// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2beta1/intent.proto

package dialogflow

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf3 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf4 "github.com/golang/protobuf/ptypes/struct"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Represents the options for views of an intent.
// An intent can be a sizable object. Therefore, we provide a resource view that
// does not return training phrases in the response by default.
type IntentView int32

const (
	// Training phrases field is not populated in the response.
	IntentView_INTENT_VIEW_UNSPECIFIED IntentView = 0
	// All fields are populated.
	IntentView_INTENT_VIEW_FULL IntentView = 1
)

var IntentView_name = map[int32]string{
	0: "INTENT_VIEW_UNSPECIFIED",
	1: "INTENT_VIEW_FULL",
}
var IntentView_value = map[string]int32{
	"INTENT_VIEW_UNSPECIFIED": 0,
	"INTENT_VIEW_FULL":        1,
}

func (x IntentView) String() string {
	return proto.EnumName(IntentView_name, int32(x))
}
func (IntentView) EnumDescriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

// Represents the different states that webhooks can be in.
type Intent_WebhookState int32

const (
	// Webhook is disabled in the agent and in the intent.
	Intent_WEBHOOK_STATE_UNSPECIFIED Intent_WebhookState = 0
	// Webhook is enabled in the agent and in the intent.
	Intent_WEBHOOK_STATE_ENABLED Intent_WebhookState = 1
	// Webhook is enabled in the agent and in the intent. Also, each slot
	// filling prompt is forwarded to the webhook.
	Intent_WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING Intent_WebhookState = 2
)

var Intent_WebhookState_name = map[int32]string{
	0: "WEBHOOK_STATE_UNSPECIFIED",
	1: "WEBHOOK_STATE_ENABLED",
	2: "WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING",
}
var Intent_WebhookState_value = map[string]int32{
	"WEBHOOK_STATE_UNSPECIFIED":              0,
	"WEBHOOK_STATE_ENABLED":                  1,
	"WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING": 2,
}

func (x Intent_WebhookState) String() string {
	return proto.EnumName(Intent_WebhookState_name, int32(x))
}
func (Intent_WebhookState) EnumDescriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 0} }

// Represents different types of training phrases.
type Intent_TrainingPhrase_Type int32

const (
	// Not specified. This value should never be used.
	Intent_TrainingPhrase_TYPE_UNSPECIFIED Intent_TrainingPhrase_Type = 0
	// Examples do not contain @-prefixed entity type names, but example parts
	// can be annotated with entity types.
	Intent_TrainingPhrase_EXAMPLE Intent_TrainingPhrase_Type = 1
	// Templates are not annotated with entity types, but they can contain
	// @-prefixed entity type names as substrings.
	Intent_TrainingPhrase_TEMPLATE Intent_TrainingPhrase_Type = 2
)

var Intent_TrainingPhrase_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "EXAMPLE",
	2: "TEMPLATE",
}
var Intent_TrainingPhrase_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"EXAMPLE":          1,
	"TEMPLATE":         2,
}

func (x Intent_TrainingPhrase_Type) String() string {
	return proto.EnumName(Intent_TrainingPhrase_Type_name, int32(x))
}
func (Intent_TrainingPhrase_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 0, 0}
}

// Represents different platforms that a rich message can be intended for.
type Intent_Message_Platform int32

const (
	// Not specified.
	Intent_Message_PLATFORM_UNSPECIFIED Intent_Message_Platform = 0
	// Facebook.
	Intent_Message_FACEBOOK Intent_Message_Platform = 1
	// Slack.
	Intent_Message_SLACK Intent_Message_Platform = 2
	// Telegram.
	Intent_Message_TELEGRAM Intent_Message_Platform = 3
	// Kik.
	Intent_Message_KIK Intent_Message_Platform = 4
	// Skype.
	Intent_Message_SKYPE Intent_Message_Platform = 5
	// Line.
	Intent_Message_LINE Intent_Message_Platform = 6
	// Viber.
	Intent_Message_VIBER Intent_Message_Platform = 7
	// Actions on Google.
	// When using Actions on Google, you can choose one of the specific
	// Intent.Message types that mention support for Actions on Google,
	// or you can use the advanced Intent.Message.payload field.
	// The payload field provides access to AoG features not available in the
	// specific message types.
	// If using the Intent.Message.payload field, it should have a structure
	// similar to the JSON message shown here. For more information, see
	// [Actions on Google Webhook
	// Format](https://developers.google.com/actions/dialogflow/webhook)
	// <pre>{
	//   "expectUserResponse": true,
	//   "isSsml": false,
	//   "noInputPrompts": [],
	//   "richResponse": {
	//     "items": [
	//       {
	//         "simpleResponse": {
	//           "displayText": "hi",
	//           "textToSpeech": "hello"
	//         }
	//       }
	//     ],
	//     "suggestions": [
	//       {
	//         "title": "Say this"
	//       },
	//       {
	//         "title": "or this"
	//       }
	//     ]
	//   },
	//   "systemIntent": {
	//     "data": {
	//       "@type": "type.googleapis.com/google.actions.v2.OptionValueSpec",
	//       "listSelect": {
	//         "items": [
	//           {
	//             "optionInfo": {
	//               "key": "key1",
	//               "synonyms": [
	//                 "key one"
	//               ]
	//             },
	//             "title": "must not be empty, but unique"
	//           },
	//           {
	//             "optionInfo": {
	//               "key": "key2",
	//               "synonyms": [
	//                 "key two"
	//               ]
	//             },
	//             "title": "must not be empty, but unique"
	//           }
	//         ]
	//       }
	//     },
	//     "intent": "actions.intent.OPTION"
	//   }
	// }</pre>
	Intent_Message_ACTIONS_ON_GOOGLE Intent_Message_Platform = 8
)

var Intent_Message_Platform_name = map[int32]string{
	0: "PLATFORM_UNSPECIFIED",
	1: "FACEBOOK",
	2: "SLACK",
	3: "TELEGRAM",
	4: "KIK",
	5: "SKYPE",
	6: "LINE",
	7: "VIBER",
	8: "ACTIONS_ON_GOOGLE",
}
var Intent_Message_Platform_value = map[string]int32{
	"PLATFORM_UNSPECIFIED": 0,
	"FACEBOOK":             1,
	"SLACK":                2,
	"TELEGRAM":             3,
	"KIK":                  4,
	"SKYPE":                5,
	"LINE":                 6,
	"VIBER":                7,
	"ACTIONS_ON_GOOGLE":    8,
}

func (x Intent_Message_Platform) String() string {
	return proto.EnumName(Intent_Message_Platform_name, int32(x))
}
func (Intent_Message_Platform) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 2, 0}
}

// Represents an intent.
// Intents convert a number of user expressions or patterns into an action. An
// action is an extraction of a user command or sentence semantics.
type Intent struct {
	// Required for all methods except `create` (`create` populates the name
	// automatically.
	// The unique identifier of this intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Required. The name of this intent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// Required. Indicates whether webhooks are enabled for the intent.
	WebhookState Intent_WebhookState `protobuf:"varint,6,opt,name=webhook_state,json=webhookState,enum=google.cloud.dialogflow.v2beta1.Intent_WebhookState" json:"webhook_state,omitempty"`
	// Optional. The priority of this intent. Higher numbers represent higher
	// priorities. Zero or negative numbers mean that the intent is disabled.
	Priority int32 `protobuf:"varint,3,opt,name=priority" json:"priority,omitempty"`
	// Optional. Indicates whether this is a fallback intent.
	IsFallback bool `protobuf:"varint,4,opt,name=is_fallback,json=isFallback" json:"is_fallback,omitempty"`
	// Optional. Indicates whether Machine Learning is enabled for the intent.
	// Note: If `ml_enabled` setting is set to false, then this intent is not
	// taken into account during inference in `ML ONLY` match mode. Also,
	// auto-markup in the UI is turned off.
	// DEPRECATED! Please use `ml_disabled` field instead.
	// NOTE: If neither `ml_enabled` nor `ml_disabled` field is set, then the
	// default value is determined as follows:
	// - Before April 15th, 2018 the default is:
	//   ml_enabled = false / ml_disabled = true.
	// - After April 15th, 2018 the default is:
	//   ml_enabled = true / ml_disabled = false.
	MlEnabled bool `protobuf:"varint,5,opt,name=ml_enabled,json=mlEnabled" json:"ml_enabled,omitempty"`
	// Optional. Indicates whether Machine Learning is disabled for the intent.
	// Note: If `ml_disabled` setting is set to true, then this intent is not
	// taken into account during inference in `ML ONLY` match mode. Also,
	// auto-markup in the UI is turned off.
	MlDisabled bool `protobuf:"varint,19,opt,name=ml_disabled,json=mlDisabled" json:"ml_disabled,omitempty"`
	// Optional. The list of context names required for this intent to be
	// triggered.
	// Format: `projects/<Project ID>/agent/sessions/-/contexts/<Context ID>`.
	InputContextNames []string `protobuf:"bytes,7,rep,name=input_context_names,json=inputContextNames" json:"input_context_names,omitempty"`
	// Optional. The collection of event names that trigger the intent.
	// If the collection of input contexts is not empty, all of the contexts must
	// be present in the active user session for an event to trigger this intent.
	Events []string `protobuf:"bytes,8,rep,name=events" json:"events,omitempty"`
	// Optional. The collection of examples/templates that the agent is
	// trained on.
	TrainingPhrases []*Intent_TrainingPhrase `protobuf:"bytes,9,rep,name=training_phrases,json=trainingPhrases" json:"training_phrases,omitempty"`
	// Optional. The name of the action associated with the intent.
	Action string `protobuf:"bytes,10,opt,name=action" json:"action,omitempty"`
	// Optional. The collection of contexts that are activated when the intent
	// is matched. Context messages in this collection should not set the
	// parameters field. Setting the `lifespan_count` to 0 will reset the context
	// when the intent is matched.
	// Format: `projects/<Project ID>/agent/sessions/-/contexts/<Context ID>`.
	OutputContexts []*Context `protobuf:"bytes,11,rep,name=output_contexts,json=outputContexts" json:"output_contexts,omitempty"`
	// Optional. Indicates whether to delete all contexts in the current
	// session when this intent is matched.
	ResetContexts bool `protobuf:"varint,12,opt,name=reset_contexts,json=resetContexts" json:"reset_contexts,omitempty"`
	// Optional. The collection of parameters associated with the intent.
	Parameters []*Intent_Parameter `protobuf:"bytes,13,rep,name=parameters" json:"parameters,omitempty"`
	// Optional. The collection of rich messages corresponding to the
	// `Response` field in the Dialogflow console.
	Messages []*Intent_Message `protobuf:"bytes,14,rep,name=messages" json:"messages,omitempty"`
	// Optional. The list of platforms for which the first response will be
	// taken from among the messages assigned to the DEFAULT_PLATFORM.
	DefaultResponsePlatforms []Intent_Message_Platform `protobuf:"varint,15,rep,packed,name=default_response_platforms,json=defaultResponsePlatforms,enum=google.cloud.dialogflow.v2beta1.Intent_Message_Platform" json:"default_response_platforms,omitempty"`
	// The unique identifier of the root intent in the chain of followup intents.
	// It identifies the correct followup intents chain for this intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	RootFollowupIntentName string `protobuf:"bytes,16,opt,name=root_followup_intent_name,json=rootFollowupIntentName" json:"root_followup_intent_name,omitempty"`
	// The unique identifier of the parent intent in the chain of followup
	// intents.
	// It identifies the parent followup intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	ParentFollowupIntentName string `protobuf:"bytes,17,opt,name=parent_followup_intent_name,json=parentFollowupIntentName" json:"parent_followup_intent_name,omitempty"`
	// Optional. Collection of information about all followup intents that have
	// name of this intent as a root_name.
	FollowupIntentInfo []*Intent_FollowupIntentInfo `protobuf:"bytes,18,rep,name=followup_intent_info,json=followupIntentInfo" json:"followup_intent_info,omitempty"`
}

func (m *Intent) Reset()                    { *m = Intent{} }
func (m *Intent) String() string            { return proto.CompactTextString(m) }
func (*Intent) ProtoMessage()               {}
func (*Intent) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *Intent) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Intent) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Intent) GetWebhookState() Intent_WebhookState {
	if m != nil {
		return m.WebhookState
	}
	return Intent_WEBHOOK_STATE_UNSPECIFIED
}

func (m *Intent) GetPriority() int32 {
	if m != nil {
		return m.Priority
	}
	return 0
}

func (m *Intent) GetIsFallback() bool {
	if m != nil {
		return m.IsFallback
	}
	return false
}

func (m *Intent) GetMlEnabled() bool {
	if m != nil {
		return m.MlEnabled
	}
	return false
}

func (m *Intent) GetMlDisabled() bool {
	if m != nil {
		return m.MlDisabled
	}
	return false
}

func (m *Intent) GetInputContextNames() []string {
	if m != nil {
		return m.InputContextNames
	}
	return nil
}

func (m *Intent) GetEvents() []string {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *Intent) GetTrainingPhrases() []*Intent_TrainingPhrase {
	if m != nil {
		return m.TrainingPhrases
	}
	return nil
}

func (m *Intent) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *Intent) GetOutputContexts() []*Context {
	if m != nil {
		return m.OutputContexts
	}
	return nil
}

func (m *Intent) GetResetContexts() bool {
	if m != nil {
		return m.ResetContexts
	}
	return false
}

func (m *Intent) GetParameters() []*Intent_Parameter {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *Intent) GetMessages() []*Intent_Message {
	if m != nil {
		return m.Messages
	}
	return nil
}

func (m *Intent) GetDefaultResponsePlatforms() []Intent_Message_Platform {
	if m != nil {
		return m.DefaultResponsePlatforms
	}
	return nil
}

func (m *Intent) GetRootFollowupIntentName() string {
	if m != nil {
		return m.RootFollowupIntentName
	}
	return ""
}

func (m *Intent) GetParentFollowupIntentName() string {
	if m != nil {
		return m.ParentFollowupIntentName
	}
	return ""
}

func (m *Intent) GetFollowupIntentInfo() []*Intent_FollowupIntentInfo {
	if m != nil {
		return m.FollowupIntentInfo
	}
	return nil
}

// Represents an example or template that the agent is trained on.
type Intent_TrainingPhrase struct {
	// Required. The unique identifier of this training phrase.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Required. The type of the training phrase.
	Type Intent_TrainingPhrase_Type `protobuf:"varint,2,opt,name=type,enum=google.cloud.dialogflow.v2beta1.Intent_TrainingPhrase_Type" json:"type,omitempty"`
	// Required. The collection of training phrase parts (can be annotated).
	// Fields: `entity_type`, `alias` and `user_defined` should be populated
	// only for the annotated parts of the training phrase.
	Parts []*Intent_TrainingPhrase_Part `protobuf:"bytes,3,rep,name=parts" json:"parts,omitempty"`
	// Optional. Indicates how many times this example or template was added to
	// the intent. Each time a developer adds an existing sample by editing an
	// intent or training, this counter is increased.
	TimesAddedCount int32 `protobuf:"varint,4,opt,name=times_added_count,json=timesAddedCount" json:"times_added_count,omitempty"`
}

func (m *Intent_TrainingPhrase) Reset()                    { *m = Intent_TrainingPhrase{} }
func (m *Intent_TrainingPhrase) String() string            { return proto.CompactTextString(m) }
func (*Intent_TrainingPhrase) ProtoMessage()               {}
func (*Intent_TrainingPhrase) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 0} }

func (m *Intent_TrainingPhrase) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Intent_TrainingPhrase) GetType() Intent_TrainingPhrase_Type {
	if m != nil {
		return m.Type
	}
	return Intent_TrainingPhrase_TYPE_UNSPECIFIED
}

func (m *Intent_TrainingPhrase) GetParts() []*Intent_TrainingPhrase_Part {
	if m != nil {
		return m.Parts
	}
	return nil
}

func (m *Intent_TrainingPhrase) GetTimesAddedCount() int32 {
	if m != nil {
		return m.TimesAddedCount
	}
	return 0
}

// Represents a part of a training phrase.
type Intent_TrainingPhrase_Part struct {
	// Required. The text corresponding to the example or template,
	// if there are no annotations. For
	// annotated examples, it is the text for one of the example's parts.
	Text string `protobuf:"bytes,1,opt,name=text" json:"text,omitempty"`
	// Optional. The entity type name prefixed with `@`. This field is
	// required for the annotated part of the text and applies only to
	// examples.
	EntityType string `protobuf:"bytes,2,opt,name=entity_type,json=entityType" json:"entity_type,omitempty"`
	// Optional. The parameter name for the value extracted from the
	// annotated part of the example.
	Alias string `protobuf:"bytes,3,opt,name=alias" json:"alias,omitempty"`
	// Optional. Indicates whether the text was manually annotated by the
	// developer.
	UserDefined bool `protobuf:"varint,4,opt,name=user_defined,json=userDefined" json:"user_defined,omitempty"`
}

func (m *Intent_TrainingPhrase_Part) Reset()         { *m = Intent_TrainingPhrase_Part{} }
func (m *Intent_TrainingPhrase_Part) String() string { return proto.CompactTextString(m) }
func (*Intent_TrainingPhrase_Part) ProtoMessage()    {}
func (*Intent_TrainingPhrase_Part) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 0, 0}
}

func (m *Intent_TrainingPhrase_Part) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *Intent_TrainingPhrase_Part) GetEntityType() string {
	if m != nil {
		return m.EntityType
	}
	return ""
}

func (m *Intent_TrainingPhrase_Part) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

func (m *Intent_TrainingPhrase_Part) GetUserDefined() bool {
	if m != nil {
		return m.UserDefined
	}
	return false
}

// Represents intent parameters.
type Intent_Parameter struct {
	// The unique identifier of this parameter.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Required. The name of the parameter.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// Optional. The definition of the parameter value. It can be:
	// - a constant string,
	// - a parameter value defined as `$parameter_name`,
	// - an original parameter value defined as `$parameter_name.original`,
	// - a parameter value from some context defined as
	//   `#context_name.parameter_name`.
	Value string `protobuf:"bytes,3,opt,name=value" json:"value,omitempty"`
	// Optional. The default value to use when the `value` yields an empty
	// result.
	// Default values can be extracted from contexts by using the following
	// syntax: `#context_name.parameter_name`.
	DefaultValue string `protobuf:"bytes,4,opt,name=default_value,json=defaultValue" json:"default_value,omitempty"`
	// Optional. The name of the entity type, prefixed with `@`, that
	// describes values of the parameter. If the parameter is
	// required, this must be provided.
	EntityTypeDisplayName string `protobuf:"bytes,5,opt,name=entity_type_display_name,json=entityTypeDisplayName" json:"entity_type_display_name,omitempty"`
	// Optional. Indicates whether the parameter is required. That is,
	// whether the intent cannot be completed without collecting the parameter
	// value.
	Mandatory bool `protobuf:"varint,6,opt,name=mandatory" json:"mandatory,omitempty"`
	// Optional. The collection of prompts that the agent can present to the
	// user in order to collect value for the parameter.
	Prompts []string `protobuf:"bytes,7,rep,name=prompts" json:"prompts,omitempty"`
	// Optional. Indicates whether the parameter represents a list of values.
	IsList bool `protobuf:"varint,8,opt,name=is_list,json=isList" json:"is_list,omitempty"`
}

func (m *Intent_Parameter) Reset()                    { *m = Intent_Parameter{} }
func (m *Intent_Parameter) String() string            { return proto.CompactTextString(m) }
func (*Intent_Parameter) ProtoMessage()               {}
func (*Intent_Parameter) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 1} }

func (m *Intent_Parameter) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Intent_Parameter) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Intent_Parameter) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *Intent_Parameter) GetDefaultValue() string {
	if m != nil {
		return m.DefaultValue
	}
	return ""
}

func (m *Intent_Parameter) GetEntityTypeDisplayName() string {
	if m != nil {
		return m.EntityTypeDisplayName
	}
	return ""
}

func (m *Intent_Parameter) GetMandatory() bool {
	if m != nil {
		return m.Mandatory
	}
	return false
}

func (m *Intent_Parameter) GetPrompts() []string {
	if m != nil {
		return m.Prompts
	}
	return nil
}

func (m *Intent_Parameter) GetIsList() bool {
	if m != nil {
		return m.IsList
	}
	return false
}

// Corresponds to the `Response` field in the Dialogflow console.
type Intent_Message struct {
	// Required. The rich response message.
	//
	// Types that are valid to be assigned to Message:
	//	*Intent_Message_Text_
	//	*Intent_Message_Image_
	//	*Intent_Message_QuickReplies_
	//	*Intent_Message_Card_
	//	*Intent_Message_Payload
	//	*Intent_Message_SimpleResponses_
	//	*Intent_Message_BasicCard_
	//	*Intent_Message_Suggestions_
	//	*Intent_Message_LinkOutSuggestion_
	//	*Intent_Message_ListSelect_
	//	*Intent_Message_CarouselSelect_
	Message isIntent_Message_Message `protobuf_oneof:"message"`
	// Optional. The platform that this message is intended for.
	Platform Intent_Message_Platform `protobuf:"varint,6,opt,name=platform,enum=google.cloud.dialogflow.v2beta1.Intent_Message_Platform" json:"platform,omitempty"`
}

func (m *Intent_Message) Reset()                    { *m = Intent_Message{} }
func (m *Intent_Message) String() string            { return proto.CompactTextString(m) }
func (*Intent_Message) ProtoMessage()               {}
func (*Intent_Message) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 2} }

type isIntent_Message_Message interface {
	isIntent_Message_Message()
}

type Intent_Message_Text_ struct {
	Text *Intent_Message_Text `protobuf:"bytes,1,opt,name=text,oneof"`
}
type Intent_Message_Image_ struct {
	Image *Intent_Message_Image `protobuf:"bytes,2,opt,name=image,oneof"`
}
type Intent_Message_QuickReplies_ struct {
	QuickReplies *Intent_Message_QuickReplies `protobuf:"bytes,3,opt,name=quick_replies,json=quickReplies,oneof"`
}
type Intent_Message_Card_ struct {
	Card *Intent_Message_Card `protobuf:"bytes,4,opt,name=card,oneof"`
}
type Intent_Message_Payload struct {
	Payload *google_protobuf4.Struct `protobuf:"bytes,5,opt,name=payload,oneof"`
}
type Intent_Message_SimpleResponses_ struct {
	SimpleResponses *Intent_Message_SimpleResponses `protobuf:"bytes,7,opt,name=simple_responses,json=simpleResponses,oneof"`
}
type Intent_Message_BasicCard_ struct {
	BasicCard *Intent_Message_BasicCard `protobuf:"bytes,8,opt,name=basic_card,json=basicCard,oneof"`
}
type Intent_Message_Suggestions_ struct {
	Suggestions *Intent_Message_Suggestions `protobuf:"bytes,9,opt,name=suggestions,oneof"`
}
type Intent_Message_LinkOutSuggestion_ struct {
	LinkOutSuggestion *Intent_Message_LinkOutSuggestion `protobuf:"bytes,10,opt,name=link_out_suggestion,json=linkOutSuggestion,oneof"`
}
type Intent_Message_ListSelect_ struct {
	ListSelect *Intent_Message_ListSelect `protobuf:"bytes,11,opt,name=list_select,json=listSelect,oneof"`
}
type Intent_Message_CarouselSelect_ struct {
	CarouselSelect *Intent_Message_CarouselSelect `protobuf:"bytes,12,opt,name=carousel_select,json=carouselSelect,oneof"`
}

func (*Intent_Message_Text_) isIntent_Message_Message()              {}
func (*Intent_Message_Image_) isIntent_Message_Message()             {}
func (*Intent_Message_QuickReplies_) isIntent_Message_Message()      {}
func (*Intent_Message_Card_) isIntent_Message_Message()              {}
func (*Intent_Message_Payload) isIntent_Message_Message()            {}
func (*Intent_Message_SimpleResponses_) isIntent_Message_Message()   {}
func (*Intent_Message_BasicCard_) isIntent_Message_Message()         {}
func (*Intent_Message_Suggestions_) isIntent_Message_Message()       {}
func (*Intent_Message_LinkOutSuggestion_) isIntent_Message_Message() {}
func (*Intent_Message_ListSelect_) isIntent_Message_Message()        {}
func (*Intent_Message_CarouselSelect_) isIntent_Message_Message()    {}

func (m *Intent_Message) GetMessage() isIntent_Message_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *Intent_Message) GetText() *Intent_Message_Text {
	if x, ok := m.GetMessage().(*Intent_Message_Text_); ok {
		return x.Text
	}
	return nil
}

func (m *Intent_Message) GetImage() *Intent_Message_Image {
	if x, ok := m.GetMessage().(*Intent_Message_Image_); ok {
		return x.Image
	}
	return nil
}

func (m *Intent_Message) GetQuickReplies() *Intent_Message_QuickReplies {
	if x, ok := m.GetMessage().(*Intent_Message_QuickReplies_); ok {
		return x.QuickReplies
	}
	return nil
}

func (m *Intent_Message) GetCard() *Intent_Message_Card {
	if x, ok := m.GetMessage().(*Intent_Message_Card_); ok {
		return x.Card
	}
	return nil
}

func (m *Intent_Message) GetPayload() *google_protobuf4.Struct {
	if x, ok := m.GetMessage().(*Intent_Message_Payload); ok {
		return x.Payload
	}
	return nil
}

func (m *Intent_Message) GetSimpleResponses() *Intent_Message_SimpleResponses {
	if x, ok := m.GetMessage().(*Intent_Message_SimpleResponses_); ok {
		return x.SimpleResponses
	}
	return nil
}

func (m *Intent_Message) GetBasicCard() *Intent_Message_BasicCard {
	if x, ok := m.GetMessage().(*Intent_Message_BasicCard_); ok {
		return x.BasicCard
	}
	return nil
}

func (m *Intent_Message) GetSuggestions() *Intent_Message_Suggestions {
	if x, ok := m.GetMessage().(*Intent_Message_Suggestions_); ok {
		return x.Suggestions
	}
	return nil
}

func (m *Intent_Message) GetLinkOutSuggestion() *Intent_Message_LinkOutSuggestion {
	if x, ok := m.GetMessage().(*Intent_Message_LinkOutSuggestion_); ok {
		return x.LinkOutSuggestion
	}
	return nil
}

func (m *Intent_Message) GetListSelect() *Intent_Message_ListSelect {
	if x, ok := m.GetMessage().(*Intent_Message_ListSelect_); ok {
		return x.ListSelect
	}
	return nil
}

func (m *Intent_Message) GetCarouselSelect() *Intent_Message_CarouselSelect {
	if x, ok := m.GetMessage().(*Intent_Message_CarouselSelect_); ok {
		return x.CarouselSelect
	}
	return nil
}

func (m *Intent_Message) GetPlatform() Intent_Message_Platform {
	if m != nil {
		return m.Platform
	}
	return Intent_Message_PLATFORM_UNSPECIFIED
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Intent_Message) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Intent_Message_OneofMarshaler, _Intent_Message_OneofUnmarshaler, _Intent_Message_OneofSizer, []interface{}{
		(*Intent_Message_Text_)(nil),
		(*Intent_Message_Image_)(nil),
		(*Intent_Message_QuickReplies_)(nil),
		(*Intent_Message_Card_)(nil),
		(*Intent_Message_Payload)(nil),
		(*Intent_Message_SimpleResponses_)(nil),
		(*Intent_Message_BasicCard_)(nil),
		(*Intent_Message_Suggestions_)(nil),
		(*Intent_Message_LinkOutSuggestion_)(nil),
		(*Intent_Message_ListSelect_)(nil),
		(*Intent_Message_CarouselSelect_)(nil),
	}
}

func _Intent_Message_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Intent_Message)
	// message
	switch x := m.Message.(type) {
	case *Intent_Message_Text_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Text); err != nil {
			return err
		}
	case *Intent_Message_Image_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Image); err != nil {
			return err
		}
	case *Intent_Message_QuickReplies_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QuickReplies); err != nil {
			return err
		}
	case *Intent_Message_Card_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Card); err != nil {
			return err
		}
	case *Intent_Message_Payload:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Payload); err != nil {
			return err
		}
	case *Intent_Message_SimpleResponses_:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SimpleResponses); err != nil {
			return err
		}
	case *Intent_Message_BasicCard_:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BasicCard); err != nil {
			return err
		}
	case *Intent_Message_Suggestions_:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Suggestions); err != nil {
			return err
		}
	case *Intent_Message_LinkOutSuggestion_:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LinkOutSuggestion); err != nil {
			return err
		}
	case *Intent_Message_ListSelect_:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ListSelect); err != nil {
			return err
		}
	case *Intent_Message_CarouselSelect_:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CarouselSelect); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Intent_Message.Message has unexpected type %T", x)
	}
	return nil
}

func _Intent_Message_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Intent_Message)
	switch tag {
	case 1: // message.text
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_Text)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_Text_{msg}
		return true, err
	case 2: // message.image
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_Image)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_Image_{msg}
		return true, err
	case 3: // message.quick_replies
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_QuickReplies)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_QuickReplies_{msg}
		return true, err
	case 4: // message.card
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_Card)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_Card_{msg}
		return true, err
	case 5: // message.payload
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf4.Struct)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_Payload{msg}
		return true, err
	case 7: // message.simple_responses
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_SimpleResponses)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_SimpleResponses_{msg}
		return true, err
	case 8: // message.basic_card
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_BasicCard)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_BasicCard_{msg}
		return true, err
	case 9: // message.suggestions
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_Suggestions)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_Suggestions_{msg}
		return true, err
	case 10: // message.link_out_suggestion
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_LinkOutSuggestion)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_LinkOutSuggestion_{msg}
		return true, err
	case 11: // message.list_select
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_ListSelect)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_ListSelect_{msg}
		return true, err
	case 12: // message.carousel_select
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_CarouselSelect)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_CarouselSelect_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Intent_Message_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Intent_Message)
	// message
	switch x := m.Message.(type) {
	case *Intent_Message_Text_:
		s := proto.Size(x.Text)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_Image_:
		s := proto.Size(x.Image)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_QuickReplies_:
		s := proto.Size(x.QuickReplies)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_Card_:
		s := proto.Size(x.Card)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_Payload:
		s := proto.Size(x.Payload)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_SimpleResponses_:
		s := proto.Size(x.SimpleResponses)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_BasicCard_:
		s := proto.Size(x.BasicCard)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_Suggestions_:
		s := proto.Size(x.Suggestions)
		n += proto.SizeVarint(9<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_LinkOutSuggestion_:
		s := proto.Size(x.LinkOutSuggestion)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_ListSelect_:
		s := proto.Size(x.ListSelect)
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_CarouselSelect_:
		s := proto.Size(x.CarouselSelect)
		n += proto.SizeVarint(12<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The text response message.
type Intent_Message_Text struct {
	// Optional. The collection of the agent's responses.
	Text []string `protobuf:"bytes,1,rep,name=text" json:"text,omitempty"`
}

func (m *Intent_Message_Text) Reset()                    { *m = Intent_Message_Text{} }
func (m *Intent_Message_Text) String() string            { return proto.CompactTextString(m) }
func (*Intent_Message_Text) ProtoMessage()               {}
func (*Intent_Message_Text) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 2, 0} }

func (m *Intent_Message_Text) GetText() []string {
	if m != nil {
		return m.Text
	}
	return nil
}

// The image response message.
type Intent_Message_Image struct {
	// Optional. The public URI to an image file.
	ImageUri string `protobuf:"bytes,1,opt,name=image_uri,json=imageUri" json:"image_uri,omitempty"`
	// Optional. A text description of the image to be used for accessibility,
	// e.g., screen readers.
	AccessibilityText string `protobuf:"bytes,2,opt,name=accessibility_text,json=accessibilityText" json:"accessibility_text,omitempty"`
}

func (m *Intent_Message_Image) Reset()                    { *m = Intent_Message_Image{} }
func (m *Intent_Message_Image) String() string            { return proto.CompactTextString(m) }
func (*Intent_Message_Image) ProtoMessage()               {}
func (*Intent_Message_Image) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 2, 1} }

func (m *Intent_Message_Image) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

func (m *Intent_Message_Image) GetAccessibilityText() string {
	if m != nil {
		return m.AccessibilityText
	}
	return ""
}

// The quick replies response message.
type Intent_Message_QuickReplies struct {
	// Optional. The title of the collection of quick replies.
	Title string `protobuf:"bytes,1,opt,name=title" json:"title,omitempty"`
	// Optional. The collection of quick replies.
	QuickReplies []string `protobuf:"bytes,2,rep,name=quick_replies,json=quickReplies" json:"quick_replies,omitempty"`
}

func (m *Intent_Message_QuickReplies) Reset()         { *m = Intent_Message_QuickReplies{} }
func (m *Intent_Message_QuickReplies) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_QuickReplies) ProtoMessage()    {}
func (*Intent_Message_QuickReplies) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 2, 2}
}

func (m *Intent_Message_QuickReplies) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_QuickReplies) GetQuickReplies() []string {
	if m != nil {
		return m.QuickReplies
	}
	return nil
}

// The card response message.
type Intent_Message_Card struct {
	// Optional. The title of the card.
	Title string `protobuf:"bytes,1,opt,name=title" json:"title,omitempty"`
	// Optional. The subtitle of the card.
	Subtitle string `protobuf:"bytes,2,opt,name=subtitle" json:"subtitle,omitempty"`
	// Optional. The public URI to an image file for the card.
	ImageUri string `protobuf:"bytes,3,opt,name=image_uri,json=imageUri" json:"image_uri,omitempty"`
	// Optional. The collection of card buttons.
	Buttons []*Intent_Message_Card_Button `protobuf:"bytes,4,rep,name=buttons" json:"buttons,omitempty"`
}

func (m *Intent_Message_Card) Reset()                    { *m = Intent_Message_Card{} }
func (m *Intent_Message_Card) String() string            { return proto.CompactTextString(m) }
func (*Intent_Message_Card) ProtoMessage()               {}
func (*Intent_Message_Card) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 2, 3} }

func (m *Intent_Message_Card) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_Card) GetSubtitle() string {
	if m != nil {
		return m.Subtitle
	}
	return ""
}

func (m *Intent_Message_Card) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

func (m *Intent_Message_Card) GetButtons() []*Intent_Message_Card_Button {
	if m != nil {
		return m.Buttons
	}
	return nil
}

// Optional. Contains information about a button.
type Intent_Message_Card_Button struct {
	// Optional. The text to show on the button.
	Text string `protobuf:"bytes,1,opt,name=text" json:"text,omitempty"`
	// Optional. The text to send back to the Dialogflow API or a URI to
	// open.
	Postback string `protobuf:"bytes,2,opt,name=postback" json:"postback,omitempty"`
}

func (m *Intent_Message_Card_Button) Reset()         { *m = Intent_Message_Card_Button{} }
func (m *Intent_Message_Card_Button) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_Card_Button) ProtoMessage()    {}
func (*Intent_Message_Card_Button) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 2, 3, 0}
}

func (m *Intent_Message_Card_Button) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *Intent_Message_Card_Button) GetPostback() string {
	if m != nil {
		return m.Postback
	}
	return ""
}

// The simple response message containing speech or text.
type Intent_Message_SimpleResponse struct {
	// One of text_to_speech or ssml must be provided. The plain text of the
	// speech output. Mutually exclusive with ssml.
	TextToSpeech string `protobuf:"bytes,1,opt,name=text_to_speech,json=textToSpeech" json:"text_to_speech,omitempty"`
	// One of text_to_speech or ssml must be provided. Structured spoken
	// response to the user in the SSML format. Mutually exclusive with
	// text_to_speech.
	Ssml string `protobuf:"bytes,2,opt,name=ssml" json:"ssml,omitempty"`
	// Optional. The text to display.
	DisplayText string `protobuf:"bytes,3,opt,name=display_text,json=displayText" json:"display_text,omitempty"`
}

func (m *Intent_Message_SimpleResponse) Reset()         { *m = Intent_Message_SimpleResponse{} }
func (m *Intent_Message_SimpleResponse) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_SimpleResponse) ProtoMessage()    {}
func (*Intent_Message_SimpleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 2, 4}
}

func (m *Intent_Message_SimpleResponse) GetTextToSpeech() string {
	if m != nil {
		return m.TextToSpeech
	}
	return ""
}

func (m *Intent_Message_SimpleResponse) GetSsml() string {
	if m != nil {
		return m.Ssml
	}
	return ""
}

func (m *Intent_Message_SimpleResponse) GetDisplayText() string {
	if m != nil {
		return m.DisplayText
	}
	return ""
}

// The collection of simple response candidates.
// This message in `QueryResult.fulfillment_messages` and
// `WebhookResponse.fulfillment_messages` should contain only one
// `SimpleResponse`.
type Intent_Message_SimpleResponses struct {
	// Required. The list of simple responses.
	SimpleResponses []*Intent_Message_SimpleResponse `protobuf:"bytes,1,rep,name=simple_responses,json=simpleResponses" json:"simple_responses,omitempty"`
}

func (m *Intent_Message_SimpleResponses) Reset()         { *m = Intent_Message_SimpleResponses{} }
func (m *Intent_Message_SimpleResponses) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_SimpleResponses) ProtoMessage()    {}
func (*Intent_Message_SimpleResponses) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 2, 5}
}

func (m *Intent_Message_SimpleResponses) GetSimpleResponses() []*Intent_Message_SimpleResponse {
	if m != nil {
		return m.SimpleResponses
	}
	return nil
}

// The basic card message. Useful for displaying information.
type Intent_Message_BasicCard struct {
	// Optional. The title of the card.
	Title string `protobuf:"bytes,1,opt,name=title" json:"title,omitempty"`
	// Optional. The subtitle of the card.
	Subtitle string `protobuf:"bytes,2,opt,name=subtitle" json:"subtitle,omitempty"`
	// Required, unless image is present. The body text of the card.
	FormattedText string `protobuf:"bytes,3,opt,name=formatted_text,json=formattedText" json:"formatted_text,omitempty"`
	// Optional. The image for the card.
	Image *Intent_Message_Image `protobuf:"bytes,4,opt,name=image" json:"image,omitempty"`
	// Optional. The collection of card buttons.
	Buttons []*Intent_Message_BasicCard_Button `protobuf:"bytes,5,rep,name=buttons" json:"buttons,omitempty"`
}

func (m *Intent_Message_BasicCard) Reset()                    { *m = Intent_Message_BasicCard{} }
func (m *Intent_Message_BasicCard) String() string            { return proto.CompactTextString(m) }
func (*Intent_Message_BasicCard) ProtoMessage()               {}
func (*Intent_Message_BasicCard) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 2, 6} }

func (m *Intent_Message_BasicCard) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_BasicCard) GetSubtitle() string {
	if m != nil {
		return m.Subtitle
	}
	return ""
}

func (m *Intent_Message_BasicCard) GetFormattedText() string {
	if m != nil {
		return m.FormattedText
	}
	return ""
}

func (m *Intent_Message_BasicCard) GetImage() *Intent_Message_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *Intent_Message_BasicCard) GetButtons() []*Intent_Message_BasicCard_Button {
	if m != nil {
		return m.Buttons
	}
	return nil
}

// The button object that appears at the bottom of a card.
type Intent_Message_BasicCard_Button struct {
	// Required. The title of the button.
	Title string `protobuf:"bytes,1,opt,name=title" json:"title,omitempty"`
	// Required. Action to take when a user taps on the button.
	OpenUriAction *Intent_Message_BasicCard_Button_OpenUriAction `protobuf:"bytes,2,opt,name=open_uri_action,json=openUriAction" json:"open_uri_action,omitempty"`
}

func (m *Intent_Message_BasicCard_Button) Reset()         { *m = Intent_Message_BasicCard_Button{} }
func (m *Intent_Message_BasicCard_Button) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_BasicCard_Button) ProtoMessage()    {}
func (*Intent_Message_BasicCard_Button) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 2, 6, 0}
}

func (m *Intent_Message_BasicCard_Button) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_BasicCard_Button) GetOpenUriAction() *Intent_Message_BasicCard_Button_OpenUriAction {
	if m != nil {
		return m.OpenUriAction
	}
	return nil
}

// Opens the given URI.
type Intent_Message_BasicCard_Button_OpenUriAction struct {
	// Required. The HTTP or HTTPS scheme URI.
	Uri string `protobuf:"bytes,1,opt,name=uri" json:"uri,omitempty"`
}

func (m *Intent_Message_BasicCard_Button_OpenUriAction) Reset() {
	*m = Intent_Message_BasicCard_Button_OpenUriAction{}
}
func (m *Intent_Message_BasicCard_Button_OpenUriAction) String() string {
	return proto.CompactTextString(m)
}
func (*Intent_Message_BasicCard_Button_OpenUriAction) ProtoMessage() {}
func (*Intent_Message_BasicCard_Button_OpenUriAction) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 2, 6, 0, 0}
}

func (m *Intent_Message_BasicCard_Button_OpenUriAction) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// The suggestion chip message that the user can tap to quickly post a reply
// to the conversation.
type Intent_Message_Suggestion struct {
	// Required. The text shown the in the suggestion chip.
	Title string `protobuf:"bytes,1,opt,name=title" json:"title,omitempty"`
}

func (m *Intent_Message_Suggestion) Reset()                    { *m = Intent_Message_Suggestion{} }
func (m *Intent_Message_Suggestion) String() string            { return proto.CompactTextString(m) }
func (*Intent_Message_Suggestion) ProtoMessage()               {}
func (*Intent_Message_Suggestion) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 2, 7} }

func (m *Intent_Message_Suggestion) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

// The collection of suggestions.
type Intent_Message_Suggestions struct {
	// Required. The list of suggested replies.
	Suggestions []*Intent_Message_Suggestion `protobuf:"bytes,1,rep,name=suggestions" json:"suggestions,omitempty"`
}

func (m *Intent_Message_Suggestions) Reset()         { *m = Intent_Message_Suggestions{} }
func (m *Intent_Message_Suggestions) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_Suggestions) ProtoMessage()    {}
func (*Intent_Message_Suggestions) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 2, 8}
}

func (m *Intent_Message_Suggestions) GetSuggestions() []*Intent_Message_Suggestion {
	if m != nil {
		return m.Suggestions
	}
	return nil
}

// The suggestion chip message that allows the user to jump out to the app
// or website associated with this agent.
type Intent_Message_LinkOutSuggestion struct {
	// Required. The name of the app or site this chip is linking to.
	DestinationName string `protobuf:"bytes,1,opt,name=destination_name,json=destinationName" json:"destination_name,omitempty"`
	// Required. The URI of the app or site to open when the user taps the
	// suggestion chip.
	Uri string `protobuf:"bytes,2,opt,name=uri" json:"uri,omitempty"`
}

func (m *Intent_Message_LinkOutSuggestion) Reset()         { *m = Intent_Message_LinkOutSuggestion{} }
func (m *Intent_Message_LinkOutSuggestion) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_LinkOutSuggestion) ProtoMessage()    {}
func (*Intent_Message_LinkOutSuggestion) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 2, 9}
}

func (m *Intent_Message_LinkOutSuggestion) GetDestinationName() string {
	if m != nil {
		return m.DestinationName
	}
	return ""
}

func (m *Intent_Message_LinkOutSuggestion) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// The card for presenting a list of options to select from.
type Intent_Message_ListSelect struct {
	// Optional. The overall title of the list.
	Title string `protobuf:"bytes,1,opt,name=title" json:"title,omitempty"`
	// Required. List items.
	Items []*Intent_Message_ListSelect_Item `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
}

func (m *Intent_Message_ListSelect) Reset()         { *m = Intent_Message_ListSelect{} }
func (m *Intent_Message_ListSelect) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_ListSelect) ProtoMessage()    {}
func (*Intent_Message_ListSelect) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 2, 10}
}

func (m *Intent_Message_ListSelect) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_ListSelect) GetItems() []*Intent_Message_ListSelect_Item {
	if m != nil {
		return m.Items
	}
	return nil
}

// An item in the list.
type Intent_Message_ListSelect_Item struct {
	// Required. Additional information about this option.
	Info *Intent_Message_SelectItemInfo `protobuf:"bytes,1,opt,name=info" json:"info,omitempty"`
	// Required. The title of the list item.
	Title string `protobuf:"bytes,2,opt,name=title" json:"title,omitempty"`
	// Optional. The main text describing the item.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// Optional. The image to display.
	Image *Intent_Message_Image `protobuf:"bytes,4,opt,name=image" json:"image,omitempty"`
}

func (m *Intent_Message_ListSelect_Item) Reset()         { *m = Intent_Message_ListSelect_Item{} }
func (m *Intent_Message_ListSelect_Item) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_ListSelect_Item) ProtoMessage()    {}
func (*Intent_Message_ListSelect_Item) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 2, 10, 0}
}

func (m *Intent_Message_ListSelect_Item) GetInfo() *Intent_Message_SelectItemInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *Intent_Message_ListSelect_Item) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_ListSelect_Item) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Intent_Message_ListSelect_Item) GetImage() *Intent_Message_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

// The card for presenting a carousel of options to select from.
type Intent_Message_CarouselSelect struct {
	// Required. Carousel items.
	Items []*Intent_Message_CarouselSelect_Item `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
}

func (m *Intent_Message_CarouselSelect) Reset()         { *m = Intent_Message_CarouselSelect{} }
func (m *Intent_Message_CarouselSelect) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_CarouselSelect) ProtoMessage()    {}
func (*Intent_Message_CarouselSelect) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 2, 11}
}

func (m *Intent_Message_CarouselSelect) GetItems() []*Intent_Message_CarouselSelect_Item {
	if m != nil {
		return m.Items
	}
	return nil
}

// An item in the carousel.
type Intent_Message_CarouselSelect_Item struct {
	// Required. Additional info about the option item.
	Info *Intent_Message_SelectItemInfo `protobuf:"bytes,1,opt,name=info" json:"info,omitempty"`
	// Required. Title of the carousel item.
	Title string `protobuf:"bytes,2,opt,name=title" json:"title,omitempty"`
	// Optional. The body text of the card.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// Optional. The image to display.
	Image *Intent_Message_Image `protobuf:"bytes,4,opt,name=image" json:"image,omitempty"`
}

func (m *Intent_Message_CarouselSelect_Item) Reset()         { *m = Intent_Message_CarouselSelect_Item{} }
func (m *Intent_Message_CarouselSelect_Item) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_CarouselSelect_Item) ProtoMessage()    {}
func (*Intent_Message_CarouselSelect_Item) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 2, 11, 0}
}

func (m *Intent_Message_CarouselSelect_Item) GetInfo() *Intent_Message_SelectItemInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *Intent_Message_CarouselSelect_Item) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_CarouselSelect_Item) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Intent_Message_CarouselSelect_Item) GetImage() *Intent_Message_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

// Additional info about the select item for when it is triggered in a
// dialog.
type Intent_Message_SelectItemInfo struct {
	// Required. A unique key that will be sent back to the agent if this
	// response is given.
	Key string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// Optional. A list of synonyms that can also be used to trigger this
	// item in dialog.
	Synonyms []string `protobuf:"bytes,2,rep,name=synonyms" json:"synonyms,omitempty"`
}

func (m *Intent_Message_SelectItemInfo) Reset()         { *m = Intent_Message_SelectItemInfo{} }
func (m *Intent_Message_SelectItemInfo) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_SelectItemInfo) ProtoMessage()    {}
func (*Intent_Message_SelectItemInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 2, 12}
}

func (m *Intent_Message_SelectItemInfo) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Intent_Message_SelectItemInfo) GetSynonyms() []string {
	if m != nil {
		return m.Synonyms
	}
	return nil
}

// Represents a single followup intent in the chain.
type Intent_FollowupIntentInfo struct {
	// The unique identifier of the followup intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	FollowupIntentName string `protobuf:"bytes,1,opt,name=followup_intent_name,json=followupIntentName" json:"followup_intent_name,omitempty"`
	// The unique identifier of the followup intent parent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	ParentFollowupIntentName string `protobuf:"bytes,2,opt,name=parent_followup_intent_name,json=parentFollowupIntentName" json:"parent_followup_intent_name,omitempty"`
}

func (m *Intent_FollowupIntentInfo) Reset()                    { *m = Intent_FollowupIntentInfo{} }
func (m *Intent_FollowupIntentInfo) String() string            { return proto.CompactTextString(m) }
func (*Intent_FollowupIntentInfo) ProtoMessage()               {}
func (*Intent_FollowupIntentInfo) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 3} }

func (m *Intent_FollowupIntentInfo) GetFollowupIntentName() string {
	if m != nil {
		return m.FollowupIntentName
	}
	return ""
}

func (m *Intent_FollowupIntentInfo) GetParentFollowupIntentName() string {
	if m != nil {
		return m.ParentFollowupIntentName
	}
	return ""
}

// The request message for [Intents.ListIntents][google.cloud.dialogflow.v2beta1.Intents.ListIntents].
type ListIntentsRequest struct {
	// Required. The agent to list all intents from.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Optional. The language to list training phrases, parameters and rich
	// messages for. If not specified, the agent's default language is used.
	// [More than a dozen
	// languages](https://dialogflow.com/docs/reference/language) are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView IntentView `protobuf:"varint,3,opt,name=intent_view,json=intentView,enum=google.cloud.dialogflow.v2beta1.IntentView" json:"intent_view,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListIntentsRequest) Reset()                    { *m = ListIntentsRequest{} }
func (m *ListIntentsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListIntentsRequest) ProtoMessage()               {}
func (*ListIntentsRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{1} }

func (m *ListIntentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListIntentsRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *ListIntentsRequest) GetIntentView() IntentView {
	if m != nil {
		return m.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

func (m *ListIntentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListIntentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response message for [Intents.ListIntents][google.cloud.dialogflow.v2beta1.Intents.ListIntents].
type ListIntentsResponse struct {
	// The list of agent intents. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Intents []*Intent `protobuf:"bytes,1,rep,name=intents" json:"intents,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListIntentsResponse) Reset()                    { *m = ListIntentsResponse{} }
func (m *ListIntentsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListIntentsResponse) ProtoMessage()               {}
func (*ListIntentsResponse) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{2} }

func (m *ListIntentsResponse) GetIntents() []*Intent {
	if m != nil {
		return m.Intents
	}
	return nil
}

func (m *ListIntentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for [Intents.GetIntent][google.cloud.dialogflow.v2beta1.Intents.GetIntent].
type GetIntentRequest struct {
	// Required. The name of the intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Optional. The language to retrieve training phrases, parameters and rich
	// messages for. If not specified, the agent's default language is used.
	// [More than a dozen
	// languages](https://dialogflow.com/docs/reference/language) are supported.
	// Note: languages must be enabled in the agent, before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView IntentView `protobuf:"varint,3,opt,name=intent_view,json=intentView,enum=google.cloud.dialogflow.v2beta1.IntentView" json:"intent_view,omitempty"`
}

func (m *GetIntentRequest) Reset()                    { *m = GetIntentRequest{} }
func (m *GetIntentRequest) String() string            { return proto.CompactTextString(m) }
func (*GetIntentRequest) ProtoMessage()               {}
func (*GetIntentRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{3} }

func (m *GetIntentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetIntentRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *GetIntentRequest) GetIntentView() IntentView {
	if m != nil {
		return m.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

// The request message for [Intents.CreateIntent][google.cloud.dialogflow.v2beta1.Intents.CreateIntent].
type CreateIntentRequest struct {
	// Required. The agent to create a intent for.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Required. The intent to create.
	Intent *Intent `protobuf:"bytes,2,opt,name=intent" json:"intent,omitempty"`
	// Optional. The language of training phrases, parameters and rich messages
	// defined in `intent`. If not specified, the agent's default language is
	// used. [More than a dozen
	// languages](https://dialogflow.com/docs/reference/language) are supported.
	// Note: languages must be enabled in the agent, before they can be used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView IntentView `protobuf:"varint,4,opt,name=intent_view,json=intentView,enum=google.cloud.dialogflow.v2beta1.IntentView" json:"intent_view,omitempty"`
}

func (m *CreateIntentRequest) Reset()                    { *m = CreateIntentRequest{} }
func (m *CreateIntentRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateIntentRequest) ProtoMessage()               {}
func (*CreateIntentRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{4} }

func (m *CreateIntentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateIntentRequest) GetIntent() *Intent {
	if m != nil {
		return m.Intent
	}
	return nil
}

func (m *CreateIntentRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *CreateIntentRequest) GetIntentView() IntentView {
	if m != nil {
		return m.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

// The request message for [Intents.UpdateIntent][google.cloud.dialogflow.v2beta1.Intents.UpdateIntent].
type UpdateIntentRequest struct {
	// Required. The intent to update.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	Intent *Intent `protobuf:"bytes,1,opt,name=intent" json:"intent,omitempty"`
	// Optional. The language of training phrases, parameters and rich messages
	// defined in `intent`. If not specified, the agent's default language is
	// used. [More than a dozen
	// languages](https://dialogflow.com/docs/reference/language) are supported.
	// Note: languages must be enabled in the agent, before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask *google_protobuf3.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView IntentView `protobuf:"varint,4,opt,name=intent_view,json=intentView,enum=google.cloud.dialogflow.v2beta1.IntentView" json:"intent_view,omitempty"`
}

func (m *UpdateIntentRequest) Reset()                    { *m = UpdateIntentRequest{} }
func (m *UpdateIntentRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateIntentRequest) ProtoMessage()               {}
func (*UpdateIntentRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{5} }

func (m *UpdateIntentRequest) GetIntent() *Intent {
	if m != nil {
		return m.Intent
	}
	return nil
}

func (m *UpdateIntentRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *UpdateIntentRequest) GetUpdateMask() *google_protobuf3.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateIntentRequest) GetIntentView() IntentView {
	if m != nil {
		return m.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

// The request message for [Intents.DeleteIntent][google.cloud.dialogflow.v2beta1.Intents.DeleteIntent].
type DeleteIntentRequest struct {
	// Required. The name of the intent to delete.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteIntentRequest) Reset()                    { *m = DeleteIntentRequest{} }
func (m *DeleteIntentRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteIntentRequest) ProtoMessage()               {}
func (*DeleteIntentRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{6} }

func (m *DeleteIntentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [Intents.BatchUpdateIntents][google.cloud.dialogflow.v2beta1.Intents.BatchUpdateIntents].
type BatchUpdateIntentsRequest struct {
	// Required. The name of the agent to update or create intents in.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Required. The source of the intent batch.
	//
	// Types that are valid to be assigned to IntentBatch:
	//	*BatchUpdateIntentsRequest_IntentBatchUri
	//	*BatchUpdateIntentsRequest_IntentBatchInline
	IntentBatch isBatchUpdateIntentsRequest_IntentBatch `protobuf_oneof:"intent_batch"`
	// Optional. The language of training phrases, parameters and rich messages
	// defined in `intents`. If not specified, the agent's default language is
	// used. [More than a dozen
	// languages](https://dialogflow.com/docs/reference/language) are supported.
	// Note: languages must be enabled in the agent, before they can be used.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask *google_protobuf3.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView IntentView `protobuf:"varint,6,opt,name=intent_view,json=intentView,enum=google.cloud.dialogflow.v2beta1.IntentView" json:"intent_view,omitempty"`
}

func (m *BatchUpdateIntentsRequest) Reset()                    { *m = BatchUpdateIntentsRequest{} }
func (m *BatchUpdateIntentsRequest) String() string            { return proto.CompactTextString(m) }
func (*BatchUpdateIntentsRequest) ProtoMessage()               {}
func (*BatchUpdateIntentsRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{7} }

type isBatchUpdateIntentsRequest_IntentBatch interface {
	isBatchUpdateIntentsRequest_IntentBatch()
}

type BatchUpdateIntentsRequest_IntentBatchUri struct {
	IntentBatchUri string `protobuf:"bytes,2,opt,name=intent_batch_uri,json=intentBatchUri,oneof"`
}
type BatchUpdateIntentsRequest_IntentBatchInline struct {
	IntentBatchInline *IntentBatch `protobuf:"bytes,3,opt,name=intent_batch_inline,json=intentBatchInline,oneof"`
}

func (*BatchUpdateIntentsRequest_IntentBatchUri) isBatchUpdateIntentsRequest_IntentBatch()    {}
func (*BatchUpdateIntentsRequest_IntentBatchInline) isBatchUpdateIntentsRequest_IntentBatch() {}

func (m *BatchUpdateIntentsRequest) GetIntentBatch() isBatchUpdateIntentsRequest_IntentBatch {
	if m != nil {
		return m.IntentBatch
	}
	return nil
}

func (m *BatchUpdateIntentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchUpdateIntentsRequest) GetIntentBatchUri() string {
	if x, ok := m.GetIntentBatch().(*BatchUpdateIntentsRequest_IntentBatchUri); ok {
		return x.IntentBatchUri
	}
	return ""
}

func (m *BatchUpdateIntentsRequest) GetIntentBatchInline() *IntentBatch {
	if x, ok := m.GetIntentBatch().(*BatchUpdateIntentsRequest_IntentBatchInline); ok {
		return x.IntentBatchInline
	}
	return nil
}

func (m *BatchUpdateIntentsRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *BatchUpdateIntentsRequest) GetUpdateMask() *google_protobuf3.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *BatchUpdateIntentsRequest) GetIntentView() IntentView {
	if m != nil {
		return m.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*BatchUpdateIntentsRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _BatchUpdateIntentsRequest_OneofMarshaler, _BatchUpdateIntentsRequest_OneofUnmarshaler, _BatchUpdateIntentsRequest_OneofSizer, []interface{}{
		(*BatchUpdateIntentsRequest_IntentBatchUri)(nil),
		(*BatchUpdateIntentsRequest_IntentBatchInline)(nil),
	}
}

func _BatchUpdateIntentsRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*BatchUpdateIntentsRequest)
	// intent_batch
	switch x := m.IntentBatch.(type) {
	case *BatchUpdateIntentsRequest_IntentBatchUri:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.IntentBatchUri)
	case *BatchUpdateIntentsRequest_IntentBatchInline:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.IntentBatchInline); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("BatchUpdateIntentsRequest.IntentBatch has unexpected type %T", x)
	}
	return nil
}

func _BatchUpdateIntentsRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*BatchUpdateIntentsRequest)
	switch tag {
	case 2: // intent_batch.intent_batch_uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.IntentBatch = &BatchUpdateIntentsRequest_IntentBatchUri{x}
		return true, err
	case 3: // intent_batch.intent_batch_inline
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(IntentBatch)
		err := b.DecodeMessage(msg)
		m.IntentBatch = &BatchUpdateIntentsRequest_IntentBatchInline{msg}
		return true, err
	default:
		return false, nil
	}
}

func _BatchUpdateIntentsRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*BatchUpdateIntentsRequest)
	// intent_batch
	switch x := m.IntentBatch.(type) {
	case *BatchUpdateIntentsRequest_IntentBatchUri:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.IntentBatchUri)))
		n += len(x.IntentBatchUri)
	case *BatchUpdateIntentsRequest_IntentBatchInline:
		s := proto.Size(x.IntentBatchInline)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response message for [Intents.BatchUpdateIntents][google.cloud.dialogflow.v2beta1.Intents.BatchUpdateIntents].
type BatchUpdateIntentsResponse struct {
	// The collection of updated or created intents.
	Intents []*Intent `protobuf:"bytes,1,rep,name=intents" json:"intents,omitempty"`
}

func (m *BatchUpdateIntentsResponse) Reset()                    { *m = BatchUpdateIntentsResponse{} }
func (m *BatchUpdateIntentsResponse) String() string            { return proto.CompactTextString(m) }
func (*BatchUpdateIntentsResponse) ProtoMessage()               {}
func (*BatchUpdateIntentsResponse) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{8} }

func (m *BatchUpdateIntentsResponse) GetIntents() []*Intent {
	if m != nil {
		return m.Intents
	}
	return nil
}

// The request message for [Intents.BatchDeleteIntents][google.cloud.dialogflow.v2beta1.Intents.BatchDeleteIntents].
type BatchDeleteIntentsRequest struct {
	// Required. The name of the agent to delete all entities types for. Format:
	// `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Required. The collection of intents to delete. Only intent `name` must be
	// filled in.
	Intents []*Intent `protobuf:"bytes,2,rep,name=intents" json:"intents,omitempty"`
}

func (m *BatchDeleteIntentsRequest) Reset()                    { *m = BatchDeleteIntentsRequest{} }
func (m *BatchDeleteIntentsRequest) String() string            { return proto.CompactTextString(m) }
func (*BatchDeleteIntentsRequest) ProtoMessage()               {}
func (*BatchDeleteIntentsRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{9} }

func (m *BatchDeleteIntentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchDeleteIntentsRequest) GetIntents() []*Intent {
	if m != nil {
		return m.Intents
	}
	return nil
}

// This message is a wrapper around a collection of intents.
type IntentBatch struct {
	// A collection of intents.
	Intents []*Intent `protobuf:"bytes,1,rep,name=intents" json:"intents,omitempty"`
}

func (m *IntentBatch) Reset()                    { *m = IntentBatch{} }
func (m *IntentBatch) String() string            { return proto.CompactTextString(m) }
func (*IntentBatch) ProtoMessage()               {}
func (*IntentBatch) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{10} }

func (m *IntentBatch) GetIntents() []*Intent {
	if m != nil {
		return m.Intents
	}
	return nil
}

func init() {
	proto.RegisterType((*Intent)(nil), "google.cloud.dialogflow.v2beta1.Intent")
	proto.RegisterType((*Intent_TrainingPhrase)(nil), "google.cloud.dialogflow.v2beta1.Intent.TrainingPhrase")
	proto.RegisterType((*Intent_TrainingPhrase_Part)(nil), "google.cloud.dialogflow.v2beta1.Intent.TrainingPhrase.Part")
	proto.RegisterType((*Intent_Parameter)(nil), "google.cloud.dialogflow.v2beta1.Intent.Parameter")
	proto.RegisterType((*Intent_Message)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message")
	proto.RegisterType((*Intent_Message_Text)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Text")
	proto.RegisterType((*Intent_Message_Image)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Image")
	proto.RegisterType((*Intent_Message_QuickReplies)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.QuickReplies")
	proto.RegisterType((*Intent_Message_Card)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Card")
	proto.RegisterType((*Intent_Message_Card_Button)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Card.Button")
	proto.RegisterType((*Intent_Message_SimpleResponse)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.SimpleResponse")
	proto.RegisterType((*Intent_Message_SimpleResponses)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.SimpleResponses")
	proto.RegisterType((*Intent_Message_BasicCard)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.BasicCard")
	proto.RegisterType((*Intent_Message_BasicCard_Button)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.BasicCard.Button")
	proto.RegisterType((*Intent_Message_BasicCard_Button_OpenUriAction)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.BasicCard.Button.OpenUriAction")
	proto.RegisterType((*Intent_Message_Suggestion)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Suggestion")
	proto.RegisterType((*Intent_Message_Suggestions)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Suggestions")
	proto.RegisterType((*Intent_Message_LinkOutSuggestion)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.LinkOutSuggestion")
	proto.RegisterType((*Intent_Message_ListSelect)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.ListSelect")
	proto.RegisterType((*Intent_Message_ListSelect_Item)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.ListSelect.Item")
	proto.RegisterType((*Intent_Message_CarouselSelect)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.CarouselSelect")
	proto.RegisterType((*Intent_Message_CarouselSelect_Item)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.CarouselSelect.Item")
	proto.RegisterType((*Intent_Message_SelectItemInfo)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.SelectItemInfo")
	proto.RegisterType((*Intent_FollowupIntentInfo)(nil), "google.cloud.dialogflow.v2beta1.Intent.FollowupIntentInfo")
	proto.RegisterType((*ListIntentsRequest)(nil), "google.cloud.dialogflow.v2beta1.ListIntentsRequest")
	proto.RegisterType((*ListIntentsResponse)(nil), "google.cloud.dialogflow.v2beta1.ListIntentsResponse")
	proto.RegisterType((*GetIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.GetIntentRequest")
	proto.RegisterType((*CreateIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.CreateIntentRequest")
	proto.RegisterType((*UpdateIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.UpdateIntentRequest")
	proto.RegisterType((*DeleteIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.DeleteIntentRequest")
	proto.RegisterType((*BatchUpdateIntentsRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest")
	proto.RegisterType((*BatchUpdateIntentsResponse)(nil), "google.cloud.dialogflow.v2beta1.BatchUpdateIntentsResponse")
	proto.RegisterType((*BatchDeleteIntentsRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchDeleteIntentsRequest")
	proto.RegisterType((*IntentBatch)(nil), "google.cloud.dialogflow.v2beta1.IntentBatch")
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.IntentView", IntentView_name, IntentView_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_WebhookState", Intent_WebhookState_name, Intent_WebhookState_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_TrainingPhrase_Type", Intent_TrainingPhrase_Type_name, Intent_TrainingPhrase_Type_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_Message_Platform", Intent_Message_Platform_name, Intent_Message_Platform_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Intents service

type IntentsClient interface {
	// Returns the list of all intents in the specified agent.
	ListIntents(ctx context.Context, in *ListIntentsRequest, opts ...grpc.CallOption) (*ListIntentsResponse, error)
	// Retrieves the specified intent.
	GetIntent(ctx context.Context, in *GetIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Creates an intent in the specified agent.
	CreateIntent(ctx context.Context, in *CreateIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Updates the specified intent.
	UpdateIntent(ctx context.Context, in *UpdateIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Deletes the specified intent.
	DeleteIntent(ctx context.Context, in *DeleteIntentRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
	// Updates/Creates multiple intents in the specified agent.
	//
	// Operation <response: [BatchUpdateIntentsResponse][google.cloud.dialogflow.v2beta1.BatchUpdateIntentsResponse]>
	BatchUpdateIntents(ctx context.Context, in *BatchUpdateIntentsRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Deletes intents in the specified agent.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteIntents(ctx context.Context, in *BatchDeleteIntentsRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type intentsClient struct {
	cc *grpc.ClientConn
}

func NewIntentsClient(cc *grpc.ClientConn) IntentsClient {
	return &intentsClient{cc}
}

func (c *intentsClient) ListIntents(ctx context.Context, in *ListIntentsRequest, opts ...grpc.CallOption) (*ListIntentsResponse, error) {
	out := new(ListIntentsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/ListIntents", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) GetIntent(ctx context.Context, in *GetIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/GetIntent", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) CreateIntent(ctx context.Context, in *CreateIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/CreateIntent", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) UpdateIntent(ctx context.Context, in *UpdateIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/UpdateIntent", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) DeleteIntent(ctx context.Context, in *DeleteIntentRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/DeleteIntent", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) BatchUpdateIntents(ctx context.Context, in *BatchUpdateIntentsRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/BatchUpdateIntents", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) BatchDeleteIntents(ctx context.Context, in *BatchDeleteIntentsRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/BatchDeleteIntents", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Intents service

type IntentsServer interface {
	// Returns the list of all intents in the specified agent.
	ListIntents(context.Context, *ListIntentsRequest) (*ListIntentsResponse, error)
	// Retrieves the specified intent.
	GetIntent(context.Context, *GetIntentRequest) (*Intent, error)
	// Creates an intent in the specified agent.
	CreateIntent(context.Context, *CreateIntentRequest) (*Intent, error)
	// Updates the specified intent.
	UpdateIntent(context.Context, *UpdateIntentRequest) (*Intent, error)
	// Deletes the specified intent.
	DeleteIntent(context.Context, *DeleteIntentRequest) (*google_protobuf2.Empty, error)
	// Updates/Creates multiple intents in the specified agent.
	//
	// Operation <response: [BatchUpdateIntentsResponse][google.cloud.dialogflow.v2beta1.BatchUpdateIntentsResponse]>
	BatchUpdateIntents(context.Context, *BatchUpdateIntentsRequest) (*google_longrunning.Operation, error)
	// Deletes intents in the specified agent.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteIntents(context.Context, *BatchDeleteIntentsRequest) (*google_longrunning.Operation, error)
}

func RegisterIntentsServer(s *grpc.Server, srv IntentsServer) {
	s.RegisterService(&_Intents_serviceDesc, srv)
}

func _Intents_ListIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).ListIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/ListIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).ListIntents(ctx, req.(*ListIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_GetIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).GetIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/GetIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).GetIntent(ctx, req.(*GetIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_CreateIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).CreateIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/CreateIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).CreateIntent(ctx, req.(*CreateIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_UpdateIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).UpdateIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/UpdateIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).UpdateIntent(ctx, req.(*UpdateIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_DeleteIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).DeleteIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/DeleteIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).DeleteIntent(ctx, req.(*DeleteIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_BatchUpdateIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).BatchUpdateIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/BatchUpdateIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).BatchUpdateIntents(ctx, req.(*BatchUpdateIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_BatchDeleteIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).BatchDeleteIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/BatchDeleteIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).BatchDeleteIntents(ctx, req.(*BatchDeleteIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Intents_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.Intents",
	HandlerType: (*IntentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListIntents",
			Handler:    _Intents_ListIntents_Handler,
		},
		{
			MethodName: "GetIntent",
			Handler:    _Intents_GetIntent_Handler,
		},
		{
			MethodName: "CreateIntent",
			Handler:    _Intents_CreateIntent_Handler,
		},
		{
			MethodName: "UpdateIntent",
			Handler:    _Intents_UpdateIntent_Handler,
		},
		{
			MethodName: "DeleteIntent",
			Handler:    _Intents_DeleteIntent_Handler,
		},
		{
			MethodName: "BatchUpdateIntents",
			Handler:    _Intents_BatchUpdateIntents_Handler,
		},
		{
			MethodName: "BatchDeleteIntents",
			Handler:    _Intents_BatchDeleteIntents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/intent.proto",
}

func init() { proto.RegisterFile("google/cloud/dialogflow/v2beta1/intent.proto", fileDescriptor3) }

var fileDescriptor3 = []byte{
	// 2592 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x5a, 0xcd, 0x73, 0x23, 0x47,
	0xd9, 0xf7, 0xe8, 0xc3, 0x96, 0x1e, 0xc9, 0xb2, 0xdc, 0xde, 0x6c, 0xb4, 0x93, 0xa4, 0xe2, 0x28,
	0x6f, 0xf2, 0x3a, 0x7e, 0x13, 0xe9, 0x8d, 0x92, 0x37, 0x1f, 0xbb, 0x6f, 0x12, 0x64, 0x5b, 0x5e,
	0x0b, 0xcb, 0x96, 0x76, 0x2c, 0x6f, 0xd8, 0x14, 0x30, 0x35, 0x92, 0xda, 0xda, 0xc6, 0xa3, 0x99,
	0xc9, 0x74, 0xcb, 0x1b, 0x05, 0x52, 0x45, 0x51, 0x05, 0x1c, 0xb8, 0x50, 0x70, 0xa0, 0x28, 0x6e,
	0x70, 0x0a, 0xc5, 0x81, 0xca, 0x8d, 0x3f, 0x81, 0x03, 0x27, 0x8e, 0x39, 0x50, 0x54, 0x51, 0xfc,
	0x0d, 0xdc, 0xa0, 0xfa, 0x63, 0xa4, 0x91, 0xa5, 0x45, 0x92, 0xbd, 0x70, 0xe1, 0x36, 0xfd, 0x74,
	0xf7, 0xef, 0xf9, 0xea, 0xfe, 0x3d, 0xdd, 0x2d, 0xc1, 0xab, 0x5d, 0xd7, 0xed, 0xda, 0xb8, 0xd8,
	0xb6, 0xdd, 0x7e, 0xa7, 0xd8, 0x21, 0x96, 0xed, 0x76, 0xcf, 0x6c, 0xf7, 0x51, 0xf1, 0xa2, 0xd4,
	0xc2, 0xcc, 0x7a, 0xbd, 0x48, 0x1c, 0x86, 0x1d, 0x56, 0xf0, 0x7c, 0x97, 0xb9, 0xe8, 0x79, 0x39,
	0xba, 0x20, 0x46, 0x17, 0x46, 0xa3, 0x0b, 0x6a, 0xb4, 0xfe, 0xac, 0x82, 0xb3, 0x3c, 0x52, 0xb4,
	0x1c, 0xc7, 0x65, 0x16, 0x23, 0xae, 0x43, 0xe5, 0x74, 0xfd, 0xb5, 0x59, 0xca, 0xda, 0xae, 0xc3,
	0xf0, 0x27, 0x4a, 0x9b, 0xfe, 0xa2, 0x1a, 0x6e, 0xbb, 0x4e, 0xd7, 0xef, 0x3b, 0x0e, 0x71, 0xba,
	0x45, 0xd7, 0xc3, 0xfe, 0x18, 0xe6, 0x33, 0x6a, 0x90, 0x68, 0xb5, 0xfa, 0x67, 0x45, 0xdc, 0xf3,
	0xd8, 0x40, 0x75, 0x6e, 0x5e, 0xee, 0x3c, 0x23, 0xd8, 0xee, 0x98, 0x3d, 0x8b, 0x9e, 0xab, 0x11,
	0xcf, 0x5e, 0x1e, 0x41, 0x99, 0xdf, 0x6f, 0x2b, 0x0b, 0xf2, 0x3f, 0xdb, 0x86, 0xe5, 0xaa, 0x08,
	0x00, 0x42, 0x10, 0x73, 0xac, 0x1e, 0xce, 0x69, 0x9b, 0xda, 0x56, 0xd2, 0x10, 0xdf, 0xe8, 0x05,
	0x48, 0x77, 0x08, 0xf5, 0x6c, 0x6b, 0x60, 0x8a, 0xbe, 0x88, 0xe8, 0x4b, 0x29, 0xd9, 0x31, 0x1f,
	0xf2, 0x00, 0x56, 0x1f, 0xe1, 0xd6, 0x43, 0xd7, 0x3d, 0x37, 0x29, 0xb3, 0x18, 0xce, 0x2d, 0x6f,
	0x6a, 0x5b, 0x99, 0xd2, 0x9b, 0x85, 0x19, 0x91, 0x2c, 0x48, 0xb5, 0x85, 0x0f, 0xe5, 0xe4, 0x13,
	0x3e, 0xd7, 0x48, 0x3f, 0x0a, 0xb5, 0x90, 0x0e, 0x09, 0xcf, 0x27, 0xae, 0x4f, 0xd8, 0x20, 0x17,
	0xdd, 0xd4, 0xb6, 0xe2, 0xc6, 0xb0, 0x8d, 0x9e, 0x87, 0x14, 0xa1, 0xe6, 0x99, 0x65, 0xdb, 0x2d,
	0xab, 0x7d, 0x9e, 0x8b, 0x6d, 0x6a, 0x5b, 0x09, 0x03, 0x08, 0xdd, 0x57, 0x12, 0xf4, 0x1c, 0x40,
	0xcf, 0x36, 0xb1, 0x63, 0xb5, 0x6c, 0xdc, 0xc9, 0xc5, 0x45, 0x7f, 0xb2, 0x67, 0x57, 0xa4, 0x80,
	0xcf, 0xef, 0xd9, 0x66, 0x87, 0x50, 0xd9, 0xbf, 0x21, 0xe7, 0xf7, 0xec, 0x3d, 0x25, 0x41, 0x05,
	0xd8, 0x20, 0x8e, 0xd7, 0x67, 0xa6, 0x4a, 0x99, 0x08, 0x00, 0xcd, 0xad, 0x6c, 0x46, 0xb7, 0x92,
	0xc6, 0xba, 0xe8, 0xda, 0x95, 0x3d, 0x3c, 0x0c, 0x14, 0xdd, 0x84, 0x65, 0x7c, 0x81, 0x1d, 0x46,
	0x73, 0x09, 0x31, 0x44, 0xb5, 0x90, 0x05, 0x59, 0xe6, 0x5b, 0x84, 0xe7, 0xd6, 0xf4, 0x1e, 0xfa,
	0x16, 0xc5, 0x34, 0x97, 0xdc, 0x8c, 0x6e, 0xa5, 0x4a, 0x6f, 0xcd, 0x1b, 0xa2, 0xa6, 0x9a, 0xdf,
	0x10, 0xd3, 0x8d, 0x35, 0x36, 0xd6, 0x16, 0xaa, 0xad, 0x36, 0x5f, 0x32, 0x39, 0x10, 0xf9, 0x51,
	0x2d, 0x74, 0x0f, 0xd6, 0xdc, 0x3e, 0x0b, 0xf9, 0x40, 0x73, 0x29, 0xa1, 0x79, 0x6b, 0xa6, 0x66,
	0xe5, 0x9a, 0x91, 0x91, 0x00, 0xaa, 0x49, 0xd1, 0x4b, 0x90, 0xf1, 0x31, 0xc5, 0x21, 0xc4, 0xb4,
	0x88, 0xdc, 0xaa, 0x90, 0x0e, 0x87, 0xdd, 0x03, 0xf0, 0x2c, 0xdf, 0xea, 0x61, 0x86, 0x7d, 0x9a,
	0x5b, 0x15, 0x4a, 0x5f, 0x9f, 0xd7, 0xdd, 0x46, 0x30, 0xd3, 0x08, 0x81, 0xa0, 0x43, 0x48, 0xf4,
	0x30, 0xa5, 0x56, 0x17, 0xd3, 0x5c, 0x46, 0x00, 0x16, 0xe7, 0x05, 0x3c, 0x92, 0xf3, 0x8c, 0x21,
	0x00, 0xba, 0x00, 0xbd, 0x83, 0xcf, 0xac, 0xbe, 0xcd, 0x4c, 0x1f, 0x53, 0xcf, 0x75, 0x28, 0x36,
	0x3d, 0xdb, 0x62, 0x67, 0xae, 0xdf, 0xa3, 0xb9, 0xb5, 0xcd, 0xe8, 0x56, 0xa6, 0xf4, 0xce, 0x82,
	0xf0, 0x85, 0x86, 0x02, 0x30, 0x72, 0x0a, 0xdb, 0x50, 0xd0, 0x41, 0x07, 0x45, 0xef, 0xc2, 0x2d,
	0xdf, 0x75, 0x99, 0x79, 0xe6, 0xda, 0xb6, 0xfb, 0xa8, 0xef, 0x99, 0x92, 0x7c, 0xe4, 0xe6, 0xca,
	0x8a, 0xe4, 0xdd, 0xe4, 0x03, 0xf6, 0x55, 0xbf, 0xd4, 0x20, 0xf6, 0xd9, 0x7b, 0xf0, 0x8c, 0x67,
	0xf9, 0x7c, 0xf0, 0xd4, 0xc9, 0xeb, 0x62, 0x72, 0x4e, 0x0e, 0x99, 0x32, 0xdd, 0x86, 0x1b, 0x97,
	0xe7, 0x11, 0xe7, 0xcc, 0xcd, 0x21, 0x11, 0xca, 0xdb, 0xf3, 0xfa, 0x3a, 0x8e, 0x5c, 0x75, 0xce,
	0x5c, 0x03, 0x9d, 0x4d, 0xc8, 0xf4, 0x5f, 0x45, 0x21, 0x33, 0xbe, 0x6a, 0xa7, 0xd2, 0x4b, 0x1d,
	0x62, 0x6c, 0xe0, 0x49, 0x5a, 0xc9, 0x94, 0xee, 0x5c, 0x6d, 0x3f, 0x14, 0x9a, 0x03, 0x0f, 0x1b,
	0x02, 0x08, 0xdd, 0x83, 0xb8, 0x67, 0xf9, 0x8c, 0xe6, 0xa2, 0xc2, 0xad, 0xab, 0x22, 0x36, 0x2c,
	0x9f, 0x19, 0x12, 0x09, 0x6d, 0xc3, 0x3a, 0x23, 0x3d, 0x4c, 0x4d, 0xab, 0xd3, 0xc1, 0x1d, 0xb3,
	0xed, 0xf6, 0x1d, 0x26, 0xe8, 0x26, 0x6e, 0xac, 0x89, 0x8e, 0x32, 0x97, 0xef, 0x72, 0xb1, 0xce,
	0x20, 0xc6, 0xa7, 0x72, 0x5f, 0xf9, 0x3e, 0x08, 0x7c, 0xe5, 0xdf, 0x9c, 0x70, 0xb0, 0xc3, 0x08,
	0x1b, 0x98, 0x43, 0x97, 0x93, 0x06, 0x48, 0x11, 0xf7, 0x00, 0xdd, 0x80, 0xb8, 0x65, 0x13, 0x8b,
	0x0a, 0xaa, 0x4b, 0x1a, 0xb2, 0xc1, 0x19, 0xb8, 0x4f, 0xb1, 0x6f, 0x76, 0xf0, 0x19, 0x71, 0x70,
	0x47, 0x11, 0x5d, 0x8a, 0xcb, 0xf6, 0xa4, 0x28, 0xff, 0x36, 0xc4, 0x14, 0x40, 0xb6, 0xf9, 0xa0,
	0x51, 0x31, 0x4f, 0x8f, 0x4f, 0x1a, 0x95, 0xdd, 0xea, 0x7e, 0xb5, 0xb2, 0x97, 0x5d, 0x42, 0x29,
	0x58, 0xa9, 0x7c, 0xad, 0x7c, 0xd4, 0xa8, 0x55, 0xb2, 0x1a, 0x4a, 0x43, 0xa2, 0x59, 0x39, 0x6a,
	0xd4, 0xca, 0xcd, 0x4a, 0x36, 0xa2, 0xff, 0x30, 0x02, 0xc9, 0xe1, 0x66, 0xbb, 0x2a, 0xff, 0xdf,
	0x80, 0xf8, 0x85, 0x65, 0xf7, 0x71, 0x60, 0xb6, 0x68, 0xa0, 0x17, 0x61, 0x35, 0xd8, 0x60, 0xb2,
	0x37, 0x26, 0x7a, 0xd3, 0x4a, 0x78, 0x5f, 0x0c, 0x7a, 0x1b, 0x72, 0xa1, 0x90, 0x98, 0x63, 0x9a,
	0xe2, 0x62, 0xfc, 0x53, 0xa3, 0xf8, 0xec, 0x85, 0x74, 0x3e, 0x0b, 0xc9, 0x9e, 0xe5, 0x74, 0x2c,
	0xe6, 0xfa, 0x03, 0x51, 0x6f, 0x38, 0xb5, 0x07, 0x02, 0x94, 0x83, 0x15, 0xcf, 0x77, 0x7b, 0x1e,
	0x0b, 0xd8, 0x3a, 0x68, 0xa2, 0xa7, 0x61, 0x85, 0x50, 0xd3, 0x26, 0x94, 0xe5, 0x12, 0x62, 0xd6,
	0x32, 0xa1, 0x35, 0x42, 0x99, 0xfe, 0x13, 0x1d, 0x56, 0xd4, 0x36, 0x46, 0x5f, 0x0d, 0x25, 0x2f,
	0x35, 0x7f, 0x1d, 0x0b, 0x58, 0xa0, 0x89, 0x3f, 0x61, 0x07, 0x4b, 0x2a, 0xe9, 0x47, 0x10, 0x27,
	0x3d, 0xab, 0x2b, 0x03, 0x97, 0x2a, 0xfd, 0xdf, 0xa2, 0x60, 0x55, 0x3e, 0xf9, 0x60, 0xc9, 0x90,
	0x28, 0xa8, 0x0d, 0xab, 0x1f, 0xf7, 0x49, 0xfb, 0xdc, 0xf4, 0xb1, 0x67, 0x13, 0x2c, 0x97, 0x4a,
	0xaa, 0xf4, 0xff, 0x8b, 0xc2, 0xde, 0xe3, 0x20, 0x86, 0xc4, 0x38, 0x58, 0x32, 0xd2, 0x1f, 0x87,
	0xda, 0xdc, 0xff, 0xb6, 0xe5, 0xcb, 0x95, 0x76, 0x05, 0xff, 0x77, 0x2d, 0xbf, 0xc3, 0xfd, 0xe7,
	0x18, 0xe8, 0x0d, 0x58, 0xf1, 0xac, 0x81, 0xed, 0x5a, 0xb2, 0x02, 0xa7, 0x4a, 0x4f, 0x07, 0x70,
	0xc1, 0x71, 0xa4, 0x70, 0x22, 0x8e, 0x23, 0x07, 0x4b, 0x46, 0x30, 0x12, 0xd9, 0x90, 0xa5, 0xa4,
	0xe7, 0xd9, 0x78, 0xc8, 0xcd, 0x3c, 0x91, 0x7c, 0xf6, 0x07, 0x8b, 0x1a, 0x73, 0x22, 0x70, 0x02,
	0x1e, 0xe6, 0xbe, 0xae, 0xd1, 0x71, 0x11, 0xfa, 0x08, 0xa0, 0x65, 0x51, 0xd2, 0x36, 0x85, 0xd3,
	0x09, 0xa1, 0xe7, 0xdd, 0x45, 0xf5, 0xec, 0x70, 0x04, 0xe5, 0x79, 0xb2, 0x15, 0x34, 0x90, 0x09,
	0x29, 0xda, 0xef, 0x76, 0x31, 0x15, 0xe7, 0xb9, 0x5c, 0x52, 0x80, 0xdf, 0x59, 0xd8, 0x89, 0x11,
	0xc4, 0xc1, 0x92, 0x11, 0x46, 0x44, 0x14, 0x36, 0x6c, 0xe2, 0x9c, 0x9b, 0x6e, 0x9f, 0x99, 0x23,
	0xb9, 0x38, 0x06, 0xa4, 0x4a, 0xe5, 0x45, 0x15, 0xd5, 0x88, 0x73, 0x5e, 0xef, 0xb3, 0x91, 0xbe,
	0x83, 0x25, 0x63, 0xdd, 0xbe, 0x2c, 0x44, 0xdf, 0x80, 0x14, 0xdf, 0x42, 0x26, 0xc5, 0x36, 0x6e,
	0xb3, 0x5c, 0x4a, 0x28, 0xbb, 0xbd, 0xb8, 0x32, 0xca, 0x4e, 0x04, 0xc2, 0xc1, 0x92, 0x01, 0xf6,
	0xb0, 0x85, 0x08, 0xac, 0xb5, 0x2d, 0xdf, 0xed, 0x53, 0x6c, 0x07, 0x2a, 0xd2, 0x42, 0xc5, 0xfb,
	0x57, 0x58, 0x8a, 0x02, 0x66, 0xa8, 0x26, 0xd3, 0x1e, 0x93, 0xa0, 0x26, 0x24, 0x82, 0xaa, 0xaf,
	0x8e, 0xad, 0x57, 0x2f, 0xfa, 0x43, 0x24, 0x5d, 0x87, 0x18, 0x27, 0x81, 0x50, 0x15, 0x88, 0x06,
	0x55, 0x40, 0x3f, 0x81, 0xb8, 0xd8, 0xd3, 0xe8, 0x19, 0x48, 0x8a, 0x3d, 0x6d, 0xf6, 0x7d, 0xa2,
	0x28, 0x37, 0x21, 0x04, 0xa7, 0x3e, 0x41, 0xaf, 0x01, 0xb2, 0xda, 0x6d, 0x4c, 0x29, 0x69, 0x11,
	0x5b, 0xf0, 0x23, 0xc7, 0x91, 0xe4, 0xbb, 0x3e, 0xd6, 0xc3, 0x15, 0xe9, 0x55, 0x48, 0x87, 0x77,
	0x34, 0xa7, 0x64, 0x46, 0x98, 0x1d, 0x50, 0xb9, 0x6c, 0x70, 0x4a, 0x1e, 0x27, 0x8f, 0x88, 0xb0,
	0x6b, 0x6c, 0xf3, 0xeb, 0x7f, 0xd5, 0x20, 0x26, 0x96, 0xee, 0x74, 0x0c, 0x1d, 0x12, 0xb4, 0xdf,
	0x92, 0x1d, 0xd2, 0x9c, 0x61, 0x7b, 0xdc, 0xa3, 0xe8, 0x25, 0x8f, 0x4e, 0x61, 0xa5, 0xd5, 0x67,
	0x8c, 0xef, 0x82, 0xd8, 0x62, 0xa5, 0x39, 0xcc, 0x2b, 0x85, 0x1d, 0x81, 0x61, 0x04, 0x58, 0xfa,
	0x3b, 0xb0, 0x2c, 0x45, 0x53, 0x4b, 0x2e, 0xbf, 0x3f, 0xb8, 0x94, 0x89, 0x0b, 0x82, 0xb2, 0x36,
	0x68, 0xeb, 0x3d, 0xc8, 0x8c, 0x93, 0x03, 0xfa, 0x2f, 0xc8, 0x88, 0x73, 0x3e, 0x73, 0x4d, 0xea,
	0x61, 0xdc, 0x7e, 0xa8, 0xb0, 0xd2, 0x5c, 0xda, 0x74, 0x4f, 0x84, 0x8c, 0xeb, 0xa1, 0xb4, 0x67,
	0x2b, 0x3c, 0xf1, 0x1d, 0xae, 0x92, 0xc2, 0x86, 0xe8, 0x58, 0x95, 0x14, 0x29, 0xfa, 0x0e, 0xac,
	0x5d, 0xe2, 0x22, 0x44, 0xa6, 0xd0, 0x9c, 0x26, 0x62, 0xf3, 0xfe, 0xf5, 0x68, 0x6e, 0x82, 0xe3,
	0xf4, 0xdf, 0x47, 0x21, 0x39, 0xa4, 0xa8, 0x2b, 0xa4, 0xf6, 0x25, 0xc8, 0xf0, 0x95, 0x6d, 0x31,
	0x86, 0x3b, 0x61, 0x17, 0x57, 0x87, 0x52, 0xb1, 0xe0, 0x0f, 0x83, 0x6a, 0x17, 0xbb, 0x46, 0xb5,
	0x0b, 0x6a, 0xdd, 0x47, 0xa3, 0x15, 0x13, 0x17, 0x51, 0xf9, 0xca, 0x95, 0x49, 0x79, 0x62, 0xd9,
	0xfc, 0x4e, 0x1b, 0xae, 0x9b, 0xe9, 0xc1, 0xb8, 0x80, 0x35, 0xd7, 0xc3, 0x0e, 0x5f, 0xca, 0xa6,
	0xba, 0x5a, 0xc9, 0x0a, 0x7e, 0x7c, 0x5d, 0x23, 0x0a, 0x75, 0x0f, 0x3b, 0xa7, 0x3e, 0x29, 0x0b,
	0x54, 0x63, 0xd5, 0x0d, 0x37, 0xf5, 0x17, 0x60, 0x75, 0xac, 0x1f, 0x65, 0x21, 0x3a, 0x22, 0x08,
	0xfe, 0xa9, 0xe7, 0x01, 0x42, 0x5c, 0x3c, 0xd5, 0x7c, 0xfd, 0x1c, 0x52, 0xa1, 0xa2, 0x81, 0xbe,
	0x3e, 0x5e, 0x86, 0xb4, 0xc5, 0x8e, 0xfc, 0x93, 0x65, 0x68, 0xac, 0x06, 0xe9, 0x0d, 0x58, 0x9f,
	0x28, 0x1c, 0xe8, 0x15, 0xc8, 0x76, 0xf8, 0xa7, 0x23, 0x9e, 0x32, 0xcc, 0xd0, 0xc1, 0x72, 0x2d,
	0x24, 0x17, 0x87, 0x39, 0xe5, 0x62, 0x64, 0xe4, 0xe2, 0x97, 0x11, 0x80, 0x51, 0x79, 0x78, 0x4c,
	0x8a, 0x4e, 0x21, 0x4e, 0x18, 0xee, 0x49, 0x1a, 0xbb, 0xc2, 0xd1, 0x60, 0xa4, 0xa0, 0x50, 0x65,
	0xb8, 0x67, 0x48, 0x34, 0xfd, 0x4f, 0x1a, 0xc4, 0x78, 0x1b, 0x19, 0x10, 0x13, 0x17, 0x24, 0xed,
	0x6a, 0xb5, 0x47, 0x42, 0x73, 0x24, 0x71, 0x49, 0x12, 0x58, 0x23, 0x4f, 0x22, 0x61, 0x4f, 0x36,
	0x21, 0xd5, 0xc1, 0xb4, 0xed, 0x13, 0x4f, 0x2c, 0xb4, 0x80, 0x3d, 0x46, 0xa2, 0x27, 0xba, 0xb1,
	0xf4, 0x3f, 0x44, 0x20, 0x33, 0x5e, 0x19, 0xd1, 0x83, 0x20, 0x96, 0x72, 0x69, 0xec, 0x5e, 0xaf,
	0xd0, 0xfe, 0x87, 0xc5, 0xf3, 0x7d, 0xc8, 0x8c, 0x1b, 0xc7, 0x57, 0xf4, 0x39, 0x1e, 0x04, 0x9b,
	0xf6, 0x1c, 0x0f, 0x04, 0xb9, 0x0e, 0x1c, 0xd7, 0x19, 0xf4, 0x82, 0xb2, 0x3b, 0x6c, 0xe7, 0x7f,
	0xa4, 0x41, 0x22, 0x38, 0x45, 0xa0, 0x1c, 0xdc, 0xe0, 0xb7, 0xb3, 0xfd, 0xba, 0x71, 0x74, 0xe9,
	0x1e, 0x97, 0x86, 0xc4, 0x7e, 0x79, 0xb7, 0xb2, 0x53, 0xaf, 0x1f, 0x66, 0x35, 0x94, 0x84, 0xf8,
	0x49, 0xad, 0xbc, 0x7b, 0x98, 0x8d, 0xc8, 0x3b, 0x5d, 0xad, 0x72, 0xd7, 0x28, 0x1f, 0x65, 0xa3,
	0x68, 0x05, 0xa2, 0x87, 0xd5, 0xc3, 0x6c, 0x4c, 0x8c, 0x38, 0x7c, 0xd0, 0xa8, 0x64, 0xe3, 0x28,
	0x01, 0xb1, 0x5a, 0xf5, 0xb8, 0x92, 0x5d, 0xe6, 0xc2, 0xfb, 0xd5, 0x9d, 0x8a, 0x91, 0x5d, 0x41,
	0x4f, 0xc1, 0x7a, 0x79, 0xb7, 0x59, 0xad, 0x1f, 0x9f, 0x98, 0xf5, 0x63, 0xf3, 0x6e, 0xbd, 0x7e,
	0xb7, 0x56, 0xc9, 0x26, 0x76, 0x92, 0xb0, 0xa2, 0x5e, 0x49, 0xf4, 0xef, 0x6b, 0x80, 0x26, 0xef,
	0xfb, 0xe8, 0x7f, 0x27, 0x5f, 0x12, 0x42, 0xdb, 0xfb, 0xd2, 0x6b, 0xc0, 0x3c, 0x4f, 0x17, 0x91,
	0x7f, 0xfe, 0x74, 0x91, 0x67, 0x90, 0x0e, 0x3f, 0x12, 0xa2, 0xe7, 0xe0, 0xd6, 0x87, 0x95, 0x9d,
	0x83, 0x7a, 0xfd, 0xd0, 0x3c, 0x69, 0x96, 0x9b, 0x97, 0x2f, 0xbc, 0xb7, 0xe0, 0xa9, 0xf1, 0xee,
	0xca, 0x71, 0x79, 0xa7, 0x56, 0xd9, 0xcb, 0x6a, 0x68, 0x1b, 0x5e, 0x9e, 0xda, 0x65, 0xee, 0xd7,
	0x0d, 0xf3, 0xa4, 0x56, 0x6f, 0x9a, 0xfb, 0xd5, 0x5a, 0xad, 0x7a, 0x7c, 0x37, 0x1b, 0xc9, 0x7f,
	0xa9, 0x01, 0xe2, 0x1c, 0x21, 0x0d, 0xa1, 0x06, 0xfe, 0xb8, 0x8f, 0x29, 0x43, 0x37, 0x61, 0x59,
	0x1a, 0xaa, 0xfc, 0x55, 0x2d, 0x7e, 0xba, 0xb2, 0x2d, 0xa7, 0xdb, 0xe7, 0x07, 0xa0, 0xb6, 0xdb,
	0x09, 0xbc, 0x4a, 0x07, 0xc2, 0x5d, 0xb7, 0x83, 0x51, 0x0d, 0x52, 0xca, 0xf1, 0x0b, 0x82, 0x1f,
	0x89, 0x95, 0x99, 0x29, 0xfd, 0xcf, 0x9c, 0xab, 0xef, 0x3e, 0xc1, 0x8f, 0x0c, 0x20, 0xc3, 0x6f,
	0x7e, 0xe0, 0xf2, 0xb8, 0x3a, 0x4a, 0x3e, 0xc5, 0xea, 0x45, 0x22, 0xc1, 0x05, 0x27, 0xe4, 0x53,
	0x1e, 0x24, 0x10, 0x9d, 0xcc, 0x3d, 0xc7, 0x8e, 0xba, 0x4d, 0x8b, 0xe1, 0x4d, 0x2e, 0xc8, 0x7f,
	0x57, 0x83, 0x8d, 0x31, 0xef, 0xd4, 0x21, 0xa8, 0x0c, 0x2b, 0x52, 0x43, 0xc0, 0x05, 0xff, 0x3d,
	0xa7, 0x75, 0x46, 0x30, 0x0f, 0xbd, 0x0c, 0x6b, 0x0e, 0x3f, 0x47, 0x85, 0xd4, 0xcb, 0x58, 0xac,
	0x72, 0x71, 0x63, 0x68, 0xc2, 0xcf, 0x35, 0xc8, 0xde, 0xc5, 0xca, 0x82, 0x20, 0xbc, 0xd3, 0x1e,
	0x21, 0xfe, 0xfd, 0xa1, 0xcd, 0xff, 0x59, 0x83, 0x8d, 0x5d, 0x1f, 0x5b, 0x0c, 0x8f, 0x9b, 0xf7,
	0xb8, 0xec, 0x7f, 0x00, 0xcb, 0x72, 0xb6, 0x3a, 0x26, 0xcc, 0x1d, 0x35, 0x35, 0x6d, 0xd2, 0xc7,
	0xe8, 0x6c, 0x1f, 0x63, 0xd7, 0xf3, 0xf1, 0x07, 0x11, 0xd8, 0x38, 0xf5, 0x3a, 0x13, 0x3e, 0x8e,
	0x7c, 0xd1, 0x9e, 0x90, 0x2f, 0xd3, 0xf2, 0x75, 0x07, 0x52, 0x7d, 0xa1, 0x5c, 0xfc, 0x56, 0xa1,
	0x1e, 0x32, 0xf4, 0x89, 0xd7, 0x81, 0x7d, 0x82, 0xed, 0xce, 0x91, 0x45, 0xcf, 0x0d, 0x90, 0xc3,
	0xf9, 0xf7, 0x13, 0x0e, 0xc4, 0x2b, 0xb0, 0xb1, 0x87, 0x6d, 0x7c, 0x39, 0x0e, 0x53, 0x96, 0x62,
	0xfe, 0xef, 0x11, 0xb8, 0xb5, 0x63, 0xb1, 0xf6, 0xc3, 0x70, 0xe0, 0x66, 0x72, 0xc3, 0x36, 0x64,
	0x95, 0xb9, 0x2d, 0x3e, 0xd7, 0x1c, 0x1e, 0x77, 0xf8, 0x95, 0x54, 0xf6, 0x48, 0x50, 0x9f, 0xa0,
	0x6f, 0xc2, 0xc6, 0xd8, 0x58, 0xe2, 0xd8, 0xc4, 0xc1, 0x2a, 0x3e, 0xaf, 0xce, 0xe9, 0xa2, 0x40,
	0xe3, 0x97, 0xf7, 0x10, 0x78, 0x55, 0x00, 0x4d, 0x26, 0x27, 0x36, 0x3b, 0x39, 0xf1, 0xeb, 0x24,
	0x67, 0xf9, 0x5a, 0xc9, 0xd9, 0xc9, 0x40, 0x3a, 0x1c, 0x8f, 0xbc, 0x09, 0xfa, 0xb4, 0x04, 0x3c,
	0x31, 0xfa, 0xca, 0x5f, 0xa8, 0x0c, 0x87, 0x97, 0xc4, 0xcc, 0x0c, 0x87, 0xf4, 0x46, 0xae, 0xa8,
	0xb7, 0x01, 0xa9, 0x50, 0xf2, 0x9e, 0x80, 0x27, 0xdb, 0x1f, 0x00, 0x54, 0xc3, 0xd5, 0xe2, 0xe9,
	0xea, 0x71, 0xb3, 0x72, 0xdc, 0x34, 0xef, 0x57, 0x2b, 0x1f, 0x5e, 0xaa, 0x99, 0x37, 0x20, 0x1b,
	0xee, 0xdc, 0x3f, 0xad, 0xd5, 0xb2, 0x5a, 0xe9, 0x8b, 0x24, 0xac, 0xa8, 0x00, 0xa0, 0xdf, 0x68,
	0x90, 0x0a, 0x15, 0x0c, 0xf4, 0xc6, 0x4c, 0x73, 0x26, 0x8b, 0xa7, 0xfe, 0xe6, 0x62, 0x93, 0x64,
	0x52, 0xf3, 0xa5, 0xef, 0xfd, 0xf1, 0x2f, 0x3f, 0x8d, 0xbc, 0x8a, 0xb6, 0x87, 0xbf, 0xa2, 0x7e,
	0x5b, 0x86, 0xfd, 0x3d, 0xcf, 0x77, 0xbf, 0x85, 0xdb, 0x8c, 0x16, 0xb7, 0x8b, 0x56, 0x17, 0x3b,
	0xec, 0xb3, 0x62, 0x50, 0x84, 0x7e, 0xa1, 0x41, 0x72, 0x58, 0x5c, 0xd0, 0xec, 0x9f, 0x9e, 0x2e,
	0x17, 0x22, 0x7d, 0xde, 0x70, 0x4f, 0xb3, 0x8e, 0x53, 0xc5, 0x84, 0x6d, 0x81, 0x69, 0xc5, 0xed,
	0xcf, 0xd0, 0xe7, 0x1a, 0xa4, 0xc3, 0xe5, 0x05, 0xcd, 0x0e, 0xcc, 0x94, 0x6a, 0x34, 0xbf, 0x8d,
	0xb7, 0x85, 0x8d, 0x6f, 0xe6, 0x17, 0x88, 0xe0, 0xed, 0x80, 0xcd, 0x7f, 0xab, 0x41, 0x3a, 0xbc,
	0xd9, 0xe6, 0xb0, 0x75, 0x4a, 0x55, 0x99, 0xdf, 0xd6, 0xb2, 0xb0, 0xf5, 0x4e, 0xe9, 0xf5, 0x91,
	0xad, 0xea, 0x17, 0xfa, 0x59, 0x61, 0x1d, 0x9a, 0xfc, 0x63, 0x0d, 0xd2, 0xe1, 0xed, 0x3b, 0x87,
	0xc9, 0x53, 0x0a, 0x80, 0x7e, 0x73, 0x82, 0xf0, 0x2a, 0x3d, 0x8f, 0x0d, 0x82, 0x8c, 0x6f, 0x2f,
	0x92, 0xf1, 0x2f, 0x34, 0x40, 0x93, 0xbc, 0x85, 0x66, 0x5f, 0xc2, 0x1f, 0x5b, 0x6d, 0xf4, 0xe7,
	0x82, 0xb9, 0xa1, 0x7f, 0x0f, 0x14, 0xea, 0xc1, 0xbf, 0x07, 0x82, 0x38, 0xe6, 0xdf, 0x5a, 0x20,
	0xe7, 0xad, 0x91, 0xb2, 0xdb, 0xda, 0xf6, 0xc8, 0xe8, 0x31, 0x2e, 0x9c, 0xd7, 0xe8, 0x69, 0x04,
	0xfa, 0x2f, 0x33, 0x5a, 0x2a, 0xbb, 0xad, 0x6d, 0xef, 0x7c, 0xae, 0xc1, 0x8b, 0x6d, 0xb7, 0x37,
	0xcb, 0xc6, 0x1d, 0xc5, 0xb6, 0x0d, 0x9e, 0xdb, 0x86, 0xf6, 0x51, 0x55, 0x8d, 0xef, 0xba, 0xbc,
	0x12, 0x16, 0x5c, 0xbf, 0x5b, 0xec, 0x62, 0x47, 0x64, 0xbe, 0x28, 0xbb, 0x2c, 0x8f, 0xd0, 0xc7,
	0xfe, 0xb1, 0xe3, 0xce, 0x48, 0xf4, 0x37, 0x4d, 0xfb, 0x65, 0x24, 0xb2, 0xb7, 0xff, 0xeb, 0xc8,
	0xf3, 0x77, 0x25, 0xe6, 0xae, 0xb0, 0x61, 0x6f, 0x64, 0xc3, 0x7d, 0x39, 0xa9, 0xb5, 0x2c, 0xf0,
	0xdf, 0xf8, 0x47, 0x00, 0x00, 0x00, 0xff, 0xff, 0x39, 0x20, 0xe1, 0xfe, 0xa4, 0x22, 0x00, 0x00,
}
