# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "vmss list",
)
class List(AAZCommand):
    """List all VM scale sets under a resource group.

    :example: List VMSS
        az vmss list --resource-group MyResourceGroup
    """

    _aaz_info = {
        "version": "2017-12-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/providers/microsoft.compute/virtualmachinescalesets", "2017-12-01"],
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.compute/virtualmachinescalesets", "2017-12-01"],
        ]
    }

    AZ_SUPPORT_PAGINATION = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_paging(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg()
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        condition_0 = has_value(self.ctx.subscription_id) and has_value(self.ctx.args.resource_group) is not True
        condition_1 = has_value(self.ctx.args.resource_group) and has_value(self.ctx.subscription_id)
        if condition_0:
            self.VirtualMachineScaleSetsListAll(ctx=self.ctx)()
        if condition_1:
            self.VirtualMachineScaleSetsList(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance.value, client_flatten=True)
        next_link = self.deserialize_output(self.ctx.vars.instance.next_link)
        return result, next_link

    class VirtualMachineScaleSetsListAll(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/Microsoft.Compute/virtualMachineScaleSets",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2017-12-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
            )
            _schema_on_200.value = AAZListType(
                flags={"required": True},
            )

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.identity = AAZObjectType()
            _element.location = AAZStrType(
                flags={"required": True},
            )
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.plan = AAZObjectType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.sku = AAZObjectType()
            _element.tags = AAZDictType()
            _element.type = AAZStrType(
                flags={"read_only": True},
            )
            _element.zones = AAZListType()

            identity = cls._schema_on_200.value.Element.identity
            identity.identity_ids = AAZListType(
                serialized_name="identityIds",
            )
            identity.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )
            identity.tenant_id = AAZStrType(
                serialized_name="tenantId",
                flags={"read_only": True},
            )
            identity.type = AAZStrType()

            identity_ids = cls._schema_on_200.value.Element.identity.identity_ids
            identity_ids.Element = AAZStrType()

            plan = cls._schema_on_200.value.Element.plan
            plan.name = AAZStrType()
            plan.product = AAZStrType()
            plan.promotion_code = AAZStrType(
                serialized_name="promotionCode",
            )
            plan.publisher = AAZStrType()

            properties = cls._schema_on_200.value.Element.properties
            properties.overprovision = AAZBoolType()
            properties.platform_fault_domain_count = AAZIntType(
                serialized_name="platformFaultDomainCount",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.single_placement_group = AAZBoolType(
                serialized_name="singlePlacementGroup",
            )
            properties.unique_id = AAZStrType(
                serialized_name="uniqueId",
                flags={"read_only": True},
            )
            properties.upgrade_policy = AAZObjectType(
                serialized_name="upgradePolicy",
            )
            properties.virtual_machine_profile = AAZObjectType(
                serialized_name="virtualMachineProfile",
            )
            properties.zone_balance = AAZBoolType(
                serialized_name="zoneBalance",
            )

            upgrade_policy = cls._schema_on_200.value.Element.properties.upgrade_policy
            upgrade_policy.auto_os_upgrade_policy = AAZObjectType(
                serialized_name="autoOSUpgradePolicy",
            )
            upgrade_policy.automatic_os_upgrade = AAZBoolType(
                serialized_name="automaticOSUpgrade",
            )
            upgrade_policy.mode = AAZStrType()
            upgrade_policy.rolling_upgrade_policy = AAZObjectType(
                serialized_name="rollingUpgradePolicy",
            )

            auto_os_upgrade_policy = cls._schema_on_200.value.Element.properties.upgrade_policy.auto_os_upgrade_policy
            auto_os_upgrade_policy.disable_auto_rollback = AAZBoolType(
                serialized_name="disableAutoRollback",
            )

            rolling_upgrade_policy = cls._schema_on_200.value.Element.properties.upgrade_policy.rolling_upgrade_policy
            rolling_upgrade_policy.max_batch_instance_percent = AAZIntType(
                serialized_name="maxBatchInstancePercent",
            )
            rolling_upgrade_policy.max_unhealthy_instance_percent = AAZIntType(
                serialized_name="maxUnhealthyInstancePercent",
            )
            rolling_upgrade_policy.max_unhealthy_upgraded_instance_percent = AAZIntType(
                serialized_name="maxUnhealthyUpgradedInstancePercent",
            )
            rolling_upgrade_policy.pause_time_between_batches = AAZStrType(
                serialized_name="pauseTimeBetweenBatches",
            )

            virtual_machine_profile = cls._schema_on_200.value.Element.properties.virtual_machine_profile
            virtual_machine_profile.diagnostics_profile = AAZObjectType(
                serialized_name="diagnosticsProfile",
            )
            virtual_machine_profile.eviction_policy = AAZStrType(
                serialized_name="evictionPolicy",
            )
            virtual_machine_profile.extension_profile = AAZObjectType(
                serialized_name="extensionProfile",
            )
            virtual_machine_profile.license_type = AAZStrType(
                serialized_name="licenseType",
            )
            virtual_machine_profile.network_profile = AAZObjectType(
                serialized_name="networkProfile",
            )
            virtual_machine_profile.os_profile = AAZObjectType(
                serialized_name="osProfile",
            )
            virtual_machine_profile.priority = AAZStrType()
            virtual_machine_profile.storage_profile = AAZObjectType(
                serialized_name="storageProfile",
            )

            diagnostics_profile = cls._schema_on_200.value.Element.properties.virtual_machine_profile.diagnostics_profile
            diagnostics_profile.boot_diagnostics = AAZObjectType(
                serialized_name="bootDiagnostics",
            )

            boot_diagnostics = cls._schema_on_200.value.Element.properties.virtual_machine_profile.diagnostics_profile.boot_diagnostics
            boot_diagnostics.enabled = AAZBoolType()
            boot_diagnostics.storage_uri = AAZStrType(
                serialized_name="storageUri",
            )

            extension_profile = cls._schema_on_200.value.Element.properties.virtual_machine_profile.extension_profile
            extension_profile.extensions = AAZListType()

            extensions = cls._schema_on_200.value.Element.properties.virtual_machine_profile.extension_profile.extensions
            extensions.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.extension_profile.extensions.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200.value.Element.properties.virtual_machine_profile.extension_profile.extensions.Element.properties
            properties.auto_upgrade_minor_version = AAZBoolType(
                serialized_name="autoUpgradeMinorVersion",
            )
            properties.force_update_tag = AAZStrType(
                serialized_name="forceUpdateTag",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.publisher = AAZStrType()
            properties.type = AAZStrType()
            properties.type_handler_version = AAZStrType(
                serialized_name="typeHandlerVersion",
            )

            network_profile = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile
            network_profile.health_probe = AAZObjectType(
                serialized_name="healthProbe",
            )
            _ListHelper._build_schema_api_entity_reference_read(network_profile.health_probe)
            network_profile.network_interface_configurations = AAZListType(
                serialized_name="networkInterfaceConfigurations",
            )

            network_interface_configurations = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations
            network_interface_configurations.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element
            _element.id = AAZStrType()
            _element.name = AAZStrType(
                flags={"required": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties
            properties.dns_settings = AAZObjectType(
                serialized_name="dnsSettings",
            )
            properties.enable_accelerated_networking = AAZBoolType(
                serialized_name="enableAcceleratedNetworking",
            )
            properties.enable_ip_forwarding = AAZBoolType(
                serialized_name="enableIPForwarding",
            )
            properties.ip_configurations = AAZListType(
                serialized_name="ipConfigurations",
                flags={"required": True},
            )
            properties.network_security_group = AAZObjectType(
                serialized_name="networkSecurityGroup",
            )
            _ListHelper._build_schema_sub_resource_read(properties.network_security_group)
            properties.primary = AAZBoolType()

            dns_settings = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.dns_settings
            dns_settings.dns_servers = AAZListType(
                serialized_name="dnsServers",
            )

            dns_servers = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.dns_settings.dns_servers
            dns_servers.Element = AAZStrType()

            ip_configurations = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations
            ip_configurations.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element
            _element.id = AAZStrType()
            _element.name = AAZStrType(
                flags={"required": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties
            properties.application_gateway_backend_address_pools = AAZListType(
                serialized_name="applicationGatewayBackendAddressPools",
            )
            properties.load_balancer_backend_address_pools = AAZListType(
                serialized_name="loadBalancerBackendAddressPools",
            )
            properties.load_balancer_inbound_nat_pools = AAZListType(
                serialized_name="loadBalancerInboundNatPools",
            )
            properties.primary = AAZBoolType()
            properties.private_ip_address_version = AAZStrType(
                serialized_name="privateIPAddressVersion",
            )
            properties.public_ip_address_configuration = AAZObjectType(
                serialized_name="publicIPAddressConfiguration",
            )
            properties.subnet = AAZObjectType()
            _ListHelper._build_schema_api_entity_reference_read(properties.subnet)

            application_gateway_backend_address_pools = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.application_gateway_backend_address_pools
            application_gateway_backend_address_pools.Element = AAZObjectType()
            _ListHelper._build_schema_sub_resource_read(application_gateway_backend_address_pools.Element)

            load_balancer_backend_address_pools = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.load_balancer_backend_address_pools
            load_balancer_backend_address_pools.Element = AAZObjectType()
            _ListHelper._build_schema_sub_resource_read(load_balancer_backend_address_pools.Element)

            load_balancer_inbound_nat_pools = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.load_balancer_inbound_nat_pools
            load_balancer_inbound_nat_pools.Element = AAZObjectType()
            _ListHelper._build_schema_sub_resource_read(load_balancer_inbound_nat_pools.Element)

            public_ip_address_configuration = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration
            public_ip_address_configuration.name = AAZStrType(
                flags={"required": True},
            )
            public_ip_address_configuration.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties
            properties.dns_settings = AAZObjectType(
                serialized_name="dnsSettings",
            )
            properties.idle_timeout_in_minutes = AAZIntType(
                serialized_name="idleTimeoutInMinutes",
            )

            dns_settings = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties.dns_settings
            dns_settings.domain_name_label = AAZStrType(
                serialized_name="domainNameLabel",
                flags={"required": True},
            )

            os_profile = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile
            os_profile.admin_password = AAZStrType(
                serialized_name="adminPassword",
            )
            os_profile.admin_username = AAZStrType(
                serialized_name="adminUsername",
            )
            os_profile.computer_name_prefix = AAZStrType(
                serialized_name="computerNamePrefix",
            )
            os_profile.custom_data = AAZStrType(
                serialized_name="customData",
            )
            os_profile.linux_configuration = AAZObjectType(
                serialized_name="linuxConfiguration",
            )
            os_profile.secrets = AAZListType()
            os_profile.windows_configuration = AAZObjectType(
                serialized_name="windowsConfiguration",
            )

            linux_configuration = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.linux_configuration
            linux_configuration.disable_password_authentication = AAZBoolType(
                serialized_name="disablePasswordAuthentication",
            )
            linux_configuration.ssh = AAZObjectType()

            ssh = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.linux_configuration.ssh
            ssh.public_keys = AAZListType(
                serialized_name="publicKeys",
            )

            public_keys = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.linux_configuration.ssh.public_keys
            public_keys.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.linux_configuration.ssh.public_keys.Element
            _element.key_data = AAZStrType(
                serialized_name="keyData",
            )
            _element.path = AAZStrType()

            secrets = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.secrets
            secrets.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.secrets.Element
            _element.source_vault = AAZObjectType(
                serialized_name="sourceVault",
            )
            _ListHelper._build_schema_sub_resource_read(_element.source_vault)
            _element.vault_certificates = AAZListType(
                serialized_name="vaultCertificates",
            )

            vault_certificates = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.secrets.Element.vault_certificates
            vault_certificates.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.secrets.Element.vault_certificates.Element
            _element.certificate_store = AAZStrType(
                serialized_name="certificateStore",
            )
            _element.certificate_url = AAZStrType(
                serialized_name="certificateUrl",
            )

            windows_configuration = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.windows_configuration
            windows_configuration.additional_unattend_content = AAZListType(
                serialized_name="additionalUnattendContent",
            )
            windows_configuration.enable_automatic_updates = AAZBoolType(
                serialized_name="enableAutomaticUpdates",
            )
            windows_configuration.provision_vm_agent = AAZBoolType(
                serialized_name="provisionVMAgent",
            )
            windows_configuration.time_zone = AAZStrType(
                serialized_name="timeZone",
            )
            windows_configuration.win_rm = AAZObjectType(
                serialized_name="winRM",
            )

            additional_unattend_content = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.windows_configuration.additional_unattend_content
            additional_unattend_content.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.windows_configuration.additional_unattend_content.Element
            _element.component_name = AAZStrType(
                serialized_name="componentName",
            )
            _element.content = AAZStrType()
            _element.pass_name = AAZStrType(
                serialized_name="passName",
            )
            _element.setting_name = AAZStrType(
                serialized_name="settingName",
            )

            win_rm = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.windows_configuration.win_rm
            win_rm.listeners = AAZListType()

            listeners = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.windows_configuration.win_rm.listeners
            listeners.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.windows_configuration.win_rm.listeners.Element
            _element.certificate_url = AAZStrType(
                serialized_name="certificateUrl",
            )
            _element.protocol = AAZStrType()

            storage_profile = cls._schema_on_200.value.Element.properties.virtual_machine_profile.storage_profile
            storage_profile.data_disks = AAZListType(
                serialized_name="dataDisks",
            )
            storage_profile.image_reference = AAZObjectType(
                serialized_name="imageReference",
            )
            storage_profile.os_disk = AAZObjectType(
                serialized_name="osDisk",
            )

            data_disks = cls._schema_on_200.value.Element.properties.virtual_machine_profile.storage_profile.data_disks
            data_disks.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.storage_profile.data_disks.Element
            _element.caching = AAZStrType()
            _element.create_option = AAZStrType(
                serialized_name="createOption",
                flags={"required": True},
            )
            _element.disk_size_gb = AAZIntType(
                serialized_name="diskSizeGB",
            )
            _element.lun = AAZIntType(
                flags={"required": True},
            )
            _element.managed_disk = AAZObjectType(
                serialized_name="managedDisk",
            )
            _ListHelper._build_schema_virtual_machine_scale_set_managed_disk_parameters_read(_element.managed_disk)
            _element.name = AAZStrType()
            _element.write_accelerator_enabled = AAZBoolType(
                serialized_name="writeAcceleratorEnabled",
            )

            image_reference = cls._schema_on_200.value.Element.properties.virtual_machine_profile.storage_profile.image_reference
            image_reference.id = AAZStrType()
            image_reference.offer = AAZStrType()
            image_reference.publisher = AAZStrType()
            image_reference.sku = AAZStrType()
            image_reference.version = AAZStrType()

            os_disk = cls._schema_on_200.value.Element.properties.virtual_machine_profile.storage_profile.os_disk
            os_disk.caching = AAZStrType()
            os_disk.create_option = AAZStrType(
                serialized_name="createOption",
                flags={"required": True},
            )
            os_disk.image = AAZObjectType()
            os_disk.managed_disk = AAZObjectType(
                serialized_name="managedDisk",
            )
            _ListHelper._build_schema_virtual_machine_scale_set_managed_disk_parameters_read(os_disk.managed_disk)
            os_disk.name = AAZStrType()
            os_disk.os_type = AAZStrType(
                serialized_name="osType",
            )
            os_disk.vhd_containers = AAZListType(
                serialized_name="vhdContainers",
            )
            os_disk.write_accelerator_enabled = AAZBoolType(
                serialized_name="writeAcceleratorEnabled",
            )

            image = cls._schema_on_200.value.Element.properties.virtual_machine_profile.storage_profile.os_disk.image
            image.uri = AAZStrType()

            vhd_containers = cls._schema_on_200.value.Element.properties.virtual_machine_profile.storage_profile.os_disk.vhd_containers
            vhd_containers.Element = AAZStrType()

            sku = cls._schema_on_200.value.Element.sku
            sku.capacity = AAZIntType()
            sku.name = AAZStrType()
            sku.tier = AAZStrType()

            tags = cls._schema_on_200.value.Element.tags
            tags.Element = AAZStrType()

            zones = cls._schema_on_200.value.Element.zones
            zones.Element = AAZStrType()

            return cls._schema_on_200

    class VirtualMachineScaleSetsList(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2017-12-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
            )
            _schema_on_200.value = AAZListType(
                flags={"required": True},
            )

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.identity = AAZObjectType()
            _element.location = AAZStrType(
                flags={"required": True},
            )
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.plan = AAZObjectType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.sku = AAZObjectType()
            _element.tags = AAZDictType()
            _element.type = AAZStrType(
                flags={"read_only": True},
            )
            _element.zones = AAZListType()

            identity = cls._schema_on_200.value.Element.identity
            identity.identity_ids = AAZListType(
                serialized_name="identityIds",
            )
            identity.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )
            identity.tenant_id = AAZStrType(
                serialized_name="tenantId",
                flags={"read_only": True},
            )
            identity.type = AAZStrType()

            identity_ids = cls._schema_on_200.value.Element.identity.identity_ids
            identity_ids.Element = AAZStrType()

            plan = cls._schema_on_200.value.Element.plan
            plan.name = AAZStrType()
            plan.product = AAZStrType()
            plan.promotion_code = AAZStrType(
                serialized_name="promotionCode",
            )
            plan.publisher = AAZStrType()

            properties = cls._schema_on_200.value.Element.properties
            properties.overprovision = AAZBoolType()
            properties.platform_fault_domain_count = AAZIntType(
                serialized_name="platformFaultDomainCount",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.single_placement_group = AAZBoolType(
                serialized_name="singlePlacementGroup",
            )
            properties.unique_id = AAZStrType(
                serialized_name="uniqueId",
                flags={"read_only": True},
            )
            properties.upgrade_policy = AAZObjectType(
                serialized_name="upgradePolicy",
            )
            properties.virtual_machine_profile = AAZObjectType(
                serialized_name="virtualMachineProfile",
            )
            properties.zone_balance = AAZBoolType(
                serialized_name="zoneBalance",
            )

            upgrade_policy = cls._schema_on_200.value.Element.properties.upgrade_policy
            upgrade_policy.auto_os_upgrade_policy = AAZObjectType(
                serialized_name="autoOSUpgradePolicy",
            )
            upgrade_policy.automatic_os_upgrade = AAZBoolType(
                serialized_name="automaticOSUpgrade",
            )
            upgrade_policy.mode = AAZStrType()
            upgrade_policy.rolling_upgrade_policy = AAZObjectType(
                serialized_name="rollingUpgradePolicy",
            )

            auto_os_upgrade_policy = cls._schema_on_200.value.Element.properties.upgrade_policy.auto_os_upgrade_policy
            auto_os_upgrade_policy.disable_auto_rollback = AAZBoolType(
                serialized_name="disableAutoRollback",
            )

            rolling_upgrade_policy = cls._schema_on_200.value.Element.properties.upgrade_policy.rolling_upgrade_policy
            rolling_upgrade_policy.max_batch_instance_percent = AAZIntType(
                serialized_name="maxBatchInstancePercent",
            )
            rolling_upgrade_policy.max_unhealthy_instance_percent = AAZIntType(
                serialized_name="maxUnhealthyInstancePercent",
            )
            rolling_upgrade_policy.max_unhealthy_upgraded_instance_percent = AAZIntType(
                serialized_name="maxUnhealthyUpgradedInstancePercent",
            )
            rolling_upgrade_policy.pause_time_between_batches = AAZStrType(
                serialized_name="pauseTimeBetweenBatches",
            )

            virtual_machine_profile = cls._schema_on_200.value.Element.properties.virtual_machine_profile
            virtual_machine_profile.diagnostics_profile = AAZObjectType(
                serialized_name="diagnosticsProfile",
            )
            virtual_machine_profile.eviction_policy = AAZStrType(
                serialized_name="evictionPolicy",
            )
            virtual_machine_profile.extension_profile = AAZObjectType(
                serialized_name="extensionProfile",
            )
            virtual_machine_profile.license_type = AAZStrType(
                serialized_name="licenseType",
            )
            virtual_machine_profile.network_profile = AAZObjectType(
                serialized_name="networkProfile",
            )
            virtual_machine_profile.os_profile = AAZObjectType(
                serialized_name="osProfile",
            )
            virtual_machine_profile.priority = AAZStrType()
            virtual_machine_profile.storage_profile = AAZObjectType(
                serialized_name="storageProfile",
            )

            diagnostics_profile = cls._schema_on_200.value.Element.properties.virtual_machine_profile.diagnostics_profile
            diagnostics_profile.boot_diagnostics = AAZObjectType(
                serialized_name="bootDiagnostics",
            )

            boot_diagnostics = cls._schema_on_200.value.Element.properties.virtual_machine_profile.diagnostics_profile.boot_diagnostics
            boot_diagnostics.enabled = AAZBoolType()
            boot_diagnostics.storage_uri = AAZStrType(
                serialized_name="storageUri",
            )

            extension_profile = cls._schema_on_200.value.Element.properties.virtual_machine_profile.extension_profile
            extension_profile.extensions = AAZListType()

            extensions = cls._schema_on_200.value.Element.properties.virtual_machine_profile.extension_profile.extensions
            extensions.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.extension_profile.extensions.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200.value.Element.properties.virtual_machine_profile.extension_profile.extensions.Element.properties
            properties.auto_upgrade_minor_version = AAZBoolType(
                serialized_name="autoUpgradeMinorVersion",
            )
            properties.force_update_tag = AAZStrType(
                serialized_name="forceUpdateTag",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.publisher = AAZStrType()
            properties.type = AAZStrType()
            properties.type_handler_version = AAZStrType(
                serialized_name="typeHandlerVersion",
            )

            network_profile = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile
            network_profile.health_probe = AAZObjectType(
                serialized_name="healthProbe",
            )
            _ListHelper._build_schema_api_entity_reference_read(network_profile.health_probe)
            network_profile.network_interface_configurations = AAZListType(
                serialized_name="networkInterfaceConfigurations",
            )

            network_interface_configurations = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations
            network_interface_configurations.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element
            _element.id = AAZStrType()
            _element.name = AAZStrType(
                flags={"required": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties
            properties.dns_settings = AAZObjectType(
                serialized_name="dnsSettings",
            )
            properties.enable_accelerated_networking = AAZBoolType(
                serialized_name="enableAcceleratedNetworking",
            )
            properties.enable_ip_forwarding = AAZBoolType(
                serialized_name="enableIPForwarding",
            )
            properties.ip_configurations = AAZListType(
                serialized_name="ipConfigurations",
                flags={"required": True},
            )
            properties.network_security_group = AAZObjectType(
                serialized_name="networkSecurityGroup",
            )
            _ListHelper._build_schema_sub_resource_read(properties.network_security_group)
            properties.primary = AAZBoolType()

            dns_settings = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.dns_settings
            dns_settings.dns_servers = AAZListType(
                serialized_name="dnsServers",
            )

            dns_servers = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.dns_settings.dns_servers
            dns_servers.Element = AAZStrType()

            ip_configurations = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations
            ip_configurations.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element
            _element.id = AAZStrType()
            _element.name = AAZStrType(
                flags={"required": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties
            properties.application_gateway_backend_address_pools = AAZListType(
                serialized_name="applicationGatewayBackendAddressPools",
            )
            properties.load_balancer_backend_address_pools = AAZListType(
                serialized_name="loadBalancerBackendAddressPools",
            )
            properties.load_balancer_inbound_nat_pools = AAZListType(
                serialized_name="loadBalancerInboundNatPools",
            )
            properties.primary = AAZBoolType()
            properties.private_ip_address_version = AAZStrType(
                serialized_name="privateIPAddressVersion",
            )
            properties.public_ip_address_configuration = AAZObjectType(
                serialized_name="publicIPAddressConfiguration",
            )
            properties.subnet = AAZObjectType()
            _ListHelper._build_schema_api_entity_reference_read(properties.subnet)

            application_gateway_backend_address_pools = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.application_gateway_backend_address_pools
            application_gateway_backend_address_pools.Element = AAZObjectType()
            _ListHelper._build_schema_sub_resource_read(application_gateway_backend_address_pools.Element)

            load_balancer_backend_address_pools = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.load_balancer_backend_address_pools
            load_balancer_backend_address_pools.Element = AAZObjectType()
            _ListHelper._build_schema_sub_resource_read(load_balancer_backend_address_pools.Element)

            load_balancer_inbound_nat_pools = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.load_balancer_inbound_nat_pools
            load_balancer_inbound_nat_pools.Element = AAZObjectType()
            _ListHelper._build_schema_sub_resource_read(load_balancer_inbound_nat_pools.Element)

            public_ip_address_configuration = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration
            public_ip_address_configuration.name = AAZStrType(
                flags={"required": True},
            )
            public_ip_address_configuration.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties
            properties.dns_settings = AAZObjectType(
                serialized_name="dnsSettings",
            )
            properties.idle_timeout_in_minutes = AAZIntType(
                serialized_name="idleTimeoutInMinutes",
            )

            dns_settings = cls._schema_on_200.value.Element.properties.virtual_machine_profile.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties.dns_settings
            dns_settings.domain_name_label = AAZStrType(
                serialized_name="domainNameLabel",
                flags={"required": True},
            )

            os_profile = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile
            os_profile.admin_password = AAZStrType(
                serialized_name="adminPassword",
            )
            os_profile.admin_username = AAZStrType(
                serialized_name="adminUsername",
            )
            os_profile.computer_name_prefix = AAZStrType(
                serialized_name="computerNamePrefix",
            )
            os_profile.custom_data = AAZStrType(
                serialized_name="customData",
            )
            os_profile.linux_configuration = AAZObjectType(
                serialized_name="linuxConfiguration",
            )
            os_profile.secrets = AAZListType()
            os_profile.windows_configuration = AAZObjectType(
                serialized_name="windowsConfiguration",
            )

            linux_configuration = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.linux_configuration
            linux_configuration.disable_password_authentication = AAZBoolType(
                serialized_name="disablePasswordAuthentication",
            )
            linux_configuration.ssh = AAZObjectType()

            ssh = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.linux_configuration.ssh
            ssh.public_keys = AAZListType(
                serialized_name="publicKeys",
            )

            public_keys = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.linux_configuration.ssh.public_keys
            public_keys.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.linux_configuration.ssh.public_keys.Element
            _element.key_data = AAZStrType(
                serialized_name="keyData",
            )
            _element.path = AAZStrType()

            secrets = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.secrets
            secrets.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.secrets.Element
            _element.source_vault = AAZObjectType(
                serialized_name="sourceVault",
            )
            _ListHelper._build_schema_sub_resource_read(_element.source_vault)
            _element.vault_certificates = AAZListType(
                serialized_name="vaultCertificates",
            )

            vault_certificates = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.secrets.Element.vault_certificates
            vault_certificates.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.secrets.Element.vault_certificates.Element
            _element.certificate_store = AAZStrType(
                serialized_name="certificateStore",
            )
            _element.certificate_url = AAZStrType(
                serialized_name="certificateUrl",
            )

            windows_configuration = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.windows_configuration
            windows_configuration.additional_unattend_content = AAZListType(
                serialized_name="additionalUnattendContent",
            )
            windows_configuration.enable_automatic_updates = AAZBoolType(
                serialized_name="enableAutomaticUpdates",
            )
            windows_configuration.provision_vm_agent = AAZBoolType(
                serialized_name="provisionVMAgent",
            )
            windows_configuration.time_zone = AAZStrType(
                serialized_name="timeZone",
            )
            windows_configuration.win_rm = AAZObjectType(
                serialized_name="winRM",
            )

            additional_unattend_content = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.windows_configuration.additional_unattend_content
            additional_unattend_content.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.windows_configuration.additional_unattend_content.Element
            _element.component_name = AAZStrType(
                serialized_name="componentName",
            )
            _element.content = AAZStrType()
            _element.pass_name = AAZStrType(
                serialized_name="passName",
            )
            _element.setting_name = AAZStrType(
                serialized_name="settingName",
            )

            win_rm = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.windows_configuration.win_rm
            win_rm.listeners = AAZListType()

            listeners = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.windows_configuration.win_rm.listeners
            listeners.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.os_profile.windows_configuration.win_rm.listeners.Element
            _element.certificate_url = AAZStrType(
                serialized_name="certificateUrl",
            )
            _element.protocol = AAZStrType()

            storage_profile = cls._schema_on_200.value.Element.properties.virtual_machine_profile.storage_profile
            storage_profile.data_disks = AAZListType(
                serialized_name="dataDisks",
            )
            storage_profile.image_reference = AAZObjectType(
                serialized_name="imageReference",
            )
            storage_profile.os_disk = AAZObjectType(
                serialized_name="osDisk",
            )

            data_disks = cls._schema_on_200.value.Element.properties.virtual_machine_profile.storage_profile.data_disks
            data_disks.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.virtual_machine_profile.storage_profile.data_disks.Element
            _element.caching = AAZStrType()
            _element.create_option = AAZStrType(
                serialized_name="createOption",
                flags={"required": True},
            )
            _element.disk_size_gb = AAZIntType(
                serialized_name="diskSizeGB",
            )
            _element.lun = AAZIntType(
                flags={"required": True},
            )
            _element.managed_disk = AAZObjectType(
                serialized_name="managedDisk",
            )
            _ListHelper._build_schema_virtual_machine_scale_set_managed_disk_parameters_read(_element.managed_disk)
            _element.name = AAZStrType()
            _element.write_accelerator_enabled = AAZBoolType(
                serialized_name="writeAcceleratorEnabled",
            )

            image_reference = cls._schema_on_200.value.Element.properties.virtual_machine_profile.storage_profile.image_reference
            image_reference.id = AAZStrType()
            image_reference.offer = AAZStrType()
            image_reference.publisher = AAZStrType()
            image_reference.sku = AAZStrType()
            image_reference.version = AAZStrType()

            os_disk = cls._schema_on_200.value.Element.properties.virtual_machine_profile.storage_profile.os_disk
            os_disk.caching = AAZStrType()
            os_disk.create_option = AAZStrType(
                serialized_name="createOption",
                flags={"required": True},
            )
            os_disk.image = AAZObjectType()
            os_disk.managed_disk = AAZObjectType(
                serialized_name="managedDisk",
            )
            _ListHelper._build_schema_virtual_machine_scale_set_managed_disk_parameters_read(os_disk.managed_disk)
            os_disk.name = AAZStrType()
            os_disk.os_type = AAZStrType(
                serialized_name="osType",
            )
            os_disk.vhd_containers = AAZListType(
                serialized_name="vhdContainers",
            )
            os_disk.write_accelerator_enabled = AAZBoolType(
                serialized_name="writeAcceleratorEnabled",
            )

            image = cls._schema_on_200.value.Element.properties.virtual_machine_profile.storage_profile.os_disk.image
            image.uri = AAZStrType()

            vhd_containers = cls._schema_on_200.value.Element.properties.virtual_machine_profile.storage_profile.os_disk.vhd_containers
            vhd_containers.Element = AAZStrType()

            sku = cls._schema_on_200.value.Element.sku
            sku.capacity = AAZIntType()
            sku.name = AAZStrType()
            sku.tier = AAZStrType()

            tags = cls._schema_on_200.value.Element.tags
            tags.Element = AAZStrType()

            zones = cls._schema_on_200.value.Element.zones
            zones.Element = AAZStrType()

            return cls._schema_on_200


class _ListHelper:
    """Helper class for List"""

    _schema_api_entity_reference_read = None

    @classmethod
    def _build_schema_api_entity_reference_read(cls, _schema):
        if cls._schema_api_entity_reference_read is not None:
            _schema.id = cls._schema_api_entity_reference_read.id
            return

        cls._schema_api_entity_reference_read = _schema_api_entity_reference_read = AAZObjectType()

        api_entity_reference_read = _schema_api_entity_reference_read
        api_entity_reference_read.id = AAZStrType()

        _schema.id = cls._schema_api_entity_reference_read.id

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id

    _schema_virtual_machine_scale_set_managed_disk_parameters_read = None

    @classmethod
    def _build_schema_virtual_machine_scale_set_managed_disk_parameters_read(cls, _schema):
        if cls._schema_virtual_machine_scale_set_managed_disk_parameters_read is not None:
            _schema.storage_account_type = cls._schema_virtual_machine_scale_set_managed_disk_parameters_read.storage_account_type
            return

        cls._schema_virtual_machine_scale_set_managed_disk_parameters_read = _schema_virtual_machine_scale_set_managed_disk_parameters_read = AAZObjectType()

        virtual_machine_scale_set_managed_disk_parameters_read = _schema_virtual_machine_scale_set_managed_disk_parameters_read
        virtual_machine_scale_set_managed_disk_parameters_read.storage_account_type = AAZStrType(
            serialized_name="storageAccountType",
        )

        _schema.storage_account_type = cls._schema_virtual_machine_scale_set_managed_disk_parameters_read.storage_account_type


__all__ = ["List"]
