// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Describes the primary or replica key in a multi-Region key.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MultiRegionKey {
    /// <p>Displays the key ARN of a primary or replica key of a multi-Region key.</p>
    pub arn: ::std::option::Option<::std::string::String>,
    /// <p>Displays the Amazon Web Services Region of a primary or replica key in a multi-Region key.</p>
    pub region: ::std::option::Option<::std::string::String>,
}
impl MultiRegionKey {
    /// <p>Displays the key ARN of a primary or replica key of a multi-Region key.</p>
    pub fn arn(&self) -> ::std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Displays the Amazon Web Services Region of a primary or replica key in a multi-Region key.</p>
    pub fn region(&self) -> ::std::option::Option<&str> {
        self.region.as_deref()
    }
}
impl MultiRegionKey {
    /// Creates a new builder-style object to manufacture [`MultiRegionKey`](crate::types::MultiRegionKey).
    pub fn builder() -> crate::types::builders::MultiRegionKeyBuilder {
        crate::types::builders::MultiRegionKeyBuilder::default()
    }
}

/// A builder for [`MultiRegionKey`](crate::types::MultiRegionKey).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct MultiRegionKeyBuilder {
    pub(crate) arn: ::std::option::Option<::std::string::String>,
    pub(crate) region: ::std::option::Option<::std::string::String>,
}
impl MultiRegionKeyBuilder {
    /// <p>Displays the key ARN of a primary or replica key of a multi-Region key.</p>
    pub fn arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Displays the key ARN of a primary or replica key of a multi-Region key.</p>
    pub fn set_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.arn = input;
        self
    }
    /// <p>Displays the key ARN of a primary or replica key of a multi-Region key.</p>
    pub fn get_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.arn
    }
    /// <p>Displays the Amazon Web Services Region of a primary or replica key in a multi-Region key.</p>
    pub fn region(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.region = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Displays the Amazon Web Services Region of a primary or replica key in a multi-Region key.</p>
    pub fn set_region(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.region = input;
        self
    }
    /// <p>Displays the Amazon Web Services Region of a primary or replica key in a multi-Region key.</p>
    pub fn get_region(&self) -> &::std::option::Option<::std::string::String> {
        &self.region
    }
    /// Consumes the builder and constructs a [`MultiRegionKey`](crate::types::MultiRegionKey).
    pub fn build(self) -> crate::types::MultiRegionKey {
        crate::types::MultiRegionKey {
            arn: self.arn,
            region: self.region,
        }
    }
}
