// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`RevokeGrant`](crate::operation::revoke_grant::builders::RevokeGrantFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::operation::revoke_grant::builders::RevokeGrantFluentBuilder::key_id) / [`set_key_id(Option<String>)`](crate::operation::revoke_grant::builders::RevokeGrantFluentBuilder::set_key_id):<br>required: **true**<br><p>A unique identifier for the KMS key associated with the grant. To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p> <p>Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN.</p> <p>For example:</p> <ul>  <li>   <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li> </ul> <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p><br>
    ///   - [`grant_id(impl Into<String>)`](crate::operation::revoke_grant::builders::RevokeGrantFluentBuilder::grant_id) / [`set_grant_id(Option<String>)`](crate::operation::revoke_grant::builders::RevokeGrantFluentBuilder::set_grant_id):<br>required: **true**<br><p>Identifies the grant to revoke. To get the grant ID, use <code>CreateGrant</code>, <code>ListGrants</code>, or <code>ListRetirableGrants</code>.</p><br>
    ///   - [`dry_run(bool)`](crate::operation::revoke_grant::builders::RevokeGrantFluentBuilder::dry_run) / [`set_dry_run(Option<bool>)`](crate::operation::revoke_grant::builders::RevokeGrantFluentBuilder::set_dry_run):<br>required: **false**<br><p>Checks if your request will succeed. <code>DryRun</code> is an optional parameter.</p> <p>To learn more about how to use this parameter, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html">Testing your KMS API calls</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    /// - On success, responds with [`RevokeGrantOutput`](crate::operation::revoke_grant::RevokeGrantOutput)
    /// - On failure, responds with [`SdkError<RevokeGrantError>`](crate::operation::revoke_grant::RevokeGrantError)
    pub fn revoke_grant(&self) -> crate::operation::revoke_grant::builders::RevokeGrantFluentBuilder {
        crate::operation::revoke_grant::builders::RevokeGrantFluentBuilder::new(self.handle.clone())
    }
}
