/**
 * Plugin to serialize markdown as HTML.
 *
 * @type {import('unified').Plugin<[Options?]|void[], Root, string>}
 */
export default function remarkHtml(settings?: void | Options | undefined): void
export type Root = import('mdast').Root
export type Schema = import('hast-util-sanitize').Schema
/**
 * Configuration (optional).
 */
export type ExtraOptionsFields = {
  /**
   * How to sanitize the output.
   */
  sanitize?:
    | boolean
    | import('hast-util-sanitize/lib').Schema
    | null
    | undefined
  /**
   * Object mapping mdast nodes to functions handling them.
   */
  handlers?: import('mdast-util-to-hast/lib').Handlers | undefined
}
export type Options = import('hast-util-to-html').Options & ExtraOptionsFields
