/*
 * Decompiled with CFR 0.152.
 */
package com.clarkware.junitperf;

import com.clarkware.junitperf.ConstantTimer;
import com.clarkware.junitperf.LoadTest;
import com.clarkware.junitperf.MockTest;
import com.clarkware.junitperf.TimedTest;
import com.clarkware.junitperf.Timer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TimedTestTest
extends TestCase {
    private Test _oneSecondTest = new MockTest("testOneSecondExecutionTime");
    private Test _oneSecondFailedTest = new MockTest("testOneSecondExecutionTimeWithFailure");
    private Timer _twoSecondDelayTimer = new ConstantTimer(2000L);
    public static final long tolerance = 100L;
    static /* synthetic */ Class class$com$clarkware$junitperf$TimedTestTest;

    public TimedTestTest(String name) {
        super(name);
    }

    public void testOneSecondResponseDefault() {
        TimedTest test = new TimedTest(this._oneSecondTest, 1100L);
        TimedTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)1, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testOneSecondResponseNoWaitForCompletion() {
        TimedTest test = new TimedTest(this._oneSecondTest, 1100L, false);
        TimedTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)1, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testOneSecondResponseWaitForCompletion() {
        TimedTest test = new TimedTest(this._oneSecondTest, 1100L, true);
        TimedTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)1, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testOneSecondResponseFailure() {
        TimedTest test = new TimedTest(this._oneSecondTest, 900L);
        TimedTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)1, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)1, (int)result.failureCount());
    }

    public void testOneSecondResponseOneUserLoadSuccess() {
        LoadTest loadTest = new LoadTest(this._oneSecondTest, 1);
        TimedTest test = new TimedTest(loadTest, 1100L);
        TimedTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)1, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testOneSecondResponseOneUserLoadFailure() {
        LoadTest loadTest = new LoadTest(this._oneSecondTest, 1);
        TimedTest test = new TimedTest(loadTest, 900L);
        TimedTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)1, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)1, (int)result.failureCount());
    }

    public void testOneSecondResponseMultiUserLoadSuccess() {
        LoadTest loadTest = new LoadTest(this._oneSecondTest, 2);
        TimedTest test = new TimedTest(loadTest, 1500L);
        TimedTestTest.assertEquals((int)2, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)2, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testOneSecondResponseMultiUserLoadFailure() {
        LoadTest loadTest = new LoadTest(this._oneSecondTest, 2);
        TimedTest test = new TimedTest(loadTest, 1000L);
        TimedTestTest.assertEquals((int)2, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)2, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)1, (int)result.failureCount());
    }

    public void testOneSecondResponseMultiUserLoadTwoSecondDelaySuccess() {
        LoadTest loadTest = new LoadTest(this._oneSecondTest, 2, this._twoSecondDelayTimer);
        TimedTest test = new TimedTest(loadTest, 4100L);
        TimedTestTest.assertEquals((int)2, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)2, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testOneSecondResponseMultiUserLoadTwoSecondDelayFailure() {
        LoadTest loadTest = new LoadTest(this._oneSecondTest, 2, this._twoSecondDelayTimer);
        TimedTest test = new TimedTest(loadTest, 3800L);
        TimedTestTest.assertEquals((int)2, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)2, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)1, (int)result.failureCount());
    }

    public void testInfiniteNoWaitForCompletion() {
        MockTest mockTest = new MockTest("testInfiniteExecutionTime");
        TimedTest test = new TimedTest((Test)mockTest, 1100L, false);
        TimedTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)1, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)1, (int)result.failureCount());
    }

    public void testLongResponseNoWaitForCompletion() {
        MockTest mockTest = new MockTest("testLongExecutionTime");
        TimedTest test = new TimedTest((Test)mockTest, 2100L, false);
        TimedTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)1, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)1, (int)result.failureCount());
    }

    public void testOneSecondResponseSuccessWaiting() {
        TimedTest test = new TimedTest(this._oneSecondFailedTest, 1100L, true);
        TimedTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)1, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)1, (int)result.failureCount());
    }

    public void testOneSecondResponseSuccessNonWaiting() {
        TimedTest test = new TimedTest(this._oneSecondFailedTest, 1100L, false);
        TimedTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)1, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)1, (int)result.failureCount());
    }

    public void testOneSecondResponseFailureWaiting() {
        TimedTest test = new TimedTest(this._oneSecondFailedTest, 900L, true);
        TimedTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)1, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)2, (int)result.failureCount());
    }

    public void testOneSecondResponseNonWaitingWithAmbiguousFailure() {
        TimedTest test = new TimedTest(this._oneSecondFailedTest, 900L, false);
        TimedTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        TimedTestTest.assertEquals((int)1, (int)result.runCount());
        TimedTestTest.assertEquals((int)0, (int)result.errorCount());
        TimedTestTest.assertEquals((int)1, (int)result.failureCount());
    }

    public void testOneSecondResponseNonWaitingWithTimeFailure() {
        TimedTest test = new TimedTest(this._oneSecondFailedTest, 900L, false);
        TimedTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        if (!test.outOfTime()) {
            TimedTestTest.fail((String)"Max elapsed time exceeded!");
        }
    }

    public void testOneSecondResponseNonWaitingWithTestFailure() {
        TimedTest test = new TimedTest(this._oneSecondFailedTest, 1100L, false);
        TimedTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        if (test.outOfTime()) {
            TimedTestTest.fail((String)"Should never get here!");
        } else {
            TimedTestTest.assertEquals((int)1, (int)result.runCount());
            TimedTestTest.assertEquals((int)0, (int)result.errorCount());
            TimedTestTest.assertEquals((int)1, (int)result.failureCount());
        }
    }

    public static Test suite() {
        return new TestSuite(class$com$clarkware$junitperf$TimedTestTest == null ? (class$com$clarkware$junitperf$TimedTestTest = TimedTestTest.class$("com.clarkware.junitperf.TimedTestTest")) : class$com$clarkware$junitperf$TimedTestTest);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TimedTestTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

