/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/core/v1beta1"
)

// VolumeUploadSourceLister helps list VolumeUploadSources.
// All objects returned here must be treated as read-only.
type VolumeUploadSourceLister interface {
	// List lists all VolumeUploadSources in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.VolumeUploadSource, err error)
	// VolumeUploadSources returns an object that can list and get VolumeUploadSources.
	VolumeUploadSources(namespace string) VolumeUploadSourceNamespaceLister
	VolumeUploadSourceListerExpansion
}

// volumeUploadSourceLister implements the VolumeUploadSourceLister interface.
type volumeUploadSourceLister struct {
	indexer cache.Indexer
}

// NewVolumeUploadSourceLister returns a new VolumeUploadSourceLister.
func NewVolumeUploadSourceLister(indexer cache.Indexer) VolumeUploadSourceLister {
	return &volumeUploadSourceLister{indexer: indexer}
}

// List lists all VolumeUploadSources in the indexer.
func (s *volumeUploadSourceLister) List(selector labels.Selector) (ret []*v1beta1.VolumeUploadSource, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.VolumeUploadSource))
	})
	return ret, err
}

// VolumeUploadSources returns an object that can list and get VolumeUploadSources.
func (s *volumeUploadSourceLister) VolumeUploadSources(namespace string) VolumeUploadSourceNamespaceLister {
	return volumeUploadSourceNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// VolumeUploadSourceNamespaceLister helps list and get VolumeUploadSources.
// All objects returned here must be treated as read-only.
type VolumeUploadSourceNamespaceLister interface {
	// List lists all VolumeUploadSources in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.VolumeUploadSource, err error)
	// Get retrieves the VolumeUploadSource from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1beta1.VolumeUploadSource, error)
	VolumeUploadSourceNamespaceListerExpansion
}

// volumeUploadSourceNamespaceLister implements the VolumeUploadSourceNamespaceLister
// interface.
type volumeUploadSourceNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all VolumeUploadSources in the indexer for a given namespace.
func (s volumeUploadSourceNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.VolumeUploadSource, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.VolumeUploadSource))
	})
	return ret, err
}

// Get retrieves the VolumeUploadSource from the indexer for a given namespace and name.
func (s volumeUploadSourceNamespaceLister) Get(name string) (*v1beta1.VolumeUploadSource, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("volumeuploadsource"), name)
	}
	return obj.(*v1beta1.VolumeUploadSource), nil
}
