/*
Copyright The KubeVirt Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "kubevirt.io/api/pool/v1alpha1"
)

// FakeVirtualMachinePools implements VirtualMachinePoolInterface
type FakeVirtualMachinePools struct {
	Fake *FakePoolV1alpha1
	ns   string
}

var virtualmachinepoolsResource = schema.GroupVersionResource{Group: "pool.kubevirt.io", Version: "v1alpha1", Resource: "virtualmachinepools"}

var virtualmachinepoolsKind = schema.GroupVersionKind{Group: "pool.kubevirt.io", Version: "v1alpha1", Kind: "VirtualMachinePool"}

// Get takes name of the virtualMachinePool, and returns the corresponding virtualMachinePool object, and an error if there is any.
func (c *FakeVirtualMachinePools) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.VirtualMachinePool, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(virtualmachinepoolsResource, c.ns, name), &v1alpha1.VirtualMachinePool{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VirtualMachinePool), err
}

// List takes label and field selectors, and returns the list of VirtualMachinePools that match those selectors.
func (c *FakeVirtualMachinePools) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.VirtualMachinePoolList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(virtualmachinepoolsResource, virtualmachinepoolsKind, c.ns, opts), &v1alpha1.VirtualMachinePoolList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.VirtualMachinePoolList{ListMeta: obj.(*v1alpha1.VirtualMachinePoolList).ListMeta}
	for _, item := range obj.(*v1alpha1.VirtualMachinePoolList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested virtualMachinePools.
func (c *FakeVirtualMachinePools) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(virtualmachinepoolsResource, c.ns, opts))

}

// Create takes the representation of a virtualMachinePool and creates it.  Returns the server's representation of the virtualMachinePool, and an error, if there is any.
func (c *FakeVirtualMachinePools) Create(ctx context.Context, virtualMachinePool *v1alpha1.VirtualMachinePool, opts v1.CreateOptions) (result *v1alpha1.VirtualMachinePool, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(virtualmachinepoolsResource, c.ns, virtualMachinePool), &v1alpha1.VirtualMachinePool{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VirtualMachinePool), err
}

// Update takes the representation of a virtualMachinePool and updates it. Returns the server's representation of the virtualMachinePool, and an error, if there is any.
func (c *FakeVirtualMachinePools) Update(ctx context.Context, virtualMachinePool *v1alpha1.VirtualMachinePool, opts v1.UpdateOptions) (result *v1alpha1.VirtualMachinePool, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(virtualmachinepoolsResource, c.ns, virtualMachinePool), &v1alpha1.VirtualMachinePool{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VirtualMachinePool), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeVirtualMachinePools) UpdateStatus(ctx context.Context, virtualMachinePool *v1alpha1.VirtualMachinePool, opts v1.UpdateOptions) (*v1alpha1.VirtualMachinePool, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(virtualmachinepoolsResource, "status", c.ns, virtualMachinePool), &v1alpha1.VirtualMachinePool{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VirtualMachinePool), err
}

// Delete takes name of the virtualMachinePool and deletes it. Returns an error if one occurs.
func (c *FakeVirtualMachinePools) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(virtualmachinepoolsResource, c.ns, name), &v1alpha1.VirtualMachinePool{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeVirtualMachinePools) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(virtualmachinepoolsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.VirtualMachinePoolList{})
	return err
}

// Patch applies the patch and returns the patched virtualMachinePool.
func (c *FakeVirtualMachinePools) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.VirtualMachinePool, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(virtualmachinepoolsResource, c.ns, name, pt, data, subresources...), &v1alpha1.VirtualMachinePool{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VirtualMachinePool), err
}
