//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The KubeVirt Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha2

import (
	unsafe "unsafe"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	corev1 "kubevirt.io/api/core/v1"
	v1beta1 "kubevirt.io/api/instancetype/v1beta1"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*v1beta1.CPUInstancetype)(nil), (*CPUInstancetype)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_CPUInstancetype_To_v1alpha2_CPUInstancetype(a.(*v1beta1.CPUInstancetype), b.(*CPUInstancetype), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CPUInstancetype)(nil), (*v1beta1.CPUInstancetype)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_CPUInstancetype_To_v1beta1_CPUInstancetype(a.(*CPUInstancetype), b.(*v1beta1.CPUInstancetype), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ClockPreferences)(nil), (*ClockPreferences)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClockPreferences_To_v1alpha2_ClockPreferences(a.(*v1beta1.ClockPreferences), b.(*ClockPreferences), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClockPreferences)(nil), (*v1beta1.ClockPreferences)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ClockPreferences_To_v1beta1_ClockPreferences(a.(*ClockPreferences), b.(*v1beta1.ClockPreferences), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*DevicePreferences)(nil), (*v1beta1.DevicePreferences)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_DevicePreferences_To_v1beta1_DevicePreferences(a.(*DevicePreferences), b.(*v1beta1.DevicePreferences), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.FeaturePreferences)(nil), (*FeaturePreferences)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_FeaturePreferences_To_v1alpha2_FeaturePreferences(a.(*v1beta1.FeaturePreferences), b.(*FeaturePreferences), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*FeaturePreferences)(nil), (*v1beta1.FeaturePreferences)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_FeaturePreferences_To_v1beta1_FeaturePreferences(a.(*FeaturePreferences), b.(*v1beta1.FeaturePreferences), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.FirmwarePreferences)(nil), (*FirmwarePreferences)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_FirmwarePreferences_To_v1alpha2_FirmwarePreferences(a.(*v1beta1.FirmwarePreferences), b.(*FirmwarePreferences), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*FirmwarePreferences)(nil), (*v1beta1.FirmwarePreferences)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_FirmwarePreferences_To_v1beta1_FirmwarePreferences(a.(*FirmwarePreferences), b.(*v1beta1.FirmwarePreferences), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachinePreferences)(nil), (*MachinePreferences)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachinePreferences_To_v1alpha2_MachinePreferences(a.(*v1beta1.MachinePreferences), b.(*MachinePreferences), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachinePreferences)(nil), (*v1beta1.MachinePreferences)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_MachinePreferences_To_v1beta1_MachinePreferences(a.(*MachinePreferences), b.(*v1beta1.MachinePreferences), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MemoryInstancetype)(nil), (*v1beta1.MemoryInstancetype)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_MemoryInstancetype_To_v1beta1_MemoryInstancetype(a.(*MemoryInstancetype), b.(*v1beta1.MemoryInstancetype), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.VirtualMachineClusterInstancetype)(nil), (*VirtualMachineClusterInstancetype)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_VirtualMachineClusterInstancetype_To_v1alpha2_VirtualMachineClusterInstancetype(a.(*v1beta1.VirtualMachineClusterInstancetype), b.(*VirtualMachineClusterInstancetype), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VirtualMachineClusterInstancetype)(nil), (*v1beta1.VirtualMachineClusterInstancetype)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_VirtualMachineClusterInstancetype_To_v1beta1_VirtualMachineClusterInstancetype(a.(*VirtualMachineClusterInstancetype), b.(*v1beta1.VirtualMachineClusterInstancetype), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.VirtualMachineClusterInstancetypeList)(nil), (*VirtualMachineClusterInstancetypeList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_VirtualMachineClusterInstancetypeList_To_v1alpha2_VirtualMachineClusterInstancetypeList(a.(*v1beta1.VirtualMachineClusterInstancetypeList), b.(*VirtualMachineClusterInstancetypeList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VirtualMachineClusterInstancetypeList)(nil), (*v1beta1.VirtualMachineClusterInstancetypeList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_VirtualMachineClusterInstancetypeList_To_v1beta1_VirtualMachineClusterInstancetypeList(a.(*VirtualMachineClusterInstancetypeList), b.(*v1beta1.VirtualMachineClusterInstancetypeList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.VirtualMachineClusterPreference)(nil), (*VirtualMachineClusterPreference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_VirtualMachineClusterPreference_To_v1alpha2_VirtualMachineClusterPreference(a.(*v1beta1.VirtualMachineClusterPreference), b.(*VirtualMachineClusterPreference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VirtualMachineClusterPreference)(nil), (*v1beta1.VirtualMachineClusterPreference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_VirtualMachineClusterPreference_To_v1beta1_VirtualMachineClusterPreference(a.(*VirtualMachineClusterPreference), b.(*v1beta1.VirtualMachineClusterPreference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.VirtualMachineClusterPreferenceList)(nil), (*VirtualMachineClusterPreferenceList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_VirtualMachineClusterPreferenceList_To_v1alpha2_VirtualMachineClusterPreferenceList(a.(*v1beta1.VirtualMachineClusterPreferenceList), b.(*VirtualMachineClusterPreferenceList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VirtualMachineClusterPreferenceList)(nil), (*v1beta1.VirtualMachineClusterPreferenceList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_VirtualMachineClusterPreferenceList_To_v1beta1_VirtualMachineClusterPreferenceList(a.(*VirtualMachineClusterPreferenceList), b.(*v1beta1.VirtualMachineClusterPreferenceList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.VirtualMachineInstancetype)(nil), (*VirtualMachineInstancetype)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_VirtualMachineInstancetype_To_v1alpha2_VirtualMachineInstancetype(a.(*v1beta1.VirtualMachineInstancetype), b.(*VirtualMachineInstancetype), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VirtualMachineInstancetype)(nil), (*v1beta1.VirtualMachineInstancetype)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_VirtualMachineInstancetype_To_v1beta1_VirtualMachineInstancetype(a.(*VirtualMachineInstancetype), b.(*v1beta1.VirtualMachineInstancetype), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.VirtualMachineInstancetypeList)(nil), (*VirtualMachineInstancetypeList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_VirtualMachineInstancetypeList_To_v1alpha2_VirtualMachineInstancetypeList(a.(*v1beta1.VirtualMachineInstancetypeList), b.(*VirtualMachineInstancetypeList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VirtualMachineInstancetypeList)(nil), (*v1beta1.VirtualMachineInstancetypeList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_VirtualMachineInstancetypeList_To_v1beta1_VirtualMachineInstancetypeList(a.(*VirtualMachineInstancetypeList), b.(*v1beta1.VirtualMachineInstancetypeList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VirtualMachineInstancetypeSpec)(nil), (*v1beta1.VirtualMachineInstancetypeSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_VirtualMachineInstancetypeSpec_To_v1beta1_VirtualMachineInstancetypeSpec(a.(*VirtualMachineInstancetypeSpec), b.(*v1beta1.VirtualMachineInstancetypeSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.VirtualMachinePreference)(nil), (*VirtualMachinePreference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_VirtualMachinePreference_To_v1alpha2_VirtualMachinePreference(a.(*v1beta1.VirtualMachinePreference), b.(*VirtualMachinePreference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VirtualMachinePreference)(nil), (*v1beta1.VirtualMachinePreference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_VirtualMachinePreference_To_v1beta1_VirtualMachinePreference(a.(*VirtualMachinePreference), b.(*v1beta1.VirtualMachinePreference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.VirtualMachinePreferenceList)(nil), (*VirtualMachinePreferenceList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_VirtualMachinePreferenceList_To_v1alpha2_VirtualMachinePreferenceList(a.(*v1beta1.VirtualMachinePreferenceList), b.(*VirtualMachinePreferenceList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VirtualMachinePreferenceList)(nil), (*v1beta1.VirtualMachinePreferenceList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_VirtualMachinePreferenceList_To_v1beta1_VirtualMachinePreferenceList(a.(*VirtualMachinePreferenceList), b.(*v1beta1.VirtualMachinePreferenceList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VirtualMachinePreferenceSpec)(nil), (*v1beta1.VirtualMachinePreferenceSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_VirtualMachinePreferenceSpec_To_v1beta1_VirtualMachinePreferenceSpec(a.(*VirtualMachinePreferenceSpec), b.(*v1beta1.VirtualMachinePreferenceSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.VolumePreferences)(nil), (*VolumePreferences)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_VolumePreferences_To_v1alpha2_VolumePreferences(a.(*v1beta1.VolumePreferences), b.(*VolumePreferences), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VolumePreferences)(nil), (*v1beta1.VolumePreferences)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_VolumePreferences_To_v1beta1_VolumePreferences(a.(*VolumePreferences), b.(*v1beta1.VolumePreferences), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*CPUPreferences)(nil), (*v1beta1.CPUPreferences)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_CPUPreferences_To_v1beta1_CPUPreferences(a.(*CPUPreferences), b.(*v1beta1.CPUPreferences), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.CPUPreferences)(nil), (*CPUPreferences)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_CPUPreferences_To_v1alpha2_CPUPreferences(a.(*v1beta1.CPUPreferences), b.(*CPUPreferences), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.DevicePreferences)(nil), (*DevicePreferences)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DevicePreferences_To_v1alpha2_DevicePreferences(a.(*v1beta1.DevicePreferences), b.(*DevicePreferences), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.MemoryInstancetype)(nil), (*MemoryInstancetype)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MemoryInstancetype_To_v1alpha2_MemoryInstancetype(a.(*v1beta1.MemoryInstancetype), b.(*MemoryInstancetype), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.VirtualMachineInstancetypeSpec)(nil), (*VirtualMachineInstancetypeSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_VirtualMachineInstancetypeSpec_To_v1alpha2_VirtualMachineInstancetypeSpec(a.(*v1beta1.VirtualMachineInstancetypeSpec), b.(*VirtualMachineInstancetypeSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.VirtualMachinePreferenceSpec)(nil), (*VirtualMachinePreferenceSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_VirtualMachinePreferenceSpec_To_v1alpha2_VirtualMachinePreferenceSpec(a.(*v1beta1.VirtualMachinePreferenceSpec), b.(*VirtualMachinePreferenceSpec), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1beta1_CPUInstancetype_To_v1alpha2_CPUInstancetype(in *v1beta1.CPUInstancetype, out *CPUInstancetype, s conversion.Scope) error {
	out.Guest = in.Guest
	if err := v1.Convert_Pointer_string_To_string(&in.Model, &out.Model, s); err != nil {
		return err
	}
	if err := v1.Convert_Pointer_bool_To_bool(&in.DedicatedCPUPlacement, &out.DedicatedCPUPlacement, s); err != nil {
		return err
	}
	out.NUMA = (*corev1.NUMA)(unsafe.Pointer(in.NUMA))
	if err := v1.Convert_Pointer_bool_To_bool(&in.IsolateEmulatorThread, &out.IsolateEmulatorThread, s); err != nil {
		return err
	}
	out.Realtime = (*corev1.Realtime)(unsafe.Pointer(in.Realtime))
	return nil
}

// Convert_v1beta1_CPUInstancetype_To_v1alpha2_CPUInstancetype is an autogenerated conversion function.
func Convert_v1beta1_CPUInstancetype_To_v1alpha2_CPUInstancetype(in *v1beta1.CPUInstancetype, out *CPUInstancetype, s conversion.Scope) error {
	return autoConvert_v1beta1_CPUInstancetype_To_v1alpha2_CPUInstancetype(in, out, s)
}

func autoConvert_v1alpha2_CPUInstancetype_To_v1beta1_CPUInstancetype(in *CPUInstancetype, out *v1beta1.CPUInstancetype, s conversion.Scope) error {
	out.Guest = in.Guest
	if err := v1.Convert_string_To_Pointer_string(&in.Model, &out.Model, s); err != nil {
		return err
	}
	if err := v1.Convert_bool_To_Pointer_bool(&in.DedicatedCPUPlacement, &out.DedicatedCPUPlacement, s); err != nil {
		return err
	}
	out.NUMA = (*corev1.NUMA)(unsafe.Pointer(in.NUMA))
	if err := v1.Convert_bool_To_Pointer_bool(&in.IsolateEmulatorThread, &out.IsolateEmulatorThread, s); err != nil {
		return err
	}
	out.Realtime = (*corev1.Realtime)(unsafe.Pointer(in.Realtime))
	return nil
}

// Convert_v1alpha2_CPUInstancetype_To_v1beta1_CPUInstancetype is an autogenerated conversion function.
func Convert_v1alpha2_CPUInstancetype_To_v1beta1_CPUInstancetype(in *CPUInstancetype, out *v1beta1.CPUInstancetype, s conversion.Scope) error {
	return autoConvert_v1alpha2_CPUInstancetype_To_v1beta1_CPUInstancetype(in, out, s)
}

func autoConvert_v1beta1_CPUPreferences_To_v1alpha2_CPUPreferences(in *v1beta1.CPUPreferences, out *CPUPreferences, s conversion.Scope) error {
	// WARNING: in.PreferredCPUTopology requires manual conversion: inconvertible types (*kubevirt.io/api/instancetype/v1beta1.PreferredCPUTopology vs kubevirt.io/api/instancetype/v1alpha2.PreferredCPUTopology)
	// WARNING: in.PreferredCPUFeatures requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha2_CPUPreferences_To_v1beta1_CPUPreferences(in *CPUPreferences, out *v1beta1.CPUPreferences, s conversion.Scope) error {
	// WARNING: in.PreferredCPUTopology requires manual conversion: inconvertible types (kubevirt.io/api/instancetype/v1alpha2.PreferredCPUTopology vs *kubevirt.io/api/instancetype/v1beta1.PreferredCPUTopology)
	return nil
}

func autoConvert_v1beta1_ClockPreferences_To_v1alpha2_ClockPreferences(in *v1beta1.ClockPreferences, out *ClockPreferences, s conversion.Scope) error {
	out.PreferredClockOffset = (*corev1.ClockOffset)(unsafe.Pointer(in.PreferredClockOffset))
	out.PreferredTimer = (*corev1.Timer)(unsafe.Pointer(in.PreferredTimer))
	return nil
}

// Convert_v1beta1_ClockPreferences_To_v1alpha2_ClockPreferences is an autogenerated conversion function.
func Convert_v1beta1_ClockPreferences_To_v1alpha2_ClockPreferences(in *v1beta1.ClockPreferences, out *ClockPreferences, s conversion.Scope) error {
	return autoConvert_v1beta1_ClockPreferences_To_v1alpha2_ClockPreferences(in, out, s)
}

func autoConvert_v1alpha2_ClockPreferences_To_v1beta1_ClockPreferences(in *ClockPreferences, out *v1beta1.ClockPreferences, s conversion.Scope) error {
	out.PreferredClockOffset = (*corev1.ClockOffset)(unsafe.Pointer(in.PreferredClockOffset))
	out.PreferredTimer = (*corev1.Timer)(unsafe.Pointer(in.PreferredTimer))
	return nil
}

// Convert_v1alpha2_ClockPreferences_To_v1beta1_ClockPreferences is an autogenerated conversion function.
func Convert_v1alpha2_ClockPreferences_To_v1beta1_ClockPreferences(in *ClockPreferences, out *v1beta1.ClockPreferences, s conversion.Scope) error {
	return autoConvert_v1alpha2_ClockPreferences_To_v1beta1_ClockPreferences(in, out, s)
}

func autoConvert_v1beta1_DevicePreferences_To_v1alpha2_DevicePreferences(in *v1beta1.DevicePreferences, out *DevicePreferences, s conversion.Scope) error {
	out.PreferredAutoattachGraphicsDevice = (*bool)(unsafe.Pointer(in.PreferredAutoattachGraphicsDevice))
	out.PreferredAutoattachMemBalloon = (*bool)(unsafe.Pointer(in.PreferredAutoattachMemBalloon))
	out.PreferredAutoattachPodInterface = (*bool)(unsafe.Pointer(in.PreferredAutoattachPodInterface))
	out.PreferredAutoattachSerialConsole = (*bool)(unsafe.Pointer(in.PreferredAutoattachSerialConsole))
	out.PreferredAutoattachInputDevice = (*bool)(unsafe.Pointer(in.PreferredAutoattachInputDevice))
	out.PreferredDisableHotplug = (*bool)(unsafe.Pointer(in.PreferredDisableHotplug))
	out.PreferredVirtualGPUOptions = (*corev1.VGPUOptions)(unsafe.Pointer(in.PreferredVirtualGPUOptions))
	out.PreferredSoundModel = in.PreferredSoundModel
	out.PreferredUseVirtioTransitional = (*bool)(unsafe.Pointer(in.PreferredUseVirtioTransitional))
	out.PreferredInputBus = corev1.InputBus(in.PreferredInputBus)
	out.PreferredInputType = corev1.InputType(in.PreferredInputType)
	out.PreferredDiskBus = corev1.DiskBus(in.PreferredDiskBus)
	out.PreferredLunBus = corev1.DiskBus(in.PreferredLunBus)
	out.PreferredCdromBus = corev1.DiskBus(in.PreferredCdromBus)
	out.PreferredDiskDedicatedIoThread = (*bool)(unsafe.Pointer(in.PreferredDiskDedicatedIoThread))
	out.PreferredDiskCache = corev1.DriverCache(in.PreferredDiskCache)
	out.PreferredDiskIO = corev1.DriverIO(in.PreferredDiskIO)
	out.PreferredDiskBlockSize = (*corev1.BlockSize)(unsafe.Pointer(in.PreferredDiskBlockSize))
	out.PreferredInterfaceModel = in.PreferredInterfaceModel
	out.PreferredRng = (*corev1.Rng)(unsafe.Pointer(in.PreferredRng))
	out.PreferredBlockMultiQueue = (*bool)(unsafe.Pointer(in.PreferredBlockMultiQueue))
	out.PreferredNetworkInterfaceMultiQueue = (*bool)(unsafe.Pointer(in.PreferredNetworkInterfaceMultiQueue))
	out.PreferredTPM = (*corev1.TPMDevice)(unsafe.Pointer(in.PreferredTPM))
	// WARNING: in.PreferredInterfaceMasquerade requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha2_DevicePreferences_To_v1beta1_DevicePreferences(in *DevicePreferences, out *v1beta1.DevicePreferences, s conversion.Scope) error {
	out.PreferredAutoattachGraphicsDevice = (*bool)(unsafe.Pointer(in.PreferredAutoattachGraphicsDevice))
	out.PreferredAutoattachMemBalloon = (*bool)(unsafe.Pointer(in.PreferredAutoattachMemBalloon))
	out.PreferredAutoattachPodInterface = (*bool)(unsafe.Pointer(in.PreferredAutoattachPodInterface))
	out.PreferredAutoattachSerialConsole = (*bool)(unsafe.Pointer(in.PreferredAutoattachSerialConsole))
	out.PreferredAutoattachInputDevice = (*bool)(unsafe.Pointer(in.PreferredAutoattachInputDevice))
	out.PreferredDisableHotplug = (*bool)(unsafe.Pointer(in.PreferredDisableHotplug))
	out.PreferredVirtualGPUOptions = (*corev1.VGPUOptions)(unsafe.Pointer(in.PreferredVirtualGPUOptions))
	out.PreferredSoundModel = in.PreferredSoundModel
	out.PreferredUseVirtioTransitional = (*bool)(unsafe.Pointer(in.PreferredUseVirtioTransitional))
	out.PreferredInputBus = corev1.InputBus(in.PreferredInputBus)
	out.PreferredInputType = corev1.InputType(in.PreferredInputType)
	out.PreferredDiskBus = corev1.DiskBus(in.PreferredDiskBus)
	out.PreferredLunBus = corev1.DiskBus(in.PreferredLunBus)
	out.PreferredCdromBus = corev1.DiskBus(in.PreferredCdromBus)
	out.PreferredDiskDedicatedIoThread = (*bool)(unsafe.Pointer(in.PreferredDiskDedicatedIoThread))
	out.PreferredDiskCache = corev1.DriverCache(in.PreferredDiskCache)
	out.PreferredDiskIO = corev1.DriverIO(in.PreferredDiskIO)
	out.PreferredDiskBlockSize = (*corev1.BlockSize)(unsafe.Pointer(in.PreferredDiskBlockSize))
	out.PreferredInterfaceModel = in.PreferredInterfaceModel
	out.PreferredRng = (*corev1.Rng)(unsafe.Pointer(in.PreferredRng))
	out.PreferredBlockMultiQueue = (*bool)(unsafe.Pointer(in.PreferredBlockMultiQueue))
	out.PreferredNetworkInterfaceMultiQueue = (*bool)(unsafe.Pointer(in.PreferredNetworkInterfaceMultiQueue))
	out.PreferredTPM = (*corev1.TPMDevice)(unsafe.Pointer(in.PreferredTPM))
	return nil
}

// Convert_v1alpha2_DevicePreferences_To_v1beta1_DevicePreferences is an autogenerated conversion function.
func Convert_v1alpha2_DevicePreferences_To_v1beta1_DevicePreferences(in *DevicePreferences, out *v1beta1.DevicePreferences, s conversion.Scope) error {
	return autoConvert_v1alpha2_DevicePreferences_To_v1beta1_DevicePreferences(in, out, s)
}

func autoConvert_v1beta1_FeaturePreferences_To_v1alpha2_FeaturePreferences(in *v1beta1.FeaturePreferences, out *FeaturePreferences, s conversion.Scope) error {
	out.PreferredAcpi = (*corev1.FeatureState)(unsafe.Pointer(in.PreferredAcpi))
	out.PreferredApic = (*corev1.FeatureAPIC)(unsafe.Pointer(in.PreferredApic))
	out.PreferredHyperv = (*corev1.FeatureHyperv)(unsafe.Pointer(in.PreferredHyperv))
	out.PreferredKvm = (*corev1.FeatureKVM)(unsafe.Pointer(in.PreferredKvm))
	out.PreferredPvspinlock = (*corev1.FeatureState)(unsafe.Pointer(in.PreferredPvspinlock))
	out.PreferredSmm = (*corev1.FeatureState)(unsafe.Pointer(in.PreferredSmm))
	return nil
}

// Convert_v1beta1_FeaturePreferences_To_v1alpha2_FeaturePreferences is an autogenerated conversion function.
func Convert_v1beta1_FeaturePreferences_To_v1alpha2_FeaturePreferences(in *v1beta1.FeaturePreferences, out *FeaturePreferences, s conversion.Scope) error {
	return autoConvert_v1beta1_FeaturePreferences_To_v1alpha2_FeaturePreferences(in, out, s)
}

func autoConvert_v1alpha2_FeaturePreferences_To_v1beta1_FeaturePreferences(in *FeaturePreferences, out *v1beta1.FeaturePreferences, s conversion.Scope) error {
	out.PreferredAcpi = (*corev1.FeatureState)(unsafe.Pointer(in.PreferredAcpi))
	out.PreferredApic = (*corev1.FeatureAPIC)(unsafe.Pointer(in.PreferredApic))
	out.PreferredHyperv = (*corev1.FeatureHyperv)(unsafe.Pointer(in.PreferredHyperv))
	out.PreferredKvm = (*corev1.FeatureKVM)(unsafe.Pointer(in.PreferredKvm))
	out.PreferredPvspinlock = (*corev1.FeatureState)(unsafe.Pointer(in.PreferredPvspinlock))
	out.PreferredSmm = (*corev1.FeatureState)(unsafe.Pointer(in.PreferredSmm))
	return nil
}

// Convert_v1alpha2_FeaturePreferences_To_v1beta1_FeaturePreferences is an autogenerated conversion function.
func Convert_v1alpha2_FeaturePreferences_To_v1beta1_FeaturePreferences(in *FeaturePreferences, out *v1beta1.FeaturePreferences, s conversion.Scope) error {
	return autoConvert_v1alpha2_FeaturePreferences_To_v1beta1_FeaturePreferences(in, out, s)
}

func autoConvert_v1beta1_FirmwarePreferences_To_v1alpha2_FirmwarePreferences(in *v1beta1.FirmwarePreferences, out *FirmwarePreferences, s conversion.Scope) error {
	out.PreferredUseBios = (*bool)(unsafe.Pointer(in.PreferredUseBios))
	out.PreferredUseBiosSerial = (*bool)(unsafe.Pointer(in.PreferredUseBiosSerial))
	out.PreferredUseEfi = (*bool)(unsafe.Pointer(in.PreferredUseEfi))
	out.PreferredUseSecureBoot = (*bool)(unsafe.Pointer(in.PreferredUseSecureBoot))
	return nil
}

// Convert_v1beta1_FirmwarePreferences_To_v1alpha2_FirmwarePreferences is an autogenerated conversion function.
func Convert_v1beta1_FirmwarePreferences_To_v1alpha2_FirmwarePreferences(in *v1beta1.FirmwarePreferences, out *FirmwarePreferences, s conversion.Scope) error {
	return autoConvert_v1beta1_FirmwarePreferences_To_v1alpha2_FirmwarePreferences(in, out, s)
}

func autoConvert_v1alpha2_FirmwarePreferences_To_v1beta1_FirmwarePreferences(in *FirmwarePreferences, out *v1beta1.FirmwarePreferences, s conversion.Scope) error {
	out.PreferredUseBios = (*bool)(unsafe.Pointer(in.PreferredUseBios))
	out.PreferredUseBiosSerial = (*bool)(unsafe.Pointer(in.PreferredUseBiosSerial))
	out.PreferredUseEfi = (*bool)(unsafe.Pointer(in.PreferredUseEfi))
	out.PreferredUseSecureBoot = (*bool)(unsafe.Pointer(in.PreferredUseSecureBoot))
	return nil
}

// Convert_v1alpha2_FirmwarePreferences_To_v1beta1_FirmwarePreferences is an autogenerated conversion function.
func Convert_v1alpha2_FirmwarePreferences_To_v1beta1_FirmwarePreferences(in *FirmwarePreferences, out *v1beta1.FirmwarePreferences, s conversion.Scope) error {
	return autoConvert_v1alpha2_FirmwarePreferences_To_v1beta1_FirmwarePreferences(in, out, s)
}

func autoConvert_v1beta1_MachinePreferences_To_v1alpha2_MachinePreferences(in *v1beta1.MachinePreferences, out *MachinePreferences, s conversion.Scope) error {
	out.PreferredMachineType = in.PreferredMachineType
	return nil
}

// Convert_v1beta1_MachinePreferences_To_v1alpha2_MachinePreferences is an autogenerated conversion function.
func Convert_v1beta1_MachinePreferences_To_v1alpha2_MachinePreferences(in *v1beta1.MachinePreferences, out *MachinePreferences, s conversion.Scope) error {
	return autoConvert_v1beta1_MachinePreferences_To_v1alpha2_MachinePreferences(in, out, s)
}

func autoConvert_v1alpha2_MachinePreferences_To_v1beta1_MachinePreferences(in *MachinePreferences, out *v1beta1.MachinePreferences, s conversion.Scope) error {
	out.PreferredMachineType = in.PreferredMachineType
	return nil
}

// Convert_v1alpha2_MachinePreferences_To_v1beta1_MachinePreferences is an autogenerated conversion function.
func Convert_v1alpha2_MachinePreferences_To_v1beta1_MachinePreferences(in *MachinePreferences, out *v1beta1.MachinePreferences, s conversion.Scope) error {
	return autoConvert_v1alpha2_MachinePreferences_To_v1beta1_MachinePreferences(in, out, s)
}

func autoConvert_v1beta1_MemoryInstancetype_To_v1alpha2_MemoryInstancetype(in *v1beta1.MemoryInstancetype, out *MemoryInstancetype, s conversion.Scope) error {
	out.Guest = in.Guest
	out.Hugepages = (*corev1.Hugepages)(unsafe.Pointer(in.Hugepages))
	// WARNING: in.OvercommitPercent requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha2_MemoryInstancetype_To_v1beta1_MemoryInstancetype(in *MemoryInstancetype, out *v1beta1.MemoryInstancetype, s conversion.Scope) error {
	out.Guest = in.Guest
	out.Hugepages = (*corev1.Hugepages)(unsafe.Pointer(in.Hugepages))
	return nil
}

// Convert_v1alpha2_MemoryInstancetype_To_v1beta1_MemoryInstancetype is an autogenerated conversion function.
func Convert_v1alpha2_MemoryInstancetype_To_v1beta1_MemoryInstancetype(in *MemoryInstancetype, out *v1beta1.MemoryInstancetype, s conversion.Scope) error {
	return autoConvert_v1alpha2_MemoryInstancetype_To_v1beta1_MemoryInstancetype(in, out, s)
}

func autoConvert_v1beta1_VirtualMachineClusterInstancetype_To_v1alpha2_VirtualMachineClusterInstancetype(in *v1beta1.VirtualMachineClusterInstancetype, out *VirtualMachineClusterInstancetype, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_VirtualMachineInstancetypeSpec_To_v1alpha2_VirtualMachineInstancetypeSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_VirtualMachineClusterInstancetype_To_v1alpha2_VirtualMachineClusterInstancetype is an autogenerated conversion function.
func Convert_v1beta1_VirtualMachineClusterInstancetype_To_v1alpha2_VirtualMachineClusterInstancetype(in *v1beta1.VirtualMachineClusterInstancetype, out *VirtualMachineClusterInstancetype, s conversion.Scope) error {
	return autoConvert_v1beta1_VirtualMachineClusterInstancetype_To_v1alpha2_VirtualMachineClusterInstancetype(in, out, s)
}

func autoConvert_v1alpha2_VirtualMachineClusterInstancetype_To_v1beta1_VirtualMachineClusterInstancetype(in *VirtualMachineClusterInstancetype, out *v1beta1.VirtualMachineClusterInstancetype, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_VirtualMachineInstancetypeSpec_To_v1beta1_VirtualMachineInstancetypeSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_VirtualMachineClusterInstancetype_To_v1beta1_VirtualMachineClusterInstancetype is an autogenerated conversion function.
func Convert_v1alpha2_VirtualMachineClusterInstancetype_To_v1beta1_VirtualMachineClusterInstancetype(in *VirtualMachineClusterInstancetype, out *v1beta1.VirtualMachineClusterInstancetype, s conversion.Scope) error {
	return autoConvert_v1alpha2_VirtualMachineClusterInstancetype_To_v1beta1_VirtualMachineClusterInstancetype(in, out, s)
}

func autoConvert_v1beta1_VirtualMachineClusterInstancetypeList_To_v1alpha2_VirtualMachineClusterInstancetypeList(in *v1beta1.VirtualMachineClusterInstancetypeList, out *VirtualMachineClusterInstancetypeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]VirtualMachineClusterInstancetype, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_VirtualMachineClusterInstancetype_To_v1alpha2_VirtualMachineClusterInstancetype(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_VirtualMachineClusterInstancetypeList_To_v1alpha2_VirtualMachineClusterInstancetypeList is an autogenerated conversion function.
func Convert_v1beta1_VirtualMachineClusterInstancetypeList_To_v1alpha2_VirtualMachineClusterInstancetypeList(in *v1beta1.VirtualMachineClusterInstancetypeList, out *VirtualMachineClusterInstancetypeList, s conversion.Scope) error {
	return autoConvert_v1beta1_VirtualMachineClusterInstancetypeList_To_v1alpha2_VirtualMachineClusterInstancetypeList(in, out, s)
}

func autoConvert_v1alpha2_VirtualMachineClusterInstancetypeList_To_v1beta1_VirtualMachineClusterInstancetypeList(in *VirtualMachineClusterInstancetypeList, out *v1beta1.VirtualMachineClusterInstancetypeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.VirtualMachineClusterInstancetype, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_VirtualMachineClusterInstancetype_To_v1beta1_VirtualMachineClusterInstancetype(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha2_VirtualMachineClusterInstancetypeList_To_v1beta1_VirtualMachineClusterInstancetypeList is an autogenerated conversion function.
func Convert_v1alpha2_VirtualMachineClusterInstancetypeList_To_v1beta1_VirtualMachineClusterInstancetypeList(in *VirtualMachineClusterInstancetypeList, out *v1beta1.VirtualMachineClusterInstancetypeList, s conversion.Scope) error {
	return autoConvert_v1alpha2_VirtualMachineClusterInstancetypeList_To_v1beta1_VirtualMachineClusterInstancetypeList(in, out, s)
}

func autoConvert_v1beta1_VirtualMachineClusterPreference_To_v1alpha2_VirtualMachineClusterPreference(in *v1beta1.VirtualMachineClusterPreference, out *VirtualMachineClusterPreference, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_VirtualMachinePreferenceSpec_To_v1alpha2_VirtualMachinePreferenceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_VirtualMachineClusterPreference_To_v1alpha2_VirtualMachineClusterPreference is an autogenerated conversion function.
func Convert_v1beta1_VirtualMachineClusterPreference_To_v1alpha2_VirtualMachineClusterPreference(in *v1beta1.VirtualMachineClusterPreference, out *VirtualMachineClusterPreference, s conversion.Scope) error {
	return autoConvert_v1beta1_VirtualMachineClusterPreference_To_v1alpha2_VirtualMachineClusterPreference(in, out, s)
}

func autoConvert_v1alpha2_VirtualMachineClusterPreference_To_v1beta1_VirtualMachineClusterPreference(in *VirtualMachineClusterPreference, out *v1beta1.VirtualMachineClusterPreference, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_VirtualMachinePreferenceSpec_To_v1beta1_VirtualMachinePreferenceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_VirtualMachineClusterPreference_To_v1beta1_VirtualMachineClusterPreference is an autogenerated conversion function.
func Convert_v1alpha2_VirtualMachineClusterPreference_To_v1beta1_VirtualMachineClusterPreference(in *VirtualMachineClusterPreference, out *v1beta1.VirtualMachineClusterPreference, s conversion.Scope) error {
	return autoConvert_v1alpha2_VirtualMachineClusterPreference_To_v1beta1_VirtualMachineClusterPreference(in, out, s)
}

func autoConvert_v1beta1_VirtualMachineClusterPreferenceList_To_v1alpha2_VirtualMachineClusterPreferenceList(in *v1beta1.VirtualMachineClusterPreferenceList, out *VirtualMachineClusterPreferenceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]VirtualMachineClusterPreference, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_VirtualMachineClusterPreference_To_v1alpha2_VirtualMachineClusterPreference(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_VirtualMachineClusterPreferenceList_To_v1alpha2_VirtualMachineClusterPreferenceList is an autogenerated conversion function.
func Convert_v1beta1_VirtualMachineClusterPreferenceList_To_v1alpha2_VirtualMachineClusterPreferenceList(in *v1beta1.VirtualMachineClusterPreferenceList, out *VirtualMachineClusterPreferenceList, s conversion.Scope) error {
	return autoConvert_v1beta1_VirtualMachineClusterPreferenceList_To_v1alpha2_VirtualMachineClusterPreferenceList(in, out, s)
}

func autoConvert_v1alpha2_VirtualMachineClusterPreferenceList_To_v1beta1_VirtualMachineClusterPreferenceList(in *VirtualMachineClusterPreferenceList, out *v1beta1.VirtualMachineClusterPreferenceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.VirtualMachineClusterPreference, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_VirtualMachineClusterPreference_To_v1beta1_VirtualMachineClusterPreference(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha2_VirtualMachineClusterPreferenceList_To_v1beta1_VirtualMachineClusterPreferenceList is an autogenerated conversion function.
func Convert_v1alpha2_VirtualMachineClusterPreferenceList_To_v1beta1_VirtualMachineClusterPreferenceList(in *VirtualMachineClusterPreferenceList, out *v1beta1.VirtualMachineClusterPreferenceList, s conversion.Scope) error {
	return autoConvert_v1alpha2_VirtualMachineClusterPreferenceList_To_v1beta1_VirtualMachineClusterPreferenceList(in, out, s)
}

func autoConvert_v1beta1_VirtualMachineInstancetype_To_v1alpha2_VirtualMachineInstancetype(in *v1beta1.VirtualMachineInstancetype, out *VirtualMachineInstancetype, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_VirtualMachineInstancetypeSpec_To_v1alpha2_VirtualMachineInstancetypeSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_VirtualMachineInstancetype_To_v1alpha2_VirtualMachineInstancetype is an autogenerated conversion function.
func Convert_v1beta1_VirtualMachineInstancetype_To_v1alpha2_VirtualMachineInstancetype(in *v1beta1.VirtualMachineInstancetype, out *VirtualMachineInstancetype, s conversion.Scope) error {
	return autoConvert_v1beta1_VirtualMachineInstancetype_To_v1alpha2_VirtualMachineInstancetype(in, out, s)
}

func autoConvert_v1alpha2_VirtualMachineInstancetype_To_v1beta1_VirtualMachineInstancetype(in *VirtualMachineInstancetype, out *v1beta1.VirtualMachineInstancetype, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_VirtualMachineInstancetypeSpec_To_v1beta1_VirtualMachineInstancetypeSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_VirtualMachineInstancetype_To_v1beta1_VirtualMachineInstancetype is an autogenerated conversion function.
func Convert_v1alpha2_VirtualMachineInstancetype_To_v1beta1_VirtualMachineInstancetype(in *VirtualMachineInstancetype, out *v1beta1.VirtualMachineInstancetype, s conversion.Scope) error {
	return autoConvert_v1alpha2_VirtualMachineInstancetype_To_v1beta1_VirtualMachineInstancetype(in, out, s)
}

func autoConvert_v1beta1_VirtualMachineInstancetypeList_To_v1alpha2_VirtualMachineInstancetypeList(in *v1beta1.VirtualMachineInstancetypeList, out *VirtualMachineInstancetypeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]VirtualMachineInstancetype, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_VirtualMachineInstancetype_To_v1alpha2_VirtualMachineInstancetype(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_VirtualMachineInstancetypeList_To_v1alpha2_VirtualMachineInstancetypeList is an autogenerated conversion function.
func Convert_v1beta1_VirtualMachineInstancetypeList_To_v1alpha2_VirtualMachineInstancetypeList(in *v1beta1.VirtualMachineInstancetypeList, out *VirtualMachineInstancetypeList, s conversion.Scope) error {
	return autoConvert_v1beta1_VirtualMachineInstancetypeList_To_v1alpha2_VirtualMachineInstancetypeList(in, out, s)
}

func autoConvert_v1alpha2_VirtualMachineInstancetypeList_To_v1beta1_VirtualMachineInstancetypeList(in *VirtualMachineInstancetypeList, out *v1beta1.VirtualMachineInstancetypeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.VirtualMachineInstancetype, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_VirtualMachineInstancetype_To_v1beta1_VirtualMachineInstancetype(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha2_VirtualMachineInstancetypeList_To_v1beta1_VirtualMachineInstancetypeList is an autogenerated conversion function.
func Convert_v1alpha2_VirtualMachineInstancetypeList_To_v1beta1_VirtualMachineInstancetypeList(in *VirtualMachineInstancetypeList, out *v1beta1.VirtualMachineInstancetypeList, s conversion.Scope) error {
	return autoConvert_v1alpha2_VirtualMachineInstancetypeList_To_v1beta1_VirtualMachineInstancetypeList(in, out, s)
}

func autoConvert_v1beta1_VirtualMachineInstancetypeSpec_To_v1alpha2_VirtualMachineInstancetypeSpec(in *v1beta1.VirtualMachineInstancetypeSpec, out *VirtualMachineInstancetypeSpec, s conversion.Scope) error {
	// WARNING: in.NodeSelector requires manual conversion: does not exist in peer-type
	// WARNING: in.SchedulerName requires manual conversion: does not exist in peer-type
	if err := Convert_v1beta1_CPUInstancetype_To_v1alpha2_CPUInstancetype(&in.CPU, &out.CPU, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_MemoryInstancetype_To_v1alpha2_MemoryInstancetype(&in.Memory, &out.Memory, s); err != nil {
		return err
	}
	out.GPUs = *(*[]corev1.GPU)(unsafe.Pointer(&in.GPUs))
	out.HostDevices = *(*[]corev1.HostDevice)(unsafe.Pointer(&in.HostDevices))
	out.IOThreadsPolicy = (*corev1.IOThreadsPolicy)(unsafe.Pointer(in.IOThreadsPolicy))
	out.LaunchSecurity = (*corev1.LaunchSecurity)(unsafe.Pointer(in.LaunchSecurity))
	// WARNING: in.Annotations requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha2_VirtualMachineInstancetypeSpec_To_v1beta1_VirtualMachineInstancetypeSpec(in *VirtualMachineInstancetypeSpec, out *v1beta1.VirtualMachineInstancetypeSpec, s conversion.Scope) error {
	if err := Convert_v1alpha2_CPUInstancetype_To_v1beta1_CPUInstancetype(&in.CPU, &out.CPU, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_MemoryInstancetype_To_v1beta1_MemoryInstancetype(&in.Memory, &out.Memory, s); err != nil {
		return err
	}
	out.GPUs = *(*[]corev1.GPU)(unsafe.Pointer(&in.GPUs))
	out.HostDevices = *(*[]corev1.HostDevice)(unsafe.Pointer(&in.HostDevices))
	out.IOThreadsPolicy = (*corev1.IOThreadsPolicy)(unsafe.Pointer(in.IOThreadsPolicy))
	out.LaunchSecurity = (*corev1.LaunchSecurity)(unsafe.Pointer(in.LaunchSecurity))
	return nil
}

// Convert_v1alpha2_VirtualMachineInstancetypeSpec_To_v1beta1_VirtualMachineInstancetypeSpec is an autogenerated conversion function.
func Convert_v1alpha2_VirtualMachineInstancetypeSpec_To_v1beta1_VirtualMachineInstancetypeSpec(in *VirtualMachineInstancetypeSpec, out *v1beta1.VirtualMachineInstancetypeSpec, s conversion.Scope) error {
	return autoConvert_v1alpha2_VirtualMachineInstancetypeSpec_To_v1beta1_VirtualMachineInstancetypeSpec(in, out, s)
}

func autoConvert_v1beta1_VirtualMachinePreference_To_v1alpha2_VirtualMachinePreference(in *v1beta1.VirtualMachinePreference, out *VirtualMachinePreference, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_VirtualMachinePreferenceSpec_To_v1alpha2_VirtualMachinePreferenceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_VirtualMachinePreference_To_v1alpha2_VirtualMachinePreference is an autogenerated conversion function.
func Convert_v1beta1_VirtualMachinePreference_To_v1alpha2_VirtualMachinePreference(in *v1beta1.VirtualMachinePreference, out *VirtualMachinePreference, s conversion.Scope) error {
	return autoConvert_v1beta1_VirtualMachinePreference_To_v1alpha2_VirtualMachinePreference(in, out, s)
}

func autoConvert_v1alpha2_VirtualMachinePreference_To_v1beta1_VirtualMachinePreference(in *VirtualMachinePreference, out *v1beta1.VirtualMachinePreference, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_VirtualMachinePreferenceSpec_To_v1beta1_VirtualMachinePreferenceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_VirtualMachinePreference_To_v1beta1_VirtualMachinePreference is an autogenerated conversion function.
func Convert_v1alpha2_VirtualMachinePreference_To_v1beta1_VirtualMachinePreference(in *VirtualMachinePreference, out *v1beta1.VirtualMachinePreference, s conversion.Scope) error {
	return autoConvert_v1alpha2_VirtualMachinePreference_To_v1beta1_VirtualMachinePreference(in, out, s)
}

func autoConvert_v1beta1_VirtualMachinePreferenceList_To_v1alpha2_VirtualMachinePreferenceList(in *v1beta1.VirtualMachinePreferenceList, out *VirtualMachinePreferenceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]VirtualMachinePreference, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_VirtualMachinePreference_To_v1alpha2_VirtualMachinePreference(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_VirtualMachinePreferenceList_To_v1alpha2_VirtualMachinePreferenceList is an autogenerated conversion function.
func Convert_v1beta1_VirtualMachinePreferenceList_To_v1alpha2_VirtualMachinePreferenceList(in *v1beta1.VirtualMachinePreferenceList, out *VirtualMachinePreferenceList, s conversion.Scope) error {
	return autoConvert_v1beta1_VirtualMachinePreferenceList_To_v1alpha2_VirtualMachinePreferenceList(in, out, s)
}

func autoConvert_v1alpha2_VirtualMachinePreferenceList_To_v1beta1_VirtualMachinePreferenceList(in *VirtualMachinePreferenceList, out *v1beta1.VirtualMachinePreferenceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.VirtualMachinePreference, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_VirtualMachinePreference_To_v1beta1_VirtualMachinePreference(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha2_VirtualMachinePreferenceList_To_v1beta1_VirtualMachinePreferenceList is an autogenerated conversion function.
func Convert_v1alpha2_VirtualMachinePreferenceList_To_v1beta1_VirtualMachinePreferenceList(in *VirtualMachinePreferenceList, out *v1beta1.VirtualMachinePreferenceList, s conversion.Scope) error {
	return autoConvert_v1alpha2_VirtualMachinePreferenceList_To_v1beta1_VirtualMachinePreferenceList(in, out, s)
}

func autoConvert_v1beta1_VirtualMachinePreferenceSpec_To_v1alpha2_VirtualMachinePreferenceSpec(in *v1beta1.VirtualMachinePreferenceSpec, out *VirtualMachinePreferenceSpec, s conversion.Scope) error {
	out.Clock = (*ClockPreferences)(unsafe.Pointer(in.Clock))
	if in.CPU != nil {
		in, out := &in.CPU, &out.CPU
		*out = new(CPUPreferences)
		if err := Convert_v1beta1_CPUPreferences_To_v1alpha2_CPUPreferences(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CPU = nil
	}
	if in.Devices != nil {
		in, out := &in.Devices, &out.Devices
		*out = new(DevicePreferences)
		if err := Convert_v1beta1_DevicePreferences_To_v1alpha2_DevicePreferences(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Devices = nil
	}
	out.Features = (*FeaturePreferences)(unsafe.Pointer(in.Features))
	out.Firmware = (*FirmwarePreferences)(unsafe.Pointer(in.Firmware))
	out.Machine = (*MachinePreferences)(unsafe.Pointer(in.Machine))
	out.Volumes = (*VolumePreferences)(unsafe.Pointer(in.Volumes))
	// WARNING: in.PreferredSubdomain requires manual conversion: does not exist in peer-type
	// WARNING: in.PreferredTerminationGracePeriodSeconds requires manual conversion: does not exist in peer-type
	// WARNING: in.Requirements requires manual conversion: does not exist in peer-type
	// WARNING: in.Annotations requires manual conversion: does not exist in peer-type
	// WARNING: in.PreferSpreadSocketToCoreRatio requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha2_VirtualMachinePreferenceSpec_To_v1beta1_VirtualMachinePreferenceSpec(in *VirtualMachinePreferenceSpec, out *v1beta1.VirtualMachinePreferenceSpec, s conversion.Scope) error {
	out.Clock = (*v1beta1.ClockPreferences)(unsafe.Pointer(in.Clock))
	if in.CPU != nil {
		in, out := &in.CPU, &out.CPU
		*out = new(v1beta1.CPUPreferences)
		if err := Convert_v1alpha2_CPUPreferences_To_v1beta1_CPUPreferences(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CPU = nil
	}
	if in.Devices != nil {
		in, out := &in.Devices, &out.Devices
		*out = new(v1beta1.DevicePreferences)
		if err := Convert_v1alpha2_DevicePreferences_To_v1beta1_DevicePreferences(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Devices = nil
	}
	out.Features = (*v1beta1.FeaturePreferences)(unsafe.Pointer(in.Features))
	out.Firmware = (*v1beta1.FirmwarePreferences)(unsafe.Pointer(in.Firmware))
	out.Machine = (*v1beta1.MachinePreferences)(unsafe.Pointer(in.Machine))
	out.Volumes = (*v1beta1.VolumePreferences)(unsafe.Pointer(in.Volumes))
	return nil
}

// Convert_v1alpha2_VirtualMachinePreferenceSpec_To_v1beta1_VirtualMachinePreferenceSpec is an autogenerated conversion function.
func Convert_v1alpha2_VirtualMachinePreferenceSpec_To_v1beta1_VirtualMachinePreferenceSpec(in *VirtualMachinePreferenceSpec, out *v1beta1.VirtualMachinePreferenceSpec, s conversion.Scope) error {
	return autoConvert_v1alpha2_VirtualMachinePreferenceSpec_To_v1beta1_VirtualMachinePreferenceSpec(in, out, s)
}

func autoConvert_v1beta1_VolumePreferences_To_v1alpha2_VolumePreferences(in *v1beta1.VolumePreferences, out *VolumePreferences, s conversion.Scope) error {
	out.PreferredStorageClassName = in.PreferredStorageClassName
	return nil
}

// Convert_v1beta1_VolumePreferences_To_v1alpha2_VolumePreferences is an autogenerated conversion function.
func Convert_v1beta1_VolumePreferences_To_v1alpha2_VolumePreferences(in *v1beta1.VolumePreferences, out *VolumePreferences, s conversion.Scope) error {
	return autoConvert_v1beta1_VolumePreferences_To_v1alpha2_VolumePreferences(in, out, s)
}

func autoConvert_v1alpha2_VolumePreferences_To_v1beta1_VolumePreferences(in *VolumePreferences, out *v1beta1.VolumePreferences, s conversion.Scope) error {
	out.PreferredStorageClassName = in.PreferredStorageClassName
	return nil
}

// Convert_v1alpha2_VolumePreferences_To_v1beta1_VolumePreferences is an autogenerated conversion function.
func Convert_v1alpha2_VolumePreferences_To_v1beta1_VolumePreferences(in *VolumePreferences, out *v1beta1.VolumePreferences, s conversion.Scope) error {
	return autoConvert_v1alpha2_VolumePreferences_To_v1beta1_VolumePreferences(in, out, s)
}
