// Copyright (c) Microsoft Corporation.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception


// Copyright 2018 Ulf Adams
// Copyright (c) Microsoft Corporation. All rights reserved.

// Boost Software License - Version 1.0 - August 17th, 2003

// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:

// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.


// This file contains test cases derived from:
// https://github.com/ulfjack/ryu
// See xcharconv_ryu.h for the exact commit.
// (Keep the cgmanifest.json commitHash in sync.)


#ifndef DOUBLE_SCIENTIFIC_PRECISION_TO_CHARS_TEST_CASES_1_HPP
#define DOUBLE_SCIENTIFIC_PRECISION_TO_CHARS_TEST_CASES_1_HPP

#include <charconv>

#include "test.hpp"
using namespace std;

inline constexpr DoublePrecisionToCharsTestCase double_scientific_precision_to_chars_test_cases_1[] = {
    // Test special cases (zero, inf, nan) and an ordinary case. Also test negative signs.
    {0.0, chars_format::scientific, 4, "0.0000e+00"},
    {-0.0, chars_format::scientific, 4, "-0.0000e+00"},
    {double_inf, chars_format::scientific, 4, "inf"},
    {-double_inf, chars_format::scientific, 4, "-inf"},
    {double_nan, chars_format::scientific, 4, "nan"},
    {-double_nan, chars_format::scientific, 4, "-nan(ind)"},
    {double_nan_payload, chars_format::scientific, 4, "nan"},
    {-double_nan_payload, chars_format::scientific, 4, "-nan"},
    {1.729, chars_format::scientific, 4, "1.7290e+00"},
    {-1.729, chars_format::scientific, 4, "-1.7290e+00"},

    // Ryu Printf d2fixed_test.cc D2expTest Basic
    {0x1.000000001869fp+211, chars_format::scientific, 62,
        "3.29100911471548643542566484557342614975886952410844652587974656e+63"},

    // Ryu Printf d2fixed_test.cc D2expTest Zero
    {0.0, chars_format::scientific, 4, "0.0000e+00"},
    {0.0, chars_format::scientific, 3, "0.000e+00"},
    {0.0, chars_format::scientific, 2, "0.00e+00"},
    {0.0, chars_format::scientific, 1, "0.0e+00"},
    {0.0, chars_format::scientific, 0, "0e+00"},

    // Ryu Printf d2fixed_test.cc D2expTest MinMax
    {0x0.0000000000001p-1022, chars_format::scientific, 750,
        "4.9406564584124654417656879286822137236505980261432476442558568250067550727020875186529983"
        "636163599237979656469544571773092665671035593979639877479601078187812630071319031140452784"
        "581716784898210368871863605699873072305000638740915356498438731247339727316961514003171538"
        "539807412623856559117102665855668676818703956031062493194527159149245532930545654440112748"
        "012970999954193198940908041656332452475714786901472678015935523861155013480352649347201937"
        "902681071074917033322268447533357208324319360923828934583680601060115061698097530783422773"
        "183292479049825247307763759272478746560847782037344696995336470179726777175851256605511991"
        "315048911014510378627381672509558373897335989936648099411642057026370902792427675445652290"
        "87538682506419718265533447265625e-324"},

    {0x1.fffffffffffffp+1023, chars_format::scientific, 308,
        "1.7976931348623157081452742373170435679807056752584499659891747680315726078002853876058955"
        "863276687817154045895351438246423432132688946418276846754670353751698604991057655128207624"
        "549009038932894407586850845513394230458323690322294816580855933212334827479782620414472316"
        "8738177180919299881250404026184124858368e+308"},

    // Test more corner cases.
    {0x0.fffffffffffffp-1022, chars_format::scientific, 766,
        "2."
        "2250738585072008890245868760858598876504231122409594654935248025624400092282356951787758888037591552642309"
        "7809504343120858773871583572918219930202943792242235598198275012420417889695713117910822610439719796040004"
        "5489739193807919893608152561311337614984204327175103362739154978273159414382813627511383860409424946494228"
        "6316695429105080201815926642134996606517803095075913058719846423906068637102005108723282784678843631944515"
        "8661350412234790147923695852083215976210663754016137365830441936037147783553066828345356340050740730401356"
        "0296804637591858316312422452159926254649430083685186171942241764645513713542013221703137049658321015465406"
        "8035397417906022589503023501937519773030945763173210852507299305089761582519159720757232455434770912461317"
        "493580281734466552734375e-308"}, // max subnormal
    {0x1p-1022, chars_format::scientific, 714,
        "2."
        "2250738585072013830902327173324040642192159804623318305533274168872044348139181958542831590125110205640673"
        "3973103581100515243416155346010885601238537771882113077799353200233047961014744258363607192156504694250373"
        "4208375250806650616658158948720491179968591639648500635908770118304874799780887753749949451580451605050915"
        "3998565824708186451135379358049921159810857660519924333521143523901487956996095912888916029926415110634663"
        "1339366347758651302937176204732563178148566435087212282863764204484681140761391147706280168985324411002416"
        "1447421618567166150540154285084716752901903161322778896729707373123334086988983175067838846926092773977972"
        "858659654941091369095406136467568702398678315290680984617210924625396728515625e-308"}, // min normal

    // Ryu Printf d2fixed_test.cc D2expTest RoundToEven
    {0.125, chars_format::scientific, 2, "1.25e-01"},
    {0.125, chars_format::scientific, 1, "1.2e-01"},
    {0.375, chars_format::scientific, 2, "3.75e-01"},
    {0.375, chars_format::scientific, 1, "3.8e-01"},

    // Ryu Printf d2fixed_test.cc D2expTest RoundToEvenInteger
    {2.5, chars_format::scientific, 1, "2.5e+00"},
    {2.5, chars_format::scientific, 0, "2e+00"},
    {3.5, chars_format::scientific, 1, "3.5e+00"},
    {3.5, chars_format::scientific, 0, "4e+00"},

    // Ryu Printf d2fixed_test.cc D2expTest NonRoundToEvenScenarios
    {0.748046875, chars_format::scientific, 2, "7.48e-01"},
    {0.748046875, chars_format::scientific, 1, "7.5e-01"},
    {0.748046875, chars_format::scientific, 0, "7e-01"}, // 0.75 would round to "8e-01", but this is smaller

    {0.2509765625, chars_format::scientific, 2, "2.51e-01"},
    {0.2509765625, chars_format::scientific, 1, "2.5e-01"},
    {0.2509765625, chars_format::scientific, 0, "3e-01"}, // 0.25 would round to "2e-01", but this is larger

    {0x1.0000000000001p-2, chars_format::scientific, 53, "2.50000000000000055511151231257827021181583404541015625e-01"},
    {0x1.0000000000001p-2, chars_format::scientific, 2, "2.50e-01"},
    {0x1.0000000000001p-2, chars_format::scientific, 1, "2.5e-01"},
    {0x1.0000000000001p-2, chars_format::scientific, 0,
        "3e-01"}, // 0.25 would round to "2e-01", but this is larger (again)

    // More rounding tests.
    {9.5, chars_format::scientific, 1, "9.5e+00"},
    {9.5, chars_format::scientific, 0, "1e+01"},
    {10.5, chars_format::scientific, 2, "1.05e+01"},
    {10.5, chars_format::scientific, 1, "1.0e+01"},

    {1.241, chars_format::scientific, 3, "1.241e+00"},
    {1.241, chars_format::scientific, 1, "1.2e+00"},
    {1.251, chars_format::scientific, 3, "1.251e+00"},
    {1.251, chars_format::scientific, 1, "1.3e+00"},
    {1.261, chars_format::scientific, 3, "1.261e+00"},
    {1.261, chars_format::scientific, 1, "1.3e+00"},
    {1.341, chars_format::scientific, 3, "1.341e+00"},
    {1.341, chars_format::scientific, 1, "1.3e+00"},
    {1.351, chars_format::scientific, 3, "1.351e+00"},
    {1.351, chars_format::scientific, 1, "1.4e+00"},
    {1.361, chars_format::scientific, 3, "1.361e+00"},
    {1.361, chars_format::scientific, 1, "1.4e+00"},

    {2.41, chars_format::scientific, 2, "2.41e+00"},
    {2.41, chars_format::scientific, 0, "2e+00"},
    {2.51, chars_format::scientific, 2, "2.51e+00"},
    {2.51, chars_format::scientific, 0, "3e+00"},
    {2.61, chars_format::scientific, 2, "2.61e+00"},
    {2.61, chars_format::scientific, 0, "3e+00"},
    {3.41, chars_format::scientific, 2, "3.41e+00"},
    {3.41, chars_format::scientific, 0, "3e+00"},
    {3.51, chars_format::scientific, 2, "3.51e+00"},
    {3.51, chars_format::scientific, 0, "4e+00"},
    {3.61, chars_format::scientific, 2, "3.61e+00"},
    {3.61, chars_format::scientific, 0, "4e+00"},

    // Ryu Printf d2fixed_test.cc D2expTest VaryingPrecision
    {1729.142857142857, chars_format::scientific, 50, "1.72914285714285711037518922239542007446289062500000e+03"},
    {1729.142857142857, chars_format::scientific, 49, "1.7291428571428571103751892223954200744628906250000e+03"},
    {1729.142857142857, chars_format::scientific, 48, "1.729142857142857110375189222395420074462890625000e+03"},
    {1729.142857142857, chars_format::scientific, 47, "1.72914285714285711037518922239542007446289062500e+03"},
    {1729.142857142857, chars_format::scientific, 46, "1.7291428571428571103751892223954200744628906250e+03"},
    {1729.142857142857, chars_format::scientific, 45, "1.729142857142857110375189222395420074462890625e+03"},
    {1729.142857142857, chars_format::scientific, 44, "1.72914285714285711037518922239542007446289062e+03"},
    {1729.142857142857, chars_format::scientific, 43, "1.7291428571428571103751892223954200744628906e+03"},
    {1729.142857142857, chars_format::scientific, 42, "1.729142857142857110375189222395420074462891e+03"},
    {1729.142857142857, chars_format::scientific, 41, "1.72914285714285711037518922239542007446289e+03"},
    {1729.142857142857, chars_format::scientific, 40, "1.7291428571428571103751892223954200744629e+03"},
    {1729.142857142857, chars_format::scientific, 39, "1.729142857142857110375189222395420074463e+03"},
    {1729.142857142857, chars_format::scientific, 38, "1.72914285714285711037518922239542007446e+03"},
    {1729.142857142857, chars_format::scientific, 37, "1.7291428571428571103751892223954200745e+03"},
    {1729.142857142857, chars_format::scientific, 36, "1.729142857142857110375189222395420074e+03"},
    {1729.142857142857, chars_format::scientific, 35, "1.72914285714285711037518922239542007e+03"},
    {1729.142857142857, chars_format::scientific, 34, "1.7291428571428571103751892223954201e+03"},
    {1729.142857142857, chars_format::scientific, 33, "1.729142857142857110375189222395420e+03"},
    {1729.142857142857, chars_format::scientific, 32, "1.72914285714285711037518922239542e+03"},
    {1729.142857142857, chars_format::scientific, 31, "1.7291428571428571103751892223954e+03"},
    {1729.142857142857, chars_format::scientific, 30, "1.729142857142857110375189222395e+03"},
    {1729.142857142857, chars_format::scientific, 29, "1.72914285714285711037518922240e+03"},
    {1729.142857142857, chars_format::scientific, 28, "1.7291428571428571103751892224e+03"},
    {1729.142857142857, chars_format::scientific, 27, "1.729142857142857110375189222e+03"},
    {1729.142857142857, chars_format::scientific, 26, "1.72914285714285711037518922e+03"},
    {1729.142857142857, chars_format::scientific, 25, "1.7291428571428571103751892e+03"},
    {1729.142857142857, chars_format::scientific, 24, "1.729142857142857110375189e+03"},
    {1729.142857142857, chars_format::scientific, 23, "1.72914285714285711037519e+03"},
    {1729.142857142857, chars_format::scientific, 22, "1.7291428571428571103752e+03"},
    {1729.142857142857, chars_format::scientific, 21, "1.729142857142857110375e+03"},
    {1729.142857142857, chars_format::scientific, 20, "1.72914285714285711038e+03"},
    {1729.142857142857, chars_format::scientific, 19, "1.7291428571428571104e+03"},
    {1729.142857142857, chars_format::scientific, 18, "1.729142857142857110e+03"},
    {1729.142857142857, chars_format::scientific, 17, "1.72914285714285711e+03"},
    {1729.142857142857, chars_format::scientific, 16, "1.7291428571428571e+03"},
    {1729.142857142857, chars_format::scientific, 15, "1.729142857142857e+03"},
    {1729.142857142857, chars_format::scientific, 14, "1.72914285714286e+03"},
    {1729.142857142857, chars_format::scientific, 13, "1.7291428571429e+03"},
    {1729.142857142857, chars_format::scientific, 12, "1.729142857143e+03"},
    {1729.142857142857, chars_format::scientific, 11, "1.72914285714e+03"},
    {1729.142857142857, chars_format::scientific, 10, "1.7291428571e+03"},
    {1729.142857142857, chars_format::scientific, 9, "1.729142857e+03"},
    {1729.142857142857, chars_format::scientific, 8, "1.72914286e+03"},
    {1729.142857142857, chars_format::scientific, 7, "1.7291429e+03"},
    {1729.142857142857, chars_format::scientific, 6, "1.729143e+03"},
    {1729.142857142857, chars_format::scientific, 5, "1.72914e+03"},
    {1729.142857142857, chars_format::scientific, 4, "1.7291e+03"},
    {1729.142857142857, chars_format::scientific, 3, "1.729e+03"},
    {1729.142857142857, chars_format::scientific, 2, "1.73e+03"},
    {1729.142857142857, chars_format::scientific, 1, "1.7e+03"},
    {1729.142857142857, chars_format::scientific, 0, "2e+03"},

    // Negative precision requests 6 digits of precision.
    {1729.142857142857, chars_format::scientific, -1, "1.729143e+03"},
    {1729.142857142857, chars_format::scientific, -2, "1.729143e+03"},
    {1729.142857142857, chars_format::scientific, -3, "1.729143e+03"},

    // Ryu Printf d2fixed_test.cc D2expTest Carrying
    {2.0009, chars_format::scientific, 4, "2.0009e+00"},
    {2.0009, chars_format::scientific, 3, "2.001e+00"},
    {2.0029, chars_format::scientific, 4, "2.0029e+00"},
    {2.0029, chars_format::scientific, 3, "2.003e+00"},
    {2.0099, chars_format::scientific, 4, "2.0099e+00"},
    {2.0099, chars_format::scientific, 3, "2.010e+00"},
    {2.0299, chars_format::scientific, 4, "2.0299e+00"},
    {2.0299, chars_format::scientific, 3, "2.030e+00"},
    {2.0999, chars_format::scientific, 4, "2.0999e+00"},
    {2.0999, chars_format::scientific, 3, "2.100e+00"},
    {2.2999, chars_format::scientific, 4, "2.2999e+00"},
    {2.2999, chars_format::scientific, 3, "2.300e+00"},
    {2.9999, chars_format::scientific, 4, "2.9999e+00"},
    {2.9999, chars_format::scientific, 3, "3.000e+00"},
    {9.9999, chars_format::scientific, 4, "9.9999e+00"},
    {9.9999, chars_format::scientific, 3, "1.000e+01"},

    {2.09, chars_format::scientific, 2, "2.09e+00"},
    {2.09, chars_format::scientific, 1, "2.1e+00"},
    {2.29, chars_format::scientific, 2, "2.29e+00"},
    {2.29, chars_format::scientific, 1, "2.3e+00"},
    {2.99, chars_format::scientific, 2, "2.99e+00"},
    {2.99, chars_format::scientific, 1, "3.0e+00"},
    {9.99, chars_format::scientific, 2, "9.99e+00"},
    {9.99, chars_format::scientific, 1, "1.0e+01"},

    {2.9, chars_format::scientific, 1, "2.9e+00"},
    {2.9, chars_format::scientific, 0, "3e+00"},
    {9.9, chars_format::scientific, 1, "9.9e+00"},
    {9.9, chars_format::scientific, 0, "1e+01"},

    // Ryu Printf d2fixed_test.cc D2expTest Exponents
    {9.99e-100, chars_format::scientific, 2, "9.99e-100"},
    {9.99e-99, chars_format::scientific, 2, "9.99e-99"},
    {9.99e-10, chars_format::scientific, 2, "9.99e-10"},
    {9.99e-09, chars_format::scientific, 2, "9.99e-09"},
    {9.99e-01, chars_format::scientific, 2, "9.99e-01"},
    {9.99e+00, chars_format::scientific, 2, "9.99e+00"},
    {9.99e+01, chars_format::scientific, 2, "9.99e+01"},
    {9.99e+09, chars_format::scientific, 2, "9.99e+09"},
    {9.99e+10, chars_format::scientific, 2, "9.99e+10"},
    {9.99e+99, chars_format::scientific, 2, "9.99e+99"},
    {9.99e+100, chars_format::scientific, 2, "9.99e+100"},

    {9.99e-100, chars_format::scientific, 1, "1.0e-99"},
    {9.99e-99, chars_format::scientific, 1, "1.0e-98"},
    {9.99e-10, chars_format::scientific, 1, "1.0e-09"},
    {9.99e-09, chars_format::scientific, 1, "1.0e-08"},
    {9.99e-01, chars_format::scientific, 1, "1.0e+00"},
    {9.99e+00, chars_format::scientific, 1, "1.0e+01"},
    {9.99e+01, chars_format::scientific, 1, "1.0e+02"},
    {9.99e+09, chars_format::scientific, 1, "1.0e+10"},
    {9.99e+10, chars_format::scientific, 1, "1.0e+11"},
    {9.99e+99, chars_format::scientific, 1, "1.0e+100"},
    {9.99e+100, chars_format::scientific, 1, "1.0e+101"},

    // Ryu Printf d2fixed_test.cc D2expTest PrintDecimalPoint
    // These values exercise each codepath.
    {1e+54, chars_format::scientific, 0, "1e+54"},
    {1e+54, chars_format::scientific, 1, "1.0e+54"},
    {1e-63, chars_format::scientific, 0, "1e-63"},
    {1e-63, chars_format::scientific, 1, "1.0e-63"},
    {1e+83, chars_format::scientific, 0, "1e+83"},
    {1e+83, chars_format::scientific, 1, "1.0e+83"},

    // The UCRT had trouble with rounding this value. charconv was never affected, but let's test it anyways.
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 104,
        "1.09995565999999994887854821710219658911365648587951921896774663603198787416706536331386569598149846892544e+"
        "104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 18, "1.099955659999999949e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 17, "1.09995565999999995e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 16, "1.0999556599999999e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 15, "1.099955660000000e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 14, "1.09995566000000e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 13, "1.0999556600000e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 12, "1.099955660000e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 11, "1.09995566000e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 10, "1.0999556600e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 9, "1.099955660e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 8, "1.09995566e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 7, "1.0999557e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 6, "1.099956e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 5, "1.09996e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 4, "1.1000e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 3, "1.100e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 2, "1.10e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 1, "1.1e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 0, "1e+104"},

    // More cases that the UCRT had trouble with (e.g. DevCom-1093399).
    {0x1.8p+62, chars_format::scientific, 16, "6.9175290276410819e+18"},
    {0x1.0a2742p+17, chars_format::scientific, 5, "1.36271e+05"},
    {0x1.f8b0f962cdffbp+205, chars_format::scientific, 13, "1.0137595739223e+62"},
    {0x1.f8b0f962cdffbp+205, chars_format::scientific, 16, "1.0137595739222531e+62"},
    {0x1.f8b0f962cdffbp+205, chars_format::scientific, 50, "1.01375957392225305727423222620636224221808910954041e+62"},
    {0x1.f8b0f962cdffbp+205, chars_format::scientific, 54,
        "1.013759573922253057274232226206362242218089109540405973e+62"},
};

#endif // DOUBLE_SCIENTIFIC_PRECISION_TO_CHARS_TEST_CASES_1_HPP
