/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.DateRule;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.SimpleTimeZone;
import java.util.Date;

public class SimpleDateRule
implements DateRule {
    static GregorianCalendar gCalendar = new GregorianCalendar(new SimpleTimeZone(0, "UTC"));
    Calendar calendar = gCalendar;
    private int month;
    private int dayOfMonth;
    private int dayOfWeek;
    private Date startDate = null;
    private Date endDate = null;

    public SimpleDateRule(int month, int dayOfMonth) {
        this.month = month;
        this.dayOfMonth = dayOfMonth;
        this.dayOfWeek = 0;
    }

    public SimpleDateRule(int month, int dayOfMonth, int dayOfWeek, boolean after) {
        this.month = month;
        this.dayOfMonth = dayOfMonth;
        this.dayOfWeek = after ? dayOfWeek : -dayOfWeek;
    }

    public Date firstAfter(Date start) {
        if (this.startDate != null && start.before(this.startDate)) {
            start = this.startDate;
        }
        return this.doFirstBetween(start, this.endDate);
    }

    public Date firstBetween(Date start, Date end) {
        if (this.startDate != null && start.before(this.startDate)) {
            start = this.startDate;
        }
        if (this.endDate != null && end.after(this.endDate)) {
            end = this.endDate;
        }
        return this.doFirstBetween(start, end);
    }

    public boolean isOn(Date date) {
        Calendar c;
        if (this.startDate != null && date.before(this.startDate)) {
            return false;
        }
        if (this.endDate != null && date.after(this.endDate)) {
            return false;
        }
        Calendar calendar = c = this.calendar;
        synchronized (calendar) {
            c.setTime(date);
            int dayOfYear = c.get(6);
            c.setTime(this.computeInYear(c.get(1), c));
            boolean bl = c.get(6) == dayOfYear;
            return bl;
        }
    }

    public boolean isBetween(Date start, Date end) {
        return this.firstBetween(start, end) != null;
    }

    private Date doFirstBetween(Date start, Date end) {
        Calendar c;
        Calendar calendar = c = this.calendar;
        synchronized (calendar) {
            c.setTime(start);
            int year = c.get(1);
            int month = c.get(2);
            if (month > this.month) {
                ++year;
            }
            Date result = this.computeInYear(year, c);
            if (month == this.month && result.before(start)) {
                result = this.computeInYear(year + 1, c);
            }
            if (end != null && result.after(end)) {
                Date date = null;
                return date;
            }
            Date date = result;
            return date;
        }
    }

    private Date computeInYear(int year, Calendar c) {
        if (c == null) {
            c = this.calendar;
        }
        Calendar calendar = c;
        synchronized (calendar) {
            c.clear();
            c.set(0, c.getMaximum(0));
            c.set(1, year);
            c.set(2, this.month);
            c.set(5, this.dayOfMonth);
            if (this.dayOfWeek != 0) {
                c.setTime(c.getTime());
                int weekday = c.get(7);
                int delta = 0;
                if (this.dayOfWeek > 0) {
                    delta = (this.dayOfWeek - weekday + 7) % 7;
                } else if (this.dayOfWeek < 0) {
                    delta = -((this.dayOfWeek + weekday + 7) % 7);
                }
                c.add(5, delta);
            }
            Date date = c.getTime();
            return date;
        }
    }

    public void setCalendar(Calendar c) {
        this.calendar = c;
    }
}

