# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class ConfigurationState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The configuration state of the resource - complete or incomplete.
    """

    INCOMPLETE = "Incomplete"
    COMPLETE = "Complete"

class CoreNetworkType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Core network type.
    """

    FIVE_GC = "5GC"
    EPC = "EPC"

class CreatedByType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class NaptEnabled(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Whether Network Address and Port Translation is enabled.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class PduSessionType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """PDU session type (IPv4/IPv6).
    """

    I_PV4 = "IPv4"
    I_PV6 = "IPv6"

class PreemptionCapability(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Preemption capability.
    """

    NOT_PREEMPT = "NotPreempt"
    MAY_PREEMPT = "MayPreempt"

class PreemptionVulnerability(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Preemption vulnerability.
    """

    NOT_PREEMPTABLE = "NotPreemptable"
    PREEMPTABLE = "Preemptable"

class ProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The current provisioning state.
    """

    UNKNOWN = "Unknown"
    SUCCEEDED = "Succeeded"
    ACCEPTED = "Accepted"
    DELETING = "Deleting"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETED = "Deleted"

class SdfDirection(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Service data flow direction.
    """

    UPLINK = "Uplink"
    DOWNLINK = "Downlink"
    BIDIRECTIONAL = "Bidirectional"

class TrafficControlPermission(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Traffic control permission.
    """

    ENABLED = "Enabled"
    BLOCKED = "Blocked"
