/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingResolver;
import org.exolab.castor.mapping.loader.MappingLoader;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.Include;
import org.exolab.castor.mapping.xml.KeyGeneratorDef;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.util.DTDResolver;
import org.exolab.castor.util.Messages;
import org.exolab.castor.xml.IDResolver;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Mapping {
    public static final EngineMapping JDO = new EngineMapping("jdo", "org.exolab.castor.jdo.engine.JDOMappingLoader");
    public static final EngineMapping DAX = new EngineMapping("dax", "org.exolab.castor.dax.engine.DAXMappingLoader");
    public static final EngineMapping XML = new EngineMapping("xml", "org.exolab.castor.xml.XMLMappingLoader");
    private boolean _allowRedefinitions = false;
    private PrintWriter _logWriter;
    private ClassLoader _loader;
    private DTDResolver _resolver = new DTDResolver();
    private MappingRoot _mapping;
    private ClassMappingResolver _idResolver = null;
    private Hashtable _resolvers = new Hashtable();
    private MappingState _state = new MappingState();
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$io$PrintWriter;
    static /* synthetic */ Class class$org$exolab$castor$mapping$xml$MappingRoot;
    static /* synthetic */ Class class$org$exolab$castor$mapping$Mapping;

    public Mapping(ClassLoader loader) {
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        this._loader = loader;
        this._resolver = new DTDResolver();
        this._idResolver = new ClassMappingResolver();
    }

    public Mapping() {
        this(null);
    }

    public MappingResolver getResolver(EngineMapping engine) throws MappingException {
        return this.getResolver(engine, null);
    }

    public synchronized MappingResolver getResolver(EngineMapping engine, Object param) throws MappingException {
        if (this._mapping == null) {
            throw new MappingException("Must call loadMapping first");
        }
        MappingResolver resolver = (MappingResolver)this._resolvers.get(engine);
        if (resolver == null) {
            try {
                Class<?> loaderClass = this._loader != null ? this._loader.loadClass(engine.getLoaderClass()) : Class.forName(engine.getLoaderClass());
                Constructor<?> loaderConst = loaderClass.getConstructor(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Mapping.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = Mapping.class$("java.io.PrintWriter")) : class$java$io$PrintWriter);
                MappingLoader loaderImpl = (MappingLoader)loaderConst.newInstance(this._loader, this._logWriter);
                resolver = loaderImpl;
                this._resolvers.put(engine, resolver);
                loaderImpl.setAllowRedefinitions(this._allowRedefinitions);
                loaderImpl.loadMapping(this._mapping, param);
            }
            catch (Exception except) {
                throw new MappingException(except);
            }
        }
        return resolver;
    }

    public MappingRoot getRoot() {
        return this._mapping;
    }

    public void setAllowRedefinitions(boolean allow) {
        this._allowRedefinitions = allow;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this._logWriter = logWriter;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this._resolver = new DTDResolver(resolver);
    }

    public void setBaseURL(String url) {
        try {
            this._resolver.setBaseURL(new URL(url));
        }
        catch (MalformedURLException except) {
            try {
                if (this._logWriter != null) {
                    this._logWriter.println(Messages.format("mapping.wrongURL", url));
                }
                this._resolver.setBaseURL(new URL("file", null, url));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public void loadMapping(String url) throws IOException, MappingException {
        if (this._resolver.getBaseURL() == null) {
            this.setBaseURL(url);
        }
        this.loadMappingInternal(url);
    }

    public void loadMapping(URL url) throws IOException, MappingException {
        try {
            InputSource source;
            if (this._resolver.getBaseURL() == null) {
                this._resolver.setBaseURL(url);
            }
            if ((source = this._resolver.resolveEntity(null, url.toString())) == null) {
                source = new InputSource(url.toString());
                source.setByteStream(url.openStream());
            } else {
                source.setSystemId(url.toString());
            }
            if (this._logWriter != null) {
                this._logWriter.println(Messages.format("mapping.loadingFrom", url.toString()));
            }
            this.loadMappingInternal(source);
        }
        catch (SAXException except) {
            throw new MappingException(except);
        }
    }

    public void loadMapping(InputSource source) throws IOException, MappingException {
        this.loadMappingInternal(source);
    }

    private void loadMappingInternal(String url) throws IOException, MappingException {
        try {
            InputSource source = this._resolver.resolveEntity(null, url);
            if (source == null) {
                source = new InputSource(url);
            }
            if (source.getSystemId() == null) {
                source.setSystemId(url);
            }
            if (this._logWriter != null) {
                this._logWriter.println(Messages.format("mapping.loadingFrom", url));
            }
            this.loadMappingInternal(source);
        }
        catch (SAXException except) {
            throw new MappingException(except);
        }
    }

    private void loadMappingInternal(InputSource source) throws IOException, MappingException {
        this._resolvers.clear();
        if (source.getSystemId() != null && this._state.processed(source.getSystemId())) {
            return;
        }
        try {
            if (this._mapping == null) {
                this._mapping = new MappingRoot();
                this._idResolver.setMapping(this._mapping);
            }
            Unmarshaller unm = new Unmarshaller(class$org$exolab$castor$mapping$xml$MappingRoot == null ? (class$org$exolab$castor$mapping$xml$MappingRoot = Mapping.class$("org.exolab.castor.mapping.xml.MappingRoot")) : class$org$exolab$castor$mapping$xml$MappingRoot);
            unm.setEntityResolver(this._resolver);
            if (this._logWriter != null) {
                unm.setLogWriter(this._logWriter);
            }
            unm.setClassLoader((class$org$exolab$castor$mapping$Mapping == null ? (class$org$exolab$castor$mapping$Mapping = Mapping.class$("org.exolab.castor.mapping.Mapping")) : class$org$exolab$castor$mapping$Mapping).getClassLoader());
            unm.setIDResolver(this._idResolver);
            MappingRoot loaded = (MappingRoot)unm.unmarshal(source);
            if (source.getSystemId() != null) {
                this._state.markAsProcessed(source.getSystemId(), this._mapping);
            }
            Enumeration includes = loaded.enumerateInclude();
            while (includes.hasMoreElements()) {
                Include include = (Include)includes.nextElement();
                try {
                    this.loadMappingInternal(include.getHref());
                }
                catch (Exception except) {
                    throw new MappingException(except);
                }
            }
            Enumeration enumeration = loaded.enumerateClassMapping();
            while (enumeration.hasMoreElements()) {
                this._mapping.addClassMapping((ClassMapping)enumeration.nextElement());
            }
            enumeration = loaded.enumerateKeyGeneratorDef();
            while (enumeration.hasMoreElements()) {
                this._mapping.addKeyGeneratorDef((KeyGeneratorDef)enumeration.nextElement());
            }
        }
        catch (MarshalException except) {
            if (except.getException() != null) {
                throw new MappingException(except.getException());
            }
            throw new MappingException(except);
        }
        catch (Exception except) {
            throw new MappingException(except);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MappingState {
        private Hashtable _processed = new Hashtable(1);

        MappingState() {
        }

        void markAsProcessed(String systemID, MappingRoot mapping) {
            this._processed.put(systemID, mapping);
        }

        boolean processed(MappingRoot mapping) {
            return this._processed.contains(mapping);
        }

        boolean processed(String systemID) {
            return this._processed.containsKey(systemID);
        }

        MappingRoot getMapping(String systemID) {
            return (MappingRoot)this._processed.get(systemID);
        }
    }

    class ClassMappingResolver
    implements IDResolver {
        private MappingRoot _mapping = null;

        ClassMappingResolver() {
        }

        public void setMapping(MappingRoot mapping) {
            this._mapping = mapping;
        }

        public Object resolve(String idref) {
            if (this._mapping == null) {
                return null;
            }
            for (int i = 0; i < this._mapping.getClassMappingCount(); ++i) {
                ClassMapping clsMap = this._mapping.getClassMapping(i);
                if (!idref.equals(clsMap.getName())) continue;
                return clsMap;
            }
            return null;
        }
    }

    static class EngineMapping {
        private final String _name;
        private final String _loaderClass;

        EngineMapping(String name, String loaderClass) {
            this._name = name;
            this._loaderClass = loaderClass;
        }

        public String getLoaderClass() {
            return this._loaderClass;
        }

        public String toString() {
            return this._name;
        }
    }
}

