/*
 * Copyright 2010-2016 Amazon.com, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.config.model;

import java.io.Serializable;
import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 */
public class DeleteConfigRuleRequest extends AmazonWebServiceRequest implements
        Serializable, Cloneable {

    /**
     * <p>
     * The name of the AWS Config rule that you want to delete.
     * </p>
     */
    private String configRuleName;

    /**
     * <p>
     * The name of the AWS Config rule that you want to delete.
     * </p>
     * 
     * @param configRuleName
     *        The name of the AWS Config rule that you want to delete.
     */

    public void setConfigRuleName(String configRuleName) {
        this.configRuleName = configRuleName;
    }

    /**
     * <p>
     * The name of the AWS Config rule that you want to delete.
     * </p>
     * 
     * @return The name of the AWS Config rule that you want to delete.
     */

    public String getConfigRuleName() {
        return this.configRuleName;
    }

    /**
     * <p>
     * The name of the AWS Config rule that you want to delete.
     * </p>
     * 
     * @param configRuleName
     *        The name of the AWS Config rule that you want to delete.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DeleteConfigRuleRequest withConfigRuleName(String configRuleName) {
        setConfigRuleName(configRuleName);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getConfigRuleName() != null)
            sb.append("ConfigRuleName: " + getConfigRuleName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteConfigRuleRequest == false)
            return false;
        DeleteConfigRuleRequest other = (DeleteConfigRuleRequest) obj;
        if (other.getConfigRuleName() == null
                ^ this.getConfigRuleName() == null)
            return false;
        if (other.getConfigRuleName() != null
                && other.getConfigRuleName().equals(this.getConfigRuleName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime
                * hashCode
                + ((getConfigRuleName() == null) ? 0 : getConfigRuleName()
                        .hashCode());
        return hashCode;
    }

    @Override
    public DeleteConfigRuleRequest clone() {
        return (DeleteConfigRuleRequest) super.clone();
    }
}