package siterecovery

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ReplicationMigrationItemsClient is the client for the ReplicationMigrationItems methods of the Siterecovery service.
type ReplicationMigrationItemsClient struct {
	BaseClient
}

// NewReplicationMigrationItemsClient creates an instance of the ReplicationMigrationItemsClient client.
func NewReplicationMigrationItemsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationMigrationItemsClient {
	return NewReplicationMigrationItemsClientWithBaseURI(DefaultBaseURI, subscriptionID, resourceGroupName, resourceName)
}

// NewReplicationMigrationItemsClientWithBaseURI creates an instance of the ReplicationMigrationItemsClient client
// using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign
// clouds, Azure stack).
func NewReplicationMigrationItemsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationMigrationItemsClient {
	return ReplicationMigrationItemsClient{NewWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)}
}

// Create the operation to create an ASR migration item (enable migration).
// Parameters:
// fabricName - fabric name.
// protectionContainerName - protection container name.
// migrationItemName - migration item name.
// input - enable migration input.
func (client ReplicationMigrationItemsClient) Create(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, input EnableMigrationInput) (result ReplicationMigrationItemsCreateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationMigrationItemsClient.Create")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: input,
			Constraints: []validation.Constraint{{Target: "input.Properties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "input.Properties.PolicyID", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "input.Properties.ProviderSpecificDetails", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("siterecovery.ReplicationMigrationItemsClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, fabricName, protectionContainerName, migrationItemName, input)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "Create", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "Create", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client ReplicationMigrationItemsClient) CreatePreparer(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, input EnableMigrationInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":              autorest.Encode("path", fabricName),
		"migrationItemName":       autorest.Encode("path", migrationItemName),
		"protectionContainerName": autorest.Encode("path", protectionContainerName),
		"resourceGroupName":       autorest.Encode("path", client.ResourceGroupName),
		"resourceName":            autorest.Encode("path", client.ResourceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationMigrationItems/{migrationItemName}", pathParameters),
		autorest.WithJSON(input),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationMigrationItemsClient) CreateSender(req *http.Request) (future ReplicationMigrationItemsCreateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client ReplicationMigrationItemsClient) CreateResponder(resp *http.Response) (result MigrationItem, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete the operation to delete an ASR migration item.
// Parameters:
// fabricName - fabric name.
// protectionContainerName - protection container name.
// migrationItemName - migration item name.
// deleteOption - the delete option.
func (client ReplicationMigrationItemsClient) Delete(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, deleteOption string) (result ReplicationMigrationItemsDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationMigrationItemsClient.Delete")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, fabricName, protectionContainerName, migrationItemName, deleteOption)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ReplicationMigrationItemsClient) DeletePreparer(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, deleteOption string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":              autorest.Encode("path", fabricName),
		"migrationItemName":       autorest.Encode("path", migrationItemName),
		"protectionContainerName": autorest.Encode("path", protectionContainerName),
		"resourceGroupName":       autorest.Encode("path", client.ResourceGroupName),
		"resourceName":            autorest.Encode("path", client.ResourceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(deleteOption) > 0 {
		queryParameters["deleteOption"] = autorest.Encode("query", deleteOption)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationMigrationItems/{migrationItemName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationMigrationItemsClient) DeleteSender(req *http.Request) (future ReplicationMigrationItemsDeleteFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ReplicationMigrationItemsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get sends the get request.
// Parameters:
// fabricName - fabric unique name.
// protectionContainerName - protection container name.
// migrationItemName - migration item name.
func (client ReplicationMigrationItemsClient) Get(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string) (result MigrationItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationMigrationItemsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, fabricName, protectionContainerName, migrationItemName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ReplicationMigrationItemsClient) GetPreparer(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":              autorest.Encode("path", fabricName),
		"migrationItemName":       autorest.Encode("path", migrationItemName),
		"protectionContainerName": autorest.Encode("path", protectionContainerName),
		"resourceGroupName":       autorest.Encode("path", client.ResourceGroupName),
		"resourceName":            autorest.Encode("path", client.ResourceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationMigrationItems/{migrationItemName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationMigrationItemsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ReplicationMigrationItemsClient) GetResponder(resp *http.Response) (result MigrationItem, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List sends the list request.
// Parameters:
// skipToken - the pagination token.
// filter - oData filter options.
func (client ReplicationMigrationItemsClient) List(ctx context.Context, skipToken string, filter string) (result MigrationItemCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationMigrationItemsClient.List")
		defer func() {
			sc := -1
			if result.mic.Response.Response != nil {
				sc = result.mic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, skipToken, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.mic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "List", resp, "Failure sending request")
		return
	}

	result.mic, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "List", resp, "Failure responding to request")
	}
	if result.mic.hasNextLink() && result.mic.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListPreparer prepares the List request.
func (client ReplicationMigrationItemsClient) ListPreparer(ctx context.Context, skipToken string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"resourceName":      autorest.Encode("path", client.ResourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["skipToken"] = autorest.Encode("query", skipToken)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationMigrationItems", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationMigrationItemsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ReplicationMigrationItemsClient) ListResponder(resp *http.Response) (result MigrationItemCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client ReplicationMigrationItemsClient) listNextResults(ctx context.Context, lastResults MigrationItemCollection) (result MigrationItemCollection, err error) {
	req, err := lastResults.migrationItemCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client ReplicationMigrationItemsClient) ListComplete(ctx context.Context, skipToken string, filter string) (result MigrationItemCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationMigrationItemsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, skipToken, filter)
	return
}

// ListByReplicationProtectionContainers gets the list of ASR migration items in the protection container.
// Parameters:
// fabricName - fabric name.
// protectionContainerName - protection container name.
func (client ReplicationMigrationItemsClient) ListByReplicationProtectionContainers(ctx context.Context, fabricName string, protectionContainerName string) (result MigrationItemCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationMigrationItemsClient.ListByReplicationProtectionContainers")
		defer func() {
			sc := -1
			if result.mic.Response.Response != nil {
				sc = result.mic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByReplicationProtectionContainersNextResults
	req, err := client.ListByReplicationProtectionContainersPreparer(ctx, fabricName, protectionContainerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "ListByReplicationProtectionContainers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByReplicationProtectionContainersSender(req)
	if err != nil {
		result.mic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "ListByReplicationProtectionContainers", resp, "Failure sending request")
		return
	}

	result.mic, err = client.ListByReplicationProtectionContainersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "ListByReplicationProtectionContainers", resp, "Failure responding to request")
	}
	if result.mic.hasNextLink() && result.mic.IsEmpty() {
		err = result.NextWithContext(ctx)
	}

	return
}

// ListByReplicationProtectionContainersPreparer prepares the ListByReplicationProtectionContainers request.
func (client ReplicationMigrationItemsClient) ListByReplicationProtectionContainersPreparer(ctx context.Context, fabricName string, protectionContainerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":              autorest.Encode("path", fabricName),
		"protectionContainerName": autorest.Encode("path", protectionContainerName),
		"resourceGroupName":       autorest.Encode("path", client.ResourceGroupName),
		"resourceName":            autorest.Encode("path", client.ResourceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationMigrationItems", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByReplicationProtectionContainersSender sends the ListByReplicationProtectionContainers request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationMigrationItemsClient) ListByReplicationProtectionContainersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByReplicationProtectionContainersResponder handles the response to the ListByReplicationProtectionContainers request. The method always
// closes the http.Response Body.
func (client ReplicationMigrationItemsClient) ListByReplicationProtectionContainersResponder(resp *http.Response) (result MigrationItemCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByReplicationProtectionContainersNextResults retrieves the next set of results, if any.
func (client ReplicationMigrationItemsClient) listByReplicationProtectionContainersNextResults(ctx context.Context, lastResults MigrationItemCollection) (result MigrationItemCollection, err error) {
	req, err := lastResults.migrationItemCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "listByReplicationProtectionContainersNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByReplicationProtectionContainersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "listByReplicationProtectionContainersNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByReplicationProtectionContainersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "listByReplicationProtectionContainersNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByReplicationProtectionContainersComplete enumerates all values, automatically crossing page boundaries as required.
func (client ReplicationMigrationItemsClient) ListByReplicationProtectionContainersComplete(ctx context.Context, fabricName string, protectionContainerName string) (result MigrationItemCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationMigrationItemsClient.ListByReplicationProtectionContainers")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByReplicationProtectionContainers(ctx, fabricName, protectionContainerName)
	return
}

// Migrate the operation to initiate migration of the item.
// Parameters:
// fabricName - fabric name.
// protectionContainerName - protection container name.
// migrationItemName - migration item name.
// migrateInput - migrate input.
func (client ReplicationMigrationItemsClient) Migrate(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, migrateInput MigrateInput) (result ReplicationMigrationItemsMigrateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationMigrationItemsClient.Migrate")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: migrateInput,
			Constraints: []validation.Constraint{{Target: "migrateInput.Properties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "migrateInput.Properties.ProviderSpecificDetails", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("siterecovery.ReplicationMigrationItemsClient", "Migrate", err.Error())
	}

	req, err := client.MigratePreparer(ctx, fabricName, protectionContainerName, migrationItemName, migrateInput)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "Migrate", nil, "Failure preparing request")
		return
	}

	result, err = client.MigrateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "Migrate", result.Response(), "Failure sending request")
		return
	}

	return
}

// MigratePreparer prepares the Migrate request.
func (client ReplicationMigrationItemsClient) MigratePreparer(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, migrateInput MigrateInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":              autorest.Encode("path", fabricName),
		"migrationItemName":       autorest.Encode("path", migrationItemName),
		"protectionContainerName": autorest.Encode("path", protectionContainerName),
		"resourceGroupName":       autorest.Encode("path", client.ResourceGroupName),
		"resourceName":            autorest.Encode("path", client.ResourceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationMigrationItems/{migrationItemName}/migrate", pathParameters),
		autorest.WithJSON(migrateInput),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MigrateSender sends the Migrate request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationMigrationItemsClient) MigrateSender(req *http.Request) (future ReplicationMigrationItemsMigrateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// MigrateResponder handles the response to the Migrate request. The method always
// closes the http.Response Body.
func (client ReplicationMigrationItemsClient) MigrateResponder(resp *http.Response) (result MigrationItem, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Resync the operation to resynchronize replication of an ASR migration item.
// Parameters:
// fabricName - fabric name.
// protectionContainerName - protection container name.
// migrationItemName - migration item name.
// input - resync input.
func (client ReplicationMigrationItemsClient) Resync(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, input ResyncInput) (result ReplicationMigrationItemsResyncFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationMigrationItemsClient.Resync")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: input,
			Constraints: []validation.Constraint{{Target: "input.Properties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "input.Properties.ProviderSpecificDetails", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("siterecovery.ReplicationMigrationItemsClient", "Resync", err.Error())
	}

	req, err := client.ResyncPreparer(ctx, fabricName, protectionContainerName, migrationItemName, input)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "Resync", nil, "Failure preparing request")
		return
	}

	result, err = client.ResyncSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "Resync", result.Response(), "Failure sending request")
		return
	}

	return
}

// ResyncPreparer prepares the Resync request.
func (client ReplicationMigrationItemsClient) ResyncPreparer(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, input ResyncInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":              autorest.Encode("path", fabricName),
		"migrationItemName":       autorest.Encode("path", migrationItemName),
		"protectionContainerName": autorest.Encode("path", protectionContainerName),
		"resourceGroupName":       autorest.Encode("path", client.ResourceGroupName),
		"resourceName":            autorest.Encode("path", client.ResourceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationMigrationItems/{migrationItemName}/resync", pathParameters),
		autorest.WithJSON(input),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ResyncSender sends the Resync request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationMigrationItemsClient) ResyncSender(req *http.Request) (future ReplicationMigrationItemsResyncFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// ResyncResponder handles the response to the Resync request. The method always
// closes the http.Response Body.
func (client ReplicationMigrationItemsClient) ResyncResponder(resp *http.Response) (result MigrationItem, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// TestMigrate the operation to initiate test migration of the item.
// Parameters:
// fabricName - fabric name.
// protectionContainerName - protection container name.
// migrationItemName - migration item name.
// testMigrateInput - test migrate input.
func (client ReplicationMigrationItemsClient) TestMigrate(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, testMigrateInput TestMigrateInput) (result ReplicationMigrationItemsTestMigrateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationMigrationItemsClient.TestMigrate")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: testMigrateInput,
			Constraints: []validation.Constraint{{Target: "testMigrateInput.Properties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "testMigrateInput.Properties.ProviderSpecificDetails", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("siterecovery.ReplicationMigrationItemsClient", "TestMigrate", err.Error())
	}

	req, err := client.TestMigratePreparer(ctx, fabricName, protectionContainerName, migrationItemName, testMigrateInput)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "TestMigrate", nil, "Failure preparing request")
		return
	}

	result, err = client.TestMigrateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "TestMigrate", result.Response(), "Failure sending request")
		return
	}

	return
}

// TestMigratePreparer prepares the TestMigrate request.
func (client ReplicationMigrationItemsClient) TestMigratePreparer(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, testMigrateInput TestMigrateInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":              autorest.Encode("path", fabricName),
		"migrationItemName":       autorest.Encode("path", migrationItemName),
		"protectionContainerName": autorest.Encode("path", protectionContainerName),
		"resourceGroupName":       autorest.Encode("path", client.ResourceGroupName),
		"resourceName":            autorest.Encode("path", client.ResourceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationMigrationItems/{migrationItemName}/testMigrate", pathParameters),
		autorest.WithJSON(testMigrateInput),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TestMigrateSender sends the TestMigrate request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationMigrationItemsClient) TestMigrateSender(req *http.Request) (future ReplicationMigrationItemsTestMigrateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// TestMigrateResponder handles the response to the TestMigrate request. The method always
// closes the http.Response Body.
func (client ReplicationMigrationItemsClient) TestMigrateResponder(resp *http.Response) (result MigrationItem, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// TestMigrateCleanup the operation to initiate test migrate cleanup.
// Parameters:
// fabricName - fabric name.
// protectionContainerName - protection container name.
// migrationItemName - migration item name.
// testMigrateCleanupInput - test migrate cleanup input.
func (client ReplicationMigrationItemsClient) TestMigrateCleanup(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, testMigrateCleanupInput TestMigrateCleanupInput) (result ReplicationMigrationItemsTestMigrateCleanupFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationMigrationItemsClient.TestMigrateCleanup")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: testMigrateCleanupInput,
			Constraints: []validation.Constraint{{Target: "testMigrateCleanupInput.Properties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "testMigrateCleanupInput.Properties.Comments", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "testMigrateCleanupInput.Properties.Comments", Name: validation.MaxLength, Rule: 1024, Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewError("siterecovery.ReplicationMigrationItemsClient", "TestMigrateCleanup", err.Error())
	}

	req, err := client.TestMigrateCleanupPreparer(ctx, fabricName, protectionContainerName, migrationItemName, testMigrateCleanupInput)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "TestMigrateCleanup", nil, "Failure preparing request")
		return
	}

	result, err = client.TestMigrateCleanupSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "TestMigrateCleanup", result.Response(), "Failure sending request")
		return
	}

	return
}

// TestMigrateCleanupPreparer prepares the TestMigrateCleanup request.
func (client ReplicationMigrationItemsClient) TestMigrateCleanupPreparer(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, testMigrateCleanupInput TestMigrateCleanupInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":              autorest.Encode("path", fabricName),
		"migrationItemName":       autorest.Encode("path", migrationItemName),
		"protectionContainerName": autorest.Encode("path", protectionContainerName),
		"resourceGroupName":       autorest.Encode("path", client.ResourceGroupName),
		"resourceName":            autorest.Encode("path", client.ResourceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationMigrationItems/{migrationItemName}/testMigrateCleanup", pathParameters),
		autorest.WithJSON(testMigrateCleanupInput),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TestMigrateCleanupSender sends the TestMigrateCleanup request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationMigrationItemsClient) TestMigrateCleanupSender(req *http.Request) (future ReplicationMigrationItemsTestMigrateCleanupFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// TestMigrateCleanupResponder handles the response to the TestMigrateCleanup request. The method always
// closes the http.Response Body.
func (client ReplicationMigrationItemsClient) TestMigrateCleanupResponder(resp *http.Response) (result MigrationItem, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update the operation to update the recovery settings of an ASR migration item.
// Parameters:
// fabricName - fabric name.
// protectionContainerName - protection container name.
// migrationItemName - migration item name.
// input - update migration item input.
func (client ReplicationMigrationItemsClient) Update(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, input UpdateMigrationItemInput) (result ReplicationMigrationItemsUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationMigrationItemsClient.Update")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePreparer(ctx, fabricName, protectionContainerName, migrationItemName, input)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "Update", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationMigrationItemsClient", "Update", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client ReplicationMigrationItemsClient) UpdatePreparer(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, input UpdateMigrationItemInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":              autorest.Encode("path", fabricName),
		"migrationItemName":       autorest.Encode("path", migrationItemName),
		"protectionContainerName": autorest.Encode("path", protectionContainerName),
		"resourceGroupName":       autorest.Encode("path", client.ResourceGroupName),
		"resourceName":            autorest.Encode("path", client.ResourceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationMigrationItems/{migrationItemName}", pathParameters),
		autorest.WithJSON(input),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationMigrationItemsClient) UpdateSender(req *http.Request) (future ReplicationMigrationItemsUpdateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client ReplicationMigrationItemsClient) UpdateResponder(resp *http.Response) (result MigrationItem, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
