// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`CreateToken`](crate::operation::create_token::builders::CreateTokenFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_id(impl Into<String>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::client_id) / [`set_client_id(Option<String>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::set_client_id):<br>required: **true**<br><p>The unique identifier string for the client or application. This value comes from the result of the <code>RegisterClient</code> API.</p><br>
    ///   - [`client_secret(impl Into<String>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::client_secret) / [`set_client_secret(Option<String>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::set_client_secret):<br>required: **true**<br><p>A secret string generated for the client. This value should come from the persisted result of the <code>RegisterClient</code> API.</p><br>
    ///   - [`grant_type(impl Into<String>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::grant_type) / [`set_grant_type(Option<String>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::set_grant_type):<br>required: **true**<br><p>Supports the following OAuth grant types: Device Code and Refresh Token. Specify either of the following values, depending on the grant type that you want:</p> <p>* Device Code - <code>urn:ietf:params:oauth:grant-type:device_code</code></p> <p>* Refresh Token - <code>refresh_token</code></p> <p>For information about how to obtain the device code, see the <code>StartDeviceAuthorization</code> topic.</p><br>
    ///   - [`device_code(impl Into<String>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::device_code) / [`set_device_code(Option<String>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::set_device_code):<br>required: **false**<br><p>Used only when calling this API for the Device Code grant type. This short-term code is used to identify this authorization request. This comes from the result of the <code>StartDeviceAuthorization</code> API.</p><br>
    ///   - [`code(impl Into<String>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::code) / [`set_code(Option<String>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::set_code):<br>required: **false**<br><p>Used only when calling this API for the Authorization Code grant type. The short-term code is used to identify this authorization request. This grant type is currently unsupported for the <code>CreateToken</code> API.</p><br>
    ///   - [`refresh_token(impl Into<String>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::refresh_token) / [`set_refresh_token(Option<String>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::set_refresh_token):<br>required: **false**<br><p>Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term tokens, such as the access token, that might expire.</p> <p>For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API Reference</a>.</p><br>
    ///   - [`scope(impl Into<String>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::scope) / [`set_scope(Option<Vec::<String>>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::set_scope):<br>required: **false**<br><p>The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes that are granted. If this value is not specified, IAM Identity Center authorizes all scopes that are configured for the client during the call to <code>RegisterClient</code>.</p><br>
    ///   - [`redirect_uri(impl Into<String>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::redirect_uri) / [`set_redirect_uri(Option<String>)`](crate::operation::create_token::builders::CreateTokenFluentBuilder::set_redirect_uri):<br>required: **false**<br><p>Used only when calling this API for the Authorization Code grant type. This value specifies the location of the client or application that has registered to receive the authorization code.</p><br>
    /// - On success, responds with [`CreateTokenOutput`](crate::operation::create_token::CreateTokenOutput) with field(s):
    ///   - [`access_token(Option<String>)`](crate::operation::create_token::CreateTokenOutput::access_token): <p>A bearer token to access AWS accounts and applications assigned to a user.</p>
    ///   - [`token_type(Option<String>)`](crate::operation::create_token::CreateTokenOutput::token_type): <p>Used to notify the client that the returned token is an access token. The supported token type is <code>Bearer</code>.</p>
    ///   - [`expires_in(i32)`](crate::operation::create_token::CreateTokenOutput::expires_in): <p>Indicates the time in seconds when an access token will expire.</p>
    ///   - [`refresh_token(Option<String>)`](crate::operation::create_token::CreateTokenOutput::refresh_token): <p>A token that, if present, can be used to refresh a previously issued access token that might have expired.</p> <p>For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API Reference</a>.</p>
    ///   - [`id_token(Option<String>)`](crate::operation::create_token::CreateTokenOutput::id_token): <p>The <code>idToken</code> is not implemented or supported. For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API Reference</a>.</p> <p>A JSON Web Token (JWT) that identifies who is associated with the issued access token.</p>
    /// - On failure, responds with [`SdkError<CreateTokenError>`](crate::operation::create_token::CreateTokenError)
    pub fn create_token(&self) -> crate::operation::create_token::builders::CreateTokenFluentBuilder {
        crate::operation::create_token::builders::CreateTokenFluentBuilder::new(self.handle.clone())
    }
}
