// Code generated by swagger-doc. DO NOT EDIT.

package v1

func (VirtualMachineInstance) SwaggerDoc() map[string]string {
	return map[string]string{
		"":       "VirtualMachineInstance is *the* VirtualMachineInstance Definition. It represents a virtual machine in the runtime environment of kubernetes.\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object\n+genclient",
		"spec":   "VirtualMachineInstance Spec contains the VirtualMachineInstance specification.",
		"status": "Status is the high level overview of how the VirtualMachineInstance is doing. It contains information available to controllers and users.",
	}
}

func (VirtualMachineInstanceList) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "VirtualMachineInstanceList is a list of VirtualMachines\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object",
	}
}

func (VirtualMachineInstanceSpec) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                              "VirtualMachineInstanceSpec is a description of a VirtualMachineInstance.",
		"priorityClassName":             "If specified, indicates the pod's priority.\nIf not specified, the pod priority will be default or zero if there is no\ndefault.\n+optional",
		"domain":                        "Specification of the desired behavior of the VirtualMachineInstance on the host.",
		"nodeSelector":                  "NodeSelector is a selector which must be true for the vmi to fit on a node.\nSelector which must match a node's labels for the vmi to be scheduled on that node.\nMore info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/\n+optional",
		"affinity":                      "If affinity is specifies, obey all the affinity rules",
		"schedulerName":                 "If specified, the VMI will be dispatched by specified scheduler.\nIf not specified, the VMI will be dispatched by default scheduler.\n+optional",
		"tolerations":                   "If toleration is specified, obey all the toleration rules.",
		"topologySpreadConstraints":     "TopologySpreadConstraints describes how a group of VMIs will be spread across a given topology\ndomains. K8s scheduler will schedule VMI pods in a way which abides by the constraints.\n+optional\n+patchMergeKey=topologyKey\n+patchStrategy=merge\n+listType=map\n+listMapKey=topologyKey\n+listMapKey=whenUnsatisfiable",
		"evictionStrategy":              "EvictionStrategy describes the strategy to follow when a node drain occurs.\nThe possible options are:\n- \"None\": No action will be taken, according to the specified 'RunStrategy' the VirtualMachine will be restarted or shutdown.\n- \"LiveMigrate\": the VirtualMachineInstance will be migrated instead of being shutdown.\n- \"LiveMigrateIfPossible\": the same as \"LiveMigrate\" but only if the VirtualMachine is Live-Migratable, otherwise it will behave as \"None\".\n- \"External\": the VirtualMachineInstance will be protected by a PDB and `vmi.Status.EvacuationNodeName` will be set on eviction. This is mainly useful for cluster-api-provider-kubevirt (capk) which needs a way for VMI's to be blocked from eviction, yet signal capk that eviction has been called on the VMI so the capk controller can handle tearing the VMI down. Details can be found in the commit description https://github.com/kubevirt/kubevirt/commit/c1d77face705c8b126696bac9a3ee3825f27f1fa.\n+optional",
		"startStrategy":                 "StartStrategy can be set to \"Paused\" if Virtual Machine should be started in paused state.\n\n+optional",
		"terminationGracePeriodSeconds": "Grace period observed after signalling a VirtualMachineInstance to stop after which the VirtualMachineInstance is force terminated.",
		"volumes":                       "List of volumes that can be mounted by disks belonging to the vmi.",
		"livenessProbe":                 "Periodic probe of VirtualMachineInstance liveness.\nVirtualmachineInstances will be stopped if the probe fails.\nCannot be updated.\nMore info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes\n+optional",
		"readinessProbe":                "Periodic probe of VirtualMachineInstance service readiness.\nVirtualmachineInstances will be removed from service endpoints if the probe fails.\nCannot be updated.\nMore info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes\n+optional",
		"hostname":                      "Specifies the hostname of the vmi\nIf not specified, the hostname will be set to the name of the vmi, if dhcp or cloud-init is configured properly.\n+optional",
		"subdomain":                     "If specified, the fully qualified vmi hostname will be \"<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>\".\nIf not specified, the vmi will not have a domainname at all. The DNS entry will resolve to the vmi,\nno matter if the vmi itself can pick up a hostname.\n+optional",
		"networks":                      "List of networks that can be attached to a vm's virtual interface.",
		"dnsPolicy":                     "Set DNS policy for the pod.\nDefaults to \"ClusterFirst\".\nValid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'.\nDNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy.\nTo have DNS options set along with hostNetwork, you have to specify DNS policy\nexplicitly to 'ClusterFirstWithHostNet'.\n+optional",
		"dnsConfig":                     "Specifies the DNS parameters of a pod.\nParameters specified here will be merged to the generated DNS\nconfiguration based on DNSPolicy.\n+optional",
		"accessCredentials":             "Specifies a set of public keys to inject into the vm guest\n+listType=atomic\n+optional",
		"architecture":                  "Specifies the architecture of the vm guest you are attempting to run. Defaults to the compiled architecture of the KubeVirt components",
	}
}

func (VirtualMachineInstancePhaseTransitionTimestamp) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                         "VirtualMachineInstancePhaseTransitionTimestamp gives a timestamp in relation to when a phase is set on a vmi",
		"phase":                    "Phase is the status of the VirtualMachineInstance in kubernetes world. It is not the VirtualMachineInstance status, but partially correlates to it.",
		"phaseTransitionTimestamp": "PhaseTransitionTimestamp is the timestamp of when the phase change occurred",
	}
}

func (TopologyHints) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (VirtualMachineInstanceStatus) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                              "VirtualMachineInstanceStatus represents information about the status of a VirtualMachineInstance. Status may trail the actual\nstate of a system.",
		"nodeName":                      "NodeName is the name where the VirtualMachineInstance is currently running.",
		"reason":                        "A brief CamelCase message indicating details about why the VMI is in this state. e.g. 'NodeUnresponsive'\n+optional",
		"conditions":                    "Conditions are specific points in VirtualMachineInstance's pod runtime.",
		"phase":                         "Phase is the status of the VirtualMachineInstance in kubernetes world. It is not the VirtualMachineInstance status, but partially correlates to it.",
		"phaseTransitionTimestamps":     "PhaseTransitionTimestamp is the timestamp of when the last phase change occurred\n+listType=atomic\n+optional",
		"interfaces":                    "Interfaces represent the details of available network interfaces.",
		"guestOSInfo":                   "Guest OS Information",
		"migrationState":                "Represents the status of a live migration",
		"migrationMethod":               "Represents the method using which the vmi can be migrated: live migration or block migration",
		"migrationTransport":            "This represents the migration transport",
		"qosClass":                      "The Quality of Service (QOS) classification assigned to the virtual machine instance based on resource requirements\nSee PodQOSClass type for available QOS classes\nMore info: https://git.k8s.io/community/contributors/design-proposals/node/resource-qos.md\n+optional",
		"launcherContainerImageVersion": "LauncherContainerImageVersion indicates what container image is currently active for the vmi.",
		"evacuationNodeName":            "EvacuationNodeName is used to track the eviction process of a VMI. It stores the name of the node that we want\nto evacuate. It is meant to be used by KubeVirt core components only and can't be set or modified by users.\n+optional",
		"activePods":                    "ActivePods is a mapping of pod UID to node name.\nIt is possible for multiple pods to be running for a single VMI during migration.",
		"volumeStatus":                  "VolumeStatus contains the statuses of all the volumes\n+optional\n+listType=atomic",
		"kernelBootStatus":              "KernelBootStatus contains info about the kernelBootContainer\n+optional",
		"fsFreezeStatus":                "FSFreezeStatus is the state of the fs of the guest\nit can be either frozen or thawed\n+optional",
		"topologyHints":                 "+optional",
		"virtualMachineRevisionName":    "VirtualMachineRevisionName is used to get the vm revision of the vmi when doing\nan online vm snapshot\n+optional",
		"runtimeUser":                   "RuntimeUser is used to determine what user will be used in launcher\n+optional",
		"VSOCKCID":                      "VSOCKCID is used to track the allocated VSOCK CID in the VM.\n+optional",
		"selinuxContext":                "SELinuxContext is the actual SELinux context of the virt-launcher pod\n+optional",
		"machine":                       "Machine shows the final resulting qemu machine type. This can be different\nthan the machine type selected in the spec, due to qemus machine type alias mechanism.\n+optional",
		"currentCPUTopology":            "CurrentCPUTopology specifies the current CPU topology used by the VM workload.\nCurrent topology may differ from the desired topology in the spec while CPU hotplug\ntakes place.",
		"memory":                        "Memory shows various informations about the VirtualMachine memory.\n+optional",
	}
}

func (PersistentVolumeClaimInfo) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                   "PersistentVolumeClaimInfo contains the relavant information virt-handler needs cached about a PVC",
		"accessModes":        "AccessModes contains the desired access modes the volume should have.\nMore info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1\n+listType=atomic\n+optional",
		"volumeMode":         "VolumeMode defines what type of volume is required by the claim.\nValue of Filesystem is implied when not included in claim spec.\n+optional",
		"capacity":           "Capacity represents the capacity set on the corresponding PVC status\n+optional",
		"requests":           "Requests represents the resources requested by the corresponding PVC spec\n+optional",
		"preallocated":       "Preallocated indicates if the PVC's storage is preallocated or not\n+optional",
		"filesystemOverhead": "Percentage of filesystem's size to be reserved when resizing the PVC\n+optional",
	}
}

func (VolumeStatus) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                          "VolumeStatus represents information about the status of volumes attached to the VirtualMachineInstance.",
		"name":                      "Name is the name of the volume",
		"target":                    "Target is the target name used when adding the volume to the VM, eg: vda",
		"phase":                     "Phase is the phase",
		"reason":                    "Reason is a brief description of why we are in the current hotplug volume phase",
		"message":                   "Message is a detailed message about the current hotplug volume phase",
		"persistentVolumeClaimInfo": "PersistentVolumeClaimInfo is information about the PVC that handler requires during start flow",
		"hotplugVolume":             "If the volume is hotplug, this will contain the hotplug status.",
		"size":                      "Represents the size of the volume",
		"memoryDumpVolume":          "If the volume is memorydump volume, this will contain the memorydump info.",
		"containerDiskVolume":       "ContainerDiskVolume shows info about the containerdisk, if the volume is a containerdisk",
	}
}

func (KernelInfo) SwaggerDoc() map[string]string {
	return map[string]string{
		"":         "KernelInfo show info about the kernel image",
		"checksum": "Checksum is the checksum of the kernel image",
	}
}

func (InitrdInfo) SwaggerDoc() map[string]string {
	return map[string]string{
		"":         "InitrdInfo show info about the initrd file",
		"checksum": "Checksum is the checksum of the initrd file",
	}
}

func (KernelBootStatus) SwaggerDoc() map[string]string {
	return map[string]string{
		"":           "KernelBootStatus contains info about the kernelBootContainer",
		"kernelInfo": "KernelInfo show info about the kernel image",
		"initrdInfo": "InitrdInfo show info about the initrd file",
	}
}

func (DomainMemoryDumpInfo) SwaggerDoc() map[string]string {
	return map[string]string{
		"":               "DomainMemoryDumpInfo represents the memory dump information",
		"startTimestamp": "StartTimestamp is the time when the memory dump started",
		"endTimestamp":   "EndTimestamp is the time when the memory dump completed",
		"claimName":      "ClaimName is the name of the pvc the memory was dumped to",
		"targetFileName": "TargetFileName is the name of the memory dump output",
	}
}

func (HotplugVolumeStatus) SwaggerDoc() map[string]string {
	return map[string]string{
		"":              "HotplugVolumeStatus represents the hotplug status of the volume",
		"attachPodName": "AttachPodName is the name of the pod used to attach the volume to the node.",
		"attachPodUID":  "AttachPodUID is the UID of the pod used to attach the volume to the node.",
	}
}

func (ContainerDiskInfo) SwaggerDoc() map[string]string {
	return map[string]string{
		"":         "ContainerDiskInfo shows info about the containerdisk",
		"checksum": "Checksum is the checksum of the rootdisk or kernel artifacts inside the containerdisk",
	}
}

func (VirtualMachineInstanceCondition) SwaggerDoc() map[string]string {
	return map[string]string{
		"lastProbeTime":      "+nullable",
		"lastTransitionTime": "+nullable",
	}
}

func (VirtualMachineInstanceMigrationCondition) SwaggerDoc() map[string]string {
	return map[string]string{
		"lastProbeTime":      "+nullable",
		"lastTransitionTime": "+nullable",
	}
}

func (VirtualMachineInstanceNetworkInterface) SwaggerDoc() map[string]string {
	return map[string]string{
		"ipAddress":     "IP address of a Virtual Machine interface. It is always the first item of\nIPs",
		"mac":           "Hardware address of a Virtual Machine interface",
		"name":          "Name of the interface, corresponds to name of the network assigned to the interface",
		"ipAddresses":   "List of all IP addresses of a Virtual Machine interface",
		"interfaceName": "The interface name inside the Virtual Machine",
		"infoSource":    "Specifies the origin of the interface data collected. values: domain, guest-agent, multus-status.",
		"queueCount":    "Specifies how many queues are allocated by MultiQueue",
	}
}

func (VirtualMachineInstanceGuestOSInfo) SwaggerDoc() map[string]string {
	return map[string]string{
		"name":          "Name of the Guest OS",
		"kernelRelease": "Guest OS Kernel Release",
		"version":       "Guest OS Version",
		"prettyName":    "Guest OS Pretty Name",
		"versionId":     "Version ID of the Guest OS",
		"kernelVersion": "Kernel version of the Guest OS",
		"machine":       "Machine type of the Guest OS",
		"id":            "Guest OS Id",
	}
}

func (VirtualMachineInstanceMigrationState) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                               "+k8s:openapi-gen=true",
		"startTimestamp":                 "The time the migration action began\n+nullable",
		"endTimestamp":                   "The time the migration action ended\n+nullable",
		"targetNodeDomainReadyTimestamp": "The timestamp at which the target node detects the domain is active",
		"targetNodeDomainDetected":       "The Target Node has seen the Domain Start Event",
		"targetNodeAddress":              "The address of the target node to use for the migration",
		"targetDirectMigrationNodePorts": "The list of ports opened for live migration on the destination node",
		"targetNode":                     "The target node that the VMI is moving to",
		"targetPod":                      "The target pod that the VMI is moving to",
		"targetAttachmentPodUID":         "The UID of the target attachment pod for hotplug volumes",
		"sourceNode":                     "The source node that the VMI originated on",
		"completed":                      "Indicates the migration completed",
		"failed":                         "Indicates that the migration failed",
		"abortRequested":                 "Indicates that the migration has been requested to abort",
		"abortStatus":                    "Indicates the final status of the live migration abortion",
		"failureReason":                  "Contains the reason why the migration failed",
		"migrationUid":                   "The VirtualMachineInstanceMigration object associated with this migration",
		"mode":                           "Lets us know if the vmi is currently running pre or post copy migration",
		"migrationPolicyName":            "Name of the migration policy. If string is empty, no policy is matched",
		"migrationConfiguration":         "Migration configurations to apply",
		"targetCPUSet":                   "If the VMI requires dedicated CPUs, this field will\nhold the dedicated CPU set on the target node\n+listType=atomic",
		"targetNodeTopology":             "If the VMI requires dedicated CPUs, this field will\nhold the numa topology on the target node",
	}
}

func (VMISelector) SwaggerDoc() map[string]string {
	return map[string]string{
		"name": "Name of the VirtualMachineInstance to migrate",
	}
}

func (VirtualMachineInstanceReplicaSet) SwaggerDoc() map[string]string {
	return map[string]string{
		"":       "VirtualMachineInstance is *the* VirtualMachineInstance Definition. It represents a virtual machine in the runtime environment of kubernetes.\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object\n+genclient",
		"spec":   "VirtualMachineInstance Spec contains the VirtualMachineInstance specification.",
		"status": "Status is the high level overview of how the VirtualMachineInstance is doing. It contains information available to controllers and users.\n+nullable",
	}
}

func (VirtualMachineInstanceReplicaSetList) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "VMIList is a list of VMIs\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object",
	}
}

func (VirtualMachineInstanceReplicaSetSpec) SwaggerDoc() map[string]string {
	return map[string]string{
		"replicas": "Number of desired pods. This is a pointer to distinguish between explicit\nzero and not specified. Defaults to 1.\n+optional",
		"selector": "Label selector for pods. Existing ReplicaSets whose pods are\nselected by this will be the ones affected by this deployment.",
		"template": "Template describes the pods that will be created.",
		"paused":   "Indicates that the replica set is paused.\n+optional",
	}
}

func (VirtualMachineInstanceReplicaSetStatus) SwaggerDoc() map[string]string {
	return map[string]string{
		"replicas":      "Total number of non-terminated pods targeted by this deployment (their labels match the selector).\n+optional",
		"readyReplicas": "The number of ready replicas for this replica set.\n+optional",
		"labelSelector": "Canonical form of the label selector for HPA which consumes it through the scale subresource.",
	}
}

func (VirtualMachineInstanceReplicaSetCondition) SwaggerDoc() map[string]string {
	return map[string]string{
		"lastProbeTime":      "+nullable",
		"lastTransitionTime": "+nullable",
	}
}

func (DataVolumeTemplateDummyStatus) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (DataVolumeTemplateSpec) SwaggerDoc() map[string]string {
	return map[string]string{
		"spec":   "DataVolumeSpec contains the DataVolume specification.",
		"status": "DataVolumeTemplateDummyStatus is here simply for backwards compatibility with\na previous API.\n+nullable\n+optional",
	}
}

func (VirtualMachineInstanceTemplateSpec) SwaggerDoc() map[string]string {
	return map[string]string{
		"metadata": "+kubebuilder:pruning:PreserveUnknownFields\n+nullable",
		"spec":     "VirtualMachineInstance Spec contains the VirtualMachineInstance specification.",
	}
}

func (VirtualMachineInstanceMigration) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "VirtualMachineInstanceMigration represents the object tracking a VMI's migration\nto another host in the cluster\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object\n+genclient",
	}
}

func (VirtualMachineInstanceMigrationList) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "VirtualMachineInstanceMigrationList is a list of VirtualMachineMigrations\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object",
	}
}

func (VirtualMachineInstanceMigrationSpec) SwaggerDoc() map[string]string {
	return map[string]string{
		"vmiName": "The name of the VMI to perform the migration on. VMI must exist in the migration objects namespace",
	}
}

func (VirtualMachineInstanceMigrationPhaseTransitionTimestamp) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                         "VirtualMachineInstanceMigrationPhaseTransitionTimestamp gives a timestamp in relation to when a phase is set on a vmi",
		"phase":                    "Phase is the status of the VirtualMachineInstanceMigrationPhase in kubernetes world. It is not the VirtualMachineInstanceMigrationPhase status, but partially correlates to it.",
		"phaseTransitionTimestamp": "PhaseTransitionTimestamp is the timestamp of when the phase change occurred",
	}
}

func (VirtualMachineInstanceMigrationStatus) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                          "VirtualMachineInstanceMigration reprents information pertaining to a VMI's migration.",
		"phaseTransitionTimestamps": "PhaseTransitionTimestamp is the timestamp of when the last phase change occurred\n+listType=atomic\n+optional",
		"migrationState":            "Represents the status of a live migration",
	}
}

func (VirtualMachineInstancePreset) SwaggerDoc() map[string]string {
	return map[string]string{
		"":     "Deprecated for removal in v2, please use VirtualMachineInstanceType and VirtualMachinePreference instead.\n\nVirtualMachineInstancePreset defines a VMI spec.domain to be applied to all VMIs that match the provided label selector\nMore info: https://kubevirt.io/user-guide/virtual_machines/presets/#overrides\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object\n+genclient",
		"spec": "VirtualMachineInstance Spec contains the VirtualMachineInstance specification.",
	}
}

func (VirtualMachineInstancePresetList) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "VirtualMachineInstancePresetList is a list of VirtualMachinePresets\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object",
	}
}

func (VirtualMachineInstancePresetSpec) SwaggerDoc() map[string]string {
	return map[string]string{
		"selector": "Selector is a label query over a set of VMIs.\nRequired.",
		"domain":   "Domain is the same object type as contained in VirtualMachineInstanceSpec",
	}
}

func (VirtualMachine) SwaggerDoc() map[string]string {
	return map[string]string{
		"":       "VirtualMachine handles the VirtualMachines that are not running\nor are in a stopped state\nThe VirtualMachine contains the template to create the\nVirtualMachineInstance. It also mirrors the running state of the created\nVirtualMachineInstance in its status.\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object\n+genclient",
		"spec":   "Spec contains the specification of VirtualMachineInstance created",
		"status": "Status holds the current state of the controller and brief information\nabout its associated VirtualMachineInstance",
	}
}

func (VirtualMachineList) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "VirtualMachineList is a list of virtualmachines\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object",
	}
}

func (VirtualMachineSpec) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                    "VirtualMachineSpec describes how the proper VirtualMachine\nshould look like",
		"running":             "Running controls whether the associatied VirtualMachineInstance is created or not\nMutually exclusive with RunStrategy",
		"runStrategy":         "Running state indicates the requested running state of the VirtualMachineInstance\nmutually exclusive with Running",
		"instancetype":        "InstancetypeMatcher references a instancetype that is used to fill fields in Template",
		"preference":          "PreferenceMatcher references a set of preference that is used to fill fields in Template",
		"template":            "Template is the direct specification of VirtualMachineInstance",
		"dataVolumeTemplates": "dataVolumeTemplates is a list of dataVolumes that the VirtualMachineInstance template can reference.\nDataVolumes in this list are dynamically created for the VirtualMachine and are tied to the VirtualMachine's life-cycle.",
	}
}

func (VirtualMachineStartFailure) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "VirtualMachineStartFailure tracks VMIs which failed to transition successfully\nto running using the VM status",
	}
}

func (VirtualMachineStatus) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                       "VirtualMachineStatus represents the status returned by the\ncontroller to describe how the VirtualMachine is doing",
		"snapshotInProgress":     "SnapshotInProgress is the name of the VirtualMachineSnapshot currently executing",
		"restoreInProgress":      "RestoreInProgress is the name of the VirtualMachineRestore currently executing",
		"created":                "Created indicates if the virtual machine is created in the cluster",
		"ready":                  "Ready indicates if the virtual machine is running and ready",
		"printableStatus":        "PrintableStatus is a human readable, high-level representation of the status of the virtual machine\n+kubebuilder:default=Stopped",
		"conditions":             "Hold the state information of the VirtualMachine and its VirtualMachineInstance",
		"stateChangeRequests":    "StateChangeRequests indicates a list of actions that should be taken on a VMI\ne.g. stop a specific VMI then start a new one.",
		"volumeRequests":         "VolumeRequests indicates a list of volumes add or remove from the VMI template and\nhotplug on an active running VMI.\n+listType=atomic",
		"volumeSnapshotStatuses": "VolumeSnapshotStatuses indicates a list of statuses whether snapshotting is\nsupported by each volume.",
		"startFailure":           "StartFailure tracks consecutive VMI startup failures for the purposes of\ncrash loop backoffs\n+nullable\n+optional",
		"memoryDumpRequest":      "MemoryDumpRequest tracks memory dump request phase and info of getting a memory\ndump to the given pvc\n+nullable\n+optional",
		"observedGeneration":     "ObservedGeneration is the generation observed by the vmi when started.\n+optional",
		"desiredGeneration":      "DesiredGeneration is the generation which is desired for the VMI.\nThis will be used in comparisons with ObservedGeneration to understand when\nthe VMI is out of sync. This will be changed at the same time as\nObservedGeneration to remove errors which could occur if Generation is\nupdated through an Update() before ObservedGeneration in Status.\n+optional",
		"runStrategy":            "RunStrategy tracks the last recorded RunStrategy used by the VM.\nThis is needed to correctly process the next strategy (for now only the RerunOnFailure)",
	}
}

func (VolumeSnapshotStatus) SwaggerDoc() map[string]string {
	return map[string]string{
		"name":    "Volume name",
		"enabled": "True if the volume supports snapshotting",
		"reason":  "Empty if snapshotting is enabled, contains reason otherwise",
	}
}

func (VirtualMachineVolumeRequest) SwaggerDoc() map[string]string {
	return map[string]string{
		"addVolumeOptions":    "AddVolumeOptions when set indicates a volume should be added. The details\nwithin this field specify how to add the volume",
		"removeVolumeOptions": "RemoveVolumeOptions when set indicates a volume should be removed. The details\nwithin this field specify how to add the volume",
	}
}

func (VirtualMachineStateChangeRequest) SwaggerDoc() map[string]string {
	return map[string]string{
		"action": "Indicates the type of action that is requested. e.g. Start or Stop",
		"data":   "Provides additional data in order to perform the Action",
		"uid":    "Indicates the UUID of an existing Virtual Machine Instance that this change request applies to -- if applicable",
	}
}

func (VirtualMachineCondition) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                   "VirtualMachineCondition represents the state of VirtualMachine",
		"lastProbeTime":      "+nullable",
		"lastTransitionTime": "+nullable",
	}
}

func (Handler) SwaggerDoc() map[string]string {
	return map[string]string{
		"":               "Handler defines a specific action that should be taken",
		"exec":           "One and only one of the following should be specified.\nExec specifies the action to take, it will be executed on the guest through the qemu-guest-agent.\nIf the guest agent is not available, this probe will fail.\n+optional",
		"guestAgentPing": "GuestAgentPing contacts the qemu-guest-agent for availability checks.\n+optional",
		"httpGet":        "HTTPGet specifies the http request to perform.\n+optional",
		"tcpSocket":      "TCPSocket specifies an action involving a TCP port.\nTCP hooks not yet supported\n+optional",
	}
}

func (Probe) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                    "Probe describes a health check to be performed against a VirtualMachineInstance to determine whether it is\nalive or ready to receive traffic.",
		"initialDelaySeconds": "Number of seconds after the VirtualMachineInstance has started before liveness probes are initiated.\nMore info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes\n+optional",
		"timeoutSeconds":      "Number of seconds after which the probe times out.\nFor exec probes the timeout fails the probe but does not terminate the command running on the guest.\nThis means a blocking command can result in an increasing load on the guest.\nA small buffer will be added to the resulting workload exec probe to compensate for delays\ncaused by the qemu guest exec mechanism.\nDefaults to 1 second. Minimum value is 1.\nMore info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes\n+optional",
		"periodSeconds":       "How often (in seconds) to perform the probe.\nDefault to 10 seconds. Minimum value is 1.\n+optional",
		"successThreshold":    "Minimum consecutive successes for the probe to be considered successful after having failed.\nDefaults to 1. Must be 1 for liveness. Minimum value is 1.\n+optional",
		"failureThreshold":    "Minimum consecutive failures for the probe to be considered failed after having succeeded.\nDefaults to 3. Minimum value is 1.\n+optional",
	}
}

func (KubeVirt) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "KubeVirt represents the object deploying all KubeVirt resources\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object\n+genclient",
	}
}

func (KubeVirtList) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "KubeVirtList is a list of KubeVirts\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object",
	}
}

func (KubeVirtSelfSignConfiguration) SwaggerDoc() map[string]string {
	return map[string]string{
		"caRotateInterval":   "Deprecated. Use CA.Duration instead",
		"certRotateInterval": "Deprecated. Use Server.Duration instead",
		"caOverlapInterval":  "Deprecated. Use CA.Duration and CA.RenewBefore instead",
		"ca":                 "CA configuration\nCA certs are kept in the CA bundle as long as they are valid",
		"server":             "Server configuration\nCerts are rotated and discarded",
	}
}

func (CertConfig) SwaggerDoc() map[string]string {
	return map[string]string{
		"":            "CertConfig contains the tunables for TLS certificates",
		"duration":    "The requested 'duration' (i.e. lifetime) of the Certificate.",
		"renewBefore": "The amount of time before the currently issued certificate's \"notAfter\"\ntime that we will begin to attempt to renew the certificate.",
	}
}

func (KubeVirtCertificateRotateStrategy) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (KubeVirtWorkloadUpdateStrategy) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                      "KubeVirtWorkloadUpdateStrategy defines options related to updating a KubeVirt install",
		"workloadUpdateMethods": "WorkloadUpdateMethods defines the methods that can be used to disrupt workloads\nduring automated workload updates.\nWhen multiple methods are present, the least disruptive method takes\nprecedence over more disruptive methods. For example if both LiveMigrate and Shutdown\nmethods are listed, only VMs which are not live migratable will be restarted/shutdown\n\nAn empty list defaults to no automated workload updating\n\n+listType=atomic\n+optional",
		"batchEvictionSize":     "BatchEvictionSize Represents the number of VMIs that can be forced updated per\nthe BatchShutdownInteral interval\n\nDefaults to 10\n\n+optional",
		"batchEvictionInterval": "BatchEvictionInterval Represents the interval to wait before issuing the next\nbatch of shutdowns\n\nDefaults to 1 minute\n\n+optional",
	}
}

func (KubeVirtSpec) SwaggerDoc() map[string]string {
	return map[string]string{
		"imageTag":                "The image tag to use for the continer images installed.\nDefaults to the same tag as the operator's container image.",
		"imageRegistry":           "The image registry to pull the container images from\nDefaults to the same registry the operator's container image is pulled from.",
		"imagePullPolicy":         "The ImagePullPolicy to use.",
		"imagePullSecrets":        "The imagePullSecrets to pull the container images from\nDefaults to none\n+listType=atomic",
		"monitorNamespace":        "The namespace Prometheus is deployed in\nDefaults to openshift-monitor",
		"serviceMonitorNamespace": "The namespace the service monitor will be deployed\n When ServiceMonitorNamespace is set, then we'll install the service monitor object in that namespace\notherwise we will use the monitoring namespace.",
		"monitorAccount":          "The name of the Prometheus service account that needs read-access to KubeVirt endpoints\nDefaults to prometheus-k8s",
		"workloadUpdateStrategy":  "WorkloadUpdateStrategy defines at the cluster level how to handle\nautomated workload updates",
		"uninstallStrategy":       "Specifies if kubevirt can be deleted if workloads are still present.\nThis is mainly a precaution to avoid accidental data loss",
		"productVersion":          "Designate the apps.kubevirt.io/version label for KubeVirt components.\nUseful if KubeVirt is included as part of a product.\nIf ProductVersion is not specified, KubeVirt's version will be used.",
		"productName":             "Designate the apps.kubevirt.io/part-of label for KubeVirt components.\nUseful if KubeVirt is included as part of a product.\nIf ProductName is not specified, the part-of label will be omitted.",
		"productComponent":        "Designate the apps.kubevirt.io/component label for KubeVirt components.\nUseful if KubeVirt is included as part of a product.\nIf ProductComponent is not specified, the component label default value is kubevirt.",
		"configuration":           "holds kubevirt configurations.\nsame as the virt-configMap",
		"infra":                   "selectors and tolerations that should apply to KubeVirt infrastructure components\n+optional",
		"workloads":               "selectors and tolerations that should apply to KubeVirt workloads\n+optional",
	}
}

func (CustomizeComponents) SwaggerDoc() map[string]string {
	return map[string]string{
		"patches": "+listType=atomic",
		"flags":   "Configure the value used for deployment and daemonset resources",
	}
}

func (Flags) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "Flags will create a patch that will replace all flags for the container's\ncommand field. The only flags that will be used are those define. There are no\nguarantees around forward/backward compatibility.  If set incorrectly this will\ncause the resource when rolled out to error until flags are updated.",
	}
}

func (CustomizeComponentsPatch) SwaggerDoc() map[string]string {
	return map[string]string{
		"resourceName": "+kubebuilder:validation:MinLength=1",
		"resourceType": "+kubebuilder:validation:MinLength=1",
	}
}

func (GenerationStatus) SwaggerDoc() map[string]string {
	return map[string]string{
		"":               "GenerationStatus keeps track of the generation for a given resource so that decisions about forced updates can be made.",
		"group":          "group is the group of the thing you're tracking",
		"resource":       "resource is the resource type of the thing you're tracking",
		"namespace":      "namespace is where the thing you're tracking is\n+optional",
		"name":           "name is the name of the thing you're tracking",
		"lastGeneration": "lastGeneration is the last generation of the workload controller involved",
		"hash":           "hash is an optional field set for resources without generation that are content sensitive like secrets and configmaps\n+optional",
	}
}

func (KubeVirtStatus) SwaggerDoc() map[string]string {
	return map[string]string{
		"":            "KubeVirtStatus represents information pertaining to a KubeVirt deployment.",
		"generations": "+listType=atomic",
	}
}

func (KubeVirtCondition) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                   "KubeVirtCondition represents a condition of a KubeVirt deployment",
		"lastProbeTime":      "+optional\n+nullable",
		"lastTransitionTime": "+optional\n+nullable",
	}
}

func (RestartOptions) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                   "RestartOptions may be provided when deleting an API object.",
		"gracePeriodSeconds": "The duration in seconds before the object should be force-restarted. Value must be non-negative integer.\nThe value zero indicates, restart immediately. If this value is nil, the default grace period for deletion of the corresponding VMI for the\nspecified type will be used to determine on how much time to give the VMI to restart.\nDefaults to a per object value if not specified. zero means restart immediately.\nAllowed Values: nil and 0\n+optional",
		"dryRun":             "When present, indicates that modifications should not be\npersisted. An invalid or unrecognized dryRun directive will\nresult in an error response and no further processing of the\nrequest. Valid values are:\n- All: all dry run stages will be processed\n+optional\n+listType=atomic",
	}
}

func (StartOptions) SwaggerDoc() map[string]string {
	return map[string]string{
		"":       "StartOptions may be provided on start request.",
		"paused": "Indicates that VM will be started in paused state.\n+optional",
		"dryRun": "When present, indicates that modifications should not be\npersisted. An invalid or unrecognized dryRun directive will\nresult in an error response and no further processing of the\nrequest. Valid values are:\n- All: all dry run stages will be processed\n+optional\n+listType=atomic",
	}
}

func (PauseOptions) SwaggerDoc() map[string]string {
	return map[string]string{
		"":       "PauseOptions may be provided on pause request.",
		"dryRun": "When present, indicates that modifications should not be\npersisted. An invalid or unrecognized dryRun directive will\nresult in an error response and no further processing of the\nrequest. Valid values are:\n- All: all dry run stages will be processed\n+optional\n+listType=atomic",
	}
}

func (UnpauseOptions) SwaggerDoc() map[string]string {
	return map[string]string{
		"":       "UnpauseOptions may be provided on unpause request.",
		"dryRun": "When present, indicates that modifications should not be\npersisted. An invalid or unrecognized dryRun directive will\nresult in an error response and no further processing of the\nrequest. Valid values are:\n- All: all dry run stages will be processed\n+optional\n+listType=atomic",
	}
}

func (StopOptions) SwaggerDoc() map[string]string {
	return map[string]string{
		"":            "StopOptions may be provided when deleting an API object.",
		"gracePeriod": "this updates the VMIs terminationGracePeriodSeconds during shutdown\n+optional",
		"dryRun":      "When present, indicates that modifications should not be\npersisted. An invalid or unrecognized dryRun directive will\nresult in an error response and no further processing of the\nrequest. Valid values are:\n- All: all dry run stages will be processed\n+optional\n+listType=atomic",
	}
}

func (MigrateOptions) SwaggerDoc() map[string]string {
	return map[string]string{
		"":       "MigrateOptions may be provided on migrate request.",
		"dryRun": "When present, indicates that modifications should not be\npersisted. An invalid or unrecognized dryRun directive will\nresult in an error response and no further processing of the\nrequest. Valid values are:\n- All: all dry run stages will be processed\n+optional\n+listType=atomic",
	}
}

func (VirtualMachineInstanceGuestAgentInfo) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                  "VirtualMachineInstanceGuestAgentInfo represents information from the installed guest agent\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object",
		"guestAgentVersion": "GAVersion is a version of currently installed guest agent",
		"supportedCommands": "Return command list the guest agent supports\n+listType=atomic",
		"hostname":          "Hostname represents FQDN of a guest",
		"os":                "OS contains the guest operating system information",
		"timezone":          "Timezone is guest os current timezone",
		"userList":          "UserList is a list of active guest OS users",
		"fsInfo":            "FSInfo is a guest os filesystem information containing the disk mapping and disk mounts with usage",
		"fsFreezeStatus":    "FSFreezeStatus is the state of the fs of the guest\nit can be either frozen or thawed",
	}
}

func (GuestAgentCommandInfo) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "List of commands that QEMU guest agent supports",
	}
}

func (VirtualMachineInstanceGuestOSUserList) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "VirtualMachineInstanceGuestOSUserList comprises the list of all active users on guest machine\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object",
	}
}

func (VirtualMachineInstanceGuestOSUser) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "VirtualMachineGuestOSUser is the single user of the guest os",
	}
}

func (VirtualMachineInstanceFileSystemInfo) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "VirtualMachineInstanceFileSystemInfo represents information regarding single guest os filesystem",
	}
}

func (VirtualMachineInstanceFileSystemList) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "VirtualMachineInstanceFileSystemList comprises the list of all filesystems on guest machine\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object",
	}
}

func (VirtualMachineInstanceFileSystemDisk) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "VirtualMachineInstanceFileSystemDisk represents the guest os FS disks",
	}
}

func (VirtualMachineInstanceFileSystem) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "VirtualMachineInstanceFileSystem represents guest os disk",
	}
}

func (FreezeUnfreezeTimeout) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "FreezeUnfreezeTimeout represent the time unfreeze will be triggered if guest was not unfrozen by unfreeze command",
	}
}

func (VirtualMachineMemoryDumpRequest) SwaggerDoc() map[string]string {
	return map[string]string{
		"":               "VirtualMachineMemoryDumpRequest represent the memory dump request phase and info",
		"claimName":      "ClaimName is the name of the pvc that will contain the memory dump",
		"phase":          "Phase represents the memory dump phase",
		"remove":         "Remove represents request of dissociating the memory dump pvc\n+optional",
		"startTimestamp": "StartTimestamp represents the time the memory dump started\n+optional",
		"endTimestamp":   "EndTimestamp represents the time the memory dump was completed\n+optional",
		"fileName":       "FileName represents the name of the output file\n+optional",
		"message":        "Message is a detailed message about failure of the memory dump\n+optional",
	}
}

func (AddVolumeOptions) SwaggerDoc() map[string]string {
	return map[string]string{
		"":             "AddVolumeOptions is provided when dynamically hot plugging a volume and disk",
		"name":         "Name represents the name that will be used to map the\ndisk to the corresponding volume. This overrides any name\nset inside the Disk struct itself.",
		"disk":         "Disk represents the hotplug disk that will be plugged into the running VMI",
		"volumeSource": "VolumeSource represents the source of the volume to map to the disk.",
		"dryRun":       "When present, indicates that modifications should not be\npersisted. An invalid or unrecognized dryRun directive will\nresult in an error response and no further processing of the\nrequest. Valid values are:\n- All: all dry run stages will be processed\n+optional\n+listType=atomic",
	}
}

func (ScreenshotOptions) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (VSOCKOptions) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (RemoveVolumeOptions) SwaggerDoc() map[string]string {
	return map[string]string{
		"":       "RemoveVolumeOptions is provided when dynamically hot unplugging volume and disk",
		"name":   "Name represents the name that maps to both the disk and volume that\nshould be removed",
		"dryRun": "When present, indicates that modifications should not be\npersisted. An invalid or unrecognized dryRun directive will\nresult in an error response and no further processing of the\nrequest. Valid values are:\n- All: all dry run stages will be processed\n+optional\n+listType=atomic",
	}
}

func (TokenBucketRateLimiter) SwaggerDoc() map[string]string {
	return map[string]string{
		"qps":   "QPS indicates the maximum QPS to the apiserver from this client.\nIf it's zero, the component default will be used",
		"burst": "Maximum burst for throttle.\nIf it's zero, the component default will be used",
	}
}

func (RateLimiter) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (RESTClientConfiguration) SwaggerDoc() map[string]string {
	return map[string]string{
		"":            "RESTClientConfiguration allows configuring certain aspects of the k8s rest client.",
		"rateLimiter": "RateLimiter allows selecting and configuring different rate limiters for the k8s client.",
	}
}

func (ReloadableComponentConfiguration) SwaggerDoc() map[string]string {
	return map[string]string{
		"":           "ReloadableComponentConfiguration holds all generic k8s configuration options which can\nbe reloaded by components without requiring a restart.",
		"restClient": "RestClient can be used to tune certain aspects of the k8s client in use.",
	}
}

func (KubeVirtConfiguration) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                                   "KubeVirtConfiguration holds all kubevirt configurations",
		"emulatedMachines":                   "Deprecated. Use architectureConfiguration instead.",
		"machineType":                        "Deprecated. Use architectureConfiguration instead.",
		"ovmfPath":                           "Deprecated. Use architectureConfiguration instead.",
		"evictionStrategy":                   "EvictionStrategy defines at the cluster level if the VirtualMachineInstance should be\nmigrated instead of shut-off in case of a node drain. If the VirtualMachineInstance specific\nfield is set it overrides the cluster level one.",
		"additionalGuestMemoryOverheadRatio": "AdditionalGuestMemoryOverheadRatio can be used to increase the virtualization infrastructure\noverhead. This is useful, since the calculation of this overhead is not accurate and cannot\nbe entirely known in advance. The ratio that is being set determines by which factor to increase\nthe overhead calculated by Kubevirt. A higher ratio means that the VMs would be less compromised\nby node pressures, but would mean that fewer VMs could be scheduled to a node.\nIf not set, the default is 1.",
		"supportContainerResources":          "+listType=map\n+listMapKey=type\nSupportContainerResources specifies the resource requirements for various types of supporting containers such as container disks/virtiofs/sidecars and hotplug attachment pods. If omitted a sensible default will be supplied.",
		"supportedGuestAgentVersions":        "deprecated",
		"vmStateStorageClass":                "VMStateStorageClass is the name of the storage class to use for the PVCs created to preserve VM state, like TPM.\nThe storage class must support RWX in filesystem mode.",
		"ksmConfiguration":                   "KSMConfiguration holds the information regarding the enabling the KSM in the nodes (if available).",
		"autoCPULimitNamespaceLabelSelector": "When set, AutoCPULimitNamespaceLabelSelector will set a CPU limit on virt-launcher for VMIs running inside\nnamespaces that match the label selector.\nThe CPU limit will equal the number of requested vCPUs.\nThis setting does not apply to VMIs with dedicated CPUs.",
		"liveUpdateConfiguration":            "LiveUpdateConfiguration holds defaults for live update features",
		"vmRolloutStrategy":                  "VMRolloutStrategy defines how changes to a VM object propagate to its VMI\n+nullable\n+kubebuilder:validation:Enum=Stage;LiveUpdate",
	}
}

func (ArchConfiguration) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (ArchSpecificConfiguration) SwaggerDoc() map[string]string {
	return map[string]string{
		"emulatedMachines": "+listType=atomic",
	}
}

func (SMBiosConfiguration) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (SupportContainerResources) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "SupportContainerResources are used to specify the cpu/memory request and limits for the containers that support various features of Virtual Machines. These containers are usually idle and don't require a lot of memory or cpu.",
	}
}

func (CustomProfile) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (VirtualMachineInstanceProfile) SwaggerDoc() map[string]string {
	return map[string]string{
		"customProfile": "CustomProfile allows to request arbitrary profile for virt-launcher",
	}
}

func (SeccompConfiguration) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                              "SeccompConfiguration holds Seccomp configuration for Kubevirt components",
		"virtualMachineInstanceProfile": "VirtualMachineInstanceProfile defines what profile should be used with virt-launcher. Defaults to none",
	}
}

func (VirtualMachineOptions) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                         "VirtualMachineOptions holds the cluster level information regarding the virtual machine.",
		"disableFreePageReporting": "DisableFreePageReporting disable the free page reporting of\nmemory balloon device https://libvirt.org/formatdomain.html#memory-balloon-device.\nThis will have effect only if AutoattachMemBalloon is not false and the vmi is not\nrequesting any high performance feature (dedicatedCPU/realtime/hugePages), in which free page reporting is always disabled.",
		"disableSerialConsoleLog":  "DisableSerialConsoleLog disables logging the auto-attached default serial console.\nIf not set, serial console logs will be written to a file and then streamed from a container named `guest-console-log`.\nThe value can be individually overridden for each VM, not relevant if AutoattachSerialConsole is disabled.",
	}
}

func (DisableFreePageReporting) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (DisableSerialConsoleLog) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (TLSConfiguration) SwaggerDoc() map[string]string {
	return map[string]string{
		"":              "TLSConfiguration holds TLS options",
		"minTLSVersion": "MinTLSVersion is a way to specify the minimum protocol version that is acceptable for TLS connections.\nProtocol versions are based on the following most common TLS configurations:\n\n  https://ssl-config.mozilla.org/\n\nNote that SSLv3.0 is not a supported protocol version due to well known\nvulnerabilities such as POODLE: https://en.wikipedia.org/wiki/POODLE\n+kubebuilder:validation:Enum=VersionTLS10;VersionTLS11;VersionTLS12;VersionTLS13",
		"ciphers":       "+listType=set",
	}
}

func (MigrationConfiguration) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                                  "MigrationConfiguration holds migration options.\nCan be overridden for specific groups of VMs though migration policies.\nVisit https://kubevirt.io/user-guide/operations/migration_policies/ for more information.",
		"nodeDrainTaintKey":                 "NodeDrainTaintKey defines the taint key that indicates a node should be drained.\nNote: this option relies on the deprecated node taint feature. Default: kubevirt.io/drain",
		"parallelOutboundMigrationsPerNode": "ParallelOutboundMigrationsPerNode is the maximum number of concurrent outgoing live migrations\nallowed per node. Defaults to 2",
		"parallelMigrationsPerCluster":      "ParallelMigrationsPerCluster is the total number of concurrent live migrations\nallowed cluster-wide. Defaults to 5",
		"allowAutoConverge":                 "AllowAutoConverge allows the platform to compromise performance/availability of VMIs to\nguarantee successful VMI live migrations. Defaults to false",
		"bandwidthPerMigration":             "BandwidthPerMigration limits the amount of network bandwidth live migrations are allowed to use.\nThe value is in quantity per second. Defaults to 0 (no limit)",
		"completionTimeoutPerGiB":           "CompletionTimeoutPerGiB is the maximum number of seconds per GiB a migration is allowed to take.\nIf a live-migration takes longer to migrate than this value multiplied by the size of the VMI,\nthe migration will be cancelled, unless AllowPostCopy is true. Defaults to 800",
		"progressTimeout":                   "ProgressTimeout is the maximum number of seconds a live migration is allowed to make no progress.\nHitting this timeout means a migration transferred 0 data for that many seconds. The migration is\nthen considered stuck and therefore cancelled. Defaults to 150",
		"unsafeMigrationOverride":           "UnsafeMigrationOverride allows live migrations to occur even if the compatibility check\nindicates the migration will be unsafe to the guest. Defaults to false",
		"allowPostCopy":                     "AllowPostCopy enables post-copy live migrations. Such migrations allow even the busiest VMIs\nto successfully live-migrate. However, events like a network failure can cause a VMI crash.\nIf set to true, migrations will still start in pre-copy, but switch to post-copy when\nCompletionTimeoutPerGiB triggers. Defaults to false",
		"disableTLS":                        "When set to true, DisableTLS will disable the additional layer of live migration encryption\nprovided by KubeVirt. This is usually a bad idea. Defaults to false",
		"network":                           "Network is the name of the CNI network to use for live migrations. By default, migrations go\nthrough the pod network.",
		"matchSELinuxLevelOnMigration":      "By default, the SELinux level of target virt-launcher pods is forced to the level of the source virt-launcher.\nWhen set to true, MatchSELinuxLevelOnMigration lets the CRI auto-assign a random level to the target.\nThat will ensure the target virt-launcher doesn't share categories with another pod on the node.\nHowever, migrations will fail when using RWX volumes that don't automatically deal with SELinux levels.",
	}
}

func (DiskVerification) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "DiskVerification holds container disks verification limits",
	}
}

func (DeveloperConfiguration) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                                "DeveloperConfiguration holds developer options",
		"featureGates":                    "FeatureGates is the list of experimental features to enable. Defaults to none",
		"pvcTolerateLessSpaceUpToPercent": "LessPVCSpaceToleration determines how much smaller, in percentage, disk PVCs are\nallowed to be compared to the requested size (to account for various overheads).\nDefaults to 10",
		"minimumReservePVCBytes":          "MinimumReservePVCBytes is the amount of space, in bytes, to leave unused on disks.\nDefaults to 131072 (128KiB)",
		"memoryOvercommit":                "MemoryOvercommit is the percentage of memory we want to give VMIs compared to the amount\ngiven to its parent pod (virt-launcher). For example, a value of 102 means the VMI will\n\"see\" 2% more memory than its parent pod. Values under 100 are effectively \"undercommits\".\nOvercommits can lead to memory exhaustion, which in turn can lead to crashes. Use carefully.\nDefaults to 100",
		"nodeSelectors":                   "NodeSelectors allows restricting VMI creation to nodes that match a set of labels.\nDefaults to none",
		"useEmulation":                    "UseEmulation can be set to true to allow fallback to software emulation\nin case hardware-assisted emulation is not available. Defaults to false",
		"cpuAllocationRatio":              "For each requested virtual CPU, CPUAllocationRatio defines how much physical CPU to request per VMI\nfrom the hosting node. The value is in fraction of a CPU thread (or core on non-hyperthreaded nodes).\nFor example, a value of 1 means 1 physical CPU thread per VMI CPU thread.\nA value of 100 would be 1% of a physical thread allocated for each requested VMI thread.\nThis option has no effect on VMIs that request dedicated CPUs. More information at:\nhttps://kubevirt.io/user-guide/operations/node_overcommit/#node-cpu-allocation-ratio\nDefaults to 10",
		"minimumClusterTSCFrequency":      "Allow overriding the automatically determined minimum TSC frequency of the cluster\nand fixate the minimum to this frequency.",
	}
}

func (LogVerbosity) SwaggerDoc() map[string]string {
	return map[string]string{
		"":              "LogVerbosity sets log verbosity level of  various components",
		"nodeVerbosity": "NodeVerbosity represents a map of nodes with a specific verbosity level",
	}
}

func (PermittedHostDevices) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                "PermittedHostDevices holds information about devices allowed for passthrough",
		"pciHostDevices":  "+listType=atomic",
		"mediatedDevices": "+listType=atomic",
		"usb":             "+listType=atomic",
	}
}

func (USBHostDevice) SwaggerDoc() map[string]string {
	return map[string]string{
		"resourceName":             "Identifies the list of USB host devices.\ne.g: kubevirt.io/storage, kubevirt.io/bootable-usb, etc",
		"selectors":                "+listType=atomic",
		"externalResourceProvider": "If true, KubeVirt will leave the allocation and monitoring to an\nexternal device plugin",
	}
}

func (USBSelector) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (PciHostDevice) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                         "PciHostDevice represents a host PCI device allowed for passthrough",
		"pciVendorSelector":        "The vendor_id:product_id tuple of the PCI device",
		"resourceName":             "The name of the resource that is representing the device. Exposed by\na device plugin and requested by VMs. Typically of the form\nvendor.com/product_name",
		"externalResourceProvider": "If true, KubeVirt will leave the allocation and monitoring to an\nexternal device plugin",
	}
}

func (MediatedHostDevice) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "MediatedHostDevice represents a host mediated device allowed for passthrough",
	}
}

func (MediatedDevicesConfiguration) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                        "MediatedDevicesConfiguration holds information about MDEV types to be defined, if available",
		"mediatedDevicesTypes":    "Deprecated. Use mediatedDeviceTypes instead.\n+optional\n+listType=atomic",
		"mediatedDeviceTypes":     "+optional\n+listType=atomic",
		"nodeMediatedDeviceTypes": "+optional\n+listType=atomic",
	}
}

func (NodeMediatedDeviceTypesConfig) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                     "NodeMediatedDeviceTypesConfig holds information about MDEV types to be defined in a specific node that matches the NodeSelector field.\n+k8s:openapi-gen=true",
		"nodeSelector":         "NodeSelector is a selector which must be true for the vmi to fit on a node.\nSelector which must match a node's labels for the vmi to be scheduled on that node.\nMore info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/",
		"mediatedDevicesTypes": "Deprecated. Use mediatedDeviceTypes instead.\n+optional\n+listType=atomic",
		"mediatedDeviceTypes":  "+optional\n+listType=atomic",
	}
}

func (KSMConfiguration) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                  "KSMConfiguration holds information about KSM.\n+k8s:openapi-gen=true",
		"nodeLabelSelector": "NodeLabelSelector is a selector that filters in which nodes the KSM will be enabled.\nEmpty NodeLabelSelector will enable ksm for every node.\n+optional",
	}
}

func (NetworkConfiguration) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "NetworkConfiguration holds network options",
	}
}

func (InterfaceBindingPlugin) SwaggerDoc() map[string]string {
	return map[string]string{
		"sidecarImage":                "SidecarImage references a container image that runs in the virt-launcher pod.\nThe sidecar handles (libvirt) domain configuration and optional services.\nversion: 1alphav1",
		"networkAttachmentDefinition": "NetworkAttachmentDefinition references to a NetworkAttachmentDefinition CR object.\nFormat: <name>, <namespace>/<name>.\nIf namespace is not specified, VMI namespace is assumed.\nversion: 1alphav1",
		"domainAttachmentType":        "DomainAttachmentType is a standard domain network attachment method kubevirt supports.\nSupported values: \"tap\".\nThe standard domain attachment can be used instead or in addition to the sidecarImage.\nversion: 1alphav1",
		"migration":                   "Migration means the VM using the plugin can be safely migrated\nversion: 1alphav1",
	}
}

func (InterfaceBindingMigration) SwaggerDoc() map[string]string {
	return map[string]string{
		"method": "Method defines a pre-defined migration methodology\nversion: 1alphav1",
	}
}

func (GuestAgentPing) SwaggerDoc() map[string]string {
	return map[string]string{
		"": "GuestAgentPing configures the guest-agent based ping probe",
	}
}

func (ProfilerResult) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (ClusterProfilerResults) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (ClusterProfilerRequest) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (InstancetypeMatcher) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                             "InstancetypeMatcher references a instancetype that is used to fill fields in the VMI template.",
		"name":                         "Name is the name of the VirtualMachineInstancetype or VirtualMachineClusterInstancetype\n\n+optional",
		"kind":                         "Kind specifies which instancetype resource is referenced.\nAllowed values are: \"VirtualMachineInstancetype\" and \"VirtualMachineClusterInstancetype\".\nIf not specified, \"VirtualMachineClusterInstancetype\" is used by default.\n\n+optional",
		"revisionName":                 "RevisionName specifies a ControllerRevision containing a specific copy of the\nVirtualMachineInstancetype or VirtualMachineClusterInstancetype to be used. This is initially\ncaptured the first time the instancetype is applied to the VirtualMachineInstance.\n\n+optional",
		"inferFromVolume":              "InferFromVolume lists the name of a volume that should be used to infer or discover the instancetype\nto be used through known annotations on the underlying resource. Once applied to the InstancetypeMatcher\nthis field is removed.\n\n+optional",
		"inferFromVolumeFailurePolicy": "InferFromVolumeFailurePolicy controls what should happen on failure when inferring the instancetype.\nAllowed values are: \"RejectInferFromVolumeFailure\" and \"IgnoreInferFromVolumeFailure\".\nIf not specified, \"RejectInferFromVolumeFailure\" is used by default.\n\n+optional",
	}
}

func (PreferenceMatcher) SwaggerDoc() map[string]string {
	return map[string]string{
		"":                             "PreferenceMatcher references a set of preference that is used to fill fields in the VMI template.",
		"name":                         "Name is the name of the VirtualMachinePreference or VirtualMachineClusterPreference\n\n+optional",
		"kind":                         "Kind specifies which preference resource is referenced.\nAllowed values are: \"VirtualMachinePreference\" and \"VirtualMachineClusterPreference\".\nIf not specified, \"VirtualMachineClusterPreference\" is used by default.\n\n+optional",
		"revisionName":                 "RevisionName specifies a ControllerRevision containing a specific copy of the\nVirtualMachinePreference or VirtualMachineClusterPreference to be used. This is\ninitially captured the first time the instancetype is applied to the VirtualMachineInstance.\n\n+optional",
		"inferFromVolume":              "InferFromVolume lists the name of a volume that should be used to infer or discover the preference\nto be used through known annotations on the underlying resource. Once applied to the PreferenceMatcher\nthis field is removed.\n\n+optional",
		"inferFromVolumeFailurePolicy": "InferFromVolumeFailurePolicy controls what should happen on failure when preference the instancetype.\nAllowed values are: \"RejectInferFromVolumeFailure\" and \"IgnoreInferFromVolumeFailure\".\nIf not specified, \"RejectInferFromVolumeFailure\" is used by default.\n\n+optional",
	}
}

func (LiveUpdateAffinity) SwaggerDoc() map[string]string {
	return map[string]string{}
}

func (LiveUpdateCPU) SwaggerDoc() map[string]string {
	return map[string]string{
		"maxSockets": "The maximum amount of sockets that can be hot-plugged to the Virtual Machine",
	}
}

func (LiveUpdateConfiguration) SwaggerDoc() map[string]string {
	return map[string]string{
		"maxHotplugRatio": "MaxHotplugRatio is the ratio used to define the max amount\nof a hotplug resource that can be made available to a VM\nwhen the specific Max* setting is not defined (MaxCpuSockets, MaxGuest)\nExample: VM is configured with 512Mi of guest memory, if MaxGuest is not\ndefined and MaxHotplugRatio is 2 then MaxGuest = 1Gi\ndefaults to 4",
		"maxCpuSockets":   "MaxCpuSockets holds the maximum amount of sockets that can be hotplugged",
		"maxGuest":        "MaxGuest defines the maximum amount memory that can be allocated\nto the guest using hotplug.",
	}
}

func (LiveUpdateMemory) SwaggerDoc() map[string]string {
	return map[string]string{
		"maxGuest": "MaxGuest defines the maximum amount memory that can be allocated for the VM.\n+optional",
	}
}

func (SEVPlatformInfo) SwaggerDoc() map[string]string {
	return map[string]string{
		"":          "SEVPlatformInfo contains information about the AMD SEV features for the node.\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object",
		"pdh":       "Base64 encoded platform Diffie-Hellman key.",
		"certChain": "Base64 encoded SEV certificate chain.",
	}
}

func (SEVMeasurementInfo) SwaggerDoc() map[string]string {
	return map[string]string{
		"":            "SEVMeasurementInfo contains information about the guest launch measurement.\n\n+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object",
		"measurement": "Base64 encoded launch measurement of the SEV guest.",
		"apiMajor":    "API major version of the SEV host.",
		"apiMinor":    "API minor version of the SEV host.",
		"buildID":     "Build ID of the SEV host.",
		"policy":      "Policy of the SEV guest.",
		"loaderSHA":   "SHA256 of the loader binary",
	}
}

func (SEVSessionOptions) SwaggerDoc() map[string]string {
	return map[string]string{
		"":        "SEVSessionOptions is used to provide SEV session parameters.",
		"session": "Base64 encoded session blob.",
		"dhCert":  "Base64 encoded guest owner's Diffie-Hellman key.",
	}
}

func (SEVSecretOptions) SwaggerDoc() map[string]string {
	return map[string]string{
		"":       "SEVSecretOptions is used to provide a secret for a running guest.",
		"header": "Base64 encoded header needed to decrypt the secret.",
		"secret": "Base64 encoded encrypted launch secret.",
	}
}
