/**********************************************************************
 * Example veriusertfs table that is used by many Verilog simulators
 * to register PLI applications that use the TF and ACC libraries of
 * the IEEE 1364 PLI.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *********************************************************************/

/* prototypes of the PLI application routines */
extern int PLIbook_MyStrobe_checktf(),
           PLIbook_MyStrobe_calltf(),
           PLIbook_MyStrobe_misctf();
extern int PLIbook_ReadStimulusShort_calltf(),
           PLIbook_ReadStimulusShort_misctf();
extern int PLIbook_MyMonitor1_calltf(),
           PLIbook_MyMonitor1_misctf();
extern int PLIbook_MyMonitor2_calltf(),
           PLIbook_MyMonitor2_misctf();
extern int PLIbook_ReadStimulus_checktf(),
           PLIbook_ReadStimulus_calltf(),
           PLIbook_ReadStimulus_misctf();

/* the veriusertfs table */
s_tfcell veriusertfs[] =
{
    {usertask,                          /* type of PLI routine */
      0,                                /* user_data value */
      PLIbook_MyStrobe_checktf,         /* checktf routine */
      0,                                /* sizetf routine */
      PLIbook_MyStrobe_calltf,          /* calltf routine */
      PLIbook_MyStrobe_misctf,          /* misctf routine */
      "$my_strobe",                     /* system task/function name */
      1                                 /* forward reference = true */
    },                                  /* */

    {usertask,                          /* type of PLI routine */
      0,                                /* user_data value */
      0,                                /* checktf routine */
      0,                                /* sizetf routine */
      PLIbook_ReadStimulusShort_calltf, /* calltf routine */
      PLIbook_ReadStimulusShort_misctf, /* misctf routine */
      "$read_stimulus_short",           /* system task/function name */
      1                                 /* forward reference = true */
    },                                  /* */

    {usertask,                          /* type of PLI routine */
      0,                                /* user_data value */
      0,                                /* checktf routine */
      0,                                /* sizetf routine */
      PLIbook_MyMonitor1_calltf,        /* calltf routine */
      PLIbook_MyMonitor1_misctf,        /* misctf routine */
      "$my_monitor1",                   /* system task/function name */
      1                                 /* forward reference = true */
    },                                  /* */

    {usertask,                          /* type of PLI routine */
      0,                                /* user_data value */
      0,                                /* checktf routine */
      0,                                /* sizetf routine */
      PLIbook_MyMonitor2_calltf,        /* calltf routine */
      PLIbook_MyMonitor2_misctf,        /* misctf routine */
      "$my_monitor2",                   /* system task/function name */
      1                                 /* forward reference = true */
    },                                  /* */

    {usertask,                          /* type of PLI routine */
      0,                                /* user_data value */
      PLIbook_ReadStimulus_checktf,     /* checktf routine */
      0,                                /* sizetf routine */
      PLIbook_ReadStimulus_calltf,      /* calltf routine */
      PLIbook_ReadStimulus_misctf,      /* misctf routine */
      "$read_stimulus",                 /* system task/function name */
      1                                 /* forward reference = true */
    },                                  /* */
    {usertask,                          /* type of PLI routine */
      0,                                /* user_data value */
      PLIbook_ReadStimulus_checktf,     /* checktf routine */
      0,                                /* sizetf routine */
      PLIbook_ReadStimulus_calltf,      /* calltf routine */
      PLIbook_ReadStimulus_misctf,      /* misctf routine */
      "$read_stimulus_ba",              /* system task/function name */
      1                                 /* forward reference = true */
    },                                  /* */
    {usertask,                          /* type of PLI routine */
      1,                                /* user_data value */
      PLIbook_ReadStimulus_checktf,     /* checktf routine */
      0,                                /* sizetf routine */
      PLIbook_ReadStimulus_calltf,      /* calltf routine */
      PLIbook_ReadStimulus_misctf,      /* misctf routine */
      "$read_stimulus_br",              /* system task/function name */
      1                                 /* forward reference = true */
    },                                  /* */
    {usertask,                          /* type of PLI routine */
      2,                                /* user_data value */
      PLIbook_ReadStimulus_checktf,     /* checktf routine */
      0,                                /* sizetf routine */
      PLIbook_ReadStimulus_calltf,      /* calltf routine */
      PLIbook_ReadStimulus_misctf,      /* misctf routine */
      "$read_stimulus_ha",              /* system task/function name */
      1                                 /* forward reference = true */
    },                                  /* */
    {usertask,                          /* type of PLI routine */
      3,                                /* user_data value */
      PLIbook_ReadStimulus_checktf,     /* checktf routine */
      0,                                /* sizetf routine */
      PLIbook_ReadStimulus_calltf,      /* calltf routine */
      PLIbook_ReadStimulus_misctf,      /* misctf routine */
      "$read_stimulus_hr",              /* system task/function name */
      1                                 /* forward reference = true */
    },                                  /* */

    {0} /*** final entry must be 0 ***/
};

