# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class ConnectedCluster(TrackedResource):
    """Represents a connected cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param identity: Required. The identity of the connected cluster.
    :type identity: ~connected_kubernetes_client.models.ConnectedClusterIdentity
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~connected_kubernetes_client.models.SystemData
    :param agent_public_key_certificate: Required. Base64 encoded public certificate used by the
     agent to do the initial handshake to the backend services in Azure.
    :type agent_public_key_certificate: str
    :ivar kubernetes_version: The Kubernetes version of the connected cluster resource.
    :vartype kubernetes_version: str
    :ivar total_node_count: Number of nodes present in the connected cluster resource.
    :vartype total_node_count: int
    :ivar total_core_count: Number of CPU cores present in the connected cluster resource.
    :vartype total_core_count: int
    :ivar agent_version: Version of the agent running on the connected cluster resource.
    :vartype agent_version: str
    :param provisioning_state: Provisioning state of the connected cluster resource. Possible
     values include: "Succeeded", "Failed", "Canceled", "Provisioning", "Updating", "Deleting",
     "Accepted".
    :type provisioning_state: str or ~connected_kubernetes_client.models.ProvisioningState
    :param distribution: The Kubernetes distribution running on this connected cluster.
    :type distribution: str
    :param infrastructure: The infrastructure on which the Kubernetes cluster represented by this
     connected cluster is running on.
    :type infrastructure: str
    :ivar offering: Connected cluster offering.
    :vartype offering: str
    :ivar managed_identity_certificate_expiration_time: Expiration time of the managed identity
     certificate.
    :vartype managed_identity_certificate_expiration_time: ~datetime.datetime
    :ivar last_connectivity_time: Time representing the last instance when heart beat was received
     from the cluster.
    :vartype last_connectivity_time: ~datetime.datetime
    :ivar connectivity_status: Represents the connectivity status of the connected cluster.
     Possible values include: "Connecting", "Connected", "Offline", "Expired".
    :vartype connectivity_status: str or ~connected_kubernetes_client.models.ConnectivityStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'identity': {'required': True},
        'system_data': {'readonly': True},
        'agent_public_key_certificate': {'required': True},
        'kubernetes_version': {'readonly': True},
        'total_node_count': {'readonly': True},
        'total_core_count': {'readonly': True},
        'agent_version': {'readonly': True},
        'offering': {'readonly': True},
        'managed_identity_certificate_expiration_time': {'readonly': True},
        'last_connectivity_time': {'readonly': True},
        'connectivity_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ConnectedClusterIdentity'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'agent_public_key_certificate': {'key': 'properties.agentPublicKeyCertificate', 'type': 'str'},
        'kubernetes_version': {'key': 'properties.kubernetesVersion', 'type': 'str'},
        'total_node_count': {'key': 'properties.totalNodeCount', 'type': 'int'},
        'total_core_count': {'key': 'properties.totalCoreCount', 'type': 'int'},
        'agent_version': {'key': 'properties.agentVersion', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'distribution': {'key': 'properties.distribution', 'type': 'str'},
        'infrastructure': {'key': 'properties.infrastructure', 'type': 'str'},
        'offering': {'key': 'properties.offering', 'type': 'str'},
        'managed_identity_certificate_expiration_time': {'key': 'properties.managedIdentityCertificateExpirationTime', 'type': 'iso-8601'},
        'last_connectivity_time': {'key': 'properties.lastConnectivityTime', 'type': 'iso-8601'},
        'connectivity_status': {'key': 'properties.connectivityStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectedCluster, self).__init__(**kwargs)
        self.identity = kwargs['identity']
        self.system_data = None
        self.agent_public_key_certificate = kwargs['agent_public_key_certificate']
        self.kubernetes_version = None
        self.total_node_count = None
        self.total_core_count = None
        self.agent_version = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.distribution = kwargs.get('distribution', None)
        self.infrastructure = kwargs.get('infrastructure', None)
        self.offering = None
        self.managed_identity_certificate_expiration_time = None
        self.last_connectivity_time = None
        self.connectivity_status = None


class ConnectedClusterIdentity(msrest.serialization.Model):
    """Identity for the connected cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal id of connected cluster identity. This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the connected cluster. This property will only
     be provided for a system assigned identity.
    :vartype tenant_id: str
    :param type: Required. The type of identity used for the connected cluster. The type
     'SystemAssigned, includes a system created identity. The type 'None' means no identity is
     assigned to the connected cluster. Possible values include: "None", "SystemAssigned". Default
     value: "SystemAssigned".
    :type type: str or ~connected_kubernetes_client.models.ResourceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectedClusterIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', "SystemAssigned")


class ConnectedClusterList(msrest.serialization.Model):
    """The paginated list of connected Clusters.

    :param value: The list of connected clusters.
    :type value: list[~connected_kubernetes_client.models.ConnectedCluster]
    :param next_link: The link to fetch the next page of connected cluster.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ConnectedCluster]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectedClusterList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ConnectedClusterPatch(msrest.serialization.Model):
    """Object containing updates for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param properties: Describes the connected cluster resource properties that can be updated
     during PATCH operation.
    :type properties: any
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectedClusterPatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.properties = kwargs.get('properties', None)


class CredentialResult(msrest.serialization.Model):
    """The credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the credential.
    :vartype name: str
    :ivar value: Base64-encoded Kubernetes configuration file.
    :vartype value: bytearray
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'bytearray'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CredentialResult, self).__init__(**kwargs)
        self.name = None
        self.value = None


class CredentialResults(msrest.serialization.Model):
    """The list of credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hybrid_connection_config: Contains the REP (rendezvous endpoint) and “Sender” access
     token.
    :vartype hybrid_connection_config: ~connected_kubernetes_client.models.HybridConnectionConfig
    :ivar kubeconfigs: Base64-encoded Kubernetes configuration file.
    :vartype kubeconfigs: list[~connected_kubernetes_client.models.CredentialResult]
    """

    _validation = {
        'hybrid_connection_config': {'readonly': True},
        'kubeconfigs': {'readonly': True},
    }

    _attribute_map = {
        'hybrid_connection_config': {'key': 'hybridConnectionConfig', 'type': 'HybridConnectionConfig'},
        'kubeconfigs': {'key': 'kubeconfigs', 'type': '[CredentialResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CredentialResults, self).__init__(**kwargs)
        self.hybrid_connection_config = None
        self.kubeconfigs = None


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~connected_kubernetes_client.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~connected_kubernetes_client.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~connected_kubernetes_client.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class HybridConnectionConfig(msrest.serialization.Model):
    """Contains the REP (rendezvous endpoint) and “Sender” access token.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar expiration_time: Timestamp when this token will be expired.
    :vartype expiration_time: long
    :ivar hybrid_connection_name: Name of the connection.
    :vartype hybrid_connection_name: str
    :ivar relay: Name of the relay.
    :vartype relay: str
    :ivar token: Sender access token.
    :vartype token: str
    """

    _validation = {
        'expiration_time': {'readonly': True},
        'hybrid_connection_name': {'readonly': True},
        'relay': {'readonly': True},
        'token': {'readonly': True},
    }

    _attribute_map = {
        'expiration_time': {'key': 'expirationTime', 'type': 'long'},
        'hybrid_connection_name': {'key': 'hybridConnectionName', 'type': 'str'},
        'relay': {'key': 'relay', 'type': 'str'},
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HybridConnectionConfig, self).__init__(**kwargs)
        self.expiration_time = None
        self.hybrid_connection_name = None
        self.relay = None
        self.token = None


class ListClusterUserCredentialProperties(msrest.serialization.Model):
    """ListClusterUserCredentialProperties.

    All required parameters must be populated in order to send to Azure.

    :param authentication_method: Required. The mode of client authentication. Possible values
     include: "Token", "AAD".
    :type authentication_method: str or ~connected_kubernetes_client.models.AuthenticationMethod
    :param client_proxy: Required. Boolean value to indicate whether the request is for client side
     proxy or not.
    :type client_proxy: bool
    """

    _validation = {
        'authentication_method': {'required': True},
        'client_proxy': {'required': True},
    }

    _attribute_map = {
        'authentication_method': {'key': 'authenticationMethod', 'type': 'str'},
        'client_proxy': {'key': 'clientProxy', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListClusterUserCredentialProperties, self).__init__(**kwargs)
        self.authentication_method = kwargs['authentication_method']
        self.client_proxy = kwargs['client_proxy']


class Operation(msrest.serialization.Model):
    """The Connected cluster API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {Microsoft.Kubernetes}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~connected_kubernetes_client.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    :param provider: Service provider: Microsoft.connectedClusters.
    :type provider: str
    :param resource: Connected Cluster Resource on which the operation is performed.
    :type resource: str
    :param operation: Operation type: Read, write, delete, etc.
    :type operation: str
    :param description: Description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationList(msrest.serialization.Model):
    """The paginated list of connected cluster API operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of connected cluster API operations.
    :vartype value: list[~connected_kubernetes_client.models.Operation]
    :param next_link: The link to fetch the next page of connected cluster API operations.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationList, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~connected_kubernetes_client.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~connected_kubernetes_client.models.LastModifiedByType
    :param last_modified_at: The timestamp of resource modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)
