/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.log4j.FileAppender;
import org.apache.log4j.rolling.RollingPolicy;
import org.apache.log4j.rolling.RolloverDescription;
import org.apache.log4j.rolling.TriggeringPolicy;
import org.apache.log4j.rolling.helper.Action;
import org.apache.log4j.spi.LoggingEvent;

public final class RollingFileAppender
extends FileAppender {
    private TriggeringPolicy triggeringPolicy;
    private RollingPolicy rollingPolicy;
    private long fileLength = 0L;
    private Action lastRolloverAsyncAction = null;

    public void activateOptions() {
        if (this.rollingPolicy == null) {
            this.getLogger().warn((Object)"Please set a rolling policy for the RollingFileAppender named '{}'", this.getName());
            return;
        }
        if (this.triggeringPolicy == null && this.rollingPolicy instanceof TriggeringPolicy) {
            this.triggeringPolicy = (TriggeringPolicy)((Object)this.rollingPolicy);
        }
        if (this.triggeringPolicy == null) {
            this.getLogger().warn((Object)"Please set a TriggeringPolicy for the RollingFileAppender named '{}'", this.getName());
            return;
        }
        Exception exception = null;
        RollingFileAppender rollingFileAppender = this;
        synchronized (rollingFileAppender) {
            this.triggeringPolicy.activateOptions();
            this.rollingPolicy.activateOptions();
            try {
                RolloverDescription rollover = this.rollingPolicy.initialize(this.getFile(), this.getAppend());
                if (rollover != null) {
                    Action syncAction = rollover.getSynchronous();
                    if (syncAction != null) {
                        syncAction.execute();
                    }
                    this.setFile(rollover.getActiveFileName());
                    this.setAppend(rollover.getAppend());
                    this.lastRolloverAsyncAction = rollover.getAsynchronous();
                    if (this.lastRolloverAsyncAction != null) {
                        Thread runner = new Thread(this.lastRolloverAsyncAction);
                        runner.start();
                    }
                }
                File activeFile = new File(this.getFile());
                this.fileLength = this.getAppend() ? activeFile.length() : 0L;
                super.activateOptions();
            }
            catch (Exception ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            this.getLogger().warn((Object)("Exception while initializing RollingFileAppender named '" + this.getName() + "'"), exception);
        }
    }

    public boolean rollover() {
        if (this.rollingPolicy != null) {
            Exception exception = null;
            RollingFileAppender rollingFileAppender = this;
            synchronized (rollingFileAppender) {
                block23: {
                    if (this.lastRolloverAsyncAction != null) {
                        this.lastRolloverAsyncAction.close();
                    }
                    try {
                        RolloverDescription rollover = this.rollingPolicy.rollover(this.getFile());
                        if (rollover == null) break block23;
                        if (rollover.getActiveFileName().equals(this.getFile())) {
                            this.closeWriter();
                            boolean success = true;
                            if (rollover.getSynchronous() != null) {
                                success = false;
                                try {
                                    success = rollover.getSynchronous().execute();
                                }
                                catch (Exception ex) {
                                    exception = ex;
                                }
                            }
                            if (success) {
                                this.fileLength = rollover.getAppend() ? new File(rollover.getActiveFileName()).length() : 0L;
                                if (rollover.getAsynchronous() != null) {
                                    this.lastRolloverAsyncAction = rollover.getAsynchronous();
                                    new Thread(this.lastRolloverAsyncAction).start();
                                }
                                this.setFile(rollover.getActiveFileName(), rollover.getAppend(), this.bufferedIO, this.bufferSize);
                            } else {
                                this.setFile(rollover.getActiveFileName(), true, this.bufferedIO, this.bufferSize);
                                if (exception == null) {
                                    this.getLogger().warn("Failure in post-close rollover action");
                                } else {
                                    this.getLogger().warn((Object)"Exception in post-close rollover action", exception);
                                }
                            }
                        } else {
                            OutputStreamWriter newWriter = this.createWriter(new FileOutputStream(rollover.getActiveFileName(), rollover.getAppend()));
                            this.closeWriter();
                            this.setFile(rollover.getActiveFileName());
                            this.qw = this.createQuietWriter(newWriter);
                            boolean success = true;
                            if (rollover.getSynchronous() != null) {
                                success = false;
                                try {
                                    success = rollover.getSynchronous().execute();
                                }
                                catch (Exception ex) {
                                    exception = ex;
                                }
                            }
                            if (success) {
                                this.fileLength = rollover.getAppend() ? new File(rollover.getActiveFileName()).length() : 0L;
                                if (rollover.getAsynchronous() != null) {
                                    this.lastRolloverAsyncAction = rollover.getAsynchronous();
                                    new Thread(this.lastRolloverAsyncAction).start();
                                }
                            }
                            this.writeHeader();
                        }
                        boolean bl = true;
                        return bl;
                    }
                    catch (Exception ex) {
                        exception = ex;
                    }
                }
            }
            if (exception != null) {
                this.getLogger().warn((Object)"Exception during rollover, rollover deferred.", exception);
            }
        }
        return false;
    }

    protected void subAppend(LoggingEvent event) {
        if (this.triggeringPolicy.isTriggeringEvent(this, event, this.getFile(), this.getFileLength())) {
            try {
                this.rollover();
            }
            catch (Exception ex) {
                this.getLogger().info((Object)"Exception during rollover attempt.", ex);
            }
        }
        super.subAppend(event);
    }

    public RollingPolicy getRollingPolicy() {
        return this.rollingPolicy;
    }

    public TriggeringPolicy getTriggeringPolicy() {
        return this.triggeringPolicy;
    }

    public void setRollingPolicy(RollingPolicy policy) {
        this.rollingPolicy = policy;
    }

    public void setTriggeringPolicy(TriggeringPolicy policy) {
        this.triggeringPolicy = policy;
    }

    public void close() {
        RollingFileAppender rollingFileAppender = this;
        synchronized (rollingFileAppender) {
            if (this.lastRolloverAsyncAction != null) {
                this.lastRolloverAsyncAction.close();
            }
        }
        super.close();
    }

    protected OutputStreamWriter createWriter(OutputStream os) {
        return super.createWriter(new CountingOutputStream(os, this));
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public void incrementFileLength(int increment) {
        this.fileLength += (long)increment;
    }

    private static class CountingOutputStream
    extends OutputStream {
        private final OutputStream os;
        private final RollingFileAppender rfa;

        public CountingOutputStream(OutputStream os, RollingFileAppender rfa) {
            this.os = os;
            this.rfa = rfa;
        }

        public void close() throws IOException {
            this.os.close();
        }

        public void flush() throws IOException {
            this.os.flush();
        }

        public void write(byte[] b) throws IOException {
            this.os.write(b);
            this.rfa.incrementFileLength(b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
            this.rfa.incrementFileLength(len);
        }

        public void write(int b) throws IOException {
            this.os.write(b);
            this.rfa.incrementFileLength(1);
        }
    }
}

