package insights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ApplicationType enumerates the values for application type.
type ApplicationType string

const (
	// Other ...
	Other ApplicationType = "other"
	// Web ...
	Web ApplicationType = "web"
)

// PossibleApplicationTypeValues returns an array of possible values for the ApplicationType const type.
func PossibleApplicationTypeValues() []ApplicationType {
	return []ApplicationType{Other, Web}
}

// CategoryType enumerates the values for category type.
type CategoryType string

const (
	// CategoryTypePerformance ...
	CategoryTypePerformance CategoryType = "performance"
	// CategoryTypeRetention ...
	CategoryTypeRetention CategoryType = "retention"
	// CategoryTypeTSG ...
	CategoryTypeTSG CategoryType = "TSG"
	// CategoryTypeWorkbook ...
	CategoryTypeWorkbook CategoryType = "workbook"
)

// PossibleCategoryTypeValues returns an array of possible values for the CategoryType const type.
func PossibleCategoryTypeValues() []CategoryType {
	return []CategoryType{CategoryTypePerformance, CategoryTypeRetention, CategoryTypeTSG, CategoryTypeWorkbook}
}

// FavoriteSourceType enumerates the values for favorite source type.
type FavoriteSourceType string

const (
	// Events ...
	Events FavoriteSourceType = "events"
	// Funnel ...
	Funnel FavoriteSourceType = "funnel"
	// Impact ...
	Impact FavoriteSourceType = "impact"
	// Notebook ...
	Notebook FavoriteSourceType = "notebook"
	// Retention ...
	Retention FavoriteSourceType = "retention"
	// Segmentation ...
	Segmentation FavoriteSourceType = "segmentation"
	// Sessions ...
	Sessions FavoriteSourceType = "sessions"
	// Userflows ...
	Userflows FavoriteSourceType = "userflows"
)

// PossibleFavoriteSourceTypeValues returns an array of possible values for the FavoriteSourceType const type.
func PossibleFavoriteSourceTypeValues() []FavoriteSourceType {
	return []FavoriteSourceType{Events, Funnel, Impact, Notebook, Retention, Segmentation, Sessions, Userflows}
}

// FavoriteType enumerates the values for favorite type.
type FavoriteType string

const (
	// Shared ...
	Shared FavoriteType = "shared"
	// User ...
	User FavoriteType = "user"
)

// PossibleFavoriteTypeValues returns an array of possible values for the FavoriteType const type.
func PossibleFavoriteTypeValues() []FavoriteType {
	return []FavoriteType{Shared, User}
}

// FlowType enumerates the values for flow type.
type FlowType string

const (
	// Bluefield ...
	Bluefield FlowType = "Bluefield"
)

// PossibleFlowTypeValues returns an array of possible values for the FlowType const type.
func PossibleFlowTypeValues() []FlowType {
	return []FlowType{Bluefield}
}

// IngestionMode enumerates the values for ingestion mode.
type IngestionMode string

const (
	// ApplicationInsights ...
	ApplicationInsights IngestionMode = "ApplicationInsights"
	// ApplicationInsightsWithDiagnosticSettings ...
	ApplicationInsightsWithDiagnosticSettings IngestionMode = "ApplicationInsightsWithDiagnosticSettings"
	// LogAnalytics ...
	LogAnalytics IngestionMode = "LogAnalytics"
)

// PossibleIngestionModeValues returns an array of possible values for the IngestionMode const type.
func PossibleIngestionModeValues() []IngestionMode {
	return []IngestionMode{ApplicationInsights, ApplicationInsightsWithDiagnosticSettings, LogAnalytics}
}

// ItemScope enumerates the values for item scope.
type ItemScope string

const (
	// ItemScopeShared ...
	ItemScopeShared ItemScope = "shared"
	// ItemScopeUser ...
	ItemScopeUser ItemScope = "user"
)

// PossibleItemScopeValues returns an array of possible values for the ItemScope const type.
func PossibleItemScopeValues() []ItemScope {
	return []ItemScope{ItemScopeShared, ItemScopeUser}
}

// ItemScopePath enumerates the values for item scope path.
type ItemScopePath string

const (
	// AnalyticsItems ...
	AnalyticsItems ItemScopePath = "analyticsItems"
	// MyanalyticsItems ...
	MyanalyticsItems ItemScopePath = "myanalyticsItems"
)

// PossibleItemScopePathValues returns an array of possible values for the ItemScopePath const type.
func PossibleItemScopePathValues() []ItemScopePath {
	return []ItemScopePath{AnalyticsItems, MyanalyticsItems}
}

// ItemType enumerates the values for item type.
type ItemType string

const (
	// Folder ...
	Folder ItemType = "folder"
	// Function ...
	Function ItemType = "function"
	// Query ...
	Query ItemType = "query"
	// Recent ...
	Recent ItemType = "recent"
)

// PossibleItemTypeValues returns an array of possible values for the ItemType const type.
func PossibleItemTypeValues() []ItemType {
	return []ItemType{Folder, Function, Query, Recent}
}

// ItemTypeParameter enumerates the values for item type parameter.
type ItemTypeParameter string

const (
	// ItemTypeParameterFolder ...
	ItemTypeParameterFolder ItemTypeParameter = "folder"
	// ItemTypeParameterFunction ...
	ItemTypeParameterFunction ItemTypeParameter = "function"
	// ItemTypeParameterNone ...
	ItemTypeParameterNone ItemTypeParameter = "none"
	// ItemTypeParameterQuery ...
	ItemTypeParameterQuery ItemTypeParameter = "query"
	// ItemTypeParameterRecent ...
	ItemTypeParameterRecent ItemTypeParameter = "recent"
)

// PossibleItemTypeParameterValues returns an array of possible values for the ItemTypeParameter const type.
func PossibleItemTypeParameterValues() []ItemTypeParameter {
	return []ItemTypeParameter{ItemTypeParameterFolder, ItemTypeParameterFunction, ItemTypeParameterNone, ItemTypeParameterQuery, ItemTypeParameterRecent}
}

// PurgeState enumerates the values for purge state.
type PurgeState string

const (
	// Completed ...
	Completed PurgeState = "completed"
	// Pending ...
	Pending PurgeState = "pending"
)

// PossiblePurgeStateValues returns an array of possible values for the PurgeState const type.
func PossiblePurgeStateValues() []PurgeState {
	return []PurgeState{Completed, Pending}
}

// RequestSource enumerates the values for request source.
type RequestSource string

const (
	// Rest ...
	Rest RequestSource = "rest"
)

// PossibleRequestSourceValues returns an array of possible values for the RequestSource const type.
func PossibleRequestSourceValues() []RequestSource {
	return []RequestSource{Rest}
}

// SharedTypeKind enumerates the values for shared type kind.
type SharedTypeKind string

const (
	// SharedTypeKindShared ...
	SharedTypeKindShared SharedTypeKind = "shared"
	// SharedTypeKindUser ...
	SharedTypeKindUser SharedTypeKind = "user"
)

// PossibleSharedTypeKindValues returns an array of possible values for the SharedTypeKind const type.
func PossibleSharedTypeKindValues() []SharedTypeKind {
	return []SharedTypeKind{SharedTypeKindShared, SharedTypeKindUser}
}

// WebTestKind enumerates the values for web test kind.
type WebTestKind string

const (
	// Multistep ...
	Multistep WebTestKind = "multistep"
	// Ping ...
	Ping WebTestKind = "ping"
)

// PossibleWebTestKindValues returns an array of possible values for the WebTestKind const type.
func PossibleWebTestKindValues() []WebTestKind {
	return []WebTestKind{Multistep, Ping}
}
