# CloudWatchLogs Event Source Example

Example SAM template for processing CloudWatch Logs.

## Running the example

```bash
# Replace YOUR_S3_ARTIFACTS_BUCKET
aws cloudformation package --template-file template.yaml --output-template-file cfn-transformed-template.yaml --s3-bucket YOUR_S3_ARTIFACTS_BUCKET
aws cloudformation deploy --template-file ./cfn-transformed-template.yaml --stack-name example-logs-processor --capabilities CAPABILITY_IAM
```

After your CloudFormation Stack has completed creation, log an event to your CloudWatch Log Group + Stream. To see it in action, modify and run the command below:

```bash
# Replace YOUR_LOG_GROUP_NAME with the name generated by CloudFormation (e.g. example-logs-processor-CloudWatchLambdaLogsGroup-XXXXXX)
UNIX_TIME=$(date +%s) LOG_TIME=$((UNIX_TIME*1000)) && aws logs put-log-events --log-group-name "YOUR_LOG_GROUP_NAME" --log-stream-name "sam-log-stream" --log-events "[{\"message\": \"This won't be processed since it doesn't match the FilterPattern.\", \"timestamp\": $LOG_TIME}, {\"message\": \"This will be processed since it says Hello log processor.\", \"timestamp\": $LOG_TIME}]"
# NOTE: Subsequent logs will require adding `--sequence-token SEQUENCE_TOKEN` to the command
```