/*
 * brass - Braille and speech server
 *
 * Copyright (C) 2001-2003 by Roger Butenuth, All rights reserved.
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
 *
 * $Id: german.h,v 1.4 2003/05/29 16:58:23 butenuth Exp $
 */
#ifndef _GERMAN_H
#define _GERMAN_H

/*
 * Table for translation of ASCII to strings.
 * (German)
 */
static char *german_table[] = {
    NULL,			/* 0x00 */
    " ",			/* 0x01 */
    NULL,			/* 0x02 */
    NULL,			/* 0x03 */
    NULL,			/* 0x04 */
    NULL,			/* 0x05 */
    NULL,			/* 0x06 */
    NULL,			/* 0x07 */
    NULL,			/* 0x08 */
    NULL,			/* 0x09 */
    NULL,			/* 0x0a */
    NULL,			/* 0x0b */
    NULL,			/* 0x0c */
    NULL,			/* 0x0d */
    NULL,			/* 0x0e */
    NULL,			/* 0x0f */
    NULL,			/* 0x10 */
    NULL,			/* 0x11 */
    NULL,			/* 0x12 */
    NULL,			/* 0x13 */
    NULL,			/* 0x14 */
    NULL,			/* 0x15 */
    NULL,			/* 0x16 */
    NULL,			/* 0x17 */
    NULL,			/* 0x18 */
    NULL,			/* 0x19 */
    NULL,			/* 0x1a */
    NULL,			/* 0x1b */
    NULL,			/* 0x1c */
    NULL,			/* 0x1d */
    NULL,			/* 0x1e */
    NULL,			/* 0x1f */
    " leer ",			/* 0x20, ' ' */
    " Ausrufezeichen ",		/* 0x21, '!' */
    " Anfhrungszeichen ",	/* 0x22, '"' */
    " Lattenkreuz ",		/* 0x23, '#' */
    " Dollar ",			/* 0x24, '$' */
    " Prozent ",		/* 0x25, '%' */
    " Kaufmannsund ",		/* 0x26, '&' */
    " Apostroph ",		/* 0x27, ''' */
    " Klammer auf ",		/* 0x28, '(' */
    " Klammer zu ",		/* 0x29, ')' */
    " Stern  ",			/* 0x2a, '*' */
    " Plus ",			/* 0x2b, '+' */
    " Komma ",			/* 0x2c, ',' */
    " Minus ",			/* 0x2d, '-' */
    " Punkt ",			/* 0x2e, '.' */
    " Schrgstrich ",		/* 0x2f, '/' */
    " null ",			/* 0x30, '0' */
    " eins ",			/* 0x31, '1' */
    " zwei ",			/* 0x32, '2' */
    " drei ",			/* 0x33, '3' */
    " vier ",			/* 0x34, '4' */
    " fnf ",			/* 0x35, '5' */
    " sechs ",			/* 0x36, '6' */
    " sieben ",			/* 0x37, '7' */
    " acht ",			/* 0x38, '8' */
    " neun ",			/* 0x39, '9' */
    " Doppelpunkt ",		/* 0x3a, ':' */
    " Semikolon ",		/* 0x3b, ';' */
    " kleiner ",		/* 0x3c, '<' */
    " gleich ",			/* 0x3d, '=' */
    " grer ",			/* 0x3e, '>' */
    " Fragezeichen ",		/* 0x3f, '?' */
    " tt ",			/* 0x40, '@' */
    "A",			/* 0x41, 'A' */
    "B",			/* 0x42, 'B' */
    "C",			/* 0x43, 'C' */
    "D",			/* 0x44, 'D' */
    "E",			/* 0x45, 'E' */
    "F",			/* 0x46, 'F' */
    "G",			/* 0x47, 'G' */
    "H",			/* 0x48, 'H' */
    "I",			/* 0x49, 'I' */
    "J",			/* 0x4a, 'J' */
    "K",			/* 0x4b, 'K' */
    "L",			/* 0x4c, 'L' */
    "M",			/* 0x4d, 'M' */
    "N",			/* 0x4e, 'N' */
    "O",			/* 0x4f, 'O' */
    "P",			/* 0x50, 'P' */
    "Q",			/* 0x51, 'Q' */
    "R",			/* 0x52, 'R' */
    "S",			/* 0x53, 'S' */
    "T",			/* 0x54, 'T' */
    "U",			/* 0x55, 'U' */
    "V",			/* 0x56, 'V' */
    "W",			/* 0x57, 'W' */
    "X",			/* 0x58, 'X' */
    "Y",			/* 0x59, 'Y' */
    "Z",			/* 0x5a, 'Z' */
    " eckige Klammer auf ",	/* 0x5b, '[' */
    " Bckslsch ",		/* 0x5c, '\' */
    " eckige Klammer zu ",	/* 0x5d, ']' */
    " Pfeil hoch ",		/* 0x5e, '^' */
    " Unterstrich ",		/* 0x5f, '_' */
    " Apostroph ",		/* 0x60, '`' */
    "a",			/* 0x61, 'a' */
    "b",			/* 0x62, 'b' */
    "c",			/* 0x63, 'c' */
    "d",			/* 0x64, 'd' */
    "e",			/* 0x65, 'e' */
    "f",			/* 0x66, 'f' */
    "g",			/* 0x67, 'g' */
    "h",			/* 0x68, 'h' */
    "i",			/* 0x69, 'i' */
    "j",			/* 0x6a, 'j' */
    "k",			/* 0x6b, 'k' */
    "l",			/* 0x6c, 'l' */
    "m",			/* 0x6d, 'm' */
    "n",			/* 0x6e, 'n' */
    "o",			/* 0x6f, 'o' */
    "p",			/* 0x70, 'p' */
    "q",			/* 0x71, 'q' */
    "r",			/* 0x72, 'r' */
    "s",			/* 0x73, 's' */
    "t",			/* 0x74, 't' */
    "u",			/* 0x75, 'u' */
    "v",			/* 0x76, 'v' */
    "w",			/* 0x77, 'w' */
    "x",			/* 0x78, 'x' */
    "y",			/* 0x79, 'y' */
    "z",			/* 0x7a, 'z' */
    " geschweifte Klammer auf ", /* 0x7b, '{' */
    " senkrechter Strich ",	/* 0x7c, '|' */
    " geschweifte Klammer zu ",	/* 0x7d, '}' */
    " Tilde ",			/* 0x7e, '~' */
    NULL,			/* 0x7f */
    NULL,			/* 0x80 */
    NULL,			/* 0x81 */
    NULL,			/* 0x82 */
    "Ecke ",			/* 0x83 bottem left */
    NULL,			/* 0x84 */
    "Strich ",			/* 0x85 vertical line */
    " Ecke ",			/* 0x86 top left */
    NULL,			/* 0x87 */
    NULL,			/* 0x88 */
    " Ecke ",			/* 0x89 bottom right */
    " Linie ",			/* 0x8a horizontal line */
    NULL,			/* 0x8b */
    " Ecke ",			/* 0x8c top right */
    NULL,			/* 0x8d */
    NULL,			/* 0x8e */
    NULL,			/* 0x8f */
    NULL,			/* 0x90 */
    NULL,			/* 0x91 */
    NULL,			/* 0x92 */
    NULL,			/* 0x93 */
    NULL,			/* 0x94 */
    NULL,			/* 0x95 */
    NULL,			/* 0x96 */
    NULL,			/* 0x97 */
    NULL,			/* 0x98 */
    NULL,			/* 0x99 */
    NULL,			/* 0x9a */
    NULL,			/* 0x9b */
    NULL,			/* 0x9c */
    NULL,			/* 0x9d */
    NULL,			/* 0x9e */
    NULL,			/* 0x9f */
    "",			/* 0xa0, '' */
    "",			/* 0xa1, '' */
    "",			/* 0xa2, '' */
    " Pfund ",			/* 0xa3, '' */
    " Euro ",			/* 0xa4, '' */
    " Yen ",			/* 0xa5, '' */
    "",			/* 0xa6, '' */
    " Paragraph ",		/* 0xa7, '' */
    "",			/* 0xa8, '' */
    " Copyright ",		/* 0xa9, '' */
    "",			/* 0xaa, '' */
    " klein gegen ",		/* 0xab, '' */
    "",			/* 0xac, '' */
    "",			/* 0xad, '' */
    " Warenzeichen ",		/* 0xae, '' */
    "",			/* 0xaf, '' */
    " Grad ",			/* 0xb0, '' */
    " Plusminus ",		/* 0xb1, '' */
    " quadrat ",		/* 0xb2, '' */
    " hoch drei ",		/* 0xb3, '' */
    "",			/* 0xb4, '' */
    " M ",			/* 0xb5, '' */
    " Absatzmarkierung ",	/* 0xb6, '' */
    "",			/* 0xb7, '' */
    "",			/* 0xb8, '' */
    "",			/* 0xb9, '' */
    "",			/* 0xba, '' */
    " gro gegen ",		/* 0xbb, '' */
    "",                        /* 0xbc, '' */
    "",                        /* 0xbd, '' */
    "",                        /* 0xbe, '' */
    "",			/* 0xbf, '' */
    "",			/* 0xc0, '' */
    "",			/* 0xc1, '' */
    "",			/* 0xc2, '' */
    "",			/* 0xc3, '' */
    "",			/* 0xc4, '' */
    "",			/* 0xc5, '' */
    "",			/* 0xc6, '' */
    "",			/* 0xc7, '' */
    "",			/* 0xc8, '' */
    "",			/* 0xc9, '' */
    "",			/* 0xca, '' */
    "",			/* 0xcb, '' */
    "",			/* 0xcc, '' */
    "",			/* 0xcd, '' */
    "",			/* 0xce, '' */
    "",			/* 0xcf, '' */
    "",			/* 0xd0, '' */
    "",			/* 0xd1, '' */
    "",			/* 0xd2, '' */
    "",			/* 0xd3, '' */
    "",			/* 0xd4, '' */
    "",			/* 0xd5, '' */
    "",			/* 0xd6, '' */
    "",			/* 0xd7, '' */
    "",			/* 0xd8, '' */
    "",			/* 0xd9, '' */
    "",			/* 0xda, '' */
    "",			/* 0xdb, '' */
    "",			/* 0xdc, '' */
    "",			/* 0xdd, '' */
    "",			/* 0xde, '' */
    "",			/* 0xdf, '' */
    "",			/* 0xe0, '' */
    "",			/* 0xe1, '' */
    "",			/* 0xe2, '' */
    "",			/* 0xe3, '' */
    "",			/* 0xe4, '' */
    "",			/* 0xe5, '' */
    "",			/* 0xe6, '' */
    "",			/* 0xe7, '' */
    "",			/* 0xe8, '' */
    "",			/* 0xe9, '' */
    "",			/* 0xea, '' */
    "",			/* 0xeb, '' */
    "",			/* 0xec, '' */
    "",			/* 0xed, '' */
    "",			/* 0xee, '' */
    "",			/* 0xef, '' */
    "",			/* 0xf0, '' */
    "",			/* 0xf1, '' */
    "",			/* 0xf2, '' */
    "",			/* 0xf3, '' */
    "",			/* 0xf4, '' */
    "",			/* 0xf5, '' */
    "",			/* 0xf6, '' */
    "",			/* 0xf7, '' */
    "",			/* 0xf8, '' */
    "",			/* 0xf9, '' */
    "",			/* 0xfa, '' */
    "",			/* 0xfb, '' */
    "",			/* 0xfc, '' */
    "",			/* 0xfd, '' */
    "",			/* 0xfe, '' */
    "",			/* 0xff, '' */
};

#endif /* _GERMAN_H */
