/* detectups.c   Automatically determine the settings for a UPS
 *
 * Copyright (C) 2001        James Brents
 *
 * This program is a minimal tool to test the serial port.
 * It can be useful to understand how your UPS is connected.
 * It will give the needed configuration info for setting up the
 * powerd configuration file.
 * It can also generate a standard powerd.conf file based on your 
 * configuration. 
 * Yes, I know, this code is ugly and messy, but it works. Though it needs 
 * to work better in future versions.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <errno.h>
#include <string.h>
#include <sys/time.h>
#include <termios.h>

#include "config.h"
#include "powerd.h"

#define WRITE write(fd,buf,strlen(buf))

void buildconfig(char *device, char *cbit, char *horl);

int main(int argc, char **argv)
{
int fd, letsexit=1;
uint bits, orig, mask=~0, outb=(TIOCM_RTS|TIOCM_DTR);
char *changedbit = "CAR";
char *highorlow = "HIGH";
int powerhasfailed = 0;
int rts_bit = TIOCM_RTS;
int dtr_bit = TIOCM_DTR;
//char inbuf;
//fd_set fd_in;
//struct timeval tv;
//struct termios foo;

  if (argc<2 || !strcmp(argv[1],"--help") || !strcmp(argv[1],"-h"))
    {
    printf("%s: Usage: \"%s <device>\"\n", argv[0], argv[0]);
    printf("    <device>        is a serial device, like /dev/ttyS0\n");
    exit(1);
    }

    if ((fd=open(argv[1], O_RDWR | O_NDELAY)) < 0)
    {fprintf(stderr, "%s: %s: %s\n",argv[0],argv[1],strerror(errno));exit(1);}
    fflush(stdin);

//    tcgetattr(0, &foo);
    /* turn off canonical mode; 
     * disables buffering and processing of special characters */
//    foo.c_lflag &= ~(ICANON);	
//    tcsetattr(0, TCSANOW, &foo);

    ioctl(fd, TIOCMBIC, &rts_bit);
    ioctl(fd, TIOCMBIC, &dtr_bit);

    usleep(1);
    ioctl(fd,TIOCMGET,&bits); bits&=mask; bits|=outb; ioctl(fd,TIOCMSET,&bits);
    ioctl(fd,TIOCMGET,&orig); orig&=mask; orig|=outb; ioctl(fd,TIOCMSET,&orig);
    usleep(1);
    ioctl(fd,TIOCMGET,&orig);
    ioctl(fd,TIOCMGET,&bits);

//    tv.tv_sec = 0;
//    tv.tv_usec = 1000;
    
    printf("Okay, With the system not plugged into the UPS (in case the UPS doesnt work,\nyou dont want to lose power to the machine..) pull the power cord from the\nwall. I shall attempt to find out what you need to change. Heres what you need\nto look out for:\n");
    printf("Make sure that when I say \"POWER IS OUT\" that it happens at the same time you\npull the power cord, if I say it after, then we have problems. And if I dont\nsay it at the same time, or ever at all, then we also have problems, and I would\nlike for you to email me for help and so I can add your UPS to my program\n");
    printf("\nOkay, having read all that, I am ready when you are. Ill announce when the\npower is out, and when it is back. Make sure this happens when you actually\nremove and restore power.\n\nYou may pull when ready.\n");
//    printf("\nIf I dont say that the power has gone off when you pull the power, please plug\nthe UPS back in, and press R to have it check differantly. After having\npressed R you may then re-unplug the UPS and it should then detect it.\n");
    do {
/*	FD_ZERO(&fd_in);
	FD_SET(fileno(stdin), &fd_in);
	select(2, &fd_in, NULL, NULL, &tv);

	if FD_ISSET(fileno(stdin), &fd_in) {
	    printf("BLAH!\n");
	    if (tolower(getchar()) == 'r') {
		ioctl(fd, TIOCMBIS, &rts_bit);
		ioctl(fd, TIOCMBIS, &dtr_bit);
		printf("Setting DTR/RTS bits.\n");
	    }
	}*/
	ioctl(fd,TIOCMGET,&bits);
	if (bits != orig && !powerhasfailed) {
	    printf("THE POWER IS OUT!\nWait a second, and plug it back in.\n");
	    if ((bits ^ orig) & TIOCM_CAR) { 
		changedbit = "CAR";
		highorlow = (bits & TIOCM_CAR) ? "HIGH" : "LOW";
	    } else if ((bits ^ orig) & TIOCM_CTS) {
		changedbit = "CTS";
		highorlow = (bits & TIOCM_CTS) ? "HIGH" : "LOW";
	    } else if ((bits ^ orig) & TIOCM_DSR) {
		changedbit = "DSR";
		highorlow = (bits & TIOCM_DSR) ? "HIGH" : "LOW";
	    } else if ((bits ^ orig) & TIOCM_RNG) {
		changedbit = "RNG";
		highorlow = (bits & TIOCM_RNG) ? "HIGH" : "LOW";
	    } else {
		printf("Ive detected a change in the line, But I dont know which ones.\nYou have an odd UPS, please email me with this line:\n");
		printf("ODD-UPS BITS: %u %u\n", orig, bits);
		exit(-1);
	    }
	    powerhasfailed = 1;

	} else if (bits == orig && powerhasfailed) {
	    printf("THE POWER IS BACK!\n");
	    printf("Okay, it worked hopefully, heres what i detected has changed, and here is what\nyou should put in your /etc/powerd.conf file for the POWERFAIL line:\n");
	    printf("\nPOWERFAIL %s %s\n\n", changedbit, highorlow);
	    printf("Email me and tell me how this worked for you, as it is still in development\nDaSyonic@users.sourceforge.net\n");
	    printf("Would you like me to now build an /etc/powerd.conf file based on your\nUPS configuration? [Y/N]");
	    if (tolower(getc(stdin)) == 'y')
		buildconfig(argv[1], changedbit, highorlow);
	    else
		printf("\nAlright, But I at least suggest you use one of the examples for guidance.\n");
	    letsexit = 0;
	}	
    usleep(1000);
    }
    while(letsexit);
  close(fd);
  exit(0);
}
    
void buildconfig(char *device, char *cbit, char *horl) {
    struct stat crap;
    char buf[1024];
    int fd;

    printf("\n");
    if (!stat("/etc/powerd.conf", &crap)) {
	printf("Moving current /etc/powerd.conf file to /etc/powerd.conf.bak\n");
	rename("/etc/powerd.conf", "/etc/powerd.conf.bak");
    }

    fd = open("/etc/powerd.conf", O_WRONLY | O_CREAT | O_EXCL, 0600);
    sprintf(buf, "# Powerd configuration file generated by detectups %s\n", VERSION);
    WRITE;
    sprintf(buf, "# Lines marked with # are a comment.\n#\n");
    WRITE;
    sprintf(buf, "# This makes powerd monitor a UPS, and be able to notify other machines on\n# the network\n#\n");
    WRITE;
    sprintf(buf, "MODE MONITOR\n");
    WRITE;
    sprintf(buf, "# This specifies which device to monitor\n");
    WRITE;
    sprintf(buf, "MONITOR %s\n", device);
    WRITE;
    sprintf(buf, "# What line configuration tells us when the power is out? Lines that you\n# can use: CAR CTS RNG DSR    and you may speicify either LOW or HIGH\n# You get this line by running the included detectups program.\n");
    WRITE;
    sprintf(buf, "POWERFAIL %s %s\n", cbit, horl);
    WRITE;
    sprintf(buf, "#\n#\n#\n# This specifies how long before the power actually goes out, and init\n# gets notified and starts the delayed shutdown. Default 16 seconds.\n# NOTE: This is not how much time will elapse until the system actually\n# shuts down, as that is configured in /etc/inittab.\n");
    WRITE;
    sprintf(buf, "DELAY 16\n#\n#\n");
    WRITE;
    sprintf(buf, "# And here are the machines to notify, we can specify the host as:\n#    hostname password\n");
    WRITE;
    sprintf(buf, "# or hostname:port password\n#\n# Here are some examples:\n#\n");
    WRITE;
    sprintf(buf, "# this one shall use the default port\n#NOTIFY Mymachine.mydomain.com MySecretPassword\n");
    WRITE;
    sprintf(buf, "# this one shall use port 732\n#NOTIFY othermachine.onmynetwork.com:732 Anotherpassword\n");
    WRITE;
    sprintf(buf, "#\n#\n# This specifies which user to drop to from root\n# This is simply for added security and not needed for powerd to operate\n# Currently commented out, Feel free to use it if you wish. \n#USER uucp\n");
    WRITE;
    printf("Done making configuration file. Please review it and tailor it further.\n");
    printf("However, powerd should be all set to run. If it doesnt work, Please email me\nwith your configuration: DaSyonic@users.sourceforge.net\n");
	close(fd);

}
