// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`ListKeyPolicies`](crate::operation::list_key_policies::builders::ListKeyPoliciesFluentBuilder) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::operation::list_key_policies::builders::ListKeyPoliciesFluentBuilder::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::operation::list_key_policies::builders::ListKeyPoliciesFluentBuilder::key_id) / [`set_key_id(Option<String>)`](crate::operation::list_key_policies::builders::ListKeyPoliciesFluentBuilder::set_key_id):<br>required: **true**<br><p>Gets the names of key policies for the specified KMS key.</p> <p>Specify the key ID or key ARN of the KMS key.</p> <p>For example:</p> <ul>  <li>   <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li> </ul> <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p><br>
    ///   - [`limit(i32)`](crate::operation::list_key_policies::builders::ListKeyPoliciesFluentBuilder::limit) / [`set_limit(Option<i32>)`](crate::operation::list_key_policies::builders::ListKeyPoliciesFluentBuilder::set_limit):<br>required: **false**<br><p>Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.</p> <p>This value is optional. If you include a value, it must be between 1 and 1000, inclusive. If you do not include a value, it defaults to 100.</p> <p>Only one policy can be attached to a key.</p><br>
    ///   - [`marker(impl Into<String>)`](crate::operation::list_key_policies::builders::ListKeyPoliciesFluentBuilder::marker) / [`set_marker(Option<String>)`](crate::operation::list_key_policies::builders::ListKeyPoliciesFluentBuilder::set_marker):<br>required: **false**<br><p>Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <code>NextMarker</code> from the truncated response you just received.</p><br>
    /// - On success, responds with [`ListKeyPoliciesOutput`](crate::operation::list_key_policies::ListKeyPoliciesOutput) with field(s):
    ///   - [`policy_names(Option<Vec::<String>>)`](crate::operation::list_key_policies::ListKeyPoliciesOutput::policy_names): <p>A list of key policy names. The only valid value is <code>default</code>.</p>
    ///   - [`next_marker(Option<String>)`](crate::operation::list_key_policies::ListKeyPoliciesOutput::next_marker): <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    ///   - [`truncated(bool)`](crate::operation::list_key_policies::ListKeyPoliciesOutput::truncated): <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    /// - On failure, responds with [`SdkError<ListKeyPoliciesError>`](crate::operation::list_key_policies::ListKeyPoliciesError)
    pub fn list_key_policies(&self) -> crate::operation::list_key_policies::builders::ListKeyPoliciesFluentBuilder {
        crate::operation::list_key_policies::builders::ListKeyPoliciesFluentBuilder::new(self.handle.clone())
    }
}
