// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetParametersForImport`](crate::operation::get_parameters_for_import::builders::GetParametersForImportFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::operation::get_parameters_for_import::builders::GetParametersForImportFluentBuilder::key_id) / [`set_key_id(Option<String>)`](crate::operation::get_parameters_for_import::builders::GetParametersForImportFluentBuilder::set_key_id):<br>required: **true**<br><p>The identifier of the KMS key that will be associated with the imported key material. The <code>Origin</code> of the KMS key must be <code>EXTERNAL</code>.</p> <p>All KMS key types are supported, including multi-Region keys. However, you cannot import key material into a KMS key in a custom key store.</p> <p>Specify the key ID or key ARN of the KMS key.</p> <p>For example:</p> <ul>  <li>   <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li> </ul> <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p><br>
    ///   - [`wrapping_algorithm(AlgorithmSpec)`](crate::operation::get_parameters_for_import::builders::GetParametersForImportFluentBuilder::wrapping_algorithm) / [`set_wrapping_algorithm(Option<AlgorithmSpec>)`](crate::operation::get_parameters_for_import::builders::GetParametersForImportFluentBuilder::set_wrapping_algorithm):<br>required: **true**<br><p>The algorithm you will use with the RSA public key (<code>PublicKey</code>) in the response to protect your key material during import. For more information, see <a href="kms/latest/developerguide/importing-keys-get-public-key-and-token.html#select-wrapping-algorithm">Select a wrapping algorithm</a> in the <i>Key Management Service Developer Guide</i>.</p> <p>For RSA_AES wrapping algorithms, you encrypt your key material with an AES key that you generate, then encrypt your AES key with the RSA public key from KMS. For RSAES wrapping algorithms, you encrypt your key material directly with the RSA public key from KMS.</p> <p>The wrapping algorithms that you can use depend on the type of key material that you are importing. To import an RSA private key, you must use an RSA_AES wrapping algorithm.</p> <ul>  <li>   <p><b>RSA_AES_KEY_WRAP_SHA_256</b> — Supported for wrapping RSA and ECC key material.</p></li>  <li>   <p><b>RSA_AES_KEY_WRAP_SHA_1</b> — Supported for wrapping RSA and ECC key material.</p></li>  <li>   <p><b>RSAES_OAEP_SHA_256</b> — Supported for all types of key material, except RSA key material (private key).</p>   <p>You cannot use the RSAES_OAEP_SHA_256 wrapping algorithm with the RSA_2048 wrapping key spec to wrap ECC_NIST_P521 key material.</p></li>  <li>   <p><b>RSAES_OAEP_SHA_1</b> — Supported for all types of key material, except RSA key material (private key).</p>   <p>You cannot use the RSAES_OAEP_SHA_1 wrapping algorithm with the RSA_2048 wrapping key spec to wrap ECC_NIST_P521 key material.</p></li>  <li>   <p><b>RSAES_PKCS1_V1_5</b> (Deprecated) — As of October 10, 2023, KMS does not support the RSAES_PKCS1_V1_5 wrapping algorithm.</p></li> </ul><br>
    ///   - [`wrapping_key_spec(WrappingKeySpec)`](crate::operation::get_parameters_for_import::builders::GetParametersForImportFluentBuilder::wrapping_key_spec) / [`set_wrapping_key_spec(Option<WrappingKeySpec>)`](crate::operation::get_parameters_for_import::builders::GetParametersForImportFluentBuilder::set_wrapping_key_spec):<br>required: **true**<br><p>The type of RSA public key to return in the response. You will use this wrapping key with the specified wrapping algorithm to protect your key material during import.</p> <p>Use the longest RSA wrapping key that is practical.</p> <p>You cannot use an RSA_2048 public key to directly wrap an ECC_NIST_P521 private key. Instead, use an RSA_AES wrapping algorithm or choose a longer RSA public key.</p><br>
    /// - On success, responds with [`GetParametersForImportOutput`](crate::operation::get_parameters_for_import::GetParametersForImportOutput) with field(s):
    ///   - [`key_id(Option<String>)`](crate::operation::get_parameters_for_import::GetParametersForImportOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key to use in a subsequent <code>ImportKeyMaterial</code> request. This is the same KMS key specified in the <code>GetParametersForImport</code> request.</p>
    ///   - [`import_token(Option<Blob>)`](crate::operation::get_parameters_for_import::GetParametersForImportOutput::import_token): <p>The import token to send in a subsequent <code>ImportKeyMaterial</code> request.</p>
    ///   - [`public_key(Option<Blob>)`](crate::operation::get_parameters_for_import::GetParametersForImportOutput::public_key): <p>The public key to use to encrypt the key material before importing it with <code>ImportKeyMaterial</code>.</p>
    ///   - [`parameters_valid_to(Option<DateTime>)`](crate::operation::get_parameters_for_import::GetParametersForImportOutput::parameters_valid_to): <p>The time at which the import token and public key are no longer valid. After this time, you cannot use them to make an <code>ImportKeyMaterial</code> request and you must send another <code>GetParametersForImport</code> request to get new ones.</p>
    /// - On failure, responds with [`SdkError<GetParametersForImportError>`](crate::operation::get_parameters_for_import::GetParametersForImportError)
    pub fn get_parameters_for_import(&self) -> crate::operation::get_parameters_for_import::builders::GetParametersForImportFluentBuilder {
        crate::operation::get_parameters_for_import::builders::GetParametersForImportFluentBuilder::new(self.handle.clone())
    }
}
