// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GenerateMac`](crate::operation::generate_mac::builders::GenerateMacFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`message(Blob)`](crate::operation::generate_mac::builders::GenerateMacFluentBuilder::message) / [`set_message(Option<Blob>)`](crate::operation::generate_mac::builders::GenerateMacFluentBuilder::set_message):<br>required: **true**<br><p>The message to be hashed. Specify a message of up to 4,096 bytes.</p> <p><code>GenerateMac</code> and <code>VerifyMac</code> do not provide special handling for message digests. If you generate an HMAC for a hash digest of a message, you must verify the HMAC of the same hash digest.</p><br>
    ///   - [`key_id(impl Into<String>)`](crate::operation::generate_mac::builders::GenerateMacFluentBuilder::key_id) / [`set_key_id(Option<String>)`](crate::operation::generate_mac::builders::GenerateMacFluentBuilder::set_key_id):<br>required: **true**<br><p>The HMAC KMS key to use in the operation. The MAC algorithm computes the HMAC for the message and the key as described in <a href="https://datatracker.ietf.org/doc/html/rfc2104">RFC 2104</a>.</p> <p>To identify an HMAC KMS key, use the <code>DescribeKey</code> operation and see the <code>KeySpec</code> field in the response.</p><br>
    ///   - [`mac_algorithm(MacAlgorithmSpec)`](crate::operation::generate_mac::builders::GenerateMacFluentBuilder::mac_algorithm) / [`set_mac_algorithm(Option<MacAlgorithmSpec>)`](crate::operation::generate_mac::builders::GenerateMacFluentBuilder::set_mac_algorithm):<br>required: **true**<br><p>The MAC algorithm used in the operation.</p> <p>The algorithm must be compatible with the HMAC KMS key that you specify. To find the MAC algorithms that your HMAC KMS key supports, use the <code>DescribeKey</code> operation and see the <code>MacAlgorithms</code> field in the <code>DescribeKey</code> response.</p><br>
    ///   - [`grant_tokens(impl Into<String>)`](crate::operation::generate_mac::builders::GenerateMacFluentBuilder::grant_tokens) / [`set_grant_tokens(Option<Vec::<String>>)`](crate::operation::generate_mac::builders::GenerateMacFluentBuilder::set_grant_tokens):<br>required: **false**<br><p>A list of grant tokens.</p> <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    ///   - [`dry_run(bool)`](crate::operation::generate_mac::builders::GenerateMacFluentBuilder::dry_run) / [`set_dry_run(Option<bool>)`](crate::operation::generate_mac::builders::GenerateMacFluentBuilder::set_dry_run):<br>required: **false**<br><p>Checks if your request will succeed. <code>DryRun</code> is an optional parameter.</p> <p>To learn more about how to use this parameter, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html">Testing your KMS API calls</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    /// - On success, responds with [`GenerateMacOutput`](crate::operation::generate_mac::GenerateMacOutput) with field(s):
    ///   - [`mac(Option<Blob>)`](crate::operation::generate_mac::GenerateMacOutput::mac): <p>The hash-based message authentication code (HMAC) that was generated for the specified message, HMAC KMS key, and MAC algorithm.</p> <p>This is the standard, raw HMAC defined in <a href="https://datatracker.ietf.org/doc/html/rfc2104">RFC 2104</a>.</p>
    ///   - [`mac_algorithm(Option<MacAlgorithmSpec>)`](crate::operation::generate_mac::GenerateMacOutput::mac_algorithm): <p>The MAC algorithm that was used to generate the HMAC.</p>
    ///   - [`key_id(Option<String>)`](crate::operation::generate_mac::GenerateMacOutput::key_id): <p>The HMAC KMS key used in the operation.</p>
    /// - On failure, responds with [`SdkError<GenerateMacError>`](crate::operation::generate_mac::GenerateMacError)
    pub fn generate_mac(&self) -> crate::operation::generate_mac::builders::GenerateMacFluentBuilder {
        crate::operation::generate_mac::builders::GenerateMacFluentBuilder::new(self.handle.clone())
    }
}
