// Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may not
// use this file except in compliance with the License. A copy of the
// License is located at
//
// http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
// either express or implied. See the License for the specific language governing
// permissions and limitations under the License.

package mocks

import (
	"github.com/aws/amazon-ssm-agent/common/identity"
	"github.com/stretchr/testify/mock"
)

// IAgentIdentitySelectorMock is an autogenerated mock type for the IAgentIdentitySelector type - to test
type IAgentIdentitySelectorMock struct {
	mock.Mock
}

// SelectAgentIdentity provides a mock function with given fields: _a0, _a1
func (_m *IAgentIdentitySelectorMock) SelectAgentIdentity(_a0 []identity.IAgentIdentityInner, _a1 string) identity.IAgentIdentityInner {
	ret := _m.Called(_a0, _a1)

	var r0 identity.IAgentIdentityInner
	if rf, ok := ret.Get(0).(func([]identity.IAgentIdentityInner, string) identity.IAgentIdentityInner); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(identity.IAgentIdentityInner)
		}
	}

	return r0
}
