/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/upload/v1beta1"
)

// UploadTokenRequestLister helps list UploadTokenRequests.
// All objects returned here must be treated as read-only.
type UploadTokenRequestLister interface {
	// List lists all UploadTokenRequests in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.UploadTokenRequest, err error)
	// UploadTokenRequests returns an object that can list and get UploadTokenRequests.
	UploadTokenRequests(namespace string) UploadTokenRequestNamespaceLister
	UploadTokenRequestListerExpansion
}

// uploadTokenRequestLister implements the UploadTokenRequestLister interface.
type uploadTokenRequestLister struct {
	indexer cache.Indexer
}

// NewUploadTokenRequestLister returns a new UploadTokenRequestLister.
func NewUploadTokenRequestLister(indexer cache.Indexer) UploadTokenRequestLister {
	return &uploadTokenRequestLister{indexer: indexer}
}

// List lists all UploadTokenRequests in the indexer.
func (s *uploadTokenRequestLister) List(selector labels.Selector) (ret []*v1beta1.UploadTokenRequest, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.UploadTokenRequest))
	})
	return ret, err
}

// UploadTokenRequests returns an object that can list and get UploadTokenRequests.
func (s *uploadTokenRequestLister) UploadTokenRequests(namespace string) UploadTokenRequestNamespaceLister {
	return uploadTokenRequestNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// UploadTokenRequestNamespaceLister helps list and get UploadTokenRequests.
// All objects returned here must be treated as read-only.
type UploadTokenRequestNamespaceLister interface {
	// List lists all UploadTokenRequests in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.UploadTokenRequest, err error)
	// Get retrieves the UploadTokenRequest from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1beta1.UploadTokenRequest, error)
	UploadTokenRequestNamespaceListerExpansion
}

// uploadTokenRequestNamespaceLister implements the UploadTokenRequestNamespaceLister
// interface.
type uploadTokenRequestNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all UploadTokenRequests in the indexer for a given namespace.
func (s uploadTokenRequestNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.UploadTokenRequest, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.UploadTokenRequest))
	})
	return ret, err
}

// Get retrieves the UploadTokenRequest from the indexer for a given namespace and name.
func (s uploadTokenRequestNamespaceLister) Get(name string) (*v1beta1.UploadTokenRequest, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("uploadtokenrequest"), name)
	}
	return obj.(*v1beta1.UploadTokenRequest), nil
}
