# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AbnormalTimePeriod(_serialization.Model):
    """Class representing Abnormal Time Period identified in diagnosis.

    :ivar start_time: Start time of the downtime.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the downtime.
    :vartype end_time: ~datetime.datetime
    :ivar events: List of Possible Cause of downtime.
    :vartype events: list[~azure.mgmt.web.v2018_02_01.models.DetectorAbnormalTimePeriod]
    :ivar solutions: List of proposed solutions.
    :vartype solutions: list[~azure.mgmt.web.v2018_02_01.models.Solution]
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "events": {"key": "events", "type": "[DetectorAbnormalTimePeriod]"},
        "solutions": {"key": "solutions", "type": "[Solution]"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        events: Optional[List["_models.DetectorAbnormalTimePeriod"]] = None,
        solutions: Optional[List["_models.Solution"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: Start time of the downtime.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the downtime.
        :paramtype end_time: ~datetime.datetime
        :keyword events: List of Possible Cause of downtime.
        :paramtype events: list[~azure.mgmt.web.v2018_02_01.models.DetectorAbnormalTimePeriod]
        :keyword solutions: List of proposed solutions.
        :paramtype solutions: list[~azure.mgmt.web.v2018_02_01.models.Solution]
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.events = events
        self.solutions = solutions


class Address(_serialization.Model):
    """Address information for domain registration.

    All required parameters must be populated in order to send to Azure.

    :ivar address1: First line of an Address. Required.
    :vartype address1: str
    :ivar address2: The second line of the Address. Optional.
    :vartype address2: str
    :ivar city: The city for the address. Required.
    :vartype city: str
    :ivar country: The country for the address. Required.
    :vartype country: str
    :ivar postal_code: The postal code for the address. Required.
    :vartype postal_code: str
    :ivar state: The state or province for the address. Required.
    :vartype state: str
    """

    _validation = {
        "address1": {"required": True},
        "city": {"required": True},
        "country": {"required": True},
        "postal_code": {"required": True},
        "state": {"required": True},
    }

    _attribute_map = {
        "address1": {"key": "address1", "type": "str"},
        "address2": {"key": "address2", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        address1: str,
        city: str,
        country: str,
        postal_code: str,
        state: str,
        address2: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword address1: First line of an Address. Required.
        :paramtype address1: str
        :keyword address2: The second line of the Address. Optional.
        :paramtype address2: str
        :keyword city: The city for the address. Required.
        :paramtype city: str
        :keyword country: The country for the address. Required.
        :paramtype country: str
        :keyword postal_code: The postal code for the address. Required.
        :paramtype postal_code: str
        :keyword state: The state or province for the address. Required.
        :paramtype state: str
        """
        super().__init__(**kwargs)
        self.address1 = address1
        self.address2 = address2
        self.city = city
        self.country = country
        self.postal_code = postal_code
        self.state = state


class AddressResponse(_serialization.Model):
    """Describes main public IP address and any extra virtual IPs.

    :ivar service_ip_address: Main public virtual IP.
    :vartype service_ip_address: str
    :ivar internal_ip_address: Virtual Network internal IP address of the App Service Environment
     if it is in internal load-balancing mode.
    :vartype internal_ip_address: str
    :ivar outbound_ip_addresses: IP addresses appearing on outbound connections.
    :vartype outbound_ip_addresses: list[str]
    :ivar vip_mappings: Additional virtual IPs.
    :vartype vip_mappings: list[~azure.mgmt.web.v2018_02_01.models.VirtualIPMapping]
    """

    _attribute_map = {
        "service_ip_address": {"key": "serviceIpAddress", "type": "str"},
        "internal_ip_address": {"key": "internalIpAddress", "type": "str"},
        "outbound_ip_addresses": {"key": "outboundIpAddresses", "type": "[str]"},
        "vip_mappings": {"key": "vipMappings", "type": "[VirtualIPMapping]"},
    }

    def __init__(
        self,
        *,
        service_ip_address: Optional[str] = None,
        internal_ip_address: Optional[str] = None,
        outbound_ip_addresses: Optional[List[str]] = None,
        vip_mappings: Optional[List["_models.VirtualIPMapping"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_ip_address: Main public virtual IP.
        :paramtype service_ip_address: str
        :keyword internal_ip_address: Virtual Network internal IP address of the App Service
         Environment if it is in internal load-balancing mode.
        :paramtype internal_ip_address: str
        :keyword outbound_ip_addresses: IP addresses appearing on outbound connections.
        :paramtype outbound_ip_addresses: list[str]
        :keyword vip_mappings: Additional virtual IPs.
        :paramtype vip_mappings: list[~azure.mgmt.web.v2018_02_01.models.VirtualIPMapping]
        """
        super().__init__(**kwargs)
        self.service_ip_address = service_ip_address
        self.internal_ip_address = internal_ip_address
        self.outbound_ip_addresses = outbound_ip_addresses
        self.vip_mappings = vip_mappings


class AnalysisData(_serialization.Model):
    """Class Representing Detector Evidence used for analysis.

    :ivar source: Name of the Detector.
    :vartype source: str
    :ivar detector_definition: Detector Definition.
    :vartype detector_definition: ~azure.mgmt.web.v2018_02_01.models.DetectorDefinition
    :ivar metrics: Source Metrics.
    :vartype metrics: list[~azure.mgmt.web.v2018_02_01.models.DiagnosticMetricSet]
    :ivar data: Additional Source Data.
    :vartype data: list[list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]]
    :ivar detector_meta_data: Detector Meta Data.
    :vartype detector_meta_data: ~azure.mgmt.web.v2018_02_01.models.ResponseMetaData
    """

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "detector_definition": {"key": "detectorDefinition", "type": "DetectorDefinition"},
        "metrics": {"key": "metrics", "type": "[DiagnosticMetricSet]"},
        "data": {"key": "data", "type": "[[NameValuePair]]"},
        "detector_meta_data": {"key": "detectorMetaData", "type": "ResponseMetaData"},
    }

    def __init__(
        self,
        *,
        source: Optional[str] = None,
        detector_definition: Optional["_models.DetectorDefinition"] = None,
        metrics: Optional[List["_models.DiagnosticMetricSet"]] = None,
        data: Optional[List[List["_models.NameValuePair"]]] = None,
        detector_meta_data: Optional["_models.ResponseMetaData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: Name of the Detector.
        :paramtype source: str
        :keyword detector_definition: Detector Definition.
        :paramtype detector_definition: ~azure.mgmt.web.v2018_02_01.models.DetectorDefinition
        :keyword metrics: Source Metrics.
        :paramtype metrics: list[~azure.mgmt.web.v2018_02_01.models.DiagnosticMetricSet]
        :keyword data: Additional Source Data.
        :paramtype data: list[list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]]
        :keyword detector_meta_data: Detector Meta Data.
        :paramtype detector_meta_data: ~azure.mgmt.web.v2018_02_01.models.ResponseMetaData
        """
        super().__init__(**kwargs)
        self.source = source
        self.detector_definition = detector_definition
        self.metrics = metrics
        self.data = data
        self.detector_meta_data = detector_meta_data


class ProxyOnlyResource(_serialization.Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.type = None


class AnalysisDefinition(ProxyOnlyResource):
    """Definition of Analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Description of the Analysis.
    :vartype description: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.description = None


class ApiDefinitionInfo(_serialization.Model):
    """Information about the formal API definition for the app.

    :ivar url: The URL of the API definition.
    :vartype url: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword url: The URL of the API definition.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.url = url


class ApplicationLogsConfig(_serialization.Model):
    """Application logs configuration.

    :ivar file_system: Application logs to file system configuration.
    :vartype file_system: ~azure.mgmt.web.v2018_02_01.models.FileSystemApplicationLogsConfig
    :ivar azure_table_storage: Application logs to azure table storage configuration.
    :vartype azure_table_storage:
     ~azure.mgmt.web.v2018_02_01.models.AzureTableStorageApplicationLogsConfig
    :ivar azure_blob_storage: Application logs to blob storage configuration.
    :vartype azure_blob_storage:
     ~azure.mgmt.web.v2018_02_01.models.AzureBlobStorageApplicationLogsConfig
    """

    _attribute_map = {
        "file_system": {"key": "fileSystem", "type": "FileSystemApplicationLogsConfig"},
        "azure_table_storage": {"key": "azureTableStorage", "type": "AzureTableStorageApplicationLogsConfig"},
        "azure_blob_storage": {"key": "azureBlobStorage", "type": "AzureBlobStorageApplicationLogsConfig"},
    }

    def __init__(
        self,
        *,
        file_system: Optional["_models.FileSystemApplicationLogsConfig"] = None,
        azure_table_storage: Optional["_models.AzureTableStorageApplicationLogsConfig"] = None,
        azure_blob_storage: Optional["_models.AzureBlobStorageApplicationLogsConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword file_system: Application logs to file system configuration.
        :paramtype file_system: ~azure.mgmt.web.v2018_02_01.models.FileSystemApplicationLogsConfig
        :keyword azure_table_storage: Application logs to azure table storage configuration.
        :paramtype azure_table_storage:
         ~azure.mgmt.web.v2018_02_01.models.AzureTableStorageApplicationLogsConfig
        :keyword azure_blob_storage: Application logs to blob storage configuration.
        :paramtype azure_blob_storage:
         ~azure.mgmt.web.v2018_02_01.models.AzureBlobStorageApplicationLogsConfig
        """
        super().__init__(**kwargs)
        self.file_system = file_system
        self.azure_table_storage = azure_table_storage
        self.azure_blob_storage = azure_blob_storage


class ApplicationStack(_serialization.Model):
    """Application stack.

    :ivar name: Application stack name.
    :vartype name: str
    :ivar display: Application stack display name.
    :vartype display: str
    :ivar dependency: Application stack dependency.
    :vartype dependency: str
    :ivar major_versions: List of major versions available.
    :vartype major_versions: list[~azure.mgmt.web.v2018_02_01.models.StackMajorVersion]
    :ivar frameworks: List of frameworks associated with application stack.
    :vartype frameworks: list[~azure.mgmt.web.v2018_02_01.models.ApplicationStack]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "str"},
        "dependency": {"key": "dependency", "type": "str"},
        "major_versions": {"key": "majorVersions", "type": "[StackMajorVersion]"},
        "frameworks": {"key": "frameworks", "type": "[ApplicationStack]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional[str] = None,
        dependency: Optional[str] = None,
        major_versions: Optional[List["_models.StackMajorVersion"]] = None,
        frameworks: Optional[List["_models.ApplicationStack"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Application stack name.
        :paramtype name: str
        :keyword display: Application stack display name.
        :paramtype display: str
        :keyword dependency: Application stack dependency.
        :paramtype dependency: str
        :keyword major_versions: List of major versions available.
        :paramtype major_versions: list[~azure.mgmt.web.v2018_02_01.models.StackMajorVersion]
        :keyword frameworks: List of frameworks associated with application stack.
        :paramtype frameworks: list[~azure.mgmt.web.v2018_02_01.models.ApplicationStack]
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.dependency = dependency
        self.major_versions = major_versions
        self.frameworks = frameworks


class ApplicationStackCollection(_serialization.Model):
    """Collection of Application Stacks.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.ApplicationStack]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationStack]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ApplicationStack"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.ApplicationStack]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AppServiceCertificate(_serialization.Model):
    """Key Vault container for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_vault_id: Key Vault resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2018_02_01.models.KeyVaultSecretStatus
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "key_vault_id": {"key": "keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "keyVaultSecretName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self, *, key_vault_id: Optional[str] = None, key_vault_secret_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_id: Key Vault resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        """
        super().__init__(**kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceCertificateCollection(_serialization.Model):
    """Collection of certificate order certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.AppServiceCertificateResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServiceCertificateResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AppServiceCertificateResource"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.AppServiceCertificateResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Resource(_serialization.Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self, *, location: str, kind: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.location = location
        self.type = None
        self.tags = tags


class AppServiceCertificateOrder(Resource):  # pylint: disable=too-many-instance-attributes
    """SSL certificate purchase order.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar certificates: State of the Key Vault secret.
    :vartype certificates: dict[str, ~azure.mgmt.web.v2018_02_01.models.AppServiceCertificate]
    :ivar distinguished_name: Certificate distinguished name.
    :vartype distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :ivar validity_in_years: Duration in years (must be between 1 and 3).
    :vartype validity_in_years: int
    :ivar key_size: Certificate key size.
    :vartype key_size: int
    :ivar product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
     and "StandardDomainValidatedWildCardSsl".
    :vartype product_type: str or ~azure.mgmt.web.v2018_02_01.models.CertificateProductType
    :ivar auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Known values are: "Succeeded", "Failed",
     "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2018_02_01.models.ProvisioningState
    :ivar status: Current order status. Known values are: "Pendingissuance", "Issued", "Revoked",
     "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired", and
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.web.v2018_02_01.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.web.v2018_02_01.models.CertificateDetails
    :ivar csr: Last CSR that was created for this order.
    :vartype csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.web.v2018_02_01.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2018_02_01.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2018_02_01.models.ResourceNotRenewableReason]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "domain_verification_token": {"readonly": True},
        "validity_in_years": {"maximum": 3, "minimum": 1},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "signed_certificate": {"readonly": True},
        "intermediate": {"readonly": True},
        "root": {"readonly": True},
        "serial_number": {"readonly": True},
        "last_certificate_issuance_time": {"readonly": True},
        "expiration_time": {"readonly": True},
        "is_private_key_external": {"readonly": True},
        "app_service_certificate_not_renewable_reasons": {"readonly": True},
        "next_auto_renewal_time_stamp": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "certificates": {"key": "properties.certificates", "type": "{AppServiceCertificate}"},
        "distinguished_name": {"key": "properties.distinguishedName", "type": "str"},
        "domain_verification_token": {"key": "properties.domainVerificationToken", "type": "str"},
        "validity_in_years": {"key": "properties.validityInYears", "type": "int"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "product_type": {"key": "properties.productType", "type": "str"},
        "auto_renew": {"key": "properties.autoRenew", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "signed_certificate": {"key": "properties.signedCertificate", "type": "CertificateDetails"},
        "csr": {"key": "properties.csr", "type": "str"},
        "intermediate": {"key": "properties.intermediate", "type": "CertificateDetails"},
        "root": {"key": "properties.root", "type": "CertificateDetails"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "last_certificate_issuance_time": {"key": "properties.lastCertificateIssuanceTime", "type": "iso-8601"},
        "expiration_time": {"key": "properties.expirationTime", "type": "iso-8601"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
        "app_service_certificate_not_renewable_reasons": {
            "key": "properties.appServiceCertificateNotRenewableReasons",
            "type": "[str]",
        },
        "next_auto_renewal_time_stamp": {"key": "properties.nextAutoRenewalTimeStamp", "type": "iso-8601"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        certificates: Optional[Dict[str, "_models.AppServiceCertificate"]] = None,
        distinguished_name: Optional[str] = None,
        validity_in_years: int = 1,
        key_size: int = 2048,
        product_type: Optional[Union[str, "_models.CertificateProductType"]] = None,
        auto_renew: bool = True,
        csr: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword certificates: State of the Key Vault secret.
        :paramtype certificates: dict[str, ~azure.mgmt.web.v2018_02_01.models.AppServiceCertificate]
        :keyword distinguished_name: Certificate distinguished name.
        :paramtype distinguished_name: str
        :keyword validity_in_years: Duration in years (must be between 1 and 3).
        :paramtype validity_in_years: int
        :keyword key_size: Certificate key size.
        :paramtype key_size: int
        :keyword product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
         and "StandardDomainValidatedWildCardSsl".
        :paramtype product_type: str or ~azure.mgmt.web.v2018_02_01.models.CertificateProductType
        :keyword auto_renew: :code:`<code>true</code>` if the certificate should be automatically
         renewed when it expires; otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword csr: Last CSR that was created for this order.
        :paramtype csr: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = csr
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None


class AppServiceCertificateOrderCollection(_serialization.Model):
    """Collection of certificate orders.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.AppServiceCertificateOrder]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServiceCertificateOrder]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AppServiceCertificateOrder"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.AppServiceCertificateOrder]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AppServiceCertificateOrderPatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a certificate order that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar certificates: State of the Key Vault secret.
    :vartype certificates: dict[str, ~azure.mgmt.web.v2018_02_01.models.AppServiceCertificate]
    :ivar distinguished_name: Certificate distinguished name.
    :vartype distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :ivar validity_in_years: Duration in years (must be between 1 and 3).
    :vartype validity_in_years: int
    :ivar key_size: Certificate key size.
    :vartype key_size: int
    :ivar product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
     and "StandardDomainValidatedWildCardSsl".
    :vartype product_type: str or ~azure.mgmt.web.v2018_02_01.models.CertificateProductType
    :ivar auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Known values are: "Succeeded", "Failed",
     "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2018_02_01.models.ProvisioningState
    :ivar status: Current order status. Known values are: "Pendingissuance", "Issued", "Revoked",
     "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired", and
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.web.v2018_02_01.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.web.v2018_02_01.models.CertificateDetails
    :ivar csr: Last CSR that was created for this order.
    :vartype csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.web.v2018_02_01.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2018_02_01.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2018_02_01.models.ResourceNotRenewableReason]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "domain_verification_token": {"readonly": True},
        "validity_in_years": {"maximum": 3, "minimum": 1},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "signed_certificate": {"readonly": True},
        "intermediate": {"readonly": True},
        "root": {"readonly": True},
        "serial_number": {"readonly": True},
        "last_certificate_issuance_time": {"readonly": True},
        "expiration_time": {"readonly": True},
        "is_private_key_external": {"readonly": True},
        "app_service_certificate_not_renewable_reasons": {"readonly": True},
        "next_auto_renewal_time_stamp": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "certificates": {"key": "properties.certificates", "type": "{AppServiceCertificate}"},
        "distinguished_name": {"key": "properties.distinguishedName", "type": "str"},
        "domain_verification_token": {"key": "properties.domainVerificationToken", "type": "str"},
        "validity_in_years": {"key": "properties.validityInYears", "type": "int"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "product_type": {"key": "properties.productType", "type": "str"},
        "auto_renew": {"key": "properties.autoRenew", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "signed_certificate": {"key": "properties.signedCertificate", "type": "CertificateDetails"},
        "csr": {"key": "properties.csr", "type": "str"},
        "intermediate": {"key": "properties.intermediate", "type": "CertificateDetails"},
        "root": {"key": "properties.root", "type": "CertificateDetails"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "last_certificate_issuance_time": {"key": "properties.lastCertificateIssuanceTime", "type": "iso-8601"},
        "expiration_time": {"key": "properties.expirationTime", "type": "iso-8601"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
        "app_service_certificate_not_renewable_reasons": {
            "key": "properties.appServiceCertificateNotRenewableReasons",
            "type": "[str]",
        },
        "next_auto_renewal_time_stamp": {"key": "properties.nextAutoRenewalTimeStamp", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        certificates: Optional[Dict[str, "_models.AppServiceCertificate"]] = None,
        distinguished_name: Optional[str] = None,
        validity_in_years: int = 1,
        key_size: int = 2048,
        product_type: Optional[Union[str, "_models.CertificateProductType"]] = None,
        auto_renew: bool = True,
        csr: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword certificates: State of the Key Vault secret.
        :paramtype certificates: dict[str, ~azure.mgmt.web.v2018_02_01.models.AppServiceCertificate]
        :keyword distinguished_name: Certificate distinguished name.
        :paramtype distinguished_name: str
        :keyword validity_in_years: Duration in years (must be between 1 and 3).
        :paramtype validity_in_years: int
        :keyword key_size: Certificate key size.
        :paramtype key_size: int
        :keyword product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
         and "StandardDomainValidatedWildCardSsl".
        :paramtype product_type: str or ~azure.mgmt.web.v2018_02_01.models.CertificateProductType
        :keyword auto_renew: :code:`<code>true</code>` if the certificate should be automatically
         renewed when it expires; otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword csr: Last CSR that was created for this order.
        :paramtype csr: str
        """
        super().__init__(kind=kind, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = csr
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None


class AppServiceCertificatePatchResource(ProxyOnlyResource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key_vault_id: Key Vault resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2018_02_01.models.KeyVaultSecretStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key_vault_id: Key Vault resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        """
        super().__init__(kind=kind, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceCertificateResource(Resource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar key_vault_id: Key Vault resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2018_02_01.models.KeyVaultSecretStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword key_vault_id: Key Vault resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceEnvironment(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Description of an App Service Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the App Service Environment. Required.
    :vartype name: str
    :ivar location: Location of the App Service Environment, e.g. "West US". Required.
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the App Service Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2018_02_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Known values are: "Preparing",
     "Ready", "Scaling", and "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2018_02_01.models.HostingEnvironmentStatus
    :ivar vnet_name: Name of the Virtual Network for the App Service Environment.
    :vartype vnet_name: str
    :ivar vnet_resource_group_name: Resource group of the Virtual Network.
    :vartype vnet_resource_group_name: str
    :ivar vnet_subnet_name: Subnet of the Virtual Network.
    :vartype vnet_subnet_name: str
    :ivar virtual_network: Description of the Virtual Network. Required.
    :vartype virtual_network: ~azure.mgmt.web.v2018_02_01.models.VirtualNetworkProfile
    :ivar internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Known values are: "None", "Web", and
     "Publishing".
    :vartype internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2018_02_01.models.InternalLoadBalancingMode
    :ivar multi_size: Front-end VM size, e.g. "Medium", "Large".
    :vartype multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :ivar worker_pools: Description of worker pools with worker size IDs, VM sizes, and number of
     workers in each pool. Required.
    :vartype worker_pools: list[~azure.mgmt.web.v2018_02_01.models.WorkerPool]
    :ivar ipssl_address_count: Number of IP SSL addresses reserved for the App Service Environment.
    :vartype ipssl_address_count: int
    :ivar database_edition: Edition of the metadata database for the App Service Environment, e.g.
     "Standard".
    :vartype database_edition: str
    :ivar database_service_objective: Service objective of the metadata database for the App
     Service Environment, e.g. "S0".
    :vartype database_service_objective: str
    :ivar upgrade_domains: Number of upgrade domains of the App Service Environment.
    :vartype upgrade_domains: int
    :ivar subscription_id: Subscription of the App Service Environment.
    :vartype subscription_id: str
    :ivar dns_suffix: DNS suffix of the App Service Environment.
    :vartype dns_suffix: str
    :ivar last_action: Last deployment action on the App Service Environment.
    :vartype last_action: str
    :ivar last_action_result: Result of the last deployment action on the App Service Environment.
    :vartype last_action_result: str
    :ivar allowed_multi_sizes: List of comma separated strings describing which VM sizes are
     allowed for front-ends.
    :vartype allowed_multi_sizes: str
    :ivar allowed_worker_sizes: List of comma separated strings describing which VM sizes are
     allowed for workers.
    :vartype allowed_worker_sizes: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar vip_mappings: Description of IP SSL mapping for the App Service Environment.
    :vartype vip_mappings: list[~azure.mgmt.web.v2018_02_01.models.VirtualIPMapping]
    :ivar environment_capacities: Current total, used, and available worker capacities.
    :vartype environment_capacities: list[~azure.mgmt.web.v2018_02_01.models.StampCapacity]
    :ivar network_access_control_list: Access control list for controlling traffic to the App
     Service Environment.
    :vartype network_access_control_list:
     list[~azure.mgmt.web.v2018_02_01.models.NetworkAccessControlEntry]
    :ivar environment_is_healthy: True/false indicating whether the App Service Environment is
     healthy.
    :vartype environment_is_healthy: bool
    :ivar environment_status: Detailed message about with results of the last check of the App
     Service Environment.
    :vartype environment_status: str
    :ivar resource_group: Resource group of the App Service Environment.
    :vartype resource_group: str
    :ivar front_end_scale_factor: Scale factor for front-ends.
    :vartype front_end_scale_factor: int
    :ivar default_front_end_scale_factor: Default Scale Factor for FrontEnds.
    :vartype default_front_end_scale_factor: int
    :ivar api_management_account_id: API Management Account associated with the App Service
     Environment.
    :vartype api_management_account_id: str
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :ivar dynamic_cache_enabled: True/false indicating whether the App Service Environment is
     suspended. The environment can be suspended e.g. when the management endpoint is no longer
     available
     (most likely because NSG blocked the incoming traffic).
    :vartype dynamic_cache_enabled: bool
    :ivar cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :vartype cluster_settings: list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]
    :ivar user_whitelisted_ip_ranges: User added list of IP Ranges allowed on ASE db.
    :vartype user_whitelisted_ip_ranges: list[str]
    :ivar has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :vartype has_linux_workers: bool
    :ivar ssl_cert_key_vault_id: Key Vault ID for ILB App Service Environment default SSL
     certificate.
    :vartype ssl_cert_key_vault_id: str
    :ivar ssl_cert_key_vault_secret_name: Key Vault Secret Name for ILB App Service Environment
     default SSL certificate.
    :vartype ssl_cert_key_vault_secret_name: str
    """

    _validation = {
        "name": {"required": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "virtual_network": {"required": True},
        "worker_pools": {"required": True},
        "database_edition": {"readonly": True},
        "database_service_objective": {"readonly": True},
        "upgrade_domains": {"readonly": True},
        "subscription_id": {"readonly": True},
        "last_action": {"readonly": True},
        "last_action_result": {"readonly": True},
        "allowed_multi_sizes": {"readonly": True},
        "allowed_worker_sizes": {"readonly": True},
        "maximum_number_of_machines": {"readonly": True},
        "vip_mappings": {"readonly": True},
        "environment_capacities": {"readonly": True},
        "environment_is_healthy": {"readonly": True},
        "environment_status": {"readonly": True},
        "resource_group": {"readonly": True},
        "default_front_end_scale_factor": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "vnet_name": {"key": "vnetName", "type": "str"},
        "vnet_resource_group_name": {"key": "vnetResourceGroupName", "type": "str"},
        "vnet_subnet_name": {"key": "vnetSubnetName", "type": "str"},
        "virtual_network": {"key": "virtualNetwork", "type": "VirtualNetworkProfile"},
        "internal_load_balancing_mode": {"key": "internalLoadBalancingMode", "type": "str"},
        "multi_size": {"key": "multiSize", "type": "str"},
        "multi_role_count": {"key": "multiRoleCount", "type": "int"},
        "worker_pools": {"key": "workerPools", "type": "[WorkerPool]"},
        "ipssl_address_count": {"key": "ipsslAddressCount", "type": "int"},
        "database_edition": {"key": "databaseEdition", "type": "str"},
        "database_service_objective": {"key": "databaseServiceObjective", "type": "str"},
        "upgrade_domains": {"key": "upgradeDomains", "type": "int"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "dns_suffix": {"key": "dnsSuffix", "type": "str"},
        "last_action": {"key": "lastAction", "type": "str"},
        "last_action_result": {"key": "lastActionResult", "type": "str"},
        "allowed_multi_sizes": {"key": "allowedMultiSizes", "type": "str"},
        "allowed_worker_sizes": {"key": "allowedWorkerSizes", "type": "str"},
        "maximum_number_of_machines": {"key": "maximumNumberOfMachines", "type": "int"},
        "vip_mappings": {"key": "vipMappings", "type": "[VirtualIPMapping]"},
        "environment_capacities": {"key": "environmentCapacities", "type": "[StampCapacity]"},
        "network_access_control_list": {"key": "networkAccessControlList", "type": "[NetworkAccessControlEntry]"},
        "environment_is_healthy": {"key": "environmentIsHealthy", "type": "bool"},
        "environment_status": {"key": "environmentStatus", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "front_end_scale_factor": {"key": "frontEndScaleFactor", "type": "int"},
        "default_front_end_scale_factor": {"key": "defaultFrontEndScaleFactor", "type": "int"},
        "api_management_account_id": {"key": "apiManagementAccountId", "type": "str"},
        "suspended": {"key": "suspended", "type": "bool"},
        "dynamic_cache_enabled": {"key": "dynamicCacheEnabled", "type": "bool"},
        "cluster_settings": {"key": "clusterSettings", "type": "[NameValuePair]"},
        "user_whitelisted_ip_ranges": {"key": "userWhitelistedIpRanges", "type": "[str]"},
        "has_linux_workers": {"key": "hasLinuxWorkers", "type": "bool"},
        "ssl_cert_key_vault_id": {"key": "sslCertKeyVaultId", "type": "str"},
        "ssl_cert_key_vault_secret_name": {"key": "sslCertKeyVaultSecretName", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        name: str,
        location: str,
        virtual_network: "_models.VirtualNetworkProfile",
        worker_pools: List["_models.WorkerPool"],
        vnet_name: Optional[str] = None,
        vnet_resource_group_name: Optional[str] = None,
        vnet_subnet_name: Optional[str] = None,
        internal_load_balancing_mode: Optional[Union[str, "_models.InternalLoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        multi_role_count: Optional[int] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        network_access_control_list: Optional[List["_models.NetworkAccessControlEntry"]] = None,
        front_end_scale_factor: Optional[int] = None,
        api_management_account_id: Optional[str] = None,
        suspended: Optional[bool] = None,
        dynamic_cache_enabled: Optional[bool] = None,
        cluster_settings: Optional[List["_models.NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[List[str]] = None,
        has_linux_workers: Optional[bool] = None,
        ssl_cert_key_vault_id: Optional[str] = None,
        ssl_cert_key_vault_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the App Service Environment. Required.
        :paramtype name: str
        :keyword location: Location of the App Service Environment, e.g. "West US". Required.
        :paramtype location: str
        :keyword vnet_name: Name of the Virtual Network for the App Service Environment.
        :paramtype vnet_name: str
        :keyword vnet_resource_group_name: Resource group of the Virtual Network.
        :paramtype vnet_resource_group_name: str
        :keyword vnet_subnet_name: Subnet of the Virtual Network.
        :paramtype vnet_subnet_name: str
        :keyword virtual_network: Description of the Virtual Network. Required.
        :paramtype virtual_network: ~azure.mgmt.web.v2018_02_01.models.VirtualNetworkProfile
        :keyword internal_load_balancing_mode: Specifies which endpoints to serve internally in the
         Virtual Network for the App Service Environment. Known values are: "None", "Web", and
         "Publishing".
        :paramtype internal_load_balancing_mode: str or
         ~azure.mgmt.web.v2018_02_01.models.InternalLoadBalancingMode
        :keyword multi_size: Front-end VM size, e.g. "Medium", "Large".
        :paramtype multi_size: str
        :keyword multi_role_count: Number of front-end instances.
        :paramtype multi_role_count: int
        :keyword worker_pools: Description of worker pools with worker size IDs, VM sizes, and number
         of workers in each pool. Required.
        :paramtype worker_pools: list[~azure.mgmt.web.v2018_02_01.models.WorkerPool]
        :keyword ipssl_address_count: Number of IP SSL addresses reserved for the App Service
         Environment.
        :paramtype ipssl_address_count: int
        :keyword dns_suffix: DNS suffix of the App Service Environment.
        :paramtype dns_suffix: str
        :keyword network_access_control_list: Access control list for controlling traffic to the App
         Service Environment.
        :paramtype network_access_control_list:
         list[~azure.mgmt.web.v2018_02_01.models.NetworkAccessControlEntry]
        :keyword front_end_scale_factor: Scale factor for front-ends.
        :paramtype front_end_scale_factor: int
        :keyword api_management_account_id: API Management Account associated with the App Service
         Environment.
        :paramtype api_management_account_id: str
        :keyword suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
         otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
         management endpoint is no longer available
          (most likely because NSG blocked the incoming traffic).
        :paramtype suspended: bool
        :keyword dynamic_cache_enabled: True/false indicating whether the App Service Environment is
         suspended. The environment can be suspended e.g. when the management endpoint is no longer
         available
         (most likely because NSG blocked the incoming traffic).
        :paramtype dynamic_cache_enabled: bool
        :keyword cluster_settings: Custom settings for changing the behavior of the App Service
         Environment.
        :paramtype cluster_settings: list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]
        :keyword user_whitelisted_ip_ranges: User added list of IP Ranges allowed on ASE db.
        :paramtype user_whitelisted_ip_ranges: list[str]
        :keyword has_linux_workers: Flag that displays whether an ASE has linux workers or not.
        :paramtype has_linux_workers: bool
        :keyword ssl_cert_key_vault_id: Key Vault ID for ILB App Service Environment default SSL
         certificate.
        :paramtype ssl_cert_key_vault_id: str
        :keyword ssl_cert_key_vault_secret_name: Key Vault Secret Name for ILB App Service Environment
         default SSL certificate.
        :paramtype ssl_cert_key_vault_secret_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.location = location
        self.provisioning_state = None
        self.status = None
        self.vnet_name = vnet_name
        self.vnet_resource_group_name = vnet_resource_group_name
        self.vnet_subnet_name = vnet_subnet_name
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count = multi_role_count
        self.worker_pools = worker_pools
        self.ipssl_address_count = ipssl_address_count
        self.database_edition = None
        self.database_service_objective = None
        self.upgrade_domains = None
        self.subscription_id = None
        self.dns_suffix = dns_suffix
        self.last_action = None
        self.last_action_result = None
        self.allowed_multi_sizes = None
        self.allowed_worker_sizes = None
        self.maximum_number_of_machines = None
        self.vip_mappings = None
        self.environment_capacities = None
        self.network_access_control_list = network_access_control_list
        self.environment_is_healthy = None
        self.environment_status = None
        self.resource_group = None
        self.front_end_scale_factor = front_end_scale_factor
        self.default_front_end_scale_factor = None
        self.api_management_account_id = api_management_account_id
        self.suspended = suspended
        self.dynamic_cache_enabled = dynamic_cache_enabled
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges
        self.has_linux_workers = has_linux_workers
        self.ssl_cert_key_vault_id = ssl_cert_key_vault_id
        self.ssl_cert_key_vault_secret_name = ssl_cert_key_vault_secret_name


class AppServiceEnvironmentCollection(_serialization.Model):
    """Collection of App Service Environments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.AppServiceEnvironmentResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServiceEnvironmentResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AppServiceEnvironmentResource"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.AppServiceEnvironmentResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AppServiceEnvironmentPatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a app service environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Name of the App Service Environment.
    :vartype name_properties_name: str
    :ivar location: Location of the App Service Environment, e.g. "West US".
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the App Service Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2018_02_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Known values are: "Preparing",
     "Ready", "Scaling", and "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2018_02_01.models.HostingEnvironmentStatus
    :ivar vnet_name: Name of the Virtual Network for the App Service Environment.
    :vartype vnet_name: str
    :ivar vnet_resource_group_name: Resource group of the Virtual Network.
    :vartype vnet_resource_group_name: str
    :ivar vnet_subnet_name: Subnet of the Virtual Network.
    :vartype vnet_subnet_name: str
    :ivar virtual_network: Description of the Virtual Network.
    :vartype virtual_network: ~azure.mgmt.web.v2018_02_01.models.VirtualNetworkProfile
    :ivar internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Known values are: "None", "Web", and
     "Publishing".
    :vartype internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2018_02_01.models.InternalLoadBalancingMode
    :ivar multi_size: Front-end VM size, e.g. "Medium", "Large".
    :vartype multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :ivar worker_pools: Description of worker pools with worker size IDs, VM sizes, and number of
     workers in each pool.
    :vartype worker_pools: list[~azure.mgmt.web.v2018_02_01.models.WorkerPool]
    :ivar ipssl_address_count: Number of IP SSL addresses reserved for the App Service Environment.
    :vartype ipssl_address_count: int
    :ivar database_edition: Edition of the metadata database for the App Service Environment, e.g.
     "Standard".
    :vartype database_edition: str
    :ivar database_service_objective: Service objective of the metadata database for the App
     Service Environment, e.g. "S0".
    :vartype database_service_objective: str
    :ivar upgrade_domains: Number of upgrade domains of the App Service Environment.
    :vartype upgrade_domains: int
    :ivar subscription_id: Subscription of the App Service Environment.
    :vartype subscription_id: str
    :ivar dns_suffix: DNS suffix of the App Service Environment.
    :vartype dns_suffix: str
    :ivar last_action: Last deployment action on the App Service Environment.
    :vartype last_action: str
    :ivar last_action_result: Result of the last deployment action on the App Service Environment.
    :vartype last_action_result: str
    :ivar allowed_multi_sizes: List of comma separated strings describing which VM sizes are
     allowed for front-ends.
    :vartype allowed_multi_sizes: str
    :ivar allowed_worker_sizes: List of comma separated strings describing which VM sizes are
     allowed for workers.
    :vartype allowed_worker_sizes: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar vip_mappings: Description of IP SSL mapping for the App Service Environment.
    :vartype vip_mappings: list[~azure.mgmt.web.v2018_02_01.models.VirtualIPMapping]
    :ivar environment_capacities: Current total, used, and available worker capacities.
    :vartype environment_capacities: list[~azure.mgmt.web.v2018_02_01.models.StampCapacity]
    :ivar network_access_control_list: Access control list for controlling traffic to the App
     Service Environment.
    :vartype network_access_control_list:
     list[~azure.mgmt.web.v2018_02_01.models.NetworkAccessControlEntry]
    :ivar environment_is_healthy: True/false indicating whether the App Service Environment is
     healthy.
    :vartype environment_is_healthy: bool
    :ivar environment_status: Detailed message about with results of the last check of the App
     Service Environment.
    :vartype environment_status: str
    :ivar resource_group: Resource group of the App Service Environment.
    :vartype resource_group: str
    :ivar front_end_scale_factor: Scale factor for front-ends.
    :vartype front_end_scale_factor: int
    :ivar default_front_end_scale_factor: Default Scale Factor for FrontEnds.
    :vartype default_front_end_scale_factor: int
    :ivar api_management_account_id: API Management Account associated with the App Service
     Environment.
    :vartype api_management_account_id: str
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :ivar dynamic_cache_enabled: True/false indicating whether the App Service Environment is
     suspended. The environment can be suspended e.g. when the management endpoint is no longer
     available
     (most likely because NSG blocked the incoming traffic).
    :vartype dynamic_cache_enabled: bool
    :ivar cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :vartype cluster_settings: list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]
    :ivar user_whitelisted_ip_ranges: User added list of IP Ranges allowed on ASE db.
    :vartype user_whitelisted_ip_ranges: list[str]
    :ivar has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :vartype has_linux_workers: bool
    :ivar ssl_cert_key_vault_id: Key Vault ID for ILB App Service Environment default SSL
     certificate.
    :vartype ssl_cert_key_vault_id: str
    :ivar ssl_cert_key_vault_secret_name: Key Vault Secret Name for ILB App Service Environment
     default SSL certificate.
    :vartype ssl_cert_key_vault_secret_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "database_edition": {"readonly": True},
        "database_service_objective": {"readonly": True},
        "upgrade_domains": {"readonly": True},
        "subscription_id": {"readonly": True},
        "last_action": {"readonly": True},
        "last_action_result": {"readonly": True},
        "allowed_multi_sizes": {"readonly": True},
        "allowed_worker_sizes": {"readonly": True},
        "maximum_number_of_machines": {"readonly": True},
        "vip_mappings": {"readonly": True},
        "environment_capacities": {"readonly": True},
        "environment_is_healthy": {"readonly": True},
        "environment_status": {"readonly": True},
        "resource_group": {"readonly": True},
        "default_front_end_scale_factor": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "location": {"key": "properties.location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "vnet_name": {"key": "properties.vnetName", "type": "str"},
        "vnet_resource_group_name": {"key": "properties.vnetResourceGroupName", "type": "str"},
        "vnet_subnet_name": {"key": "properties.vnetSubnetName", "type": "str"},
        "virtual_network": {"key": "properties.virtualNetwork", "type": "VirtualNetworkProfile"},
        "internal_load_balancing_mode": {"key": "properties.internalLoadBalancingMode", "type": "str"},
        "multi_size": {"key": "properties.multiSize", "type": "str"},
        "multi_role_count": {"key": "properties.multiRoleCount", "type": "int"},
        "worker_pools": {"key": "properties.workerPools", "type": "[WorkerPool]"},
        "ipssl_address_count": {"key": "properties.ipsslAddressCount", "type": "int"},
        "database_edition": {"key": "properties.databaseEdition", "type": "str"},
        "database_service_objective": {"key": "properties.databaseServiceObjective", "type": "str"},
        "upgrade_domains": {"key": "properties.upgradeDomains", "type": "int"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
        "dns_suffix": {"key": "properties.dnsSuffix", "type": "str"},
        "last_action": {"key": "properties.lastAction", "type": "str"},
        "last_action_result": {"key": "properties.lastActionResult", "type": "str"},
        "allowed_multi_sizes": {"key": "properties.allowedMultiSizes", "type": "str"},
        "allowed_worker_sizes": {"key": "properties.allowedWorkerSizes", "type": "str"},
        "maximum_number_of_machines": {"key": "properties.maximumNumberOfMachines", "type": "int"},
        "vip_mappings": {"key": "properties.vipMappings", "type": "[VirtualIPMapping]"},
        "environment_capacities": {"key": "properties.environmentCapacities", "type": "[StampCapacity]"},
        "network_access_control_list": {
            "key": "properties.networkAccessControlList",
            "type": "[NetworkAccessControlEntry]",
        },
        "environment_is_healthy": {"key": "properties.environmentIsHealthy", "type": "bool"},
        "environment_status": {"key": "properties.environmentStatus", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "front_end_scale_factor": {"key": "properties.frontEndScaleFactor", "type": "int"},
        "default_front_end_scale_factor": {"key": "properties.defaultFrontEndScaleFactor", "type": "int"},
        "api_management_account_id": {"key": "properties.apiManagementAccountId", "type": "str"},
        "suspended": {"key": "properties.suspended", "type": "bool"},
        "dynamic_cache_enabled": {"key": "properties.dynamicCacheEnabled", "type": "bool"},
        "cluster_settings": {"key": "properties.clusterSettings", "type": "[NameValuePair]"},
        "user_whitelisted_ip_ranges": {"key": "properties.userWhitelistedIpRanges", "type": "[str]"},
        "has_linux_workers": {"key": "properties.hasLinuxWorkers", "type": "bool"},
        "ssl_cert_key_vault_id": {"key": "properties.sslCertKeyVaultId", "type": "str"},
        "ssl_cert_key_vault_secret_name": {"key": "properties.sslCertKeyVaultSecretName", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        name_properties_name: Optional[str] = None,
        location: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vnet_resource_group_name: Optional[str] = None,
        vnet_subnet_name: Optional[str] = None,
        virtual_network: Optional["_models.VirtualNetworkProfile"] = None,
        internal_load_balancing_mode: Optional[Union[str, "_models.InternalLoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        multi_role_count: Optional[int] = None,
        worker_pools: Optional[List["_models.WorkerPool"]] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        network_access_control_list: Optional[List["_models.NetworkAccessControlEntry"]] = None,
        front_end_scale_factor: Optional[int] = None,
        api_management_account_id: Optional[str] = None,
        suspended: Optional[bool] = None,
        dynamic_cache_enabled: Optional[bool] = None,
        cluster_settings: Optional[List["_models.NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[List[str]] = None,
        has_linux_workers: Optional[bool] = None,
        ssl_cert_key_vault_id: Optional[str] = None,
        ssl_cert_key_vault_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword name_properties_name: Name of the App Service Environment.
        :paramtype name_properties_name: str
        :keyword location: Location of the App Service Environment, e.g. "West US".
        :paramtype location: str
        :keyword vnet_name: Name of the Virtual Network for the App Service Environment.
        :paramtype vnet_name: str
        :keyword vnet_resource_group_name: Resource group of the Virtual Network.
        :paramtype vnet_resource_group_name: str
        :keyword vnet_subnet_name: Subnet of the Virtual Network.
        :paramtype vnet_subnet_name: str
        :keyword virtual_network: Description of the Virtual Network.
        :paramtype virtual_network: ~azure.mgmt.web.v2018_02_01.models.VirtualNetworkProfile
        :keyword internal_load_balancing_mode: Specifies which endpoints to serve internally in the
         Virtual Network for the App Service Environment. Known values are: "None", "Web", and
         "Publishing".
        :paramtype internal_load_balancing_mode: str or
         ~azure.mgmt.web.v2018_02_01.models.InternalLoadBalancingMode
        :keyword multi_size: Front-end VM size, e.g. "Medium", "Large".
        :paramtype multi_size: str
        :keyword multi_role_count: Number of front-end instances.
        :paramtype multi_role_count: int
        :keyword worker_pools: Description of worker pools with worker size IDs, VM sizes, and number
         of workers in each pool.
        :paramtype worker_pools: list[~azure.mgmt.web.v2018_02_01.models.WorkerPool]
        :keyword ipssl_address_count: Number of IP SSL addresses reserved for the App Service
         Environment.
        :paramtype ipssl_address_count: int
        :keyword dns_suffix: DNS suffix of the App Service Environment.
        :paramtype dns_suffix: str
        :keyword network_access_control_list: Access control list for controlling traffic to the App
         Service Environment.
        :paramtype network_access_control_list:
         list[~azure.mgmt.web.v2018_02_01.models.NetworkAccessControlEntry]
        :keyword front_end_scale_factor: Scale factor for front-ends.
        :paramtype front_end_scale_factor: int
        :keyword api_management_account_id: API Management Account associated with the App Service
         Environment.
        :paramtype api_management_account_id: str
        :keyword suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
         otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
         management endpoint is no longer available
          (most likely because NSG blocked the incoming traffic).
        :paramtype suspended: bool
        :keyword dynamic_cache_enabled: True/false indicating whether the App Service Environment is
         suspended. The environment can be suspended e.g. when the management endpoint is no longer
         available
         (most likely because NSG blocked the incoming traffic).
        :paramtype dynamic_cache_enabled: bool
        :keyword cluster_settings: Custom settings for changing the behavior of the App Service
         Environment.
        :paramtype cluster_settings: list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]
        :keyword user_whitelisted_ip_ranges: User added list of IP Ranges allowed on ASE db.
        :paramtype user_whitelisted_ip_ranges: list[str]
        :keyword has_linux_workers: Flag that displays whether an ASE has linux workers or not.
        :paramtype has_linux_workers: bool
        :keyword ssl_cert_key_vault_id: Key Vault ID for ILB App Service Environment default SSL
         certificate.
        :paramtype ssl_cert_key_vault_id: str
        :keyword ssl_cert_key_vault_secret_name: Key Vault Secret Name for ILB App Service Environment
         default SSL certificate.
        :paramtype ssl_cert_key_vault_secret_name: str
        """
        super().__init__(kind=kind, **kwargs)
        self.name_properties_name = name_properties_name
        self.location = location
        self.provisioning_state = None
        self.status = None
        self.vnet_name = vnet_name
        self.vnet_resource_group_name = vnet_resource_group_name
        self.vnet_subnet_name = vnet_subnet_name
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count = multi_role_count
        self.worker_pools = worker_pools
        self.ipssl_address_count = ipssl_address_count
        self.database_edition = None
        self.database_service_objective = None
        self.upgrade_domains = None
        self.subscription_id = None
        self.dns_suffix = dns_suffix
        self.last_action = None
        self.last_action_result = None
        self.allowed_multi_sizes = None
        self.allowed_worker_sizes = None
        self.maximum_number_of_machines = None
        self.vip_mappings = None
        self.environment_capacities = None
        self.network_access_control_list = network_access_control_list
        self.environment_is_healthy = None
        self.environment_status = None
        self.resource_group = None
        self.front_end_scale_factor = front_end_scale_factor
        self.default_front_end_scale_factor = None
        self.api_management_account_id = api_management_account_id
        self.suspended = suspended
        self.dynamic_cache_enabled = dynamic_cache_enabled
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges
        self.has_linux_workers = has_linux_workers
        self.ssl_cert_key_vault_id = ssl_cert_key_vault_id
        self.ssl_cert_key_vault_secret_name = ssl_cert_key_vault_secret_name


class AppServiceEnvironmentResource(Resource):  # pylint: disable=too-many-instance-attributes
    """App Service Environment ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar name_properties_name: Name of the App Service Environment.
    :vartype name_properties_name: str
    :ivar location_properties_location: Location of the App Service Environment, e.g. "West US".
    :vartype location_properties_location: str
    :ivar provisioning_state: Provisioning state of the App Service Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2018_02_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Known values are: "Preparing",
     "Ready", "Scaling", and "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2018_02_01.models.HostingEnvironmentStatus
    :ivar vnet_name: Name of the Virtual Network for the App Service Environment.
    :vartype vnet_name: str
    :ivar vnet_resource_group_name: Resource group of the Virtual Network.
    :vartype vnet_resource_group_name: str
    :ivar vnet_subnet_name: Subnet of the Virtual Network.
    :vartype vnet_subnet_name: str
    :ivar virtual_network: Description of the Virtual Network.
    :vartype virtual_network: ~azure.mgmt.web.v2018_02_01.models.VirtualNetworkProfile
    :ivar internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Known values are: "None", "Web", and
     "Publishing".
    :vartype internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2018_02_01.models.InternalLoadBalancingMode
    :ivar multi_size: Front-end VM size, e.g. "Medium", "Large".
    :vartype multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :ivar worker_pools: Description of worker pools with worker size IDs, VM sizes, and number of
     workers in each pool.
    :vartype worker_pools: list[~azure.mgmt.web.v2018_02_01.models.WorkerPool]
    :ivar ipssl_address_count: Number of IP SSL addresses reserved for the App Service Environment.
    :vartype ipssl_address_count: int
    :ivar database_edition: Edition of the metadata database for the App Service Environment, e.g.
     "Standard".
    :vartype database_edition: str
    :ivar database_service_objective: Service objective of the metadata database for the App
     Service Environment, e.g. "S0".
    :vartype database_service_objective: str
    :ivar upgrade_domains: Number of upgrade domains of the App Service Environment.
    :vartype upgrade_domains: int
    :ivar subscription_id: Subscription of the App Service Environment.
    :vartype subscription_id: str
    :ivar dns_suffix: DNS suffix of the App Service Environment.
    :vartype dns_suffix: str
    :ivar last_action: Last deployment action on the App Service Environment.
    :vartype last_action: str
    :ivar last_action_result: Result of the last deployment action on the App Service Environment.
    :vartype last_action_result: str
    :ivar allowed_multi_sizes: List of comma separated strings describing which VM sizes are
     allowed for front-ends.
    :vartype allowed_multi_sizes: str
    :ivar allowed_worker_sizes: List of comma separated strings describing which VM sizes are
     allowed for workers.
    :vartype allowed_worker_sizes: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar vip_mappings: Description of IP SSL mapping for the App Service Environment.
    :vartype vip_mappings: list[~azure.mgmt.web.v2018_02_01.models.VirtualIPMapping]
    :ivar environment_capacities: Current total, used, and available worker capacities.
    :vartype environment_capacities: list[~azure.mgmt.web.v2018_02_01.models.StampCapacity]
    :ivar network_access_control_list: Access control list for controlling traffic to the App
     Service Environment.
    :vartype network_access_control_list:
     list[~azure.mgmt.web.v2018_02_01.models.NetworkAccessControlEntry]
    :ivar environment_is_healthy: True/false indicating whether the App Service Environment is
     healthy.
    :vartype environment_is_healthy: bool
    :ivar environment_status: Detailed message about with results of the last check of the App
     Service Environment.
    :vartype environment_status: str
    :ivar resource_group: Resource group of the App Service Environment.
    :vartype resource_group: str
    :ivar front_end_scale_factor: Scale factor for front-ends.
    :vartype front_end_scale_factor: int
    :ivar default_front_end_scale_factor: Default Scale Factor for FrontEnds.
    :vartype default_front_end_scale_factor: int
    :ivar api_management_account_id: API Management Account associated with the App Service
     Environment.
    :vartype api_management_account_id: str
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :ivar dynamic_cache_enabled: True/false indicating whether the App Service Environment is
     suspended. The environment can be suspended e.g. when the management endpoint is no longer
     available
     (most likely because NSG blocked the incoming traffic).
    :vartype dynamic_cache_enabled: bool
    :ivar cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :vartype cluster_settings: list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]
    :ivar user_whitelisted_ip_ranges: User added list of IP Ranges allowed on ASE db.
    :vartype user_whitelisted_ip_ranges: list[str]
    :ivar has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :vartype has_linux_workers: bool
    :ivar ssl_cert_key_vault_id: Key Vault ID for ILB App Service Environment default SSL
     certificate.
    :vartype ssl_cert_key_vault_id: str
    :ivar ssl_cert_key_vault_secret_name: Key Vault Secret Name for ILB App Service Environment
     default SSL certificate.
    :vartype ssl_cert_key_vault_secret_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "database_edition": {"readonly": True},
        "database_service_objective": {"readonly": True},
        "upgrade_domains": {"readonly": True},
        "subscription_id": {"readonly": True},
        "last_action": {"readonly": True},
        "last_action_result": {"readonly": True},
        "allowed_multi_sizes": {"readonly": True},
        "allowed_worker_sizes": {"readonly": True},
        "maximum_number_of_machines": {"readonly": True},
        "vip_mappings": {"readonly": True},
        "environment_capacities": {"readonly": True},
        "environment_is_healthy": {"readonly": True},
        "environment_status": {"readonly": True},
        "resource_group": {"readonly": True},
        "default_front_end_scale_factor": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "location_properties_location": {"key": "properties.location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "vnet_name": {"key": "properties.vnetName", "type": "str"},
        "vnet_resource_group_name": {"key": "properties.vnetResourceGroupName", "type": "str"},
        "vnet_subnet_name": {"key": "properties.vnetSubnetName", "type": "str"},
        "virtual_network": {"key": "properties.virtualNetwork", "type": "VirtualNetworkProfile"},
        "internal_load_balancing_mode": {"key": "properties.internalLoadBalancingMode", "type": "str"},
        "multi_size": {"key": "properties.multiSize", "type": "str"},
        "multi_role_count": {"key": "properties.multiRoleCount", "type": "int"},
        "worker_pools": {"key": "properties.workerPools", "type": "[WorkerPool]"},
        "ipssl_address_count": {"key": "properties.ipsslAddressCount", "type": "int"},
        "database_edition": {"key": "properties.databaseEdition", "type": "str"},
        "database_service_objective": {"key": "properties.databaseServiceObjective", "type": "str"},
        "upgrade_domains": {"key": "properties.upgradeDomains", "type": "int"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
        "dns_suffix": {"key": "properties.dnsSuffix", "type": "str"},
        "last_action": {"key": "properties.lastAction", "type": "str"},
        "last_action_result": {"key": "properties.lastActionResult", "type": "str"},
        "allowed_multi_sizes": {"key": "properties.allowedMultiSizes", "type": "str"},
        "allowed_worker_sizes": {"key": "properties.allowedWorkerSizes", "type": "str"},
        "maximum_number_of_machines": {"key": "properties.maximumNumberOfMachines", "type": "int"},
        "vip_mappings": {"key": "properties.vipMappings", "type": "[VirtualIPMapping]"},
        "environment_capacities": {"key": "properties.environmentCapacities", "type": "[StampCapacity]"},
        "network_access_control_list": {
            "key": "properties.networkAccessControlList",
            "type": "[NetworkAccessControlEntry]",
        },
        "environment_is_healthy": {"key": "properties.environmentIsHealthy", "type": "bool"},
        "environment_status": {"key": "properties.environmentStatus", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "front_end_scale_factor": {"key": "properties.frontEndScaleFactor", "type": "int"},
        "default_front_end_scale_factor": {"key": "properties.defaultFrontEndScaleFactor", "type": "int"},
        "api_management_account_id": {"key": "properties.apiManagementAccountId", "type": "str"},
        "suspended": {"key": "properties.suspended", "type": "bool"},
        "dynamic_cache_enabled": {"key": "properties.dynamicCacheEnabled", "type": "bool"},
        "cluster_settings": {"key": "properties.clusterSettings", "type": "[NameValuePair]"},
        "user_whitelisted_ip_ranges": {"key": "properties.userWhitelistedIpRanges", "type": "[str]"},
        "has_linux_workers": {"key": "properties.hasLinuxWorkers", "type": "bool"},
        "ssl_cert_key_vault_id": {"key": "properties.sslCertKeyVaultId", "type": "str"},
        "ssl_cert_key_vault_secret_name": {"key": "properties.sslCertKeyVaultSecretName", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        name_properties_name: Optional[str] = None,
        location_properties_location: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vnet_resource_group_name: Optional[str] = None,
        vnet_subnet_name: Optional[str] = None,
        virtual_network: Optional["_models.VirtualNetworkProfile"] = None,
        internal_load_balancing_mode: Optional[Union[str, "_models.InternalLoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        multi_role_count: Optional[int] = None,
        worker_pools: Optional[List["_models.WorkerPool"]] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        network_access_control_list: Optional[List["_models.NetworkAccessControlEntry"]] = None,
        front_end_scale_factor: Optional[int] = None,
        api_management_account_id: Optional[str] = None,
        suspended: Optional[bool] = None,
        dynamic_cache_enabled: Optional[bool] = None,
        cluster_settings: Optional[List["_models.NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[List[str]] = None,
        has_linux_workers: Optional[bool] = None,
        ssl_cert_key_vault_id: Optional[str] = None,
        ssl_cert_key_vault_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword name_properties_name: Name of the App Service Environment.
        :paramtype name_properties_name: str
        :keyword location_properties_location: Location of the App Service Environment, e.g. "West US".
        :paramtype location_properties_location: str
        :keyword vnet_name: Name of the Virtual Network for the App Service Environment.
        :paramtype vnet_name: str
        :keyword vnet_resource_group_name: Resource group of the Virtual Network.
        :paramtype vnet_resource_group_name: str
        :keyword vnet_subnet_name: Subnet of the Virtual Network.
        :paramtype vnet_subnet_name: str
        :keyword virtual_network: Description of the Virtual Network.
        :paramtype virtual_network: ~azure.mgmt.web.v2018_02_01.models.VirtualNetworkProfile
        :keyword internal_load_balancing_mode: Specifies which endpoints to serve internally in the
         Virtual Network for the App Service Environment. Known values are: "None", "Web", and
         "Publishing".
        :paramtype internal_load_balancing_mode: str or
         ~azure.mgmt.web.v2018_02_01.models.InternalLoadBalancingMode
        :keyword multi_size: Front-end VM size, e.g. "Medium", "Large".
        :paramtype multi_size: str
        :keyword multi_role_count: Number of front-end instances.
        :paramtype multi_role_count: int
        :keyword worker_pools: Description of worker pools with worker size IDs, VM sizes, and number
         of workers in each pool.
        :paramtype worker_pools: list[~azure.mgmt.web.v2018_02_01.models.WorkerPool]
        :keyword ipssl_address_count: Number of IP SSL addresses reserved for the App Service
         Environment.
        :paramtype ipssl_address_count: int
        :keyword dns_suffix: DNS suffix of the App Service Environment.
        :paramtype dns_suffix: str
        :keyword network_access_control_list: Access control list for controlling traffic to the App
         Service Environment.
        :paramtype network_access_control_list:
         list[~azure.mgmt.web.v2018_02_01.models.NetworkAccessControlEntry]
        :keyword front_end_scale_factor: Scale factor for front-ends.
        :paramtype front_end_scale_factor: int
        :keyword api_management_account_id: API Management Account associated with the App Service
         Environment.
        :paramtype api_management_account_id: str
        :keyword suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
         otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
         management endpoint is no longer available
          (most likely because NSG blocked the incoming traffic).
        :paramtype suspended: bool
        :keyword dynamic_cache_enabled: True/false indicating whether the App Service Environment is
         suspended. The environment can be suspended e.g. when the management endpoint is no longer
         available
         (most likely because NSG blocked the incoming traffic).
        :paramtype dynamic_cache_enabled: bool
        :keyword cluster_settings: Custom settings for changing the behavior of the App Service
         Environment.
        :paramtype cluster_settings: list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]
        :keyword user_whitelisted_ip_ranges: User added list of IP Ranges allowed on ASE db.
        :paramtype user_whitelisted_ip_ranges: list[str]
        :keyword has_linux_workers: Flag that displays whether an ASE has linux workers or not.
        :paramtype has_linux_workers: bool
        :keyword ssl_cert_key_vault_id: Key Vault ID for ILB App Service Environment default SSL
         certificate.
        :paramtype ssl_cert_key_vault_id: str
        :keyword ssl_cert_key_vault_secret_name: Key Vault Secret Name for ILB App Service Environment
         default SSL certificate.
        :paramtype ssl_cert_key_vault_secret_name: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.name_properties_name = name_properties_name
        self.location_properties_location = location_properties_location
        self.provisioning_state = None
        self.status = None
        self.vnet_name = vnet_name
        self.vnet_resource_group_name = vnet_resource_group_name
        self.vnet_subnet_name = vnet_subnet_name
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count = multi_role_count
        self.worker_pools = worker_pools
        self.ipssl_address_count = ipssl_address_count
        self.database_edition = None
        self.database_service_objective = None
        self.upgrade_domains = None
        self.subscription_id = None
        self.dns_suffix = dns_suffix
        self.last_action = None
        self.last_action_result = None
        self.allowed_multi_sizes = None
        self.allowed_worker_sizes = None
        self.maximum_number_of_machines = None
        self.vip_mappings = None
        self.environment_capacities = None
        self.network_access_control_list = network_access_control_list
        self.environment_is_healthy = None
        self.environment_status = None
        self.resource_group = None
        self.front_end_scale_factor = front_end_scale_factor
        self.default_front_end_scale_factor = None
        self.api_management_account_id = api_management_account_id
        self.suspended = suspended
        self.dynamic_cache_enabled = dynamic_cache_enabled
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges
        self.has_linux_workers = has_linux_workers
        self.ssl_cert_key_vault_id = ssl_cert_key_vault_id
        self.ssl_cert_key_vault_secret_name = ssl_cert_key_vault_secret_name


class AppServicePlan(Resource):  # pylint: disable=too-many-instance-attributes
    """App Service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Description of a SKU for a scalable resource.
    :vartype sku: ~azure.mgmt.web.v2018_02_01.models.SkuDescription
    :ivar worker_tier_name: Target worker tier assigned to the App Service plan.
    :vartype worker_tier_name: str
    :ivar status: App Service plan status. Known values are: "Ready", "Pending", and "Creating".
    :vartype status: str or ~azure.mgmt.web.v2018_02_01.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     App Service plan.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2018_02_01.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :ivar per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :vartype per_site_scaling: bool
    :ivar maximum_elastic_worker_count: Maximum number of total workers allowed for this
     ElasticScaleEnabled App Service Plan.
    :vartype maximum_elastic_worker_count: int
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :ivar is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :vartype is_spot: bool
    :ivar spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :vartype spot_expiration_time: ~datetime.datetime
    :ivar free_offer_expiration_time: The time when the server farm free offer expires.
    :vartype free_offer_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :ivar reserved: If Linux app service plan :code:`<code>true</code>`, :code:`<code>false</code>`
     otherwise.
    :vartype reserved: bool
    :ivar is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :vartype is_xenon: bool
    :ivar hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :vartype hyper_v: bool
    :ivar target_worker_count: Scaling worker count.
    :vartype target_worker_count: int
    :ivar target_worker_size_id: Scaling worker size ID.
    :vartype target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2018_02_01.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "status": {"readonly": True},
        "subscription": {"readonly": True},
        "maximum_number_of_workers": {"readonly": True},
        "geo_region": {"readonly": True},
        "number_of_sites": {"readonly": True},
        "resource_group": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "SkuDescription"},
        "worker_tier_name": {"key": "properties.workerTierName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "subscription": {"key": "properties.subscription", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "maximum_number_of_workers": {"key": "properties.maximumNumberOfWorkers", "type": "int"},
        "geo_region": {"key": "properties.geoRegion", "type": "str"},
        "per_site_scaling": {"key": "properties.perSiteScaling", "type": "bool"},
        "maximum_elastic_worker_count": {"key": "properties.maximumElasticWorkerCount", "type": "int"},
        "number_of_sites": {"key": "properties.numberOfSites", "type": "int"},
        "is_spot": {"key": "properties.isSpot", "type": "bool"},
        "spot_expiration_time": {"key": "properties.spotExpirationTime", "type": "iso-8601"},
        "free_offer_expiration_time": {"key": "properties.freeOfferExpirationTime", "type": "iso-8601"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "reserved": {"key": "properties.reserved", "type": "bool"},
        "is_xenon": {"key": "properties.isXenon", "type": "bool"},
        "hyper_v": {"key": "properties.hyperV", "type": "bool"},
        "target_worker_count": {"key": "properties.targetWorkerCount", "type": "int"},
        "target_worker_size_id": {"key": "properties.targetWorkerSizeId", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.SkuDescription"] = None,
        worker_tier_name: Optional[str] = None,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        per_site_scaling: bool = False,
        maximum_elastic_worker_count: Optional[int] = None,
        is_spot: Optional[bool] = None,
        spot_expiration_time: Optional[datetime.datetime] = None,
        free_offer_expiration_time: Optional[datetime.datetime] = None,
        reserved: bool = False,
        is_xenon: bool = False,
        hyper_v: bool = False,
        target_worker_count: Optional[int] = None,
        target_worker_size_id: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Description of a SKU for a scalable resource.
        :paramtype sku: ~azure.mgmt.web.v2018_02_01.models.SkuDescription
        :keyword worker_tier_name: Target worker tier assigned to the App Service plan.
        :paramtype worker_tier_name: str
        :keyword hosting_environment_profile: Specification for the App Service Environment to use for
         the App Service plan.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2018_02_01.models.HostingEnvironmentProfile
        :keyword per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
         can be scaled independently.
         If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
         instances of the plan.
        :paramtype per_site_scaling: bool
        :keyword maximum_elastic_worker_count: Maximum number of total workers allowed for this
         ElasticScaleEnabled App Service Plan.
        :paramtype maximum_elastic_worker_count: int
        :keyword is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
        :paramtype is_spot: bool
        :keyword spot_expiration_time: The time when the server farm expires. Valid only if it is a
         spot server farm.
        :paramtype spot_expiration_time: ~datetime.datetime
        :keyword free_offer_expiration_time: The time when the server farm free offer expires.
        :paramtype free_offer_expiration_time: ~datetime.datetime
        :keyword reserved: If Linux app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype reserved: bool
        :keyword is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype is_xenon: bool
        :keyword hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype hyper_v: bool
        :keyword target_worker_count: Scaling worker count.
        :paramtype target_worker_count: int
        :keyword target_worker_size_id: Scaling worker size ID.
        :paramtype target_worker_size_id: int
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.worker_tier_name = worker_tier_name
        self.status = None
        self.subscription = None
        self.hosting_environment_profile = hosting_environment_profile
        self.maximum_number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = per_site_scaling
        self.maximum_elastic_worker_count = maximum_elastic_worker_count
        self.number_of_sites = None
        self.is_spot = is_spot
        self.spot_expiration_time = spot_expiration_time
        self.free_offer_expiration_time = free_offer_expiration_time
        self.resource_group = None
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.target_worker_count = target_worker_count
        self.target_worker_size_id = target_worker_size_id
        self.provisioning_state = None


class AppServicePlanCollection(_serialization.Model):
    """Collection of App Service plans.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.AppServicePlan]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServicePlan]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AppServicePlan"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.AppServicePlan]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AppServicePlanPatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a app service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar worker_tier_name: Target worker tier assigned to the App Service plan.
    :vartype worker_tier_name: str
    :ivar status: App Service plan status. Known values are: "Ready", "Pending", and "Creating".
    :vartype status: str or ~azure.mgmt.web.v2018_02_01.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     App Service plan.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2018_02_01.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :ivar per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :vartype per_site_scaling: bool
    :ivar maximum_elastic_worker_count: Maximum number of total workers allowed for this
     ElasticScaleEnabled App Service Plan.
    :vartype maximum_elastic_worker_count: int
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :ivar is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :vartype is_spot: bool
    :ivar spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :vartype spot_expiration_time: ~datetime.datetime
    :ivar free_offer_expiration_time: The time when the server farm free offer expires.
    :vartype free_offer_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :ivar reserved: If Linux app service plan :code:`<code>true</code>`, :code:`<code>false</code>`
     otherwise.
    :vartype reserved: bool
    :ivar is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :vartype is_xenon: bool
    :ivar hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :vartype hyper_v: bool
    :ivar target_worker_count: Scaling worker count.
    :vartype target_worker_count: int
    :ivar target_worker_size_id: Scaling worker size ID.
    :vartype target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2018_02_01.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "status": {"readonly": True},
        "subscription": {"readonly": True},
        "maximum_number_of_workers": {"readonly": True},
        "geo_region": {"readonly": True},
        "number_of_sites": {"readonly": True},
        "resource_group": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "worker_tier_name": {"key": "properties.workerTierName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "subscription": {"key": "properties.subscription", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "maximum_number_of_workers": {"key": "properties.maximumNumberOfWorkers", "type": "int"},
        "geo_region": {"key": "properties.geoRegion", "type": "str"},
        "per_site_scaling": {"key": "properties.perSiteScaling", "type": "bool"},
        "maximum_elastic_worker_count": {"key": "properties.maximumElasticWorkerCount", "type": "int"},
        "number_of_sites": {"key": "properties.numberOfSites", "type": "int"},
        "is_spot": {"key": "properties.isSpot", "type": "bool"},
        "spot_expiration_time": {"key": "properties.spotExpirationTime", "type": "iso-8601"},
        "free_offer_expiration_time": {"key": "properties.freeOfferExpirationTime", "type": "iso-8601"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "reserved": {"key": "properties.reserved", "type": "bool"},
        "is_xenon": {"key": "properties.isXenon", "type": "bool"},
        "hyper_v": {"key": "properties.hyperV", "type": "bool"},
        "target_worker_count": {"key": "properties.targetWorkerCount", "type": "int"},
        "target_worker_size_id": {"key": "properties.targetWorkerSizeId", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        worker_tier_name: Optional[str] = None,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        per_site_scaling: bool = False,
        maximum_elastic_worker_count: Optional[int] = None,
        is_spot: Optional[bool] = None,
        spot_expiration_time: Optional[datetime.datetime] = None,
        free_offer_expiration_time: Optional[datetime.datetime] = None,
        reserved: bool = False,
        is_xenon: bool = False,
        hyper_v: bool = False,
        target_worker_count: Optional[int] = None,
        target_worker_size_id: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword worker_tier_name: Target worker tier assigned to the App Service plan.
        :paramtype worker_tier_name: str
        :keyword hosting_environment_profile: Specification for the App Service Environment to use for
         the App Service plan.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2018_02_01.models.HostingEnvironmentProfile
        :keyword per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
         can be scaled independently.
         If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
         instances of the plan.
        :paramtype per_site_scaling: bool
        :keyword maximum_elastic_worker_count: Maximum number of total workers allowed for this
         ElasticScaleEnabled App Service Plan.
        :paramtype maximum_elastic_worker_count: int
        :keyword is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
        :paramtype is_spot: bool
        :keyword spot_expiration_time: The time when the server farm expires. Valid only if it is a
         spot server farm.
        :paramtype spot_expiration_time: ~datetime.datetime
        :keyword free_offer_expiration_time: The time when the server farm free offer expires.
        :paramtype free_offer_expiration_time: ~datetime.datetime
        :keyword reserved: If Linux app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype reserved: bool
        :keyword is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype is_xenon: bool
        :keyword hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype hyper_v: bool
        :keyword target_worker_count: Scaling worker count.
        :paramtype target_worker_count: int
        :keyword target_worker_size_id: Scaling worker size ID.
        :paramtype target_worker_size_id: int
        """
        super().__init__(kind=kind, **kwargs)
        self.worker_tier_name = worker_tier_name
        self.status = None
        self.subscription = None
        self.hosting_environment_profile = hosting_environment_profile
        self.maximum_number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = per_site_scaling
        self.maximum_elastic_worker_count = maximum_elastic_worker_count
        self.number_of_sites = None
        self.is_spot = is_spot
        self.spot_expiration_time = spot_expiration_time
        self.free_offer_expiration_time = free_offer_expiration_time
        self.resource_group = None
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.target_worker_count = target_worker_count
        self.target_worker_size_id = target_worker_size_id
        self.provisioning_state = None


class AutoHealActions(_serialization.Model):
    """Actions which to take by the auto-heal module when a rule is triggered.

    :ivar action_type: Predefined action to be taken. Known values are: "Recycle", "LogEvent", and
     "CustomAction".
    :vartype action_type: str or ~azure.mgmt.web.v2018_02_01.models.AutoHealActionType
    :ivar custom_action: Custom action to be taken.
    :vartype custom_action: ~azure.mgmt.web.v2018_02_01.models.AutoHealCustomAction
    :ivar min_process_execution_time: Minimum time the process must execute
     before taking the action.
    :vartype min_process_execution_time: str
    """

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "custom_action": {"key": "customAction", "type": "AutoHealCustomAction"},
        "min_process_execution_time": {"key": "minProcessExecutionTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.AutoHealActionType"]] = None,
        custom_action: Optional["_models.AutoHealCustomAction"] = None,
        min_process_execution_time: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_type: Predefined action to be taken. Known values are: "Recycle", "LogEvent",
         and "CustomAction".
        :paramtype action_type: str or ~azure.mgmt.web.v2018_02_01.models.AutoHealActionType
        :keyword custom_action: Custom action to be taken.
        :paramtype custom_action: ~azure.mgmt.web.v2018_02_01.models.AutoHealCustomAction
        :keyword min_process_execution_time: Minimum time the process must execute
         before taking the action.
        :paramtype min_process_execution_time: str
        """
        super().__init__(**kwargs)
        self.action_type = action_type
        self.custom_action = custom_action
        self.min_process_execution_time = min_process_execution_time


class AutoHealCustomAction(_serialization.Model):
    """Custom action to be executed
    when an auto heal rule is triggered.

    :ivar exe: Executable to be run.
    :vartype exe: str
    :ivar parameters: Parameters for the executable.
    :vartype parameters: str
    """

    _attribute_map = {
        "exe": {"key": "exe", "type": "str"},
        "parameters": {"key": "parameters", "type": "str"},
    }

    def __init__(self, *, exe: Optional[str] = None, parameters: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword exe: Executable to be run.
        :paramtype exe: str
        :keyword parameters: Parameters for the executable.
        :paramtype parameters: str
        """
        super().__init__(**kwargs)
        self.exe = exe
        self.parameters = parameters


class AutoHealRules(_serialization.Model):
    """Rules that can be defined for auto-heal.

    :ivar triggers: Conditions that describe when to execute the auto-heal actions.
    :vartype triggers: ~azure.mgmt.web.v2018_02_01.models.AutoHealTriggers
    :ivar actions: Actions to be executed when a rule is triggered.
    :vartype actions: ~azure.mgmt.web.v2018_02_01.models.AutoHealActions
    """

    _attribute_map = {
        "triggers": {"key": "triggers", "type": "AutoHealTriggers"},
        "actions": {"key": "actions", "type": "AutoHealActions"},
    }

    def __init__(
        self,
        *,
        triggers: Optional["_models.AutoHealTriggers"] = None,
        actions: Optional["_models.AutoHealActions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword triggers: Conditions that describe when to execute the auto-heal actions.
        :paramtype triggers: ~azure.mgmt.web.v2018_02_01.models.AutoHealTriggers
        :keyword actions: Actions to be executed when a rule is triggered.
        :paramtype actions: ~azure.mgmt.web.v2018_02_01.models.AutoHealActions
        """
        super().__init__(**kwargs)
        self.triggers = triggers
        self.actions = actions


class AutoHealTriggers(_serialization.Model):
    """Triggers for auto-heal.

    :ivar requests: A rule based on total requests.
    :vartype requests: ~azure.mgmt.web.v2018_02_01.models.RequestsBasedTrigger
    :ivar private_bytes_in_kb: A rule based on private bytes.
    :vartype private_bytes_in_kb: int
    :ivar status_codes: A rule based on status codes.
    :vartype status_codes: list[~azure.mgmt.web.v2018_02_01.models.StatusCodesBasedTrigger]
    :ivar slow_requests: A rule based on request execution time.
    :vartype slow_requests: ~azure.mgmt.web.v2018_02_01.models.SlowRequestsBasedTrigger
    """

    _attribute_map = {
        "requests": {"key": "requests", "type": "RequestsBasedTrigger"},
        "private_bytes_in_kb": {"key": "privateBytesInKB", "type": "int"},
        "status_codes": {"key": "statusCodes", "type": "[StatusCodesBasedTrigger]"},
        "slow_requests": {"key": "slowRequests", "type": "SlowRequestsBasedTrigger"},
    }

    def __init__(
        self,
        *,
        requests: Optional["_models.RequestsBasedTrigger"] = None,
        private_bytes_in_kb: Optional[int] = None,
        status_codes: Optional[List["_models.StatusCodesBasedTrigger"]] = None,
        slow_requests: Optional["_models.SlowRequestsBasedTrigger"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword requests: A rule based on total requests.
        :paramtype requests: ~azure.mgmt.web.v2018_02_01.models.RequestsBasedTrigger
        :keyword private_bytes_in_kb: A rule based on private bytes.
        :paramtype private_bytes_in_kb: int
        :keyword status_codes: A rule based on status codes.
        :paramtype status_codes: list[~azure.mgmt.web.v2018_02_01.models.StatusCodesBasedTrigger]
        :keyword slow_requests: A rule based on request execution time.
        :paramtype slow_requests: ~azure.mgmt.web.v2018_02_01.models.SlowRequestsBasedTrigger
        """
        super().__init__(**kwargs)
        self.requests = requests
        self.private_bytes_in_kb = private_bytes_in_kb
        self.status_codes = status_codes
        self.slow_requests = slow_requests


class AzureBlobStorageApplicationLogsConfig(_serialization.Model):
    """Application logs azure blob storage configuration.

    :ivar level: Log level. Known values are: "Off", "Verbose", "Information", "Warning", and
     "Error".
    :vartype level: str or ~azure.mgmt.web.v2018_02_01.models.LogLevel
    :ivar sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
    :vartype sas_url: str
    :ivar retention_in_days: Retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
    :vartype retention_in_days: int
    """

    _attribute_map = {
        "level": {"key": "level", "type": "str"},
        "sas_url": {"key": "sasUrl", "type": "str"},
        "retention_in_days": {"key": "retentionInDays", "type": "int"},
    }

    def __init__(
        self,
        *,
        level: Optional[Union[str, "_models.LogLevel"]] = None,
        sas_url: Optional[str] = None,
        retention_in_days: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword level: Log level. Known values are: "Off", "Verbose", "Information", "Warning", and
         "Error".
        :paramtype level: str or ~azure.mgmt.web.v2018_02_01.models.LogLevel
        :keyword sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
        :paramtype sas_url: str
        :keyword retention_in_days: Retention in days.
         Remove blobs older than X days.
         0 or lower means no retention.
        :paramtype retention_in_days: int
        """
        super().__init__(**kwargs)
        self.level = level
        self.sas_url = sas_url
        self.retention_in_days = retention_in_days


class AzureBlobStorageHttpLogsConfig(_serialization.Model):
    """Http logs to azure blob storage configuration.

    :ivar sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
    :vartype sas_url: str
    :ivar retention_in_days: Retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
    :vartype retention_in_days: int
    :ivar enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :vartype enabled: bool
    """

    _attribute_map = {
        "sas_url": {"key": "sasUrl", "type": "str"},
        "retention_in_days": {"key": "retentionInDays", "type": "int"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        sas_url: Optional[str] = None,
        retention_in_days: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
        :paramtype sas_url: str
        :keyword retention_in_days: Retention in days.
         Remove blobs older than X days.
         0 or lower means no retention.
        :paramtype retention_in_days: int
        :keyword enabled: True if configuration is enabled, false if it is disabled and null if
         configuration is not set.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.sas_url = sas_url
        self.retention_in_days = retention_in_days
        self.enabled = enabled


class AzureStorageInfoValue(_serialization.Model):
    """Azure Files or Blob Storage access information value for dictionary storage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Type of storage. Known values are: "AzureFiles" and "AzureBlob".
    :vartype type: str or ~azure.mgmt.web.v2018_02_01.models.AzureStorageType
    :ivar account_name: Name of the storage account.
    :vartype account_name: str
    :ivar share_name: Name of the file share (container name, for Blob storage).
    :vartype share_name: str
    :ivar access_key: Access key for the storage account.
    :vartype access_key: str
    :ivar mount_path: Path to mount the storage within the site's runtime environment.
    :vartype mount_path: str
    :ivar state: State of the storage account. Known values are: "Ok", "InvalidCredentials", and
     "InvalidShare".
    :vartype state: str or ~azure.mgmt.web.v2018_02_01.models.AzureStorageState
    """

    _validation = {
        "state": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "account_name": {"key": "accountName", "type": "str"},
        "share_name": {"key": "shareName", "type": "str"},
        "access_key": {"key": "accessKey", "type": "str"},
        "mount_path": {"key": "mountPath", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.AzureStorageType"]] = None,
        account_name: Optional[str] = None,
        share_name: Optional[str] = None,
        access_key: Optional[str] = None,
        mount_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of storage. Known values are: "AzureFiles" and "AzureBlob".
        :paramtype type: str or ~azure.mgmt.web.v2018_02_01.models.AzureStorageType
        :keyword account_name: Name of the storage account.
        :paramtype account_name: str
        :keyword share_name: Name of the file share (container name, for Blob storage).
        :paramtype share_name: str
        :keyword access_key: Access key for the storage account.
        :paramtype access_key: str
        :keyword mount_path: Path to mount the storage within the site's runtime environment.
        :paramtype mount_path: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.account_name = account_name
        self.share_name = share_name
        self.access_key = access_key
        self.mount_path = mount_path
        self.state = None


class AzureStoragePropertyDictionaryResource(ProxyOnlyResource):
    """AzureStorageInfo dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Azure storage accounts.
    :vartype properties: dict[str, ~azure.mgmt.web.v2018_02_01.models.AzureStorageInfoValue]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "{AzureStorageInfoValue}"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        properties: Optional[Dict[str, "_models.AzureStorageInfoValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword properties: Azure storage accounts.
        :paramtype properties: dict[str, ~azure.mgmt.web.v2018_02_01.models.AzureStorageInfoValue]
        """
        super().__init__(kind=kind, **kwargs)
        self.properties = properties


class AzureTableStorageApplicationLogsConfig(_serialization.Model):
    """Application logs to Azure table storage configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar level: Log level. Known values are: "Off", "Verbose", "Information", "Warning", and
     "Error".
    :vartype level: str or ~azure.mgmt.web.v2018_02_01.models.LogLevel
    :ivar sas_url: SAS URL to an Azure table with add/query/delete permissions. Required.
    :vartype sas_url: str
    """

    _validation = {
        "sas_url": {"required": True},
    }

    _attribute_map = {
        "level": {"key": "level", "type": "str"},
        "sas_url": {"key": "sasUrl", "type": "str"},
    }

    def __init__(self, *, sas_url: str, level: Optional[Union[str, "_models.LogLevel"]] = None, **kwargs: Any) -> None:
        """
        :keyword level: Log level. Known values are: "Off", "Verbose", "Information", "Warning", and
         "Error".
        :paramtype level: str or ~azure.mgmt.web.v2018_02_01.models.LogLevel
        :keyword sas_url: SAS URL to an Azure table with add/query/delete permissions. Required.
        :paramtype sas_url: str
        """
        super().__init__(**kwargs)
        self.level = level
        self.sas_url = sas_url


class BackupItem(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Backup description.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar backup_id: Id of the backup.
    :vartype backup_id: int
    :ivar storage_account_url: SAS URL for the storage account container which contains this
     backup.
    :vartype storage_account_url: str
    :ivar blob_name: Name of the blob which contains data for this backup.
    :vartype blob_name: str
    :ivar name_properties_name: Name of this backup.
    :vartype name_properties_name: str
    :ivar status: Backup status. Known values are: "InProgress", "Failed", "Succeeded", "TimedOut",
     "Created", "Skipped", "PartiallySucceeded", "DeleteInProgress", "DeleteFailed", and "Deleted".
    :vartype status: str or ~azure.mgmt.web.v2018_02_01.models.BackupItemStatus
    :ivar size_in_bytes: Size of the backup in bytes.
    :vartype size_in_bytes: int
    :ivar created: Timestamp of the backup creation.
    :vartype created: ~datetime.datetime
    :ivar log: Details regarding this backup. Might contain an error message.
    :vartype log: str
    :ivar databases: List of databases included in the backup.
    :vartype databases: list[~azure.mgmt.web.v2018_02_01.models.DatabaseBackupSetting]
    :ivar scheduled: True if this backup has been created due to a schedule being triggered.
    :vartype scheduled: bool
    :ivar last_restore_time_stamp: Timestamp of a last restore operation which used this backup.
    :vartype last_restore_time_stamp: ~datetime.datetime
    :ivar finished_time_stamp: Timestamp when this backup finished.
    :vartype finished_time_stamp: ~datetime.datetime
    :ivar correlation_id: Unique correlation identifier. Please use this along with the timestamp
     while communicating with Azure support.
    :vartype correlation_id: str
    :ivar website_size_in_bytes: Size of the original web app which has been backed up.
    :vartype website_size_in_bytes: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "backup_id": {"readonly": True},
        "storage_account_url": {"readonly": True},
        "blob_name": {"readonly": True},
        "name_properties_name": {"readonly": True},
        "status": {"readonly": True},
        "size_in_bytes": {"readonly": True},
        "created": {"readonly": True},
        "log": {"readonly": True},
        "databases": {"readonly": True},
        "scheduled": {"readonly": True},
        "last_restore_time_stamp": {"readonly": True},
        "finished_time_stamp": {"readonly": True},
        "correlation_id": {"readonly": True},
        "website_size_in_bytes": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "backup_id": {"key": "properties.id", "type": "int"},
        "storage_account_url": {"key": "properties.storageAccountUrl", "type": "str"},
        "blob_name": {"key": "properties.blobName", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "size_in_bytes": {"key": "properties.sizeInBytes", "type": "int"},
        "created": {"key": "properties.created", "type": "iso-8601"},
        "log": {"key": "properties.log", "type": "str"},
        "databases": {"key": "properties.databases", "type": "[DatabaseBackupSetting]"},
        "scheduled": {"key": "properties.scheduled", "type": "bool"},
        "last_restore_time_stamp": {"key": "properties.lastRestoreTimeStamp", "type": "iso-8601"},
        "finished_time_stamp": {"key": "properties.finishedTimeStamp", "type": "iso-8601"},
        "correlation_id": {"key": "properties.correlationId", "type": "str"},
        "website_size_in_bytes": {"key": "properties.websiteSizeInBytes", "type": "int"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.backup_id = None
        self.storage_account_url = None
        self.blob_name = None
        self.name_properties_name = None
        self.status = None
        self.size_in_bytes = None
        self.created = None
        self.log = None
        self.databases = None
        self.scheduled = None
        self.last_restore_time_stamp = None
        self.finished_time_stamp = None
        self.correlation_id = None
        self.website_size_in_bytes = None


class BackupItemCollection(_serialization.Model):
    """Collection of backup items.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.BackupItem]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BackupItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.BackupItem"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.BackupItem]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class BackupRequest(ProxyOnlyResource):
    """Description of a backup which will be performed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar backup_name: Name of the backup.
    :vartype backup_name: str
    :ivar enabled: True if the backup schedule is enabled (must be included in that case), false if
     the backup schedule should be disabled.
    :vartype enabled: bool
    :ivar storage_account_url: SAS URL to the container.
    :vartype storage_account_url: str
    :ivar backup_schedule: Schedule for the backup if it is executed periodically.
    :vartype backup_schedule: ~azure.mgmt.web.v2018_02_01.models.BackupSchedule
    :ivar databases: Databases included in the backup.
    :vartype databases: list[~azure.mgmt.web.v2018_02_01.models.DatabaseBackupSetting]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "backup_name": {"key": "properties.backupName", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "storage_account_url": {"key": "properties.storageAccountUrl", "type": "str"},
        "backup_schedule": {"key": "properties.backupSchedule", "type": "BackupSchedule"},
        "databases": {"key": "properties.databases", "type": "[DatabaseBackupSetting]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        backup_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        storage_account_url: Optional[str] = None,
        backup_schedule: Optional["_models.BackupSchedule"] = None,
        databases: Optional[List["_models.DatabaseBackupSetting"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword backup_name: Name of the backup.
        :paramtype backup_name: str
        :keyword enabled: True if the backup schedule is enabled (must be included in that case), false
         if the backup schedule should be disabled.
        :paramtype enabled: bool
        :keyword storage_account_url: SAS URL to the container.
        :paramtype storage_account_url: str
        :keyword backup_schedule: Schedule for the backup if it is executed periodically.
        :paramtype backup_schedule: ~azure.mgmt.web.v2018_02_01.models.BackupSchedule
        :keyword databases: Databases included in the backup.
        :paramtype databases: list[~azure.mgmt.web.v2018_02_01.models.DatabaseBackupSetting]
        """
        super().__init__(kind=kind, **kwargs)
        self.backup_name = backup_name
        self.enabled = enabled
        self.storage_account_url = storage_account_url
        self.backup_schedule = backup_schedule
        self.databases = databases


class BackupSchedule(_serialization.Model):
    """Description of a backup schedule. Describes how often should be the backup performed and what
    should be the retention policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar frequency_interval: How often the backup should be executed (e.g. for weekly backup, this
     should be set to 7 and FrequencyUnit should be set to Day).
    :vartype frequency_interval: int
    :ivar frequency_unit: The unit of time for how often the backup should be executed (e.g. for
     weekly backup, this should be set to Day and FrequencyInterval should be set to 7). Known
     values are: "Day" and "Hour".
    :vartype frequency_unit: str or ~azure.mgmt.web.v2018_02_01.models.FrequencyUnit
    :ivar keep_at_least_one_backup: True if the retention policy should always keep at least one
     backup in the storage account, regardless how old it is; false otherwise.
    :vartype keep_at_least_one_backup: bool
    :ivar retention_period_in_days: After how many days backups should be deleted.
    :vartype retention_period_in_days: int
    :ivar start_time: When the schedule should start working.
    :vartype start_time: ~datetime.datetime
    :ivar last_execution_time: Last time when this schedule was triggered.
    :vartype last_execution_time: ~datetime.datetime
    """

    _validation = {
        "frequency_interval": {"required": True},
        "frequency_unit": {"required": True},
        "keep_at_least_one_backup": {"required": True},
        "retention_period_in_days": {"required": True},
        "last_execution_time": {"readonly": True},
    }

    _attribute_map = {
        "frequency_interval": {"key": "frequencyInterval", "type": "int"},
        "frequency_unit": {"key": "frequencyUnit", "type": "str"},
        "keep_at_least_one_backup": {"key": "keepAtLeastOneBackup", "type": "bool"},
        "retention_period_in_days": {"key": "retentionPeriodInDays", "type": "int"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "last_execution_time": {"key": "lastExecutionTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        frequency_interval: int = 7,
        frequency_unit: Union[str, "_models.FrequencyUnit"] = "Day",
        keep_at_least_one_backup: bool = True,
        retention_period_in_days: int = 30,
        start_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword frequency_interval: How often the backup should be executed (e.g. for weekly backup,
         this should be set to 7 and FrequencyUnit should be set to Day).
        :paramtype frequency_interval: int
        :keyword frequency_unit: The unit of time for how often the backup should be executed (e.g. for
         weekly backup, this should be set to Day and FrequencyInterval should be set to 7). Known
         values are: "Day" and "Hour".
        :paramtype frequency_unit: str or ~azure.mgmt.web.v2018_02_01.models.FrequencyUnit
        :keyword keep_at_least_one_backup: True if the retention policy should always keep at least one
         backup in the storage account, regardless how old it is; false otherwise.
        :paramtype keep_at_least_one_backup: bool
        :keyword retention_period_in_days: After how many days backups should be deleted.
        :paramtype retention_period_in_days: int
        :keyword start_time: When the schedule should start working.
        :paramtype start_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.frequency_interval = frequency_interval
        self.frequency_unit = frequency_unit
        self.keep_at_least_one_backup = keep_at_least_one_backup
        self.retention_period_in_days = retention_period_in_days
        self.start_time = start_time
        self.last_execution_time = None


class BillingMeter(ProxyOnlyResource):
    """App Service billing entity that contains information about meter which the Azure billing system
    utilizes to charge users for services.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar meter_id: Meter GUID onboarded in Commerce.
    :vartype meter_id: str
    :ivar billing_location: Azure Location of billable resource.
    :vartype billing_location: str
    :ivar short_name: Short Name from App Service Azure pricing Page.
    :vartype short_name: str
    :ivar friendly_name: Friendly name of the meter.
    :vartype friendly_name: str
    :ivar resource_type: App Service ResourceType meter used for.
    :vartype resource_type: str
    :ivar os_type: App Service OS type meter used for.
    :vartype os_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "meter_id": {"key": "properties.meterId", "type": "str"},
        "billing_location": {"key": "properties.billingLocation", "type": "str"},
        "short_name": {"key": "properties.shortName", "type": "str"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "resource_type": {"key": "properties.resourceType", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        meter_id: Optional[str] = None,
        billing_location: Optional[str] = None,
        short_name: Optional[str] = None,
        friendly_name: Optional[str] = None,
        resource_type: Optional[str] = None,
        os_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword meter_id: Meter GUID onboarded in Commerce.
        :paramtype meter_id: str
        :keyword billing_location: Azure Location of billable resource.
        :paramtype billing_location: str
        :keyword short_name: Short Name from App Service Azure pricing Page.
        :paramtype short_name: str
        :keyword friendly_name: Friendly name of the meter.
        :paramtype friendly_name: str
        :keyword resource_type: App Service ResourceType meter used for.
        :paramtype resource_type: str
        :keyword os_type: App Service OS type meter used for.
        :paramtype os_type: str
        """
        super().__init__(kind=kind, **kwargs)
        self.meter_id = meter_id
        self.billing_location = billing_location
        self.short_name = short_name
        self.friendly_name = friendly_name
        self.resource_type = resource_type
        self.os_type = os_type


class BillingMeterCollection(_serialization.Model):
    """Collection of Billing Meters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.BillingMeter]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BillingMeter]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.BillingMeter"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.BillingMeter]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Capability(_serialization.Model):
    """Describes the capabilities/features allowed for a specific SKU.

    :ivar name: Name of the SKU capability.
    :vartype name: str
    :ivar value: Value of the SKU capability.
    :vartype value: str
    :ivar reason: Reason of the SKU capability.
    :vartype reason: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[str] = None, value: Optional[str] = None, reason: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the SKU capability.
        :paramtype name: str
        :keyword value: Value of the SKU capability.
        :paramtype value: str
        :keyword reason: Reason of the SKU capability.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.reason = reason


class Certificate(Resource):  # pylint: disable=too-many-instance-attributes
    """SSL certificate for an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :ivar host_names: Host names the certificate applies to.
    :vartype host_names: list[str]
    :ivar pfx_blob: Pfx blob.
    :vartype pfx_blob: bytes
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar password: Certificate password.
    :vartype password: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytes
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2018_02_01.models.HostingEnvironmentProfile
    :ivar key_vault_id: Key Vault Csm resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.v2018_02_01.models.KeyVaultSecretStatus
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "subject_name": {"readonly": True},
        "site_name": {"readonly": True},
        "self_link": {"readonly": True},
        "issuer": {"readonly": True},
        "issue_date": {"readonly": True},
        "expiration_date": {"readonly": True},
        "thumbprint": {"readonly": True},
        "valid": {"readonly": True},
        "cer_blob": {"readonly": True},
        "public_key_hash": {"readonly": True},
        "hosting_environment_profile": {"readonly": True},
        "key_vault_secret_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "subject_name": {"key": "properties.subjectName", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
        "pfx_blob": {"key": "properties.pfxBlob", "type": "bytearray"},
        "site_name": {"key": "properties.siteName", "type": "str"},
        "self_link": {"key": "properties.selfLink", "type": "str"},
        "issuer": {"key": "properties.issuer", "type": "str"},
        "issue_date": {"key": "properties.issueDate", "type": "iso-8601"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "password": {"key": "properties.password", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "valid": {"key": "properties.valid", "type": "bool"},
        "cer_blob": {"key": "properties.cerBlob", "type": "bytearray"},
        "public_key_hash": {"key": "properties.publicKeyHash", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "key_vault_secret_status": {"key": "properties.keyVaultSecretStatus", "type": "str"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        host_names: Optional[List[str]] = None,
        pfx_blob: Optional[bytes] = None,
        password: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        server_farm_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword host_names: Host names the certificate applies to.
        :paramtype host_names: list[str]
        :keyword pfx_blob: Pfx blob.
        :paramtype pfx_blob: bytes
        :keyword password: Certificate password.
        :paramtype password: str
        :keyword key_vault_id: Key Vault Csm resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.friendly_name = None
        self.subject_name = None
        self.host_names = host_names
        self.pfx_blob = pfx_blob
        self.site_name = None
        self.self_link = None
        self.issuer = None
        self.issue_date = None
        self.expiration_date = None
        self.password = password
        self.thumbprint = None
        self.valid = None
        self.cer_blob = None
        self.public_key_hash = None
        self.hosting_environment_profile = None
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.key_vault_secret_status = None
        self.server_farm_id = server_farm_id


class CertificateCollection(_serialization.Model):
    """Collection of certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.Certificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Certificate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Certificate"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.Certificate]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class CertificateDetails(_serialization.Model):
    """SSL certificate details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: Certificate Version.
    :vartype version: int
    :ivar serial_number: Certificate Serial Number.
    :vartype serial_number: str
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    :ivar subject: Certificate Subject.
    :vartype subject: str
    :ivar not_before: Date Certificate is valid from.
    :vartype not_before: ~datetime.datetime
    :ivar not_after: Date Certificate is valid to.
    :vartype not_after: ~datetime.datetime
    :ivar signature_algorithm: Certificate Signature algorithm.
    :vartype signature_algorithm: str
    :ivar issuer: Certificate Issuer.
    :vartype issuer: str
    :ivar raw_data: Raw certificate data.
    :vartype raw_data: str
    """

    _validation = {
        "version": {"readonly": True},
        "serial_number": {"readonly": True},
        "thumbprint": {"readonly": True},
        "subject": {"readonly": True},
        "not_before": {"readonly": True},
        "not_after": {"readonly": True},
        "signature_algorithm": {"readonly": True},
        "issuer": {"readonly": True},
        "raw_data": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "int"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "not_before": {"key": "notBefore", "type": "iso-8601"},
        "not_after": {"key": "notAfter", "type": "iso-8601"},
        "signature_algorithm": {"key": "signatureAlgorithm", "type": "str"},
        "issuer": {"key": "issuer", "type": "str"},
        "raw_data": {"key": "rawData", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.version = None
        self.serial_number = None
        self.thumbprint = None
        self.subject = None
        self.not_before = None
        self.not_after = None
        self.signature_algorithm = None
        self.issuer = None
        self.raw_data = None


class CertificateEmail(ProxyOnlyResource):
    """SSL certificate email.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar email_id: Email id.
    :vartype email_id: str
    :ivar time_stamp: Time stamp.
    :vartype time_stamp: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "email_id": {"key": "properties.emailId", "type": "str"},
        "time_stamp": {"key": "properties.timeStamp", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        email_id: Optional[str] = None,
        time_stamp: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword email_id: Email id.
        :paramtype email_id: str
        :keyword time_stamp: Time stamp.
        :paramtype time_stamp: ~datetime.datetime
        """
        super().__init__(kind=kind, **kwargs)
        self.email_id = email_id
        self.time_stamp = time_stamp


class CertificateOrderAction(ProxyOnlyResource):
    """Certificate order action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar action_type: Action type. Known values are: "CertificateIssued",
     "CertificateOrderCanceled", "CertificateOrderCreated", "CertificateRevoked",
     "DomainValidationComplete", "FraudDetected", "OrgNameChange", "OrgValidationComplete",
     "SanDrop", "FraudCleared", "CertificateExpired", "CertificateExpirationWarning",
     "FraudDocumentationRequired", and "Unknown".
    :vartype action_type: str or ~azure.mgmt.web.v2018_02_01.models.CertificateOrderActionType
    :ivar created_at: Time at which the certificate action was performed.
    :vartype created_at: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "action_type": {"readonly": True},
        "created_at": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "action_type": {"key": "properties.actionType", "type": "str"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.action_type = None
        self.created_at = None


class CertificatePatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :ivar host_names: Host names the certificate applies to.
    :vartype host_names: list[str]
    :ivar pfx_blob: Pfx blob.
    :vartype pfx_blob: bytes
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar password: Certificate password.
    :vartype password: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytes
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2018_02_01.models.HostingEnvironmentProfile
    :ivar key_vault_id: Key Vault Csm resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.v2018_02_01.models.KeyVaultSecretStatus
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "subject_name": {"readonly": True},
        "site_name": {"readonly": True},
        "self_link": {"readonly": True},
        "issuer": {"readonly": True},
        "issue_date": {"readonly": True},
        "expiration_date": {"readonly": True},
        "thumbprint": {"readonly": True},
        "valid": {"readonly": True},
        "cer_blob": {"readonly": True},
        "public_key_hash": {"readonly": True},
        "hosting_environment_profile": {"readonly": True},
        "key_vault_secret_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "subject_name": {"key": "properties.subjectName", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
        "pfx_blob": {"key": "properties.pfxBlob", "type": "bytearray"},
        "site_name": {"key": "properties.siteName", "type": "str"},
        "self_link": {"key": "properties.selfLink", "type": "str"},
        "issuer": {"key": "properties.issuer", "type": "str"},
        "issue_date": {"key": "properties.issueDate", "type": "iso-8601"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "password": {"key": "properties.password", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "valid": {"key": "properties.valid", "type": "bool"},
        "cer_blob": {"key": "properties.cerBlob", "type": "bytearray"},
        "public_key_hash": {"key": "properties.publicKeyHash", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "key_vault_secret_status": {"key": "properties.keyVaultSecretStatus", "type": "str"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        host_names: Optional[List[str]] = None,
        pfx_blob: Optional[bytes] = None,
        password: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        server_farm_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword host_names: Host names the certificate applies to.
        :paramtype host_names: list[str]
        :keyword pfx_blob: Pfx blob.
        :paramtype pfx_blob: bytes
        :keyword password: Certificate password.
        :paramtype password: str
        :keyword key_vault_id: Key Vault Csm resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        """
        super().__init__(kind=kind, **kwargs)
        self.friendly_name = None
        self.subject_name = None
        self.host_names = host_names
        self.pfx_blob = pfx_blob
        self.site_name = None
        self.self_link = None
        self.issuer = None
        self.issue_date = None
        self.expiration_date = None
        self.password = password
        self.thumbprint = None
        self.valid = None
        self.cer_blob = None
        self.public_key_hash = None
        self.hosting_environment_profile = None
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.key_vault_secret_status = None
        self.server_farm_id = server_farm_id


class CloningInfo(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Information needed for cloning operation.

    All required parameters must be populated in order to send to Azure.

    :ivar correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
     operations
     together to use the same snapshot.
    :vartype correlation_id: str
    :ivar overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
     :code:`<code>false</code>`.
    :vartype overwrite: bool
    :ivar clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from source
     app; otherwise, :code:`<code>false</code>`.
    :vartype clone_custom_host_names: bool
    :ivar clone_source_control: :code:`<code>true</code>` to clone source control from source app;
     otherwise, :code:`<code>false</code>`.
    :vartype clone_source_control: bool
    :ivar source_web_app_id: ARM resource ID of the source app. App resource ID is of the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots. Required.
    :vartype source_web_app_id: str
    :ivar source_web_app_location: Location of source app ex: West US or North Europe.
    :vartype source_web_app_location: str
    :ivar hosting_environment: App Service Environment.
    :vartype hosting_environment: str
    :ivar app_settings_overrides: Application setting overrides for cloned app. If specified, these
     settings override the settings cloned
     from source app. Otherwise, application settings from source app are retained.
    :vartype app_settings_overrides: dict[str, str]
    :ivar configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
     source and destination app.
    :vartype configure_load_balancing: bool
    :ivar traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if it
     exists. Traffic Manager resource ID is of the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
    :vartype traffic_manager_profile_id: str
    :ivar traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
     needed if Traffic Manager profile does not already exist.
    :vartype traffic_manager_profile_name: str
    """

    _validation = {
        "source_web_app_id": {"required": True},
    }

    _attribute_map = {
        "correlation_id": {"key": "correlationId", "type": "str"},
        "overwrite": {"key": "overwrite", "type": "bool"},
        "clone_custom_host_names": {"key": "cloneCustomHostNames", "type": "bool"},
        "clone_source_control": {"key": "cloneSourceControl", "type": "bool"},
        "source_web_app_id": {"key": "sourceWebAppId", "type": "str"},
        "source_web_app_location": {"key": "sourceWebAppLocation", "type": "str"},
        "hosting_environment": {"key": "hostingEnvironment", "type": "str"},
        "app_settings_overrides": {"key": "appSettingsOverrides", "type": "{str}"},
        "configure_load_balancing": {"key": "configureLoadBalancing", "type": "bool"},
        "traffic_manager_profile_id": {"key": "trafficManagerProfileId", "type": "str"},
        "traffic_manager_profile_name": {"key": "trafficManagerProfileName", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_web_app_id: str,
        correlation_id: Optional[str] = None,
        overwrite: Optional[bool] = None,
        clone_custom_host_names: Optional[bool] = None,
        clone_source_control: Optional[bool] = None,
        source_web_app_location: Optional[str] = None,
        hosting_environment: Optional[str] = None,
        app_settings_overrides: Optional[Dict[str, str]] = None,
        configure_load_balancing: Optional[bool] = None,
        traffic_manager_profile_id: Optional[str] = None,
        traffic_manager_profile_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
         operations
         together to use the same snapshot.
        :paramtype correlation_id: str
        :keyword overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
         :code:`<code>false</code>`.
        :paramtype overwrite: bool
        :keyword clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from
         source app; otherwise, :code:`<code>false</code>`.
        :paramtype clone_custom_host_names: bool
        :keyword clone_source_control: :code:`<code>true</code>` to clone source control from source
         app; otherwise, :code:`<code>false</code>`.
        :paramtype clone_source_control: bool
        :keyword source_web_app_id: ARM resource ID of the source app. App resource ID is of the form
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
         for production slots and
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
         for other slots. Required.
        :paramtype source_web_app_id: str
        :keyword source_web_app_location: Location of source app ex: West US or North Europe.
        :paramtype source_web_app_location: str
        :keyword hosting_environment: App Service Environment.
        :paramtype hosting_environment: str
        :keyword app_settings_overrides: Application setting overrides for cloned app. If specified,
         these settings override the settings cloned
         from source app. Otherwise, application settings from source app are retained.
        :paramtype app_settings_overrides: dict[str, str]
        :keyword configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
         source and destination app.
        :paramtype configure_load_balancing: bool
        :keyword traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if
         it exists. Traffic Manager resource ID is of the form
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
        :paramtype traffic_manager_profile_id: str
        :keyword traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
         needed if Traffic Manager profile does not already exist.
        :paramtype traffic_manager_profile_name: str
        """
        super().__init__(**kwargs)
        self.correlation_id = correlation_id
        self.overwrite = overwrite
        self.clone_custom_host_names = clone_custom_host_names
        self.clone_source_control = clone_source_control
        self.source_web_app_id = source_web_app_id
        self.source_web_app_location = source_web_app_location
        self.hosting_environment = hosting_environment
        self.app_settings_overrides = app_settings_overrides
        self.configure_load_balancing = configure_load_balancing
        self.traffic_manager_profile_id = traffic_manager_profile_id
        self.traffic_manager_profile_name = traffic_manager_profile_name


class Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties(
    _serialization.Model
):
    """Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: Principal Id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: Client Id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class ConnectionStringDictionary(ProxyOnlyResource):
    """String dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Connection strings.
    :vartype properties: dict[str, ~azure.mgmt.web.v2018_02_01.models.ConnStringValueTypePair]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "{ConnStringValueTypePair}"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        properties: Optional[Dict[str, "_models.ConnStringValueTypePair"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword properties: Connection strings.
        :paramtype properties: dict[str, ~azure.mgmt.web.v2018_02_01.models.ConnStringValueTypePair]
        """
        super().__init__(kind=kind, **kwargs)
        self.properties = properties


class ConnStringInfo(_serialization.Model):
    """Database connection string information.

    :ivar name: Name of connection string.
    :vartype name: str
    :ivar connection_string: Connection string value.
    :vartype connection_string: str
    :ivar type: Type of database. Known values are: "MySql", "SQLServer", "SQLAzure", "Custom",
     "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", and "PostgreSQL".
    :vartype type: str or ~azure.mgmt.web.v2018_02_01.models.ConnectionStringType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "connection_string": {"key": "connectionString", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        connection_string: Optional[str] = None,
        type: Optional[Union[str, "_models.ConnectionStringType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of connection string.
        :paramtype name: str
        :keyword connection_string: Connection string value.
        :paramtype connection_string: str
        :keyword type: Type of database. Known values are: "MySql", "SQLServer", "SQLAzure", "Custom",
         "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", and "PostgreSQL".
        :paramtype type: str or ~azure.mgmt.web.v2018_02_01.models.ConnectionStringType
        """
        super().__init__(**kwargs)
        self.name = name
        self.connection_string = connection_string
        self.type = type


class ConnStringValueTypePair(_serialization.Model):
    """Database connection string value to type pair.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Value of pair. Required.
    :vartype value: str
    :ivar type: Type of database. Required. Known values are: "MySql", "SQLServer", "SQLAzure",
     "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", and
     "PostgreSQL".
    :vartype type: str or ~azure.mgmt.web.v2018_02_01.models.ConnectionStringType
    """

    _validation = {
        "value": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, value: str, type: Union[str, "_models.ConnectionStringType"], **kwargs: Any) -> None:
        """
        :keyword value: Value of pair. Required.
        :paramtype value: str
        :keyword type: Type of database. Required. Known values are: "MySql", "SQLServer", "SQLAzure",
         "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", and
         "PostgreSQL".
        :paramtype type: str or ~azure.mgmt.web.v2018_02_01.models.ConnectionStringType
        """
        super().__init__(**kwargs)
        self.value = value
        self.type = type


class Contact(_serialization.Model):
    """Contact information for domain registration. If 'Domain Privacy' option is not selected then
    the contact information is made publicly available through the Whois
    directories as per ICANN requirements.

    All required parameters must be populated in order to send to Azure.

    :ivar address_mailing: Mailing address.
    :vartype address_mailing: ~azure.mgmt.web.v2018_02_01.models.Address
    :ivar email: Email address. Required.
    :vartype email: str
    :ivar fax: Fax number.
    :vartype fax: str
    :ivar job_title: Job title.
    :vartype job_title: str
    :ivar name_first: First name. Required.
    :vartype name_first: str
    :ivar name_last: Last name. Required.
    :vartype name_last: str
    :ivar name_middle: Middle name.
    :vartype name_middle: str
    :ivar organization: Organization contact belongs to.
    :vartype organization: str
    :ivar phone: Phone number. Required.
    :vartype phone: str
    """

    _validation = {
        "email": {"required": True},
        "name_first": {"required": True},
        "name_last": {"required": True},
        "phone": {"required": True},
    }

    _attribute_map = {
        "address_mailing": {"key": "addressMailing", "type": "Address"},
        "email": {"key": "email", "type": "str"},
        "fax": {"key": "fax", "type": "str"},
        "job_title": {"key": "jobTitle", "type": "str"},
        "name_first": {"key": "nameFirst", "type": "str"},
        "name_last": {"key": "nameLast", "type": "str"},
        "name_middle": {"key": "nameMiddle", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
    }

    def __init__(
        self,
        *,
        email: str,
        name_first: str,
        name_last: str,
        phone: str,
        address_mailing: Optional["_models.Address"] = None,
        fax: Optional[str] = None,
        job_title: Optional[str] = None,
        name_middle: Optional[str] = None,
        organization: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword address_mailing: Mailing address.
        :paramtype address_mailing: ~azure.mgmt.web.v2018_02_01.models.Address
        :keyword email: Email address. Required.
        :paramtype email: str
        :keyword fax: Fax number.
        :paramtype fax: str
        :keyword job_title: Job title.
        :paramtype job_title: str
        :keyword name_first: First name. Required.
        :paramtype name_first: str
        :keyword name_last: Last name. Required.
        :paramtype name_last: str
        :keyword name_middle: Middle name.
        :paramtype name_middle: str
        :keyword organization: Organization contact belongs to.
        :paramtype organization: str
        :keyword phone: Phone number. Required.
        :paramtype phone: str
        """
        super().__init__(**kwargs)
        self.address_mailing = address_mailing
        self.email = email
        self.fax = fax
        self.job_title = job_title
        self.name_first = name_first
        self.name_last = name_last
        self.name_middle = name_middle
        self.organization = organization
        self.phone = phone


class ContinuousWebJob(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Continuous Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar status: Job status. Known values are: "Initializing", "Starting", "Running",
     "PendingRestart", and "Stopped".
    :vartype status: str or ~azure.mgmt.web.v2018_02_01.models.ContinuousWebJobStatus
    :ivar detailed_status: Detailed status.
    :vartype detailed_status: str
    :ivar log_url: Log URL.
    :vartype log_url: str
    :ivar run_command: Run command.
    :vartype run_command: str
    :ivar url: Job URL.
    :vartype url: str
    :ivar extra_info_url: Extra Info URL.
    :vartype extra_info_url: str
    :ivar web_job_type: Job type. Known values are: "Continuous" and "Triggered".
    :vartype web_job_type: str or ~azure.mgmt.web.v2018_02_01.models.WebJobType
    :ivar error: Error information.
    :vartype error: str
    :ivar using_sdk: Using SDK?.
    :vartype using_sdk: bool
    :ivar settings: Job settings.
    :vartype settings: dict[str, JSON]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "detailed_status": {"key": "properties.detailed_status", "type": "str"},
        "log_url": {"key": "properties.log_url", "type": "str"},
        "run_command": {"key": "properties.run_command", "type": "str"},
        "url": {"key": "properties.url", "type": "str"},
        "extra_info_url": {"key": "properties.extra_info_url", "type": "str"},
        "web_job_type": {"key": "properties.web_job_type", "type": "str"},
        "error": {"key": "properties.error", "type": "str"},
        "using_sdk": {"key": "properties.using_sdk", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        status: Optional[Union[str, "_models.ContinuousWebJobStatus"]] = None,
        detailed_status: Optional[str] = None,
        log_url: Optional[str] = None,
        run_command: Optional[str] = None,
        url: Optional[str] = None,
        extra_info_url: Optional[str] = None,
        web_job_type: Optional[Union[str, "_models.WebJobType"]] = None,
        error: Optional[str] = None,
        using_sdk: Optional[bool] = None,
        settings: Optional[Dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword status: Job status. Known values are: "Initializing", "Starting", "Running",
         "PendingRestart", and "Stopped".
        :paramtype status: str or ~azure.mgmt.web.v2018_02_01.models.ContinuousWebJobStatus
        :keyword detailed_status: Detailed status.
        :paramtype detailed_status: str
        :keyword log_url: Log URL.
        :paramtype log_url: str
        :keyword run_command: Run command.
        :paramtype run_command: str
        :keyword url: Job URL.
        :paramtype url: str
        :keyword extra_info_url: Extra Info URL.
        :paramtype extra_info_url: str
        :keyword web_job_type: Job type. Known values are: "Continuous" and "Triggered".
        :paramtype web_job_type: str or ~azure.mgmt.web.v2018_02_01.models.WebJobType
        :keyword error: Error information.
        :paramtype error: str
        :keyword using_sdk: Using SDK?.
        :paramtype using_sdk: bool
        :keyword settings: Job settings.
        :paramtype settings: dict[str, JSON]
        """
        super().__init__(kind=kind, **kwargs)
        self.status = status
        self.detailed_status = detailed_status
        self.log_url = log_url
        self.run_command = run_command
        self.url = url
        self.extra_info_url = extra_info_url
        self.web_job_type = web_job_type
        self.error = error
        self.using_sdk = using_sdk
        self.settings = settings


class ContinuousWebJobCollection(_serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.ContinuousWebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ContinuousWebJob]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ContinuousWebJob"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.ContinuousWebJob]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class CorsSettings(_serialization.Model):
    """Cross-Origin Resource Sharing (CORS) settings for the app.

    :ivar allowed_origins: Gets or sets the list of origins that should be allowed to make
     cross-origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
    :vartype allowed_origins: list[str]
    :ivar support_credentials: Gets or sets whether CORS requests with credentials are allowed. See
     https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
     for more details.
    :vartype support_credentials: bool
    """

    _attribute_map = {
        "allowed_origins": {"key": "allowedOrigins", "type": "[str]"},
        "support_credentials": {"key": "supportCredentials", "type": "bool"},
    }

    def __init__(
        self, *, allowed_origins: Optional[List[str]] = None, support_credentials: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword allowed_origins: Gets or sets the list of origins that should be allowed to make
         cross-origin
         calls (for example: http://example.com:12345). Use "*" to allow all.
        :paramtype allowed_origins: list[str]
        :keyword support_credentials: Gets or sets whether CORS requests with credentials are allowed.
         See
         https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
         for more details.
        :paramtype support_credentials: bool
        """
        super().__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.support_credentials = support_credentials


class CsmMoveResourceEnvelope(_serialization.Model):
    """Object with a list of the resources that need to be moved and the resource group they should be
    moved to.

    :ivar target_resource_group:
    :vartype target_resource_group: str
    :ivar resources:
    :vartype resources: list[str]
    """

    _validation = {
        "target_resource_group": {"max_length": 90, "min_length": 1, "pattern": r" ^[-\w\._\(\)]+[^\.]$"},
    }

    _attribute_map = {
        "target_resource_group": {"key": "targetResourceGroup", "type": "str"},
        "resources": {"key": "resources", "type": "[str]"},
    }

    def __init__(
        self, *, target_resource_group: Optional[str] = None, resources: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword target_resource_group:
        :paramtype target_resource_group: str
        :keyword resources:
        :paramtype resources: list[str]
        """
        super().__init__(**kwargs)
        self.target_resource_group = target_resource_group
        self.resources = resources


class CsmOperationCollection(_serialization.Model):
    """Collection of Azure resource manager operation metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.CsmOperationDescription]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CsmOperationDescription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CsmOperationDescription"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.CsmOperationDescription]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class CsmOperationDescription(_serialization.Model):
    """Description of an operation available for Microsoft.Web resource provider.

    :ivar name:
    :vartype name: str
    :ivar display: Meta data about operation used for display in portal.
    :vartype display: ~azure.mgmt.web.v2018_02_01.models.CsmOperationDisplay
    :ivar origin:
    :vartype origin: str
    :ivar properties: Properties available for a Microsoft.Web resource provider operation.
    :vartype properties: ~azure.mgmt.web.v2018_02_01.models.CsmOperationDescriptionProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "CsmOperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "CsmOperationDescriptionProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.CsmOperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.CsmOperationDescriptionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display: Meta data about operation used for display in portal.
        :paramtype display: ~azure.mgmt.web.v2018_02_01.models.CsmOperationDisplay
        :keyword origin:
        :paramtype origin: str
        :keyword properties: Properties available for a Microsoft.Web resource provider operation.
        :paramtype properties: ~azure.mgmt.web.v2018_02_01.models.CsmOperationDescriptionProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class CsmOperationDescriptionProperties(_serialization.Model):
    """Properties available for a Microsoft.Web resource provider operation.

    :ivar service_specification: Resource metrics service provided by Microsoft.Insights resource
     provider.
    :vartype service_specification: ~azure.mgmt.web.v2018_02_01.models.ServiceSpecification
    """

    _attribute_map = {
        "service_specification": {"key": "serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self, *, service_specification: Optional["_models.ServiceSpecification"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword service_specification: Resource metrics service provided by Microsoft.Insights
         resource provider.
        :paramtype service_specification: ~azure.mgmt.web.v2018_02_01.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.service_specification = service_specification


class CsmOperationDisplay(_serialization.Model):
    """Meta data about operation used for display in portal.

    :ivar provider:
    :vartype provider: str
    :ivar resource:
    :vartype resource: str
    :ivar operation:
    :vartype operation: str
    :ivar description:
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider:
        :paramtype provider: str
        :keyword resource:
        :paramtype resource: str
        :keyword operation:
        :paramtype operation: str
        :keyword description:
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class CsmPublishingProfileOptions(_serialization.Model):
    """Publishing options for requested profile.

    :ivar format: Name of the format. Valid values are:
     FileZilla3
     WebDeploy -- default
     Ftp. Known values are: "FileZilla3", "WebDeploy", and "Ftp".
    :vartype format: str or ~azure.mgmt.web.v2018_02_01.models.PublishingProfileFormat
    :ivar include_disaster_recovery_endpoints: Include the DisasterRecover endpoint if true.
    :vartype include_disaster_recovery_endpoints: bool
    """

    _attribute_map = {
        "format": {"key": "format", "type": "str"},
        "include_disaster_recovery_endpoints": {"key": "includeDisasterRecoveryEndpoints", "type": "bool"},
    }

    def __init__(
        self,
        *,
        format: Optional[Union[str, "_models.PublishingProfileFormat"]] = None,
        include_disaster_recovery_endpoints: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword format: Name of the format. Valid values are:
         FileZilla3
         WebDeploy -- default
         Ftp. Known values are: "FileZilla3", "WebDeploy", and "Ftp".
        :paramtype format: str or ~azure.mgmt.web.v2018_02_01.models.PublishingProfileFormat
        :keyword include_disaster_recovery_endpoints: Include the DisasterRecover endpoint if true.
        :paramtype include_disaster_recovery_endpoints: bool
        """
        super().__init__(**kwargs)
        self.format = format
        self.include_disaster_recovery_endpoints = include_disaster_recovery_endpoints


class CsmSlotEntity(_serialization.Model):
    """Deployment slot parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar target_slot: Destination deployment slot during swap operation. Required.
    :vartype target_slot: str
    :ivar preserve_vnet: :code:`<code>true</code>` to preserve Virtual Network to the slot during
     swap; otherwise, :code:`<code>false</code>`. Required.
    :vartype preserve_vnet: bool
    """

    _validation = {
        "target_slot": {"required": True},
        "preserve_vnet": {"required": True},
    }

    _attribute_map = {
        "target_slot": {"key": "targetSlot", "type": "str"},
        "preserve_vnet": {"key": "preserveVnet", "type": "bool"},
    }

    def __init__(self, *, target_slot: str, preserve_vnet: bool, **kwargs: Any) -> None:
        """
        :keyword target_slot: Destination deployment slot during swap operation. Required.
        :paramtype target_slot: str
        :keyword preserve_vnet: :code:`<code>true</code>` to preserve Virtual Network to the slot
         during swap; otherwise, :code:`<code>false</code>`. Required.
        :paramtype preserve_vnet: bool
        """
        super().__init__(**kwargs)
        self.target_slot = target_slot
        self.preserve_vnet = preserve_vnet


class CsmUsageQuota(_serialization.Model):
    """Usage of the quota resource.

    :ivar unit: Units of measurement for the quota resource.
    :vartype unit: str
    :ivar next_reset_time: Next reset time for the resource counter.
    :vartype next_reset_time: ~datetime.datetime
    :ivar current_value: The current value of the resource counter.
    :vartype current_value: int
    :ivar limit: The resource limit.
    :vartype limit: int
    :ivar name: Quota name.
    :vartype name: ~azure.mgmt.web.v2018_02_01.models.LocalizableString
    """

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "next_reset_time": {"key": "nextResetTime", "type": "iso-8601"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "LocalizableString"},
    }

    def __init__(
        self,
        *,
        unit: Optional[str] = None,
        next_reset_time: Optional[datetime.datetime] = None,
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        name: Optional["_models.LocalizableString"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unit: Units of measurement for the quota resource.
        :paramtype unit: str
        :keyword next_reset_time: Next reset time for the resource counter.
        :paramtype next_reset_time: ~datetime.datetime
        :keyword current_value: The current value of the resource counter.
        :paramtype current_value: int
        :keyword limit: The resource limit.
        :paramtype limit: int
        :keyword name: Quota name.
        :paramtype name: ~azure.mgmt.web.v2018_02_01.models.LocalizableString
        """
        super().__init__(**kwargs)
        self.unit = unit
        self.next_reset_time = next_reset_time
        self.current_value = current_value
        self.limit = limit
        self.name = name


class CsmUsageQuotaCollection(_serialization.Model):
    """Collection of CSM usage quotas.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.CsmUsageQuota]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CsmUsageQuota]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CsmUsageQuota"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.CsmUsageQuota]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class CustomHostnameAnalysisResult(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Custom domain analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_hostname_already_verified: :code:`<code>true</code>` if hostname is already verified;
     otherwise, :code:`<code>false</code>`.
    :vartype is_hostname_already_verified: bool
    :ivar custom_domain_verification_test: DNS verification test result. Known values are:
     "Passed", "Failed", and "Skipped".
    :vartype custom_domain_verification_test: str or
     ~azure.mgmt.web.v2018_02_01.models.DnsVerificationTestResult
    :ivar custom_domain_verification_failure_info: Raw failure information if DNS verification
     fails.
    :vartype custom_domain_verification_failure_info:
     ~azure.mgmt.web.v2018_02_01.models.ErrorEntity
    :ivar has_conflict_on_scale_unit: :code:`<code>true</code>` if there is a conflict on a scale
     unit; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_on_scale_unit: bool
    :ivar has_conflict_across_subscription: :code:`<code>true</code>` if there is a conflict across
     subscriptions; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_across_subscription: bool
    :ivar conflicting_app_resource_id: Name of the conflicting app on scale unit if it's within the
     same subscription.
    :vartype conflicting_app_resource_id: str
    :ivar c_name_records: CName records controller can see for this hostname.
    :vartype c_name_records: list[str]
    :ivar txt_records: TXT records controller can see for this hostname.
    :vartype txt_records: list[str]
    :ivar a_records: A records controller can see for this hostname.
    :vartype a_records: list[str]
    :ivar alternate_c_name_records: Alternate CName records controller can see for this hostname.
    :vartype alternate_c_name_records: list[str]
    :ivar alternate_txt_records: Alternate TXT records controller can see for this hostname.
    :vartype alternate_txt_records: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "is_hostname_already_verified": {"readonly": True},
        "custom_domain_verification_test": {"readonly": True},
        "custom_domain_verification_failure_info": {"readonly": True},
        "has_conflict_on_scale_unit": {"readonly": True},
        "has_conflict_across_subscription": {"readonly": True},
        "conflicting_app_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_hostname_already_verified": {"key": "properties.isHostnameAlreadyVerified", "type": "bool"},
        "custom_domain_verification_test": {"key": "properties.customDomainVerificationTest", "type": "str"},
        "custom_domain_verification_failure_info": {
            "key": "properties.customDomainVerificationFailureInfo",
            "type": "ErrorEntity",
        },
        "has_conflict_on_scale_unit": {"key": "properties.hasConflictOnScaleUnit", "type": "bool"},
        "has_conflict_across_subscription": {"key": "properties.hasConflictAcrossSubscription", "type": "bool"},
        "conflicting_app_resource_id": {"key": "properties.conflictingAppResourceId", "type": "str"},
        "c_name_records": {"key": "properties.cNameRecords", "type": "[str]"},
        "txt_records": {"key": "properties.txtRecords", "type": "[str]"},
        "a_records": {"key": "properties.aRecords", "type": "[str]"},
        "alternate_c_name_records": {"key": "properties.alternateCNameRecords", "type": "[str]"},
        "alternate_txt_records": {"key": "properties.alternateTxtRecords", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        c_name_records: Optional[List[str]] = None,
        txt_records: Optional[List[str]] = None,
        a_records: Optional[List[str]] = None,
        alternate_c_name_records: Optional[List[str]] = None,
        alternate_txt_records: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword c_name_records: CName records controller can see for this hostname.
        :paramtype c_name_records: list[str]
        :keyword txt_records: TXT records controller can see for this hostname.
        :paramtype txt_records: list[str]
        :keyword a_records: A records controller can see for this hostname.
        :paramtype a_records: list[str]
        :keyword alternate_c_name_records: Alternate CName records controller can see for this
         hostname.
        :paramtype alternate_c_name_records: list[str]
        :keyword alternate_txt_records: Alternate TXT records controller can see for this hostname.
        :paramtype alternate_txt_records: list[str]
        """
        super().__init__(kind=kind, **kwargs)
        self.is_hostname_already_verified = None
        self.custom_domain_verification_test = None
        self.custom_domain_verification_failure_info = None
        self.has_conflict_on_scale_unit = None
        self.has_conflict_across_subscription = None
        self.conflicting_app_resource_id = None
        self.c_name_records = c_name_records
        self.txt_records = txt_records
        self.a_records = a_records
        self.alternate_c_name_records = alternate_c_name_records
        self.alternate_txt_records = alternate_txt_records


class DatabaseBackupSetting(_serialization.Model):
    """Database backup settings.

    All required parameters must be populated in order to send to Azure.

    :ivar database_type: Database type (e.g. SqlAzure / MySql). Required. Known values are:
     "SqlAzure", "MySql", "LocalMySql", and "PostgreSql".
    :vartype database_type: str or ~azure.mgmt.web.v2018_02_01.models.DatabaseType
    :ivar name:
    :vartype name: str
    :ivar connection_string_name: Contains a connection string name that is linked to the
     SiteConfig.ConnectionStrings.
     This is used during restore with overwrite connection strings options.
    :vartype connection_string_name: str
    :ivar connection_string: Contains a connection string to a database which is being backed up or
     restored. If the restore should happen to a new database, the database name inside is the new
     one.
    :vartype connection_string: str
    """

    _validation = {
        "database_type": {"required": True},
    }

    _attribute_map = {
        "database_type": {"key": "databaseType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "connection_string_name": {"key": "connectionStringName", "type": "str"},
        "connection_string": {"key": "connectionString", "type": "str"},
    }

    def __init__(
        self,
        *,
        database_type: Union[str, "_models.DatabaseType"],
        name: Optional[str] = None,
        connection_string_name: Optional[str] = None,
        connection_string: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword database_type: Database type (e.g. SqlAzure / MySql). Required. Known values are:
         "SqlAzure", "MySql", "LocalMySql", and "PostgreSql".
        :paramtype database_type: str or ~azure.mgmt.web.v2018_02_01.models.DatabaseType
        :keyword name:
        :paramtype name: str
        :keyword connection_string_name: Contains a connection string name that is linked to the
         SiteConfig.ConnectionStrings.
         This is used during restore with overwrite connection strings options.
        :paramtype connection_string_name: str
        :keyword connection_string: Contains a connection string to a database which is being backed up
         or restored. If the restore should happen to a new database, the database name inside is the
         new one.
        :paramtype connection_string: str
        """
        super().__init__(**kwargs)
        self.database_type = database_type
        self.name = name
        self.connection_string_name = connection_string_name
        self.connection_string = connection_string


class DataSource(_serialization.Model):
    """Class representing data source used by the detectors.

    :ivar instructions: Instructions if any for the data source.
    :vartype instructions: list[str]
    :ivar data_source_uri: Datasource Uri Links.
    :vartype data_source_uri: list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]
    """

    _attribute_map = {
        "instructions": {"key": "instructions", "type": "[str]"},
        "data_source_uri": {"key": "dataSourceUri", "type": "[NameValuePair]"},
    }

    def __init__(
        self,
        *,
        instructions: Optional[List[str]] = None,
        data_source_uri: Optional[List["_models.NameValuePair"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword instructions: Instructions if any for the data source.
        :paramtype instructions: list[str]
        :keyword data_source_uri: Datasource Uri Links.
        :paramtype data_source_uri: list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]
        """
        super().__init__(**kwargs)
        self.instructions = instructions
        self.data_source_uri = data_source_uri


class DataTableResponseColumn(_serialization.Model):
    """Column definition.

    :ivar column_name: Name of the column.
    :vartype column_name: str
    :ivar data_type: Data type which looks like 'String' or 'Int32'.
    :vartype data_type: str
    :ivar column_type: Column Type.
    :vartype column_type: str
    """

    _attribute_map = {
        "column_name": {"key": "columnName", "type": "str"},
        "data_type": {"key": "dataType", "type": "str"},
        "column_type": {"key": "columnType", "type": "str"},
    }

    def __init__(
        self,
        *,
        column_name: Optional[str] = None,
        data_type: Optional[str] = None,
        column_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword column_name: Name of the column.
        :paramtype column_name: str
        :keyword data_type: Data type which looks like 'String' or 'Int32'.
        :paramtype data_type: str
        :keyword column_type: Column Type.
        :paramtype column_type: str
        """
        super().__init__(**kwargs)
        self.column_name = column_name
        self.data_type = data_type
        self.column_type = column_type


class DataTableResponseObject(_serialization.Model):
    """Data Table which defines columns and raw row values.

    :ivar table_name: Name of the table.
    :vartype table_name: str
    :ivar columns: List of columns with data types.
    :vartype columns: list[~azure.mgmt.web.v2018_02_01.models.DataTableResponseColumn]
    :ivar rows: Raw row values.
    :vartype rows: list[list[str]]
    """

    _attribute_map = {
        "table_name": {"key": "tableName", "type": "str"},
        "columns": {"key": "columns", "type": "[DataTableResponseColumn]"},
        "rows": {"key": "rows", "type": "[[str]]"},
    }

    def __init__(
        self,
        *,
        table_name: Optional[str] = None,
        columns: Optional[List["_models.DataTableResponseColumn"]] = None,
        rows: Optional[List[List[str]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword table_name: Name of the table.
        :paramtype table_name: str
        :keyword columns: List of columns with data types.
        :paramtype columns: list[~azure.mgmt.web.v2018_02_01.models.DataTableResponseColumn]
        :keyword rows: Raw row values.
        :paramtype rows: list[list[str]]
        """
        super().__init__(**kwargs)
        self.table_name = table_name
        self.columns = columns
        self.rows = rows


class DefaultErrorResponse(_serialization.Model):
    """App Service error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error model.
    :vartype error: ~azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseError
    """

    _validation = {
        "error": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "DefaultErrorResponseError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error = None


class DefaultErrorResponseError(_serialization.Model):
    """Error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    :ivar details:
    :vartype details: list[~azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseErrorDetailsItem]
    :ivar innererror: More information to debug error.
    :vartype innererror: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "innererror": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[DefaultErrorResponseErrorDetailsItem]"},
        "innererror": {"key": "innererror", "type": "str"},
    }

    def __init__(
        self, *, details: Optional[List["_models.DefaultErrorResponseErrorDetailsItem"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword details:
        :paramtype details:
         list[~azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseErrorDetailsItem]
        """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = details
        self.innererror = None


class DefaultErrorResponseErrorDetailsItem(_serialization.Model):
    """Detailed errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None


class DeletedAppRestoreRequest(ProxyOnlyResource):
    """Details about restoring a deleted app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deleted_site_id: ARM resource ID of the deleted app. Example:
     /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}.
    :vartype deleted_site_id: str
    :ivar recover_configuration: If true, deleted site configuration, in addition to content, will
     be restored.
    :vartype recover_configuration: bool
    :ivar snapshot_time: Point in time to restore the deleted app from, formatted as a DateTime
     string.
     If unspecified, default value is the time that the app was deleted.
    :vartype snapshot_time: str
    :ivar use_dr_secondary: If true, the snapshot is retrieved from DRSecondary endpoint.
    :vartype use_dr_secondary: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "deleted_site_id": {"key": "properties.deletedSiteId", "type": "str"},
        "recover_configuration": {"key": "properties.recoverConfiguration", "type": "bool"},
        "snapshot_time": {"key": "properties.snapshotTime", "type": "str"},
        "use_dr_secondary": {"key": "properties.useDRSecondary", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        deleted_site_id: Optional[str] = None,
        recover_configuration: Optional[bool] = None,
        snapshot_time: Optional[str] = None,
        use_dr_secondary: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword deleted_site_id: ARM resource ID of the deleted app. Example:
         /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}.
        :paramtype deleted_site_id: str
        :keyword recover_configuration: If true, deleted site configuration, in addition to content,
         will be restored.
        :paramtype recover_configuration: bool
        :keyword snapshot_time: Point in time to restore the deleted app from, formatted as a DateTime
         string.
         If unspecified, default value is the time that the app was deleted.
        :paramtype snapshot_time: str
        :keyword use_dr_secondary: If true, the snapshot is retrieved from DRSecondary endpoint.
        :paramtype use_dr_secondary: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.deleted_site_id = deleted_site_id
        self.recover_configuration = recover_configuration
        self.snapshot_time = snapshot_time
        self.use_dr_secondary = use_dr_secondary


class DeletedSite(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """A deleted app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deleted_site_id: Numeric id for the deleted site.
    :vartype deleted_site_id: int
    :ivar deleted_timestamp: Time in UTC when the app was deleted.
    :vartype deleted_timestamp: str
    :ivar subscription: Subscription containing the deleted site.
    :vartype subscription: str
    :ivar resource_group: ResourceGroup that contained the deleted site.
    :vartype resource_group: str
    :ivar deleted_site_name: Name of the deleted site.
    :vartype deleted_site_name: str
    :ivar slot: Slot of the deleted site.
    :vartype slot: str
    :ivar kind_properties_kind: Kind of site that was deleted.
    :vartype kind_properties_kind: str
    :ivar geo_region_name: Geo Region of the deleted site.
    :vartype geo_region_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "deleted_site_id": {"readonly": True},
        "deleted_timestamp": {"readonly": True},
        "subscription": {"readonly": True},
        "resource_group": {"readonly": True},
        "deleted_site_name": {"readonly": True},
        "slot": {"readonly": True},
        "kind_properties_kind": {"readonly": True},
        "geo_region_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "deleted_site_id": {"key": "properties.deletedSiteId", "type": "int"},
        "deleted_timestamp": {"key": "properties.deletedTimestamp", "type": "str"},
        "subscription": {"key": "properties.subscription", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "deleted_site_name": {"key": "properties.deletedSiteName", "type": "str"},
        "slot": {"key": "properties.slot", "type": "str"},
        "kind_properties_kind": {"key": "properties.kind", "type": "str"},
        "geo_region_name": {"key": "properties.geoRegionName", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.deleted_site_id = None
        self.deleted_timestamp = None
        self.subscription = None
        self.resource_group = None
        self.deleted_site_name = None
        self.slot = None
        self.kind_properties_kind = None
        self.geo_region_name = None


class DeletedWebAppCollection(_serialization.Model):
    """Collection of deleted apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.DeletedSite]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedSite]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DeletedSite"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.DeletedSite]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Deployment(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar status: Deployment status.
    :vartype status: int
    :ivar message: Details about deployment status.
    :vartype message: str
    :ivar author: Who authored the deployment.
    :vartype author: str
    :ivar deployer: Who performed the deployment.
    :vartype deployer: str
    :ivar author_email: Author email.
    :vartype author_email: str
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time.
    :vartype end_time: ~datetime.datetime
    :ivar active: True if deployment is currently active, false if completed and null if not
     started.
    :vartype active: bool
    :ivar details: Details on deployment.
    :vartype details: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "status": {"key": "properties.status", "type": "int"},
        "message": {"key": "properties.message", "type": "str"},
        "author": {"key": "properties.author", "type": "str"},
        "deployer": {"key": "properties.deployer", "type": "str"},
        "author_email": {"key": "properties.author_email", "type": "str"},
        "start_time": {"key": "properties.start_time", "type": "iso-8601"},
        "end_time": {"key": "properties.end_time", "type": "iso-8601"},
        "active": {"key": "properties.active", "type": "bool"},
        "details": {"key": "properties.details", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        status: Optional[int] = None,
        message: Optional[str] = None,
        author: Optional[str] = None,
        deployer: Optional[str] = None,
        author_email: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        active: Optional[bool] = None,
        details: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword status: Deployment status.
        :paramtype status: int
        :keyword message: Details about deployment status.
        :paramtype message: str
        :keyword author: Who authored the deployment.
        :paramtype author: str
        :keyword deployer: Who performed the deployment.
        :paramtype deployer: str
        :keyword author_email: Author email.
        :paramtype author_email: str
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time.
        :paramtype end_time: ~datetime.datetime
        :keyword active: True if deployment is currently active, false if completed and null if not
         started.
        :paramtype active: bool
        :keyword details: Details on deployment.
        :paramtype details: str
        """
        super().__init__(kind=kind, **kwargs)
        self.status = status
        self.message = message
        self.author = author
        self.deployer = deployer
        self.author_email = author_email
        self.start_time = start_time
        self.end_time = end_time
        self.active = active
        self.details = details


class DeploymentCollection(_serialization.Model):
    """Collection of app deployments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.Deployment]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Deployment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Deployment"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.Deployment]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DeploymentLocations(_serialization.Model):
    """List of available locations (regions or App Service Environments) for
    deployment of App Service resources.

    :ivar locations: Available regions.
    :vartype locations: list[~azure.mgmt.web.v2018_02_01.models.GeoRegion]
    :ivar hosting_environments: Available App Service Environments with full descriptions of the
     environments.
    :vartype hosting_environments: list[~azure.mgmt.web.v2018_02_01.models.AppServiceEnvironment]
    :ivar hosting_environment_deployment_infos: Available App Service Environments with basic
     information.
    :vartype hosting_environment_deployment_infos:
     list[~azure.mgmt.web.v2018_02_01.models.HostingEnvironmentDeploymentInfo]
    """

    _attribute_map = {
        "locations": {"key": "locations", "type": "[GeoRegion]"},
        "hosting_environments": {"key": "hostingEnvironments", "type": "[AppServiceEnvironment]"},
        "hosting_environment_deployment_infos": {
            "key": "hostingEnvironmentDeploymentInfos",
            "type": "[HostingEnvironmentDeploymentInfo]",
        },
    }

    def __init__(
        self,
        *,
        locations: Optional[List["_models.GeoRegion"]] = None,
        hosting_environments: Optional[List["_models.AppServiceEnvironment"]] = None,
        hosting_environment_deployment_infos: Optional[List["_models.HostingEnvironmentDeploymentInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword locations: Available regions.
        :paramtype locations: list[~azure.mgmt.web.v2018_02_01.models.GeoRegion]
        :keyword hosting_environments: Available App Service Environments with full descriptions of the
         environments.
        :paramtype hosting_environments: list[~azure.mgmt.web.v2018_02_01.models.AppServiceEnvironment]
        :keyword hosting_environment_deployment_infos: Available App Service Environments with basic
         information.
        :paramtype hosting_environment_deployment_infos:
         list[~azure.mgmt.web.v2018_02_01.models.HostingEnvironmentDeploymentInfo]
        """
        super().__init__(**kwargs)
        self.locations = locations
        self.hosting_environments = hosting_environments
        self.hosting_environment_deployment_infos = hosting_environment_deployment_infos


class DetectorAbnormalTimePeriod(_serialization.Model):
    """Class representing Abnormal Time Period detected.

    :ivar start_time: Start time of the correlated event.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the correlated event.
    :vartype end_time: ~datetime.datetime
    :ivar message: Message describing the event.
    :vartype message: str
    :ivar source: Represents the name of the Detector.
    :vartype source: str
    :ivar priority: Represents the rank of the Detector.
    :vartype priority: float
    :ivar meta_data: Downtime metadata.
    :vartype meta_data: list[list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]]
    :ivar type: Represents the type of the Detector. Known values are: "ServiceIncident",
     "AppDeployment", "AppCrash", "RuntimeIssueDetected", "AseDeployment", "UserIssue",
     "PlatformIssue", and "Other".
    :vartype type: str or ~azure.mgmt.web.v2018_02_01.models.IssueType
    :ivar solutions: List of proposed solutions.
    :vartype solutions: list[~azure.mgmt.web.v2018_02_01.models.Solution]
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "source": {"key": "source", "type": "str"},
        "priority": {"key": "priority", "type": "float"},
        "meta_data": {"key": "metaData", "type": "[[NameValuePair]]"},
        "type": {"key": "type", "type": "str"},
        "solutions": {"key": "solutions", "type": "[Solution]"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        source: Optional[str] = None,
        priority: Optional[float] = None,
        meta_data: Optional[List[List["_models.NameValuePair"]]] = None,
        type: Optional[Union[str, "_models.IssueType"]] = None,
        solutions: Optional[List["_models.Solution"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: Start time of the correlated event.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the correlated event.
        :paramtype end_time: ~datetime.datetime
        :keyword message: Message describing the event.
        :paramtype message: str
        :keyword source: Represents the name of the Detector.
        :paramtype source: str
        :keyword priority: Represents the rank of the Detector.
        :paramtype priority: float
        :keyword meta_data: Downtime metadata.
        :paramtype meta_data: list[list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]]
        :keyword type: Represents the type of the Detector. Known values are: "ServiceIncident",
         "AppDeployment", "AppCrash", "RuntimeIssueDetected", "AseDeployment", "UserIssue",
         "PlatformIssue", and "Other".
        :paramtype type: str or ~azure.mgmt.web.v2018_02_01.models.IssueType
        :keyword solutions: List of proposed solutions.
        :paramtype solutions: list[~azure.mgmt.web.v2018_02_01.models.Solution]
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.message = message
        self.source = source
        self.priority = priority
        self.meta_data = meta_data
        self.type = type
        self.solutions = solutions


class DetectorDefinition(ProxyOnlyResource):
    """Class representing detector definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Display name of the detector.
    :vartype display_name: str
    :ivar description: Description of the detector.
    :vartype description: str
    :ivar rank: Detector Rank.
    :vartype rank: float
    :ivar is_enabled: Flag representing whether detector is enabled or not.
    :vartype is_enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "rank": {"readonly": True},
        "is_enabled": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "rank": {"key": "properties.rank", "type": "float"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.display_name = None
        self.description = None
        self.rank = None
        self.is_enabled = None


class DetectorInfo(_serialization.Model):
    """Definition of Detector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Short description of the detector and its purpose.
    :vartype description: str
    :ivar category: Support Category.
    :vartype category: str
    :ivar sub_category: Support Sub Category.
    :vartype sub_category: str
    :ivar support_topic_id: Support Topic Id.
    :vartype support_topic_id: str
    """

    _validation = {
        "description": {"readonly": True},
        "category": {"readonly": True},
        "sub_category": {"readonly": True},
        "support_topic_id": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "sub_category": {"key": "subCategory", "type": "str"},
        "support_topic_id": {"key": "supportTopicId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.description = None
        self.category = None
        self.sub_category = None
        self.support_topic_id = None


class DetectorResponse(ProxyOnlyResource):
    """Class representing Response from Detector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar metadata: metadata for the detector.
    :vartype metadata: ~azure.mgmt.web.v2018_02_01.models.DetectorInfo
    :ivar dataset: Data Set.
    :vartype dataset: list[~azure.mgmt.web.v2018_02_01.models.DiagnosticData]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "DetectorInfo"},
        "dataset": {"key": "properties.dataset", "type": "[DiagnosticData]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        metadata: Optional["_models.DetectorInfo"] = None,
        dataset: Optional[List["_models.DiagnosticData"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword metadata: metadata for the detector.
        :paramtype metadata: ~azure.mgmt.web.v2018_02_01.models.DetectorInfo
        :keyword dataset: Data Set.
        :paramtype dataset: list[~azure.mgmt.web.v2018_02_01.models.DiagnosticData]
        """
        super().__init__(kind=kind, **kwargs)
        self.metadata = metadata
        self.dataset = dataset


class DetectorResponseCollection(_serialization.Model):
    """Collection of detector responses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.DetectorResponse]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DetectorResponse]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DetectorResponse"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.DetectorResponse]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticAnalysis(ProxyOnlyResource):
    """Class representing a diagnostic analysis done on an application.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar abnormal_time_periods: List of time periods.
    :vartype abnormal_time_periods: list[~azure.mgmt.web.v2018_02_01.models.AbnormalTimePeriod]
    :ivar payload: Data by each detector.
    :vartype payload: list[~azure.mgmt.web.v2018_02_01.models.AnalysisData]
    :ivar non_correlated_detectors: Data by each detector for detectors that did not corelate.
    :vartype non_correlated_detectors: list[~azure.mgmt.web.v2018_02_01.models.DetectorDefinition]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
        "abnormal_time_periods": {"key": "properties.abnormalTimePeriods", "type": "[AbnormalTimePeriod]"},
        "payload": {"key": "properties.payload", "type": "[AnalysisData]"},
        "non_correlated_detectors": {"key": "properties.nonCorrelatedDetectors", "type": "[DetectorDefinition]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        abnormal_time_periods: Optional[List["_models.AbnormalTimePeriod"]] = None,
        payload: Optional[List["_models.AnalysisData"]] = None,
        non_correlated_detectors: Optional[List["_models.DetectorDefinition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword abnormal_time_periods: List of time periods.
        :paramtype abnormal_time_periods: list[~azure.mgmt.web.v2018_02_01.models.AbnormalTimePeriod]
        :keyword payload: Data by each detector.
        :paramtype payload: list[~azure.mgmt.web.v2018_02_01.models.AnalysisData]
        :keyword non_correlated_detectors: Data by each detector for detectors that did not corelate.
        :paramtype non_correlated_detectors:
         list[~azure.mgmt.web.v2018_02_01.models.DetectorDefinition]
        """
        super().__init__(kind=kind, **kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.abnormal_time_periods = abnormal_time_periods
        self.payload = payload
        self.non_correlated_detectors = non_correlated_detectors


class DiagnosticAnalysisCollection(_serialization.Model):
    """Collection of Diagnostic Analyses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.AnalysisDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AnalysisDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AnalysisDefinition"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.AnalysisDefinition]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticCategory(ProxyOnlyResource):
    """Class representing detector definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Description of the diagnostic category.
    :vartype description: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.description = None


class DiagnosticCategoryCollection(_serialization.Model):
    """Collection of Diagnostic Categories.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.DiagnosticCategory]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DiagnosticCategory]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DiagnosticCategory"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.DiagnosticCategory]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticData(_serialization.Model):
    """Set of data with rendering instructions.

    :ivar table: Data in table form.
    :vartype table: ~azure.mgmt.web.v2018_02_01.models.DataTableResponseObject
    :ivar rendering_properties: Properties that describe how the table should be rendered.
    :vartype rendering_properties: ~azure.mgmt.web.v2018_02_01.models.Rendering
    """

    _attribute_map = {
        "table": {"key": "table", "type": "DataTableResponseObject"},
        "rendering_properties": {"key": "renderingProperties", "type": "Rendering"},
    }

    def __init__(
        self,
        *,
        table: Optional["_models.DataTableResponseObject"] = None,
        rendering_properties: Optional["_models.Rendering"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword table: Data in table form.
        :paramtype table: ~azure.mgmt.web.v2018_02_01.models.DataTableResponseObject
        :keyword rendering_properties: Properties that describe how the table should be rendered.
        :paramtype rendering_properties: ~azure.mgmt.web.v2018_02_01.models.Rendering
        """
        super().__init__(**kwargs)
        self.table = table
        self.rendering_properties = rendering_properties


class DiagnosticDetectorCollection(_serialization.Model):
    """Collection of Diagnostic Detectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.DetectorDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DetectorDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DetectorDefinition"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.DetectorDefinition]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticDetectorResponse(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Class representing Response from Diagnostic Detectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar issue_detected: Flag representing Issue was detected.
    :vartype issue_detected: bool
    :ivar detector_definition: Detector's definition.
    :vartype detector_definition: ~azure.mgmt.web.v2018_02_01.models.DetectorDefinition
    :ivar metrics: Metrics provided by the detector.
    :vartype metrics: list[~azure.mgmt.web.v2018_02_01.models.DiagnosticMetricSet]
    :ivar abnormal_time_periods: List of Correlated events found by the detector.
    :vartype abnormal_time_periods:
     list[~azure.mgmt.web.v2018_02_01.models.DetectorAbnormalTimePeriod]
    :ivar data: Additional Data that detector wants to send.
    :vartype data: list[list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]]
    :ivar response_meta_data: Meta Data.
    :vartype response_meta_data: ~azure.mgmt.web.v2018_02_01.models.ResponseMetaData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
        "issue_detected": {"key": "properties.issueDetected", "type": "bool"},
        "detector_definition": {"key": "properties.detectorDefinition", "type": "DetectorDefinition"},
        "metrics": {"key": "properties.metrics", "type": "[DiagnosticMetricSet]"},
        "abnormal_time_periods": {"key": "properties.abnormalTimePeriods", "type": "[DetectorAbnormalTimePeriod]"},
        "data": {"key": "properties.data", "type": "[[NameValuePair]]"},
        "response_meta_data": {"key": "properties.responseMetaData", "type": "ResponseMetaData"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        issue_detected: Optional[bool] = None,
        detector_definition: Optional["_models.DetectorDefinition"] = None,
        metrics: Optional[List["_models.DiagnosticMetricSet"]] = None,
        abnormal_time_periods: Optional[List["_models.DetectorAbnormalTimePeriod"]] = None,
        data: Optional[List[List["_models.NameValuePair"]]] = None,
        response_meta_data: Optional["_models.ResponseMetaData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword issue_detected: Flag representing Issue was detected.
        :paramtype issue_detected: bool
        :keyword detector_definition: Detector's definition.
        :paramtype detector_definition: ~azure.mgmt.web.v2018_02_01.models.DetectorDefinition
        :keyword metrics: Metrics provided by the detector.
        :paramtype metrics: list[~azure.mgmt.web.v2018_02_01.models.DiagnosticMetricSet]
        :keyword abnormal_time_periods: List of Correlated events found by the detector.
        :paramtype abnormal_time_periods:
         list[~azure.mgmt.web.v2018_02_01.models.DetectorAbnormalTimePeriod]
        :keyword data: Additional Data that detector wants to send.
        :paramtype data: list[list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]]
        :keyword response_meta_data: Meta Data.
        :paramtype response_meta_data: ~azure.mgmt.web.v2018_02_01.models.ResponseMetaData
        """
        super().__init__(kind=kind, **kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.issue_detected = issue_detected
        self.detector_definition = detector_definition
        self.metrics = metrics
        self.abnormal_time_periods = abnormal_time_periods
        self.data = data
        self.response_meta_data = response_meta_data


class DiagnosticMetricSample(_serialization.Model):
    """Class representing Diagnostic Metric.

    :ivar timestamp: Time at which metric is measured.
    :vartype timestamp: ~datetime.datetime
    :ivar role_instance: Role Instance. Null if this counter is not per instance
     This is returned and should be whichever instance name we desire to be returned
     i.e. CPU and Memory return RDWORKERNAME (LargeDed..._IN_0)
     where RDWORKERNAME is Machine name below and RoleInstance name in parenthesis.
    :vartype role_instance: str
    :ivar total: Total value of the metric. If multiple measurements are made this will have sum of
     all.
    :vartype total: float
    :ivar maximum: Maximum of the metric sampled during the time period.
    :vartype maximum: float
    :ivar minimum: Minimum of the metric sampled during the time period.
    :vartype minimum: float
    :ivar is_aggregated: Whether the values are aggregates across all workers or not.
    :vartype is_aggregated: bool
    """

    _attribute_map = {
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "role_instance": {"key": "roleInstance", "type": "str"},
        "total": {"key": "total", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
        "minimum": {"key": "minimum", "type": "float"},
        "is_aggregated": {"key": "isAggregated", "type": "bool"},
    }

    def __init__(
        self,
        *,
        timestamp: Optional[datetime.datetime] = None,
        role_instance: Optional[str] = None,
        total: Optional[float] = None,
        maximum: Optional[float] = None,
        minimum: Optional[float] = None,
        is_aggregated: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword timestamp: Time at which metric is measured.
        :paramtype timestamp: ~datetime.datetime
        :keyword role_instance: Role Instance. Null if this counter is not per instance
         This is returned and should be whichever instance name we desire to be returned
         i.e. CPU and Memory return RDWORKERNAME (LargeDed..._IN_0)
         where RDWORKERNAME is Machine name below and RoleInstance name in parenthesis.
        :paramtype role_instance: str
        :keyword total: Total value of the metric. If multiple measurements are made this will have sum
         of all.
        :paramtype total: float
        :keyword maximum: Maximum of the metric sampled during the time period.
        :paramtype maximum: float
        :keyword minimum: Minimum of the metric sampled during the time period.
        :paramtype minimum: float
        :keyword is_aggregated: Whether the values are aggregates across all workers or not.
        :paramtype is_aggregated: bool
        """
        super().__init__(**kwargs)
        self.timestamp = timestamp
        self.role_instance = role_instance
        self.total = total
        self.maximum = maximum
        self.minimum = minimum
        self.is_aggregated = is_aggregated


class DiagnosticMetricSet(_serialization.Model):
    """Class representing Diagnostic Metric information.

    :ivar name: Name of the metric.
    :vartype name: str
    :ivar unit: Metric's unit.
    :vartype unit: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar time_grain: Presented time grain. Supported grains at the moment are PT1M, PT1H, P1D.
    :vartype time_grain: str
    :ivar values: Collection of metric values for the selected period based on the
     {Microsoft.Web.Hosting.Administration.DiagnosticMetricSet.TimeGrain}.
    :vartype values: list[~azure.mgmt.web.v2018_02_01.models.DiagnosticMetricSample]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "time_grain": {"key": "timeGrain", "type": "str"},
        "values": {"key": "values", "type": "[DiagnosticMetricSample]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        unit: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        values: Optional[List["_models.DiagnosticMetricSample"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the metric.
        :paramtype name: str
        :keyword unit: Metric's unit.
        :paramtype unit: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword time_grain: Presented time grain. Supported grains at the moment are PT1M, PT1H, P1D.
        :paramtype time_grain: str
        :keyword values: Collection of metric values for the selected period based on the
         {Microsoft.Web.Hosting.Administration.DiagnosticMetricSet.TimeGrain}.
        :paramtype values: list[~azure.mgmt.web.v2018_02_01.models.DiagnosticMetricSample]
        """
        super().__init__(**kwargs)
        self.name = name
        self.unit = unit
        self.start_time = start_time
        self.end_time = end_time
        self.time_grain = time_grain
        self.values = values


class Dimension(_serialization.Model):
    """Dimension of a resource metric. For e.g. instance specific HTTP requests for a web app,
    where instance name is dimension of the metric HTTP request.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar internal_name:
    :vartype internal_name: str
    :ivar to_be_exported_for_shoebox:
    :vartype to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "internal_name": {"key": "internalName", "type": "str"},
        "to_be_exported_for_shoebox": {"key": "toBeExportedForShoebox", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword internal_name:
        :paramtype internal_name: str
        :keyword to_be_exported_for_shoebox:
        :paramtype to_be_exported_for_shoebox: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class Domain(Resource):  # pylint: disable=too-many-instance-attributes
    """Information about a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar contact_admin: Administrative contact.
    :vartype contact_admin: ~azure.mgmt.web.v2018_02_01.models.Contact
    :ivar contact_billing: Billing contact.
    :vartype contact_billing: ~azure.mgmt.web.v2018_02_01.models.Contact
    :ivar contact_registrant: Registrant contact.
    :vartype contact_registrant: ~azure.mgmt.web.v2018_02_01.models.Contact
    :ivar contact_tech: Technical contact.
    :vartype contact_tech: ~azure.mgmt.web.v2018_02_01.models.Contact
    :ivar registration_status: Domain registration status. Known values are: "Active", "Awaiting",
     "Cancelled", "Confiscated", "Disabled", "Excluded", "Expired", "Failed", "Held", "Locked",
     "Parked", "Pending", "Reserved", "Reverted", "Suspended", "Transferred", "Unknown", "Unlocked",
     "Unparked", "Updated", and "JsonConverterFailed".
    :vartype registration_status: str or ~azure.mgmt.web.v2018_02_01.models.DomainStatus
    :ivar provisioning_state: Domain provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2018_02_01.models.ProvisioningState
    :ivar name_servers: Name servers.
    :vartype name_servers: list[str]
    :ivar privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
     otherwise, :code:`<code>false</code>`.
    :vartype privacy: bool
    :ivar created_time: Domain creation timestamp.
    :vartype created_time: ~datetime.datetime
    :ivar expiration_time: Domain expiration timestamp.
    :vartype expiration_time: ~datetime.datetime
    :ivar last_renewed_time: Timestamp when the domain was renewed last time.
    :vartype last_renewed_time: ~datetime.datetime
    :ivar auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
     otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar ready_for_dns_record_management: :code:`<code>true</code>` if Azure can assign this
     domain to App Service apps; otherwise, :code:`<code>false</code>`. This value will be
     :code:`<code>true</code>` if domain registration status is active and
      it is hosted on name servers Azure has programmatic access to.
    :vartype ready_for_dns_record_management: bool
    :ivar managed_host_names: All hostnames derived from the domain and assigned to Azure
     resources.
    :vartype managed_host_names: list[~azure.mgmt.web.v2018_02_01.models.HostName]
    :ivar consent: Legal agreement consent.
    :vartype consent: ~azure.mgmt.web.v2018_02_01.models.DomainPurchaseConsent
    :ivar domain_not_renewable_reasons: Reasons why domain is not renewable.
    :vartype domain_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2018_02_01.models.DomainPropertiesDomainNotRenewableReasonsItem]
    :ivar dns_type: Current DNS type. Known values are: "AzureDns" and "DefaultDomainRegistrarDns".
    :vartype dns_type: str or ~azure.mgmt.web.v2018_02_01.models.DnsType
    :ivar dns_zone_id: Azure DNS Zone to use.
    :vartype dns_zone_id: str
    :ivar target_dns_type: Target DNS type (would be used for migration). Known values are:
     "AzureDns" and "DefaultDomainRegistrarDns".
    :vartype target_dns_type: str or ~azure.mgmt.web.v2018_02_01.models.DnsType
    :ivar auth_code:
    :vartype auth_code: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "registration_status": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "name_servers": {"readonly": True},
        "created_time": {"readonly": True},
        "expiration_time": {"readonly": True},
        "last_renewed_time": {"readonly": True},
        "ready_for_dns_record_management": {"readonly": True},
        "managed_host_names": {"readonly": True},
        "domain_not_renewable_reasons": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "contact_admin": {"key": "properties.contactAdmin", "type": "Contact"},
        "contact_billing": {"key": "properties.contactBilling", "type": "Contact"},
        "contact_registrant": {"key": "properties.contactRegistrant", "type": "Contact"},
        "contact_tech": {"key": "properties.contactTech", "type": "Contact"},
        "registration_status": {"key": "properties.registrationStatus", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "name_servers": {"key": "properties.nameServers", "type": "[str]"},
        "privacy": {"key": "properties.privacy", "type": "bool"},
        "created_time": {"key": "properties.createdTime", "type": "iso-8601"},
        "expiration_time": {"key": "properties.expirationTime", "type": "iso-8601"},
        "last_renewed_time": {"key": "properties.lastRenewedTime", "type": "iso-8601"},
        "auto_renew": {"key": "properties.autoRenew", "type": "bool"},
        "ready_for_dns_record_management": {"key": "properties.readyForDnsRecordManagement", "type": "bool"},
        "managed_host_names": {"key": "properties.managedHostNames", "type": "[HostName]"},
        "consent": {"key": "properties.consent", "type": "DomainPurchaseConsent"},
        "domain_not_renewable_reasons": {"key": "properties.domainNotRenewableReasons", "type": "[str]"},
        "dns_type": {"key": "properties.dnsType", "type": "str"},
        "dns_zone_id": {"key": "properties.dnsZoneId", "type": "str"},
        "target_dns_type": {"key": "properties.targetDnsType", "type": "str"},
        "auth_code": {"key": "properties.authCode", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        contact_admin: Optional["_models.Contact"] = None,
        contact_billing: Optional["_models.Contact"] = None,
        contact_registrant: Optional["_models.Contact"] = None,
        contact_tech: Optional["_models.Contact"] = None,
        privacy: Optional[bool] = None,
        auto_renew: bool = True,
        consent: Optional["_models.DomainPurchaseConsent"] = None,
        dns_type: Optional[Union[str, "_models.DnsType"]] = None,
        dns_zone_id: Optional[str] = None,
        target_dns_type: Optional[Union[str, "_models.DnsType"]] = None,
        auth_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword contact_admin: Administrative contact.
        :paramtype contact_admin: ~azure.mgmt.web.v2018_02_01.models.Contact
        :keyword contact_billing: Billing contact.
        :paramtype contact_billing: ~azure.mgmt.web.v2018_02_01.models.Contact
        :keyword contact_registrant: Registrant contact.
        :paramtype contact_registrant: ~azure.mgmt.web.v2018_02_01.models.Contact
        :keyword contact_tech: Technical contact.
        :paramtype contact_tech: ~azure.mgmt.web.v2018_02_01.models.Contact
        :keyword privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
         otherwise, :code:`<code>false</code>`.
        :paramtype privacy: bool
        :keyword auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
         otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword consent: Legal agreement consent.
        :paramtype consent: ~azure.mgmt.web.v2018_02_01.models.DomainPurchaseConsent
        :keyword dns_type: Current DNS type. Known values are: "AzureDns" and
         "DefaultDomainRegistrarDns".
        :paramtype dns_type: str or ~azure.mgmt.web.v2018_02_01.models.DnsType
        :keyword dns_zone_id: Azure DNS Zone to use.
        :paramtype dns_zone_id: str
        :keyword target_dns_type: Target DNS type (would be used for migration). Known values are:
         "AzureDns" and "DefaultDomainRegistrarDns".
        :paramtype target_dns_type: str or ~azure.mgmt.web.v2018_02_01.models.DnsType
        :keyword auth_code:
        :paramtype auth_code: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.contact_admin = contact_admin
        self.contact_billing = contact_billing
        self.contact_registrant = contact_registrant
        self.contact_tech = contact_tech
        self.registration_status = None
        self.provisioning_state = None
        self.name_servers = None
        self.privacy = privacy
        self.created_time = None
        self.expiration_time = None
        self.last_renewed_time = None
        self.auto_renew = auto_renew
        self.ready_for_dns_record_management = None
        self.managed_host_names = None
        self.consent = consent
        self.domain_not_renewable_reasons = None
        self.dns_type = dns_type
        self.dns_zone_id = dns_zone_id
        self.target_dns_type = target_dns_type
        self.auth_code = auth_code


class DomainAvailablilityCheckResult(_serialization.Model):
    """Domain availability check result.

    :ivar name: Name of the domain.
    :vartype name: str
    :ivar available: :code:`<code>true</code>` if domain can be purchased using CreateDomain API;
     otherwise, :code:`<code>false</code>`.
    :vartype available: bool
    :ivar domain_type: Valid values are Regular domain: Azure will charge the full price of domain
     registration, SoftDeleted: Purchasing this domain will simply restore it and this operation
     will not cost anything. Known values are: "Regular" and "SoftDeleted".
    :vartype domain_type: str or ~azure.mgmt.web.v2018_02_01.models.DomainType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "available": {"key": "available", "type": "bool"},
        "domain_type": {"key": "domainType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        available: Optional[bool] = None,
        domain_type: Optional[Union[str, "_models.DomainType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the domain.
        :paramtype name: str
        :keyword available: :code:`<code>true</code>` if domain can be purchased using CreateDomain
         API; otherwise, :code:`<code>false</code>`.
        :paramtype available: bool
        :keyword domain_type: Valid values are Regular domain: Azure will charge the full price of
         domain registration, SoftDeleted: Purchasing this domain will simply restore it and this
         operation will not cost anything. Known values are: "Regular" and "SoftDeleted".
        :paramtype domain_type: str or ~azure.mgmt.web.v2018_02_01.models.DomainType
        """
        super().__init__(**kwargs)
        self.name = name
        self.available = available
        self.domain_type = domain_type


class DomainCollection(_serialization.Model):
    """Collection of domains.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.Domain]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Domain]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Domain"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.Domain]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DomainControlCenterSsoRequest(_serialization.Model):
    """Single sign-on request information for domain management.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar url: URL where the single sign-on request is to be made.
    :vartype url: str
    :ivar post_parameter_key: Post parameter key.
    :vartype post_parameter_key: str
    :ivar post_parameter_value: Post parameter value. Client should use
     'application/x-www-form-urlencoded' encoding for this value.
    :vartype post_parameter_value: str
    """

    _validation = {
        "url": {"readonly": True},
        "post_parameter_key": {"readonly": True},
        "post_parameter_value": {"readonly": True},
    }

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "post_parameter_key": {"key": "postParameterKey", "type": "str"},
        "post_parameter_value": {"key": "postParameterValue", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.url = None
        self.post_parameter_key = None
        self.post_parameter_value = None


class DomainOwnershipIdentifier(ProxyOnlyResource):
    """Domain ownership Identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar ownership_id: Ownership Id.
    :vartype ownership_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "ownership_id": {"key": "properties.ownershipId", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, ownership_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword ownership_id: Ownership Id.
        :paramtype ownership_id: str
        """
        super().__init__(kind=kind, **kwargs)
        self.ownership_id = ownership_id


class DomainOwnershipIdentifierCollection(_serialization.Model):
    """Collection of domain ownership identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.DomainOwnershipIdentifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DomainOwnershipIdentifier]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DomainOwnershipIdentifier"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.DomainOwnershipIdentifier]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DomainPatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar contact_admin: Administrative contact.
    :vartype contact_admin: ~azure.mgmt.web.v2018_02_01.models.Contact
    :ivar contact_billing: Billing contact.
    :vartype contact_billing: ~azure.mgmt.web.v2018_02_01.models.Contact
    :ivar contact_registrant: Registrant contact.
    :vartype contact_registrant: ~azure.mgmt.web.v2018_02_01.models.Contact
    :ivar contact_tech: Technical contact.
    :vartype contact_tech: ~azure.mgmt.web.v2018_02_01.models.Contact
    :ivar registration_status: Domain registration status. Known values are: "Active", "Awaiting",
     "Cancelled", "Confiscated", "Disabled", "Excluded", "Expired", "Failed", "Held", "Locked",
     "Parked", "Pending", "Reserved", "Reverted", "Suspended", "Transferred", "Unknown", "Unlocked",
     "Unparked", "Updated", and "JsonConverterFailed".
    :vartype registration_status: str or ~azure.mgmt.web.v2018_02_01.models.DomainStatus
    :ivar provisioning_state: Domain provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2018_02_01.models.ProvisioningState
    :ivar name_servers: Name servers.
    :vartype name_servers: list[str]
    :ivar privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
     otherwise, :code:`<code>false</code>`.
    :vartype privacy: bool
    :ivar created_time: Domain creation timestamp.
    :vartype created_time: ~datetime.datetime
    :ivar expiration_time: Domain expiration timestamp.
    :vartype expiration_time: ~datetime.datetime
    :ivar last_renewed_time: Timestamp when the domain was renewed last time.
    :vartype last_renewed_time: ~datetime.datetime
    :ivar auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
     otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar ready_for_dns_record_management: :code:`<code>true</code>` if Azure can assign this
     domain to App Service apps; otherwise, :code:`<code>false</code>`. This value will be
     :code:`<code>true</code>` if domain registration status is active and
      it is hosted on name servers Azure has programmatic access to.
    :vartype ready_for_dns_record_management: bool
    :ivar managed_host_names: All hostnames derived from the domain and assigned to Azure
     resources.
    :vartype managed_host_names: list[~azure.mgmt.web.v2018_02_01.models.HostName]
    :ivar consent: Legal agreement consent.
    :vartype consent: ~azure.mgmt.web.v2018_02_01.models.DomainPurchaseConsent
    :ivar domain_not_renewable_reasons: Reasons why domain is not renewable.
    :vartype domain_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2018_02_01.models.DomainPatchResourcePropertiesDomainNotRenewableReasonsItem]
    :ivar dns_type: Current DNS type. Known values are: "AzureDns" and "DefaultDomainRegistrarDns".
    :vartype dns_type: str or ~azure.mgmt.web.v2018_02_01.models.DnsType
    :ivar dns_zone_id: Azure DNS Zone to use.
    :vartype dns_zone_id: str
    :ivar target_dns_type: Target DNS type (would be used for migration). Known values are:
     "AzureDns" and "DefaultDomainRegistrarDns".
    :vartype target_dns_type: str or ~azure.mgmt.web.v2018_02_01.models.DnsType
    :ivar auth_code:
    :vartype auth_code: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "registration_status": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "name_servers": {"readonly": True},
        "created_time": {"readonly": True},
        "expiration_time": {"readonly": True},
        "last_renewed_time": {"readonly": True},
        "ready_for_dns_record_management": {"readonly": True},
        "managed_host_names": {"readonly": True},
        "domain_not_renewable_reasons": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "contact_admin": {"key": "properties.contactAdmin", "type": "Contact"},
        "contact_billing": {"key": "properties.contactBilling", "type": "Contact"},
        "contact_registrant": {"key": "properties.contactRegistrant", "type": "Contact"},
        "contact_tech": {"key": "properties.contactTech", "type": "Contact"},
        "registration_status": {"key": "properties.registrationStatus", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "name_servers": {"key": "properties.nameServers", "type": "[str]"},
        "privacy": {"key": "properties.privacy", "type": "bool"},
        "created_time": {"key": "properties.createdTime", "type": "iso-8601"},
        "expiration_time": {"key": "properties.expirationTime", "type": "iso-8601"},
        "last_renewed_time": {"key": "properties.lastRenewedTime", "type": "iso-8601"},
        "auto_renew": {"key": "properties.autoRenew", "type": "bool"},
        "ready_for_dns_record_management": {"key": "properties.readyForDnsRecordManagement", "type": "bool"},
        "managed_host_names": {"key": "properties.managedHostNames", "type": "[HostName]"},
        "consent": {"key": "properties.consent", "type": "DomainPurchaseConsent"},
        "domain_not_renewable_reasons": {"key": "properties.domainNotRenewableReasons", "type": "[str]"},
        "dns_type": {"key": "properties.dnsType", "type": "str"},
        "dns_zone_id": {"key": "properties.dnsZoneId", "type": "str"},
        "target_dns_type": {"key": "properties.targetDnsType", "type": "str"},
        "auth_code": {"key": "properties.authCode", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        contact_admin: Optional["_models.Contact"] = None,
        contact_billing: Optional["_models.Contact"] = None,
        contact_registrant: Optional["_models.Contact"] = None,
        contact_tech: Optional["_models.Contact"] = None,
        privacy: Optional[bool] = None,
        auto_renew: bool = True,
        consent: Optional["_models.DomainPurchaseConsent"] = None,
        dns_type: Optional[Union[str, "_models.DnsType"]] = None,
        dns_zone_id: Optional[str] = None,
        target_dns_type: Optional[Union[str, "_models.DnsType"]] = None,
        auth_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword contact_admin: Administrative contact.
        :paramtype contact_admin: ~azure.mgmt.web.v2018_02_01.models.Contact
        :keyword contact_billing: Billing contact.
        :paramtype contact_billing: ~azure.mgmt.web.v2018_02_01.models.Contact
        :keyword contact_registrant: Registrant contact.
        :paramtype contact_registrant: ~azure.mgmt.web.v2018_02_01.models.Contact
        :keyword contact_tech: Technical contact.
        :paramtype contact_tech: ~azure.mgmt.web.v2018_02_01.models.Contact
        :keyword privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
         otherwise, :code:`<code>false</code>`.
        :paramtype privacy: bool
        :keyword auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
         otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword consent: Legal agreement consent.
        :paramtype consent: ~azure.mgmt.web.v2018_02_01.models.DomainPurchaseConsent
        :keyword dns_type: Current DNS type. Known values are: "AzureDns" and
         "DefaultDomainRegistrarDns".
        :paramtype dns_type: str or ~azure.mgmt.web.v2018_02_01.models.DnsType
        :keyword dns_zone_id: Azure DNS Zone to use.
        :paramtype dns_zone_id: str
        :keyword target_dns_type: Target DNS type (would be used for migration). Known values are:
         "AzureDns" and "DefaultDomainRegistrarDns".
        :paramtype target_dns_type: str or ~azure.mgmt.web.v2018_02_01.models.DnsType
        :keyword auth_code:
        :paramtype auth_code: str
        """
        super().__init__(kind=kind, **kwargs)
        self.contact_admin = contact_admin
        self.contact_billing = contact_billing
        self.contact_registrant = contact_registrant
        self.contact_tech = contact_tech
        self.registration_status = None
        self.provisioning_state = None
        self.name_servers = None
        self.privacy = privacy
        self.created_time = None
        self.expiration_time = None
        self.last_renewed_time = None
        self.auto_renew = auto_renew
        self.ready_for_dns_record_management = None
        self.managed_host_names = None
        self.consent = consent
        self.domain_not_renewable_reasons = None
        self.dns_type = dns_type
        self.dns_zone_id = dns_zone_id
        self.target_dns_type = target_dns_type
        self.auth_code = auth_code


class DomainPurchaseConsent(_serialization.Model):
    """Domain purchase consent object, representing acceptance of applicable legal agreements.

    :ivar agreement_keys: List of applicable legal agreement keys. This list can be retrieved using
     ListLegalAgreements API under :code:`<code>TopLevelDomain</code>` resource.
    :vartype agreement_keys: list[str]
    :ivar agreed_by: Client IP address.
    :vartype agreed_by: str
    :ivar agreed_at: Timestamp when the agreements were accepted.
    :vartype agreed_at: ~datetime.datetime
    """

    _attribute_map = {
        "agreement_keys": {"key": "agreementKeys", "type": "[str]"},
        "agreed_by": {"key": "agreedBy", "type": "str"},
        "agreed_at": {"key": "agreedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        agreement_keys: Optional[List[str]] = None,
        agreed_by: Optional[str] = None,
        agreed_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword agreement_keys: List of applicable legal agreement keys. This list can be retrieved
         using ListLegalAgreements API under :code:`<code>TopLevelDomain</code>` resource.
        :paramtype agreement_keys: list[str]
        :keyword agreed_by: Client IP address.
        :paramtype agreed_by: str
        :keyword agreed_at: Timestamp when the agreements were accepted.
        :paramtype agreed_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.agreement_keys = agreement_keys
        self.agreed_by = agreed_by
        self.agreed_at = agreed_at


class DomainRecommendationSearchParameters(_serialization.Model):
    """Domain recommendation search parameters.

    :ivar keywords: Keywords to be used for generating domain recommendations.
    :vartype keywords: str
    :ivar max_domain_recommendations: Maximum number of recommendations.
    :vartype max_domain_recommendations: int
    """

    _attribute_map = {
        "keywords": {"key": "keywords", "type": "str"},
        "max_domain_recommendations": {"key": "maxDomainRecommendations", "type": "int"},
    }

    def __init__(
        self, *, keywords: Optional[str] = None, max_domain_recommendations: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword keywords: Keywords to be used for generating domain recommendations.
        :paramtype keywords: str
        :keyword max_domain_recommendations: Maximum number of recommendations.
        :paramtype max_domain_recommendations: int
        """
        super().__init__(**kwargs)
        self.keywords = keywords
        self.max_domain_recommendations = max_domain_recommendations


class EnabledConfig(_serialization.Model):
    """Enabled configuration.

    :ivar enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: True if configuration is enabled, false if it is disabled and null if
         configuration is not set.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class EndpointDependency(_serialization.Model):
    """A domain name that a service is reached at, including details of the current connection status.

    :ivar domain_name: The domain name of the dependency.
    :vartype domain_name: str
    :ivar endpoint_details: The IP Addresses and Ports used when connecting to DomainName.
    :vartype endpoint_details: list[~azure.mgmt.web.v2018_02_01.models.EndpointDetail]
    """

    _attribute_map = {
        "domain_name": {"key": "domainName", "type": "str"},
        "endpoint_details": {"key": "endpointDetails", "type": "[EndpointDetail]"},
    }

    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        endpoint_details: Optional[List["_models.EndpointDetail"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword domain_name: The domain name of the dependency.
        :paramtype domain_name: str
        :keyword endpoint_details: The IP Addresses and Ports used when connecting to DomainName.
        :paramtype endpoint_details: list[~azure.mgmt.web.v2018_02_01.models.EndpointDetail]
        """
        super().__init__(**kwargs)
        self.domain_name = domain_name
        self.endpoint_details = endpoint_details


class EndpointDetail(_serialization.Model):
    """Current TCP connectivity information from the App Service Environment to a single endpoint.

    :ivar ip_address: An IP Address that Domain Name currently resolves to.
    :vartype ip_address: str
    :ivar port: The port an endpoint is connected to.
    :vartype port: int
    :ivar latency: The time in milliseconds it takes for a TCP connection to be created from the
     App Service Environment to this IpAddress at this Port.
    :vartype latency: float
    :ivar is_accessable: Whether it is possible to create a TCP connection from the App Service
     Environment to this IpAddress at this Port.
    :vartype is_accessable: bool
    """

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "latency": {"key": "latency", "type": "float"},
        "is_accessable": {"key": "isAccessable", "type": "bool"},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        port: Optional[int] = None,
        latency: Optional[float] = None,
        is_accessable: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_address: An IP Address that Domain Name currently resolves to.
        :paramtype ip_address: str
        :keyword port: The port an endpoint is connected to.
        :paramtype port: int
        :keyword latency: The time in milliseconds it takes for a TCP connection to be created from the
         App Service Environment to this IpAddress at this Port.
        :paramtype latency: float
        :keyword is_accessable: Whether it is possible to create a TCP connection from the App Service
         Environment to this IpAddress at this Port.
        :paramtype is_accessable: bool
        """
        super().__init__(**kwargs)
        self.ip_address = ip_address
        self.port = port
        self.latency = latency
        self.is_accessable = is_accessable


class ErrorEntity(_serialization.Model):
    """Body of the error response returned from the API.

    :ivar extended_code: Type of error.
    :vartype extended_code: str
    :ivar message_template: Message template.
    :vartype message_template: str
    :ivar parameters: Parameters for the template.
    :vartype parameters: list[str]
    :ivar inner_errors: Inner errors.
    :vartype inner_errors: list[~azure.mgmt.web.v2018_02_01.models.ErrorEntity]
    :ivar code: Basic error code.
    :vartype code: str
    :ivar message: Any details of the error.
    :vartype message: str
    """

    _attribute_map = {
        "extended_code": {"key": "extendedCode", "type": "str"},
        "message_template": {"key": "messageTemplate", "type": "str"},
        "parameters": {"key": "parameters", "type": "[str]"},
        "inner_errors": {"key": "innerErrors", "type": "[ErrorEntity]"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        extended_code: Optional[str] = None,
        message_template: Optional[str] = None,
        parameters: Optional[List[str]] = None,
        inner_errors: Optional[List["_models.ErrorEntity"]] = None,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extended_code: Type of error.
        :paramtype extended_code: str
        :keyword message_template: Message template.
        :paramtype message_template: str
        :keyword parameters: Parameters for the template.
        :paramtype parameters: list[str]
        :keyword inner_errors: Inner errors.
        :paramtype inner_errors: list[~azure.mgmt.web.v2018_02_01.models.ErrorEntity]
        :keyword code: Basic error code.
        :paramtype code: str
        :keyword message: Any details of the error.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.extended_code = extended_code
        self.message_template = message_template
        self.parameters = parameters
        self.inner_errors = inner_errors
        self.code = code
        self.message = message


class Experiments(_serialization.Model):
    """Routing rules in production experiments.

    :ivar ramp_up_rules: List of ramp-up rules.
    :vartype ramp_up_rules: list[~azure.mgmt.web.v2018_02_01.models.RampUpRule]
    """

    _attribute_map = {
        "ramp_up_rules": {"key": "rampUpRules", "type": "[RampUpRule]"},
    }

    def __init__(self, *, ramp_up_rules: Optional[List["_models.RampUpRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword ramp_up_rules: List of ramp-up rules.
        :paramtype ramp_up_rules: list[~azure.mgmt.web.v2018_02_01.models.RampUpRule]
        """
        super().__init__(**kwargs)
        self.ramp_up_rules = ramp_up_rules


class FileSystemApplicationLogsConfig(_serialization.Model):
    """Application logs to file system configuration.

    :ivar level: Log level. Known values are: "Off", "Verbose", "Information", "Warning", and
     "Error".
    :vartype level: str or ~azure.mgmt.web.v2018_02_01.models.LogLevel
    """

    _attribute_map = {
        "level": {"key": "level", "type": "str"},
    }

    def __init__(self, *, level: Optional[Union[str, "_models.LogLevel"]] = None, **kwargs: Any) -> None:
        """
        :keyword level: Log level. Known values are: "Off", "Verbose", "Information", "Warning", and
         "Error".
        :paramtype level: str or ~azure.mgmt.web.v2018_02_01.models.LogLevel
        """
        super().__init__(**kwargs)
        self.level = level


class FileSystemHttpLogsConfig(_serialization.Model):
    """Http logs to file system configuration.

    :ivar retention_in_mb: Maximum size in megabytes that http log files can use.
     When reached old log files will be removed to make space for new ones.
     Value can range between 25 and 100.
    :vartype retention_in_mb: int
    :ivar retention_in_days: Retention in days.
     Remove files older than X days.
     0 or lower means no retention.
    :vartype retention_in_days: int
    :ivar enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :vartype enabled: bool
    """

    _validation = {
        "retention_in_mb": {"maximum": 100, "minimum": 25},
    }

    _attribute_map = {
        "retention_in_mb": {"key": "retentionInMb", "type": "int"},
        "retention_in_days": {"key": "retentionInDays", "type": "int"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        retention_in_mb: Optional[int] = None,
        retention_in_days: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword retention_in_mb: Maximum size in megabytes that http log files can use.
         When reached old log files will be removed to make space for new ones.
         Value can range between 25 and 100.
        :paramtype retention_in_mb: int
        :keyword retention_in_days: Retention in days.
         Remove files older than X days.
         0 or lower means no retention.
        :paramtype retention_in_days: int
        :keyword enabled: True if configuration is enabled, false if it is disabled and null if
         configuration is not set.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.retention_in_mb = retention_in_mb
        self.retention_in_days = retention_in_days
        self.enabled = enabled


class FunctionEnvelope(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Function information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar function_app_id: Function App ID.
    :vartype function_app_id: str
    :ivar script_root_path_href: Script root path URI.
    :vartype script_root_path_href: str
    :ivar script_href: Script URI.
    :vartype script_href: str
    :ivar config_href: Config URI.
    :vartype config_href: str
    :ivar test_data_href: Test data URI.
    :vartype test_data_href: str
    :ivar secrets_file_href: Secrets file URI.
    :vartype secrets_file_href: str
    :ivar href: Function URI.
    :vartype href: str
    :ivar config: Config information.
    :vartype config: JSON
    :ivar files: File list.
    :vartype files: dict[str, str]
    :ivar test_data: Test data used when testing via the Azure Portal.
    :vartype test_data: str
    :ivar invoke_url_template: The invocation URL.
    :vartype invoke_url_template: str
    :ivar language: The function language.
    :vartype language: str
    :ivar is_disabled: Value indicating whether the function is disabled.
    :vartype is_disabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "function_app_id": {"key": "properties.function_app_id", "type": "str"},
        "script_root_path_href": {"key": "properties.script_root_path_href", "type": "str"},
        "script_href": {"key": "properties.script_href", "type": "str"},
        "config_href": {"key": "properties.config_href", "type": "str"},
        "test_data_href": {"key": "properties.test_data_href", "type": "str"},
        "secrets_file_href": {"key": "properties.secrets_file_href", "type": "str"},
        "href": {"key": "properties.href", "type": "str"},
        "config": {"key": "properties.config", "type": "object"},
        "files": {"key": "properties.files", "type": "{str}"},
        "test_data": {"key": "properties.test_data", "type": "str"},
        "invoke_url_template": {"key": "properties.invoke_url_template", "type": "str"},
        "language": {"key": "properties.language", "type": "str"},
        "is_disabled": {"key": "properties.isDisabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        function_app_id: Optional[str] = None,
        script_root_path_href: Optional[str] = None,
        script_href: Optional[str] = None,
        config_href: Optional[str] = None,
        test_data_href: Optional[str] = None,
        secrets_file_href: Optional[str] = None,
        href: Optional[str] = None,
        config: Optional[JSON] = None,
        files: Optional[Dict[str, str]] = None,
        test_data: Optional[str] = None,
        invoke_url_template: Optional[str] = None,
        language: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword function_app_id: Function App ID.
        :paramtype function_app_id: str
        :keyword script_root_path_href: Script root path URI.
        :paramtype script_root_path_href: str
        :keyword script_href: Script URI.
        :paramtype script_href: str
        :keyword config_href: Config URI.
        :paramtype config_href: str
        :keyword test_data_href: Test data URI.
        :paramtype test_data_href: str
        :keyword secrets_file_href: Secrets file URI.
        :paramtype secrets_file_href: str
        :keyword href: Function URI.
        :paramtype href: str
        :keyword config: Config information.
        :paramtype config: JSON
        :keyword files: File list.
        :paramtype files: dict[str, str]
        :keyword test_data: Test data used when testing via the Azure Portal.
        :paramtype test_data: str
        :keyword invoke_url_template: The invocation URL.
        :paramtype invoke_url_template: str
        :keyword language: The function language.
        :paramtype language: str
        :keyword is_disabled: Value indicating whether the function is disabled.
        :paramtype is_disabled: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.function_app_id = function_app_id
        self.script_root_path_href = script_root_path_href
        self.script_href = script_href
        self.config_href = config_href
        self.test_data_href = test_data_href
        self.secrets_file_href = secrets_file_href
        self.href = href
        self.config = config
        self.files = files
        self.test_data = test_data
        self.invoke_url_template = invoke_url_template
        self.language = language
        self.is_disabled = is_disabled


class FunctionEnvelopeCollection(_serialization.Model):
    """Collection of Kudu function information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.FunctionEnvelope]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FunctionEnvelope]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.FunctionEnvelope"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.FunctionEnvelope]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class FunctionSecrets(ProxyOnlyResource):
    """Function secrets.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key: Secret key.
    :vartype key: str
    :ivar trigger_url: Trigger URL.
    :vartype trigger_url: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "key": {"key": "properties.key", "type": "str"},
        "trigger_url": {"key": "properties.trigger_url", "type": "str"},
    }

    def __init__(
        self, *, kind: Optional[str] = None, key: Optional[str] = None, trigger_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key: Secret key.
        :paramtype key: str
        :keyword trigger_url: Trigger URL.
        :paramtype trigger_url: str
        """
        super().__init__(kind=kind, **kwargs)
        self.key = key
        self.trigger_url = trigger_url


class GeoDistribution(_serialization.Model):
    """A global distribution definition.

    :ivar location: Location.
    :vartype location: str
    :ivar number_of_workers: NumberOfWorkers.
    :vartype number_of_workers: int
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "number_of_workers": {"key": "numberOfWorkers", "type": "int"},
    }

    def __init__(
        self, *, location: Optional[str] = None, number_of_workers: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword location: Location.
        :paramtype location: str
        :keyword number_of_workers: NumberOfWorkers.
        :paramtype number_of_workers: int
        """
        super().__init__(**kwargs)
        self.location = location
        self.number_of_workers = number_of_workers


class GeoRegion(ProxyOnlyResource):
    """Geographical region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Region description.
    :vartype description: str
    :ivar display_name: Display name for region.
    :vartype display_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "description": {"readonly": True},
        "display_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.description = None
        self.display_name = None


class GeoRegionCollection(_serialization.Model):
    """Collection of geographical regions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.GeoRegion]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GeoRegion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.GeoRegion"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.GeoRegion]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class GlobalCsmSkuDescription(_serialization.Model):
    """A Global SKU Description.

    :ivar name: Name of the resource SKU.
    :vartype name: str
    :ivar tier: Service Tier of the resource SKU.
    :vartype tier: str
    :ivar size: Size specifier of the resource SKU.
    :vartype size: str
    :ivar family: Family code of the resource SKU.
    :vartype family: str
    :ivar capacity: Min, max, and default scale values of the SKU.
    :vartype capacity: ~azure.mgmt.web.v2018_02_01.models.SkuCapacity
    :ivar locations: Locations of the SKU.
    :vartype locations: list[str]
    :ivar capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
    :vartype capabilities: list[~azure.mgmt.web.v2018_02_01.models.Capability]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "SkuCapacity"},
        "locations": {"key": "locations", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[Capability]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional["_models.SkuCapacity"] = None,
        locations: Optional[List[str]] = None,
        capabilities: Optional[List["_models.Capability"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the resource SKU.
        :paramtype name: str
        :keyword tier: Service Tier of the resource SKU.
        :paramtype tier: str
        :keyword size: Size specifier of the resource SKU.
        :paramtype size: str
        :keyword family: Family code of the resource SKU.
        :paramtype family: str
        :keyword capacity: Min, max, and default scale values of the SKU.
        :paramtype capacity: ~azure.mgmt.web.v2018_02_01.models.SkuCapacity
        :keyword locations: Locations of the SKU.
        :paramtype locations: list[str]
        :keyword capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
        :paramtype capabilities: list[~azure.mgmt.web.v2018_02_01.models.Capability]
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity
        self.locations = locations
        self.capabilities = capabilities


class HandlerMapping(_serialization.Model):
    """The IIS handler mappings used to define which handler processes HTTP requests with certain
    extension.
    For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php
    extension.

    :ivar extension: Requests with this extension will be handled using the specified FastCGI
     application.
    :vartype extension: str
    :ivar script_processor: The absolute path to the FastCGI application.
    :vartype script_processor: str
    :ivar arguments: Command-line arguments to be passed to the script processor.
    :vartype arguments: str
    """

    _attribute_map = {
        "extension": {"key": "extension", "type": "str"},
        "script_processor": {"key": "scriptProcessor", "type": "str"},
        "arguments": {"key": "arguments", "type": "str"},
    }

    def __init__(
        self,
        *,
        extension: Optional[str] = None,
        script_processor: Optional[str] = None,
        arguments: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extension: Requests with this extension will be handled using the specified FastCGI
         application.
        :paramtype extension: str
        :keyword script_processor: The absolute path to the FastCGI application.
        :paramtype script_processor: str
        :keyword arguments: Command-line arguments to be passed to the script processor.
        :paramtype arguments: str
        """
        super().__init__(**kwargs)
        self.extension = extension
        self.script_processor = script_processor
        self.arguments = arguments


class HostingEnvironmentDeploymentInfo(_serialization.Model):
    """Information needed to create resources on an App Service Environment.

    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar location: Location of the App Service Environment.
    :vartype location: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the App Service Environment.
        :paramtype name: str
        :keyword location: Location of the App Service Environment.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.location = location


class HostingEnvironmentDiagnostics(_serialization.Model):
    """Diagnostics for an App Service Environment.

    :ivar name: Name/identifier of the diagnostics.
    :vartype name: str
    :ivar diagnosics_output: Diagnostics output.
    :vartype diagnosics_output: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "diagnosics_output": {"key": "diagnosicsOutput", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, diagnosics_output: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name/identifier of the diagnostics.
        :paramtype name: str
        :keyword diagnosics_output: Diagnostics output.
        :paramtype diagnosics_output: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.diagnosics_output = diagnosics_output


class HostingEnvironmentProfile(_serialization.Model):
    """Specification for an App Service Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of the App Service Environment.
    :vartype id: str
    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar type: Resource type of the App Service Environment.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of the App Service Environment.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None


class HostKeys(_serialization.Model):
    """Functions host level keys.

    :ivar master_key: Secret key.
    :vartype master_key: str
    :ivar function_keys: Host level function keys.
    :vartype function_keys: dict[str, str]
    :ivar system_keys: System keys.
    :vartype system_keys: dict[str, str]
    """

    _attribute_map = {
        "master_key": {"key": "masterKey", "type": "str"},
        "function_keys": {"key": "functionKeys", "type": "{str}"},
        "system_keys": {"key": "systemKeys", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        master_key: Optional[str] = None,
        function_keys: Optional[Dict[str, str]] = None,
        system_keys: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword master_key: Secret key.
        :paramtype master_key: str
        :keyword function_keys: Host level function keys.
        :paramtype function_keys: dict[str, str]
        :keyword system_keys: System keys.
        :paramtype system_keys: dict[str, str]
        """
        super().__init__(**kwargs)
        self.master_key = master_key
        self.function_keys = function_keys
        self.system_keys = system_keys


class HostName(_serialization.Model):
    """Details of a hostname derived from a domain.

    :ivar name: Name of the hostname.
    :vartype name: str
    :ivar site_names: List of apps the hostname is assigned to. This list will have more than one
     app only if the hostname is pointing to a Traffic Manager.
    :vartype site_names: list[str]
    :ivar azure_resource_name: Name of the Azure resource the hostname is assigned to. If it is
     assigned to a Traffic Manager then it will be the Traffic Manager name otherwise it will be the
     app name.
    :vartype azure_resource_name: str
    :ivar azure_resource_type: Type of the Azure resource the hostname is assigned to. Known values
     are: "Website" and "TrafficManager".
    :vartype azure_resource_type: str or ~azure.mgmt.web.v2018_02_01.models.AzureResourceType
    :ivar custom_host_name_dns_record_type: Type of the DNS record. Known values are: "CName" and
     "A".
    :vartype custom_host_name_dns_record_type: str or
     ~azure.mgmt.web.v2018_02_01.models.CustomHostNameDnsRecordType
    :ivar host_name_type: Type of the hostname. Known values are: "Verified" and "Managed".
    :vartype host_name_type: str or ~azure.mgmt.web.v2018_02_01.models.HostNameType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "site_names": {"key": "siteNames", "type": "[str]"},
        "azure_resource_name": {"key": "azureResourceName", "type": "str"},
        "azure_resource_type": {"key": "azureResourceType", "type": "str"},
        "custom_host_name_dns_record_type": {"key": "customHostNameDnsRecordType", "type": "str"},
        "host_name_type": {"key": "hostNameType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        site_names: Optional[List[str]] = None,
        azure_resource_name: Optional[str] = None,
        azure_resource_type: Optional[Union[str, "_models.AzureResourceType"]] = None,
        custom_host_name_dns_record_type: Optional[Union[str, "_models.CustomHostNameDnsRecordType"]] = None,
        host_name_type: Optional[Union[str, "_models.HostNameType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the hostname.
        :paramtype name: str
        :keyword site_names: List of apps the hostname is assigned to. This list will have more than
         one app only if the hostname is pointing to a Traffic Manager.
        :paramtype site_names: list[str]
        :keyword azure_resource_name: Name of the Azure resource the hostname is assigned to. If it is
         assigned to a Traffic Manager then it will be the Traffic Manager name otherwise it will be the
         app name.
        :paramtype azure_resource_name: str
        :keyword azure_resource_type: Type of the Azure resource the hostname is assigned to. Known
         values are: "Website" and "TrafficManager".
        :paramtype azure_resource_type: str or ~azure.mgmt.web.v2018_02_01.models.AzureResourceType
        :keyword custom_host_name_dns_record_type: Type of the DNS record. Known values are: "CName"
         and "A".
        :paramtype custom_host_name_dns_record_type: str or
         ~azure.mgmt.web.v2018_02_01.models.CustomHostNameDnsRecordType
        :keyword host_name_type: Type of the hostname. Known values are: "Verified" and "Managed".
        :paramtype host_name_type: str or ~azure.mgmt.web.v2018_02_01.models.HostNameType
        """
        super().__init__(**kwargs)
        self.name = name
        self.site_names = site_names
        self.azure_resource_name = azure_resource_name
        self.azure_resource_type = azure_resource_type
        self.custom_host_name_dns_record_type = custom_host_name_dns_record_type
        self.host_name_type = host_name_type


class HostNameBinding(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """A hostname binding object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar site_name: App Service app name.
    :vartype site_name: str
    :ivar domain_id: Fully qualified ARM domain resource URI.
    :vartype domain_id: str
    :ivar azure_resource_name: Azure resource name.
    :vartype azure_resource_name: str
    :ivar azure_resource_type: Azure resource type. Known values are: "Website" and
     "TrafficManager".
    :vartype azure_resource_type: str or ~azure.mgmt.web.v2018_02_01.models.AzureResourceType
    :ivar custom_host_name_dns_record_type: Custom DNS record type. Known values are: "CName" and
     "A".
    :vartype custom_host_name_dns_record_type: str or
     ~azure.mgmt.web.v2018_02_01.models.CustomHostNameDnsRecordType
    :ivar host_name_type: Hostname type. Known values are: "Verified" and "Managed".
    :vartype host_name_type: str or ~azure.mgmt.web.v2018_02_01.models.HostNameType
    :ivar ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
    :vartype ssl_state: str or ~azure.mgmt.web.v2018_02_01.models.SslState
    :ivar thumbprint: SSL certificate thumbprint.
    :vartype thumbprint: str
    :ivar virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :vartype virtual_ip: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "virtual_ip": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "site_name": {"key": "properties.siteName", "type": "str"},
        "domain_id": {"key": "properties.domainId", "type": "str"},
        "azure_resource_name": {"key": "properties.azureResourceName", "type": "str"},
        "azure_resource_type": {"key": "properties.azureResourceType", "type": "str"},
        "custom_host_name_dns_record_type": {"key": "properties.customHostNameDnsRecordType", "type": "str"},
        "host_name_type": {"key": "properties.hostNameType", "type": "str"},
        "ssl_state": {"key": "properties.sslState", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "virtual_ip": {"key": "properties.virtualIP", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        site_name: Optional[str] = None,
        domain_id: Optional[str] = None,
        azure_resource_name: Optional[str] = None,
        azure_resource_type: Optional[Union[str, "_models.AzureResourceType"]] = None,
        custom_host_name_dns_record_type: Optional[Union[str, "_models.CustomHostNameDnsRecordType"]] = None,
        host_name_type: Optional[Union[str, "_models.HostNameType"]] = None,
        ssl_state: Optional[Union[str, "_models.SslState"]] = None,
        thumbprint: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword site_name: App Service app name.
        :paramtype site_name: str
        :keyword domain_id: Fully qualified ARM domain resource URI.
        :paramtype domain_id: str
        :keyword azure_resource_name: Azure resource name.
        :paramtype azure_resource_name: str
        :keyword azure_resource_type: Azure resource type. Known values are: "Website" and
         "TrafficManager".
        :paramtype azure_resource_type: str or ~azure.mgmt.web.v2018_02_01.models.AzureResourceType
        :keyword custom_host_name_dns_record_type: Custom DNS record type. Known values are: "CName"
         and "A".
        :paramtype custom_host_name_dns_record_type: str or
         ~azure.mgmt.web.v2018_02_01.models.CustomHostNameDnsRecordType
        :keyword host_name_type: Hostname type. Known values are: "Verified" and "Managed".
        :paramtype host_name_type: str or ~azure.mgmt.web.v2018_02_01.models.HostNameType
        :keyword ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
        :paramtype ssl_state: str or ~azure.mgmt.web.v2018_02_01.models.SslState
        :keyword thumbprint: SSL certificate thumbprint.
        :paramtype thumbprint: str
        """
        super().__init__(kind=kind, **kwargs)
        self.site_name = site_name
        self.domain_id = domain_id
        self.azure_resource_name = azure_resource_name
        self.azure_resource_type = azure_resource_type
        self.custom_host_name_dns_record_type = custom_host_name_dns_record_type
        self.host_name_type = host_name_type
        self.ssl_state = ssl_state
        self.thumbprint = thumbprint
        self.virtual_ip = None


class HostNameBindingCollection(_serialization.Model):
    """Collection of hostname bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.HostNameBinding]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HostNameBinding]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.HostNameBinding"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.HostNameBinding]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class HostNameSslState(_serialization.Model):
    """SSL-enabled hostname.

    :ivar name: Hostname.
    :vartype name: str
    :ivar ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
    :vartype ssl_state: str or ~azure.mgmt.web.v2018_02_01.models.SslState
    :ivar virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :vartype virtual_ip: str
    :ivar thumbprint: SSL certificate thumbprint.
    :vartype thumbprint: str
    :ivar to_update: Set to :code:`<code>true</code>` to update existing hostname.
    :vartype to_update: bool
    :ivar host_type: Indicates whether the hostname is a standard or repository hostname. Known
     values are: "Standard" and "Repository".
    :vartype host_type: str or ~azure.mgmt.web.v2018_02_01.models.HostType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "ssl_state": {"key": "sslState", "type": "str"},
        "virtual_ip": {"key": "virtualIP", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "to_update": {"key": "toUpdate", "type": "bool"},
        "host_type": {"key": "hostType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        ssl_state: Optional[Union[str, "_models.SslState"]] = None,
        virtual_ip: Optional[str] = None,
        thumbprint: Optional[str] = None,
        to_update: Optional[bool] = None,
        host_type: Optional[Union[str, "_models.HostType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Hostname.
        :paramtype name: str
        :keyword ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
        :paramtype ssl_state: str or ~azure.mgmt.web.v2018_02_01.models.SslState
        :keyword virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
        :paramtype virtual_ip: str
        :keyword thumbprint: SSL certificate thumbprint.
        :paramtype thumbprint: str
        :keyword to_update: Set to :code:`<code>true</code>` to update existing hostname.
        :paramtype to_update: bool
        :keyword host_type: Indicates whether the hostname is a standard or repository hostname. Known
         values are: "Standard" and "Repository".
        :paramtype host_type: str or ~azure.mgmt.web.v2018_02_01.models.HostType
        """
        super().__init__(**kwargs)
        self.name = name
        self.ssl_state = ssl_state
        self.virtual_ip = virtual_ip
        self.thumbprint = thumbprint
        self.to_update = to_update
        self.host_type = host_type


class HttpLogsConfig(_serialization.Model):
    """Http logs configuration.

    :ivar file_system: Http logs to file system configuration.
    :vartype file_system: ~azure.mgmt.web.v2018_02_01.models.FileSystemHttpLogsConfig
    :ivar azure_blob_storage: Http logs to azure blob storage configuration.
    :vartype azure_blob_storage: ~azure.mgmt.web.v2018_02_01.models.AzureBlobStorageHttpLogsConfig
    """

    _attribute_map = {
        "file_system": {"key": "fileSystem", "type": "FileSystemHttpLogsConfig"},
        "azure_blob_storage": {"key": "azureBlobStorage", "type": "AzureBlobStorageHttpLogsConfig"},
    }

    def __init__(
        self,
        *,
        file_system: Optional["_models.FileSystemHttpLogsConfig"] = None,
        azure_blob_storage: Optional["_models.AzureBlobStorageHttpLogsConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword file_system: Http logs to file system configuration.
        :paramtype file_system: ~azure.mgmt.web.v2018_02_01.models.FileSystemHttpLogsConfig
        :keyword azure_blob_storage: Http logs to azure blob storage configuration.
        :paramtype azure_blob_storage:
         ~azure.mgmt.web.v2018_02_01.models.AzureBlobStorageHttpLogsConfig
        """
        super().__init__(**kwargs)
        self.file_system = file_system
        self.azure_blob_storage = azure_blob_storage


class HybridConnection(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Hybrid Connection contract. This is used to configure a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_bus_namespace: The name of the Service Bus namespace.
    :vartype service_bus_namespace: str
    :ivar relay_name: The name of the Service Bus relay.
    :vartype relay_name: str
    :ivar relay_arm_uri: The ARM URI to the Service Bus relay.
    :vartype relay_arm_uri: str
    :ivar hostname: The hostname of the endpoint.
    :vartype hostname: str
    :ivar port: The port of the endpoint.
    :vartype port: int
    :ivar send_key_name: The name of the Service Bus key which has Send permissions. This is used
     to authenticate to Service Bus.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the Service Bus key. This is used to authenticate to Service
     Bus. In ARM this key will not be returned
     normally, use the POST /listKeys API instead.
    :vartype send_key_value: str
    :ivar service_bus_suffix: The suffix for the service bus endpoint. By default this is
     .servicebus.windows.net.
    :vartype service_bus_suffix: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "service_bus_namespace": {"key": "properties.serviceBusNamespace", "type": "str"},
        "relay_name": {"key": "properties.relayName", "type": "str"},
        "relay_arm_uri": {"key": "properties.relayArmUri", "type": "str"},
        "hostname": {"key": "properties.hostname", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "send_key_name": {"key": "properties.sendKeyName", "type": "str"},
        "send_key_value": {"key": "properties.sendKeyValue", "type": "str"},
        "service_bus_suffix": {"key": "properties.serviceBusSuffix", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        service_bus_namespace: Optional[str] = None,
        relay_name: Optional[str] = None,
        relay_arm_uri: Optional[str] = None,
        hostname: Optional[str] = None,
        port: Optional[int] = None,
        send_key_name: Optional[str] = None,
        send_key_value: Optional[str] = None,
        service_bus_suffix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword service_bus_namespace: The name of the Service Bus namespace.
        :paramtype service_bus_namespace: str
        :keyword relay_name: The name of the Service Bus relay.
        :paramtype relay_name: str
        :keyword relay_arm_uri: The ARM URI to the Service Bus relay.
        :paramtype relay_arm_uri: str
        :keyword hostname: The hostname of the endpoint.
        :paramtype hostname: str
        :keyword port: The port of the endpoint.
        :paramtype port: int
        :keyword send_key_name: The name of the Service Bus key which has Send permissions. This is
         used to authenticate to Service Bus.
        :paramtype send_key_name: str
        :keyword send_key_value: The value of the Service Bus key. This is used to authenticate to
         Service Bus. In ARM this key will not be returned
         normally, use the POST /listKeys API instead.
        :paramtype send_key_value: str
        :keyword service_bus_suffix: The suffix for the service bus endpoint. By default this is
         .servicebus.windows.net.
        :paramtype service_bus_suffix: str
        """
        super().__init__(kind=kind, **kwargs)
        self.service_bus_namespace = service_bus_namespace
        self.relay_name = relay_name
        self.relay_arm_uri = relay_arm_uri
        self.hostname = hostname
        self.port = port
        self.send_key_name = send_key_name
        self.send_key_value = send_key_value
        self.service_bus_suffix = service_bus_suffix


class HybridConnectionCollection(_serialization.Model):
    """Collection of hostname bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.HybridConnection]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HybridConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.HybridConnection"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.HybridConnection]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class HybridConnectionKey(ProxyOnlyResource):
    """Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar send_key_name: The name of the send key.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the send key.
    :vartype send_key_value: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "send_key_name": {"readonly": True},
        "send_key_value": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "send_key_name": {"key": "properties.sendKeyName", "type": "str"},
        "send_key_value": {"key": "properties.sendKeyValue", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.send_key_name = None
        self.send_key_value = None


class HybridConnectionLimits(ProxyOnlyResource):
    """Hybrid Connection limits contract. This is used to return the plan limits of Hybrid
    Connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar current: The current number of Hybrid Connections.
    :vartype current: int
    :ivar maximum: The maximum number of Hybrid Connections allowed.
    :vartype maximum: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "current": {"readonly": True},
        "maximum": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "current": {"key": "properties.current", "type": "int"},
        "maximum": {"key": "properties.maximum", "type": "int"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.current = None
        self.maximum = None


class Identifier(ProxyOnlyResource):
    """A domain specific resource identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar id_properties_id: String representation of the identity.
    :vartype id_properties_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "id_properties_id": {"key": "properties.id", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, id_properties_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword id_properties_id: String representation of the identity.
        :paramtype id_properties_id: str
        """
        super().__init__(kind=kind, **kwargs)
        self.id_properties_id = id_properties_id


class IdentifierCollection(_serialization.Model):
    """Collection of identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.Identifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Identifier]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Identifier"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.Identifier]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class InboundEnvironmentEndpoint(_serialization.Model):
    """The IP Addresses and Ports that require inbound network access to and within the subnet of the
    App Service Environment.

    :ivar description: Short text describing the purpose of the network traffic.
    :vartype description: str
    :ivar endpoints: The IP addresses that network traffic will originate from in cidr notation.
    :vartype endpoints: list[str]
    :ivar ports: The ports that network traffic will arrive to the App Service Environment at.
    :vartype ports: list[str]
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "endpoints": {"key": "endpoints", "type": "[str]"},
        "ports": {"key": "ports", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        endpoints: Optional[List[str]] = None,
        ports: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Short text describing the purpose of the network traffic.
        :paramtype description: str
        :keyword endpoints: The IP addresses that network traffic will originate from in cidr notation.
        :paramtype endpoints: list[str]
        :keyword ports: The ports that network traffic will arrive to the App Service Environment at.
        :paramtype ports: list[str]
        """
        super().__init__(**kwargs)
        self.description = description
        self.endpoints = endpoints
        self.ports = ports


class InboundEnvironmentEndpointCollection(_serialization.Model):
    """Collection of Inbound Environment Endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.InboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[InboundEnvironmentEndpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.InboundEnvironmentEndpoint"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.InboundEnvironmentEndpoint]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class IpSecurityRestriction(_serialization.Model):
    """IP security restriction on an app.

    :ivar ip_address: IP address the security restriction is valid for.
     It can be in form of pure ipv4 address (required SubnetMask property) or
     CIDR notation such as ipv4/mask (leading bit match). For CIDR,
     SubnetMask property must not be specified.
    :vartype ip_address: str
    :ivar subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
    :vartype subnet_mask: str
    :ivar vnet_subnet_resource_id: Virtual network resource id.
    :vartype vnet_subnet_resource_id: str
    :ivar vnet_traffic_tag: (internal) Vnet traffic tag.
    :vartype vnet_traffic_tag: int
    :ivar subnet_traffic_tag: (internal) Subnet traffic tag.
    :vartype subnet_traffic_tag: int
    :ivar action: Allow or Deny access for this IP range.
    :vartype action: str
    :ivar tag: Defines what this IP filter will be used for. This is to support IP filtering on
     proxies. Known values are: "Default" and "XffProxy".
    :vartype tag: str or ~azure.mgmt.web.v2018_02_01.models.IpFilterTag
    :ivar priority: Priority of IP restriction rule.
    :vartype priority: int
    :ivar name: IP restriction rule name.
    :vartype name: str
    :ivar description: IP restriction rule description.
    :vartype description: str
    """

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "subnet_mask": {"key": "subnetMask", "type": "str"},
        "vnet_subnet_resource_id": {"key": "vnetSubnetResourceId", "type": "str"},
        "vnet_traffic_tag": {"key": "vnetTrafficTag", "type": "int"},
        "subnet_traffic_tag": {"key": "subnetTrafficTag", "type": "int"},
        "action": {"key": "action", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        subnet_mask: Optional[str] = None,
        vnet_subnet_resource_id: Optional[str] = None,
        vnet_traffic_tag: Optional[int] = None,
        subnet_traffic_tag: Optional[int] = None,
        action: Optional[str] = None,
        tag: Optional[Union[str, "_models.IpFilterTag"]] = None,
        priority: Optional[int] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_address: IP address the security restriction is valid for.
         It can be in form of pure ipv4 address (required SubnetMask property) or
         CIDR notation such as ipv4/mask (leading bit match). For CIDR,
         SubnetMask property must not be specified.
        :paramtype ip_address: str
        :keyword subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
        :paramtype subnet_mask: str
        :keyword vnet_subnet_resource_id: Virtual network resource id.
        :paramtype vnet_subnet_resource_id: str
        :keyword vnet_traffic_tag: (internal) Vnet traffic tag.
        :paramtype vnet_traffic_tag: int
        :keyword subnet_traffic_tag: (internal) Subnet traffic tag.
        :paramtype subnet_traffic_tag: int
        :keyword action: Allow or Deny access for this IP range.
        :paramtype action: str
        :keyword tag: Defines what this IP filter will be used for. This is to support IP filtering on
         proxies. Known values are: "Default" and "XffProxy".
        :paramtype tag: str or ~azure.mgmt.web.v2018_02_01.models.IpFilterTag
        :keyword priority: Priority of IP restriction rule.
        :paramtype priority: int
        :keyword name: IP restriction rule name.
        :paramtype name: str
        :keyword description: IP restriction rule description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.ip_address = ip_address
        self.subnet_mask = subnet_mask
        self.vnet_subnet_resource_id = vnet_subnet_resource_id
        self.vnet_traffic_tag = vnet_traffic_tag
        self.subnet_traffic_tag = subnet_traffic_tag
        self.action = action
        self.tag = tag
        self.priority = priority
        self.name = name
        self.description = description


class KeyInfo(_serialization.Model):
    """Function key info.

    :ivar name: Key name.
    :vartype name: str
    :ivar value: Key value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Key name.
        :paramtype name: str
        :keyword value: Key value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class LocalizableString(_serialization.Model):
    """Localizable string object containing the name and a localized value.

    :ivar value: Non-localized name.
    :vartype value: str
    :ivar localized_value: Localized name.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Non-localized name.
        :paramtype value: str
        :keyword localized_value: Localized name.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class LogSpecification(_serialization.Model):
    """Log Definition of a single resource metric.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar blob_duration:
    :vartype blob_duration: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword blob_duration:
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Type of managed service identity. Known values are: "SystemAssigned",
     "UserAssigned", "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.web.v2018_02_01.models.ManagedServiceIdentityType
    :ivar tenant_id: Tenant of managed service identity.
    :vartype tenant_id: str
    :ivar principal_id: Principal Id of managed service identity.
    :vartype principal_id: str
    :ivar user_assigned_identities: The list of user assigned identities associated with the
     resource. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.web.v2018_02_01.models.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties]
    """

    _validation = {
        "tenant_id": {"readonly": True},
        "principal_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "user_assigned_identities": {
            "key": "userAssignedIdentities",
            "type": "{Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties}",
        },
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = None,
        user_assigned_identities: Optional[
            Dict[
                str,
                "_models.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties",
            ]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity. Known values are: "SystemAssigned",
         "UserAssigned", "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.web.v2018_02_01.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The list of user assigned identities associated with the
         resource. The user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.web.v2018_02_01.models.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties]
        """
        super().__init__(**kwargs)
        self.type = type
        self.tenant_id = None
        self.principal_id = None
        self.user_assigned_identities = user_assigned_identities


class MetricAvailabilily(_serialization.Model):
    """Metric availability and retention.

    :ivar time_grain: Time grain.
    :vartype time_grain: str
    :ivar retention: Retention period for the current time grain.
    :vartype retention: str
    """

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "retention": {"key": "retention", "type": "str"},
    }

    def __init__(self, *, time_grain: Optional[str] = None, retention: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword time_grain: Time grain.
        :paramtype time_grain: str
        :keyword retention: Retention period for the current time grain.
        :paramtype retention: str
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.retention = retention


class MetricAvailability(_serialization.Model):
    """Retention policy of a resource metric.

    :ivar time_grain:
    :vartype time_grain: str
    :ivar blob_duration:
    :vartype blob_duration: str
    """

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(self, *, time_grain: Optional[str] = None, blob_duration: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword time_grain:
        :paramtype time_grain: str
        :keyword blob_duration:
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.blob_duration = blob_duration


class MetricDefinition(ProxyOnlyResource):
    """Metadata for a metric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar primary_aggregation_type: Primary aggregation type.
    :vartype primary_aggregation_type: str
    :ivar metric_availabilities: List of time grains supported for the metric together with
     retention period.
    :vartype metric_availabilities: list[~azure.mgmt.web.v2018_02_01.models.MetricAvailabilily]
    :ivar display_name: Friendly name shown in the UI.
    :vartype display_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "unit": {"readonly": True},
        "primary_aggregation_type": {"readonly": True},
        "metric_availabilities": {"readonly": True},
        "display_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "unit": {"key": "properties.unit", "type": "str"},
        "primary_aggregation_type": {"key": "properties.primaryAggregationType", "type": "str"},
        "metric_availabilities": {"key": "properties.metricAvailabilities", "type": "[MetricAvailabilily]"},
        "display_name": {"key": "properties.displayName", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.unit = None
        self.primary_aggregation_type = None
        self.metric_availabilities = None
        self.display_name = None


class MetricSpecification(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Definition of a single resource metric.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar display_description:
    :vartype display_description: str
    :ivar unit:
    :vartype unit: str
    :ivar aggregation_type:
    :vartype aggregation_type: str
    :ivar supports_instance_level_aggregation:
    :vartype supports_instance_level_aggregation: bool
    :ivar enable_regional_mdm_account:
    :vartype enable_regional_mdm_account: bool
    :ivar source_mdm_account:
    :vartype source_mdm_account: str
    :ivar source_mdm_namespace:
    :vartype source_mdm_namespace: str
    :ivar metric_filter_pattern:
    :vartype metric_filter_pattern: str
    :ivar fill_gap_with_zero:
    :vartype fill_gap_with_zero: bool
    :ivar is_internal:
    :vartype is_internal: bool
    :ivar dimensions:
    :vartype dimensions: list[~azure.mgmt.web.v2018_02_01.models.Dimension]
    :ivar category:
    :vartype category: str
    :ivar availabilities:
    :vartype availabilities: list[~azure.mgmt.web.v2018_02_01.models.MetricAvailability]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "supports_instance_level_aggregation": {"key": "supportsInstanceLevelAggregation", "type": "bool"},
        "enable_regional_mdm_account": {"key": "enableRegionalMdmAccount", "type": "bool"},
        "source_mdm_account": {"key": "sourceMdmAccount", "type": "str"},
        "source_mdm_namespace": {"key": "sourceMdmNamespace", "type": "str"},
        "metric_filter_pattern": {"key": "metricFilterPattern", "type": "str"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "is_internal": {"key": "isInternal", "type": "bool"},
        "dimensions": {"key": "dimensions", "type": "[Dimension]"},
        "category": {"key": "category", "type": "str"},
        "availabilities": {"key": "availabilities", "type": "[MetricAvailability]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supports_instance_level_aggregation: Optional[bool] = None,
        enable_regional_mdm_account: Optional[bool] = None,
        source_mdm_account: Optional[str] = None,
        source_mdm_namespace: Optional[str] = None,
        metric_filter_pattern: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        is_internal: Optional[bool] = None,
        dimensions: Optional[List["_models.Dimension"]] = None,
        category: Optional[str] = None,
        availabilities: Optional[List["_models.MetricAvailability"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword display_description:
        :paramtype display_description: str
        :keyword unit:
        :paramtype unit: str
        :keyword aggregation_type:
        :paramtype aggregation_type: str
        :keyword supports_instance_level_aggregation:
        :paramtype supports_instance_level_aggregation: bool
        :keyword enable_regional_mdm_account:
        :paramtype enable_regional_mdm_account: bool
        :keyword source_mdm_account:
        :paramtype source_mdm_account: str
        :keyword source_mdm_namespace:
        :paramtype source_mdm_namespace: str
        :keyword metric_filter_pattern:
        :paramtype metric_filter_pattern: str
        :keyword fill_gap_with_zero:
        :paramtype fill_gap_with_zero: bool
        :keyword is_internal:
        :paramtype is_internal: bool
        :keyword dimensions:
        :paramtype dimensions: list[~azure.mgmt.web.v2018_02_01.models.Dimension]
        :keyword category:
        :paramtype category: str
        :keyword availabilities:
        :paramtype availabilities: list[~azure.mgmt.web.v2018_02_01.models.MetricAvailability]
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.supports_instance_level_aggregation = supports_instance_level_aggregation
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace
        self.metric_filter_pattern = metric_filter_pattern
        self.fill_gap_with_zero = fill_gap_with_zero
        self.is_internal = is_internal
        self.dimensions = dimensions
        self.category = category
        self.availabilities = availabilities


class MigrateMySqlRequest(ProxyOnlyResource):
    """MySQL migration request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar connection_string: Connection string to the remote MySQL database.
    :vartype connection_string: str
    :ivar migration_type: The type of migration operation to be done. Known values are:
     "LocalToRemote" and "RemoteToLocal".
    :vartype migration_type: str or ~azure.mgmt.web.v2018_02_01.models.MySqlMigrationType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "connection_string": {"key": "properties.connectionString", "type": "str"},
        "migration_type": {"key": "properties.migrationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        connection_string: Optional[str] = None,
        migration_type: Optional[Union[str, "_models.MySqlMigrationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword connection_string: Connection string to the remote MySQL database.
        :paramtype connection_string: str
        :keyword migration_type: The type of migration operation to be done. Known values are:
         "LocalToRemote" and "RemoteToLocal".
        :paramtype migration_type: str or ~azure.mgmt.web.v2018_02_01.models.MySqlMigrationType
        """
        super().__init__(kind=kind, **kwargs)
        self.connection_string = connection_string
        self.migration_type = migration_type


class MigrateMySqlStatus(ProxyOnlyResource):
    """MySQL migration status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar migration_operation_status: Status of the migration task. Known values are: "InProgress",
     "Failed", "Succeeded", "TimedOut", and "Created".
    :vartype migration_operation_status: str or ~azure.mgmt.web.v2018_02_01.models.OperationStatus
    :ivar operation_id: Operation ID for the migration task.
    :vartype operation_id: str
    :ivar local_my_sql_enabled: True if the web app has in app MySql enabled.
    :vartype local_my_sql_enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "migration_operation_status": {"readonly": True},
        "operation_id": {"readonly": True},
        "local_my_sql_enabled": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "migration_operation_status": {"key": "properties.migrationOperationStatus", "type": "str"},
        "operation_id": {"key": "properties.operationId", "type": "str"},
        "local_my_sql_enabled": {"key": "properties.localMySqlEnabled", "type": "bool"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.migration_operation_status = None
        self.operation_id = None
        self.local_my_sql_enabled = None


class MSDeploy(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """MSDeploy ARM PUT information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar package_uri: Package URI.
    :vartype package_uri: str
    :ivar connection_string: SQL Connection String.
    :vartype connection_string: str
    :ivar db_type: Database Type.
    :vartype db_type: str
    :ivar set_parameters_xml_file_uri: URI of MSDeploy Parameters file. Must not be set if
     SetParameters is used.
    :vartype set_parameters_xml_file_uri: str
    :ivar set_parameters: MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is used.
    :vartype set_parameters: dict[str, str]
    :ivar skip_app_data: Controls whether the MSDeploy operation skips the App_Data directory.
     If set to :code:`<code>true</code>`, the existing App_Data directory on the destination
     will not be deleted, and any App_Data directory in the source will be ignored.
     Setting is :code:`<code>false</code>` by default.
    :vartype skip_app_data: bool
    :ivar app_offline: Sets the AppOffline rule while the MSDeploy operation executes.
     Setting is :code:`<code>false</code>` by default.
    :vartype app_offline: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "package_uri": {"key": "properties.packageUri", "type": "str"},
        "connection_string": {"key": "properties.connectionString", "type": "str"},
        "db_type": {"key": "properties.dbType", "type": "str"},
        "set_parameters_xml_file_uri": {"key": "properties.setParametersXmlFileUri", "type": "str"},
        "set_parameters": {"key": "properties.setParameters", "type": "{str}"},
        "skip_app_data": {"key": "properties.skipAppData", "type": "bool"},
        "app_offline": {"key": "properties.appOffline", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        package_uri: Optional[str] = None,
        connection_string: Optional[str] = None,
        db_type: Optional[str] = None,
        set_parameters_xml_file_uri: Optional[str] = None,
        set_parameters: Optional[Dict[str, str]] = None,
        skip_app_data: Optional[bool] = None,
        app_offline: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword package_uri: Package URI.
        :paramtype package_uri: str
        :keyword connection_string: SQL Connection String.
        :paramtype connection_string: str
        :keyword db_type: Database Type.
        :paramtype db_type: str
        :keyword set_parameters_xml_file_uri: URI of MSDeploy Parameters file. Must not be set if
         SetParameters is used.
        :paramtype set_parameters_xml_file_uri: str
        :keyword set_parameters: MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is
         used.
        :paramtype set_parameters: dict[str, str]
        :keyword skip_app_data: Controls whether the MSDeploy operation skips the App_Data directory.
         If set to :code:`<code>true</code>`, the existing App_Data directory on the destination
         will not be deleted, and any App_Data directory in the source will be ignored.
         Setting is :code:`<code>false</code>` by default.
        :paramtype skip_app_data: bool
        :keyword app_offline: Sets the AppOffline rule while the MSDeploy operation executes.
         Setting is :code:`<code>false</code>` by default.
        :paramtype app_offline: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.package_uri = package_uri
        self.connection_string = connection_string
        self.db_type = db_type
        self.set_parameters_xml_file_uri = set_parameters_xml_file_uri
        self.set_parameters = set_parameters
        self.skip_app_data = skip_app_data
        self.app_offline = app_offline


class MSDeployLog(ProxyOnlyResource):
    """MSDeploy log.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar entries: List of log entry messages.
    :vartype entries: list[~azure.mgmt.web.v2018_02_01.models.MSDeployLogEntry]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "entries": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "entries": {"key": "properties.entries", "type": "[MSDeployLogEntry]"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.entries = None


class MSDeployLogEntry(_serialization.Model):
    """MSDeploy log entry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time: Timestamp of log entry.
    :vartype time: ~datetime.datetime
    :ivar type: Log entry type. Known values are: "Message", "Warning", and "Error".
    :vartype type: str or ~azure.mgmt.web.v2018_02_01.models.MSDeployLogEntryType
    :ivar message: Log entry message.
    :vartype message: str
    """

    _validation = {
        "time": {"readonly": True},
        "type": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "time": {"key": "time", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.time = None
        self.type = None
        self.message = None


class MSDeployStatus(ProxyOnlyResource):
    """MSDeploy ARM response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deployer: Username of deployer.
    :vartype deployer: str
    :ivar provisioning_state: Provisioning state. Known values are: "accepted", "running",
     "succeeded", "failed", and "canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2018_02_01.models.MSDeployProvisioningState
    :ivar start_time: Start time of deploy operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of deploy operation.
    :vartype end_time: ~datetime.datetime
    :ivar complete: Whether the deployment operation has completed.
    :vartype complete: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "deployer": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "complete": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "deployer": {"key": "properties.deployer", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
        "complete": {"key": "properties.complete", "type": "bool"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.deployer = None
        self.provisioning_state = None
        self.start_time = None
        self.end_time = None
        self.complete = None


class NameIdentifier(_serialization.Model):
    """Identifies an object.

    :ivar name: Name of the object.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the object.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class NameIdentifierCollection(_serialization.Model):
    """Collection of domain name identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.NameIdentifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NameIdentifier]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.NameIdentifier"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.NameIdentifier]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class NameValuePair(_serialization.Model):
    """Name value pair.

    :ivar name: Pair name.
    :vartype name: str
    :ivar value: Pair value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Pair name.
        :paramtype name: str
        :keyword value: Pair value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class NetworkAccessControlEntry(_serialization.Model):
    """Network access control entry.

    :ivar action: Action object. Known values are: "Permit" and "Deny".
    :vartype action: str or ~azure.mgmt.web.v2018_02_01.models.AccessControlEntryAction
    :ivar description: Description of network access control entry.
    :vartype description: str
    :ivar order: Order of precedence.
    :vartype order: int
    :ivar remote_subnet: Remote subnet.
    :vartype remote_subnet: str
    """

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "order": {"key": "order", "type": "int"},
        "remote_subnet": {"key": "remoteSubnet", "type": "str"},
    }

    def __init__(
        self,
        *,
        action: Optional[Union[str, "_models.AccessControlEntryAction"]] = None,
        description: Optional[str] = None,
        order: Optional[int] = None,
        remote_subnet: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action: Action object. Known values are: "Permit" and "Deny".
        :paramtype action: str or ~azure.mgmt.web.v2018_02_01.models.AccessControlEntryAction
        :keyword description: Description of network access control entry.
        :paramtype description: str
        :keyword order: Order of precedence.
        :paramtype order: int
        :keyword remote_subnet: Remote subnet.
        :paramtype remote_subnet: str
        """
        super().__init__(**kwargs)
        self.action = action
        self.description = description
        self.order = order
        self.remote_subnet = remote_subnet


class NetworkFeatures(ProxyOnlyResource):
    """Full view of network features for an app (presently VNET integration and Hybrid Connections).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar virtual_network_name: The Virtual Network name.
    :vartype virtual_network_name: str
    :ivar virtual_network_connection: The Virtual Network summary view.
    :vartype virtual_network_connection: ~azure.mgmt.web.v2018_02_01.models.VnetInfo
    :ivar hybrid_connections: The Hybrid Connections summary view.
    :vartype hybrid_connections:
     list[~azure.mgmt.web.v2018_02_01.models.RelayServiceConnectionEntity]
    :ivar hybrid_connections_v2: The Hybrid Connection V2 (Service Bus) view.
    :vartype hybrid_connections_v2: list[~azure.mgmt.web.v2018_02_01.models.HybridConnection]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "virtual_network_name": {"readonly": True},
        "virtual_network_connection": {"readonly": True},
        "hybrid_connections": {"readonly": True},
        "hybrid_connections_v2": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "virtual_network_name": {"key": "properties.virtualNetworkName", "type": "str"},
        "virtual_network_connection": {"key": "properties.virtualNetworkConnection", "type": "VnetInfo"},
        "hybrid_connections": {"key": "properties.hybridConnections", "type": "[RelayServiceConnectionEntity]"},
        "hybrid_connections_v2": {"key": "properties.hybridConnectionsV2", "type": "[HybridConnection]"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.virtual_network_name = None
        self.virtual_network_connection = None
        self.hybrid_connections = None
        self.hybrid_connections_v2 = None


class NetworkTrace(_serialization.Model):
    """Network trace.

    :ivar path: Local file path for the captured network trace file.
    :vartype path: str
    :ivar status: Current status of the network trace operation, same as Operation.Status
     (InProgress/Succeeded/Failed).
    :vartype status: str
    :ivar message: Detailed message of a network trace operation, e.g. error message in case of
     failure.
    :vartype message: str
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, path: Optional[str] = None, status: Optional[str] = None, message: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword path: Local file path for the captured network trace file.
        :paramtype path: str
        :keyword status: Current status of the network trace operation, same as Operation.Status
         (InProgress/Succeeded/Failed).
        :paramtype status: str
        :keyword message: Detailed message of a network trace operation, e.g. error message in case of
         failure.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.path = path
        self.status = status
        self.message = message


class Operation(_serialization.Model):
    """An operation on a resource.

    :ivar id: Operation ID.
    :vartype id: str
    :ivar name: Operation name.
    :vartype name: str
    :ivar status: The current status of the operation. Known values are: "InProgress", "Failed",
     "Succeeded", "TimedOut", and "Created".
    :vartype status: str or ~azure.mgmt.web.v2018_02_01.models.OperationStatus
    :ivar errors: Any errors associate with the operation.
    :vartype errors: list[~azure.mgmt.web.v2018_02_01.models.ErrorEntity]
    :ivar created_time: Time when operation has started.
    :vartype created_time: ~datetime.datetime
    :ivar modified_time: Time when operation has been updated.
    :vartype modified_time: ~datetime.datetime
    :ivar expiration_time: Time when operation will expire.
    :vartype expiration_time: ~datetime.datetime
    :ivar geo_master_operation_id: Applicable only for stamp operation ids.
    :vartype geo_master_operation_id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "errors": {"key": "errors", "type": "[ErrorEntity]"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "modified_time": {"key": "modifiedTime", "type": "iso-8601"},
        "expiration_time": {"key": "expirationTime", "type": "iso-8601"},
        "geo_master_operation_id": {"key": "geoMasterOperationId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        status: Optional[Union[str, "_models.OperationStatus"]] = None,
        errors: Optional[List["_models.ErrorEntity"]] = None,
        created_time: Optional[datetime.datetime] = None,
        modified_time: Optional[datetime.datetime] = None,
        expiration_time: Optional[datetime.datetime] = None,
        geo_master_operation_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Operation ID.
        :paramtype id: str
        :keyword name: Operation name.
        :paramtype name: str
        :keyword status: The current status of the operation. Known values are: "InProgress", "Failed",
         "Succeeded", "TimedOut", and "Created".
        :paramtype status: str or ~azure.mgmt.web.v2018_02_01.models.OperationStatus
        :keyword errors: Any errors associate with the operation.
        :paramtype errors: list[~azure.mgmt.web.v2018_02_01.models.ErrorEntity]
        :keyword created_time: Time when operation has started.
        :paramtype created_time: ~datetime.datetime
        :keyword modified_time: Time when operation has been updated.
        :paramtype modified_time: ~datetime.datetime
        :keyword expiration_time: Time when operation will expire.
        :paramtype expiration_time: ~datetime.datetime
        :keyword geo_master_operation_id: Applicable only for stamp operation ids.
        :paramtype geo_master_operation_id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.errors = errors
        self.created_time = created_time
        self.modified_time = modified_time
        self.expiration_time = expiration_time
        self.geo_master_operation_id = geo_master_operation_id


class OutboundEnvironmentEndpoint(_serialization.Model):
    """Endpoints accessed for a common purpose that the App Service Environment requires outbound
    network access to.

    :ivar category: The type of service accessed by the App Service Environment, e.g., Azure
     Storage, Azure SQL Database, and Azure Active Directory.
    :vartype category: str
    :ivar endpoints: The endpoints that the App Service Environment reaches the service at.
    :vartype endpoints: list[~azure.mgmt.web.v2018_02_01.models.EndpointDependency]
    """

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "endpoints": {"key": "endpoints", "type": "[EndpointDependency]"},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        endpoints: Optional[List["_models.EndpointDependency"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: The type of service accessed by the App Service Environment, e.g., Azure
         Storage, Azure SQL Database, and Azure Active Directory.
        :paramtype category: str
        :keyword endpoints: The endpoints that the App Service Environment reaches the service at.
        :paramtype endpoints: list[~azure.mgmt.web.v2018_02_01.models.EndpointDependency]
        """
        super().__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints


class OutboundEnvironmentEndpointCollection(_serialization.Model):
    """Collection of Outbound Environment Endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.OutboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OutboundEnvironmentEndpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.OutboundEnvironmentEndpoint"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.OutboundEnvironmentEndpoint]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PerfMonCounterCollection(_serialization.Model):
    """Collection of performance monitor counters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.PerfMonResponse]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PerfMonResponse]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.PerfMonResponse"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.PerfMonResponse]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PerfMonResponse(_serialization.Model):
    """Performance monitor API response.

    :ivar code: The response code.
    :vartype code: str
    :ivar message: The message.
    :vartype message: str
    :ivar data: The performance monitor counters.
    :vartype data: ~azure.mgmt.web.v2018_02_01.models.PerfMonSet
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "data": {"key": "data", "type": "PerfMonSet"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        data: Optional["_models.PerfMonSet"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: The response code.
        :paramtype code: str
        :keyword message: The message.
        :paramtype message: str
        :keyword data: The performance monitor counters.
        :paramtype data: ~azure.mgmt.web.v2018_02_01.models.PerfMonSet
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.data = data


class PerfMonSample(_serialization.Model):
    """Performance monitor sample in a set.

    :ivar time: Point in time for which counter was measured.
    :vartype time: ~datetime.datetime
    :ivar instance_name: Name of the server on which the measurement is made.
    :vartype instance_name: str
    :ivar value: Value of counter at a certain time.
    :vartype value: float
    """

    _attribute_map = {
        "time": {"key": "time", "type": "iso-8601"},
        "instance_name": {"key": "instanceName", "type": "str"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(
        self,
        *,
        time: Optional[datetime.datetime] = None,
        instance_name: Optional[str] = None,
        value: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time: Point in time for which counter was measured.
        :paramtype time: ~datetime.datetime
        :keyword instance_name: Name of the server on which the measurement is made.
        :paramtype instance_name: str
        :keyword value: Value of counter at a certain time.
        :paramtype value: float
        """
        super().__init__(**kwargs)
        self.time = time
        self.instance_name = instance_name
        self.value = value


class PerfMonSet(_serialization.Model):
    """Metric information.

    :ivar name: Unique key name of the counter.
    :vartype name: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar time_grain: Presented time grain.
    :vartype time_grain: str
    :ivar values: Collection of workers that are active during this time.
    :vartype values: list[~azure.mgmt.web.v2018_02_01.models.PerfMonSample]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "time_grain": {"key": "timeGrain", "type": "str"},
        "values": {"key": "values", "type": "[PerfMonSample]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        values: Optional[List["_models.PerfMonSample"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Unique key name of the counter.
        :paramtype name: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword time_grain: Presented time grain.
        :paramtype time_grain: str
        :keyword values: Collection of workers that are active during this time.
        :paramtype values: list[~azure.mgmt.web.v2018_02_01.models.PerfMonSample]
        """
        super().__init__(**kwargs)
        self.name = name
        self.start_time = start_time
        self.end_time = end_time
        self.time_grain = time_grain
        self.values = values


class PremierAddOn(Resource):  # pylint: disable=too-many-instance-attributes
    """Premier add-on.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Premier add on SKU.
    :vartype sku: str
    :ivar product: Premier add on Product.
    :vartype product: str
    :ivar vendor: Premier add on Vendor.
    :vartype vendor: str
    :ivar marketplace_publisher: Premier add on Marketplace publisher.
    :vartype marketplace_publisher: str
    :ivar marketplace_offer: Premier add on Marketplace offer.
    :vartype marketplace_offer: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "properties.sku", "type": "str"},
        "product": {"key": "properties.product", "type": "str"},
        "vendor": {"key": "properties.vendor", "type": "str"},
        "marketplace_publisher": {"key": "properties.marketplacePublisher", "type": "str"},
        "marketplace_offer": {"key": "properties.marketplaceOffer", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional[str] = None,
        product: Optional[str] = None,
        vendor: Optional[str] = None,
        marketplace_publisher: Optional[str] = None,
        marketplace_offer: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Premier add on SKU.
        :paramtype sku: str
        :keyword product: Premier add on Product.
        :paramtype product: str
        :keyword vendor: Premier add on Vendor.
        :paramtype vendor: str
        :keyword marketplace_publisher: Premier add on Marketplace publisher.
        :paramtype marketplace_publisher: str
        :keyword marketplace_offer: Premier add on Marketplace offer.
        :paramtype marketplace_offer: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.product = product
        self.vendor = vendor
        self.marketplace_publisher = marketplace_publisher
        self.marketplace_offer = marketplace_offer


class PremierAddOnOffer(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Premier add-on offer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar sku: Premier add on SKU.
    :vartype sku: str
    :ivar product: Premier add on offer Product.
    :vartype product: str
    :ivar vendor: Premier add on offer Vendor.
    :vartype vendor: str
    :ivar promo_code_required: :code:`<code>true</code>` if promotion code is required; otherwise,
     :code:`<code>false</code>`.
    :vartype promo_code_required: bool
    :ivar quota: Premier add on offer Quota.
    :vartype quota: int
    :ivar web_hosting_plan_restrictions: App Service plans this offer is restricted to. Known
     values are: "None", "Free", "Shared", "Basic", "Standard", and "Premium".
    :vartype web_hosting_plan_restrictions: str or
     ~azure.mgmt.web.v2018_02_01.models.AppServicePlanRestrictions
    :ivar privacy_policy_url: Privacy policy URL.
    :vartype privacy_policy_url: str
    :ivar legal_terms_url: Legal terms URL.
    :vartype legal_terms_url: str
    :ivar marketplace_publisher: Marketplace publisher.
    :vartype marketplace_publisher: str
    :ivar marketplace_offer: Marketplace offer.
    :vartype marketplace_offer: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku": {"key": "properties.sku", "type": "str"},
        "product": {"key": "properties.product", "type": "str"},
        "vendor": {"key": "properties.vendor", "type": "str"},
        "promo_code_required": {"key": "properties.promoCodeRequired", "type": "bool"},
        "quota": {"key": "properties.quota", "type": "int"},
        "web_hosting_plan_restrictions": {"key": "properties.webHostingPlanRestrictions", "type": "str"},
        "privacy_policy_url": {"key": "properties.privacyPolicyUrl", "type": "str"},
        "legal_terms_url": {"key": "properties.legalTermsUrl", "type": "str"},
        "marketplace_publisher": {"key": "properties.marketplacePublisher", "type": "str"},
        "marketplace_offer": {"key": "properties.marketplaceOffer", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        sku: Optional[str] = None,
        product: Optional[str] = None,
        vendor: Optional[str] = None,
        promo_code_required: Optional[bool] = None,
        quota: Optional[int] = None,
        web_hosting_plan_restrictions: Optional[Union[str, "_models.AppServicePlanRestrictions"]] = None,
        privacy_policy_url: Optional[str] = None,
        legal_terms_url: Optional[str] = None,
        marketplace_publisher: Optional[str] = None,
        marketplace_offer: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword sku: Premier add on SKU.
        :paramtype sku: str
        :keyword product: Premier add on offer Product.
        :paramtype product: str
        :keyword vendor: Premier add on offer Vendor.
        :paramtype vendor: str
        :keyword promo_code_required: :code:`<code>true</code>` if promotion code is required;
         otherwise, :code:`<code>false</code>`.
        :paramtype promo_code_required: bool
        :keyword quota: Premier add on offer Quota.
        :paramtype quota: int
        :keyword web_hosting_plan_restrictions: App Service plans this offer is restricted to. Known
         values are: "None", "Free", "Shared", "Basic", "Standard", and "Premium".
        :paramtype web_hosting_plan_restrictions: str or
         ~azure.mgmt.web.v2018_02_01.models.AppServicePlanRestrictions
        :keyword privacy_policy_url: Privacy policy URL.
        :paramtype privacy_policy_url: str
        :keyword legal_terms_url: Legal terms URL.
        :paramtype legal_terms_url: str
        :keyword marketplace_publisher: Marketplace publisher.
        :paramtype marketplace_publisher: str
        :keyword marketplace_offer: Marketplace offer.
        :paramtype marketplace_offer: str
        """
        super().__init__(kind=kind, **kwargs)
        self.sku = sku
        self.product = product
        self.vendor = vendor
        self.promo_code_required = promo_code_required
        self.quota = quota
        self.web_hosting_plan_restrictions = web_hosting_plan_restrictions
        self.privacy_policy_url = privacy_policy_url
        self.legal_terms_url = legal_terms_url
        self.marketplace_publisher = marketplace_publisher
        self.marketplace_offer = marketplace_offer


class PremierAddOnOfferCollection(_serialization.Model):
    """Collection of premier add-on offers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.PremierAddOnOffer]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PremierAddOnOffer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.PremierAddOnOffer"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.PremierAddOnOffer]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PremierAddOnPatchResource(ProxyOnlyResource):
    """ARM resource for a PremierAddOn.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar sku: Premier add on SKU.
    :vartype sku: str
    :ivar product: Premier add on Product.
    :vartype product: str
    :ivar vendor: Premier add on Vendor.
    :vartype vendor: str
    :ivar marketplace_publisher: Premier add on Marketplace publisher.
    :vartype marketplace_publisher: str
    :ivar marketplace_offer: Premier add on Marketplace offer.
    :vartype marketplace_offer: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku": {"key": "properties.sku", "type": "str"},
        "product": {"key": "properties.product", "type": "str"},
        "vendor": {"key": "properties.vendor", "type": "str"},
        "marketplace_publisher": {"key": "properties.marketplacePublisher", "type": "str"},
        "marketplace_offer": {"key": "properties.marketplaceOffer", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        sku: Optional[str] = None,
        product: Optional[str] = None,
        vendor: Optional[str] = None,
        marketplace_publisher: Optional[str] = None,
        marketplace_offer: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword sku: Premier add on SKU.
        :paramtype sku: str
        :keyword product: Premier add on Product.
        :paramtype product: str
        :keyword vendor: Premier add on Vendor.
        :paramtype vendor: str
        :keyword marketplace_publisher: Premier add on Marketplace publisher.
        :paramtype marketplace_publisher: str
        :keyword marketplace_offer: Premier add on Marketplace offer.
        :paramtype marketplace_offer: str
        """
        super().__init__(kind=kind, **kwargs)
        self.sku = sku
        self.product = product
        self.vendor = vendor
        self.marketplace_publisher = marketplace_publisher
        self.marketplace_offer = marketplace_offer


class PrivateAccess(ProxyOnlyResource):
    """Description of the parameters of Private Access for a Web Site.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar enabled: Whether private access is enabled or not.
    :vartype enabled: bool
    :ivar virtual_networks: The Virtual Networks (and subnets) allowed to access the site
     privately.
    :vartype virtual_networks: list[~azure.mgmt.web.v2018_02_01.models.PrivateAccessVirtualNetwork]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "virtual_networks": {"key": "properties.virtualNetworks", "type": "[PrivateAccessVirtualNetwork]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        enabled: Optional[bool] = None,
        virtual_networks: Optional[List["_models.PrivateAccessVirtualNetwork"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword enabled: Whether private access is enabled or not.
        :paramtype enabled: bool
        :keyword virtual_networks: The Virtual Networks (and subnets) allowed to access the site
         privately.
        :paramtype virtual_networks:
         list[~azure.mgmt.web.v2018_02_01.models.PrivateAccessVirtualNetwork]
        """
        super().__init__(kind=kind, **kwargs)
        self.enabled = enabled
        self.virtual_networks = virtual_networks


class PrivateAccessSubnet(_serialization.Model):
    """Description of a Virtual Network subnet that is useable for private site access.

    :ivar name: The name of the subnet.
    :vartype name: str
    :ivar key: The key (ID) of the subnet.
    :vartype key: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "key": {"key": "key", "type": "int"},
    }

    def __init__(self, *, name: Optional[str] = None, key: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the subnet.
        :paramtype name: str
        :keyword key: The key (ID) of the subnet.
        :paramtype key: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.key = key


class PrivateAccessVirtualNetwork(_serialization.Model):
    """Description of a Virtual Network that is useable for private site access.

    :ivar name: The name of the Virtual Network.
    :vartype name: str
    :ivar key: The key (ID) of the Virtual Network.
    :vartype key: int
    :ivar resource_id: The ARM uri of the Virtual Network.
    :vartype resource_id: str
    :ivar subnets: A List of subnets that access is allowed to on this Virtual Network. An empty
     array (but not null) is interpreted to mean that all subnets are allowed within this Virtual
     Network.
    :vartype subnets: list[~azure.mgmt.web.v2018_02_01.models.PrivateAccessSubnet]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "key": {"key": "key", "type": "int"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "subnets": {"key": "subnets", "type": "[PrivateAccessSubnet]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        key: Optional[int] = None,
        resource_id: Optional[str] = None,
        subnets: Optional[List["_models.PrivateAccessSubnet"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the Virtual Network.
        :paramtype name: str
        :keyword key: The key (ID) of the Virtual Network.
        :paramtype key: int
        :keyword resource_id: The ARM uri of the Virtual Network.
        :paramtype resource_id: str
        :keyword subnets: A List of subnets that access is allowed to on this Virtual Network. An empty
         array (but not null) is interpreted to mean that all subnets are allowed within this Virtual
         Network.
        :paramtype subnets: list[~azure.mgmt.web.v2018_02_01.models.PrivateAccessSubnet]
        """
        super().__init__(**kwargs)
        self.name = name
        self.key = key
        self.resource_id = resource_id
        self.subnets = subnets


class ProcessInfo(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Process Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar identifier: ARM Identifier for deployment.
    :vartype identifier: int
    :ivar deployment_name: Deployment name.
    :vartype deployment_name: str
    :ivar href: HRef URI.
    :vartype href: str
    :ivar minidump: Minidump URI.
    :vartype minidump: str
    :ivar is_profile_running: Is profile running?.
    :vartype is_profile_running: bool
    :ivar is_iis_profile_running: Is the IIS Profile running?.
    :vartype is_iis_profile_running: bool
    :ivar iis_profile_timeout_in_seconds: IIS Profile timeout (seconds).
    :vartype iis_profile_timeout_in_seconds: float
    :ivar parent: Parent process.
    :vartype parent: str
    :ivar children: Child process list.
    :vartype children: list[str]
    :ivar threads: Thread list.
    :vartype threads: list[~azure.mgmt.web.v2018_02_01.models.ProcessThreadInfo]
    :ivar open_file_handles: List of open files.
    :vartype open_file_handles: list[str]
    :ivar modules: List of modules.
    :vartype modules: list[~azure.mgmt.web.v2018_02_01.models.ProcessModuleInfo]
    :ivar file_name: File name of this process.
    :vartype file_name: str
    :ivar command_line: Command line.
    :vartype command_line: str
    :ivar user_name: User name.
    :vartype user_name: str
    :ivar handle_count: Handle count.
    :vartype handle_count: int
    :ivar module_count: Module count.
    :vartype module_count: int
    :ivar thread_count: Thread count.
    :vartype thread_count: int
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar total_cpu_time: Total CPU time.
    :vartype total_cpu_time: str
    :ivar user_cpu_time: User CPU time.
    :vartype user_cpu_time: str
    :ivar privileged_cpu_time: Privileged CPU time.
    :vartype privileged_cpu_time: str
    :ivar working_set: Working set.
    :vartype working_set: int
    :ivar peak_working_set: Peak working set.
    :vartype peak_working_set: int
    :ivar private_memory: Private memory size.
    :vartype private_memory: int
    :ivar virtual_memory: Virtual memory size.
    :vartype virtual_memory: int
    :ivar peak_virtual_memory: Peak virtual memory usage.
    :vartype peak_virtual_memory: int
    :ivar paged_system_memory: Paged system memory.
    :vartype paged_system_memory: int
    :ivar non_paged_system_memory: Non-paged system memory.
    :vartype non_paged_system_memory: int
    :ivar paged_memory: Paged memory.
    :vartype paged_memory: int
    :ivar peak_paged_memory: Peak paged memory.
    :vartype peak_paged_memory: int
    :ivar time_stamp: Time stamp.
    :vartype time_stamp: ~datetime.datetime
    :ivar environment_variables: List of environment variables.
    :vartype environment_variables: dict[str, str]
    :ivar is_scm_site: Is this the SCM site?.
    :vartype is_scm_site: bool
    :ivar is_webjob: Is this a Web Job?.
    :vartype is_webjob: bool
    :ivar description: Description of process.
    :vartype description: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identifier": {"key": "properties.identifier", "type": "int"},
        "deployment_name": {"key": "properties.deployment_name", "type": "str"},
        "href": {"key": "properties.href", "type": "str"},
        "minidump": {"key": "properties.minidump", "type": "str"},
        "is_profile_running": {"key": "properties.is_profile_running", "type": "bool"},
        "is_iis_profile_running": {"key": "properties.is_iis_profile_running", "type": "bool"},
        "iis_profile_timeout_in_seconds": {"key": "properties.iis_profile_timeout_in_seconds", "type": "float"},
        "parent": {"key": "properties.parent", "type": "str"},
        "children": {"key": "properties.children", "type": "[str]"},
        "threads": {"key": "properties.threads", "type": "[ProcessThreadInfo]"},
        "open_file_handles": {"key": "properties.open_file_handles", "type": "[str]"},
        "modules": {"key": "properties.modules", "type": "[ProcessModuleInfo]"},
        "file_name": {"key": "properties.file_name", "type": "str"},
        "command_line": {"key": "properties.command_line", "type": "str"},
        "user_name": {"key": "properties.user_name", "type": "str"},
        "handle_count": {"key": "properties.handle_count", "type": "int"},
        "module_count": {"key": "properties.module_count", "type": "int"},
        "thread_count": {"key": "properties.thread_count", "type": "int"},
        "start_time": {"key": "properties.start_time", "type": "iso-8601"},
        "total_cpu_time": {"key": "properties.total_cpu_time", "type": "str"},
        "user_cpu_time": {"key": "properties.user_cpu_time", "type": "str"},
        "privileged_cpu_time": {"key": "properties.privileged_cpu_time", "type": "str"},
        "working_set": {"key": "properties.working_set", "type": "int"},
        "peak_working_set": {"key": "properties.peak_working_set", "type": "int"},
        "private_memory": {"key": "properties.private_memory", "type": "int"},
        "virtual_memory": {"key": "properties.virtual_memory", "type": "int"},
        "peak_virtual_memory": {"key": "properties.peak_virtual_memory", "type": "int"},
        "paged_system_memory": {"key": "properties.paged_system_memory", "type": "int"},
        "non_paged_system_memory": {"key": "properties.non_paged_system_memory", "type": "int"},
        "paged_memory": {"key": "properties.paged_memory", "type": "int"},
        "peak_paged_memory": {"key": "properties.peak_paged_memory", "type": "int"},
        "time_stamp": {"key": "properties.time_stamp", "type": "iso-8601"},
        "environment_variables": {"key": "properties.environment_variables", "type": "{str}"},
        "is_scm_site": {"key": "properties.is_scm_site", "type": "bool"},
        "is_webjob": {"key": "properties.is_webjob", "type": "bool"},
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        deployment_name: Optional[str] = None,
        href: Optional[str] = None,
        minidump: Optional[str] = None,
        is_profile_running: Optional[bool] = None,
        is_iis_profile_running: Optional[bool] = None,
        iis_profile_timeout_in_seconds: Optional[float] = None,
        parent: Optional[str] = None,
        children: Optional[List[str]] = None,
        threads: Optional[List["_models.ProcessThreadInfo"]] = None,
        open_file_handles: Optional[List[str]] = None,
        modules: Optional[List["_models.ProcessModuleInfo"]] = None,
        file_name: Optional[str] = None,
        command_line: Optional[str] = None,
        user_name: Optional[str] = None,
        handle_count: Optional[int] = None,
        module_count: Optional[int] = None,
        thread_count: Optional[int] = None,
        start_time: Optional[datetime.datetime] = None,
        total_cpu_time: Optional[str] = None,
        user_cpu_time: Optional[str] = None,
        privileged_cpu_time: Optional[str] = None,
        working_set: Optional[int] = None,
        peak_working_set: Optional[int] = None,
        private_memory: Optional[int] = None,
        virtual_memory: Optional[int] = None,
        peak_virtual_memory: Optional[int] = None,
        paged_system_memory: Optional[int] = None,
        non_paged_system_memory: Optional[int] = None,
        paged_memory: Optional[int] = None,
        peak_paged_memory: Optional[int] = None,
        time_stamp: Optional[datetime.datetime] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        is_scm_site: Optional[bool] = None,
        is_webjob: Optional[bool] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword deployment_name: Deployment name.
        :paramtype deployment_name: str
        :keyword href: HRef URI.
        :paramtype href: str
        :keyword minidump: Minidump URI.
        :paramtype minidump: str
        :keyword is_profile_running: Is profile running?.
        :paramtype is_profile_running: bool
        :keyword is_iis_profile_running: Is the IIS Profile running?.
        :paramtype is_iis_profile_running: bool
        :keyword iis_profile_timeout_in_seconds: IIS Profile timeout (seconds).
        :paramtype iis_profile_timeout_in_seconds: float
        :keyword parent: Parent process.
        :paramtype parent: str
        :keyword children: Child process list.
        :paramtype children: list[str]
        :keyword threads: Thread list.
        :paramtype threads: list[~azure.mgmt.web.v2018_02_01.models.ProcessThreadInfo]
        :keyword open_file_handles: List of open files.
        :paramtype open_file_handles: list[str]
        :keyword modules: List of modules.
        :paramtype modules: list[~azure.mgmt.web.v2018_02_01.models.ProcessModuleInfo]
        :keyword file_name: File name of this process.
        :paramtype file_name: str
        :keyword command_line: Command line.
        :paramtype command_line: str
        :keyword user_name: User name.
        :paramtype user_name: str
        :keyword handle_count: Handle count.
        :paramtype handle_count: int
        :keyword module_count: Module count.
        :paramtype module_count: int
        :keyword thread_count: Thread count.
        :paramtype thread_count: int
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword total_cpu_time: Total CPU time.
        :paramtype total_cpu_time: str
        :keyword user_cpu_time: User CPU time.
        :paramtype user_cpu_time: str
        :keyword privileged_cpu_time: Privileged CPU time.
        :paramtype privileged_cpu_time: str
        :keyword working_set: Working set.
        :paramtype working_set: int
        :keyword peak_working_set: Peak working set.
        :paramtype peak_working_set: int
        :keyword private_memory: Private memory size.
        :paramtype private_memory: int
        :keyword virtual_memory: Virtual memory size.
        :paramtype virtual_memory: int
        :keyword peak_virtual_memory: Peak virtual memory usage.
        :paramtype peak_virtual_memory: int
        :keyword paged_system_memory: Paged system memory.
        :paramtype paged_system_memory: int
        :keyword non_paged_system_memory: Non-paged system memory.
        :paramtype non_paged_system_memory: int
        :keyword paged_memory: Paged memory.
        :paramtype paged_memory: int
        :keyword peak_paged_memory: Peak paged memory.
        :paramtype peak_paged_memory: int
        :keyword time_stamp: Time stamp.
        :paramtype time_stamp: ~datetime.datetime
        :keyword environment_variables: List of environment variables.
        :paramtype environment_variables: dict[str, str]
        :keyword is_scm_site: Is this the SCM site?.
        :paramtype is_scm_site: bool
        :keyword is_webjob: Is this a Web Job?.
        :paramtype is_webjob: bool
        :keyword description: Description of process.
        :paramtype description: str
        """
        super().__init__(kind=kind, **kwargs)
        self.identifier = None
        self.deployment_name = deployment_name
        self.href = href
        self.minidump = minidump
        self.is_profile_running = is_profile_running
        self.is_iis_profile_running = is_iis_profile_running
        self.iis_profile_timeout_in_seconds = iis_profile_timeout_in_seconds
        self.parent = parent
        self.children = children
        self.threads = threads
        self.open_file_handles = open_file_handles
        self.modules = modules
        self.file_name = file_name
        self.command_line = command_line
        self.user_name = user_name
        self.handle_count = handle_count
        self.module_count = module_count
        self.thread_count = thread_count
        self.start_time = start_time
        self.total_cpu_time = total_cpu_time
        self.user_cpu_time = user_cpu_time
        self.privileged_cpu_time = privileged_cpu_time
        self.working_set = working_set
        self.peak_working_set = peak_working_set
        self.private_memory = private_memory
        self.virtual_memory = virtual_memory
        self.peak_virtual_memory = peak_virtual_memory
        self.paged_system_memory = paged_system_memory
        self.non_paged_system_memory = non_paged_system_memory
        self.paged_memory = paged_memory
        self.peak_paged_memory = peak_paged_memory
        self.time_stamp = time_stamp
        self.environment_variables = environment_variables
        self.is_scm_site = is_scm_site
        self.is_webjob = is_webjob
        self.description = description


class ProcessInfoCollection(_serialization.Model):
    """Collection of Kudu process information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.ProcessInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ProcessInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ProcessInfo"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.ProcessInfo]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProcessModuleInfo(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Process Module Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar base_address: Base address. Used as module identifier in ARM resource URI.
    :vartype base_address: str
    :ivar file_name: File name.
    :vartype file_name: str
    :ivar href: HRef URI.
    :vartype href: str
    :ivar file_path: File path.
    :vartype file_path: str
    :ivar module_memory_size: Module memory size.
    :vartype module_memory_size: int
    :ivar file_version: File version.
    :vartype file_version: str
    :ivar file_description: File description.
    :vartype file_description: str
    :ivar product: Product name.
    :vartype product: str
    :ivar product_version: Product version.
    :vartype product_version: str
    :ivar is_debug: Is debug?.
    :vartype is_debug: bool
    :ivar language: Module language (locale).
    :vartype language: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "base_address": {"key": "properties.base_address", "type": "str"},
        "file_name": {"key": "properties.file_name", "type": "str"},
        "href": {"key": "properties.href", "type": "str"},
        "file_path": {"key": "properties.file_path", "type": "str"},
        "module_memory_size": {"key": "properties.module_memory_size", "type": "int"},
        "file_version": {"key": "properties.file_version", "type": "str"},
        "file_description": {"key": "properties.file_description", "type": "str"},
        "product": {"key": "properties.product", "type": "str"},
        "product_version": {"key": "properties.product_version", "type": "str"},
        "is_debug": {"key": "properties.is_debug", "type": "bool"},
        "language": {"key": "properties.language", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        base_address: Optional[str] = None,
        file_name: Optional[str] = None,
        href: Optional[str] = None,
        file_path: Optional[str] = None,
        module_memory_size: Optional[int] = None,
        file_version: Optional[str] = None,
        file_description: Optional[str] = None,
        product: Optional[str] = None,
        product_version: Optional[str] = None,
        is_debug: Optional[bool] = None,
        language: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword base_address: Base address. Used as module identifier in ARM resource URI.
        :paramtype base_address: str
        :keyword file_name: File name.
        :paramtype file_name: str
        :keyword href: HRef URI.
        :paramtype href: str
        :keyword file_path: File path.
        :paramtype file_path: str
        :keyword module_memory_size: Module memory size.
        :paramtype module_memory_size: int
        :keyword file_version: File version.
        :paramtype file_version: str
        :keyword file_description: File description.
        :paramtype file_description: str
        :keyword product: Product name.
        :paramtype product: str
        :keyword product_version: Product version.
        :paramtype product_version: str
        :keyword is_debug: Is debug?.
        :paramtype is_debug: bool
        :keyword language: Module language (locale).
        :paramtype language: str
        """
        super().__init__(kind=kind, **kwargs)
        self.base_address = base_address
        self.file_name = file_name
        self.href = href
        self.file_path = file_path
        self.module_memory_size = module_memory_size
        self.file_version = file_version
        self.file_description = file_description
        self.product = product
        self.product_version = product_version
        self.is_debug = is_debug
        self.language = language


class ProcessModuleInfoCollection(_serialization.Model):
    """Collection of Kudu thread information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.ProcessModuleInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ProcessModuleInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ProcessModuleInfo"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.ProcessModuleInfo]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProcessThreadInfo(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Process Thread Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar identifier: Site extension ID.
    :vartype identifier: int
    :ivar href: HRef URI.
    :vartype href: str
    :ivar process: Process URI.
    :vartype process: str
    :ivar start_address: Start address.
    :vartype start_address: str
    :ivar current_priority: Current thread priority.
    :vartype current_priority: int
    :ivar priority_level: Thread priority level.
    :vartype priority_level: str
    :ivar base_priority: Base priority.
    :vartype base_priority: int
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar total_processor_time: Total processor time.
    :vartype total_processor_time: str
    :ivar user_processor_time: User processor time.
    :vartype user_processor_time: str
    :ivar priviledged_processor_time: Privileged processor time.
    :vartype priviledged_processor_time: str
    :ivar state: Thread state.
    :vartype state: str
    :ivar wait_reason: Wait reason.
    :vartype wait_reason: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identifier": {"key": "properties.identifier", "type": "int"},
        "href": {"key": "properties.href", "type": "str"},
        "process": {"key": "properties.process", "type": "str"},
        "start_address": {"key": "properties.start_address", "type": "str"},
        "current_priority": {"key": "properties.current_priority", "type": "int"},
        "priority_level": {"key": "properties.priority_level", "type": "str"},
        "base_priority": {"key": "properties.base_priority", "type": "int"},
        "start_time": {"key": "properties.start_time", "type": "iso-8601"},
        "total_processor_time": {"key": "properties.total_processor_time", "type": "str"},
        "user_processor_time": {"key": "properties.user_processor_time", "type": "str"},
        "priviledged_processor_time": {"key": "properties.priviledged_processor_time", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "wait_reason": {"key": "properties.wait_reason", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        href: Optional[str] = None,
        process: Optional[str] = None,
        start_address: Optional[str] = None,
        current_priority: Optional[int] = None,
        priority_level: Optional[str] = None,
        base_priority: Optional[int] = None,
        start_time: Optional[datetime.datetime] = None,
        total_processor_time: Optional[str] = None,
        user_processor_time: Optional[str] = None,
        priviledged_processor_time: Optional[str] = None,
        state: Optional[str] = None,
        wait_reason: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword href: HRef URI.
        :paramtype href: str
        :keyword process: Process URI.
        :paramtype process: str
        :keyword start_address: Start address.
        :paramtype start_address: str
        :keyword current_priority: Current thread priority.
        :paramtype current_priority: int
        :keyword priority_level: Thread priority level.
        :paramtype priority_level: str
        :keyword base_priority: Base priority.
        :paramtype base_priority: int
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword total_processor_time: Total processor time.
        :paramtype total_processor_time: str
        :keyword user_processor_time: User processor time.
        :paramtype user_processor_time: str
        :keyword priviledged_processor_time: Privileged processor time.
        :paramtype priviledged_processor_time: str
        :keyword state: Thread state.
        :paramtype state: str
        :keyword wait_reason: Wait reason.
        :paramtype wait_reason: str
        """
        super().__init__(kind=kind, **kwargs)
        self.identifier = None
        self.href = href
        self.process = process
        self.start_address = start_address
        self.current_priority = current_priority
        self.priority_level = priority_level
        self.base_priority = base_priority
        self.start_time = start_time
        self.total_processor_time = total_processor_time
        self.user_processor_time = user_processor_time
        self.priviledged_processor_time = priviledged_processor_time
        self.state = state
        self.wait_reason = wait_reason


class ProcessThreadInfoCollection(_serialization.Model):
    """Collection of Kudu thread information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.ProcessThreadInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ProcessThreadInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ProcessThreadInfo"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.ProcessThreadInfo]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PublicCertificate(ProxyOnlyResource):
    """Public certificate object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar blob: Public Certificate byte array.
    :vartype blob: bytes
    :ivar public_certificate_location: Public Certificate Location. Known values are:
     "CurrentUserMy", "LocalMachineMy", and "Unknown".
    :vartype public_certificate_location: str or
     ~azure.mgmt.web.v2018_02_01.models.PublicCertificateLocation
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "thumbprint": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "blob": {"key": "properties.blob", "type": "bytearray"},
        "public_certificate_location": {"key": "properties.publicCertificateLocation", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        blob: Optional[bytes] = None,
        public_certificate_location: Optional[Union[str, "_models.PublicCertificateLocation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword blob: Public Certificate byte array.
        :paramtype blob: bytes
        :keyword public_certificate_location: Public Certificate Location. Known values are:
         "CurrentUserMy", "LocalMachineMy", and "Unknown".
        :paramtype public_certificate_location: str or
         ~azure.mgmt.web.v2018_02_01.models.PublicCertificateLocation
        """
        super().__init__(kind=kind, **kwargs)
        self.blob = blob
        self.public_certificate_location = public_certificate_location
        self.thumbprint = None


class PublicCertificateCollection(_serialization.Model):
    """Collection of public certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.PublicCertificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PublicCertificate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.PublicCertificate"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.PublicCertificate]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PushSettings(ProxyOnlyResource):
    """Push settings for the App.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
    :vartype is_push_enabled: bool
    :ivar tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are in the
     allowed list for use by the push registration endpoint.
    :vartype tag_whitelist_json: str
    :ivar tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
     user authentication to be used in the push registration endpoint.
     Tags can consist of alphanumeric characters and the following:
     '_', '@', '#', '.', ':', '-'.
     Validation should be performed at the PushRequestHandler.
    :vartype tags_requiring_auth: str
    :ivar dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that will
     be evaluated from user claims in the push registration endpoint.
    :vartype dynamic_tags_json: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_push_enabled": {"key": "properties.isPushEnabled", "type": "bool"},
        "tag_whitelist_json": {"key": "properties.tagWhitelistJson", "type": "str"},
        "tags_requiring_auth": {"key": "properties.tagsRequiringAuth", "type": "str"},
        "dynamic_tags_json": {"key": "properties.dynamicTagsJson", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        is_push_enabled: Optional[bool] = None,
        tag_whitelist_json: Optional[str] = None,
        tags_requiring_auth: Optional[str] = None,
        dynamic_tags_json: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
        :paramtype is_push_enabled: bool
        :keyword tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are in
         the allowed list for use by the push registration endpoint.
        :paramtype tag_whitelist_json: str
        :keyword tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
         user authentication to be used in the push registration endpoint.
         Tags can consist of alphanumeric characters and the following:
         '_', '@', '#', '.', ':', '-'.
         Validation should be performed at the PushRequestHandler.
        :paramtype tags_requiring_auth: str
        :keyword dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that
         will be evaluated from user claims in the push registration endpoint.
        :paramtype dynamic_tags_json: str
        """
        super().__init__(kind=kind, **kwargs)
        self.is_push_enabled = is_push_enabled
        self.tag_whitelist_json = tag_whitelist_json
        self.tags_requiring_auth = tags_requiring_auth
        self.dynamic_tags_json = dynamic_tags_json


class RampUpRule(_serialization.Model):
    """Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or
    to gradually change routing % based on performance.

    :ivar action_host_name: Hostname of a slot to which the traffic will be redirected if decided
     to. E.g. myapp-stage.azurewebsites.net.
    :vartype action_host_name: str
    :ivar reroute_percentage: Percentage of the traffic which will be redirected to
     :code:`<code>ActionHostName</code>`.
    :vartype reroute_percentage: float
    :ivar change_step: In auto ramp up scenario this is the step to add/remove from
     :code:`<code>ReroutePercentage</code>` until it reaches
     :code:`<code>MinReroutePercentage</code>` or :code:`<code>MaxReroutePercentage</code>`. Site
     metrics are checked every N minutes specified in :code:`<code>ChangeIntervalInMinutes</code>`.
     Custom decision algorithm can be provided in TiPCallback site extension which URL can be
     specified in :code:`<code>ChangeDecisionCallbackUrl</code>`.
    :vartype change_step: float
    :ivar change_interval_in_minutes: Specifies interval in minutes to reevaluate
     ReroutePercentage.
    :vartype change_interval_in_minutes: int
    :ivar min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will stay.
    :vartype min_reroute_percentage: float
    :ivar max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will stay.
    :vartype max_reroute_percentage: float
    :ivar change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
     site extension which URL can be specified. See TiPCallback site extension for the scaffold and
     contracts.
     https://www.siteextensions.net/packages/TiPCallback/.
    :vartype change_decision_callback_url: str
    :ivar name: Name of the routing rule. The recommended name would be to point to the slot which
     will receive the traffic in the experiment.
    :vartype name: str
    """

    _attribute_map = {
        "action_host_name": {"key": "actionHostName", "type": "str"},
        "reroute_percentage": {"key": "reroutePercentage", "type": "float"},
        "change_step": {"key": "changeStep", "type": "float"},
        "change_interval_in_minutes": {"key": "changeIntervalInMinutes", "type": "int"},
        "min_reroute_percentage": {"key": "minReroutePercentage", "type": "float"},
        "max_reroute_percentage": {"key": "maxReroutePercentage", "type": "float"},
        "change_decision_callback_url": {"key": "changeDecisionCallbackUrl", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_host_name: Optional[str] = None,
        reroute_percentage: Optional[float] = None,
        change_step: Optional[float] = None,
        change_interval_in_minutes: Optional[int] = None,
        min_reroute_percentage: Optional[float] = None,
        max_reroute_percentage: Optional[float] = None,
        change_decision_callback_url: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_host_name: Hostname of a slot to which the traffic will be redirected if
         decided to. E.g. myapp-stage.azurewebsites.net.
        :paramtype action_host_name: str
        :keyword reroute_percentage: Percentage of the traffic which will be redirected to
         :code:`<code>ActionHostName</code>`.
        :paramtype reroute_percentage: float
        :keyword change_step: In auto ramp up scenario this is the step to add/remove from
         :code:`<code>ReroutePercentage</code>` until it reaches
         :code:`<code>MinReroutePercentage</code>` or :code:`<code>MaxReroutePercentage</code>`. Site
         metrics are checked every N minutes specified in :code:`<code>ChangeIntervalInMinutes</code>`.
         Custom decision algorithm can be provided in TiPCallback site extension which URL can be
         specified in :code:`<code>ChangeDecisionCallbackUrl</code>`.
        :paramtype change_step: float
        :keyword change_interval_in_minutes: Specifies interval in minutes to reevaluate
         ReroutePercentage.
        :paramtype change_interval_in_minutes: int
        :keyword min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will
         stay.
        :paramtype min_reroute_percentage: float
        :keyword max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will
         stay.
        :paramtype max_reroute_percentage: float
        :keyword change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
         site extension which URL can be specified. See TiPCallback site extension for the scaffold and
         contracts.
         https://www.siteextensions.net/packages/TiPCallback/.
        :paramtype change_decision_callback_url: str
        :keyword name: Name of the routing rule. The recommended name would be to point to the slot
         which will receive the traffic in the experiment.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.action_host_name = action_host_name
        self.reroute_percentage = reroute_percentage
        self.change_step = change_step
        self.change_interval_in_minutes = change_interval_in_minutes
        self.min_reroute_percentage = min_reroute_percentage
        self.max_reroute_percentage = max_reroute_percentage
        self.change_decision_callback_url = change_decision_callback_url
        self.name = name


class Recommendation(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Represents a recommendation result generated by the recommendation engine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar creation_time: Timestamp when this instance was created.
    :vartype creation_time: ~datetime.datetime
    :ivar recommendation_id: A GUID value that each recommendation object is associated with.
    :vartype recommendation_id: str
    :ivar resource_id: Full ARM resource ID string that this recommendation object is associated
     with.
    :vartype resource_id: str
    :ivar resource_scope: Name of a resource type this recommendation applies, e.g. Subscription,
     ServerFarm, Site. Known values are: "ServerFarm", "Subscription", and "WebSite".
    :vartype resource_scope: str or ~azure.mgmt.web.v2018_02_01.models.ResourceScopeType
    :ivar rule_name: Unique name of the rule.
    :vartype rule_name: str
    :ivar display_name: UI friendly name of the rule (may not be unique).
    :vartype display_name: str
    :ivar message: Recommendation text.
    :vartype message: str
    :ivar level: Level indicating how critical this recommendation can impact. Known values are:
     "Critical", "Warning", "Information", and "NonUrgentSuggestion".
    :vartype level: str or ~azure.mgmt.web.v2018_02_01.models.NotificationLevel
    :ivar channels: List of channels that this recommendation can apply. Known values are:
     "Notification", "Api", "Email", "Webhook", and "All".
    :vartype channels: str or ~azure.mgmt.web.v2018_02_01.models.Channels
    :ivar category_tags: The list of category tags that this recommendation belongs to.
    :vartype category_tags: list[str]
    :ivar action_name: Name of action recommended by this object.
    :vartype action_name: str
    :ivar enabled: True if this recommendation is still valid (i.e. "actionable"). False if it is
     invalid.
    :vartype enabled: int
    :ivar states: The list of states of this recommendation. If it's null then it should be
     considered "Active".
    :vartype states: list[str]
    :ivar start_time: The beginning time in UTC of a range that the recommendation refers to.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time in UTC of a range that the recommendation refers to.
    :vartype end_time: ~datetime.datetime
    :ivar next_notification_time: When to notify this recommendation next in UTC. Null means that
     this will never be notified anymore.
    :vartype next_notification_time: ~datetime.datetime
    :ivar notification_expiration_time: Date and time in UTC when this notification expires.
    :vartype notification_expiration_time: ~datetime.datetime
    :ivar notified_time: Last timestamp in UTC this instance was actually notified. Null means that
     this recommendation hasn't been notified yet.
    :vartype notified_time: ~datetime.datetime
    :ivar score: A metric value measured by the rule.
    :vartype score: float
    :ivar is_dynamic: True if this is associated with a dynamically added rule.
    :vartype is_dynamic: bool
    :ivar extension_name: Extension name of the portal if exists.
    :vartype extension_name: str
    :ivar blade_name: Deep link to a blade on the portal.
    :vartype blade_name: str
    :ivar forward_link: Forward link to an external document associated with the rule.
    :vartype forward_link: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "category_tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
        "recommendation_id": {"key": "properties.recommendationId", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "resource_scope": {"key": "properties.resourceScope", "type": "str"},
        "rule_name": {"key": "properties.ruleName", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "message": {"key": "properties.message", "type": "str"},
        "level": {"key": "properties.level", "type": "str"},
        "channels": {"key": "properties.channels", "type": "str"},
        "category_tags": {"key": "properties.categoryTags", "type": "[str]"},
        "action_name": {"key": "properties.actionName", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "int"},
        "states": {"key": "properties.states", "type": "[str]"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
        "next_notification_time": {"key": "properties.nextNotificationTime", "type": "iso-8601"},
        "notification_expiration_time": {"key": "properties.notificationExpirationTime", "type": "iso-8601"},
        "notified_time": {"key": "properties.notifiedTime", "type": "iso-8601"},
        "score": {"key": "properties.score", "type": "float"},
        "is_dynamic": {"key": "properties.isDynamic", "type": "bool"},
        "extension_name": {"key": "properties.extensionName", "type": "str"},
        "blade_name": {"key": "properties.bladeName", "type": "str"},
        "forward_link": {"key": "properties.forwardLink", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        creation_time: Optional[datetime.datetime] = None,
        recommendation_id: Optional[str] = None,
        resource_id: Optional[str] = None,
        resource_scope: Optional[Union[str, "_models.ResourceScopeType"]] = None,
        rule_name: Optional[str] = None,
        display_name: Optional[str] = None,
        message: Optional[str] = None,
        level: Optional[Union[str, "_models.NotificationLevel"]] = None,
        channels: Optional[Union[str, "_models.Channels"]] = None,
        action_name: Optional[str] = None,
        enabled: Optional[int] = None,
        states: Optional[List[str]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        next_notification_time: Optional[datetime.datetime] = None,
        notification_expiration_time: Optional[datetime.datetime] = None,
        notified_time: Optional[datetime.datetime] = None,
        score: Optional[float] = None,
        is_dynamic: Optional[bool] = None,
        extension_name: Optional[str] = None,
        blade_name: Optional[str] = None,
        forward_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword creation_time: Timestamp when this instance was created.
        :paramtype creation_time: ~datetime.datetime
        :keyword recommendation_id: A GUID value that each recommendation object is associated with.
        :paramtype recommendation_id: str
        :keyword resource_id: Full ARM resource ID string that this recommendation object is associated
         with.
        :paramtype resource_id: str
        :keyword resource_scope: Name of a resource type this recommendation applies, e.g.
         Subscription, ServerFarm, Site. Known values are: "ServerFarm", "Subscription", and "WebSite".
        :paramtype resource_scope: str or ~azure.mgmt.web.v2018_02_01.models.ResourceScopeType
        :keyword rule_name: Unique name of the rule.
        :paramtype rule_name: str
        :keyword display_name: UI friendly name of the rule (may not be unique).
        :paramtype display_name: str
        :keyword message: Recommendation text.
        :paramtype message: str
        :keyword level: Level indicating how critical this recommendation can impact. Known values are:
         "Critical", "Warning", "Information", and "NonUrgentSuggestion".
        :paramtype level: str or ~azure.mgmt.web.v2018_02_01.models.NotificationLevel
        :keyword channels: List of channels that this recommendation can apply. Known values are:
         "Notification", "Api", "Email", "Webhook", and "All".
        :paramtype channels: str or ~azure.mgmt.web.v2018_02_01.models.Channels
        :keyword action_name: Name of action recommended by this object.
        :paramtype action_name: str
        :keyword enabled: True if this recommendation is still valid (i.e. "actionable"). False if it
         is invalid.
        :paramtype enabled: int
        :keyword states: The list of states of this recommendation. If it's null then it should be
         considered "Active".
        :paramtype states: list[str]
        :keyword start_time: The beginning time in UTC of a range that the recommendation refers to.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time in UTC of a range that the recommendation refers to.
        :paramtype end_time: ~datetime.datetime
        :keyword next_notification_time: When to notify this recommendation next in UTC. Null means
         that this will never be notified anymore.
        :paramtype next_notification_time: ~datetime.datetime
        :keyword notification_expiration_time: Date and time in UTC when this notification expires.
        :paramtype notification_expiration_time: ~datetime.datetime
        :keyword notified_time: Last timestamp in UTC this instance was actually notified. Null means
         that this recommendation hasn't been notified yet.
        :paramtype notified_time: ~datetime.datetime
        :keyword score: A metric value measured by the rule.
        :paramtype score: float
        :keyword is_dynamic: True if this is associated with a dynamically added rule.
        :paramtype is_dynamic: bool
        :keyword extension_name: Extension name of the portal if exists.
        :paramtype extension_name: str
        :keyword blade_name: Deep link to a blade on the portal.
        :paramtype blade_name: str
        :keyword forward_link: Forward link to an external document associated with the rule.
        :paramtype forward_link: str
        """
        super().__init__(kind=kind, **kwargs)
        self.creation_time = creation_time
        self.recommendation_id = recommendation_id
        self.resource_id = resource_id
        self.resource_scope = resource_scope
        self.rule_name = rule_name
        self.display_name = display_name
        self.message = message
        self.level = level
        self.channels = channels
        self.category_tags = None
        self.action_name = action_name
        self.enabled = enabled
        self.states = states
        self.start_time = start_time
        self.end_time = end_time
        self.next_notification_time = next_notification_time
        self.notification_expiration_time = notification_expiration_time
        self.notified_time = notified_time
        self.score = score
        self.is_dynamic = is_dynamic
        self.extension_name = extension_name
        self.blade_name = blade_name
        self.forward_link = forward_link


class RecommendationCollection(_serialization.Model):
    """Collection of recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.Recommendation]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Recommendation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Recommendation"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.Recommendation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class RecommendationRule(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Represents a recommendation rule that the recommendation engine can perform.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar recommendation_name: Unique name of the rule.
    :vartype recommendation_name: str
    :ivar display_name: UI friendly name of the rule.
    :vartype display_name: str
    :ivar message: Localized name of the rule (Good for UI).
    :vartype message: str
    :ivar recommendation_id: Recommendation ID of an associated recommendation object tied to the
     rule, if exists.
     If such an object doesn't exist, it is set to null.
    :vartype recommendation_id: str
    :ivar description: Localized detailed description of the rule.
    :vartype description: str
    :ivar action_name: Name of action that is recommended by this rule in string.
    :vartype action_name: str
    :ivar level: Level of impact indicating how critical this rule is. Known values are:
     "Critical", "Warning", "Information", and "NonUrgentSuggestion".
    :vartype level: str or ~azure.mgmt.web.v2018_02_01.models.NotificationLevel
    :ivar channels: List of available channels that this rule applies. Known values are:
     "Notification", "Api", "Email", "Webhook", and "All".
    :vartype channels: str or ~azure.mgmt.web.v2018_02_01.models.Channels
    :ivar category_tags: The list of category tags that this recommendation rule belongs to.
    :vartype category_tags: list[str]
    :ivar is_dynamic: True if this is associated with a dynamically added rule.
    :vartype is_dynamic: bool
    :ivar extension_name: Extension name of the portal if exists. Applicable to dynamic rule only.
    :vartype extension_name: str
    :ivar blade_name: Deep link to a blade on the portal. Applicable to dynamic rule only.
    :vartype blade_name: str
    :ivar forward_link: Forward link to an external document associated with the rule. Applicable
     to dynamic rule only.
    :vartype forward_link: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "category_tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "recommendation_name": {"key": "properties.recommendationName", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "message": {"key": "properties.message", "type": "str"},
        "recommendation_id": {"key": "properties.recommendationId", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "action_name": {"key": "properties.actionName", "type": "str"},
        "level": {"key": "properties.level", "type": "str"},
        "channels": {"key": "properties.channels", "type": "str"},
        "category_tags": {"key": "properties.categoryTags", "type": "[str]"},
        "is_dynamic": {"key": "properties.isDynamic", "type": "bool"},
        "extension_name": {"key": "properties.extensionName", "type": "str"},
        "blade_name": {"key": "properties.bladeName", "type": "str"},
        "forward_link": {"key": "properties.forwardLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        recommendation_name: Optional[str] = None,
        display_name: Optional[str] = None,
        message: Optional[str] = None,
        recommendation_id: Optional[str] = None,
        description: Optional[str] = None,
        action_name: Optional[str] = None,
        level: Optional[Union[str, "_models.NotificationLevel"]] = None,
        channels: Optional[Union[str, "_models.Channels"]] = None,
        is_dynamic: Optional[bool] = None,
        extension_name: Optional[str] = None,
        blade_name: Optional[str] = None,
        forward_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword recommendation_name: Unique name of the rule.
        :paramtype recommendation_name: str
        :keyword display_name: UI friendly name of the rule.
        :paramtype display_name: str
        :keyword message: Localized name of the rule (Good for UI).
        :paramtype message: str
        :keyword recommendation_id: Recommendation ID of an associated recommendation object tied to
         the rule, if exists.
         If such an object doesn't exist, it is set to null.
        :paramtype recommendation_id: str
        :keyword description: Localized detailed description of the rule.
        :paramtype description: str
        :keyword action_name: Name of action that is recommended by this rule in string.
        :paramtype action_name: str
        :keyword level: Level of impact indicating how critical this rule is. Known values are:
         "Critical", "Warning", "Information", and "NonUrgentSuggestion".
        :paramtype level: str or ~azure.mgmt.web.v2018_02_01.models.NotificationLevel
        :keyword channels: List of available channels that this rule applies. Known values are:
         "Notification", "Api", "Email", "Webhook", and "All".
        :paramtype channels: str or ~azure.mgmt.web.v2018_02_01.models.Channels
        :keyword is_dynamic: True if this is associated with a dynamically added rule.
        :paramtype is_dynamic: bool
        :keyword extension_name: Extension name of the portal if exists. Applicable to dynamic rule
         only.
        :paramtype extension_name: str
        :keyword blade_name: Deep link to a blade on the portal. Applicable to dynamic rule only.
        :paramtype blade_name: str
        :keyword forward_link: Forward link to an external document associated with the rule.
         Applicable to dynamic rule only.
        :paramtype forward_link: str
        """
        super().__init__(kind=kind, **kwargs)
        self.recommendation_name = recommendation_name
        self.display_name = display_name
        self.message = message
        self.recommendation_id = recommendation_id
        self.description = description
        self.action_name = action_name
        self.level = level
        self.channels = channels
        self.category_tags = None
        self.is_dynamic = is_dynamic
        self.extension_name = extension_name
        self.blade_name = blade_name
        self.forward_link = forward_link


class ReissueCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate reissue request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key_size: Certificate Key Size.
    :vartype key_size: int
    :ivar delay_existing_revoke_in_hours: Delay in hours to revoke existing certificate after the
     new certificate is issued.
    :vartype delay_existing_revoke_in_hours: int
    :ivar csr: Csr to be used for re-key operation.
    :vartype csr: str
    :ivar is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :vartype is_private_key_external: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "delay_existing_revoke_in_hours": {"key": "properties.delayExistingRevokeInHours", "type": "int"},
        "csr": {"key": "properties.csr", "type": "str"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_size: Optional[int] = None,
        delay_existing_revoke_in_hours: Optional[int] = None,
        csr: Optional[str] = None,
        is_private_key_external: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key_size: Certificate Key Size.
        :paramtype key_size: int
        :keyword delay_existing_revoke_in_hours: Delay in hours to revoke existing certificate after
         the new certificate is issued.
        :paramtype delay_existing_revoke_in_hours: int
        :keyword csr: Csr to be used for re-key operation.
        :paramtype csr: str
        :keyword is_private_key_external: Should we change the ASC type (from managed private key to
         external private key and vice versa).
        :paramtype is_private_key_external: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.delay_existing_revoke_in_hours = delay_existing_revoke_in_hours
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class RelayServiceConnectionEntity(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Hybrid Connection for an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar entity_name:
    :vartype entity_name: str
    :ivar entity_connection_string:
    :vartype entity_connection_string: str
    :ivar resource_type:
    :vartype resource_type: str
    :ivar resource_connection_string:
    :vartype resource_connection_string: str
    :ivar hostname:
    :vartype hostname: str
    :ivar port:
    :vartype port: int
    :ivar biztalk_uri:
    :vartype biztalk_uri: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "entity_name": {"key": "properties.entityName", "type": "str"},
        "entity_connection_string": {"key": "properties.entityConnectionString", "type": "str"},
        "resource_type": {"key": "properties.resourceType", "type": "str"},
        "resource_connection_string": {"key": "properties.resourceConnectionString", "type": "str"},
        "hostname": {"key": "properties.hostname", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "biztalk_uri": {"key": "properties.biztalkUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        entity_name: Optional[str] = None,
        entity_connection_string: Optional[str] = None,
        resource_type: Optional[str] = None,
        resource_connection_string: Optional[str] = None,
        hostname: Optional[str] = None,
        port: Optional[int] = None,
        biztalk_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword entity_name:
        :paramtype entity_name: str
        :keyword entity_connection_string:
        :paramtype entity_connection_string: str
        :keyword resource_type:
        :paramtype resource_type: str
        :keyword resource_connection_string:
        :paramtype resource_connection_string: str
        :keyword hostname:
        :paramtype hostname: str
        :keyword port:
        :paramtype port: int
        :keyword biztalk_uri:
        :paramtype biztalk_uri: str
        """
        super().__init__(kind=kind, **kwargs)
        self.entity_name = entity_name
        self.entity_connection_string = entity_connection_string
        self.resource_type = resource_type
        self.resource_connection_string = resource_connection_string
        self.hostname = hostname
        self.port = port
        self.biztalk_uri = biztalk_uri


class Rendering(_serialization.Model):
    """Instructions for rendering the data.

    :ivar type: Rendering Type. Known values are: "NoGraph", "Table", "TimeSeries", and
     "TimeSeriesPerInstance".
    :vartype type: str or ~azure.mgmt.web.v2018_02_01.models.RenderingType
    :ivar title: Title of data.
    :vartype title: str
    :ivar description: Description of the data that will help it be interpreted.
    :vartype description: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.RenderingType"]] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Rendering Type. Known values are: "NoGraph", "Table", "TimeSeries", and
         "TimeSeriesPerInstance".
        :paramtype type: str or ~azure.mgmt.web.v2018_02_01.models.RenderingType
        :keyword title: Title of data.
        :paramtype title: str
        :keyword description: Description of the data that will help it be interpreted.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.title = title
        self.description = description


class RenewCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate renew request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key_size: Certificate Key Size.
    :vartype key_size: int
    :ivar csr: Csr to be used for re-key operation.
    :vartype csr: str
    :ivar is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :vartype is_private_key_external: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "csr": {"key": "properties.csr", "type": "str"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_size: Optional[int] = None,
        csr: Optional[str] = None,
        is_private_key_external: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key_size: Certificate Key Size.
        :paramtype key_size: int
        :keyword csr: Csr to be used for re-key operation.
        :paramtype csr: str
        :keyword is_private_key_external: Should we change the ASC type (from managed private key to
         external private key and vice versa).
        :paramtype is_private_key_external: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class RequestsBasedTrigger(_serialization.Model):
    """Trigger based on total requests.

    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "time_interval": {"key": "timeInterval", "type": "str"},
    }

    def __init__(self, *, count: Optional[int] = None, time_interval: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super().__init__(**kwargs)
        self.count = count
        self.time_interval = time_interval


class ResourceCollection(_serialization.Model):
    """Collection of resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[str]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[str]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List[str], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[str]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceHealthMetadata(ProxyOnlyResource):
    """Used for getting ResourceHealthCheck settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar category: The category that the resource matches in the RHC Policy File.
    :vartype category: str
    :ivar signal_availability: Is there a health signal for the resource.
    :vartype signal_availability: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "category": {"key": "properties.category", "type": "str"},
        "signal_availability": {"key": "properties.signalAvailability", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        category: Optional[str] = None,
        signal_availability: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword category: The category that the resource matches in the RHC Policy File.
        :paramtype category: str
        :keyword signal_availability: Is there a health signal for the resource.
        :paramtype signal_availability: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.category = category
        self.signal_availability = signal_availability


class ResourceHealthMetadataCollection(_serialization.Model):
    """Collection of resource health metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.ResourceHealthMetadata]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceHealthMetadata]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ResourceHealthMetadata"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.ResourceHealthMetadata]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceMetric(_serialization.Model):
    """Object representing a metric for any resource .

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of metric.
    :vartype name: ~azure.mgmt.web.v2018_02_01.models.ResourceMetricName
    :ivar unit: Metric unit.
    :vartype unit: str
    :ivar time_grain: Metric granularity. E.g PT1H, PT5M, P1D.
    :vartype time_grain: str
    :ivar start_time: Metric start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Metric end time.
    :vartype end_time: ~datetime.datetime
    :ivar resource_id: Metric resource Id.
    :vartype resource_id: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar metric_values: Metric values.
    :vartype metric_values: list[~azure.mgmt.web.v2018_02_01.models.ResourceMetricValue]
    :ivar properties: Resource metric properties collection.
    :vartype properties: list[~azure.mgmt.web.v2018_02_01.models.ResourceMetricProperty]
    """

    _validation = {
        "name": {"readonly": True},
        "unit": {"readonly": True},
        "time_grain": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "resource_id": {"readonly": True},
        "id": {"readonly": True},
        "metric_values": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "ResourceMetricName"},
        "unit": {"key": "unit", "type": "str"},
        "time_grain": {"key": "timeGrain", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "metric_values": {"key": "metricValues", "type": "[ResourceMetricValue]"},
        "properties": {"key": "properties", "type": "[ResourceMetricProperty]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.unit = None
        self.time_grain = None
        self.start_time = None
        self.end_time = None
        self.resource_id = None
        self.id = None
        self.metric_values = None
        self.properties = None


class ResourceMetricAvailability(_serialization.Model):
    """Metrics availability and retention.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time_grain: Time grain .
    :vartype time_grain: str
    :ivar retention: Retention period for the current time grain.
    :vartype retention: str
    """

    _validation = {
        "time_grain": {"readonly": True},
        "retention": {"readonly": True},
    }

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "retention": {"key": "retention", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.time_grain = None
        self.retention = None


class ResourceMetricCollection(_serialization.Model):
    """Collection of metric responses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.ResourceMetric]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceMetric]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ResourceMetric"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.ResourceMetric]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceMetricDefinition(ProxyOnlyResource):
    """Metadata for the metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar primary_aggregation_type: Primary aggregation type.
    :vartype primary_aggregation_type: str
    :ivar metric_availabilities: List of time grains supported for the metric together with
     retention period.
    :vartype metric_availabilities:
     list[~azure.mgmt.web.v2018_02_01.models.ResourceMetricAvailability]
    :ivar resource_uri: Resource URI.
    :vartype resource_uri: str
    :ivar properties: Resource metric definition properties.
    :vartype properties: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "unit": {"readonly": True},
        "primary_aggregation_type": {"readonly": True},
        "metric_availabilities": {"readonly": True},
        "resource_uri": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "unit": {"key": "properties.unit", "type": "str"},
        "primary_aggregation_type": {"key": "properties.primaryAggregationType", "type": "str"},
        "metric_availabilities": {"key": "properties.metricAvailabilities", "type": "[ResourceMetricAvailability]"},
        "resource_uri": {"key": "properties.resourceUri", "type": "str"},
        "properties": {"key": "properties.properties", "type": "{str}"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.unit = None
        self.primary_aggregation_type = None
        self.metric_availabilities = None
        self.resource_uri = None
        self.properties = None


class ResourceMetricDefinitionCollection(_serialization.Model):
    """Collection of metric definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.ResourceMetricDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceMetricDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ResourceMetricDefinition"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.ResourceMetricDefinition]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceMetricName(_serialization.Model):
    """Name of a metric for any resource .

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: metric name value.
    :vartype value: str
    :ivar localized_value: Localized metric name value.
    :vartype localized_value: str
    """

    _validation = {
        "value": {"readonly": True},
        "localized_value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.localized_value = None


class ResourceMetricProperty(_serialization.Model):
    """Resource metric property.

    :ivar key: Key for resource metric property.
    :vartype key: str
    :ivar value: Value of pair.
    :vartype value: str
    """

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: Key for resource metric property.
        :paramtype key: str
        :keyword value: Value of pair.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class ResourceMetricValue(_serialization.Model):
    """Value of resource metric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: Value timestamp.
    :vartype timestamp: str
    :ivar average: Value average.
    :vartype average: float
    :ivar minimum: Value minimum.
    :vartype minimum: float
    :ivar maximum: Value maximum.
    :vartype maximum: float
    :ivar total: Value total.
    :vartype total: float
    :ivar count: Value count.
    :vartype count: float
    :ivar properties: Resource metric properties collection.
    :vartype properties: list[~azure.mgmt.web.v2018_02_01.models.ResourceMetricProperty]
    """

    _validation = {
        "timestamp": {"readonly": True},
        "average": {"readonly": True},
        "minimum": {"readonly": True},
        "maximum": {"readonly": True},
        "total": {"readonly": True},
        "count": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "timestamp": {"key": "timestamp", "type": "str"},
        "average": {"key": "average", "type": "float"},
        "minimum": {"key": "minimum", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
        "total": {"key": "total", "type": "float"},
        "count": {"key": "count", "type": "float"},
        "properties": {"key": "properties", "type": "[ResourceMetricProperty]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.timestamp = None
        self.average = None
        self.minimum = None
        self.maximum = None
        self.total = None
        self.count = None
        self.properties = None


class ResourceNameAvailability(_serialization.Model):
    """Information regarding availability of a resource name.

    :ivar name_available: :code:`<code>true</code>` indicates name is valid and available.
     :code:`<code>false</code>` indicates the name is invalid, unavailable, or both.
    :vartype name_available: bool
    :ivar reason: :code:`<code>Invalid</code>` indicates the name provided does not match Azure App
     Service naming requirements. :code:`<code>AlreadyExists</code>` indicates that the name is
     already in use and is therefore unavailable. Known values are: "Invalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.web.v2018_02_01.models.InAvailabilityReasonType
    :ivar message: If reason == invalid, provide the user with the reason why the given name is
     invalid, and provide the resource naming requirements so that the user can select a valid name.
     If reason == AlreadyExists, explain that resource name is already in use, and direct them to
     select a different name.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.InAvailabilityReasonType"]] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: :code:`<code>true</code>` indicates name is valid and available.
         :code:`<code>false</code>` indicates the name is invalid, unavailable, or both.
        :paramtype name_available: bool
        :keyword reason: :code:`<code>Invalid</code>` indicates the name provided does not match Azure
         App Service naming requirements. :code:`<code>AlreadyExists</code>` indicates that the name is
         already in use and is therefore unavailable. Known values are: "Invalid" and "AlreadyExists".
        :paramtype reason: str or ~azure.mgmt.web.v2018_02_01.models.InAvailabilityReasonType
        :keyword message: If reason == invalid, provide the user with the reason why the given name is
         invalid, and provide the resource naming requirements so that the user can select a valid name.
         If reason == AlreadyExists, explain that resource name is already in use, and direct them to
         select a different name.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class ResourceNameAvailabilityRequest(_serialization.Model):
    """Resource name availability request content.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Resource name to verify. Required.
    :vartype name: str
    :ivar type: Resource type used for verification. Required. Known values are: "Site", "Slot",
     "HostingEnvironment", "PublishingUser", "Microsoft.Web/sites", "Microsoft.Web/sites/slots",
     "Microsoft.Web/hostingEnvironments", and "Microsoft.Web/publishingUsers".
    :vartype type: str or ~azure.mgmt.web.v2018_02_01.models.CheckNameResourceTypes
    :ivar is_fqdn: Is fully qualified domain name.
    :vartype is_fqdn: bool
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_fqdn": {"key": "isFqdn", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.CheckNameResourceTypes"],
        is_fqdn: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Resource name to verify. Required.
        :paramtype name: str
        :keyword type: Resource type used for verification. Required. Known values are: "Site", "Slot",
         "HostingEnvironment", "PublishingUser", "Microsoft.Web/sites", "Microsoft.Web/sites/slots",
         "Microsoft.Web/hostingEnvironments", and "Microsoft.Web/publishingUsers".
        :paramtype type: str or ~azure.mgmt.web.v2018_02_01.models.CheckNameResourceTypes
        :keyword is_fqdn: Is fully qualified domain name.
        :paramtype is_fqdn: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.is_fqdn = is_fqdn


class ResponseMetaData(_serialization.Model):
    """ResponseMetaData.

    :ivar data_source: Source of the Data.
    :vartype data_source: ~azure.mgmt.web.v2018_02_01.models.DataSource
    """

    _attribute_map = {
        "data_source": {"key": "dataSource", "type": "DataSource"},
    }

    def __init__(self, *, data_source: Optional["_models.DataSource"] = None, **kwargs: Any) -> None:
        """
        :keyword data_source: Source of the Data.
        :paramtype data_source: ~azure.mgmt.web.v2018_02_01.models.DataSource
        """
        super().__init__(**kwargs)
        self.data_source = data_source


class RestoreRequest(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Description of a restore request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar storage_account_url: SAS URL to the container.
    :vartype storage_account_url: str
    :ivar blob_name: Name of a blob which contains the backup.
    :vartype blob_name: str
    :ivar overwrite: :code:`<code>true</code>` if the restore operation can overwrite target app;
     otherwise, :code:`<code>false</code>`. :code:`<code>true</code>` is needed if trying to restore
     over an existing app.
    :vartype overwrite: bool
    :ivar site_name: Name of an app.
    :vartype site_name: str
    :ivar databases: Collection of databases which should be restored. This list has to match the
     list of databases included in the backup.
    :vartype databases: list[~azure.mgmt.web.v2018_02_01.models.DatabaseBackupSetting]
    :ivar ignore_conflicting_host_names: Changes a logic when restoring an app with custom domains.
     :code:`<code>true</code>` to remove custom domains automatically. If
     :code:`<code>false</code>`, custom domains are added to
     the app's object when it is being restored, but that might fail due to conflicts during the
     operation.
    :vartype ignore_conflicting_host_names: bool
    :ivar ignore_databases: Ignore the databases and only restore the site content.
    :vartype ignore_databases: bool
    :ivar app_service_plan: Specify app service plan that will own restored site.
    :vartype app_service_plan: str
    :ivar operation_type: Operation type. Known values are: "Default", "Clone", "Relocation",
     "Snapshot", and "CloudFS".
    :vartype operation_type: str or ~azure.mgmt.web.v2018_02_01.models.BackupRestoreOperationType
    :ivar adjust_connection_strings: :code:`<code>true</code>` if SiteConfig.ConnectionStrings
     should be set in new app; otherwise, :code:`<code>false</code>`.
    :vartype adjust_connection_strings: bool
    :ivar hosting_environment: App Service Environment name, if needed (only when restoring an app
     to an App Service Environment).
    :vartype hosting_environment: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "storage_account_url": {"key": "properties.storageAccountUrl", "type": "str"},
        "blob_name": {"key": "properties.blobName", "type": "str"},
        "overwrite": {"key": "properties.overwrite", "type": "bool"},
        "site_name": {"key": "properties.siteName", "type": "str"},
        "databases": {"key": "properties.databases", "type": "[DatabaseBackupSetting]"},
        "ignore_conflicting_host_names": {"key": "properties.ignoreConflictingHostNames", "type": "bool"},
        "ignore_databases": {"key": "properties.ignoreDatabases", "type": "bool"},
        "app_service_plan": {"key": "properties.appServicePlan", "type": "str"},
        "operation_type": {"key": "properties.operationType", "type": "str"},
        "adjust_connection_strings": {"key": "properties.adjustConnectionStrings", "type": "bool"},
        "hosting_environment": {"key": "properties.hostingEnvironment", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        storage_account_url: Optional[str] = None,
        blob_name: Optional[str] = None,
        overwrite: Optional[bool] = None,
        site_name: Optional[str] = None,
        databases: Optional[List["_models.DatabaseBackupSetting"]] = None,
        ignore_conflicting_host_names: bool = False,
        ignore_databases: bool = False,
        app_service_plan: Optional[str] = None,
        operation_type: Union[str, "_models.BackupRestoreOperationType"] = "Default",
        adjust_connection_strings: Optional[bool] = None,
        hosting_environment: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword storage_account_url: SAS URL to the container.
        :paramtype storage_account_url: str
        :keyword blob_name: Name of a blob which contains the backup.
        :paramtype blob_name: str
        :keyword overwrite: :code:`<code>true</code>` if the restore operation can overwrite target
         app; otherwise, :code:`<code>false</code>`. :code:`<code>true</code>` is needed if trying to
         restore over an existing app.
        :paramtype overwrite: bool
        :keyword site_name: Name of an app.
        :paramtype site_name: str
        :keyword databases: Collection of databases which should be restored. This list has to match
         the list of databases included in the backup.
        :paramtype databases: list[~azure.mgmt.web.v2018_02_01.models.DatabaseBackupSetting]
        :keyword ignore_conflicting_host_names: Changes a logic when restoring an app with custom
         domains. :code:`<code>true</code>` to remove custom domains automatically. If
         :code:`<code>false</code>`, custom domains are added to
         the app's object when it is being restored, but that might fail due to conflicts during the
         operation.
        :paramtype ignore_conflicting_host_names: bool
        :keyword ignore_databases: Ignore the databases and only restore the site content.
        :paramtype ignore_databases: bool
        :keyword app_service_plan: Specify app service plan that will own restored site.
        :paramtype app_service_plan: str
        :keyword operation_type: Operation type. Known values are: "Default", "Clone", "Relocation",
         "Snapshot", and "CloudFS".
        :paramtype operation_type: str or ~azure.mgmt.web.v2018_02_01.models.BackupRestoreOperationType
        :keyword adjust_connection_strings: :code:`<code>true</code>` if SiteConfig.ConnectionStrings
         should be set in new app; otherwise, :code:`<code>false</code>`.
        :paramtype adjust_connection_strings: bool
        :keyword hosting_environment: App Service Environment name, if needed (only when restoring an
         app to an App Service Environment).
        :paramtype hosting_environment: str
        """
        super().__init__(kind=kind, **kwargs)
        self.storage_account_url = storage_account_url
        self.blob_name = blob_name
        self.overwrite = overwrite
        self.site_name = site_name
        self.databases = databases
        self.ignore_conflicting_host_names = ignore_conflicting_host_names
        self.ignore_databases = ignore_databases
        self.app_service_plan = app_service_plan
        self.operation_type = operation_type
        self.adjust_connection_strings = adjust_connection_strings
        self.hosting_environment = hosting_environment


class ServiceSpecification(_serialization.Model):
    """Resource metrics service provided by Microsoft.Insights resource provider.

    :ivar metric_specifications:
    :vartype metric_specifications: list[~azure.mgmt.web.v2018_02_01.models.MetricSpecification]
    :ivar log_specifications:
    :vartype log_specifications: list[~azure.mgmt.web.v2018_02_01.models.LogSpecification]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["_models.MetricSpecification"]] = None,
        log_specifications: Optional[List["_models.LogSpecification"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metric_specifications:
        :paramtype metric_specifications: list[~azure.mgmt.web.v2018_02_01.models.MetricSpecification]
        :keyword log_specifications:
        :paramtype log_specifications: list[~azure.mgmt.web.v2018_02_01.models.LogSpecification]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications


class Site(Resource):  # pylint: disable=too-many-instance-attributes
    """A web app, a mobile app backend, or an API app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed service identity.
    :vartype identity: ~azure.mgmt.web.v2018_02_01.models.ManagedServiceIdentity
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Known values are: "Normal" and "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2018_02_01.models.UsageState
    :ivar enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :vartype enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Known values
     are: "Normal", "Limited", and "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2018_02_01.models.SiteAvailabilityState
    :ivar host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :vartype host_name_ssl_states: list[~azure.mgmt.web.v2018_02_01.models.HostNameSslState]
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    :ivar reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :vartype reserved: bool
    :ivar is_xenon: Obsolete: Hyper-V sandbox.
    :vartype is_xenon: bool
    :ivar hyper_v: Hyper-V sandbox.
    :vartype hyper_v: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar site_config: Configuration of the app.
    :vartype site_config: ~azure.mgmt.web.v2018_02_01.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :ivar scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :vartype scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :ivar hosting_environment_profile: App Service Environment to use for the app.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2018_02_01.models.HostingEnvironmentProfile
    :ivar client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :vartype client_affinity_enabled: bool
    :ivar client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :vartype client_cert_enabled: bool
    :ivar client_cert_exclusion_paths: client certificate authentication comma-separated exclusion
     paths.
    :vartype client_cert_exclusion_paths: str
    :ivar host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :vartype host_names_disabled: bool
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants. Read-only.
    :vartype possible_outbound_ip_addresses: str
    :ivar container_size: Size of the function container.
    :vartype container_size: int
    :ivar daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :vartype daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :ivar cloning_info: If specified during app creation, the app is cloned from a source app.
    :vartype cloning_info: ~azure.mgmt.web.v2018_02_01.models.CloningInfo
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2018_02_01.models.SlotSwapStatus
    :ivar https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :vartype https_only: bool
    :ivar redundancy_mode: Site redundancy mode. Known values are: "None", "Manual", "Failover",
     "ActiveActive", and "GeoRedundant".
    :vartype redundancy_mode: str or ~azure.mgmt.web.v2018_02_01.models.RedundancyMode
    :ivar in_progress_operation_id: Specifies an operation id if this site has a pending operation.
    :vartype in_progress_operation_id: str
    :ivar geo_distributions: GeoDistributions for this site.
    :vartype geo_distributions: list[~azure.mgmt.web.v2018_02_01.models.GeoDistribution]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "state": {"readonly": True},
        "host_names": {"readonly": True},
        "repository_site_name": {"readonly": True},
        "usage_state": {"readonly": True},
        "enabled_host_names": {"readonly": True},
        "availability_state": {"readonly": True},
        "last_modified_time_utc": {"readonly": True},
        "traffic_manager_host_names": {"readonly": True},
        "target_swap_slot": {"readonly": True},
        "outbound_ip_addresses": {"readonly": True},
        "possible_outbound_ip_addresses": {"readonly": True},
        "suspended_till": {"readonly": True},
        "max_number_of_workers": {"readonly": True},
        "resource_group": {"readonly": True},
        "is_default_container": {"readonly": True},
        "default_host_name": {"readonly": True},
        "slot_swap_status": {"readonly": True},
        "in_progress_operation_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "state": {"key": "properties.state", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
        "repository_site_name": {"key": "properties.repositorySiteName", "type": "str"},
        "usage_state": {"key": "properties.usageState", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "enabled_host_names": {"key": "properties.enabledHostNames", "type": "[str]"},
        "availability_state": {"key": "properties.availabilityState", "type": "str"},
        "host_name_ssl_states": {"key": "properties.hostNameSslStates", "type": "[HostNameSslState]"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
        "reserved": {"key": "properties.reserved", "type": "bool"},
        "is_xenon": {"key": "properties.isXenon", "type": "bool"},
        "hyper_v": {"key": "properties.hyperV", "type": "bool"},
        "last_modified_time_utc": {"key": "properties.lastModifiedTimeUtc", "type": "iso-8601"},
        "site_config": {"key": "properties.siteConfig", "type": "SiteConfig"},
        "traffic_manager_host_names": {"key": "properties.trafficManagerHostNames", "type": "[str]"},
        "scm_site_also_stopped": {"key": "properties.scmSiteAlsoStopped", "type": "bool"},
        "target_swap_slot": {"key": "properties.targetSwapSlot", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "client_affinity_enabled": {"key": "properties.clientAffinityEnabled", "type": "bool"},
        "client_cert_enabled": {"key": "properties.clientCertEnabled", "type": "bool"},
        "client_cert_exclusion_paths": {"key": "properties.clientCertExclusionPaths", "type": "str"},
        "host_names_disabled": {"key": "properties.hostNamesDisabled", "type": "bool"},
        "outbound_ip_addresses": {"key": "properties.outboundIpAddresses", "type": "str"},
        "possible_outbound_ip_addresses": {"key": "properties.possibleOutboundIpAddresses", "type": "str"},
        "container_size": {"key": "properties.containerSize", "type": "int"},
        "daily_memory_time_quota": {"key": "properties.dailyMemoryTimeQuota", "type": "int"},
        "suspended_till": {"key": "properties.suspendedTill", "type": "iso-8601"},
        "max_number_of_workers": {"key": "properties.maxNumberOfWorkers", "type": "int"},
        "cloning_info": {"key": "properties.cloningInfo", "type": "CloningInfo"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "is_default_container": {"key": "properties.isDefaultContainer", "type": "bool"},
        "default_host_name": {"key": "properties.defaultHostName", "type": "str"},
        "slot_swap_status": {"key": "properties.slotSwapStatus", "type": "SlotSwapStatus"},
        "https_only": {"key": "properties.httpsOnly", "type": "bool"},
        "redundancy_mode": {"key": "properties.redundancyMode", "type": "str"},
        "in_progress_operation_id": {"key": "properties.inProgressOperationId", "type": "str"},
        "geo_distributions": {"key": "properties.geoDistributions", "type": "[GeoDistribution]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        enabled: Optional[bool] = None,
        host_name_ssl_states: Optional[List["_models.HostNameSslState"]] = None,
        server_farm_id: Optional[str] = None,
        reserved: bool = False,
        is_xenon: bool = False,
        hyper_v: bool = False,
        site_config: Optional["_models.SiteConfig"] = None,
        scm_site_also_stopped: bool = False,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        client_affinity_enabled: Optional[bool] = None,
        client_cert_enabled: Optional[bool] = None,
        client_cert_exclusion_paths: Optional[str] = None,
        host_names_disabled: Optional[bool] = None,
        container_size: Optional[int] = None,
        daily_memory_time_quota: Optional[int] = None,
        cloning_info: Optional["_models.CloningInfo"] = None,
        https_only: Optional[bool] = None,
        redundancy_mode: Optional[Union[str, "_models.RedundancyMode"]] = None,
        geo_distributions: Optional[List["_models.GeoDistribution"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed service identity.
        :paramtype identity: ~azure.mgmt.web.v2018_02_01.models.ManagedServiceIdentity
        :keyword enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
         :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
         offline).
        :paramtype enabled: bool
        :keyword host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for
         app's hostnames.
        :paramtype host_name_ssl_states: list[~azure.mgmt.web.v2018_02_01.models.HostNameSslState]
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        :keyword reserved: :code:`<code>true</code>` if reserved; otherwise,
         :code:`<code>false</code>`.
        :paramtype reserved: bool
        :keyword is_xenon: Obsolete: Hyper-V sandbox.
        :paramtype is_xenon: bool
        :keyword hyper_v: Hyper-V sandbox.
        :paramtype hyper_v: bool
        :keyword site_config: Configuration of the app.
        :paramtype site_config: ~azure.mgmt.web.v2018_02_01.models.SiteConfig
        :keyword scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app
         is stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
        :paramtype scm_site_also_stopped: bool
        :keyword hosting_environment_profile: App Service Environment to use for the app.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2018_02_01.models.HostingEnvironmentProfile
        :keyword client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
         :code:`<code>false</code>` to stop sending session affinity cookies, which route client
         requests in the same session to the same instance. Default is :code:`<code>true</code>`.
        :paramtype client_affinity_enabled: bool
        :keyword client_cert_enabled: :code:`<code>true</code>` to enable client certificate
         authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
         :code:`<code>false</code>`.
        :paramtype client_cert_enabled: bool
        :keyword client_cert_exclusion_paths: client certificate authentication comma-separated
         exclusion paths.
        :paramtype client_cert_exclusion_paths: str
        :keyword host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
         app; otherwise, :code:`<code>false</code>`.
          If :code:`<code>true</code>`, the app is only accessible via API management process.
        :paramtype host_names_disabled: bool
        :keyword container_size: Size of the function container.
        :paramtype container_size: int
        :keyword daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on
         dynamic apps only).
        :paramtype daily_memory_time_quota: int
        :keyword cloning_info: If specified during app creation, the app is cloned from a source app.
        :paramtype cloning_info: ~azure.mgmt.web.v2018_02_01.models.CloningInfo
        :keyword https_only: HttpsOnly: configures a web site to accept only https requests. Issues
         redirect for
         http requests.
        :paramtype https_only: bool
        :keyword redundancy_mode: Site redundancy mode. Known values are: "None", "Manual", "Failover",
         "ActiveActive", and "GeoRedundant".
        :paramtype redundancy_mode: str or ~azure.mgmt.web.v2018_02_01.models.RedundancyMode
        :keyword geo_distributions: GeoDistributions for this site.
        :paramtype geo_distributions: list[~azure.mgmt.web.v2018_02_01.models.GeoDistribution]
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.identity = identity
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = enabled
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = host_name_ssl_states
        self.server_farm_id = server_farm_id
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.last_modified_time_utc = None
        self.site_config = site_config
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = scm_site_also_stopped
        self.target_swap_slot = None
        self.hosting_environment_profile = hosting_environment_profile
        self.client_affinity_enabled = client_affinity_enabled
        self.client_cert_enabled = client_cert_enabled
        self.client_cert_exclusion_paths = client_cert_exclusion_paths
        self.host_names_disabled = host_names_disabled
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = container_size
        self.daily_memory_time_quota = daily_memory_time_quota
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = cloning_info
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = https_only
        self.redundancy_mode = redundancy_mode
        self.in_progress_operation_id = None
        self.geo_distributions = geo_distributions


class SiteAuthSettings(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Configuration settings for the Azure App Service Authentication / Authorization feature.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
     enabled for the current app; otherwise, :code:`<code>false</code>`.
    :vartype enabled: bool
    :ivar runtime_version: The RuntimeVersion of the Authentication / Authorization feature in use
     for the current app.
     The setting in this value can control the behavior of certain features in the Authentication /
     Authorization module.
    :vartype runtime_version: str
    :ivar unauthenticated_client_action: The action to take when an unauthenticated client attempts
     to access the app. Known values are: "RedirectToLoginPage" and "AllowAnonymous".
    :vartype unauthenticated_client_action: str or
     ~azure.mgmt.web.v2018_02_01.models.UnauthenticatedClientAction
    :ivar token_store_enabled: :code:`<code>true</code>` to durably store platform-specific
     security tokens that are obtained during login flows; otherwise, :code:`<code>false</code>`.
      The default is :code:`<code>false</code>`.
    :vartype token_store_enabled: bool
    :ivar allowed_external_redirect_urls: External URLs that can be redirected to as part of
     logging in or logging out of the app. Note that the query string part of the URL is ignored.
     This is an advanced setting typically only needed by Windows Store application backends.
     Note that URLs within the current domain are always implicitly allowed.
    :vartype allowed_external_redirect_urls: list[str]
    :ivar default_provider: The default authentication provider to use when multiple providers are
     configured.
     This setting is only needed if multiple providers are configured and the unauthenticated
     client
     action is set to "RedirectToLoginPage". Known values are: "AzureActiveDirectory", "Facebook",
     "Google", "MicrosoftAccount", and "Twitter".
    :vartype default_provider: str or
     ~azure.mgmt.web.v2018_02_01.models.BuiltInAuthenticationProvider
    :ivar token_refresh_extension_hours: The number of hours after session token expiration that a
     session token can be used to
     call the token refresh API. The default is 72 hours.
    :vartype token_refresh_extension_hours: float
    :ivar client_id: The Client ID of this relying party application, known as the client_id.
     This setting is required for enabling OpenID Connection authentication with Azure Active
     Directory or
     other 3rd party OpenID Connect providers.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :vartype client_id: str
    :ivar client_secret: The Client Secret of this relying party application (in Azure Active
     Directory, this is also referred to as the Key).
     This setting is optional. If no client secret is configured, the OpenID Connect implicit auth
     flow is used to authenticate end users.
     Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :vartype client_secret: str
    :ivar client_secret_certificate_thumbprint: An alternative to the client secret, that is the
     thumbprint of a certificate used for signing purposes. This property acts as
     a replacement for the Client Secret. It is also optional.
    :vartype client_secret_certificate_thumbprint: str
    :ivar issuer: The OpenID Connect Issuer URI that represents the entity which issues access
     tokens for this application.
     When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
     https://sts.windows.net/{tenant-guid}/.
     This URI is a case-sensitive identifier for the token issuer.
     More information on OpenID Connect Discovery:
     http://openid.net/specs/openid-connect-discovery-1_0.html.
    :vartype issuer: str
    :ivar validate_issuer: Gets a value indicating whether the issuer should be a valid HTTPS url
     and be validated as such.
    :vartype validate_issuer: bool
    :ivar allowed_audiences: Allowed audience values to consider when validating JWTs issued by
     Azure Active Directory. Note that the :code:`<code>ClientID</code>` value is always considered
     an
     allowed audience, regardless of this setting.
    :vartype allowed_audiences: list[str]
    :ivar additional_login_params: Login parameters to send to the OpenID Connect authorization
     endpoint when
     a user logs in. Each parameter must be in the form "key=value".
    :vartype additional_login_params: list[str]
    :ivar google_client_id: The OpenID Connect Client ID for the Google web application.
     This setting is required for enabling Google Sign-In.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :vartype google_client_id: str
    :ivar google_client_secret: The client secret associated with the Google web application.
     This setting is required for enabling Google Sign-In.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :vartype google_client_secret: str
    :ivar google_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Google
     Sign-In authentication.
     This setting is optional. If not specified, "openid", "profile", and "email" are used as
     default scopes.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :vartype google_o_auth_scopes: list[str]
    :ivar facebook_app_id: The App ID of the Facebook app used for login.
     This setting is required for enabling Facebook Login.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :vartype facebook_app_id: str
    :ivar facebook_app_secret: The App Secret of the Facebook app used for Facebook Login.
     This setting is required for enabling Facebook Login.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :vartype facebook_app_secret: str
    :ivar facebook_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Facebook
     Login authentication.
     This setting is optional.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :vartype facebook_o_auth_scopes: list[str]
    :ivar twitter_consumer_key: The OAuth 1.0a consumer key of the Twitter application used for
     sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :vartype twitter_consumer_key: str
    :ivar twitter_consumer_secret: The OAuth 1.0a consumer secret of the Twitter application used
     for sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :vartype twitter_consumer_secret: str
    :ivar microsoft_account_client_id: The OAuth 2.0 client ID that was created for the app used
     for authentication.
     This setting is required for enabling Microsoft Account authentication.
     Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
    :vartype microsoft_account_client_id: str
    :ivar microsoft_account_client_secret: The OAuth 2.0 client secret that was created for the app
     used for authentication.
     This setting is required for enabling Microsoft Account authentication.
     Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
    :vartype microsoft_account_client_secret: str
    :ivar microsoft_account_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of
     Microsoft Account authentication.
     This setting is optional. If not specified, "wl.basic" is used as the default scope.
     Microsoft Account Scopes and permissions documentation:
     https://msdn.microsoft.com/en-us/library/dn631845.aspx.
    :vartype microsoft_account_o_auth_scopes: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "runtime_version": {"key": "properties.runtimeVersion", "type": "str"},
        "unauthenticated_client_action": {"key": "properties.unauthenticatedClientAction", "type": "str"},
        "token_store_enabled": {"key": "properties.tokenStoreEnabled", "type": "bool"},
        "allowed_external_redirect_urls": {"key": "properties.allowedExternalRedirectUrls", "type": "[str]"},
        "default_provider": {"key": "properties.defaultProvider", "type": "str"},
        "token_refresh_extension_hours": {"key": "properties.tokenRefreshExtensionHours", "type": "float"},
        "client_id": {"key": "properties.clientId", "type": "str"},
        "client_secret": {"key": "properties.clientSecret", "type": "str"},
        "client_secret_certificate_thumbprint": {"key": "properties.clientSecretCertificateThumbprint", "type": "str"},
        "issuer": {"key": "properties.issuer", "type": "str"},
        "validate_issuer": {"key": "properties.validateIssuer", "type": "bool"},
        "allowed_audiences": {"key": "properties.allowedAudiences", "type": "[str]"},
        "additional_login_params": {"key": "properties.additionalLoginParams", "type": "[str]"},
        "google_client_id": {"key": "properties.googleClientId", "type": "str"},
        "google_client_secret": {"key": "properties.googleClientSecret", "type": "str"},
        "google_o_auth_scopes": {"key": "properties.googleOAuthScopes", "type": "[str]"},
        "facebook_app_id": {"key": "properties.facebookAppId", "type": "str"},
        "facebook_app_secret": {"key": "properties.facebookAppSecret", "type": "str"},
        "facebook_o_auth_scopes": {"key": "properties.facebookOAuthScopes", "type": "[str]"},
        "twitter_consumer_key": {"key": "properties.twitterConsumerKey", "type": "str"},
        "twitter_consumer_secret": {"key": "properties.twitterConsumerSecret", "type": "str"},
        "microsoft_account_client_id": {"key": "properties.microsoftAccountClientId", "type": "str"},
        "microsoft_account_client_secret": {"key": "properties.microsoftAccountClientSecret", "type": "str"},
        "microsoft_account_o_auth_scopes": {"key": "properties.microsoftAccountOAuthScopes", "type": "[str]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        enabled: Optional[bool] = None,
        runtime_version: Optional[str] = None,
        unauthenticated_client_action: Optional[Union[str, "_models.UnauthenticatedClientAction"]] = None,
        token_store_enabled: Optional[bool] = None,
        allowed_external_redirect_urls: Optional[List[str]] = None,
        default_provider: Optional[Union[str, "_models.BuiltInAuthenticationProvider"]] = None,
        token_refresh_extension_hours: Optional[float] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        client_secret_certificate_thumbprint: Optional[str] = None,
        issuer: Optional[str] = None,
        validate_issuer: Optional[bool] = None,
        allowed_audiences: Optional[List[str]] = None,
        additional_login_params: Optional[List[str]] = None,
        google_client_id: Optional[str] = None,
        google_client_secret: Optional[str] = None,
        google_o_auth_scopes: Optional[List[str]] = None,
        facebook_app_id: Optional[str] = None,
        facebook_app_secret: Optional[str] = None,
        facebook_o_auth_scopes: Optional[List[str]] = None,
        twitter_consumer_key: Optional[str] = None,
        twitter_consumer_secret: Optional[str] = None,
        microsoft_account_client_id: Optional[str] = None,
        microsoft_account_client_secret: Optional[str] = None,
        microsoft_account_o_auth_scopes: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
         enabled for the current app; otherwise, :code:`<code>false</code>`.
        :paramtype enabled: bool
        :keyword runtime_version: The RuntimeVersion of the Authentication / Authorization feature in
         use for the current app.
         The setting in this value can control the behavior of certain features in the Authentication /
         Authorization module.
        :paramtype runtime_version: str
        :keyword unauthenticated_client_action: The action to take when an unauthenticated client
         attempts to access the app. Known values are: "RedirectToLoginPage" and "AllowAnonymous".
        :paramtype unauthenticated_client_action: str or
         ~azure.mgmt.web.v2018_02_01.models.UnauthenticatedClientAction
        :keyword token_store_enabled: :code:`<code>true</code>` to durably store platform-specific
         security tokens that are obtained during login flows; otherwise, :code:`<code>false</code>`.
          The default is :code:`<code>false</code>`.
        :paramtype token_store_enabled: bool
        :keyword allowed_external_redirect_urls: External URLs that can be redirected to as part of
         logging in or logging out of the app. Note that the query string part of the URL is ignored.
         This is an advanced setting typically only needed by Windows Store application backends.
         Note that URLs within the current domain are always implicitly allowed.
        :paramtype allowed_external_redirect_urls: list[str]
        :keyword default_provider: The default authentication provider to use when multiple providers
         are configured.
         This setting is only needed if multiple providers are configured and the unauthenticated
         client
         action is set to "RedirectToLoginPage". Known values are: "AzureActiveDirectory", "Facebook",
         "Google", "MicrosoftAccount", and "Twitter".
        :paramtype default_provider: str or
         ~azure.mgmt.web.v2018_02_01.models.BuiltInAuthenticationProvider
        :keyword token_refresh_extension_hours: The number of hours after session token expiration that
         a session token can be used to
         call the token refresh API. The default is 72 hours.
        :paramtype token_refresh_extension_hours: float
        :keyword client_id: The Client ID of this relying party application, known as the client_id.
         This setting is required for enabling OpenID Connection authentication with Azure Active
         Directory or
         other 3rd party OpenID Connect providers.
         More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
        :paramtype client_id: str
        :keyword client_secret: The Client Secret of this relying party application (in Azure Active
         Directory, this is also referred to as the Key).
         This setting is optional. If no client secret is configured, the OpenID Connect implicit auth
         flow is used to authenticate end users.
         Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
         More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
        :paramtype client_secret: str
        :keyword client_secret_certificate_thumbprint: An alternative to the client secret, that is the
         thumbprint of a certificate used for signing purposes. This property acts as
         a replacement for the Client Secret. It is also optional.
        :paramtype client_secret_certificate_thumbprint: str
        :keyword issuer: The OpenID Connect Issuer URI that represents the entity which issues access
         tokens for this application.
         When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
         https://sts.windows.net/{tenant-guid}/.
         This URI is a case-sensitive identifier for the token issuer.
         More information on OpenID Connect Discovery:
         http://openid.net/specs/openid-connect-discovery-1_0.html.
        :paramtype issuer: str
        :keyword validate_issuer: Gets a value indicating whether the issuer should be a valid HTTPS
         url and be validated as such.
        :paramtype validate_issuer: bool
        :keyword allowed_audiences: Allowed audience values to consider when validating JWTs issued by
         Azure Active Directory. Note that the :code:`<code>ClientID</code>` value is always considered
         an
         allowed audience, regardless of this setting.
        :paramtype allowed_audiences: list[str]
        :keyword additional_login_params: Login parameters to send to the OpenID Connect authorization
         endpoint when
         a user logs in. Each parameter must be in the form "key=value".
        :paramtype additional_login_params: list[str]
        :keyword google_client_id: The OpenID Connect Client ID for the Google web application.
         This setting is required for enabling Google Sign-In.
         Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
        :paramtype google_client_id: str
        :keyword google_client_secret: The client secret associated with the Google web application.
         This setting is required for enabling Google Sign-In.
         Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
        :paramtype google_client_secret: str
        :keyword google_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Google
         Sign-In authentication.
         This setting is optional. If not specified, "openid", "profile", and "email" are used as
         default scopes.
         Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
        :paramtype google_o_auth_scopes: list[str]
        :keyword facebook_app_id: The App ID of the Facebook app used for login.
         This setting is required for enabling Facebook Login.
         Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
        :paramtype facebook_app_id: str
        :keyword facebook_app_secret: The App Secret of the Facebook app used for Facebook Login.
         This setting is required for enabling Facebook Login.
         Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
        :paramtype facebook_app_secret: str
        :keyword facebook_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of
         Facebook Login authentication.
         This setting is optional.
         Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
        :paramtype facebook_o_auth_scopes: list[str]
        :keyword twitter_consumer_key: The OAuth 1.0a consumer key of the Twitter application used for
         sign-in.
         This setting is required for enabling Twitter Sign-In.
         Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
        :paramtype twitter_consumer_key: str
        :keyword twitter_consumer_secret: The OAuth 1.0a consumer secret of the Twitter application
         used for sign-in.
         This setting is required for enabling Twitter Sign-In.
         Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
        :paramtype twitter_consumer_secret: str
        :keyword microsoft_account_client_id: The OAuth 2.0 client ID that was created for the app used
         for authentication.
         This setting is required for enabling Microsoft Account authentication.
         Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
        :paramtype microsoft_account_client_id: str
        :keyword microsoft_account_client_secret: The OAuth 2.0 client secret that was created for the
         app used for authentication.
         This setting is required for enabling Microsoft Account authentication.
         Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
        :paramtype microsoft_account_client_secret: str
        :keyword microsoft_account_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part
         of Microsoft Account authentication.
         This setting is optional. If not specified, "wl.basic" is used as the default scope.
         Microsoft Account Scopes and permissions documentation:
         https://msdn.microsoft.com/en-us/library/dn631845.aspx.
        :paramtype microsoft_account_o_auth_scopes: list[str]
        """
        super().__init__(kind=kind, **kwargs)
        self.enabled = enabled
        self.runtime_version = runtime_version
        self.unauthenticated_client_action = unauthenticated_client_action
        self.token_store_enabled = token_store_enabled
        self.allowed_external_redirect_urls = allowed_external_redirect_urls
        self.default_provider = default_provider
        self.token_refresh_extension_hours = token_refresh_extension_hours
        self.client_id = client_id
        self.client_secret = client_secret
        self.client_secret_certificate_thumbprint = client_secret_certificate_thumbprint
        self.issuer = issuer
        self.validate_issuer = validate_issuer
        self.allowed_audiences = allowed_audiences
        self.additional_login_params = additional_login_params
        self.google_client_id = google_client_id
        self.google_client_secret = google_client_secret
        self.google_o_auth_scopes = google_o_auth_scopes
        self.facebook_app_id = facebook_app_id
        self.facebook_app_secret = facebook_app_secret
        self.facebook_o_auth_scopes = facebook_o_auth_scopes
        self.twitter_consumer_key = twitter_consumer_key
        self.twitter_consumer_secret = twitter_consumer_secret
        self.microsoft_account_client_id = microsoft_account_client_id
        self.microsoft_account_client_secret = microsoft_account_client_secret
        self.microsoft_account_o_auth_scopes = microsoft_account_o_auth_scopes


class SiteCloneability(_serialization.Model):
    """Represents whether or not an app is cloneable.

    :ivar result: Name of app. Known values are: "Cloneable", "PartiallyCloneable", and
     "NotCloneable".
    :vartype result: str or ~azure.mgmt.web.v2018_02_01.models.CloneAbilityResult
    :ivar blocking_features: List of features enabled on app that prevent cloning.
    :vartype blocking_features: list[~azure.mgmt.web.v2018_02_01.models.SiteCloneabilityCriterion]
    :ivar unsupported_features: List of features enabled on app that are non-blocking but cannot be
     cloned. The app can still be cloned
     but the features in this list will not be set up on cloned app.
    :vartype unsupported_features:
     list[~azure.mgmt.web.v2018_02_01.models.SiteCloneabilityCriterion]
    :ivar blocking_characteristics: List of blocking application characteristics.
    :vartype blocking_characteristics:
     list[~azure.mgmt.web.v2018_02_01.models.SiteCloneabilityCriterion]
    """

    _attribute_map = {
        "result": {"key": "result", "type": "str"},
        "blocking_features": {"key": "blockingFeatures", "type": "[SiteCloneabilityCriterion]"},
        "unsupported_features": {"key": "unsupportedFeatures", "type": "[SiteCloneabilityCriterion]"},
        "blocking_characteristics": {"key": "blockingCharacteristics", "type": "[SiteCloneabilityCriterion]"},
    }

    def __init__(
        self,
        *,
        result: Optional[Union[str, "_models.CloneAbilityResult"]] = None,
        blocking_features: Optional[List["_models.SiteCloneabilityCriterion"]] = None,
        unsupported_features: Optional[List["_models.SiteCloneabilityCriterion"]] = None,
        blocking_characteristics: Optional[List["_models.SiteCloneabilityCriterion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword result: Name of app. Known values are: "Cloneable", "PartiallyCloneable", and
         "NotCloneable".
        :paramtype result: str or ~azure.mgmt.web.v2018_02_01.models.CloneAbilityResult
        :keyword blocking_features: List of features enabled on app that prevent cloning.
        :paramtype blocking_features:
         list[~azure.mgmt.web.v2018_02_01.models.SiteCloneabilityCriterion]
        :keyword unsupported_features: List of features enabled on app that are non-blocking but cannot
         be cloned. The app can still be cloned
         but the features in this list will not be set up on cloned app.
        :paramtype unsupported_features:
         list[~azure.mgmt.web.v2018_02_01.models.SiteCloneabilityCriterion]
        :keyword blocking_characteristics: List of blocking application characteristics.
        :paramtype blocking_characteristics:
         list[~azure.mgmt.web.v2018_02_01.models.SiteCloneabilityCriterion]
        """
        super().__init__(**kwargs)
        self.result = result
        self.blocking_features = blocking_features
        self.unsupported_features = unsupported_features
        self.blocking_characteristics = blocking_characteristics


class SiteCloneabilityCriterion(_serialization.Model):
    """An app cloneability criterion.

    :ivar name: Name of criterion.
    :vartype name: str
    :ivar description: Description of criterion.
    :vartype description: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of criterion.
        :paramtype name: str
        :keyword description: Description of criterion.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description


class SiteConfig(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Configuration of an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar number_of_workers: Number of workers.
    :vartype number_of_workers: int
    :ivar default_documents: Default documents.
    :vartype default_documents: list[str]
    :ivar net_framework_version: .NET Framework version.
    :vartype net_framework_version: str
    :ivar php_version: Version of PHP.
    :vartype php_version: str
    :ivar python_version: Version of Python.
    :vartype python_version: str
    :ivar node_version: Version of Node.js.
    :vartype node_version: str
    :ivar linux_fx_version: Linux App Framework and version.
    :vartype linux_fx_version: str
    :ivar windows_fx_version: Xenon App Framework and version.
    :vartype windows_fx_version: str
    :ivar request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype request_tracing_enabled: bool
    :ivar request_tracing_expiration_time: Request tracing expiration time.
    :vartype request_tracing_expiration_time: ~datetime.datetime
    :ivar remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype remote_debugging_enabled: bool
    :ivar remote_debugging_version: Remote debugging version.
    :vartype remote_debugging_version: str
    :ivar http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype http_logging_enabled: bool
    :ivar logs_directory_size_limit: HTTP logs directory size limit.
    :vartype logs_directory_size_limit: int
    :ivar detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :vartype detailed_error_logging_enabled: bool
    :ivar publishing_username: Publishing user name.
    :vartype publishing_username: str
    :ivar app_settings: Application settings.
    :vartype app_settings: list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]
    :ivar azure_storage_accounts: User-provided Azure storage accounts.
    :vartype azure_storage_accounts: dict[str,
     ~azure.mgmt.web.v2018_02_01.models.AzureStorageInfoValue]
    :ivar connection_strings: Connection strings.
    :vartype connection_strings: list[~azure.mgmt.web.v2018_02_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2018_02_01.models.SiteMachineKey
    :ivar handler_mappings: Handler mappings.
    :vartype handler_mappings: list[~azure.mgmt.web.v2018_02_01.models.HandlerMapping]
    :ivar document_root: Document root.
    :vartype document_root: str
    :ivar scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
     "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
     "OneDrive", and "VSO".
    :vartype scm_type: str or ~azure.mgmt.web.v2018_02_01.models.ScmType
    :ivar use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :vartype use32_bit_worker_process: bool
    :ivar web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype web_sockets_enabled: bool
    :ivar always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype always_on: bool
    :ivar java_version: Java version.
    :vartype java_version: str
    :ivar java_container: Java container.
    :vartype java_container: str
    :ivar java_container_version: Java container version.
    :vartype java_container_version: str
    :ivar app_command_line: App command line to launch.
    :vartype app_command_line: str
    :ivar managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated" and
     "Classic".
    :vartype managed_pipeline_mode: str or ~azure.mgmt.web.v2018_02_01.models.ManagedPipelineMode
    :ivar virtual_applications: Virtual applications.
    :vartype virtual_applications: list[~azure.mgmt.web.v2018_02_01.models.VirtualApplication]
    :ivar load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", and "RequestHash".
    :vartype load_balancing: str or ~azure.mgmt.web.v2018_02_01.models.SiteLoadBalancing
    :ivar experiments: This is work around for polymorphic types.
    :vartype experiments: ~azure.mgmt.web.v2018_02_01.models.Experiments
    :ivar limits: Site limits.
    :vartype limits: ~azure.mgmt.web.v2018_02_01.models.SiteLimits
    :ivar auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype auto_heal_enabled: bool
    :ivar auto_heal_rules: Auto Heal rules.
    :vartype auto_heal_rules: ~azure.mgmt.web.v2018_02_01.models.AutoHealRules
    :ivar tracing_options: Tracing options.
    :vartype tracing_options: str
    :ivar vnet_name: Virtual Network name.
    :vartype vnet_name: str
    :ivar cors: Cross-Origin Resource Sharing (CORS) settings.
    :vartype cors: ~azure.mgmt.web.v2018_02_01.models.CorsSettings
    :ivar push: Push endpoint settings.
    :vartype push: ~azure.mgmt.web.v2018_02_01.models.PushSettings
    :ivar api_definition: Information about the formal API definition for the app.
    :vartype api_definition: ~azure.mgmt.web.v2018_02_01.models.ApiDefinitionInfo
    :ivar auto_swap_slot_name: Auto-swap slot name.
    :vartype auto_swap_slot_name: str
    :ivar local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :vartype local_my_sql_enabled: bool
    :ivar managed_service_identity_id: Managed Service Identity Id.
    :vartype managed_service_identity_id: int
    :ivar x_managed_service_identity_id: Explicit Managed Service Identity Id.
    :vartype x_managed_service_identity_id: int
    :ivar ip_security_restrictions: IP security restrictions for main.
    :vartype ip_security_restrictions:
     list[~azure.mgmt.web.v2018_02_01.models.IpSecurityRestriction]
    :ivar scm_ip_security_restrictions: IP security restrictions for scm.
    :vartype scm_ip_security_restrictions:
     list[~azure.mgmt.web.v2018_02_01.models.IpSecurityRestriction]
    :ivar scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
    :vartype scm_ip_security_restrictions_use_main: bool
    :ivar http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :vartype http20_enabled: bool
    :ivar min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Known values are: "1.0", "1.1", and "1.2".
    :vartype min_tls_version: str or ~azure.mgmt.web.v2018_02_01.models.SupportedTlsVersions
    :ivar ftps_state: State of FTP / FTPS service. Known values are: "AllAllowed", "FtpsOnly", and
     "Disabled".
    :vartype ftps_state: str or ~azure.mgmt.web.v2018_02_01.models.FtpsState
    :ivar reserved_instance_count: Number of reserved instances.
     This setting only applies to the Consumption Plan.
    :vartype reserved_instance_count: int
    """

    _validation = {
        "machine_key": {"readonly": True},
        "reserved_instance_count": {"maximum": 10, "minimum": 0},
    }

    _attribute_map = {
        "number_of_workers": {"key": "numberOfWorkers", "type": "int"},
        "default_documents": {"key": "defaultDocuments", "type": "[str]"},
        "net_framework_version": {"key": "netFrameworkVersion", "type": "str"},
        "php_version": {"key": "phpVersion", "type": "str"},
        "python_version": {"key": "pythonVersion", "type": "str"},
        "node_version": {"key": "nodeVersion", "type": "str"},
        "linux_fx_version": {"key": "linuxFxVersion", "type": "str"},
        "windows_fx_version": {"key": "windowsFxVersion", "type": "str"},
        "request_tracing_enabled": {"key": "requestTracingEnabled", "type": "bool"},
        "request_tracing_expiration_time": {"key": "requestTracingExpirationTime", "type": "iso-8601"},
        "remote_debugging_enabled": {"key": "remoteDebuggingEnabled", "type": "bool"},
        "remote_debugging_version": {"key": "remoteDebuggingVersion", "type": "str"},
        "http_logging_enabled": {"key": "httpLoggingEnabled", "type": "bool"},
        "logs_directory_size_limit": {"key": "logsDirectorySizeLimit", "type": "int"},
        "detailed_error_logging_enabled": {"key": "detailedErrorLoggingEnabled", "type": "bool"},
        "publishing_username": {"key": "publishingUsername", "type": "str"},
        "app_settings": {"key": "appSettings", "type": "[NameValuePair]"},
        "azure_storage_accounts": {"key": "azureStorageAccounts", "type": "{AzureStorageInfoValue}"},
        "connection_strings": {"key": "connectionStrings", "type": "[ConnStringInfo]"},
        "machine_key": {"key": "machineKey", "type": "SiteMachineKey"},
        "handler_mappings": {"key": "handlerMappings", "type": "[HandlerMapping]"},
        "document_root": {"key": "documentRoot", "type": "str"},
        "scm_type": {"key": "scmType", "type": "str"},
        "use32_bit_worker_process": {"key": "use32BitWorkerProcess", "type": "bool"},
        "web_sockets_enabled": {"key": "webSocketsEnabled", "type": "bool"},
        "always_on": {"key": "alwaysOn", "type": "bool"},
        "java_version": {"key": "javaVersion", "type": "str"},
        "java_container": {"key": "javaContainer", "type": "str"},
        "java_container_version": {"key": "javaContainerVersion", "type": "str"},
        "app_command_line": {"key": "appCommandLine", "type": "str"},
        "managed_pipeline_mode": {"key": "managedPipelineMode", "type": "str"},
        "virtual_applications": {"key": "virtualApplications", "type": "[VirtualApplication]"},
        "load_balancing": {"key": "loadBalancing", "type": "str"},
        "experiments": {"key": "experiments", "type": "Experiments"},
        "limits": {"key": "limits", "type": "SiteLimits"},
        "auto_heal_enabled": {"key": "autoHealEnabled", "type": "bool"},
        "auto_heal_rules": {"key": "autoHealRules", "type": "AutoHealRules"},
        "tracing_options": {"key": "tracingOptions", "type": "str"},
        "vnet_name": {"key": "vnetName", "type": "str"},
        "cors": {"key": "cors", "type": "CorsSettings"},
        "push": {"key": "push", "type": "PushSettings"},
        "api_definition": {"key": "apiDefinition", "type": "ApiDefinitionInfo"},
        "auto_swap_slot_name": {"key": "autoSwapSlotName", "type": "str"},
        "local_my_sql_enabled": {"key": "localMySqlEnabled", "type": "bool"},
        "managed_service_identity_id": {"key": "managedServiceIdentityId", "type": "int"},
        "x_managed_service_identity_id": {"key": "xManagedServiceIdentityId", "type": "int"},
        "ip_security_restrictions": {"key": "ipSecurityRestrictions", "type": "[IpSecurityRestriction]"},
        "scm_ip_security_restrictions": {"key": "scmIpSecurityRestrictions", "type": "[IpSecurityRestriction]"},
        "scm_ip_security_restrictions_use_main": {"key": "scmIpSecurityRestrictionsUseMain", "type": "bool"},
        "http20_enabled": {"key": "http20Enabled", "type": "bool"},
        "min_tls_version": {"key": "minTlsVersion", "type": "str"},
        "ftps_state": {"key": "ftpsState", "type": "str"},
        "reserved_instance_count": {"key": "reservedInstanceCount", "type": "int"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        number_of_workers: Optional[int] = None,
        default_documents: Optional[List[str]] = None,
        net_framework_version: str = "v4.6",
        php_version: Optional[str] = None,
        python_version: Optional[str] = None,
        node_version: Optional[str] = None,
        linux_fx_version: Optional[str] = None,
        windows_fx_version: Optional[str] = None,
        request_tracing_enabled: Optional[bool] = None,
        request_tracing_expiration_time: Optional[datetime.datetime] = None,
        remote_debugging_enabled: Optional[bool] = None,
        remote_debugging_version: Optional[str] = None,
        http_logging_enabled: Optional[bool] = None,
        logs_directory_size_limit: Optional[int] = None,
        detailed_error_logging_enabled: Optional[bool] = None,
        publishing_username: Optional[str] = None,
        app_settings: Optional[List["_models.NameValuePair"]] = None,
        azure_storage_accounts: Optional[Dict[str, "_models.AzureStorageInfoValue"]] = None,
        connection_strings: Optional[List["_models.ConnStringInfo"]] = None,
        handler_mappings: Optional[List["_models.HandlerMapping"]] = None,
        document_root: Optional[str] = None,
        scm_type: Optional[Union[str, "_models.ScmType"]] = None,
        use32_bit_worker_process: Optional[bool] = None,
        web_sockets_enabled: Optional[bool] = None,
        always_on: Optional[bool] = None,
        java_version: Optional[str] = None,
        java_container: Optional[str] = None,
        java_container_version: Optional[str] = None,
        app_command_line: Optional[str] = None,
        managed_pipeline_mode: Optional[Union[str, "_models.ManagedPipelineMode"]] = None,
        virtual_applications: Optional[List["_models.VirtualApplication"]] = None,
        load_balancing: Optional[Union[str, "_models.SiteLoadBalancing"]] = None,
        experiments: Optional["_models.Experiments"] = None,
        limits: Optional["_models.SiteLimits"] = None,
        auto_heal_enabled: Optional[bool] = None,
        auto_heal_rules: Optional["_models.AutoHealRules"] = None,
        tracing_options: Optional[str] = None,
        vnet_name: Optional[str] = None,
        cors: Optional["_models.CorsSettings"] = None,
        push: Optional["_models.PushSettings"] = None,
        api_definition: Optional["_models.ApiDefinitionInfo"] = None,
        auto_swap_slot_name: Optional[str] = None,
        local_my_sql_enabled: bool = False,
        managed_service_identity_id: Optional[int] = None,
        x_managed_service_identity_id: Optional[int] = None,
        ip_security_restrictions: Optional[List["_models.IpSecurityRestriction"]] = None,
        scm_ip_security_restrictions: Optional[List["_models.IpSecurityRestriction"]] = None,
        scm_ip_security_restrictions_use_main: Optional[bool] = None,
        http20_enabled: bool = True,
        min_tls_version: Optional[Union[str, "_models.SupportedTlsVersions"]] = None,
        ftps_state: Optional[Union[str, "_models.FtpsState"]] = None,
        reserved_instance_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword number_of_workers: Number of workers.
        :paramtype number_of_workers: int
        :keyword default_documents: Default documents.
        :paramtype default_documents: list[str]
        :keyword net_framework_version: .NET Framework version.
        :paramtype net_framework_version: str
        :keyword php_version: Version of PHP.
        :paramtype php_version: str
        :keyword python_version: Version of Python.
        :paramtype python_version: str
        :keyword node_version: Version of Node.js.
        :paramtype node_version: str
        :keyword linux_fx_version: Linux App Framework and version.
        :paramtype linux_fx_version: str
        :keyword windows_fx_version: Xenon App Framework and version.
        :paramtype windows_fx_version: str
        :keyword request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype request_tracing_enabled: bool
        :keyword request_tracing_expiration_time: Request tracing expiration time.
        :paramtype request_tracing_expiration_time: ~datetime.datetime
        :keyword remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype remote_debugging_enabled: bool
        :keyword remote_debugging_version: Remote debugging version.
        :paramtype remote_debugging_version: str
        :keyword http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype http_logging_enabled: bool
        :keyword logs_directory_size_limit: HTTP logs directory size limit.
        :paramtype logs_directory_size_limit: int
        :keyword detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
         enabled; otherwise, :code:`<code>false</code>`.
        :paramtype detailed_error_logging_enabled: bool
        :keyword publishing_username: Publishing user name.
        :paramtype publishing_username: str
        :keyword app_settings: Application settings.
        :paramtype app_settings: list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]
        :keyword azure_storage_accounts: User-provided Azure storage accounts.
        :paramtype azure_storage_accounts: dict[str,
         ~azure.mgmt.web.v2018_02_01.models.AzureStorageInfoValue]
        :keyword connection_strings: Connection strings.
        :paramtype connection_strings: list[~azure.mgmt.web.v2018_02_01.models.ConnStringInfo]
        :keyword handler_mappings: Handler mappings.
        :paramtype handler_mappings: list[~azure.mgmt.web.v2018_02_01.models.HandlerMapping]
        :keyword document_root: Document root.
        :paramtype document_root: str
        :keyword scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
         "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
         "OneDrive", and "VSO".
        :paramtype scm_type: str or ~azure.mgmt.web.v2018_02_01.models.ScmType
        :keyword use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
         otherwise, :code:`<code>false</code>`.
        :paramtype use32_bit_worker_process: bool
        :keyword web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype web_sockets_enabled: bool
        :keyword always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype always_on: bool
        :keyword java_version: Java version.
        :paramtype java_version: str
        :keyword java_container: Java container.
        :paramtype java_container: str
        :keyword java_container_version: Java container version.
        :paramtype java_container_version: str
        :keyword app_command_line: App command line to launch.
        :paramtype app_command_line: str
        :keyword managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated" and
         "Classic".
        :paramtype managed_pipeline_mode: str or ~azure.mgmt.web.v2018_02_01.models.ManagedPipelineMode
        :keyword virtual_applications: Virtual applications.
        :paramtype virtual_applications: list[~azure.mgmt.web.v2018_02_01.models.VirtualApplication]
        :keyword load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
         "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", and "RequestHash".
        :paramtype load_balancing: str or ~azure.mgmt.web.v2018_02_01.models.SiteLoadBalancing
        :keyword experiments: This is work around for polymorphic types.
        :paramtype experiments: ~azure.mgmt.web.v2018_02_01.models.Experiments
        :keyword limits: Site limits.
        :paramtype limits: ~azure.mgmt.web.v2018_02_01.models.SiteLimits
        :keyword auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype auto_heal_enabled: bool
        :keyword auto_heal_rules: Auto Heal rules.
        :paramtype auto_heal_rules: ~azure.mgmt.web.v2018_02_01.models.AutoHealRules
        :keyword tracing_options: Tracing options.
        :paramtype tracing_options: str
        :keyword vnet_name: Virtual Network name.
        :paramtype vnet_name: str
        :keyword cors: Cross-Origin Resource Sharing (CORS) settings.
        :paramtype cors: ~azure.mgmt.web.v2018_02_01.models.CorsSettings
        :keyword push: Push endpoint settings.
        :paramtype push: ~azure.mgmt.web.v2018_02_01.models.PushSettings
        :keyword api_definition: Information about the formal API definition for the app.
        :paramtype api_definition: ~azure.mgmt.web.v2018_02_01.models.ApiDefinitionInfo
        :keyword auto_swap_slot_name: Auto-swap slot name.
        :paramtype auto_swap_slot_name: str
        :keyword local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
         :code:`<code>false</code>`.
        :paramtype local_my_sql_enabled: bool
        :keyword managed_service_identity_id: Managed Service Identity Id.
        :paramtype managed_service_identity_id: int
        :keyword x_managed_service_identity_id: Explicit Managed Service Identity Id.
        :paramtype x_managed_service_identity_id: int
        :keyword ip_security_restrictions: IP security restrictions for main.
        :paramtype ip_security_restrictions:
         list[~azure.mgmt.web.v2018_02_01.models.IpSecurityRestriction]
        :keyword scm_ip_security_restrictions: IP security restrictions for scm.
        :paramtype scm_ip_security_restrictions:
         list[~azure.mgmt.web.v2018_02_01.models.IpSecurityRestriction]
        :keyword scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
        :paramtype scm_ip_security_restrictions_use_main: bool
        :keyword http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
         http2.0.
        :paramtype http20_enabled: bool
        :keyword min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
         requests. Known values are: "1.0", "1.1", and "1.2".
        :paramtype min_tls_version: str or ~azure.mgmt.web.v2018_02_01.models.SupportedTlsVersions
        :keyword ftps_state: State of FTP / FTPS service. Known values are: "AllAllowed", "FtpsOnly",
         and "Disabled".
        :paramtype ftps_state: str or ~azure.mgmt.web.v2018_02_01.models.FtpsState
        :keyword reserved_instance_count: Number of reserved instances.
         This setting only applies to the Consumption Plan.
        :paramtype reserved_instance_count: int
        """
        super().__init__(**kwargs)
        self.number_of_workers = number_of_workers
        self.default_documents = default_documents
        self.net_framework_version = net_framework_version
        self.php_version = php_version
        self.python_version = python_version
        self.node_version = node_version
        self.linux_fx_version = linux_fx_version
        self.windows_fx_version = windows_fx_version
        self.request_tracing_enabled = request_tracing_enabled
        self.request_tracing_expiration_time = request_tracing_expiration_time
        self.remote_debugging_enabled = remote_debugging_enabled
        self.remote_debugging_version = remote_debugging_version
        self.http_logging_enabled = http_logging_enabled
        self.logs_directory_size_limit = logs_directory_size_limit
        self.detailed_error_logging_enabled = detailed_error_logging_enabled
        self.publishing_username = publishing_username
        self.app_settings = app_settings
        self.azure_storage_accounts = azure_storage_accounts
        self.connection_strings = connection_strings
        self.machine_key = None
        self.handler_mappings = handler_mappings
        self.document_root = document_root
        self.scm_type = scm_type
        self.use32_bit_worker_process = use32_bit_worker_process
        self.web_sockets_enabled = web_sockets_enabled
        self.always_on = always_on
        self.java_version = java_version
        self.java_container = java_container
        self.java_container_version = java_container_version
        self.app_command_line = app_command_line
        self.managed_pipeline_mode = managed_pipeline_mode
        self.virtual_applications = virtual_applications
        self.load_balancing = load_balancing
        self.experiments = experiments
        self.limits = limits
        self.auto_heal_enabled = auto_heal_enabled
        self.auto_heal_rules = auto_heal_rules
        self.tracing_options = tracing_options
        self.vnet_name = vnet_name
        self.cors = cors
        self.push = push
        self.api_definition = api_definition
        self.auto_swap_slot_name = auto_swap_slot_name
        self.local_my_sql_enabled = local_my_sql_enabled
        self.managed_service_identity_id = managed_service_identity_id
        self.x_managed_service_identity_id = x_managed_service_identity_id
        self.ip_security_restrictions = ip_security_restrictions
        self.scm_ip_security_restrictions = scm_ip_security_restrictions
        self.scm_ip_security_restrictions_use_main = scm_ip_security_restrictions_use_main
        self.http20_enabled = http20_enabled
        self.min_tls_version = min_tls_version
        self.ftps_state = ftps_state
        self.reserved_instance_count = reserved_instance_count


class SiteConfigResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Web app configuration ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar number_of_workers: Number of workers.
    :vartype number_of_workers: int
    :ivar default_documents: Default documents.
    :vartype default_documents: list[str]
    :ivar net_framework_version: .NET Framework version.
    :vartype net_framework_version: str
    :ivar php_version: Version of PHP.
    :vartype php_version: str
    :ivar python_version: Version of Python.
    :vartype python_version: str
    :ivar node_version: Version of Node.js.
    :vartype node_version: str
    :ivar linux_fx_version: Linux App Framework and version.
    :vartype linux_fx_version: str
    :ivar windows_fx_version: Xenon App Framework and version.
    :vartype windows_fx_version: str
    :ivar request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype request_tracing_enabled: bool
    :ivar request_tracing_expiration_time: Request tracing expiration time.
    :vartype request_tracing_expiration_time: ~datetime.datetime
    :ivar remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype remote_debugging_enabled: bool
    :ivar remote_debugging_version: Remote debugging version.
    :vartype remote_debugging_version: str
    :ivar http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype http_logging_enabled: bool
    :ivar logs_directory_size_limit: HTTP logs directory size limit.
    :vartype logs_directory_size_limit: int
    :ivar detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :vartype detailed_error_logging_enabled: bool
    :ivar publishing_username: Publishing user name.
    :vartype publishing_username: str
    :ivar app_settings: Application settings.
    :vartype app_settings: list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]
    :ivar azure_storage_accounts: User-provided Azure storage accounts.
    :vartype azure_storage_accounts: dict[str,
     ~azure.mgmt.web.v2018_02_01.models.AzureStorageInfoValue]
    :ivar connection_strings: Connection strings.
    :vartype connection_strings: list[~azure.mgmt.web.v2018_02_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2018_02_01.models.SiteMachineKey
    :ivar handler_mappings: Handler mappings.
    :vartype handler_mappings: list[~azure.mgmt.web.v2018_02_01.models.HandlerMapping]
    :ivar document_root: Document root.
    :vartype document_root: str
    :ivar scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
     "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
     "OneDrive", and "VSO".
    :vartype scm_type: str or ~azure.mgmt.web.v2018_02_01.models.ScmType
    :ivar use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :vartype use32_bit_worker_process: bool
    :ivar web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype web_sockets_enabled: bool
    :ivar always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype always_on: bool
    :ivar java_version: Java version.
    :vartype java_version: str
    :ivar java_container: Java container.
    :vartype java_container: str
    :ivar java_container_version: Java container version.
    :vartype java_container_version: str
    :ivar app_command_line: App command line to launch.
    :vartype app_command_line: str
    :ivar managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated" and
     "Classic".
    :vartype managed_pipeline_mode: str or ~azure.mgmt.web.v2018_02_01.models.ManagedPipelineMode
    :ivar virtual_applications: Virtual applications.
    :vartype virtual_applications: list[~azure.mgmt.web.v2018_02_01.models.VirtualApplication]
    :ivar load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", and "RequestHash".
    :vartype load_balancing: str or ~azure.mgmt.web.v2018_02_01.models.SiteLoadBalancing
    :ivar experiments: This is work around for polymorphic types.
    :vartype experiments: ~azure.mgmt.web.v2018_02_01.models.Experiments
    :ivar limits: Site limits.
    :vartype limits: ~azure.mgmt.web.v2018_02_01.models.SiteLimits
    :ivar auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype auto_heal_enabled: bool
    :ivar auto_heal_rules: Auto Heal rules.
    :vartype auto_heal_rules: ~azure.mgmt.web.v2018_02_01.models.AutoHealRules
    :ivar tracing_options: Tracing options.
    :vartype tracing_options: str
    :ivar vnet_name: Virtual Network name.
    :vartype vnet_name: str
    :ivar cors: Cross-Origin Resource Sharing (CORS) settings.
    :vartype cors: ~azure.mgmt.web.v2018_02_01.models.CorsSettings
    :ivar push: Push endpoint settings.
    :vartype push: ~azure.mgmt.web.v2018_02_01.models.PushSettings
    :ivar api_definition: Information about the formal API definition for the app.
    :vartype api_definition: ~azure.mgmt.web.v2018_02_01.models.ApiDefinitionInfo
    :ivar auto_swap_slot_name: Auto-swap slot name.
    :vartype auto_swap_slot_name: str
    :ivar local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :vartype local_my_sql_enabled: bool
    :ivar managed_service_identity_id: Managed Service Identity Id.
    :vartype managed_service_identity_id: int
    :ivar x_managed_service_identity_id: Explicit Managed Service Identity Id.
    :vartype x_managed_service_identity_id: int
    :ivar ip_security_restrictions: IP security restrictions for main.
    :vartype ip_security_restrictions:
     list[~azure.mgmt.web.v2018_02_01.models.IpSecurityRestriction]
    :ivar scm_ip_security_restrictions: IP security restrictions for scm.
    :vartype scm_ip_security_restrictions:
     list[~azure.mgmt.web.v2018_02_01.models.IpSecurityRestriction]
    :ivar scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
    :vartype scm_ip_security_restrictions_use_main: bool
    :ivar http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :vartype http20_enabled: bool
    :ivar min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Known values are: "1.0", "1.1", and "1.2".
    :vartype min_tls_version: str or ~azure.mgmt.web.v2018_02_01.models.SupportedTlsVersions
    :ivar ftps_state: State of FTP / FTPS service. Known values are: "AllAllowed", "FtpsOnly", and
     "Disabled".
    :vartype ftps_state: str or ~azure.mgmt.web.v2018_02_01.models.FtpsState
    :ivar reserved_instance_count: Number of reserved instances.
     This setting only applies to the Consumption Plan.
    :vartype reserved_instance_count: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "machine_key": {"readonly": True},
        "reserved_instance_count": {"maximum": 10, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "number_of_workers": {"key": "properties.numberOfWorkers", "type": "int"},
        "default_documents": {"key": "properties.defaultDocuments", "type": "[str]"},
        "net_framework_version": {"key": "properties.netFrameworkVersion", "type": "str"},
        "php_version": {"key": "properties.phpVersion", "type": "str"},
        "python_version": {"key": "properties.pythonVersion", "type": "str"},
        "node_version": {"key": "properties.nodeVersion", "type": "str"},
        "linux_fx_version": {"key": "properties.linuxFxVersion", "type": "str"},
        "windows_fx_version": {"key": "properties.windowsFxVersion", "type": "str"},
        "request_tracing_enabled": {"key": "properties.requestTracingEnabled", "type": "bool"},
        "request_tracing_expiration_time": {"key": "properties.requestTracingExpirationTime", "type": "iso-8601"},
        "remote_debugging_enabled": {"key": "properties.remoteDebuggingEnabled", "type": "bool"},
        "remote_debugging_version": {"key": "properties.remoteDebuggingVersion", "type": "str"},
        "http_logging_enabled": {"key": "properties.httpLoggingEnabled", "type": "bool"},
        "logs_directory_size_limit": {"key": "properties.logsDirectorySizeLimit", "type": "int"},
        "detailed_error_logging_enabled": {"key": "properties.detailedErrorLoggingEnabled", "type": "bool"},
        "publishing_username": {"key": "properties.publishingUsername", "type": "str"},
        "app_settings": {"key": "properties.appSettings", "type": "[NameValuePair]"},
        "azure_storage_accounts": {"key": "properties.azureStorageAccounts", "type": "{AzureStorageInfoValue}"},
        "connection_strings": {"key": "properties.connectionStrings", "type": "[ConnStringInfo]"},
        "machine_key": {"key": "properties.machineKey", "type": "SiteMachineKey"},
        "handler_mappings": {"key": "properties.handlerMappings", "type": "[HandlerMapping]"},
        "document_root": {"key": "properties.documentRoot", "type": "str"},
        "scm_type": {"key": "properties.scmType", "type": "str"},
        "use32_bit_worker_process": {"key": "properties.use32BitWorkerProcess", "type": "bool"},
        "web_sockets_enabled": {"key": "properties.webSocketsEnabled", "type": "bool"},
        "always_on": {"key": "properties.alwaysOn", "type": "bool"},
        "java_version": {"key": "properties.javaVersion", "type": "str"},
        "java_container": {"key": "properties.javaContainer", "type": "str"},
        "java_container_version": {"key": "properties.javaContainerVersion", "type": "str"},
        "app_command_line": {"key": "properties.appCommandLine", "type": "str"},
        "managed_pipeline_mode": {"key": "properties.managedPipelineMode", "type": "str"},
        "virtual_applications": {"key": "properties.virtualApplications", "type": "[VirtualApplication]"},
        "load_balancing": {"key": "properties.loadBalancing", "type": "str"},
        "experiments": {"key": "properties.experiments", "type": "Experiments"},
        "limits": {"key": "properties.limits", "type": "SiteLimits"},
        "auto_heal_enabled": {"key": "properties.autoHealEnabled", "type": "bool"},
        "auto_heal_rules": {"key": "properties.autoHealRules", "type": "AutoHealRules"},
        "tracing_options": {"key": "properties.tracingOptions", "type": "str"},
        "vnet_name": {"key": "properties.vnetName", "type": "str"},
        "cors": {"key": "properties.cors", "type": "CorsSettings"},
        "push": {"key": "properties.push", "type": "PushSettings"},
        "api_definition": {"key": "properties.apiDefinition", "type": "ApiDefinitionInfo"},
        "auto_swap_slot_name": {"key": "properties.autoSwapSlotName", "type": "str"},
        "local_my_sql_enabled": {"key": "properties.localMySqlEnabled", "type": "bool"},
        "managed_service_identity_id": {"key": "properties.managedServiceIdentityId", "type": "int"},
        "x_managed_service_identity_id": {"key": "properties.xManagedServiceIdentityId", "type": "int"},
        "ip_security_restrictions": {"key": "properties.ipSecurityRestrictions", "type": "[IpSecurityRestriction]"},
        "scm_ip_security_restrictions": {
            "key": "properties.scmIpSecurityRestrictions",
            "type": "[IpSecurityRestriction]",
        },
        "scm_ip_security_restrictions_use_main": {"key": "properties.scmIpSecurityRestrictionsUseMain", "type": "bool"},
        "http20_enabled": {"key": "properties.http20Enabled", "type": "bool"},
        "min_tls_version": {"key": "properties.minTlsVersion", "type": "str"},
        "ftps_state": {"key": "properties.ftpsState", "type": "str"},
        "reserved_instance_count": {"key": "properties.reservedInstanceCount", "type": "int"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        number_of_workers: Optional[int] = None,
        default_documents: Optional[List[str]] = None,
        net_framework_version: str = "v4.6",
        php_version: Optional[str] = None,
        python_version: Optional[str] = None,
        node_version: Optional[str] = None,
        linux_fx_version: Optional[str] = None,
        windows_fx_version: Optional[str] = None,
        request_tracing_enabled: Optional[bool] = None,
        request_tracing_expiration_time: Optional[datetime.datetime] = None,
        remote_debugging_enabled: Optional[bool] = None,
        remote_debugging_version: Optional[str] = None,
        http_logging_enabled: Optional[bool] = None,
        logs_directory_size_limit: Optional[int] = None,
        detailed_error_logging_enabled: Optional[bool] = None,
        publishing_username: Optional[str] = None,
        app_settings: Optional[List["_models.NameValuePair"]] = None,
        azure_storage_accounts: Optional[Dict[str, "_models.AzureStorageInfoValue"]] = None,
        connection_strings: Optional[List["_models.ConnStringInfo"]] = None,
        handler_mappings: Optional[List["_models.HandlerMapping"]] = None,
        document_root: Optional[str] = None,
        scm_type: Optional[Union[str, "_models.ScmType"]] = None,
        use32_bit_worker_process: Optional[bool] = None,
        web_sockets_enabled: Optional[bool] = None,
        always_on: Optional[bool] = None,
        java_version: Optional[str] = None,
        java_container: Optional[str] = None,
        java_container_version: Optional[str] = None,
        app_command_line: Optional[str] = None,
        managed_pipeline_mode: Optional[Union[str, "_models.ManagedPipelineMode"]] = None,
        virtual_applications: Optional[List["_models.VirtualApplication"]] = None,
        load_balancing: Optional[Union[str, "_models.SiteLoadBalancing"]] = None,
        experiments: Optional["_models.Experiments"] = None,
        limits: Optional["_models.SiteLimits"] = None,
        auto_heal_enabled: Optional[bool] = None,
        auto_heal_rules: Optional["_models.AutoHealRules"] = None,
        tracing_options: Optional[str] = None,
        vnet_name: Optional[str] = None,
        cors: Optional["_models.CorsSettings"] = None,
        push: Optional["_models.PushSettings"] = None,
        api_definition: Optional["_models.ApiDefinitionInfo"] = None,
        auto_swap_slot_name: Optional[str] = None,
        local_my_sql_enabled: bool = False,
        managed_service_identity_id: Optional[int] = None,
        x_managed_service_identity_id: Optional[int] = None,
        ip_security_restrictions: Optional[List["_models.IpSecurityRestriction"]] = None,
        scm_ip_security_restrictions: Optional[List["_models.IpSecurityRestriction"]] = None,
        scm_ip_security_restrictions_use_main: Optional[bool] = None,
        http20_enabled: bool = True,
        min_tls_version: Optional[Union[str, "_models.SupportedTlsVersions"]] = None,
        ftps_state: Optional[Union[str, "_models.FtpsState"]] = None,
        reserved_instance_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword number_of_workers: Number of workers.
        :paramtype number_of_workers: int
        :keyword default_documents: Default documents.
        :paramtype default_documents: list[str]
        :keyword net_framework_version: .NET Framework version.
        :paramtype net_framework_version: str
        :keyword php_version: Version of PHP.
        :paramtype php_version: str
        :keyword python_version: Version of Python.
        :paramtype python_version: str
        :keyword node_version: Version of Node.js.
        :paramtype node_version: str
        :keyword linux_fx_version: Linux App Framework and version.
        :paramtype linux_fx_version: str
        :keyword windows_fx_version: Xenon App Framework and version.
        :paramtype windows_fx_version: str
        :keyword request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype request_tracing_enabled: bool
        :keyword request_tracing_expiration_time: Request tracing expiration time.
        :paramtype request_tracing_expiration_time: ~datetime.datetime
        :keyword remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype remote_debugging_enabled: bool
        :keyword remote_debugging_version: Remote debugging version.
        :paramtype remote_debugging_version: str
        :keyword http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype http_logging_enabled: bool
        :keyword logs_directory_size_limit: HTTP logs directory size limit.
        :paramtype logs_directory_size_limit: int
        :keyword detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
         enabled; otherwise, :code:`<code>false</code>`.
        :paramtype detailed_error_logging_enabled: bool
        :keyword publishing_username: Publishing user name.
        :paramtype publishing_username: str
        :keyword app_settings: Application settings.
        :paramtype app_settings: list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]
        :keyword azure_storage_accounts: User-provided Azure storage accounts.
        :paramtype azure_storage_accounts: dict[str,
         ~azure.mgmt.web.v2018_02_01.models.AzureStorageInfoValue]
        :keyword connection_strings: Connection strings.
        :paramtype connection_strings: list[~azure.mgmt.web.v2018_02_01.models.ConnStringInfo]
        :keyword handler_mappings: Handler mappings.
        :paramtype handler_mappings: list[~azure.mgmt.web.v2018_02_01.models.HandlerMapping]
        :keyword document_root: Document root.
        :paramtype document_root: str
        :keyword scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
         "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
         "OneDrive", and "VSO".
        :paramtype scm_type: str or ~azure.mgmt.web.v2018_02_01.models.ScmType
        :keyword use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
         otherwise, :code:`<code>false</code>`.
        :paramtype use32_bit_worker_process: bool
        :keyword web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype web_sockets_enabled: bool
        :keyword always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype always_on: bool
        :keyword java_version: Java version.
        :paramtype java_version: str
        :keyword java_container: Java container.
        :paramtype java_container: str
        :keyword java_container_version: Java container version.
        :paramtype java_container_version: str
        :keyword app_command_line: App command line to launch.
        :paramtype app_command_line: str
        :keyword managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated" and
         "Classic".
        :paramtype managed_pipeline_mode: str or ~azure.mgmt.web.v2018_02_01.models.ManagedPipelineMode
        :keyword virtual_applications: Virtual applications.
        :paramtype virtual_applications: list[~azure.mgmt.web.v2018_02_01.models.VirtualApplication]
        :keyword load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
         "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", and "RequestHash".
        :paramtype load_balancing: str or ~azure.mgmt.web.v2018_02_01.models.SiteLoadBalancing
        :keyword experiments: This is work around for polymorphic types.
        :paramtype experiments: ~azure.mgmt.web.v2018_02_01.models.Experiments
        :keyword limits: Site limits.
        :paramtype limits: ~azure.mgmt.web.v2018_02_01.models.SiteLimits
        :keyword auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype auto_heal_enabled: bool
        :keyword auto_heal_rules: Auto Heal rules.
        :paramtype auto_heal_rules: ~azure.mgmt.web.v2018_02_01.models.AutoHealRules
        :keyword tracing_options: Tracing options.
        :paramtype tracing_options: str
        :keyword vnet_name: Virtual Network name.
        :paramtype vnet_name: str
        :keyword cors: Cross-Origin Resource Sharing (CORS) settings.
        :paramtype cors: ~azure.mgmt.web.v2018_02_01.models.CorsSettings
        :keyword push: Push endpoint settings.
        :paramtype push: ~azure.mgmt.web.v2018_02_01.models.PushSettings
        :keyword api_definition: Information about the formal API definition for the app.
        :paramtype api_definition: ~azure.mgmt.web.v2018_02_01.models.ApiDefinitionInfo
        :keyword auto_swap_slot_name: Auto-swap slot name.
        :paramtype auto_swap_slot_name: str
        :keyword local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
         :code:`<code>false</code>`.
        :paramtype local_my_sql_enabled: bool
        :keyword managed_service_identity_id: Managed Service Identity Id.
        :paramtype managed_service_identity_id: int
        :keyword x_managed_service_identity_id: Explicit Managed Service Identity Id.
        :paramtype x_managed_service_identity_id: int
        :keyword ip_security_restrictions: IP security restrictions for main.
        :paramtype ip_security_restrictions:
         list[~azure.mgmt.web.v2018_02_01.models.IpSecurityRestriction]
        :keyword scm_ip_security_restrictions: IP security restrictions for scm.
        :paramtype scm_ip_security_restrictions:
         list[~azure.mgmt.web.v2018_02_01.models.IpSecurityRestriction]
        :keyword scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
        :paramtype scm_ip_security_restrictions_use_main: bool
        :keyword http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
         http2.0.
        :paramtype http20_enabled: bool
        :keyword min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
         requests. Known values are: "1.0", "1.1", and "1.2".
        :paramtype min_tls_version: str or ~azure.mgmt.web.v2018_02_01.models.SupportedTlsVersions
        :keyword ftps_state: State of FTP / FTPS service. Known values are: "AllAllowed", "FtpsOnly",
         and "Disabled".
        :paramtype ftps_state: str or ~azure.mgmt.web.v2018_02_01.models.FtpsState
        :keyword reserved_instance_count: Number of reserved instances.
         This setting only applies to the Consumption Plan.
        :paramtype reserved_instance_count: int
        """
        super().__init__(kind=kind, **kwargs)
        self.number_of_workers = number_of_workers
        self.default_documents = default_documents
        self.net_framework_version = net_framework_version
        self.php_version = php_version
        self.python_version = python_version
        self.node_version = node_version
        self.linux_fx_version = linux_fx_version
        self.windows_fx_version = windows_fx_version
        self.request_tracing_enabled = request_tracing_enabled
        self.request_tracing_expiration_time = request_tracing_expiration_time
        self.remote_debugging_enabled = remote_debugging_enabled
        self.remote_debugging_version = remote_debugging_version
        self.http_logging_enabled = http_logging_enabled
        self.logs_directory_size_limit = logs_directory_size_limit
        self.detailed_error_logging_enabled = detailed_error_logging_enabled
        self.publishing_username = publishing_username
        self.app_settings = app_settings
        self.azure_storage_accounts = azure_storage_accounts
        self.connection_strings = connection_strings
        self.machine_key = None
        self.handler_mappings = handler_mappings
        self.document_root = document_root
        self.scm_type = scm_type
        self.use32_bit_worker_process = use32_bit_worker_process
        self.web_sockets_enabled = web_sockets_enabled
        self.always_on = always_on
        self.java_version = java_version
        self.java_container = java_container
        self.java_container_version = java_container_version
        self.app_command_line = app_command_line
        self.managed_pipeline_mode = managed_pipeline_mode
        self.virtual_applications = virtual_applications
        self.load_balancing = load_balancing
        self.experiments = experiments
        self.limits = limits
        self.auto_heal_enabled = auto_heal_enabled
        self.auto_heal_rules = auto_heal_rules
        self.tracing_options = tracing_options
        self.vnet_name = vnet_name
        self.cors = cors
        self.push = push
        self.api_definition = api_definition
        self.auto_swap_slot_name = auto_swap_slot_name
        self.local_my_sql_enabled = local_my_sql_enabled
        self.managed_service_identity_id = managed_service_identity_id
        self.x_managed_service_identity_id = x_managed_service_identity_id
        self.ip_security_restrictions = ip_security_restrictions
        self.scm_ip_security_restrictions = scm_ip_security_restrictions
        self.scm_ip_security_restrictions_use_main = scm_ip_security_restrictions_use_main
        self.http20_enabled = http20_enabled
        self.min_tls_version = min_tls_version
        self.ftps_state = ftps_state
        self.reserved_instance_count = reserved_instance_count


class SiteConfigResourceCollection(_serialization.Model):
    """Collection of site configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.SiteConfigResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SiteConfigResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SiteConfigResource"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.SiteConfigResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteConfigurationSnapshotInfo(ProxyOnlyResource):
    """A snapshot of a web app configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time: The time the snapshot was taken.
    :vartype time: ~datetime.datetime
    :ivar snapshot_id: The id of the snapshot.
    :vartype snapshot_id: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "time": {"readonly": True},
        "snapshot_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "time": {"key": "properties.time", "type": "iso-8601"},
        "snapshot_id": {"key": "properties.snapshotId", "type": "int"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.time = None
        self.snapshot_id = None


class SiteConfigurationSnapshotInfoCollection(_serialization.Model):
    """Collection of metadata for the app configuration snapshots that can be restored.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.SiteConfigurationSnapshotInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SiteConfigurationSnapshotInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SiteConfigurationSnapshotInfo"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.SiteConfigurationSnapshotInfo]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteExtensionInfo(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Site Extension Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar extension_id: Site extension ID.
    :vartype extension_id: str
    :ivar title:
    :vartype title: str
    :ivar extension_type: Site extension type. Known values are: "Gallery" and "WebRoot".
    :vartype extension_type: str or ~azure.mgmt.web.v2018_02_01.models.SiteExtensionType
    :ivar summary: Summary description.
    :vartype summary: str
    :ivar description: Detailed description.
    :vartype description: str
    :ivar version: Version information.
    :vartype version: str
    :ivar extension_url: Extension URL.
    :vartype extension_url: str
    :ivar project_url: Project URL.
    :vartype project_url: str
    :ivar icon_url: Icon URL.
    :vartype icon_url: str
    :ivar license_url: License URL.
    :vartype license_url: str
    :ivar feed_url: Feed URL.
    :vartype feed_url: str
    :ivar authors: List of authors.
    :vartype authors: list[str]
    :ivar installer_command_line_params: Installer command line parameters.
    :vartype installer_command_line_params: str
    :ivar published_date_time: Published timestamp.
    :vartype published_date_time: ~datetime.datetime
    :ivar download_count: Count of downloads.
    :vartype download_count: int
    :ivar local_is_latest_version: :code:`<code>true</code>` if the local version is the latest
     version; :code:`<code>false</code>` otherwise.
    :vartype local_is_latest_version: bool
    :ivar local_path: Local path.
    :vartype local_path: str
    :ivar installed_date_time: Installed timestamp.
    :vartype installed_date_time: ~datetime.datetime
    :ivar provisioning_state: Provisioning state.
    :vartype provisioning_state: str
    :ivar comment: Site Extension comment.
    :vartype comment: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "extension_id": {"key": "properties.extension_id", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "extension_type": {"key": "properties.extension_type", "type": "str"},
        "summary": {"key": "properties.summary", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "extension_url": {"key": "properties.extension_url", "type": "str"},
        "project_url": {"key": "properties.project_url", "type": "str"},
        "icon_url": {"key": "properties.icon_url", "type": "str"},
        "license_url": {"key": "properties.license_url", "type": "str"},
        "feed_url": {"key": "properties.feed_url", "type": "str"},
        "authors": {"key": "properties.authors", "type": "[str]"},
        "installer_command_line_params": {"key": "properties.installer_command_line_params", "type": "str"},
        "published_date_time": {"key": "properties.published_date_time", "type": "iso-8601"},
        "download_count": {"key": "properties.download_count", "type": "int"},
        "local_is_latest_version": {"key": "properties.local_is_latest_version", "type": "bool"},
        "local_path": {"key": "properties.local_path", "type": "str"},
        "installed_date_time": {"key": "properties.installed_date_time", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "comment": {"key": "properties.comment", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        extension_id: Optional[str] = None,
        title: Optional[str] = None,
        extension_type: Optional[Union[str, "_models.SiteExtensionType"]] = None,
        summary: Optional[str] = None,
        description: Optional[str] = None,
        version: Optional[str] = None,
        extension_url: Optional[str] = None,
        project_url: Optional[str] = None,
        icon_url: Optional[str] = None,
        license_url: Optional[str] = None,
        feed_url: Optional[str] = None,
        authors: Optional[List[str]] = None,
        installer_command_line_params: Optional[str] = None,
        published_date_time: Optional[datetime.datetime] = None,
        download_count: Optional[int] = None,
        local_is_latest_version: Optional[bool] = None,
        local_path: Optional[str] = None,
        installed_date_time: Optional[datetime.datetime] = None,
        provisioning_state: Optional[str] = None,
        comment: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword extension_id: Site extension ID.
        :paramtype extension_id: str
        :keyword title:
        :paramtype title: str
        :keyword extension_type: Site extension type. Known values are: "Gallery" and "WebRoot".
        :paramtype extension_type: str or ~azure.mgmt.web.v2018_02_01.models.SiteExtensionType
        :keyword summary: Summary description.
        :paramtype summary: str
        :keyword description: Detailed description.
        :paramtype description: str
        :keyword version: Version information.
        :paramtype version: str
        :keyword extension_url: Extension URL.
        :paramtype extension_url: str
        :keyword project_url: Project URL.
        :paramtype project_url: str
        :keyword icon_url: Icon URL.
        :paramtype icon_url: str
        :keyword license_url: License URL.
        :paramtype license_url: str
        :keyword feed_url: Feed URL.
        :paramtype feed_url: str
        :keyword authors: List of authors.
        :paramtype authors: list[str]
        :keyword installer_command_line_params: Installer command line parameters.
        :paramtype installer_command_line_params: str
        :keyword published_date_time: Published timestamp.
        :paramtype published_date_time: ~datetime.datetime
        :keyword download_count: Count of downloads.
        :paramtype download_count: int
        :keyword local_is_latest_version: :code:`<code>true</code>` if the local version is the latest
         version; :code:`<code>false</code>` otherwise.
        :paramtype local_is_latest_version: bool
        :keyword local_path: Local path.
        :paramtype local_path: str
        :keyword installed_date_time: Installed timestamp.
        :paramtype installed_date_time: ~datetime.datetime
        :keyword provisioning_state: Provisioning state.
        :paramtype provisioning_state: str
        :keyword comment: Site Extension comment.
        :paramtype comment: str
        """
        super().__init__(kind=kind, **kwargs)
        self.extension_id = extension_id
        self.title = title
        self.extension_type = extension_type
        self.summary = summary
        self.description = description
        self.version = version
        self.extension_url = extension_url
        self.project_url = project_url
        self.icon_url = icon_url
        self.license_url = license_url
        self.feed_url = feed_url
        self.authors = authors
        self.installer_command_line_params = installer_command_line_params
        self.published_date_time = published_date_time
        self.download_count = download_count
        self.local_is_latest_version = local_is_latest_version
        self.local_path = local_path
        self.installed_date_time = installed_date_time
        self.provisioning_state = provisioning_state
        self.comment = comment


class SiteExtensionInfoCollection(_serialization.Model):
    """Collection of Kudu site extension information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.SiteExtensionInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SiteExtensionInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SiteExtensionInfo"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.SiteExtensionInfo]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteInstance(ProxyOnlyResource):
    """Instance of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar site_instance_name: Name of instance.
    :vartype site_instance_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "site_instance_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "site_instance_name": {"key": "properties.siteInstanceName", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.site_instance_name = None


class SiteLimits(_serialization.Model):
    """Metric limits set on an app.

    :ivar max_percentage_cpu: Maximum allowed CPU usage percentage.
    :vartype max_percentage_cpu: float
    :ivar max_memory_in_mb: Maximum allowed memory usage in MB.
    :vartype max_memory_in_mb: int
    :ivar max_disk_size_in_mb: Maximum allowed disk size usage in MB.
    :vartype max_disk_size_in_mb: int
    """

    _attribute_map = {
        "max_percentage_cpu": {"key": "maxPercentageCpu", "type": "float"},
        "max_memory_in_mb": {"key": "maxMemoryInMb", "type": "int"},
        "max_disk_size_in_mb": {"key": "maxDiskSizeInMb", "type": "int"},
    }

    def __init__(
        self,
        *,
        max_percentage_cpu: Optional[float] = None,
        max_memory_in_mb: Optional[int] = None,
        max_disk_size_in_mb: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_percentage_cpu: Maximum allowed CPU usage percentage.
        :paramtype max_percentage_cpu: float
        :keyword max_memory_in_mb: Maximum allowed memory usage in MB.
        :paramtype max_memory_in_mb: int
        :keyword max_disk_size_in_mb: Maximum allowed disk size usage in MB.
        :paramtype max_disk_size_in_mb: int
        """
        super().__init__(**kwargs)
        self.max_percentage_cpu = max_percentage_cpu
        self.max_memory_in_mb = max_memory_in_mb
        self.max_disk_size_in_mb = max_disk_size_in_mb


class SiteLogsConfig(ProxyOnlyResource):
    """Configuration of App Service site logs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar application_logs: Application logs configuration.
    :vartype application_logs: ~azure.mgmt.web.v2018_02_01.models.ApplicationLogsConfig
    :ivar http_logs: HTTP logs configuration.
    :vartype http_logs: ~azure.mgmt.web.v2018_02_01.models.HttpLogsConfig
    :ivar failed_requests_tracing: Failed requests tracing configuration.
    :vartype failed_requests_tracing: ~azure.mgmt.web.v2018_02_01.models.EnabledConfig
    :ivar detailed_error_messages: Detailed error messages configuration.
    :vartype detailed_error_messages: ~azure.mgmt.web.v2018_02_01.models.EnabledConfig
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "application_logs": {"key": "properties.applicationLogs", "type": "ApplicationLogsConfig"},
        "http_logs": {"key": "properties.httpLogs", "type": "HttpLogsConfig"},
        "failed_requests_tracing": {"key": "properties.failedRequestsTracing", "type": "EnabledConfig"},
        "detailed_error_messages": {"key": "properties.detailedErrorMessages", "type": "EnabledConfig"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        application_logs: Optional["_models.ApplicationLogsConfig"] = None,
        http_logs: Optional["_models.HttpLogsConfig"] = None,
        failed_requests_tracing: Optional["_models.EnabledConfig"] = None,
        detailed_error_messages: Optional["_models.EnabledConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword application_logs: Application logs configuration.
        :paramtype application_logs: ~azure.mgmt.web.v2018_02_01.models.ApplicationLogsConfig
        :keyword http_logs: HTTP logs configuration.
        :paramtype http_logs: ~azure.mgmt.web.v2018_02_01.models.HttpLogsConfig
        :keyword failed_requests_tracing: Failed requests tracing configuration.
        :paramtype failed_requests_tracing: ~azure.mgmt.web.v2018_02_01.models.EnabledConfig
        :keyword detailed_error_messages: Detailed error messages configuration.
        :paramtype detailed_error_messages: ~azure.mgmt.web.v2018_02_01.models.EnabledConfig
        """
        super().__init__(kind=kind, **kwargs)
        self.application_logs = application_logs
        self.http_logs = http_logs
        self.failed_requests_tracing = failed_requests_tracing
        self.detailed_error_messages = detailed_error_messages


class SiteMachineKey(_serialization.Model):
    """MachineKey of an app.

    :ivar validation: MachineKey validation.
    :vartype validation: str
    :ivar validation_key: Validation key.
    :vartype validation_key: str
    :ivar decryption: Algorithm used for decryption.
    :vartype decryption: str
    :ivar decryption_key: Decryption key.
    :vartype decryption_key: str
    """

    _attribute_map = {
        "validation": {"key": "validation", "type": "str"},
        "validation_key": {"key": "validationKey", "type": "str"},
        "decryption": {"key": "decryption", "type": "str"},
        "decryption_key": {"key": "decryptionKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        validation: Optional[str] = None,
        validation_key: Optional[str] = None,
        decryption: Optional[str] = None,
        decryption_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword validation: MachineKey validation.
        :paramtype validation: str
        :keyword validation_key: Validation key.
        :paramtype validation_key: str
        :keyword decryption: Algorithm used for decryption.
        :paramtype decryption: str
        :keyword decryption_key: Decryption key.
        :paramtype decryption_key: str
        """
        super().__init__(**kwargs)
        self.validation = validation
        self.validation_key = validation_key
        self.decryption = decryption
        self.decryption_key = decryption_key


class SitePatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a site.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar identity: Managed service identity.
    :vartype identity: ~azure.mgmt.web.v2018_02_01.models.ManagedServiceIdentity
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Known values are: "Normal" and "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2018_02_01.models.UsageState
    :ivar enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :vartype enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Known values
     are: "Normal", "Limited", and "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2018_02_01.models.SiteAvailabilityState
    :ivar host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :vartype host_name_ssl_states: list[~azure.mgmt.web.v2018_02_01.models.HostNameSslState]
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    :ivar reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :vartype reserved: bool
    :ivar is_xenon: Obsolete: Hyper-V sandbox.
    :vartype is_xenon: bool
    :ivar hyper_v: Hyper-V sandbox.
    :vartype hyper_v: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar site_config: Configuration of the app.
    :vartype site_config: ~azure.mgmt.web.v2018_02_01.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :ivar scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :vartype scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :ivar hosting_environment_profile: App Service Environment to use for the app.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2018_02_01.models.HostingEnvironmentProfile
    :ivar client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :vartype client_affinity_enabled: bool
    :ivar client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :vartype client_cert_enabled: bool
    :ivar client_cert_exclusion_paths: client certificate authentication comma-separated exclusion
     paths.
    :vartype client_cert_exclusion_paths: str
    :ivar host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :vartype host_names_disabled: bool
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants. Read-only.
    :vartype possible_outbound_ip_addresses: str
    :ivar container_size: Size of the function container.
    :vartype container_size: int
    :ivar daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :vartype daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :ivar cloning_info: If specified during app creation, the app is cloned from a source app.
    :vartype cloning_info: ~azure.mgmt.web.v2018_02_01.models.CloningInfo
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2018_02_01.models.SlotSwapStatus
    :ivar https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :vartype https_only: bool
    :ivar redundancy_mode: Site redundancy mode. Known values are: "None", "Manual", "Failover",
     "ActiveActive", and "GeoRedundant".
    :vartype redundancy_mode: str or ~azure.mgmt.web.v2018_02_01.models.RedundancyMode
    :ivar in_progress_operation_id: Specifies an operation id if this site has a pending operation.
    :vartype in_progress_operation_id: str
    :ivar geo_distributions: GeoDistributions for this site.
    :vartype geo_distributions: list[~azure.mgmt.web.v2018_02_01.models.GeoDistribution]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "state": {"readonly": True},
        "host_names": {"readonly": True},
        "repository_site_name": {"readonly": True},
        "usage_state": {"readonly": True},
        "enabled_host_names": {"readonly": True},
        "availability_state": {"readonly": True},
        "last_modified_time_utc": {"readonly": True},
        "traffic_manager_host_names": {"readonly": True},
        "target_swap_slot": {"readonly": True},
        "outbound_ip_addresses": {"readonly": True},
        "possible_outbound_ip_addresses": {"readonly": True},
        "suspended_till": {"readonly": True},
        "max_number_of_workers": {"readonly": True},
        "resource_group": {"readonly": True},
        "is_default_container": {"readonly": True},
        "default_host_name": {"readonly": True},
        "slot_swap_status": {"readonly": True},
        "in_progress_operation_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "state": {"key": "properties.state", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
        "repository_site_name": {"key": "properties.repositorySiteName", "type": "str"},
        "usage_state": {"key": "properties.usageState", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "enabled_host_names": {"key": "properties.enabledHostNames", "type": "[str]"},
        "availability_state": {"key": "properties.availabilityState", "type": "str"},
        "host_name_ssl_states": {"key": "properties.hostNameSslStates", "type": "[HostNameSslState]"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
        "reserved": {"key": "properties.reserved", "type": "bool"},
        "is_xenon": {"key": "properties.isXenon", "type": "bool"},
        "hyper_v": {"key": "properties.hyperV", "type": "bool"},
        "last_modified_time_utc": {"key": "properties.lastModifiedTimeUtc", "type": "iso-8601"},
        "site_config": {"key": "properties.siteConfig", "type": "SiteConfig"},
        "traffic_manager_host_names": {"key": "properties.trafficManagerHostNames", "type": "[str]"},
        "scm_site_also_stopped": {"key": "properties.scmSiteAlsoStopped", "type": "bool"},
        "target_swap_slot": {"key": "properties.targetSwapSlot", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "client_affinity_enabled": {"key": "properties.clientAffinityEnabled", "type": "bool"},
        "client_cert_enabled": {"key": "properties.clientCertEnabled", "type": "bool"},
        "client_cert_exclusion_paths": {"key": "properties.clientCertExclusionPaths", "type": "str"},
        "host_names_disabled": {"key": "properties.hostNamesDisabled", "type": "bool"},
        "outbound_ip_addresses": {"key": "properties.outboundIpAddresses", "type": "str"},
        "possible_outbound_ip_addresses": {"key": "properties.possibleOutboundIpAddresses", "type": "str"},
        "container_size": {"key": "properties.containerSize", "type": "int"},
        "daily_memory_time_quota": {"key": "properties.dailyMemoryTimeQuota", "type": "int"},
        "suspended_till": {"key": "properties.suspendedTill", "type": "iso-8601"},
        "max_number_of_workers": {"key": "properties.maxNumberOfWorkers", "type": "int"},
        "cloning_info": {"key": "properties.cloningInfo", "type": "CloningInfo"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "is_default_container": {"key": "properties.isDefaultContainer", "type": "bool"},
        "default_host_name": {"key": "properties.defaultHostName", "type": "str"},
        "slot_swap_status": {"key": "properties.slotSwapStatus", "type": "SlotSwapStatus"},
        "https_only": {"key": "properties.httpsOnly", "type": "bool"},
        "redundancy_mode": {"key": "properties.redundancyMode", "type": "str"},
        "in_progress_operation_id": {"key": "properties.inProgressOperationId", "type": "str"},
        "geo_distributions": {"key": "properties.geoDistributions", "type": "[GeoDistribution]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        enabled: Optional[bool] = None,
        host_name_ssl_states: Optional[List["_models.HostNameSslState"]] = None,
        server_farm_id: Optional[str] = None,
        reserved: bool = False,
        is_xenon: bool = False,
        hyper_v: bool = False,
        site_config: Optional["_models.SiteConfig"] = None,
        scm_site_also_stopped: bool = False,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        client_affinity_enabled: Optional[bool] = None,
        client_cert_enabled: Optional[bool] = None,
        client_cert_exclusion_paths: Optional[str] = None,
        host_names_disabled: Optional[bool] = None,
        container_size: Optional[int] = None,
        daily_memory_time_quota: Optional[int] = None,
        cloning_info: Optional["_models.CloningInfo"] = None,
        https_only: Optional[bool] = None,
        redundancy_mode: Optional[Union[str, "_models.RedundancyMode"]] = None,
        geo_distributions: Optional[List["_models.GeoDistribution"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword identity: Managed service identity.
        :paramtype identity: ~azure.mgmt.web.v2018_02_01.models.ManagedServiceIdentity
        :keyword enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
         :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
         offline).
        :paramtype enabled: bool
        :keyword host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for
         app's hostnames.
        :paramtype host_name_ssl_states: list[~azure.mgmt.web.v2018_02_01.models.HostNameSslState]
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        :keyword reserved: :code:`<code>true</code>` if reserved; otherwise,
         :code:`<code>false</code>`.
        :paramtype reserved: bool
        :keyword is_xenon: Obsolete: Hyper-V sandbox.
        :paramtype is_xenon: bool
        :keyword hyper_v: Hyper-V sandbox.
        :paramtype hyper_v: bool
        :keyword site_config: Configuration of the app.
        :paramtype site_config: ~azure.mgmt.web.v2018_02_01.models.SiteConfig
        :keyword scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app
         is stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
        :paramtype scm_site_also_stopped: bool
        :keyword hosting_environment_profile: App Service Environment to use for the app.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2018_02_01.models.HostingEnvironmentProfile
        :keyword client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
         :code:`<code>false</code>` to stop sending session affinity cookies, which route client
         requests in the same session to the same instance. Default is :code:`<code>true</code>`.
        :paramtype client_affinity_enabled: bool
        :keyword client_cert_enabled: :code:`<code>true</code>` to enable client certificate
         authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
         :code:`<code>false</code>`.
        :paramtype client_cert_enabled: bool
        :keyword client_cert_exclusion_paths: client certificate authentication comma-separated
         exclusion paths.
        :paramtype client_cert_exclusion_paths: str
        :keyword host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
         app; otherwise, :code:`<code>false</code>`.
          If :code:`<code>true</code>`, the app is only accessible via API management process.
        :paramtype host_names_disabled: bool
        :keyword container_size: Size of the function container.
        :paramtype container_size: int
        :keyword daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on
         dynamic apps only).
        :paramtype daily_memory_time_quota: int
        :keyword cloning_info: If specified during app creation, the app is cloned from a source app.
        :paramtype cloning_info: ~azure.mgmt.web.v2018_02_01.models.CloningInfo
        :keyword https_only: HttpsOnly: configures a web site to accept only https requests. Issues
         redirect for
         http requests.
        :paramtype https_only: bool
        :keyword redundancy_mode: Site redundancy mode. Known values are: "None", "Manual", "Failover",
         "ActiveActive", and "GeoRedundant".
        :paramtype redundancy_mode: str or ~azure.mgmt.web.v2018_02_01.models.RedundancyMode
        :keyword geo_distributions: GeoDistributions for this site.
        :paramtype geo_distributions: list[~azure.mgmt.web.v2018_02_01.models.GeoDistribution]
        """
        super().__init__(kind=kind, **kwargs)
        self.identity = identity
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = enabled
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = host_name_ssl_states
        self.server_farm_id = server_farm_id
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.last_modified_time_utc = None
        self.site_config = site_config
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = scm_site_also_stopped
        self.target_swap_slot = None
        self.hosting_environment_profile = hosting_environment_profile
        self.client_affinity_enabled = client_affinity_enabled
        self.client_cert_enabled = client_cert_enabled
        self.client_cert_exclusion_paths = client_cert_exclusion_paths
        self.host_names_disabled = host_names_disabled
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = container_size
        self.daily_memory_time_quota = daily_memory_time_quota
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = cloning_info
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = https_only
        self.redundancy_mode = redundancy_mode
        self.in_progress_operation_id = None
        self.geo_distributions = geo_distributions


class SitePhpErrorLogFlag(ProxyOnlyResource):
    """Used for getting PHP error logging flag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar local_log_errors: Local log_errors setting.
    :vartype local_log_errors: str
    :ivar master_log_errors: Master log_errors setting.
    :vartype master_log_errors: str
    :ivar local_log_errors_max_length: Local log_errors_max_len setting.
    :vartype local_log_errors_max_length: str
    :ivar master_log_errors_max_length: Master log_errors_max_len setting.
    :vartype master_log_errors_max_length: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "local_log_errors": {"key": "properties.localLogErrors", "type": "str"},
        "master_log_errors": {"key": "properties.masterLogErrors", "type": "str"},
        "local_log_errors_max_length": {"key": "properties.localLogErrorsMaxLength", "type": "str"},
        "master_log_errors_max_length": {"key": "properties.masterLogErrorsMaxLength", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        local_log_errors: Optional[str] = None,
        master_log_errors: Optional[str] = None,
        local_log_errors_max_length: Optional[str] = None,
        master_log_errors_max_length: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword local_log_errors: Local log_errors setting.
        :paramtype local_log_errors: str
        :keyword master_log_errors: Master log_errors setting.
        :paramtype master_log_errors: str
        :keyword local_log_errors_max_length: Local log_errors_max_len setting.
        :paramtype local_log_errors_max_length: str
        :keyword master_log_errors_max_length: Master log_errors_max_len setting.
        :paramtype master_log_errors_max_length: str
        """
        super().__init__(kind=kind, **kwargs)
        self.local_log_errors = local_log_errors
        self.master_log_errors = master_log_errors
        self.local_log_errors_max_length = local_log_errors_max_length
        self.master_log_errors_max_length = master_log_errors_max_length


class SiteSeal(_serialization.Model):
    """Site seal.

    All required parameters must be populated in order to send to Azure.

    :ivar html: HTML snippet. Required.
    :vartype html: str
    """

    _validation = {
        "html": {"required": True},
    }

    _attribute_map = {
        "html": {"key": "html", "type": "str"},
    }

    def __init__(self, *, html: str, **kwargs: Any) -> None:
        """
        :keyword html: HTML snippet. Required.
        :paramtype html: str
        """
        super().__init__(**kwargs)
        self.html = html


class SiteSealRequest(_serialization.Model):
    """Site seal request.

    :ivar light_theme: If :code:`<code>true</code>` use the light color theme for site seal;
     otherwise, use the default color theme.
    :vartype light_theme: bool
    :ivar locale: Locale of site seal.
    :vartype locale: str
    """

    _attribute_map = {
        "light_theme": {"key": "lightTheme", "type": "bool"},
        "locale": {"key": "locale", "type": "str"},
    }

    def __init__(self, *, light_theme: Optional[bool] = None, locale: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword light_theme: If :code:`<code>true</code>` use the light color theme for site seal;
         otherwise, use the default color theme.
        :paramtype light_theme: bool
        :keyword locale: Locale of site seal.
        :paramtype locale: str
        """
        super().__init__(**kwargs)
        self.light_theme = light_theme
        self.locale = locale


class SiteSourceControl(ProxyOnlyResource):
    """Source control configuration for an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar repo_url: Repository or source control URL.
    :vartype repo_url: str
    :ivar branch: Name of branch to use for deployment.
    :vartype branch: str
    :ivar is_manual_integration: :code:`<code>true</code>` to limit to manual integration;
     :code:`<code>false</code>` to enable continuous integration (which configures webhooks into
     online repos like GitHub).
    :vartype is_manual_integration: bool
    :ivar deployment_rollback_enabled: :code:`<code>true</code>` to enable deployment rollback;
     otherwise, :code:`<code>false</code>`.
    :vartype deployment_rollback_enabled: bool
    :ivar is_mercurial: :code:`<code>true</code>` for a Mercurial repository;
     :code:`<code>false</code>` for a Git repository.
    :vartype is_mercurial: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "repo_url": {"key": "properties.repoUrl", "type": "str"},
        "branch": {"key": "properties.branch", "type": "str"},
        "is_manual_integration": {"key": "properties.isManualIntegration", "type": "bool"},
        "deployment_rollback_enabled": {"key": "properties.deploymentRollbackEnabled", "type": "bool"},
        "is_mercurial": {"key": "properties.isMercurial", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        repo_url: Optional[str] = None,
        branch: Optional[str] = None,
        is_manual_integration: Optional[bool] = None,
        deployment_rollback_enabled: Optional[bool] = None,
        is_mercurial: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword repo_url: Repository or source control URL.
        :paramtype repo_url: str
        :keyword branch: Name of branch to use for deployment.
        :paramtype branch: str
        :keyword is_manual_integration: :code:`<code>true</code>` to limit to manual integration;
         :code:`<code>false</code>` to enable continuous integration (which configures webhooks into
         online repos like GitHub).
        :paramtype is_manual_integration: bool
        :keyword deployment_rollback_enabled: :code:`<code>true</code>` to enable deployment rollback;
         otherwise, :code:`<code>false</code>`.
        :paramtype deployment_rollback_enabled: bool
        :keyword is_mercurial: :code:`<code>true</code>` for a Mercurial repository;
         :code:`<code>false</code>` for a Git repository.
        :paramtype is_mercurial: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.repo_url = repo_url
        self.branch = branch
        self.is_manual_integration = is_manual_integration
        self.deployment_rollback_enabled = deployment_rollback_enabled
        self.is_mercurial = is_mercurial


class SkuCapacity(_serialization.Model):
    """Description of the App Service plan scale options.

    :ivar minimum: Minimum number of workers for this App Service plan SKU.
    :vartype minimum: int
    :ivar maximum: Maximum number of workers for this App Service plan SKU.
    :vartype maximum: int
    :ivar default: Default number of workers for this App Service plan SKU.
    :vartype default: int
    :ivar scale_type: Available scale configurations for an App Service plan.
    :vartype scale_type: str
    """

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "default": {"key": "default", "type": "int"},
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(
        self,
        *,
        minimum: Optional[int] = None,
        maximum: Optional[int] = None,
        default: Optional[int] = None,
        scale_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword minimum: Minimum number of workers for this App Service plan SKU.
        :paramtype minimum: int
        :keyword maximum: Maximum number of workers for this App Service plan SKU.
        :paramtype maximum: int
        :keyword default: Default number of workers for this App Service plan SKU.
        :paramtype default: int
        :keyword scale_type: Available scale configurations for an App Service plan.
        :paramtype scale_type: str
        """
        super().__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.default = default
        self.scale_type = scale_type


class SkuDescription(_serialization.Model):
    """Description of a SKU for a scalable resource.

    :ivar name: Name of the resource SKU.
    :vartype name: str
    :ivar tier: Service tier of the resource SKU.
    :vartype tier: str
    :ivar size: Size specifier of the resource SKU.
    :vartype size: str
    :ivar family: Family code of the resource SKU.
    :vartype family: str
    :ivar capacity: Current number of instances assigned to the resource.
    :vartype capacity: int
    :ivar sku_capacity: Min, max, and default scale values of the SKU.
    :vartype sku_capacity: ~azure.mgmt.web.v2018_02_01.models.SkuCapacity
    :ivar locations: Locations of the SKU.
    :vartype locations: list[str]
    :ivar capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
    :vartype capabilities: list[~azure.mgmt.web.v2018_02_01.models.Capability]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
        "sku_capacity": {"key": "skuCapacity", "type": "SkuCapacity"},
        "locations": {"key": "locations", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[Capability]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        sku_capacity: Optional["_models.SkuCapacity"] = None,
        locations: Optional[List[str]] = None,
        capabilities: Optional[List["_models.Capability"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the resource SKU.
        :paramtype name: str
        :keyword tier: Service tier of the resource SKU.
        :paramtype tier: str
        :keyword size: Size specifier of the resource SKU.
        :paramtype size: str
        :keyword family: Family code of the resource SKU.
        :paramtype family: str
        :keyword capacity: Current number of instances assigned to the resource.
        :paramtype capacity: int
        :keyword sku_capacity: Min, max, and default scale values of the SKU.
        :paramtype sku_capacity: ~azure.mgmt.web.v2018_02_01.models.SkuCapacity
        :keyword locations: Locations of the SKU.
        :paramtype locations: list[str]
        :keyword capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
        :paramtype capabilities: list[~azure.mgmt.web.v2018_02_01.models.Capability]
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity
        self.sku_capacity = sku_capacity
        self.locations = locations
        self.capabilities = capabilities


class SkuInfo(_serialization.Model):
    """SKU discovery information.

    :ivar resource_type: Resource type that this SKU applies to.
    :vartype resource_type: str
    :ivar sku: Name and tier of the SKU.
    :vartype sku: ~azure.mgmt.web.v2018_02_01.models.SkuDescription
    :ivar capacity: Min, max, and default scale values of the SKU.
    :vartype capacity: ~azure.mgmt.web.v2018_02_01.models.SkuCapacity
    """

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "sku": {"key": "sku", "type": "SkuDescription"},
        "capacity": {"key": "capacity", "type": "SkuCapacity"},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        sku: Optional["_models.SkuDescription"] = None,
        capacity: Optional["_models.SkuCapacity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_type: Resource type that this SKU applies to.
        :paramtype resource_type: str
        :keyword sku: Name and tier of the SKU.
        :paramtype sku: ~azure.mgmt.web.v2018_02_01.models.SkuDescription
        :keyword capacity: Min, max, and default scale values of the SKU.
        :paramtype capacity: ~azure.mgmt.web.v2018_02_01.models.SkuCapacity
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.sku = sku
        self.capacity = capacity


class SkuInfoCollection(_serialization.Model):
    """Collection of SKU information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.SkuInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SkuInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SkuInfo"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.SkuInfo]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SkuInfos(_serialization.Model):
    """Collection of SKU information.

    :ivar resource_type: Resource type that this SKU applies to.
    :vartype resource_type: str
    :ivar skus: List of SKUs the subscription is able to use.
    :vartype skus: list[~azure.mgmt.web.v2018_02_01.models.GlobalCsmSkuDescription]
    """

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "skus": {"key": "skus", "type": "[GlobalCsmSkuDescription]"},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        skus: Optional[List["_models.GlobalCsmSkuDescription"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_type: Resource type that this SKU applies to.
        :paramtype resource_type: str
        :keyword skus: List of SKUs the subscription is able to use.
        :paramtype skus: list[~azure.mgmt.web.v2018_02_01.models.GlobalCsmSkuDescription]
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.skus = skus


class SlotConfigNamesResource(ProxyOnlyResource):
    """Slot Config names azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar connection_string_names: List of connection string names.
    :vartype connection_string_names: list[str]
    :ivar app_setting_names: List of application settings names.
    :vartype app_setting_names: list[str]
    :ivar azure_storage_config_names: List of external Azure storage account identifiers.
    :vartype azure_storage_config_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "connection_string_names": {"key": "properties.connectionStringNames", "type": "[str]"},
        "app_setting_names": {"key": "properties.appSettingNames", "type": "[str]"},
        "azure_storage_config_names": {"key": "properties.azureStorageConfigNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        connection_string_names: Optional[List[str]] = None,
        app_setting_names: Optional[List[str]] = None,
        azure_storage_config_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword connection_string_names: List of connection string names.
        :paramtype connection_string_names: list[str]
        :keyword app_setting_names: List of application settings names.
        :paramtype app_setting_names: list[str]
        :keyword azure_storage_config_names: List of external Azure storage account identifiers.
        :paramtype azure_storage_config_names: list[str]
        """
        super().__init__(kind=kind, **kwargs)
        self.connection_string_names = connection_string_names
        self.app_setting_names = app_setting_names
        self.azure_storage_config_names = azure_storage_config_names


class SlotDifference(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """A setting difference between two deployment slots of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar level: Level of the difference: Information, Warning or Error.
    :vartype level: str
    :ivar setting_type: The type of the setting: General, AppSetting or ConnectionString.
    :vartype setting_type: str
    :ivar diff_rule: Rule that describes how to process the setting difference during a slot swap.
    :vartype diff_rule: str
    :ivar setting_name: Name of the setting.
    :vartype setting_name: str
    :ivar value_in_current_slot: Value of the setting in the current slot.
    :vartype value_in_current_slot: str
    :ivar value_in_target_slot: Value of the setting in the target slot.
    :vartype value_in_target_slot: str
    :ivar description: Description of the setting difference.
    :vartype description: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "level": {"readonly": True},
        "setting_type": {"readonly": True},
        "diff_rule": {"readonly": True},
        "setting_name": {"readonly": True},
        "value_in_current_slot": {"readonly": True},
        "value_in_target_slot": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "level": {"key": "properties.level", "type": "str"},
        "setting_type": {"key": "properties.settingType", "type": "str"},
        "diff_rule": {"key": "properties.diffRule", "type": "str"},
        "setting_name": {"key": "properties.settingName", "type": "str"},
        "value_in_current_slot": {"key": "properties.valueInCurrentSlot", "type": "str"},
        "value_in_target_slot": {"key": "properties.valueInTargetSlot", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.level = None
        self.setting_type = None
        self.diff_rule = None
        self.setting_name = None
        self.value_in_current_slot = None
        self.value_in_target_slot = None
        self.description = None


class SlotDifferenceCollection(_serialization.Model):
    """Collection of slot differences.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.SlotDifference]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SlotDifference]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SlotDifference"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.SlotDifference]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SlotSwapStatus(_serialization.Model):
    """The status of the last successful slot swap operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp_utc: The time the last successful slot swap completed.
    :vartype timestamp_utc: ~datetime.datetime
    :ivar source_slot_name: The source slot of the last swap operation.
    :vartype source_slot_name: str
    :ivar destination_slot_name: The destination slot of the last swap operation.
    :vartype destination_slot_name: str
    """

    _validation = {
        "timestamp_utc": {"readonly": True},
        "source_slot_name": {"readonly": True},
        "destination_slot_name": {"readonly": True},
    }

    _attribute_map = {
        "timestamp_utc": {"key": "timestampUtc", "type": "iso-8601"},
        "source_slot_name": {"key": "sourceSlotName", "type": "str"},
        "destination_slot_name": {"key": "destinationSlotName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.timestamp_utc = None
        self.source_slot_name = None
        self.destination_slot_name = None


class SlowRequestsBasedTrigger(_serialization.Model):
    """Trigger based on request execution time.

    :ivar time_taken: Time taken.
    :vartype time_taken: str
    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        "time_taken": {"key": "timeTaken", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "time_interval": {"key": "timeInterval", "type": "str"},
    }

    def __init__(
        self,
        *,
        time_taken: Optional[str] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_taken: Time taken.
        :paramtype time_taken: str
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super().__init__(**kwargs)
        self.time_taken = time_taken
        self.count = count
        self.time_interval = time_interval


class Snapshot(ProxyOnlyResource):
    """A snapshot of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time: The time the snapshot was taken.
    :vartype time: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "time": {"key": "properties.time", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.time = None


class SnapshotCollection(_serialization.Model):
    """Collection of snapshots which can be used to revert an app to a previous time.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.Snapshot]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Snapshot]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Snapshot"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.Snapshot]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SnapshotRecoverySource(_serialization.Model):
    """Specifies the web app that snapshot contents will be retrieved from.

    :ivar location: Geographical location of the source web app, e.g. SouthEastAsia,
     SouthCentralUS.
    :vartype location: str
    :ivar id: ARM resource ID of the source app.
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :vartype id: str
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Geographical location of the source web app, e.g. SouthEastAsia,
         SouthCentralUS.
        :paramtype location: str
        :keyword id: ARM resource ID of the source app.
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
         for production slots and
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
         for other slots.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.id = id


class SnapshotRestoreRequest(ProxyOnlyResource):
    """Details about app recovery operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar snapshot_time: Point in time in which the app restore should be done, formatted as a
     DateTime string.
    :vartype snapshot_time: str
    :ivar recovery_source: Optional. Specifies the web app that snapshot contents will be retrieved
     from.
     If empty, the targeted web app will be used as the source.
    :vartype recovery_source: ~azure.mgmt.web.v2018_02_01.models.SnapshotRecoverySource
    :ivar overwrite: If :code:`<code>true</code>` the restore operation can overwrite source app;
     otherwise, :code:`<code>false</code>`.
    :vartype overwrite: bool
    :ivar recover_configuration: If true, site configuration, in addition to content, will be
     reverted.
    :vartype recover_configuration: bool
    :ivar ignore_conflicting_host_names: If true, custom hostname conflicts will be ignored when
     recovering to a target web app.
     This setting is only necessary when RecoverConfiguration is enabled.
    :vartype ignore_conflicting_host_names: bool
    :ivar use_dr_secondary: If true, the snapshot is retrieved from DRSecondary endpoint.
    :vartype use_dr_secondary: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "snapshot_time": {"key": "properties.snapshotTime", "type": "str"},
        "recovery_source": {"key": "properties.recoverySource", "type": "SnapshotRecoverySource"},
        "overwrite": {"key": "properties.overwrite", "type": "bool"},
        "recover_configuration": {"key": "properties.recoverConfiguration", "type": "bool"},
        "ignore_conflicting_host_names": {"key": "properties.ignoreConflictingHostNames", "type": "bool"},
        "use_dr_secondary": {"key": "properties.useDRSecondary", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        snapshot_time: Optional[str] = None,
        recovery_source: Optional["_models.SnapshotRecoverySource"] = None,
        overwrite: Optional[bool] = None,
        recover_configuration: Optional[bool] = None,
        ignore_conflicting_host_names: Optional[bool] = None,
        use_dr_secondary: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword snapshot_time: Point in time in which the app restore should be done, formatted as a
         DateTime string.
        :paramtype snapshot_time: str
        :keyword recovery_source: Optional. Specifies the web app that snapshot contents will be
         retrieved from.
         If empty, the targeted web app will be used as the source.
        :paramtype recovery_source: ~azure.mgmt.web.v2018_02_01.models.SnapshotRecoverySource
        :keyword overwrite: If :code:`<code>true</code>` the restore operation can overwrite source
         app; otherwise, :code:`<code>false</code>`.
        :paramtype overwrite: bool
        :keyword recover_configuration: If true, site configuration, in addition to content, will be
         reverted.
        :paramtype recover_configuration: bool
        :keyword ignore_conflicting_host_names: If true, custom hostname conflicts will be ignored when
         recovering to a target web app.
         This setting is only necessary when RecoverConfiguration is enabled.
        :paramtype ignore_conflicting_host_names: bool
        :keyword use_dr_secondary: If true, the snapshot is retrieved from DRSecondary endpoint.
        :paramtype use_dr_secondary: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.snapshot_time = snapshot_time
        self.recovery_source = recovery_source
        self.overwrite = overwrite
        self.recover_configuration = recover_configuration
        self.ignore_conflicting_host_names = ignore_conflicting_host_names
        self.use_dr_secondary = use_dr_secondary


class Solution(_serialization.Model):
    """Class Representing Solution for problems detected.

    :ivar id: Solution Id.
    :vartype id: float
    :ivar display_name: Display Name of the solution.
    :vartype display_name: str
    :ivar order: Order of the solution.
    :vartype order: float
    :ivar description: Description of the solution.
    :vartype description: str
    :ivar type: Type of Solution. Known values are: "QuickSolution", "DeepInvestigation", and
     "BestPractices".
    :vartype type: str or ~azure.mgmt.web.v2018_02_01.models.SolutionType
    :ivar data: Solution Data.
    :vartype data: list[list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]]
    :ivar metadata: Solution Metadata.
    :vartype metadata: list[list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "float"},
        "display_name": {"key": "displayName", "type": "str"},
        "order": {"key": "order", "type": "float"},
        "description": {"key": "description", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data": {"key": "data", "type": "[[NameValuePair]]"},
        "metadata": {"key": "metadata", "type": "[[NameValuePair]]"},
    }

    def __init__(
        self,
        *,
        id: Optional[float] = None,  # pylint: disable=redefined-builtin
        display_name: Optional[str] = None,
        order: Optional[float] = None,
        description: Optional[str] = None,
        type: Optional[Union[str, "_models.SolutionType"]] = None,
        data: Optional[List[List["_models.NameValuePair"]]] = None,
        metadata: Optional[List[List["_models.NameValuePair"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Solution Id.
        :paramtype id: float
        :keyword display_name: Display Name of the solution.
        :paramtype display_name: str
        :keyword order: Order of the solution.
        :paramtype order: float
        :keyword description: Description of the solution.
        :paramtype description: str
        :keyword type: Type of Solution. Known values are: "QuickSolution", "DeepInvestigation", and
         "BestPractices".
        :paramtype type: str or ~azure.mgmt.web.v2018_02_01.models.SolutionType
        :keyword data: Solution Data.
        :paramtype data: list[list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]]
        :keyword metadata: Solution Metadata.
        :paramtype metadata: list[list[~azure.mgmt.web.v2018_02_01.models.NameValuePair]]
        """
        super().__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.order = order
        self.description = description
        self.type = type
        self.data = data
        self.metadata = metadata


class SourceControl(ProxyOnlyResource):
    """The source control OAuth token.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar token: OAuth access token.
    :vartype token: str
    :ivar token_secret: OAuth access token secret.
    :vartype token_secret: str
    :ivar refresh_token: OAuth refresh token.
    :vartype refresh_token: str
    :ivar expiration_time: OAuth token expiration.
    :vartype expiration_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "token": {"key": "properties.token", "type": "str"},
        "token_secret": {"key": "properties.tokenSecret", "type": "str"},
        "refresh_token": {"key": "properties.refreshToken", "type": "str"},
        "expiration_time": {"key": "properties.expirationTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        token: Optional[str] = None,
        token_secret: Optional[str] = None,
        refresh_token: Optional[str] = None,
        expiration_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword token: OAuth access token.
        :paramtype token: str
        :keyword token_secret: OAuth access token secret.
        :paramtype token_secret: str
        :keyword refresh_token: OAuth refresh token.
        :paramtype refresh_token: str
        :keyword expiration_time: OAuth token expiration.
        :paramtype expiration_time: ~datetime.datetime
        """
        super().__init__(kind=kind, **kwargs)
        self.token = token
        self.token_secret = token_secret
        self.refresh_token = refresh_token
        self.expiration_time = expiration_time


class SourceControlCollection(_serialization.Model):
    """Collection of source controls.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.SourceControl]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SourceControl]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SourceControl"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.SourceControl]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class StackMajorVersion(_serialization.Model):
    """Application stack major version.

    :ivar display_version: Application stack major version (display only).
    :vartype display_version: str
    :ivar runtime_version: Application stack major version (runtime only).
    :vartype runtime_version: str
    :ivar is_default: :code:`<code>true</code>` if this is the default major version; otherwise,
     :code:`<code>false</code>`.
    :vartype is_default: bool
    :ivar minor_versions: Minor versions associated with the major version.
    :vartype minor_versions: list[~azure.mgmt.web.v2018_02_01.models.StackMinorVersion]
    :ivar application_insights: :code:`<code>true</code>` if this supports Application Insights;
     otherwise, :code:`<code>false</code>`.
    :vartype application_insights: bool
    """

    _attribute_map = {
        "display_version": {"key": "displayVersion", "type": "str"},
        "runtime_version": {"key": "runtimeVersion", "type": "str"},
        "is_default": {"key": "isDefault", "type": "bool"},
        "minor_versions": {"key": "minorVersions", "type": "[StackMinorVersion]"},
        "application_insights": {"key": "applicationInsights", "type": "bool"},
    }

    def __init__(
        self,
        *,
        display_version: Optional[str] = None,
        runtime_version: Optional[str] = None,
        is_default: Optional[bool] = None,
        minor_versions: Optional[List["_models.StackMinorVersion"]] = None,
        application_insights: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_version: Application stack major version (display only).
        :paramtype display_version: str
        :keyword runtime_version: Application stack major version (runtime only).
        :paramtype runtime_version: str
        :keyword is_default: :code:`<code>true</code>` if this is the default major version; otherwise,
         :code:`<code>false</code>`.
        :paramtype is_default: bool
        :keyword minor_versions: Minor versions associated with the major version.
        :paramtype minor_versions: list[~azure.mgmt.web.v2018_02_01.models.StackMinorVersion]
        :keyword application_insights: :code:`<code>true</code>` if this supports Application Insights;
         otherwise, :code:`<code>false</code>`.
        :paramtype application_insights: bool
        """
        super().__init__(**kwargs)
        self.display_version = display_version
        self.runtime_version = runtime_version
        self.is_default = is_default
        self.minor_versions = minor_versions
        self.application_insights = application_insights


class StackMinorVersion(_serialization.Model):
    """Application stack minor version.

    :ivar display_version: Application stack minor version (display only).
    :vartype display_version: str
    :ivar runtime_version: Application stack minor version (runtime only).
    :vartype runtime_version: str
    :ivar is_default: :code:`<code>true</code>` if this is the default minor version; otherwise,
     :code:`<code>false</code>`.
    :vartype is_default: bool
    :ivar is_remote_debugging_enabled: :code:`<code>true</code>` if this supports Remote Debugging,
     otherwise :code:`<code>false</code>`.
    :vartype is_remote_debugging_enabled: bool
    """

    _attribute_map = {
        "display_version": {"key": "displayVersion", "type": "str"},
        "runtime_version": {"key": "runtimeVersion", "type": "str"},
        "is_default": {"key": "isDefault", "type": "bool"},
        "is_remote_debugging_enabled": {"key": "isRemoteDebuggingEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        display_version: Optional[str] = None,
        runtime_version: Optional[str] = None,
        is_default: Optional[bool] = None,
        is_remote_debugging_enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_version: Application stack minor version (display only).
        :paramtype display_version: str
        :keyword runtime_version: Application stack minor version (runtime only).
        :paramtype runtime_version: str
        :keyword is_default: :code:`<code>true</code>` if this is the default minor version; otherwise,
         :code:`<code>false</code>`.
        :paramtype is_default: bool
        :keyword is_remote_debugging_enabled: :code:`<code>true</code>` if this supports Remote
         Debugging, otherwise :code:`<code>false</code>`.
        :paramtype is_remote_debugging_enabled: bool
        """
        super().__init__(**kwargs)
        self.display_version = display_version
        self.runtime_version = runtime_version
        self.is_default = is_default
        self.is_remote_debugging_enabled = is_remote_debugging_enabled


class StampCapacity(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Stamp capacity information.

    :ivar name: Name of the stamp.
    :vartype name: str
    :ivar available_capacity: Available capacity (# of machines, bytes of storage etc...).
    :vartype available_capacity: int
    :ivar total_capacity: Total capacity (# of machines, bytes of storage etc...).
    :vartype total_capacity: int
    :ivar unit: Name of the unit.
    :vartype unit: str
    :ivar compute_mode: Shared/dedicated workers. Known values are: "Shared", "Dedicated", and
     "Dynamic".
    :vartype compute_mode: str or ~azure.mgmt.web.v2018_02_01.models.ComputeModeOptions
    :ivar worker_size: Size of the machines. Known values are: "Small", "Medium", "Large", "D1",
     "D2", "D3", and "Default".
    :vartype worker_size: str or ~azure.mgmt.web.v2018_02_01.models.WorkerSizeOptions
    :ivar worker_size_id: Size ID of machines:
     0 - Small
     1 - Medium
     2 - Large.
    :vartype worker_size_id: int
    :ivar exclude_from_capacity_allocation: If :code:`<code>true</code>`, it includes basic apps.
     Basic apps are not used for capacity allocation.
    :vartype exclude_from_capacity_allocation: bool
    :ivar is_applicable_for_all_compute_modes: :code:`<code>true</code>` if capacity is applicable
     for all apps; otherwise, :code:`<code>false</code>`.
    :vartype is_applicable_for_all_compute_modes: bool
    :ivar site_mode: Shared or Dedicated.
    :vartype site_mode: str
    :ivar is_linux: Is this a linux stamp capacity.
    :vartype is_linux: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "available_capacity": {"key": "availableCapacity", "type": "int"},
        "total_capacity": {"key": "totalCapacity", "type": "int"},
        "unit": {"key": "unit", "type": "str"},
        "compute_mode": {"key": "computeMode", "type": "str"},
        "worker_size": {"key": "workerSize", "type": "str"},
        "worker_size_id": {"key": "workerSizeId", "type": "int"},
        "exclude_from_capacity_allocation": {"key": "excludeFromCapacityAllocation", "type": "bool"},
        "is_applicable_for_all_compute_modes": {"key": "isApplicableForAllComputeModes", "type": "bool"},
        "site_mode": {"key": "siteMode", "type": "str"},
        "is_linux": {"key": "isLinux", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        available_capacity: Optional[int] = None,
        total_capacity: Optional[int] = None,
        unit: Optional[str] = None,
        compute_mode: Optional[Union[str, "_models.ComputeModeOptions"]] = None,
        worker_size: Optional[Union[str, "_models.WorkerSizeOptions"]] = None,
        worker_size_id: Optional[int] = None,
        exclude_from_capacity_allocation: Optional[bool] = None,
        is_applicable_for_all_compute_modes: Optional[bool] = None,
        site_mode: Optional[str] = None,
        is_linux: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the stamp.
        :paramtype name: str
        :keyword available_capacity: Available capacity (# of machines, bytes of storage etc...).
        :paramtype available_capacity: int
        :keyword total_capacity: Total capacity (# of machines, bytes of storage etc...).
        :paramtype total_capacity: int
        :keyword unit: Name of the unit.
        :paramtype unit: str
        :keyword compute_mode: Shared/dedicated workers. Known values are: "Shared", "Dedicated", and
         "Dynamic".
        :paramtype compute_mode: str or ~azure.mgmt.web.v2018_02_01.models.ComputeModeOptions
        :keyword worker_size: Size of the machines. Known values are: "Small", "Medium", "Large", "D1",
         "D2", "D3", and "Default".
        :paramtype worker_size: str or ~azure.mgmt.web.v2018_02_01.models.WorkerSizeOptions
        :keyword worker_size_id: Size ID of machines:
         0 - Small
         1 - Medium
         2 - Large.
        :paramtype worker_size_id: int
        :keyword exclude_from_capacity_allocation: If :code:`<code>true</code>`, it includes basic
         apps.
         Basic apps are not used for capacity allocation.
        :paramtype exclude_from_capacity_allocation: bool
        :keyword is_applicable_for_all_compute_modes: :code:`<code>true</code>` if capacity is
         applicable for all apps; otherwise, :code:`<code>false</code>`.
        :paramtype is_applicable_for_all_compute_modes: bool
        :keyword site_mode: Shared or Dedicated.
        :paramtype site_mode: str
        :keyword is_linux: Is this a linux stamp capacity.
        :paramtype is_linux: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.available_capacity = available_capacity
        self.total_capacity = total_capacity
        self.unit = unit
        self.compute_mode = compute_mode
        self.worker_size = worker_size
        self.worker_size_id = worker_size_id
        self.exclude_from_capacity_allocation = exclude_from_capacity_allocation
        self.is_applicable_for_all_compute_modes = is_applicable_for_all_compute_modes
        self.site_mode = site_mode
        self.is_linux = is_linux


class StampCapacityCollection(_serialization.Model):
    """Collection of stamp capacities.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.StampCapacity]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StampCapacity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.StampCapacity"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.StampCapacity]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class StatusCodesBasedTrigger(_serialization.Model):
    """Trigger based on status code.

    :ivar status: HTTP status code.
    :vartype status: int
    :ivar sub_status: Request Sub Status.
    :vartype sub_status: int
    :ivar win32_status: Win32 error code.
    :vartype win32_status: int
    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "int"},
        "sub_status": {"key": "subStatus", "type": "int"},
        "win32_status": {"key": "win32Status", "type": "int"},
        "count": {"key": "count", "type": "int"},
        "time_interval": {"key": "timeInterval", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[int] = None,
        sub_status: Optional[int] = None,
        win32_status: Optional[int] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: HTTP status code.
        :paramtype status: int
        :keyword sub_status: Request Sub Status.
        :paramtype sub_status: int
        :keyword win32_status: Win32 error code.
        :paramtype win32_status: int
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.sub_status = sub_status
        self.win32_status = win32_status
        self.count = count
        self.time_interval = time_interval


class StorageMigrationOptions(ProxyOnlyResource):
    """Options for app content migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar azurefiles_connection_string: AzureFiles connection string.
    :vartype azurefiles_connection_string: str
    :ivar azurefiles_share: AzureFiles share.
    :vartype azurefiles_share: str
    :ivar switch_site_after_migration: :code:`<code>true</code>`if the app should be switched over;
     otherwise, :code:`<code>false</code>`.
    :vartype switch_site_after_migration: bool
    :ivar block_write_access_to_site: :code:`<code>true</code>` if the app should be read only
     during copy operation; otherwise, :code:`<code>false</code>`.
    :vartype block_write_access_to_site: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "azurefiles_connection_string": {"key": "properties.azurefilesConnectionString", "type": "str"},
        "azurefiles_share": {"key": "properties.azurefilesShare", "type": "str"},
        "switch_site_after_migration": {"key": "properties.switchSiteAfterMigration", "type": "bool"},
        "block_write_access_to_site": {"key": "properties.blockWriteAccessToSite", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        azurefiles_connection_string: Optional[str] = None,
        azurefiles_share: Optional[str] = None,
        switch_site_after_migration: bool = False,
        block_write_access_to_site: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword azurefiles_connection_string: AzureFiles connection string.
        :paramtype azurefiles_connection_string: str
        :keyword azurefiles_share: AzureFiles share.
        :paramtype azurefiles_share: str
        :keyword switch_site_after_migration: :code:`<code>true</code>`if the app should be switched
         over; otherwise, :code:`<code>false</code>`.
        :paramtype switch_site_after_migration: bool
        :keyword block_write_access_to_site: :code:`<code>true</code>` if the app should be read only
         during copy operation; otherwise, :code:`<code>false</code>`.
        :paramtype block_write_access_to_site: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.azurefiles_connection_string = azurefiles_connection_string
        self.azurefiles_share = azurefiles_share
        self.switch_site_after_migration = switch_site_after_migration
        self.block_write_access_to_site = block_write_access_to_site


class StorageMigrationResponse(ProxyOnlyResource):
    """Response for a migration of app content request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar operation_id: When server starts the migration process, it will return an operation ID
     identifying that particular migration operation.
    :vartype operation_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "operation_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "operation_id": {"key": "properties.operationId", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.operation_id = None


class StringDictionary(ProxyOnlyResource):
    """String dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Settings.
    :vartype properties: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
    }

    def __init__(
        self, *, kind: Optional[str] = None, properties: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword properties: Settings.
        :paramtype properties: dict[str, str]
        """
        super().__init__(kind=kind, **kwargs)
        self.properties = properties


class SwiftVirtualNetwork(ProxyOnlyResource):
    """Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual
    network integration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar subnet_resource_id: The Virtual Network subnet's resource ID. This is the subnet that
     this Web App will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined
     first.
    :vartype subnet_resource_id: str
    :ivar swift_supported: A flag that specifies if the scale unit this Web App is on supports
     Swift integration.
    :vartype swift_supported: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "subnet_resource_id": {"key": "properties.subnetResourceId", "type": "str"},
        "swift_supported": {"key": "properties.swiftSupported", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        subnet_resource_id: Optional[str] = None,
        swift_supported: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword subnet_resource_id: The Virtual Network subnet's resource ID. This is the subnet that
         this Web App will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined
         first.
        :paramtype subnet_resource_id: str
        :keyword swift_supported: A flag that specifies if the scale unit this Web App is on supports
         Swift integration.
        :paramtype swift_supported: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.subnet_resource_id = subnet_resource_id
        self.swift_supported = swift_supported


class TldLegalAgreement(_serialization.Model):
    """Legal agreement for a top level domain.

    All required parameters must be populated in order to send to Azure.

    :ivar agreement_key: Unique identifier for the agreement. Required.
    :vartype agreement_key: str
    :ivar title: Agreement title. Required.
    :vartype title: str
    :ivar content: Agreement details. Required.
    :vartype content: str
    :ivar url: URL where a copy of the agreement details is hosted.
    :vartype url: str
    """

    _validation = {
        "agreement_key": {"required": True},
        "title": {"required": True},
        "content": {"required": True},
    }

    _attribute_map = {
        "agreement_key": {"key": "agreementKey", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "content": {"key": "content", "type": "str"},
        "url": {"key": "url", "type": "str"},
    }

    def __init__(
        self, *, agreement_key: str, title: str, content: str, url: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword agreement_key: Unique identifier for the agreement. Required.
        :paramtype agreement_key: str
        :keyword title: Agreement title. Required.
        :paramtype title: str
        :keyword content: Agreement details. Required.
        :paramtype content: str
        :keyword url: URL where a copy of the agreement details is hosted.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.agreement_key = agreement_key
        self.title = title
        self.content = content
        self.url = url


class TldLegalAgreementCollection(_serialization.Model):
    """Collection of top-level domain legal agreements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.TldLegalAgreement]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TldLegalAgreement]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.TldLegalAgreement"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.TldLegalAgreement]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class TopLevelDomain(ProxyOnlyResource):
    """A top level domain object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar privacy: If :code:`<code>true</code>`, then the top level domain supports domain privacy;
     otherwise, :code:`<code>false</code>`.
    :vartype privacy: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "privacy": {"key": "properties.privacy", "type": "bool"},
    }

    def __init__(self, *, kind: Optional[str] = None, privacy: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword privacy: If :code:`<code>true</code>`, then the top level domain supports domain
         privacy; otherwise, :code:`<code>false</code>`.
        :paramtype privacy: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.privacy = privacy


class TopLevelDomainAgreementOption(_serialization.Model):
    """Options for retrieving the list of top level domain legal agreements.

    :ivar include_privacy: If :code:`<code>true</code>`, then the list of agreements will include
     agreements for domain privacy as well; otherwise, :code:`<code>false</code>`.
    :vartype include_privacy: bool
    :ivar for_transfer: If :code:`<code>true</code>`, then the list of agreements will include
     agreements for domain transfer as well; otherwise, :code:`<code>false</code>`.
    :vartype for_transfer: bool
    """

    _attribute_map = {
        "include_privacy": {"key": "includePrivacy", "type": "bool"},
        "for_transfer": {"key": "forTransfer", "type": "bool"},
    }

    def __init__(
        self, *, include_privacy: Optional[bool] = None, for_transfer: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword include_privacy: If :code:`<code>true</code>`, then the list of agreements will
         include agreements for domain privacy as well; otherwise, :code:`<code>false</code>`.
        :paramtype include_privacy: bool
        :keyword for_transfer: If :code:`<code>true</code>`, then the list of agreements will include
         agreements for domain transfer as well; otherwise, :code:`<code>false</code>`.
        :paramtype for_transfer: bool
        """
        super().__init__(**kwargs)
        self.include_privacy = include_privacy
        self.for_transfer = for_transfer


class TopLevelDomainCollection(_serialization.Model):
    """Collection of Top-level domains.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.TopLevelDomain]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TopLevelDomain]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.TopLevelDomain"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.TopLevelDomain]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class TriggeredJobHistory(ProxyOnlyResource):
    """Triggered Web Job History. List of Triggered Web Job Run Information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar runs: List of triggered web job runs.
    :vartype runs: list[~azure.mgmt.web.v2018_02_01.models.TriggeredJobRun]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "runs": {"key": "properties.runs", "type": "[TriggeredJobRun]"},
    }

    def __init__(
        self, *, kind: Optional[str] = None, runs: Optional[List["_models.TriggeredJobRun"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword runs: List of triggered web job runs.
        :paramtype runs: list[~azure.mgmt.web.v2018_02_01.models.TriggeredJobRun]
        """
        super().__init__(kind=kind, **kwargs)
        self.runs = runs


class TriggeredJobHistoryCollection(_serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.TriggeredJobHistory]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TriggeredJobHistory]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.TriggeredJobHistory"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.TriggeredJobHistory]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class TriggeredJobRun(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Triggered Web Job Run Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar web_job_id: Job ID.
    :vartype web_job_id: str
    :ivar web_job_name: Job name.
    :vartype web_job_name: str
    :ivar status: Job status. Known values are: "Success", "Failed", and "Error".
    :vartype status: str or ~azure.mgmt.web.v2018_02_01.models.TriggeredWebJobStatus
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time.
    :vartype end_time: ~datetime.datetime
    :ivar duration: Job duration.
    :vartype duration: str
    :ivar output_url: Output URL.
    :vartype output_url: str
    :ivar error_url: Error URL.
    :vartype error_url: str
    :ivar url: Job URL.
    :vartype url: str
    :ivar job_name: Job name.
    :vartype job_name: str
    :ivar trigger: Job trigger.
    :vartype trigger: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "web_job_id": {"key": "properties.web_job_id", "type": "str"},
        "web_job_name": {"key": "properties.web_job_name", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "start_time": {"key": "properties.start_time", "type": "iso-8601"},
        "end_time": {"key": "properties.end_time", "type": "iso-8601"},
        "duration": {"key": "properties.duration", "type": "str"},
        "output_url": {"key": "properties.output_url", "type": "str"},
        "error_url": {"key": "properties.error_url", "type": "str"},
        "url": {"key": "properties.url", "type": "str"},
        "job_name": {"key": "properties.job_name", "type": "str"},
        "trigger": {"key": "properties.trigger", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        web_job_id: Optional[str] = None,
        web_job_name: Optional[str] = None,
        status: Optional[Union[str, "_models.TriggeredWebJobStatus"]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        duration: Optional[str] = None,
        output_url: Optional[str] = None,
        error_url: Optional[str] = None,
        url: Optional[str] = None,
        job_name: Optional[str] = None,
        trigger: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword web_job_id: Job ID.
        :paramtype web_job_id: str
        :keyword web_job_name: Job name.
        :paramtype web_job_name: str
        :keyword status: Job status. Known values are: "Success", "Failed", and "Error".
        :paramtype status: str or ~azure.mgmt.web.v2018_02_01.models.TriggeredWebJobStatus
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time.
        :paramtype end_time: ~datetime.datetime
        :keyword duration: Job duration.
        :paramtype duration: str
        :keyword output_url: Output URL.
        :paramtype output_url: str
        :keyword error_url: Error URL.
        :paramtype error_url: str
        :keyword url: Job URL.
        :paramtype url: str
        :keyword job_name: Job name.
        :paramtype job_name: str
        :keyword trigger: Job trigger.
        :paramtype trigger: str
        """
        super().__init__(kind=kind, **kwargs)
        self.web_job_id = web_job_id
        self.web_job_name = web_job_name
        self.status = status
        self.start_time = start_time
        self.end_time = end_time
        self.duration = duration
        self.output_url = output_url
        self.error_url = error_url
        self.url = url
        self.job_name = job_name
        self.trigger = trigger


class TriggeredWebJob(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Triggered Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar latest_run: Latest job run information.
    :vartype latest_run: ~azure.mgmt.web.v2018_02_01.models.TriggeredJobRun
    :ivar history_url: History URL.
    :vartype history_url: str
    :ivar scheduler_logs_url: Scheduler Logs URL.
    :vartype scheduler_logs_url: str
    :ivar run_command: Run command.
    :vartype run_command: str
    :ivar url: Job URL.
    :vartype url: str
    :ivar extra_info_url: Extra Info URL.
    :vartype extra_info_url: str
    :ivar web_job_type: Job type. Known values are: "Continuous" and "Triggered".
    :vartype web_job_type: str or ~azure.mgmt.web.v2018_02_01.models.WebJobType
    :ivar error: Error information.
    :vartype error: str
    :ivar using_sdk: Using SDK?.
    :vartype using_sdk: bool
    :ivar settings: Job settings.
    :vartype settings: dict[str, JSON]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "latest_run": {"key": "properties.latest_run", "type": "TriggeredJobRun"},
        "history_url": {"key": "properties.history_url", "type": "str"},
        "scheduler_logs_url": {"key": "properties.scheduler_logs_url", "type": "str"},
        "run_command": {"key": "properties.run_command", "type": "str"},
        "url": {"key": "properties.url", "type": "str"},
        "extra_info_url": {"key": "properties.extra_info_url", "type": "str"},
        "web_job_type": {"key": "properties.web_job_type", "type": "str"},
        "error": {"key": "properties.error", "type": "str"},
        "using_sdk": {"key": "properties.using_sdk", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        latest_run: Optional["_models.TriggeredJobRun"] = None,
        history_url: Optional[str] = None,
        scheduler_logs_url: Optional[str] = None,
        run_command: Optional[str] = None,
        url: Optional[str] = None,
        extra_info_url: Optional[str] = None,
        web_job_type: Optional[Union[str, "_models.WebJobType"]] = None,
        error: Optional[str] = None,
        using_sdk: Optional[bool] = None,
        settings: Optional[Dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword latest_run: Latest job run information.
        :paramtype latest_run: ~azure.mgmt.web.v2018_02_01.models.TriggeredJobRun
        :keyword history_url: History URL.
        :paramtype history_url: str
        :keyword scheduler_logs_url: Scheduler Logs URL.
        :paramtype scheduler_logs_url: str
        :keyword run_command: Run command.
        :paramtype run_command: str
        :keyword url: Job URL.
        :paramtype url: str
        :keyword extra_info_url: Extra Info URL.
        :paramtype extra_info_url: str
        :keyword web_job_type: Job type. Known values are: "Continuous" and "Triggered".
        :paramtype web_job_type: str or ~azure.mgmt.web.v2018_02_01.models.WebJobType
        :keyword error: Error information.
        :paramtype error: str
        :keyword using_sdk: Using SDK?.
        :paramtype using_sdk: bool
        :keyword settings: Job settings.
        :paramtype settings: dict[str, JSON]
        """
        super().__init__(kind=kind, **kwargs)
        self.latest_run = latest_run
        self.history_url = history_url
        self.scheduler_logs_url = scheduler_logs_url
        self.run_command = run_command
        self.url = url
        self.extra_info_url = extra_info_url
        self.web_job_type = web_job_type
        self.error = error
        self.using_sdk = using_sdk
        self.settings = settings


class TriggeredWebJobCollection(_serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.TriggeredWebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TriggeredWebJob]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.TriggeredWebJob"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.TriggeredWebJob]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Usage(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Usage of the quota resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Friendly name shown in the UI.
    :vartype display_name: str
    :ivar resource_name: Name of the quota resource.
    :vartype resource_name: str
    :ivar unit: Units of measurement for the quota resource.
    :vartype unit: str
    :ivar current_value: The current value of the resource counter.
    :vartype current_value: int
    :ivar limit: The resource limit.
    :vartype limit: int
    :ivar next_reset_time: Next reset time for the resource counter.
    :vartype next_reset_time: ~datetime.datetime
    :ivar compute_mode: Compute mode used for this usage. Known values are: "Shared", "Dedicated",
     and "Dynamic".
    :vartype compute_mode: str or ~azure.mgmt.web.v2018_02_01.models.ComputeModeOptions
    :ivar site_mode: Site mode used for this usage.
    :vartype site_mode: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "resource_name": {"readonly": True},
        "unit": {"readonly": True},
        "current_value": {"readonly": True},
        "limit": {"readonly": True},
        "next_reset_time": {"readonly": True},
        "compute_mode": {"readonly": True},
        "site_mode": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "resource_name": {"key": "properties.resourceName", "type": "str"},
        "unit": {"key": "properties.unit", "type": "str"},
        "current_value": {"key": "properties.currentValue", "type": "int"},
        "limit": {"key": "properties.limit", "type": "int"},
        "next_reset_time": {"key": "properties.nextResetTime", "type": "iso-8601"},
        "compute_mode": {"key": "properties.computeMode", "type": "str"},
        "site_mode": {"key": "properties.siteMode", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.display_name = None
        self.resource_name = None
        self.unit = None
        self.current_value = None
        self.limit = None
        self.next_reset_time = None
        self.compute_mode = None
        self.site_mode = None


class UsageCollection(_serialization.Model):
    """Collection of usages.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.Usage]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Usage"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.Usage]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class User(ProxyOnlyResource):
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar publishing_user_name: Username used for publishing.
    :vartype publishing_user_name: str
    :ivar publishing_password: Password used for publishing.
    :vartype publishing_password: str
    :ivar publishing_password_hash: Password hash used for publishing.
    :vartype publishing_password_hash: str
    :ivar publishing_password_hash_salt: Password hash salt used for publishing.
    :vartype publishing_password_hash_salt: str
    :ivar scm_uri: Url of SCM site.
    :vartype scm_uri: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "publishing_user_name": {"key": "properties.publishingUserName", "type": "str"},
        "publishing_password": {"key": "properties.publishingPassword", "type": "str"},
        "publishing_password_hash": {"key": "properties.publishingPasswordHash", "type": "str"},
        "publishing_password_hash_salt": {"key": "properties.publishingPasswordHashSalt", "type": "str"},
        "scm_uri": {"key": "properties.scmUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        publishing_user_name: Optional[str] = None,
        publishing_password: Optional[str] = None,
        publishing_password_hash: Optional[str] = None,
        publishing_password_hash_salt: Optional[str] = None,
        scm_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword publishing_user_name: Username used for publishing.
        :paramtype publishing_user_name: str
        :keyword publishing_password: Password used for publishing.
        :paramtype publishing_password: str
        :keyword publishing_password_hash: Password hash used for publishing.
        :paramtype publishing_password_hash: str
        :keyword publishing_password_hash_salt: Password hash salt used for publishing.
        :paramtype publishing_password_hash_salt: str
        :keyword scm_uri: Url of SCM site.
        :paramtype scm_uri: str
        """
        super().__init__(kind=kind, **kwargs)
        self.publishing_user_name = publishing_user_name
        self.publishing_password = publishing_password
        self.publishing_password_hash = publishing_password_hash
        self.publishing_password_hash_salt = publishing_password_hash_salt
        self.scm_uri = scm_uri


class ValidateContainerSettingsRequest(_serialization.Model):
    """Container settings validation request context.

    :ivar base_url: Base URL of the container registry.
    :vartype base_url: str
    :ivar username: Username for to access the container registry.
    :vartype username: str
    :ivar password: Password for to access the container registry.
    :vartype password: str
    :ivar repository: Repository name (image name).
    :vartype repository: str
    :ivar tag: Image tag.
    :vartype tag: str
    :ivar platform: Platform (windows or linux).
    :vartype platform: str
    """

    _attribute_map = {
        "base_url": {"key": "baseUrl", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "repository": {"key": "repository", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
        "platform": {"key": "platform", "type": "str"},
    }

    def __init__(
        self,
        *,
        base_url: Optional[str] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        repository: Optional[str] = None,
        tag: Optional[str] = None,
        platform: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword base_url: Base URL of the container registry.
        :paramtype base_url: str
        :keyword username: Username for to access the container registry.
        :paramtype username: str
        :keyword password: Password for to access the container registry.
        :paramtype password: str
        :keyword repository: Repository name (image name).
        :paramtype repository: str
        :keyword tag: Image tag.
        :paramtype tag: str
        :keyword platform: Platform (windows or linux).
        :paramtype platform: str
        """
        super().__init__(**kwargs)
        self.base_url = base_url
        self.username = username
        self.password = password
        self.repository = repository
        self.tag = tag
        self.platform = platform


class ValidateRequest(_serialization.Model):
    """Resource validation request content.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Resource name to verify. Required.
    :vartype name: str
    :ivar type: Resource type used for verification. Required. Known values are: "ServerFarm" and
     "Site".
    :vartype type: str or ~azure.mgmt.web.v2018_02_01.models.ValidateResourceTypes
    :ivar location: Expected location of the resource. Required.
    :vartype location: str
    :ivar server_farm_id: ARM resource ID of an App Service plan that would host the app.
    :vartype server_farm_id: str
    :ivar sku_name: Name of the target SKU for the App Service plan.
    :vartype sku_name: str
    :ivar need_linux_workers: :code:`<code>true</code>` if App Service plan is for Linux workers;
     otherwise, :code:`<code>false</code>`.
    :vartype need_linux_workers: bool
    :ivar is_spot: :code:`<code>true</code>` if App Service plan is for Spot instances; otherwise,
     :code:`<code>false</code>`.
    :vartype is_spot: bool
    :ivar capacity: Target capacity of the App Service plan (number of VMs).
    :vartype capacity: int
    :ivar hosting_environment: Name of App Service Environment where app or App Service plan should
     be created.
    :vartype hosting_environment: str
    :ivar is_xenon: :code:`<code>true</code>` if App Service plan is running as a windows
     container.
    :vartype is_xenon: bool
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
        "location": {"required": True},
        "capacity": {"minimum": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
        "sku_name": {"key": "properties.skuName", "type": "str"},
        "need_linux_workers": {"key": "properties.needLinuxWorkers", "type": "bool"},
        "is_spot": {"key": "properties.isSpot", "type": "bool"},
        "capacity": {"key": "properties.capacity", "type": "int"},
        "hosting_environment": {"key": "properties.hostingEnvironment", "type": "str"},
        "is_xenon": {"key": "properties.isXenon", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.ValidateResourceTypes"],
        location: str,
        server_farm_id: Optional[str] = None,
        sku_name: Optional[str] = None,
        need_linux_workers: Optional[bool] = None,
        is_spot: Optional[bool] = None,
        capacity: Optional[int] = None,
        hosting_environment: Optional[str] = None,
        is_xenon: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Resource name to verify. Required.
        :paramtype name: str
        :keyword type: Resource type used for verification. Required. Known values are: "ServerFarm"
         and "Site".
        :paramtype type: str or ~azure.mgmt.web.v2018_02_01.models.ValidateResourceTypes
        :keyword location: Expected location of the resource. Required.
        :paramtype location: str
        :keyword server_farm_id: ARM resource ID of an App Service plan that would host the app.
        :paramtype server_farm_id: str
        :keyword sku_name: Name of the target SKU for the App Service plan.
        :paramtype sku_name: str
        :keyword need_linux_workers: :code:`<code>true</code>` if App Service plan is for Linux
         workers; otherwise, :code:`<code>false</code>`.
        :paramtype need_linux_workers: bool
        :keyword is_spot: :code:`<code>true</code>` if App Service plan is for Spot instances;
         otherwise, :code:`<code>false</code>`.
        :paramtype is_spot: bool
        :keyword capacity: Target capacity of the App Service plan (number of VMs).
        :paramtype capacity: int
        :keyword hosting_environment: Name of App Service Environment where app or App Service plan
         should be created.
        :paramtype hosting_environment: str
        :keyword is_xenon: :code:`<code>true</code>` if App Service plan is running as a windows
         container.
        :paramtype is_xenon: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.location = location
        self.server_farm_id = server_farm_id
        self.sku_name = sku_name
        self.need_linux_workers = need_linux_workers
        self.is_spot = is_spot
        self.capacity = capacity
        self.hosting_environment = hosting_environment
        self.is_xenon = is_xenon


class ValidateResponse(_serialization.Model):
    """Describes the result of resource validation.

    :ivar status: Result of validation.
    :vartype status: str
    :ivar error: Error details for the case when validation fails.
    :vartype error: ~azure.mgmt.web.v2018_02_01.models.ValidateResponseError
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ValidateResponseError"},
    }

    def __init__(
        self, *, status: Optional[str] = None, error: Optional["_models.ValidateResponseError"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword status: Result of validation.
        :paramtype status: str
        :keyword error: Error details for the case when validation fails.
        :paramtype error: ~azure.mgmt.web.v2018_02_01.models.ValidateResponseError
        """
        super().__init__(**kwargs)
        self.status = status
        self.error = error


class ValidateResponseError(_serialization.Model):
    """Error details for when validation fails.

    :ivar code: Validation error code.
    :vartype code: str
    :ivar message: Validation error message.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Validation error code.
        :paramtype code: str
        :keyword message: Validation error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class VirtualApplication(_serialization.Model):
    """Virtual application in an app.

    :ivar virtual_path: Virtual path.
    :vartype virtual_path: str
    :ivar physical_path: Physical path.
    :vartype physical_path: str
    :ivar preload_enabled: :code:`<code>true</code>` if preloading is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype preload_enabled: bool
    :ivar virtual_directories: Virtual directories for virtual application.
    :vartype virtual_directories: list[~azure.mgmt.web.v2018_02_01.models.VirtualDirectory]
    """

    _attribute_map = {
        "virtual_path": {"key": "virtualPath", "type": "str"},
        "physical_path": {"key": "physicalPath", "type": "str"},
        "preload_enabled": {"key": "preloadEnabled", "type": "bool"},
        "virtual_directories": {"key": "virtualDirectories", "type": "[VirtualDirectory]"},
    }

    def __init__(
        self,
        *,
        virtual_path: Optional[str] = None,
        physical_path: Optional[str] = None,
        preload_enabled: Optional[bool] = None,
        virtual_directories: Optional[List["_models.VirtualDirectory"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_path: Virtual path.
        :paramtype virtual_path: str
        :keyword physical_path: Physical path.
        :paramtype physical_path: str
        :keyword preload_enabled: :code:`<code>true</code>` if preloading is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype preload_enabled: bool
        :keyword virtual_directories: Virtual directories for virtual application.
        :paramtype virtual_directories: list[~azure.mgmt.web.v2018_02_01.models.VirtualDirectory]
        """
        super().__init__(**kwargs)
        self.virtual_path = virtual_path
        self.physical_path = physical_path
        self.preload_enabled = preload_enabled
        self.virtual_directories = virtual_directories


class VirtualDirectory(_serialization.Model):
    """Directory for virtual application.

    :ivar virtual_path: Path to virtual application.
    :vartype virtual_path: str
    :ivar physical_path: Physical path.
    :vartype physical_path: str
    """

    _attribute_map = {
        "virtual_path": {"key": "virtualPath", "type": "str"},
        "physical_path": {"key": "physicalPath", "type": "str"},
    }

    def __init__(
        self, *, virtual_path: Optional[str] = None, physical_path: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword virtual_path: Path to virtual application.
        :paramtype virtual_path: str
        :keyword physical_path: Physical path.
        :paramtype physical_path: str
        """
        super().__init__(**kwargs)
        self.virtual_path = virtual_path
        self.physical_path = physical_path


class VirtualIPMapping(_serialization.Model):
    """Virtual IP mapping.

    :ivar virtual_ip: Virtual IP address.
    :vartype virtual_ip: str
    :ivar internal_http_port: Internal HTTP port.
    :vartype internal_http_port: int
    :ivar internal_https_port: Internal HTTPS port.
    :vartype internal_https_port: int
    :ivar in_use: Is virtual IP mapping in use.
    :vartype in_use: bool
    """

    _attribute_map = {
        "virtual_ip": {"key": "virtualIP", "type": "str"},
        "internal_http_port": {"key": "internalHttpPort", "type": "int"},
        "internal_https_port": {"key": "internalHttpsPort", "type": "int"},
        "in_use": {"key": "inUse", "type": "bool"},
    }

    def __init__(
        self,
        *,
        virtual_ip: Optional[str] = None,
        internal_http_port: Optional[int] = None,
        internal_https_port: Optional[int] = None,
        in_use: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_ip: Virtual IP address.
        :paramtype virtual_ip: str
        :keyword internal_http_port: Internal HTTP port.
        :paramtype internal_http_port: int
        :keyword internal_https_port: Internal HTTPS port.
        :paramtype internal_https_port: int
        :keyword in_use: Is virtual IP mapping in use.
        :paramtype in_use: bool
        """
        super().__init__(**kwargs)
        self.virtual_ip = virtual_ip
        self.internal_http_port = internal_http_port
        self.internal_https_port = internal_https_port
        self.in_use = in_use


class VirtualNetworkProfile(_serialization.Model):
    """Specification for using a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource id of the Virtual Network.
    :vartype id: str
    :ivar name: Name of the Virtual Network (read-only).
    :vartype name: str
    :ivar type: Resource type of the Virtual Network (read-only).
    :vartype type: str
    :ivar subnet: Subnet within the Virtual Network.
    :vartype subnet: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "subnet": {"key": "subnet", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        subnet: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource id of the Virtual Network.
        :paramtype id: str
        :keyword subnet: Subnet within the Virtual Network.
        :paramtype subnet: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None
        self.subnet = subnet


class VnetGateway(ProxyOnlyResource):
    """The Virtual Network gateway contract. This is used to give the Virtual Network gateway access
    to the VPN package.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vnet_name: The Virtual Network name.
    :vartype vnet_name: str
    :ivar vpn_package_uri: The URI where the VPN package can be downloaded.
    :vartype vpn_package_uri: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "vnet_name": {"key": "properties.vnetName", "type": "str"},
        "vpn_package_uri": {"key": "properties.vpnPackageUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vpn_package_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword vnet_name: The Virtual Network name.
        :paramtype vnet_name: str
        :keyword vpn_package_uri: The URI where the VPN package can be downloaded.
        :paramtype vpn_package_uri: str
        """
        super().__init__(kind=kind, **kwargs)
        self.vnet_name = vnet_name
        self.vpn_package_uri = vpn_package_uri


class VnetInfo(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Virtual Network information contract.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vnet_resource_id: The Virtual Network's resource ID.
    :vartype vnet_resource_id: str
    :ivar cert_thumbprint: The client certificate thumbprint.
    :vartype cert_thumbprint: str
    :ivar cert_blob: A certificate file (.cer) blob containing the public key of the private key
     used to authenticate a
     Point-To-Site VPN connection.
    :vartype cert_blob: str
    :ivar routes: The routes that this Virtual Network connection uses.
    :vartype routes: list[~azure.mgmt.web.v2018_02_01.models.VnetRoute]
    :ivar resync_required: :code:`<code>true</code>` if a resync is required; otherwise,
     :code:`<code>false</code>`.
    :vartype resync_required: bool
    :ivar dns_servers: DNS servers to be used by this Virtual Network. This should be a
     comma-separated list of IP addresses.
    :vartype dns_servers: str
    :ivar is_swift: Flag that is used to denote if this is VNET injection.
    :vartype is_swift: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "cert_thumbprint": {"readonly": True},
        "routes": {"readonly": True},
        "resync_required": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "vnet_resource_id": {"key": "properties.vnetResourceId", "type": "str"},
        "cert_thumbprint": {"key": "properties.certThumbprint", "type": "str"},
        "cert_blob": {"key": "properties.certBlob", "type": "str"},
        "routes": {"key": "properties.routes", "type": "[VnetRoute]"},
        "resync_required": {"key": "properties.resyncRequired", "type": "bool"},
        "dns_servers": {"key": "properties.dnsServers", "type": "str"},
        "is_swift": {"key": "properties.isSwift", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_resource_id: Optional[str] = None,
        cert_blob: Optional[str] = None,
        dns_servers: Optional[str] = None,
        is_swift: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword vnet_resource_id: The Virtual Network's resource ID.
        :paramtype vnet_resource_id: str
        :keyword cert_blob: A certificate file (.cer) blob containing the public key of the private key
         used to authenticate a
         Point-To-Site VPN connection.
        :paramtype cert_blob: str
        :keyword dns_servers: DNS servers to be used by this Virtual Network. This should be a
         comma-separated list of IP addresses.
        :paramtype dns_servers: str
        :keyword is_swift: Flag that is used to denote if this is VNET injection.
        :paramtype is_swift: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.vnet_resource_id = vnet_resource_id
        self.cert_thumbprint = None
        self.cert_blob = cert_blob
        self.routes = None
        self.resync_required = None
        self.dns_servers = dns_servers
        self.is_swift = is_swift


class VnetParameters(ProxyOnlyResource):
    """The required set of inputs to validate a VNET.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vnet_resource_group: The Resource Group of the VNET to be validated.
    :vartype vnet_resource_group: str
    :ivar vnet_name: The name of the VNET to be validated.
    :vartype vnet_name: str
    :ivar vnet_subnet_name: The subnet name to be validated.
    :vartype vnet_subnet_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "vnet_resource_group": {"key": "properties.vnetResourceGroup", "type": "str"},
        "vnet_name": {"key": "properties.vnetName", "type": "str"},
        "vnet_subnet_name": {"key": "properties.vnetSubnetName", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_resource_group: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vnet_subnet_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword vnet_resource_group: The Resource Group of the VNET to be validated.
        :paramtype vnet_resource_group: str
        :keyword vnet_name: The name of the VNET to be validated.
        :paramtype vnet_name: str
        :keyword vnet_subnet_name: The subnet name to be validated.
        :paramtype vnet_subnet_name: str
        """
        super().__init__(kind=kind, **kwargs)
        self.vnet_resource_group = vnet_resource_group
        self.vnet_name = vnet_name
        self.vnet_subnet_name = vnet_subnet_name


class VnetRoute(ProxyOnlyResource):
    """Virtual Network route contract used to pass routing information for a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar start_address: The starting address for this route. This may also include a CIDR
     notation, in which case the end address must not be specified.
    :vartype start_address: str
    :ivar end_address: The ending address for this route. If the start address is specified in CIDR
     notation, this must be omitted.
    :vartype end_address: str
    :ivar route_type: The type of route this is:
     DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
     INHERITED - Routes inherited from the real Virtual Network routes
     STATIC - Static route set on the app only

     These values will be used for syncing an app's routes with those from a Virtual Network. Known
     values are: "DEFAULT", "INHERITED", and "STATIC".
    :vartype route_type: str or ~azure.mgmt.web.v2018_02_01.models.RouteType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "start_address": {"key": "properties.startAddress", "type": "str"},
        "end_address": {"key": "properties.endAddress", "type": "str"},
        "route_type": {"key": "properties.routeType", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        start_address: Optional[str] = None,
        end_address: Optional[str] = None,
        route_type: Optional[Union[str, "_models.RouteType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword start_address: The starting address for this route. This may also include a CIDR
         notation, in which case the end address must not be specified.
        :paramtype start_address: str
        :keyword end_address: The ending address for this route. If the start address is specified in
         CIDR notation, this must be omitted.
        :paramtype end_address: str
        :keyword route_type: The type of route this is:
         DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
         INHERITED - Routes inherited from the real Virtual Network routes
         STATIC - Static route set on the app only

         These values will be used for syncing an app's routes with those from a Virtual Network. Known
         values are: "DEFAULT", "INHERITED", and "STATIC".
        :paramtype route_type: str or ~azure.mgmt.web.v2018_02_01.models.RouteType
        """
        super().__init__(kind=kind, **kwargs)
        self.start_address = start_address
        self.end_address = end_address
        self.route_type = route_type


class VnetValidationFailureDetails(ProxyOnlyResource):
    """A class that describes the reason for a validation failure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar failed: A flag describing whether or not validation failed.
    :vartype failed: bool
    :ivar failed_tests: A list of tests that failed in the validation.
    :vartype failed_tests: list[~azure.mgmt.web.v2018_02_01.models.VnetValidationTestFailure]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "failed": {"key": "properties.failed", "type": "bool"},
        "failed_tests": {"key": "properties.failedTests", "type": "[VnetValidationTestFailure]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        failed: Optional[bool] = None,
        failed_tests: Optional[List["_models.VnetValidationTestFailure"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword failed: A flag describing whether or not validation failed.
        :paramtype failed: bool
        :keyword failed_tests: A list of tests that failed in the validation.
        :paramtype failed_tests: list[~azure.mgmt.web.v2018_02_01.models.VnetValidationTestFailure]
        """
        super().__init__(kind=kind, **kwargs)
        self.failed = failed
        self.failed_tests = failed_tests


class VnetValidationTestFailure(ProxyOnlyResource):
    """A class that describes a test that failed during NSG and UDR validation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar test_name: The name of the test that failed.
    :vartype test_name: str
    :ivar details: The details of what caused the failure, e.g. the blocking rule name, etc.
    :vartype details: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "test_name": {"key": "properties.testName", "type": "str"},
        "details": {"key": "properties.details", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        test_name: Optional[str] = None,
        details: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword test_name: The name of the test that failed.
        :paramtype test_name: str
        :keyword details: The details of what caused the failure, e.g. the blocking rule name, etc.
        :paramtype details: str
        """
        super().__init__(kind=kind, **kwargs)
        self.test_name = test_name
        self.details = details


class WebAppCollection(_serialization.Model):
    """Collection of App Service apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.Site]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Site]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Site"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.Site]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class WebAppInstanceCollection(_serialization.Model):
    """Collection of app instances.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.SiteInstance]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SiteInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SiteInstance"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.SiteInstance]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class WebJob(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar run_command: Run command.
    :vartype run_command: str
    :ivar url: Job URL.
    :vartype url: str
    :ivar extra_info_url: Extra Info URL.
    :vartype extra_info_url: str
    :ivar web_job_type: Job type. Known values are: "Continuous" and "Triggered".
    :vartype web_job_type: str or ~azure.mgmt.web.v2018_02_01.models.WebJobType
    :ivar error: Error information.
    :vartype error: str
    :ivar using_sdk: Using SDK?.
    :vartype using_sdk: bool
    :ivar settings: Job settings.
    :vartype settings: dict[str, JSON]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "run_command": {"key": "properties.run_command", "type": "str"},
        "url": {"key": "properties.url", "type": "str"},
        "extra_info_url": {"key": "properties.extra_info_url", "type": "str"},
        "web_job_type": {"key": "properties.web_job_type", "type": "str"},
        "error": {"key": "properties.error", "type": "str"},
        "using_sdk": {"key": "properties.using_sdk", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        run_command: Optional[str] = None,
        url: Optional[str] = None,
        extra_info_url: Optional[str] = None,
        web_job_type: Optional[Union[str, "_models.WebJobType"]] = None,
        error: Optional[str] = None,
        using_sdk: Optional[bool] = None,
        settings: Optional[Dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword run_command: Run command.
        :paramtype run_command: str
        :keyword url: Job URL.
        :paramtype url: str
        :keyword extra_info_url: Extra Info URL.
        :paramtype extra_info_url: str
        :keyword web_job_type: Job type. Known values are: "Continuous" and "Triggered".
        :paramtype web_job_type: str or ~azure.mgmt.web.v2018_02_01.models.WebJobType
        :keyword error: Error information.
        :paramtype error: str
        :keyword using_sdk: Using SDK?.
        :paramtype using_sdk: bool
        :keyword settings: Job settings.
        :paramtype settings: dict[str, JSON]
        """
        super().__init__(kind=kind, **kwargs)
        self.run_command = run_command
        self.url = url
        self.extra_info_url = extra_info_url
        self.web_job_type = web_job_type
        self.error = error
        self.using_sdk = using_sdk
        self.settings = settings


class WebJobCollection(_serialization.Model):
    """Collection of Kudu web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.WebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WebJob]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.WebJob"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.WebJob]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class WorkerPool(_serialization.Model):
    """Worker pool of an App Service Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar worker_size_id: Worker size ID for referencing this worker pool.
    :vartype worker_size_id: int
    :ivar compute_mode: Shared or dedicated app hosting. Known values are: "Shared", "Dedicated",
     and "Dynamic".
    :vartype compute_mode: str or ~azure.mgmt.web.v2018_02_01.models.ComputeModeOptions
    :ivar worker_size: VM size of the worker pool instances.
    :vartype worker_size: str
    :ivar worker_count: Number of instances in the worker pool.
    :vartype worker_count: int
    :ivar instance_names: Names of all instances in the worker pool (read only).
    :vartype instance_names: list[str]
    """

    _validation = {
        "instance_names": {"readonly": True},
    }

    _attribute_map = {
        "worker_size_id": {"key": "workerSizeId", "type": "int"},
        "compute_mode": {"key": "computeMode", "type": "str"},
        "worker_size": {"key": "workerSize", "type": "str"},
        "worker_count": {"key": "workerCount", "type": "int"},
        "instance_names": {"key": "instanceNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        worker_size_id: Optional[int] = None,
        compute_mode: Optional[Union[str, "_models.ComputeModeOptions"]] = None,
        worker_size: Optional[str] = None,
        worker_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword worker_size_id: Worker size ID for referencing this worker pool.
        :paramtype worker_size_id: int
        :keyword compute_mode: Shared or dedicated app hosting. Known values are: "Shared",
         "Dedicated", and "Dynamic".
        :paramtype compute_mode: str or ~azure.mgmt.web.v2018_02_01.models.ComputeModeOptions
        :keyword worker_size: VM size of the worker pool instances.
        :paramtype worker_size: str
        :keyword worker_count: Number of instances in the worker pool.
        :paramtype worker_count: int
        """
        super().__init__(**kwargs)
        self.worker_size_id = worker_size_id
        self.compute_mode = compute_mode
        self.worker_size = worker_size
        self.worker_count = worker_count
        self.instance_names = None


class WorkerPoolCollection(_serialization.Model):
    """Collection of worker pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2018_02_01.models.WorkerPoolResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkerPoolResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.WorkerPoolResource"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2018_02_01.models.WorkerPoolResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class WorkerPoolResource(ProxyOnlyResource):
    """Worker pool of an App Service Environment ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar sku: Description of a SKU for a scalable resource.
    :vartype sku: ~azure.mgmt.web.v2018_02_01.models.SkuDescription
    :ivar worker_size_id: Worker size ID for referencing this worker pool.
    :vartype worker_size_id: int
    :ivar compute_mode: Shared or dedicated app hosting. Known values are: "Shared", "Dedicated",
     and "Dynamic".
    :vartype compute_mode: str or ~azure.mgmt.web.v2018_02_01.models.ComputeModeOptions
    :ivar worker_size: VM size of the worker pool instances.
    :vartype worker_size: str
    :ivar worker_count: Number of instances in the worker pool.
    :vartype worker_count: int
    :ivar instance_names: Names of all instances in the worker pool (read only).
    :vartype instance_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "instance_names": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku": {"key": "sku", "type": "SkuDescription"},
        "worker_size_id": {"key": "properties.workerSizeId", "type": "int"},
        "compute_mode": {"key": "properties.computeMode", "type": "str"},
        "worker_size": {"key": "properties.workerSize", "type": "str"},
        "worker_count": {"key": "properties.workerCount", "type": "int"},
        "instance_names": {"key": "properties.instanceNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        sku: Optional["_models.SkuDescription"] = None,
        worker_size_id: Optional[int] = None,
        compute_mode: Optional[Union[str, "_models.ComputeModeOptions"]] = None,
        worker_size: Optional[str] = None,
        worker_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword sku: Description of a SKU for a scalable resource.
        :paramtype sku: ~azure.mgmt.web.v2018_02_01.models.SkuDescription
        :keyword worker_size_id: Worker size ID for referencing this worker pool.
        :paramtype worker_size_id: int
        :keyword compute_mode: Shared or dedicated app hosting. Known values are: "Shared",
         "Dedicated", and "Dynamic".
        :paramtype compute_mode: str or ~azure.mgmt.web.v2018_02_01.models.ComputeModeOptions
        :keyword worker_size: VM size of the worker pool instances.
        :paramtype worker_size: str
        :keyword worker_count: Number of instances in the worker pool.
        :paramtype worker_count: int
        """
        super().__init__(kind=kind, **kwargs)
        self.sku = sku
        self.worker_size_id = worker_size_id
        self.compute_mode = compute_mode
        self.worker_size = worker_size
        self.worker_count = worker_count
        self.instance_names = None
