# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.sphere.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.sphere.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Catalog(TrackedResource):
    """An Azure Sphere catalog.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.sphere.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.sphere.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None


class CatalogListResult(_serialization.Model):
    """The response of a Catalog list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The Catalog items on this page. Required.
    :vartype value: list[~azure.mgmt.sphere.models.Catalog]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Catalog]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Catalog"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Catalog items on this page. Required.
        :paramtype value: list[~azure.mgmt.sphere.models.Catalog]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CatalogUpdate(_serialization.Model):
    """The type used for update operations of the Catalog.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.sphere.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class Certificate(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """An certificate resource belonging to a catalog resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.sphere.models.SystemData
    :ivar certificate: The certificate as a UTF-8 encoded base 64 string.
    :vartype certificate: str
    :ivar status: The certificate status. Known values are: "Active", "Inactive", "Expired", and
     "Revoked".
    :vartype status: str or ~azure.mgmt.sphere.models.CertificateStatus
    :ivar subject: The certificate subject.
    :vartype subject: str
    :ivar thumbprint: The certificate thumbprint.
    :vartype thumbprint: str
    :ivar expiry_utc: The certificate expiry date.
    :vartype expiry_utc: ~datetime.datetime
    :ivar not_before_utc: The certificate not before date.
    :vartype not_before_utc: ~datetime.datetime
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.sphere.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "certificate": {"readonly": True},
        "status": {"readonly": True},
        "subject": {"readonly": True},
        "thumbprint": {"readonly": True},
        "expiry_utc": {"readonly": True},
        "not_before_utc": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "certificate": {"key": "properties.certificate", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "subject": {"key": "properties.subject", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "expiry_utc": {"key": "properties.expiryUtc", "type": "iso-8601"},
        "not_before_utc": {"key": "properties.notBeforeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.certificate = None
        self.status = None
        self.subject = None
        self.thumbprint = None
        self.expiry_utc = None
        self.not_before_utc = None
        self.provisioning_state = None


class CertificateChainResponse(_serialization.Model):
    """The certificate chain response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar certificate_chain: The certificate chain.
    :vartype certificate_chain: str
    """

    _validation = {
        "certificate_chain": {"readonly": True},
    }

    _attribute_map = {
        "certificate_chain": {"key": "certificateChain", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.certificate_chain = None


class CertificateListResult(_serialization.Model):
    """The response of a Certificate list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The Certificate items on this page. Required.
    :vartype value: list[~azure.mgmt.sphere.models.Certificate]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Certificate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Certificate"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Certificate items on this page. Required.
        :paramtype value: list[~azure.mgmt.sphere.models.Certificate]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CertificateProperties(_serialization.Model):
    """The properties of certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar certificate: The certificate as a UTF-8 encoded base 64 string.
    :vartype certificate: str
    :ivar status: The certificate status. Known values are: "Active", "Inactive", "Expired", and
     "Revoked".
    :vartype status: str or ~azure.mgmt.sphere.models.CertificateStatus
    :ivar subject: The certificate subject.
    :vartype subject: str
    :ivar thumbprint: The certificate thumbprint.
    :vartype thumbprint: str
    :ivar expiry_utc: The certificate expiry date.
    :vartype expiry_utc: ~datetime.datetime
    :ivar not_before_utc: The certificate not before date.
    :vartype not_before_utc: ~datetime.datetime
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.sphere.models.ProvisioningState
    """

    _validation = {
        "certificate": {"readonly": True},
        "status": {"readonly": True},
        "subject": {"readonly": True},
        "thumbprint": {"readonly": True},
        "expiry_utc": {"readonly": True},
        "not_before_utc": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "certificate": {"key": "certificate", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "expiry_utc": {"key": "expiryUtc", "type": "iso-8601"},
        "not_before_utc": {"key": "notBeforeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.certificate = None
        self.status = None
        self.subject = None
        self.thumbprint = None
        self.expiry_utc = None
        self.not_before_utc = None
        self.provisioning_state = None


class ClaimDevicesRequest(_serialization.Model):
    """Request to the action call to bulk claim devices.

    All required parameters must be populated in order to send to Azure.

    :ivar device_identifiers: Device identifiers of the devices to be claimed. Required.
    :vartype device_identifiers: list[str]
    """

    _validation = {
        "device_identifiers": {"required": True},
    }

    _attribute_map = {
        "device_identifiers": {"key": "deviceIdentifiers", "type": "[str]"},
    }

    def __init__(self, *, device_identifiers: List[str], **kwargs: Any) -> None:
        """
        :keyword device_identifiers: Device identifiers of the devices to be claimed. Required.
        :paramtype device_identifiers: list[str]
        """
        super().__init__(**kwargs)
        self.device_identifiers = device_identifiers


class CountElementsResponse(_serialization.Model):
    """Response of the count for elements.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Number of children resources in parent resource. Required.
    :vartype value: int
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "int"},
    }

    def __init__(self, *, value: int, **kwargs: Any) -> None:
        """
        :keyword value: Number of children resources in parent resource. Required.
        :paramtype value: int
        """
        super().__init__(**kwargs)
        self.value = value


class CountDeviceResponse(CountElementsResponse):
    """Response to the action call for count devices in a catalog.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Number of children resources in parent resource. Required.
    :vartype value: int
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "int"},
    }

    def __init__(self, *, value: int, **kwargs: Any) -> None:
        """
        :keyword value: Number of children resources in parent resource. Required.
        :paramtype value: int
        """
        super().__init__(value=value, **kwargs)


class Deployment(ProxyResource):
    """An deployment resource belonging to a device group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.sphere.models.SystemData
    :ivar deployment_id: Deployment ID.
    :vartype deployment_id: str
    :ivar deployed_images: Images deployed.
    :vartype deployed_images: list[~azure.mgmt.sphere.models.Image]
    :ivar deployment_date_utc: Deployment date UTC.
    :vartype deployment_date_utc: ~datetime.datetime
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.sphere.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "deployment_date_utc": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "deployment_id": {"key": "properties.deploymentId", "type": "str"},
        "deployed_images": {"key": "properties.deployedImages", "type": "[Image]"},
        "deployment_date_utc": {"key": "properties.deploymentDateUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        deployment_id: Optional[str] = None,
        deployed_images: Optional[List["_models.Image"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword deployment_id: Deployment ID.
        :paramtype deployment_id: str
        :keyword deployed_images: Images deployed.
        :paramtype deployed_images: list[~azure.mgmt.sphere.models.Image]
        """
        super().__init__(**kwargs)
        self.deployment_id = deployment_id
        self.deployed_images = deployed_images
        self.deployment_date_utc = None
        self.provisioning_state = None


class DeploymentListResult(_serialization.Model):
    """The response of a Deployment list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The Deployment items on this page. Required.
    :vartype value: list[~azure.mgmt.sphere.models.Deployment]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Deployment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Deployment"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Deployment items on this page. Required.
        :paramtype value: list[~azure.mgmt.sphere.models.Deployment]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Device(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """An device resource belonging to a device group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.sphere.models.SystemData
    :ivar device_id: Device ID.
    :vartype device_id: str
    :ivar chip_sku: SKU of the chip.
    :vartype chip_sku: str
    :ivar last_available_os_version: OS version available for installation when update requested.
    :vartype last_available_os_version: str
    :ivar last_installed_os_version: OS version running on device when update requested.
    :vartype last_installed_os_version: str
    :ivar last_os_update_utc: Time when update requested and new OS version available.
    :vartype last_os_update_utc: ~datetime.datetime
    :ivar last_update_request_utc: Time when update was last requested.
    :vartype last_update_request_utc: ~datetime.datetime
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.sphere.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "chip_sku": {"readonly": True},
        "last_available_os_version": {"readonly": True},
        "last_installed_os_version": {"readonly": True},
        "last_os_update_utc": {"readonly": True},
        "last_update_request_utc": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "device_id": {"key": "properties.deviceId", "type": "str"},
        "chip_sku": {"key": "properties.chipSku", "type": "str"},
        "last_available_os_version": {"key": "properties.lastAvailableOsVersion", "type": "str"},
        "last_installed_os_version": {"key": "properties.lastInstalledOsVersion", "type": "str"},
        "last_os_update_utc": {"key": "properties.lastOsUpdateUtc", "type": "iso-8601"},
        "last_update_request_utc": {"key": "properties.lastUpdateRequestUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, device_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword device_id: Device ID.
        :paramtype device_id: str
        """
        super().__init__(**kwargs)
        self.device_id = device_id
        self.chip_sku = None
        self.last_available_os_version = None
        self.last_installed_os_version = None
        self.last_os_update_utc = None
        self.last_update_request_utc = None
        self.provisioning_state = None


class DeviceGroup(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """An device group resource belonging to a product resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.sphere.models.SystemData
    :ivar description: Description of the device group.
    :vartype description: str
    :ivar os_feed_type: Operating system feed type of the device group. Known values are: "Retail"
     and "RetailEval".
    :vartype os_feed_type: str or ~azure.mgmt.sphere.models.OSFeedType
    :ivar update_policy: Update policy of the device group. Known values are: "UpdateAll" and
     "No3rdPartyAppUpdates".
    :vartype update_policy: str or ~azure.mgmt.sphere.models.UpdatePolicy
    :ivar allow_crash_dumps_collection: Flag to define if the user allows for crash dump
     collection. Known values are: "Enabled" and "Disabled".
    :vartype allow_crash_dumps_collection: str or
     ~azure.mgmt.sphere.models.AllowCrashDumpCollection
    :ivar regional_data_boundary: Regional data boundary for the device group. Known values are:
     "None" and "EU".
    :vartype regional_data_boundary: str or ~azure.mgmt.sphere.models.RegionalDataBoundary
    :ivar has_deployment: Deployment status for the device group.
    :vartype has_deployment: bool
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.sphere.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "has_deployment": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "os_feed_type": {"key": "properties.osFeedType", "type": "str"},
        "update_policy": {"key": "properties.updatePolicy", "type": "str"},
        "allow_crash_dumps_collection": {"key": "properties.allowCrashDumpsCollection", "type": "str"},
        "regional_data_boundary": {"key": "properties.regionalDataBoundary", "type": "str"},
        "has_deployment": {"key": "properties.hasDeployment", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        os_feed_type: Optional[Union[str, "_models.OSFeedType"]] = None,
        update_policy: Optional[Union[str, "_models.UpdatePolicy"]] = None,
        allow_crash_dumps_collection: Optional[Union[str, "_models.AllowCrashDumpCollection"]] = None,
        regional_data_boundary: Optional[Union[str, "_models.RegionalDataBoundary"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description of the device group.
        :paramtype description: str
        :keyword os_feed_type: Operating system feed type of the device group. Known values are:
         "Retail" and "RetailEval".
        :paramtype os_feed_type: str or ~azure.mgmt.sphere.models.OSFeedType
        :keyword update_policy: Update policy of the device group. Known values are: "UpdateAll" and
         "No3rdPartyAppUpdates".
        :paramtype update_policy: str or ~azure.mgmt.sphere.models.UpdatePolicy
        :keyword allow_crash_dumps_collection: Flag to define if the user allows for crash dump
         collection. Known values are: "Enabled" and "Disabled".
        :paramtype allow_crash_dumps_collection: str or
         ~azure.mgmt.sphere.models.AllowCrashDumpCollection
        :keyword regional_data_boundary: Regional data boundary for the device group. Known values are:
         "None" and "EU".
        :paramtype regional_data_boundary: str or ~azure.mgmt.sphere.models.RegionalDataBoundary
        """
        super().__init__(**kwargs)
        self.description = description
        self.os_feed_type = os_feed_type
        self.update_policy = update_policy
        self.allow_crash_dumps_collection = allow_crash_dumps_collection
        self.regional_data_boundary = regional_data_boundary
        self.has_deployment = None
        self.provisioning_state = None


class DeviceGroupListResult(_serialization.Model):
    """The response of a DeviceGroup list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The DeviceGroup items on this page. Required.
    :vartype value: list[~azure.mgmt.sphere.models.DeviceGroup]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeviceGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DeviceGroup"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The DeviceGroup items on this page. Required.
        :paramtype value: list[~azure.mgmt.sphere.models.DeviceGroup]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DeviceGroupUpdate(_serialization.Model):
    """The type used for update operations of the DeviceGroup.

    :ivar description: Description of the device group.
    :vartype description: str
    :ivar os_feed_type: Operating system feed type of the device group. Known values are: "Retail"
     and "RetailEval".
    :vartype os_feed_type: str or ~azure.mgmt.sphere.models.OSFeedType
    :ivar update_policy: Update policy of the device group. Known values are: "UpdateAll" and
     "No3rdPartyAppUpdates".
    :vartype update_policy: str or ~azure.mgmt.sphere.models.UpdatePolicy
    :ivar allow_crash_dumps_collection: Flag to define if the user allows for crash dump
     collection. Known values are: "Enabled" and "Disabled".
    :vartype allow_crash_dumps_collection: str or
     ~azure.mgmt.sphere.models.AllowCrashDumpCollection
    :ivar regional_data_boundary: Regional data boundary for the device group. Known values are:
     "None" and "EU".
    :vartype regional_data_boundary: str or ~azure.mgmt.sphere.models.RegionalDataBoundary
    """

    _attribute_map = {
        "description": {"key": "properties.description", "type": "str"},
        "os_feed_type": {"key": "properties.osFeedType", "type": "str"},
        "update_policy": {"key": "properties.updatePolicy", "type": "str"},
        "allow_crash_dumps_collection": {"key": "properties.allowCrashDumpsCollection", "type": "str"},
        "regional_data_boundary": {"key": "properties.regionalDataBoundary", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        os_feed_type: Optional[Union[str, "_models.OSFeedType"]] = None,
        update_policy: Optional[Union[str, "_models.UpdatePolicy"]] = None,
        allow_crash_dumps_collection: Optional[Union[str, "_models.AllowCrashDumpCollection"]] = None,
        regional_data_boundary: Optional[Union[str, "_models.RegionalDataBoundary"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description of the device group.
        :paramtype description: str
        :keyword os_feed_type: Operating system feed type of the device group. Known values are:
         "Retail" and "RetailEval".
        :paramtype os_feed_type: str or ~azure.mgmt.sphere.models.OSFeedType
        :keyword update_policy: Update policy of the device group. Known values are: "UpdateAll" and
         "No3rdPartyAppUpdates".
        :paramtype update_policy: str or ~azure.mgmt.sphere.models.UpdatePolicy
        :keyword allow_crash_dumps_collection: Flag to define if the user allows for crash dump
         collection. Known values are: "Enabled" and "Disabled".
        :paramtype allow_crash_dumps_collection: str or
         ~azure.mgmt.sphere.models.AllowCrashDumpCollection
        :keyword regional_data_boundary: Regional data boundary for the device group. Known values are:
         "None" and "EU".
        :paramtype regional_data_boundary: str or ~azure.mgmt.sphere.models.RegionalDataBoundary
        """
        super().__init__(**kwargs)
        self.description = description
        self.os_feed_type = os_feed_type
        self.update_policy = update_policy
        self.allow_crash_dumps_collection = allow_crash_dumps_collection
        self.regional_data_boundary = regional_data_boundary


class DeviceInsight(_serialization.Model):
    """Device insight report.

    All required parameters must be populated in order to send to Azure.

    :ivar device_id: Device ID. Required.
    :vartype device_id: str
    :ivar description: Event description. Required.
    :vartype description: str
    :ivar start_timestamp_utc: Event start timestamp. Required.
    :vartype start_timestamp_utc: ~datetime.datetime
    :ivar end_timestamp_utc: Event end timestamp. Required.
    :vartype end_timestamp_utc: ~datetime.datetime
    :ivar event_category: Event category. Required.
    :vartype event_category: str
    :ivar event_class: Event class. Required.
    :vartype event_class: str
    :ivar event_type: Event type. Required.
    :vartype event_type: str
    :ivar event_count: Event count. Required.
    :vartype event_count: int
    """

    _validation = {
        "device_id": {"required": True},
        "description": {"required": True},
        "start_timestamp_utc": {"required": True},
        "end_timestamp_utc": {"required": True},
        "event_category": {"required": True},
        "event_class": {"required": True},
        "event_type": {"required": True},
        "event_count": {"required": True},
    }

    _attribute_map = {
        "device_id": {"key": "deviceId", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "start_timestamp_utc": {"key": "startTimestampUtc", "type": "iso-8601"},
        "end_timestamp_utc": {"key": "endTimestampUtc", "type": "iso-8601"},
        "event_category": {"key": "eventCategory", "type": "str"},
        "event_class": {"key": "eventClass", "type": "str"},
        "event_type": {"key": "eventType", "type": "str"},
        "event_count": {"key": "eventCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        device_id: str,
        description: str,
        start_timestamp_utc: datetime.datetime,
        end_timestamp_utc: datetime.datetime,
        event_category: str,
        event_class: str,
        event_type: str,
        event_count: int,
        **kwargs: Any
    ) -> None:
        """
        :keyword device_id: Device ID. Required.
        :paramtype device_id: str
        :keyword description: Event description. Required.
        :paramtype description: str
        :keyword start_timestamp_utc: Event start timestamp. Required.
        :paramtype start_timestamp_utc: ~datetime.datetime
        :keyword end_timestamp_utc: Event end timestamp. Required.
        :paramtype end_timestamp_utc: ~datetime.datetime
        :keyword event_category: Event category. Required.
        :paramtype event_category: str
        :keyword event_class: Event class. Required.
        :paramtype event_class: str
        :keyword event_type: Event type. Required.
        :paramtype event_type: str
        :keyword event_count: Event count. Required.
        :paramtype event_count: int
        """
        super().__init__(**kwargs)
        self.device_id = device_id
        self.description = description
        self.start_timestamp_utc = start_timestamp_utc
        self.end_timestamp_utc = end_timestamp_utc
        self.event_category = event_category
        self.event_class = event_class
        self.event_type = event_type
        self.event_count = event_count


class DeviceListResult(_serialization.Model):
    """The response of a Device list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The Device items on this page. Required.
    :vartype value: list[~azure.mgmt.sphere.models.Device]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Device]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Device"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Device items on this page. Required.
        :paramtype value: list[~azure.mgmt.sphere.models.Device]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DevicePatchProperties(_serialization.Model):
    """The properties of device patch.

    All required parameters must be populated in order to send to Azure.

    :ivar device_group_id: Device group id. Required.
    :vartype device_group_id: str
    """

    _validation = {
        "device_group_id": {"required": True},
    }

    _attribute_map = {
        "device_group_id": {"key": "deviceGroupId", "type": "str"},
    }

    def __init__(self, *, device_group_id: str, **kwargs: Any) -> None:
        """
        :keyword device_group_id: Device group id. Required.
        :paramtype device_group_id: str
        """
        super().__init__(**kwargs)
        self.device_group_id = device_group_id


class DeviceUpdate(_serialization.Model):
    """The type used for update operations of the Device.

    :ivar device_group_id: Device group id.
    :vartype device_group_id: str
    """

    _attribute_map = {
        "device_group_id": {"key": "properties.deviceGroupId", "type": "str"},
    }

    def __init__(self, *, device_group_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword device_group_id: Device group id.
        :paramtype device_group_id: str
        """
        super().__init__(**kwargs)
        self.device_group_id = device_group_id


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.sphere.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.sphere.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.sphere.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.sphere.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class GenerateCapabilityImageRequest(_serialization.Model):
    """Request of the action to create a signed device capability image.

    All required parameters must be populated in order to send to Azure.

    :ivar capabilities: List of capabilities to create. Required.
    :vartype capabilities: list[str or ~azure.mgmt.sphere.models.CapabilityType]
    """

    _validation = {
        "capabilities": {"required": True},
    }

    _attribute_map = {
        "capabilities": {"key": "capabilities", "type": "[str]"},
    }

    def __init__(self, *, capabilities: List[Union[str, "_models.CapabilityType"]], **kwargs: Any) -> None:
        """
        :keyword capabilities: List of capabilities to create. Required.
        :paramtype capabilities: list[str or ~azure.mgmt.sphere.models.CapabilityType]
        """
        super().__init__(**kwargs)
        self.capabilities = capabilities


class Image(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """An image resource belonging to a catalog resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.sphere.models.SystemData
    :ivar image: Image as a UTF-8 encoded base 64 string on image create. This field contains the
     image URI on image reads.
    :vartype image: str
    :ivar image_id: Image ID.
    :vartype image_id: str
    :ivar image_name: Image name.
    :vartype image_name: str
    :ivar regional_data_boundary: Regional data boundary for an image. Known values are: "None" and
     "EU".
    :vartype regional_data_boundary: str or ~azure.mgmt.sphere.models.RegionalDataBoundary
    :ivar uri: Location the image.
    :vartype uri: str
    :ivar description: The image description.
    :vartype description: str
    :ivar component_id: The image component id.
    :vartype component_id: str
    :ivar image_type: The image type. Known values are: "InvalidImageType", "OneBl",
     "PlutonRuntime", "WifiFirmware", "SecurityMonitor", "NormalWorldLoader", "NormalWorldDtb",
     "NormalWorldKernel", "RootFs", "Services", "Applications", "FwConfig", "BootManifest", "Nwfs",
     "TrustedKeystore", "Policy", "CustomerBoardConfig", "UpdateCertStore",
     "BaseSystemUpdateManifest", "FirmwareUpdateManifest", "CustomerUpdateManifest",
     "RecoveryManifest", "ManifestSet", and "Other".
    :vartype image_type: str or ~azure.mgmt.sphere.models.ImageType
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.sphere.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "image_name": {"readonly": True},
        "uri": {"readonly": True},
        "description": {"readonly": True},
        "component_id": {"readonly": True},
        "image_type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "image": {"key": "properties.image", "type": "str"},
        "image_id": {"key": "properties.imageId", "type": "str"},
        "image_name": {"key": "properties.imageName", "type": "str"},
        "regional_data_boundary": {"key": "properties.regionalDataBoundary", "type": "str"},
        "uri": {"key": "properties.uri", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "component_id": {"key": "properties.componentId", "type": "str"},
        "image_type": {"key": "properties.imageType", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        image: Optional[str] = None,
        image_id: Optional[str] = None,
        regional_data_boundary: Optional[Union[str, "_models.RegionalDataBoundary"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image: Image as a UTF-8 encoded base 64 string on image create. This field contains
         the image URI on image reads.
        :paramtype image: str
        :keyword image_id: Image ID.
        :paramtype image_id: str
        :keyword regional_data_boundary: Regional data boundary for an image. Known values are: "None"
         and "EU".
        :paramtype regional_data_boundary: str or ~azure.mgmt.sphere.models.RegionalDataBoundary
        """
        super().__init__(**kwargs)
        self.image = image
        self.image_id = image_id
        self.image_name = None
        self.regional_data_boundary = regional_data_boundary
        self.uri = None
        self.description = None
        self.component_id = None
        self.image_type = None
        self.provisioning_state = None


class ImageListResult(_serialization.Model):
    """The response of a Image list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The Image items on this page. Required.
    :vartype value: list[~azure.mgmt.sphere.models.Image]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Image]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Image"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Image items on this page. Required.
        :paramtype value: list[~azure.mgmt.sphere.models.Image]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ImageUploadRequestBody(_serialization.Model):
    """Image upload request body.

    All required parameters must be populated in order to send to Azure.

    :ivar images: . Required.
    :vartype images: str
    """

    _validation = {
        "images": {"required": True},
    }

    _attribute_map = {
        "images": {"key": "images", "type": "str"},
    }

    def __init__(self, *, images: str, **kwargs: Any) -> None:
        """
        :keyword images: . Required.
        :paramtype images: str
        """
        super().__init__(**kwargs)
        self.images = images


class ListDeviceGroupsRequest(_serialization.Model):
    """Request of the action to list device groups for a catalog.

    :ivar device_group_name: Device Group name.
    :vartype device_group_name: str
    """

    _attribute_map = {
        "device_group_name": {"key": "deviceGroupName", "type": "str"},
    }

    def __init__(self, *, device_group_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword device_group_name: Device Group name.
        :paramtype device_group_name: str
        """
        super().__init__(**kwargs)
        self.device_group_name = device_group_name


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.sphere.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.sphere.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.sphere.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.sphere.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.sphere.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PagedDeviceInsight(_serialization.Model):
    """Paged collection of DeviceInsight items.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The DeviceInsight items on this page. Required.
    :vartype value: list[~azure.mgmt.sphere.models.DeviceInsight]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeviceInsight]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DeviceInsight"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The DeviceInsight items on this page. Required.
        :paramtype value: list[~azure.mgmt.sphere.models.DeviceInsight]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Product(ProxyResource):
    """An product resource belonging to a catalog resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.sphere.models.SystemData
    :ivar description: Description of the product.
    :vartype description: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.sphere.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: Description of the product.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.provisioning_state = None


class ProductListResult(_serialization.Model):
    """The response of a Product list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The Product items on this page. Required.
    :vartype value: list[~azure.mgmt.sphere.models.Product]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Product]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Product"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Product items on this page. Required.
        :paramtype value: list[~azure.mgmt.sphere.models.Product]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProductUpdate(_serialization.Model):
    """The type used for update operations of the Product.

    :ivar description: Description of the product.
    :vartype description: str
    """

    _attribute_map = {
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: Description of the product.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.description = description


class ProofOfPossessionNonceRequest(_serialization.Model):
    """Request for the proof of possession nonce.

    All required parameters must be populated in order to send to Azure.

    :ivar proof_of_possession_nonce: The proof of possession nonce. Required.
    :vartype proof_of_possession_nonce: str
    """

    _validation = {
        "proof_of_possession_nonce": {"required": True},
    }

    _attribute_map = {
        "proof_of_possession_nonce": {"key": "proofOfPossessionNonce", "type": "str"},
    }

    def __init__(self, *, proof_of_possession_nonce: str, **kwargs: Any) -> None:
        """
        :keyword proof_of_possession_nonce: The proof of possession nonce. Required.
        :paramtype proof_of_possession_nonce: str
        """
        super().__init__(**kwargs)
        self.proof_of_possession_nonce = proof_of_possession_nonce


class ProofOfPossessionNonceResponse(CertificateProperties):
    """Result of the action to generate a proof of possession nonce.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar certificate: The certificate as a UTF-8 encoded base 64 string.
    :vartype certificate: str
    :ivar status: The certificate status. Known values are: "Active", "Inactive", "Expired", and
     "Revoked".
    :vartype status: str or ~azure.mgmt.sphere.models.CertificateStatus
    :ivar subject: The certificate subject.
    :vartype subject: str
    :ivar thumbprint: The certificate thumbprint.
    :vartype thumbprint: str
    :ivar expiry_utc: The certificate expiry date.
    :vartype expiry_utc: ~datetime.datetime
    :ivar not_before_utc: The certificate not before date.
    :vartype not_before_utc: ~datetime.datetime
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.sphere.models.ProvisioningState
    """

    _validation = {
        "certificate": {"readonly": True},
        "status": {"readonly": True},
        "subject": {"readonly": True},
        "thumbprint": {"readonly": True},
        "expiry_utc": {"readonly": True},
        "not_before_utc": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "certificate": {"key": "certificate", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "expiry_utc": {"key": "expiryUtc", "type": "iso-8601"},
        "not_before_utc": {"key": "notBeforeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class SignedCapabilityImageResponse(_serialization.Model):
    """Signed device capability image response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar image: The signed device capability image as a UTF-8 encoded base 64 string.
    :vartype image: str
    """

    _validation = {
        "image": {"readonly": True},
    }

    _attribute_map = {
        "image": {"key": "image", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.image = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.sphere.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.sphere.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.sphere.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.sphere.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
