# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models as _models
from ._configuration import RecoveryServicesDataReplicationMgmtClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    DraOperationStatusOperations,
    DraOperations,
    EmailConfigurationOperations,
    EventOperations,
    FabricOperations,
    FabricOperationsStatusOperations,
    Operations,
    PolicyOperationStatusOperations,
    PolicyOperations,
    ProtectedItemOperationStatusOperations,
    ProtectedItemOperations,
    RecoveryPointsOperations,
    RecoveryServicesDataReplicationMgmtClientOperationsMixin,
    ReplicationExtensionOperationStatusOperations,
    ReplicationExtensionOperations,
    VaultOperationStatusOperations,
    VaultOperations,
    WorkflowOperationStatusOperations,
    WorkflowOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class RecoveryServicesDataReplicationMgmtClient(
    RecoveryServicesDataReplicationMgmtClientOperationsMixin
):  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """A first party Azure service enabling the data replication.

    :ivar dra: DraOperations operations
    :vartype dra: azure.mgmt.recoveryservicesdatareplication.operations.DraOperations
    :ivar dra_operation_status: DraOperationStatusOperations operations
    :vartype dra_operation_status:
     azure.mgmt.recoveryservicesdatareplication.operations.DraOperationStatusOperations
    :ivar email_configuration: EmailConfigurationOperations operations
    :vartype email_configuration:
     azure.mgmt.recoveryservicesdatareplication.operations.EmailConfigurationOperations
    :ivar event: EventOperations operations
    :vartype event: azure.mgmt.recoveryservicesdatareplication.operations.EventOperations
    :ivar fabric: FabricOperations operations
    :vartype fabric: azure.mgmt.recoveryservicesdatareplication.operations.FabricOperations
    :ivar fabric_operations_status: FabricOperationsStatusOperations operations
    :vartype fabric_operations_status:
     azure.mgmt.recoveryservicesdatareplication.operations.FabricOperationsStatusOperations
    :ivar policy: PolicyOperations operations
    :vartype policy: azure.mgmt.recoveryservicesdatareplication.operations.PolicyOperations
    :ivar policy_operation_status: PolicyOperationStatusOperations operations
    :vartype policy_operation_status:
     azure.mgmt.recoveryservicesdatareplication.operations.PolicyOperationStatusOperations
    :ivar protected_item: ProtectedItemOperations operations
    :vartype protected_item:
     azure.mgmt.recoveryservicesdatareplication.operations.ProtectedItemOperations
    :ivar protected_item_operation_status: ProtectedItemOperationStatusOperations operations
    :vartype protected_item_operation_status:
     azure.mgmt.recoveryservicesdatareplication.operations.ProtectedItemOperationStatusOperations
    :ivar recovery_points: RecoveryPointsOperations operations
    :vartype recovery_points:
     azure.mgmt.recoveryservicesdatareplication.operations.RecoveryPointsOperations
    :ivar replication_extension: ReplicationExtensionOperations operations
    :vartype replication_extension:
     azure.mgmt.recoveryservicesdatareplication.operations.ReplicationExtensionOperations
    :ivar replication_extension_operation_status: ReplicationExtensionOperationStatusOperations
     operations
    :vartype replication_extension_operation_status:
     azure.mgmt.recoveryservicesdatareplication.operations.ReplicationExtensionOperationStatusOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.recoveryservicesdatareplication.operations.Operations
    :ivar vault: VaultOperations operations
    :vartype vault: azure.mgmt.recoveryservicesdatareplication.operations.VaultOperations
    :ivar vault_operation_status: VaultOperationStatusOperations operations
    :vartype vault_operation_status:
     azure.mgmt.recoveryservicesdatareplication.operations.VaultOperationStatusOperations
    :ivar workflow: WorkflowOperations operations
    :vartype workflow: azure.mgmt.recoveryservicesdatareplication.operations.WorkflowOperations
    :ivar workflow_operation_status: WorkflowOperationStatusOperations operations
    :vartype workflow_operation_status:
     azure.mgmt.recoveryservicesdatareplication.operations.WorkflowOperationStatusOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. The value must be an UUID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2021-02-16-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = RecoveryServicesDataReplicationMgmtClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.dra = DraOperations(self._client, self._config, self._serialize, self._deserialize)
        self.dra_operation_status = DraOperationStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.email_configuration = EmailConfigurationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.event = EventOperations(self._client, self._config, self._serialize, self._deserialize)
        self.fabric = FabricOperations(self._client, self._config, self._serialize, self._deserialize)
        self.fabric_operations_status = FabricOperationsStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.policy = PolicyOperations(self._client, self._config, self._serialize, self._deserialize)
        self.policy_operation_status = PolicyOperationStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.protected_item = ProtectedItemOperations(self._client, self._config, self._serialize, self._deserialize)
        self.protected_item_operation_status = ProtectedItemOperationStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.recovery_points = RecoveryPointsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.replication_extension = ReplicationExtensionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.replication_extension_operation_status = ReplicationExtensionOperationStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.vault = VaultOperations(self._client, self._config, self._serialize, self._deserialize)
        self.vault_operation_status = VaultOperationStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow = WorkflowOperations(self._client, self._config, self._serialize, self._deserialize)
        self.workflow_operation_status = WorkflowOperationStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> "RecoveryServicesDataReplicationMgmtClient":
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
