# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class Resource(Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ApplicationInsightsComponentPricingPlan(Resource):
    """An Application Insights component pricing plan.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param plan_type: Pricing Plan Type Name.
    :type plan_type: str
    :param cap: Daily data volume cap in GB.
    :type cap: float
    :ivar reset_hour: Daily data volume cap UTC reset hour.
    :vartype reset_hour: int
    :param warning_threshold: Reserved, not used for now.
    :type warning_threshold: int
    :param stop_send_notification_when_hit_threshold: Reserved, not used for
     now.
    :type stop_send_notification_when_hit_threshold: bool
    :param stop_send_notification_when_hit_cap: Do not send a notification
     email when the daily data volume cap is met.
    :type stop_send_notification_when_hit_cap: bool
    :ivar max_history_cap: Maximum daily data volume cap that the user can set
     for this component.
    :vartype max_history_cap: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'reset_hour': {'readonly': True},
        'max_history_cap': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'plan_type': {'key': 'properties.planType', 'type': 'str'},
        'cap': {'key': 'properties.cap', 'type': 'float'},
        'reset_hour': {'key': 'properties.resetHour', 'type': 'int'},
        'warning_threshold': {'key': 'properties.warningThreshold', 'type': 'int'},
        'stop_send_notification_when_hit_threshold': {'key': 'properties.stopSendNotificationWhenHitThreshold', 'type': 'bool'},
        'stop_send_notification_when_hit_cap': {'key': 'properties.stopSendNotificationWhenHitCap', 'type': 'bool'},
        'max_history_cap': {'key': 'properties.maxHistoryCap', 'type': 'float'},
    }

    def __init__(self, *, plan_type: str=None, cap: float=None, warning_threshold: int=None, stop_send_notification_when_hit_threshold: bool=None, stop_send_notification_when_hit_cap: bool=None, **kwargs) -> None:
        super(ApplicationInsightsComponentPricingPlan, self).__init__(**kwargs)
        self.plan_type = plan_type
        self.cap = cap
        self.reset_hour = None
        self.warning_threshold = warning_threshold
        self.stop_send_notification_when_hit_threshold = stop_send_notification_when_hit_threshold
        self.stop_send_notification_when_hit_cap = stop_send_notification_when_hit_cap
        self.max_history_cap = None


class CloudError(Model):
    """An error response from the Batch service.

    :param error: Cloud error body.
    :type error:
     ~azure.mgmt.applicationinsights.v2017_10_01.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(CloudError, self).__init__(**kwargs)
        self.error = error


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CloudErrorBody(Model):
    """An error response from the Batch service.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable
     for display in a user interface.
    :type message: str
    :param target: The target of the particular error. For example, the name
     of the property in error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details:
     list[~azure.mgmt.applicationinsights.v2017_10_01.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(self, *, code: str=None, message: str=None, target: str=None, details=None, **kwargs) -> None:
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class EASubscriptionMigrationDate(Model):
    """Subscription migrate date information properties.

    :param is_grand_fatherable_subscription: Is subscription in the grand
     fatherable subscription list.
    :type is_grand_fatherable_subscription: bool
    :param opted_in_date: Time to start using new pricing model.
    :type opted_in_date: datetime
    """

    _attribute_map = {
        'is_grand_fatherable_subscription': {'key': 'isGrandFatherableSubscription', 'type': 'bool'},
        'opted_in_date': {'key': 'optedInDate', 'type': 'iso-8601'},
    }

    def __init__(self, *, is_grand_fatherable_subscription: bool=None, opted_in_date=None, **kwargs) -> None:
        super(EASubscriptionMigrationDate, self).__init__(**kwargs)
        self.is_grand_fatherable_subscription = is_grand_fatherable_subscription
        self.opted_in_date = opted_in_date
