# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CertificateRequest(Model):
    """Details of the certificate to be uploaded to the vault.

    :param properties:
    :type properties: ~azure.mgmt.recoveryservices.models.RawCertificateData
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'RawCertificateData'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(CertificateRequest, self).__init__(**kwargs)
        self.properties = properties


class CheckNameAvailabilityParameters(Model):
    """Resource Name availability input parameters - Resource type and resource
    name.

    :param type: Describes the Resource type:
     Microsoft.RecoveryServices/Vaults
    :type type: str
    :param name: Resource name for which availability needs to be checked
    :type name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, type: str=None, name: str=None, **kwargs) -> None:
        super(CheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.type = type
        self.name = name


class CheckNameAvailabilityResult(Model):
    """Response for check name availability API. Resource provider will set
    availability as true | false.

    :param name_available:
    :type name_available: bool
    :param reason:
    :type reason: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, name_available: bool=None, reason: str=None, message: str=None, **kwargs) -> None:
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class ClientDiscoveryDisplay(Model):
    """Localized display information of an operation.

    :param provider: Name of the provider for display purposes
    :type provider: str
    :param resource: ResourceType for which this Operation can be performed.
    :type resource: str
    :param operation: Operations Name itself.
    :type operation: str
    :param description: Description of the operation having details of what
     operation is about.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(ClientDiscoveryDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ClientDiscoveryForLogSpecification(Model):
    """Class to represent shoebox log specification in json client discovery.

    :param name: Name of the log.
    :type name: str
    :param display_name: Localized display name
    :type display_name: str
    :param blob_duration: Blobs created in customer storage account per hour
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, blob_duration: str=None, **kwargs) -> None:
        super(ClientDiscoveryForLogSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class ClientDiscoveryForProperties(Model):
    """Class to represent shoebox properties in json client discovery.

    :param service_specification: Operation properties.
    :type service_specification:
     ~azure.mgmt.recoveryservices.models.ClientDiscoveryForServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ClientDiscoveryForServiceSpecification'},
    }

    def __init__(self, *, service_specification=None, **kwargs) -> None:
        super(ClientDiscoveryForProperties, self).__init__(**kwargs)
        self.service_specification = service_specification


class ClientDiscoveryForServiceSpecification(Model):
    """Class to represent shoebox service specification in json client discovery.

    :param log_specifications: List of log specifications of this operation.
    :type log_specifications:
     list[~azure.mgmt.recoveryservices.models.ClientDiscoveryForLogSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[ClientDiscoveryForLogSpecification]'},
    }

    def __init__(self, *, log_specifications=None, **kwargs) -> None:
        super(ClientDiscoveryForServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = log_specifications


class ClientDiscoveryValueForSingleApi(Model):
    """Available operation details.

    :param name: Name of the Operation.
    :type name: str
    :param display: Contains the localized display information for this
     particular operation
    :type display: ~azure.mgmt.recoveryservices.models.ClientDiscoveryDisplay
    :param origin: The intended executor of the operation;governs the display
     of the operation in the RBAC UX and the audit logs UX
    :type origin: str
    :param properties: ShoeBox properties for the given operation.
    :type properties:
     ~azure.mgmt.recoveryservices.models.ClientDiscoveryForProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'ClientDiscoveryDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ClientDiscoveryForProperties'},
    }

    def __init__(self, *, name: str=None, display=None, origin: str=None, properties=None, **kwargs) -> None:
        super(ClientDiscoveryValueForSingleApi, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class IdentityData(Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: Required. The identity type. Possible values include:
     'SystemAssigned', 'None'
    :type type: str or
     ~azure.mgmt.recoveryservices.models.ResourceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, type, **kwargs) -> None:
        super(IdentityData, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class JobsSummary(Model):
    """Summary of the replication job data for this vault.

    :param failed_jobs: Count of failed jobs.
    :type failed_jobs: int
    :param suspended_jobs: Count of suspended jobs.
    :type suspended_jobs: int
    :param in_progress_jobs: Count of in-progress jobs.
    :type in_progress_jobs: int
    """

    _attribute_map = {
        'failed_jobs': {'key': 'failedJobs', 'type': 'int'},
        'suspended_jobs': {'key': 'suspendedJobs', 'type': 'int'},
        'in_progress_jobs': {'key': 'inProgressJobs', 'type': 'int'},
    }

    def __init__(self, *, failed_jobs: int=None, suspended_jobs: int=None, in_progress_jobs: int=None, **kwargs) -> None:
        super(JobsSummary, self).__init__(**kwargs)
        self.failed_jobs = failed_jobs
        self.suspended_jobs = suspended_jobs
        self.in_progress_jobs = in_progress_jobs


class MonitoringSummary(Model):
    """Summary of the replication monitoring data for this vault.

    :param un_healthy_vm_count: Count of unhealthy VMs.
    :type un_healthy_vm_count: int
    :param un_healthy_provider_count: Count of unhealthy replication
     providers.
    :type un_healthy_provider_count: int
    :param events_count: Count of all critical warnings.
    :type events_count: int
    :param deprecated_provider_count: Count of all deprecated recovery service
     providers.
    :type deprecated_provider_count: int
    :param supported_provider_count: Count of all the supported recovery
     service providers.
    :type supported_provider_count: int
    :param unsupported_provider_count: Count of all the unsupported recovery
     service providers.
    :type unsupported_provider_count: int
    """

    _attribute_map = {
        'un_healthy_vm_count': {'key': 'unHealthyVmCount', 'type': 'int'},
        'un_healthy_provider_count': {'key': 'unHealthyProviderCount', 'type': 'int'},
        'events_count': {'key': 'eventsCount', 'type': 'int'},
        'deprecated_provider_count': {'key': 'deprecatedProviderCount', 'type': 'int'},
        'supported_provider_count': {'key': 'supportedProviderCount', 'type': 'int'},
        'unsupported_provider_count': {'key': 'unsupportedProviderCount', 'type': 'int'},
    }

    def __init__(self, *, un_healthy_vm_count: int=None, un_healthy_provider_count: int=None, events_count: int=None, deprecated_provider_count: int=None, supported_provider_count: int=None, unsupported_provider_count: int=None, **kwargs) -> None:
        super(MonitoringSummary, self).__init__(**kwargs)
        self.un_healthy_vm_count = un_healthy_vm_count
        self.un_healthy_provider_count = un_healthy_provider_count
        self.events_count = events_count
        self.deprecated_provider_count = deprecated_provider_count
        self.supported_provider_count = supported_provider_count
        self.unsupported_provider_count = unsupported_provider_count


class NameInfo(Model):
    """The name of usage.

    :param value: Value of usage.
    :type value: str
    :param localized_value: Localized value of usage.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, *, value: str=None, localized_value: str=None, **kwargs) -> None:
        super(NameInfo, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class Resource(Model):
    """ARM Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param e_tag: Optional ETag.
    :type e_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
    }

    def __init__(self, *, e_tag: str=None, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.e_tag = e_tag


class PatchTrackedResource(Resource):
    """Tracked resource with location.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, e_tag: str=None, location: str=None, tags=None, **kwargs) -> None:
        super(PatchTrackedResource, self).__init__(e_tag=e_tag, **kwargs)
        self.location = location
        self.tags = tags


class PatchVault(PatchTrackedResource):
    """Patch Resource information, as returned by the resource provider.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param properties:
    :type properties: ~azure.mgmt.recoveryservices.models.VaultProperties
    :param sku:
    :type sku: ~azure.mgmt.recoveryservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'VaultProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(self, *, e_tag: str=None, location: str=None, tags=None, properties=None, sku=None, **kwargs) -> None:
        super(PatchVault, self).__init__(e_tag=e_tag, location=location, tags=tags, **kwargs)
        self.properties = properties
        self.sku = sku


class PrivateEndpoint(Model):
    """The Private Endpoint network resource that is linked to the Private
    Endpoint connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Gets or sets id.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Model):
    """Private Endpoint Connection Response Properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provisioning_state: Gets or sets provisioning state of the private
     endpoint connection. Possible values include: 'Succeeded', 'Deleting',
     'Failed', 'Pending'
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservices.models.ProvisioningState
    :param private_endpoint:
    :type private_endpoint:
     ~azure.mgmt.recoveryservices.models.PrivateEndpoint
    :param private_link_service_connection_state:
    :type private_link_service_connection_state:
     ~azure.mgmt.recoveryservices.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
    }

    def __init__(self, *, private_endpoint=None, private_link_service_connection_state=None, **kwargs) -> None:
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateEndpointConnectionVaultProperties(Model):
    """Information to be stored in Vault properties as an element of
    privateEndpointConnections List.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Format of id
     subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.[Service]/{resource}/{resourceName}/privateEndpointConnections/{connectionName}.
    :vartype id: str
    :param properties:
    :type properties:
     ~azure.mgmt.recoveryservices.models.PrivateEndpointConnection
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateEndpointConnection'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(PrivateEndpointConnectionVaultProperties, self).__init__(**kwargs)
        self.id = None
        self.properties = properties


class PrivateLinkResource(Model):
    """Information of the private link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar group_id: e.g. f9ad6492-33d4-4690-9999-6bfd52a0d081 (Backup) or
     f9ad6492-33d4-4690-9999-6bfd52a0d082 (SiteRecovery)
    :vartype group_id: str
    :ivar required_members: [backup-ecs1, backup-prot1, backup-prot1b,
     backup-prot1c, backup-id1]
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone
     name.
    :vartype required_zone_names: list[str]
    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: e.g. Microsoft.RecoveryServices/vaults/privateLinkResources
    :vartype type: str
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'required_zone_names': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None
        self.id = None
        self.name = None
        self.type = None


class PrivateLinkServiceConnectionState(Model):
    """Gets or sets private link service connection state.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar status: Gets or sets the status. Possible values include: 'Pending',
     'Approved', 'Rejected', 'Disconnected'
    :vartype status: str or
     ~azure.mgmt.recoveryservices.models.PrivateEndpointConnectionStatus
    :ivar description: Gets or sets description.
    :vartype description: str
    :ivar actions_required: Gets or sets actions required.
    :vartype actions_required: str
    """

    _validation = {
        'status': {'readonly': True},
        'description': {'readonly': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = None
        self.description = None
        self.actions_required = None


class RawCertificateData(Model):
    """Raw certificate data.

    :param auth_type: Specifies the authentication type. Possible values
     include: 'Invalid', 'ACS', 'AAD', 'AccessControlService',
     'AzureActiveDirectory'
    :type auth_type: str or ~azure.mgmt.recoveryservices.models.AuthType
    :param certificate: The base64 encoded certificate raw data string
    :type certificate: bytearray
    """

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'bytearray'},
    }

    def __init__(self, *, auth_type=None, certificate: bytearray=None, **kwargs) -> None:
        super(RawCertificateData, self).__init__(**kwargs)
        self.auth_type = auth_type
        self.certificate = certificate


class ReplicationUsage(Model):
    """Replication usages of a vault.

    :param monitoring_summary: Summary of the replication monitoring data for
     this vault.
    :type monitoring_summary:
     ~azure.mgmt.recoveryservices.models.MonitoringSummary
    :param jobs_summary: Summary of the replication jobs data for this vault.
    :type jobs_summary: ~azure.mgmt.recoveryservices.models.JobsSummary
    :param protected_item_count: Number of replication protected items for
     this vault.
    :type protected_item_count: int
    :param recovery_plan_count: Number of replication recovery plans for this
     vault.
    :type recovery_plan_count: int
    :param registered_servers_count: Number of servers registered to this
     vault.
    :type registered_servers_count: int
    :param recovery_services_provider_auth_type: The authentication type of
     recovery service providers in the vault.
    :type recovery_services_provider_auth_type: int
    """

    _attribute_map = {
        'monitoring_summary': {'key': 'monitoringSummary', 'type': 'MonitoringSummary'},
        'jobs_summary': {'key': 'jobsSummary', 'type': 'JobsSummary'},
        'protected_item_count': {'key': 'protectedItemCount', 'type': 'int'},
        'recovery_plan_count': {'key': 'recoveryPlanCount', 'type': 'int'},
        'registered_servers_count': {'key': 'registeredServersCount', 'type': 'int'},
        'recovery_services_provider_auth_type': {'key': 'recoveryServicesProviderAuthType', 'type': 'int'},
    }

    def __init__(self, *, monitoring_summary=None, jobs_summary=None, protected_item_count: int=None, recovery_plan_count: int=None, registered_servers_count: int=None, recovery_services_provider_auth_type: int=None, **kwargs) -> None:
        super(ReplicationUsage, self).__init__(**kwargs)
        self.monitoring_summary = monitoring_summary
        self.jobs_summary = jobs_summary
        self.protected_item_count = protected_item_count
        self.recovery_plan_count = recovery_plan_count
        self.registered_servers_count = registered_servers_count
        self.recovery_services_provider_auth_type = recovery_services_provider_auth_type


class ResourceCertificateDetails(Model):
    """Certificate details representing the Vault credentials.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ResourceCertificateAndAadDetails,
    ResourceCertificateAndAcsDetails

    All required parameters must be populated in order to send to Azure.

    :param certificate: The base64 encoded certificate raw data string.
    :type certificate: bytearray
    :param friendly_name: Certificate friendly name.
    :type friendly_name: str
    :param issuer: Certificate issuer.
    :type issuer: str
    :param resource_id: Resource ID of the vault.
    :type resource_id: long
    :param subject: Certificate Subject Name.
    :type subject: str
    :param thumbprint: Certificate thumbprint.
    :type thumbprint: str
    :param valid_from: Certificate Validity start Date time.
    :type valid_from: datetime
    :param valid_to: Certificate Validity End Date time.
    :type valid_to: datetime
    :param auth_type: Required. Constant filled by server.
    :type auth_type: str
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'bytearray'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'long'},
        'subject': {'key': 'subject', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'valid_from': {'key': 'validFrom', 'type': 'iso-8601'},
        'valid_to': {'key': 'validTo', 'type': 'iso-8601'},
        'auth_type': {'key': 'authType', 'type': 'str'},
    }

    _subtype_map = {
        'auth_type': {'AzureActiveDirectory': 'ResourceCertificateAndAadDetails', 'AccessControlService': 'ResourceCertificateAndAcsDetails'}
    }

    def __init__(self, *, certificate: bytearray=None, friendly_name: str=None, issuer: str=None, resource_id: int=None, subject: str=None, thumbprint: str=None, valid_from=None, valid_to=None, **kwargs) -> None:
        super(ResourceCertificateDetails, self).__init__(**kwargs)
        self.certificate = certificate
        self.friendly_name = friendly_name
        self.issuer = issuer
        self.resource_id = resource_id
        self.subject = subject
        self.thumbprint = thumbprint
        self.valid_from = valid_from
        self.valid_to = valid_to
        self.auth_type = None


class ResourceCertificateAndAadDetails(ResourceCertificateDetails):
    """Certificate details representing the Vault credentials for AAD.

    All required parameters must be populated in order to send to Azure.

    :param certificate: The base64 encoded certificate raw data string.
    :type certificate: bytearray
    :param friendly_name: Certificate friendly name.
    :type friendly_name: str
    :param issuer: Certificate issuer.
    :type issuer: str
    :param resource_id: Resource ID of the vault.
    :type resource_id: long
    :param subject: Certificate Subject Name.
    :type subject: str
    :param thumbprint: Certificate thumbprint.
    :type thumbprint: str
    :param valid_from: Certificate Validity start Date time.
    :type valid_from: datetime
    :param valid_to: Certificate Validity End Date time.
    :type valid_to: datetime
    :param auth_type: Required. Constant filled by server.
    :type auth_type: str
    :param aad_authority: Required. AAD tenant authority.
    :type aad_authority: str
    :param aad_tenant_id: Required. AAD tenant Id.
    :type aad_tenant_id: str
    :param service_principal_client_id: Required. AAD service principal
     clientId.
    :type service_principal_client_id: str
    :param service_principal_object_id: Required. AAD service principal
     ObjectId.
    :type service_principal_object_id: str
    :param azure_management_endpoint_audience: Required. Azure Management
     Endpoint Audience.
    :type azure_management_endpoint_audience: str
    """

    _validation = {
        'auth_type': {'required': True},
        'aad_authority': {'required': True},
        'aad_tenant_id': {'required': True},
        'service_principal_client_id': {'required': True},
        'service_principal_object_id': {'required': True},
        'azure_management_endpoint_audience': {'required': True},
    }

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'bytearray'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'long'},
        'subject': {'key': 'subject', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'valid_from': {'key': 'validFrom', 'type': 'iso-8601'},
        'valid_to': {'key': 'validTo', 'type': 'iso-8601'},
        'auth_type': {'key': 'authType', 'type': 'str'},
        'aad_authority': {'key': 'aadAuthority', 'type': 'str'},
        'aad_tenant_id': {'key': 'aadTenantId', 'type': 'str'},
        'service_principal_client_id': {'key': 'servicePrincipalClientId', 'type': 'str'},
        'service_principal_object_id': {'key': 'servicePrincipalObjectId', 'type': 'str'},
        'azure_management_endpoint_audience': {'key': 'azureManagementEndpointAudience', 'type': 'str'},
    }

    def __init__(self, *, aad_authority: str, aad_tenant_id: str, service_principal_client_id: str, service_principal_object_id: str, azure_management_endpoint_audience: str, certificate: bytearray=None, friendly_name: str=None, issuer: str=None, resource_id: int=None, subject: str=None, thumbprint: str=None, valid_from=None, valid_to=None, **kwargs) -> None:
        super(ResourceCertificateAndAadDetails, self).__init__(certificate=certificate, friendly_name=friendly_name, issuer=issuer, resource_id=resource_id, subject=subject, thumbprint=thumbprint, valid_from=valid_from, valid_to=valid_to, **kwargs)
        self.aad_authority = aad_authority
        self.aad_tenant_id = aad_tenant_id
        self.service_principal_client_id = service_principal_client_id
        self.service_principal_object_id = service_principal_object_id
        self.azure_management_endpoint_audience = azure_management_endpoint_audience
        self.auth_type = 'AzureActiveDirectory'


class ResourceCertificateAndAcsDetails(ResourceCertificateDetails):
    """Certificate details representing the Vault credentials for ACS.

    All required parameters must be populated in order to send to Azure.

    :param certificate: The base64 encoded certificate raw data string.
    :type certificate: bytearray
    :param friendly_name: Certificate friendly name.
    :type friendly_name: str
    :param issuer: Certificate issuer.
    :type issuer: str
    :param resource_id: Resource ID of the vault.
    :type resource_id: long
    :param subject: Certificate Subject Name.
    :type subject: str
    :param thumbprint: Certificate thumbprint.
    :type thumbprint: str
    :param valid_from: Certificate Validity start Date time.
    :type valid_from: datetime
    :param valid_to: Certificate Validity End Date time.
    :type valid_to: datetime
    :param auth_type: Required. Constant filled by server.
    :type auth_type: str
    :param global_acs_namespace: Required. ACS namespace name - tenant for our
     service.
    :type global_acs_namespace: str
    :param global_acs_host_name: Required. Acs mgmt host name to connect to.
    :type global_acs_host_name: str
    :param global_acs_rp_realm: Required. Global ACS namespace RP realm.
    :type global_acs_rp_realm: str
    """

    _validation = {
        'auth_type': {'required': True},
        'global_acs_namespace': {'required': True},
        'global_acs_host_name': {'required': True},
        'global_acs_rp_realm': {'required': True},
    }

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'bytearray'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'long'},
        'subject': {'key': 'subject', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'valid_from': {'key': 'validFrom', 'type': 'iso-8601'},
        'valid_to': {'key': 'validTo', 'type': 'iso-8601'},
        'auth_type': {'key': 'authType', 'type': 'str'},
        'global_acs_namespace': {'key': 'globalAcsNamespace', 'type': 'str'},
        'global_acs_host_name': {'key': 'globalAcsHostName', 'type': 'str'},
        'global_acs_rp_realm': {'key': 'globalAcsRPRealm', 'type': 'str'},
    }

    def __init__(self, *, global_acs_namespace: str, global_acs_host_name: str, global_acs_rp_realm: str, certificate: bytearray=None, friendly_name: str=None, issuer: str=None, resource_id: int=None, subject: str=None, thumbprint: str=None, valid_from=None, valid_to=None, **kwargs) -> None:
        super(ResourceCertificateAndAcsDetails, self).__init__(certificate=certificate, friendly_name=friendly_name, issuer=issuer, resource_id=resource_id, subject=subject, thumbprint=thumbprint, valid_from=valid_from, valid_to=valid_to, **kwargs)
        self.global_acs_namespace = global_acs_namespace
        self.global_acs_host_name = global_acs_host_name
        self.global_acs_rp_realm = global_acs_rp_realm
        self.auth_type = 'AccessControlService'


class Sku(Model):
    """Identifies the unique system identifier for each Azure resource.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The Sku name. Possible values include: 'Standard',
     'RS0'
    :type name: str or ~azure.mgmt.recoveryservices.models.SkuName
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name, **kwargs) -> None:
        super(Sku, self).__init__(**kwargs)
        self.name = name


class TrackedResource(Resource):
    """Tracked resource with location.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, location: str, e_tag: str=None, tags=None, **kwargs) -> None:
        super(TrackedResource, self).__init__(e_tag=e_tag, **kwargs)
        self.location = location
        self.tags = tags


class UpgradeDetails(Model):
    """Details for upgrading vault.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar operation_id: ID of the vault upgrade operation.
    :vartype operation_id: str
    :ivar start_time_utc: UTC time at which the upgrade operation has started.
    :vartype start_time_utc: datetime
    :ivar last_updated_time_utc: UTC time at which the upgrade operation
     status was last updated.
    :vartype last_updated_time_utc: datetime
    :ivar end_time_utc: UTC time at which the upgrade operation has ended.
    :vartype end_time_utc: datetime
    :ivar status: Status of the vault upgrade operation. Possible values
     include: 'Unknown', 'InProgress', 'Upgraded', 'Failed'
    :vartype status: str or
     ~azure.mgmt.recoveryservices.models.VaultUpgradeState
    :ivar message: Message to the user containing information about the
     upgrade operation.
    :vartype message: str
    :ivar trigger_type: The way the vault upgrade was triggered. Possible
     values include: 'UserTriggered', 'ForcedUpgrade'
    :vartype trigger_type: str or
     ~azure.mgmt.recoveryservices.models.TriggerType
    :ivar upgraded_resource_id: Resource ID of the upgraded vault.
    :vartype upgraded_resource_id: str
    :ivar previous_resource_id: Resource ID of the vault before the upgrade.
    :vartype previous_resource_id: str
    """

    _validation = {
        'operation_id': {'readonly': True},
        'start_time_utc': {'readonly': True},
        'last_updated_time_utc': {'readonly': True},
        'end_time_utc': {'readonly': True},
        'status': {'readonly': True},
        'message': {'readonly': True},
        'trigger_type': {'readonly': True},
        'upgraded_resource_id': {'readonly': True},
        'previous_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'iso-8601'},
        'last_updated_time_utc': {'key': 'lastUpdatedTimeUtc', 'type': 'iso-8601'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'trigger_type': {'key': 'triggerType', 'type': 'str'},
        'upgraded_resource_id': {'key': 'upgradedResourceId', 'type': 'str'},
        'previous_resource_id': {'key': 'previousResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(UpgradeDetails, self).__init__(**kwargs)
        self.operation_id = None
        self.start_time_utc = None
        self.last_updated_time_utc = None
        self.end_time_utc = None
        self.status = None
        self.message = None
        self.trigger_type = None
        self.upgraded_resource_id = None
        self.previous_resource_id = None


class Vault(TrackedResource):
    """Resource information, as returned by the resource provider.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param identity:
    :type identity: ~azure.mgmt.recoveryservices.models.IdentityData
    :param properties:
    :type properties: ~azure.mgmt.recoveryservices.models.VaultProperties
    :param sku:
    :type sku: ~azure.mgmt.recoveryservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'IdentityData'},
        'properties': {'key': 'properties', 'type': 'VaultProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(self, *, location: str, e_tag: str=None, tags=None, identity=None, properties=None, sku=None, **kwargs) -> None:
        super(Vault, self).__init__(e_tag=e_tag, location=location, tags=tags, **kwargs)
        self.identity = identity
        self.properties = properties
        self.sku = sku


class VaultCertificateResponse(Model):
    """Certificate corresponding to a vault that can be used by clients to
    register themselves with the vault.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :param properties:
    :type properties:
     ~azure.mgmt.recoveryservices.models.ResourceCertificateDetails
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'id': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ResourceCertificateDetails'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(VaultCertificateResponse, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.id = None
        self.properties = properties


class VaultExtendedInfoResource(Resource):
    """Vault extended information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param integrity_key: Integrity key.
    :type integrity_key: str
    :param encryption_key: Encryption key.
    :type encryption_key: str
    :param encryption_key_thumbprint: Encryption key thumbprint.
    :type encryption_key_thumbprint: str
    :param algorithm: Algorithm for Vault ExtendedInfo
    :type algorithm: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'integrity_key': {'key': 'properties.integrityKey', 'type': 'str'},
        'encryption_key': {'key': 'properties.encryptionKey', 'type': 'str'},
        'encryption_key_thumbprint': {'key': 'properties.encryptionKeyThumbprint', 'type': 'str'},
        'algorithm': {'key': 'properties.algorithm', 'type': 'str'},
    }

    def __init__(self, *, e_tag: str=None, integrity_key: str=None, encryption_key: str=None, encryption_key_thumbprint: str=None, algorithm: str=None, **kwargs) -> None:
        super(VaultExtendedInfoResource, self).__init__(e_tag=e_tag, **kwargs)
        self.integrity_key = integrity_key
        self.encryption_key = encryption_key
        self.encryption_key_thumbprint = encryption_key_thumbprint
        self.algorithm = algorithm


class VaultProperties(Model):
    """Properties of the vault.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provisioning_state: Provisioning State.
    :vartype provisioning_state: str
    :param upgrade_details:
    :type upgrade_details: ~azure.mgmt.recoveryservices.models.UpgradeDetails
    :ivar private_endpoint_connections: List of private endpoint connection.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.recoveryservices.models.PrivateEndpointConnectionVaultProperties]
    :ivar private_endpoint_state_for_backup: Private endpoint state for
     backup. Possible values include: 'None', 'Enabled'
    :vartype private_endpoint_state_for_backup: str or
     ~azure.mgmt.recoveryservices.models.VaultPrivateEndpointState
    :ivar private_endpoint_state_for_site_recovery: Private endpoint state for
     site recovery. Possible values include: 'None', 'Enabled'
    :vartype private_endpoint_state_for_site_recovery: str or
     ~azure.mgmt.recoveryservices.models.VaultPrivateEndpointState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'private_endpoint_state_for_backup': {'readonly': True},
        'private_endpoint_state_for_site_recovery': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'upgrade_details': {'key': 'upgradeDetails', 'type': 'UpgradeDetails'},
        'private_endpoint_connections': {'key': 'privateEndpointConnections', 'type': '[PrivateEndpointConnectionVaultProperties]'},
        'private_endpoint_state_for_backup': {'key': 'privateEndpointStateForBackup', 'type': 'str'},
        'private_endpoint_state_for_site_recovery': {'key': 'privateEndpointStateForSiteRecovery', 'type': 'str'},
    }

    def __init__(self, *, upgrade_details=None, **kwargs) -> None:
        super(VaultProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.upgrade_details = upgrade_details
        self.private_endpoint_connections = None
        self.private_endpoint_state_for_backup = None
        self.private_endpoint_state_for_site_recovery = None


class VaultUsage(Model):
    """Usages of a vault.

    :param unit: Unit of the usage. Possible values include: 'Count', 'Bytes',
     'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond'
    :type unit: str or ~azure.mgmt.recoveryservices.models.UsagesUnit
    :param quota_period: Quota period of usage.
    :type quota_period: str
    :param next_reset_time: Next reset time of usage.
    :type next_reset_time: datetime
    :param current_value: Current value of usage.
    :type current_value: long
    :param limit: Limit of usage.
    :type limit: long
    :param name: Name of usage.
    :type name: ~azure.mgmt.recoveryservices.models.NameInfo
    """

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'NameInfo'},
    }

    def __init__(self, *, unit=None, quota_period: str=None, next_reset_time=None, current_value: int=None, limit: int=None, name=None, **kwargs) -> None:
        super(VaultUsage, self).__init__(**kwargs)
        self.unit = unit
        self.quota_period = quota_period
        self.next_reset_time = next_reset_time
        self.current_value = current_value
        self.limit = limit
        self.name = name
