#include <stdio.h>
#include <dlfcn.h>
#include "sbllog.h"
#include "speechd.h"
/* sbl speechdispatcherlibrary  pointer */
static void *speechdlib_ptr = NULL;

/* pointer to libspeechd of speechdidspatcher */
static void *spd_libptr = NULL;

void speechd_close_lib ()
{
  if (speechdlib_ptr != NULL)
    dlclose (speechdlib_ptr);

  if (spd_libptr != NULL)
    dlclose (spd_libptr);
}

int speechd_load_lib (char *libpath)
{
  const char *err;

  spd_libptr = dlopen (SPEECHD, RTLD_NOW | RTLD_GLOBAL);
  sbl_log ("speechd: %s \n", dlerror ());
  sbl_log ("speechdispatcher lib opened");
  if (spd_libptr == NULL)
    return 1;

  speechdlib_ptr = dlopen (libpath, RTLD_NOW | RTLD_GLOBAL);
  if (speechdlib_ptr == NULL)
   {
     sbl_log ("%s", dlerror ());
     sbl_log ("Cannot open speechd driver library: %s", libpath);
     dlclose (spd_libptr);
     return 1;
   }
/* load symbols */
  speechd_close = dlsym (speechdlib_ptr, "speechd_close");
  if ((err = dlerror ()))
   {
     sbl_log ("speechd_load_sym: %s ", err);
     return 1;
   }

  speechd_init = dlsym (speechdlib_ptr, "speechd_init");
  if ((err = dlerror ()))
   {
     sbl_log ("speechd_load_sym: %s ", err);
     return 1;
   }

  speechd_start = dlsym (speechdlib_ptr, "speechd_start");
  if ((err = dlerror ()))
   {
     sbl_log ("speechd_load_sym: %s ", err);
     return 1;
   }

  speechd_say = dlsym (speechdlib_ptr, "speechd_say");
  if ((err = dlerror ()))
   {
     sbl_log ("speechd_load_sym: %s ", err);
     return 1;
   }

  speechd_param = dlsym (speechdlib_ptr, "speechd_param");
  if ((err = dlerror ()))
   {
     sbl_log ("speechd_load_sym: %s ", err);
     return 1;
   }

  speechd_vol = dlsym (speechdlib_ptr, "speechd_vol");
  if ((err = dlerror ()))
   {
     sbl_log ("speechd_load_sym: %s ", err);
     return 1;
   }

  speechd_frq = dlsym (speechdlib_ptr, "speechd_frq");
  if ((err = dlerror ()))
   {
     sbl_log ("speechd_load_sym: %s ", err);
     return 1;
   }

  speechd_spd = dlsym (speechdlib_ptr, "speechd_spd");
  if ((err = dlerror ()))
   {
     sbl_log ("speechd_load_sym: %s ", err);
     return 1;
   }

  speechd_voice = dlsym (speechdlib_ptr, "speechd_voice");
  if ((err = dlerror ()))
   {
     sbl_log ("speechd_load_sym: %s ", err);
     return 1;
   }

  speechd_lang = dlsym (speechdlib_ptr, "speechd_lang");
  if ((err = dlerror ()))
   {
     sbl_log ("speechd_load_sym: %s ", err);
     return 1;
   }

  speechd_spec = dlsym (speechdlib_ptr, "speechd_spec");
  if ((err = dlerror ()))
   {
     sbl_log ("speechd_load_sym: %s ", err);
     return 1;
   }

  speechd_stop = dlsym (speechdlib_ptr, "speechd_stop");
  if ((err = dlerror ()))
   {
     sbl_log ("speechd_load_sym: %s ", err);
     return 1;
   }

  speechd_punctuation = dlsym (speechdlib_ptr, "speechd_punctuation");
  if ((err = dlerror ()))
   {
     sbl_log ("speechd_load_sym: %s ", err);
     return 1;
   }
  sbl_log ("speechd_load_sym OK\n");
  return 0;
}
