#define SCR_C 1

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <linux/vt.h>
#include <errno.h>
#include <linux/kd.h>
#include "misc.h"
#include "config.h"
#include "scr.h"

static int vcsa_fd = -1, cons_fd = -1;

/* Pointer for external reference */

/* Conversion from ibmpc==cp437 to iso-latin-1 for chars>=128
 * Note that this is a quick hack until we can get all this directly
 * from the kernel console.  We also need to find how to know if 
 * such a translation table is in use.  This translation may be disabled
 * if the next line is commented out.
 */

#define CHARSET_CONV

int initscr (void)
{
  vcsa_fd = -1;
  if ((vcsa_fd = open (VCSADEV, O_RDONLY)) < 0)
   {
     fprintf (stderr, "can#t open %s\n", VCSADEV);
     return 1;
   }
  if ((cons_fd = open (CONSOLE, O_RDONLY)) < 0)
   {
     fprintf (stderr, "Can't open console device %s\n", CONSOLE);
     if (vcsa_fd >= 0)
       close (vcsa_fd);
     return 2;
   }
  return 0;
}

void getstat (scrstat * stat)
{
  unsigned char buffer[4];

  struct vt_stat vtstat;

  lseek (vcsa_fd, 0, SEEK_SET); /* go to start of file */
  read (vcsa_fd, buffer, 4);    /* get screen status bytes */
  stat->rows = buffer[0];
  stat->cols = buffer[1];
  stat->posx = buffer[2];
  stat->posy = buffer[3];
  ioctl (cons_fd, VT_GETSTATE, &vtstat);
  stat->no = vtstat.v_active;
}

int pos_to_unicode (int pos)
{
  struct unimapdesc sfm;
  int ch, i;

  sfm.entry_ct = 256;
  sfm.entries = malloc (sfm.entry_ct * sizeof (*sfm.entries));

  ioctl (cons_fd, GIO_UNIMAP, &sfm);

  for (i = 0; i < sfm.entry_ct; i++)
   {
     if (sfm.entries[i].fontpos == pos)
      {
        ch = (int) sfm.entries[i].unicode;
        free (sfm.entries);
        return ch;
      }
   }

  free (sfm.entries);
  return '?';
}

unsigned char *getscr (winpos pos, unsigned char *buffer, short mode)
{
  /* screen statistics */
  scrstat stat;

  getstat (&stat);
  if (pos.width < 1 || pos.height < 1
      || mode < 0 || mode > 1 || pos.left + pos.width > stat.cols
      || pos.top + pos.height > stat.rows)
    return NULL;
  /* start offset */
  off_t start = 4 + (pos.top * stat.cols + pos.left) * 2 + mode;

  /* number of bytes to read for one complete line */
  size_t linelen = 2 * pos.width - 1;

  /* line buffer */
  unsigned char linebuf[linelen];

  /* pointer to copy data to */
  unsigned char *dst = buffer;

  /* pointer to copy data from */
  unsigned char *src;

  /* indexes */
  int i, j;

  for (i = 0; i < pos.height; i++)
   {
     lseek (vcsa_fd, start + i * stat.cols * 2, SEEK_SET);
     read (vcsa_fd, linebuf, linelen);
     src = linebuf;
     for (j = 0; j < pos.width; j++)
      {
#ifdef CHARSET_CONV
        if (mode == SCR_TEXT && *src >= 128)
          /* Conversion from ibmpc==cp437 to iso-latin-1 for chars>=128 */
          *dst++ = pos_to_unicode (*src);
        else
          *dst++ = *src;
        src += 2;
#else
        *dst++ = *Src;
        src += 2;
#endif
      }
   }
  return buffer;
}

void closescr (void)
{
  if (vcsa_fd >= 0)
    close (vcsa_fd);
  if (cons_fd >= 0)
    close (cons_fd);
}

int initscr_phys (void)
{

  closescr ();
  return (initscr ());
}

void closescr_phys ()
{
  closescr ();
}

void getstat_phys (scrstat * stat)
{

  getstat (stat);

}
