// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`VerifyMac`](crate::operation::verify_mac::builders::VerifyMacFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`message(Blob)`](crate::operation::verify_mac::builders::VerifyMacFluentBuilder::message) / [`set_message(Option<Blob>)`](crate::operation::verify_mac::builders::VerifyMacFluentBuilder::set_message):<br>required: **true**<br><p>The message that will be used in the verification. Enter the same message that was used to generate the HMAC.</p> <p><code>GenerateMac</code> and <code>VerifyMac</code> do not provide special handling for message digests. If you generated an HMAC for a hash digest of a message, you must verify the HMAC for the same hash digest.</p><br>
    ///   - [`key_id(impl Into<String>)`](crate::operation::verify_mac::builders::VerifyMacFluentBuilder::key_id) / [`set_key_id(Option<String>)`](crate::operation::verify_mac::builders::VerifyMacFluentBuilder::set_key_id):<br>required: **true**<br><p>The KMS key that will be used in the verification.</p> <p>Enter a key ID of the KMS key that was used to generate the HMAC. If you identify a different KMS key, the <code>VerifyMac</code> operation fails.</p><br>
    ///   - [`mac_algorithm(MacAlgorithmSpec)`](crate::operation::verify_mac::builders::VerifyMacFluentBuilder::mac_algorithm) / [`set_mac_algorithm(Option<MacAlgorithmSpec>)`](crate::operation::verify_mac::builders::VerifyMacFluentBuilder::set_mac_algorithm):<br>required: **true**<br><p>The MAC algorithm that will be used in the verification. Enter the same MAC algorithm that was used to compute the HMAC. This algorithm must be supported by the HMAC KMS key identified by the <code>KeyId</code> parameter.</p><br>
    ///   - [`mac(Blob)`](crate::operation::verify_mac::builders::VerifyMacFluentBuilder::mac) / [`set_mac(Option<Blob>)`](crate::operation::verify_mac::builders::VerifyMacFluentBuilder::set_mac):<br>required: **true**<br><p>The HMAC to verify. Enter the HMAC that was generated by the <code>GenerateMac</code> operation when you specified the same message, HMAC KMS key, and MAC algorithm as the values specified in this request.</p><br>
    ///   - [`grant_tokens(impl Into<String>)`](crate::operation::verify_mac::builders::VerifyMacFluentBuilder::grant_tokens) / [`set_grant_tokens(Option<Vec::<String>>)`](crate::operation::verify_mac::builders::VerifyMacFluentBuilder::set_grant_tokens):<br>required: **false**<br><p>A list of grant tokens.</p> <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    ///   - [`dry_run(bool)`](crate::operation::verify_mac::builders::VerifyMacFluentBuilder::dry_run) / [`set_dry_run(Option<bool>)`](crate::operation::verify_mac::builders::VerifyMacFluentBuilder::set_dry_run):<br>required: **false**<br><p>Checks if your request will succeed. <code>DryRun</code> is an optional parameter.</p> <p>To learn more about how to use this parameter, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html">Testing your KMS API calls</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    /// - On success, responds with [`VerifyMacOutput`](crate::operation::verify_mac::VerifyMacOutput) with field(s):
    ///   - [`key_id(Option<String>)`](crate::operation::verify_mac::VerifyMacOutput::key_id): <p>The HMAC KMS key used in the verification.</p>
    ///   - [`mac_valid(bool)`](crate::operation::verify_mac::VerifyMacOutput::mac_valid): <p>A Boolean value that indicates whether the HMAC was verified. A value of <code>True</code> indicates that the HMAC (<code>Mac</code>) was generated with the specified <code>Message</code>, HMAC KMS key (<code>KeyID</code>) and <code>MacAlgorithm.</code>.</p> <p>If the HMAC is not verified, the <code>VerifyMac</code> operation fails with a <code>KMSInvalidMacException</code> exception. This exception indicates that one or more of the inputs changed since the HMAC was computed.</p>
    ///   - [`mac_algorithm(Option<MacAlgorithmSpec>)`](crate::operation::verify_mac::VerifyMacOutput::mac_algorithm): <p>The MAC algorithm used in the verification.</p>
    /// - On failure, responds with [`SdkError<VerifyMacError>`](crate::operation::verify_mac::VerifyMacError)
    pub fn verify_mac(&self) -> crate::operation::verify_mac::builders::VerifyMacFluentBuilder {
        crate::operation::verify_mac::builders::VerifyMacFluentBuilder::new(self.handle.clone())
    }
}
