// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GenerateDataKey`](crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder::key_id) / [`set_key_id(Option<String>)`](crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder::set_key_id):<br>required: **true**<br><p>Specifies the symmetric encryption KMS key that encrypts the data key. You cannot specify an asymmetric KMS key or a KMS key in a custom key store. To get the type and origin of your KMS key, use the <code>DescribeKey</code> operation.</p> <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p> <p>For example:</p> <ul>  <li>   <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Alias name: <code>alias/ExampleAlias</code></p></li>  <li>   <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code></p></li> </ul> <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p><br>
    ///   - [`encryption_context(impl Into<String>, impl Into<String>)`](crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder::encryption_context) / [`set_encryption_context(Option<HashMap::<String, String>>)`](crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder::set_encryption_context):<br>required: **false**<br><p>Specifies the encryption context that will be used when encrypting the data key.</p><important>  <p>Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.</p> </important> <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represent additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is supported only on operations with symmetric encryption KMS keys. On operations with symmetric encryption KMS keys, an encryption context is optional, but it is strongly recommended.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption context</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    ///   - [`number_of_bytes(i32)`](crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder::number_of_bytes) / [`set_number_of_bytes(Option<i32>)`](crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder::set_number_of_bytes):<br>required: **false**<br><p>Specifies the length of the data key in bytes. For example, use the value 64 to generate a 512-bit data key (64 bytes is 512 bits). For 128-bit (16-byte) and 256-bit (32-byte) data keys, use the <code>KeySpec</code> parameter.</p> <p>You must specify either the <code>KeySpec</code> or the <code>NumberOfBytes</code> parameter (but not both) in every <code>GenerateDataKey</code> request.</p><br>
    ///   - [`key_spec(DataKeySpec)`](crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder::key_spec) / [`set_key_spec(Option<DataKeySpec>)`](crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder::set_key_spec):<br>required: **false**<br><p>Specifies the length of the data key. Use <code>AES_128</code> to generate a 128-bit symmetric key, or <code>AES_256</code> to generate a 256-bit symmetric key.</p> <p>You must specify either the <code>KeySpec</code> or the <code>NumberOfBytes</code> parameter (but not both) in every <code>GenerateDataKey</code> request.</p><br>
    ///   - [`grant_tokens(impl Into<String>)`](crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder::grant_tokens) / [`set_grant_tokens(Option<Vec::<String>>)`](crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder::set_grant_tokens):<br>required: **false**<br><p>A list of grant tokens.</p> <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    ///   - [`recipient(RecipientInfo)`](crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder::recipient) / [`set_recipient(Option<RecipientInfo>)`](crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder::set_recipient):<br>required: **false**<br><p>A signed <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitro-enclave-how.html#term-attestdoc">attestation document</a> from an Amazon Web Services Nitro enclave and the encryption algorithm to use with the enclave's public key. The only valid encryption algorithm is <code>RSAES_OAEP_SHA_256</code>.</p> <p>This parameter only supports attestation documents for Amazon Web Services Nitro Enclaves. To include this parameter, use the <a href="https://docs.aws.amazon.com/enclaves/latest/user/developing-applications.html#sdk">Amazon Web Services Nitro Enclaves SDK</a> or any Amazon Web Services SDK.</p> <p>When you use this parameter, instead of returning the plaintext data key, KMS encrypts the plaintext data key under the public key in the attestation document, and returns the resulting ciphertext in the <code>CiphertextForRecipient</code> field in the response. This ciphertext can be decrypted only with the private key in the enclave. The <code>CiphertextBlob</code> field in the response contains a copy of the data key encrypted under the KMS key specified by the <code>KeyId</code> parameter. The <code>Plaintext</code> field in the response is null or empty.</p> <p>For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html">How Amazon Web Services Nitro Enclaves uses KMS</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    ///   - [`dry_run(bool)`](crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder::dry_run) / [`set_dry_run(Option<bool>)`](crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder::set_dry_run):<br>required: **false**<br><p>Checks if your request will succeed. <code>DryRun</code> is an optional parameter.</p> <p>To learn more about how to use this parameter, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html">Testing your KMS API calls</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    /// - On success, responds with [`GenerateDataKeyOutput`](crate::operation::generate_data_key::GenerateDataKeyOutput) with field(s):
    ///   - [`ciphertext_blob(Option<Blob>)`](crate::operation::generate_data_key::GenerateDataKeyOutput::ciphertext_blob): <p>The encrypted copy of the data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    ///   - [`plaintext(Option<Blob>)`](crate::operation::generate_data_key::GenerateDataKeyOutput::plaintext): <p>The plaintext data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded. Use this data key to encrypt your data outside of KMS. Then, remove it from memory as soon as possible.</p> <p>If the response includes the <code>CiphertextForRecipient</code> field, the <code>Plaintext</code> field is null or empty.</p>
    ///   - [`key_id(Option<String>)`](crate::operation::generate_data_key::GenerateDataKeyOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that encrypted the data key.</p>
    ///   - [`ciphertext_for_recipient(Option<Blob>)`](crate::operation::generate_data_key::GenerateDataKeyOutput::ciphertext_for_recipient): <p>The plaintext data key encrypted with the public key from the Nitro enclave. This ciphertext can be decrypted only by using a private key in the Nitro enclave.</p> <p>This field is included in the response only when the <code>Recipient</code> parameter in the request includes a valid attestation document from an Amazon Web Services Nitro enclave. For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html">How Amazon Web Services Nitro Enclaves uses KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<GenerateDataKeyError>`](crate::operation::generate_data_key::GenerateDataKeyError)
    pub fn generate_data_key(&self) -> crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder {
        crate::operation::generate_data_key::builders::GenerateDataKeyFluentBuilder::new(self.handle.clone())
    }
}
