/*
 * Decompiled with CFR 0.152.
 */
package com.clarkware.junitperf;

import com.clarkware.junitperf.ConstantTimer;
import com.clarkware.junitperf.LoadTest;
import com.clarkware.junitperf.MockTest;
import com.clarkware.junitperf.MockTestWithState;
import com.clarkware.junitperf.TestFactory;
import com.clarkware.junitperf.TimedTest;
import junit.extensions.RepeatedTest;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LoadTestTest
extends TestCase {
    private TestSuite _successSuite = new TestSuite();
    private TestSuite _rogueThreadSuite;
    private TestSuite _failureSuite = new TestSuite();
    private TestSuite _errorSuite;
    public static final long tolerance = 100L;
    static /* synthetic */ Class class$com$clarkware$junitperf$MockTestWithState;
    static /* synthetic */ Class class$com$clarkware$junitperf$LoadTestTest;

    public LoadTestTest(String name) {
        super(name);
        this._rogueThreadSuite = new TestSuite();
        this._errorSuite = new TestSuite();
        this._successSuite.addTest((Test)new MockTest("testSuccess"));
        this._successSuite.addTest((Test)new MockTest("testSuccess"));
        this._rogueThreadSuite.addTest((Test)new MockTest("testRogueThread"));
        this._failureSuite.addTest((Test)new MockTest("testFailure"));
        this._errorSuite.addTest((Test)new MockTest("testError"));
    }

    public void testOneUser() {
        LoadTest test = new LoadTest((Test)this._successSuite, 1);
        LoadTestTest.assertEquals((int)2, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        LoadTestTest.assertEquals((int)2, (int)result.runCount());
        LoadTestTest.assertEquals((int)0, (int)result.errorCount());
        LoadTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testOneUserRogueThread() {
        LoadTest test = new LoadTest((Test)this._rogueThreadSuite, 1);
        LoadTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        LoadTestTest.assertEquals((int)1, (int)result.runCount());
        LoadTestTest.assertEquals((int)0, (int)result.errorCount());
        LoadTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testMultiUser() {
        LoadTest test = new LoadTest((Test)this._successSuite, 3);
        LoadTestTest.assertEquals((int)6, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        LoadTestTest.assertEquals((int)6, (int)result.runCount());
        LoadTestTest.assertEquals((int)0, (int)result.errorCount());
        LoadTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testMultiUserWithIterations() {
        LoadTest test = new LoadTest((Test)this._successSuite, 3, 10);
        LoadTestTest.assertEquals((int)60, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        LoadTestTest.assertEquals((int)60, (int)result.runCount());
        LoadTestTest.assertEquals((int)0, (int)result.errorCount());
        LoadTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testMultiUserWithRepeatedTest() {
        RepeatedTest repeat = new RepeatedTest((Test)this._successSuite, 10);
        LoadTest test = new LoadTest((Test)repeat, 3);
        LoadTestTest.assertEquals((int)60, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        LoadTestTest.assertEquals((int)60, (int)result.runCount());
        LoadTestTest.assertEquals((int)0, (int)result.errorCount());
        LoadTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testMultiUserWithDelay() {
        LoadTest test = new LoadTest((Test)this._successSuite, 3, new ConstantTimer(0L));
        LoadTestTest.assertEquals((int)6, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        LoadTestTest.assertEquals((int)6, (int)result.runCount());
        LoadTestTest.assertEquals((int)0, (int)result.errorCount());
        LoadTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testMultiUserWithFailure() {
        LoadTest test = new LoadTest((Test)this._failureSuite, 3);
        LoadTestTest.assertEquals((int)3, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        LoadTestTest.assertEquals((int)3, (int)result.runCount());
        LoadTestTest.assertEquals((int)0, (int)result.errorCount());
        LoadTestTest.assertEquals((int)3, (int)result.failureCount());
    }

    public void testMultiUserWithError() {
        LoadTest test = new LoadTest((Test)this._errorSuite, 3);
        LoadTestTest.assertEquals((int)3, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        LoadTestTest.assertEquals((int)3, (int)result.runCount());
        LoadTestTest.assertEquals((int)3, (int)result.errorCount());
        LoadTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testMultiUserWithStop() {
        LoadTest test = new LoadTest((Test)this._failureSuite, 2);
        LoadTestTest.assertEquals((int)2, (int)test.countTestCases());
        TestResult result = new TestResult();
        result.stop();
        test.run(result);
        LoadTestTest.assertEquals((int)0, (int)result.runCount());
        LoadTestTest.assertEquals((int)0, (int)result.errorCount());
        LoadTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testNonPositiveUser() {
        try {
            LoadTest test1 = new LoadTest((Test)this._successSuite, 0);
            LoadTestTest.fail((String)"Should throw an IllegalArgumentException");
            LoadTest test2 = new LoadTest((Test)this._successSuite, -1);
            LoadTestTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException success) {
            return;
        }
    }

    public void testNullTimer() {
        try {
            LoadTest test = new LoadTest((Test)this._successSuite, 1, null);
            LoadTestTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException success) {
            return;
        }
    }

    public void testAtomic2SecondResponse() {
        MockTest mockTest = new MockTest("testAtomic2SecondResponseWithWorkerThread");
        LoadTest loadTest = new LoadTest((Test)mockTest, 1);
        TimedTest test = new TimedTest(loadTest, 1100L);
        LoadTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        LoadTestTest.assertEquals((int)1, (int)result.runCount());
        LoadTestTest.assertEquals((int)0, (int)result.errorCount());
        LoadTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testAtomic2SecondResponseEnforceTestAtomicity() {
        MockTest mockTest = new MockTest("testAtomic2SecondResponseWithWorkerThread");
        LoadTest loadTest = new LoadTest((Test)mockTest, 1);
        loadTest.setEnforceTestAtomicity(true);
        TimedTest test = new TimedTest(loadTest, 1100L);
        LoadTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        LoadTestTest.assertEquals((int)1, (int)result.runCount());
        LoadTestTest.assertEquals((int)0, (int)result.errorCount());
        LoadTestTest.assertEquals((int)1, (int)result.failureCount());
    }

    public void testNonAtomic2SecondResponse() {
        MockTest mockTest = new MockTest("testNonAtomic2SecondResponseWithWorkerThread");
        LoadTest loadTest = new LoadTest((Test)mockTest, 1);
        TimedTest test = new TimedTest(loadTest, 1100L);
        LoadTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        LoadTestTest.assertEquals((int)1, (int)result.runCount());
        LoadTestTest.assertEquals((int)0, (int)result.errorCount());
        LoadTestTest.assertEquals((int)1, (int)result.failureCount());
    }

    public void testNonAtomic2SecondResponseEnforceTestAtomicity() {
        MockTest mockTest = new MockTest("testNonAtomic2SecondResponseWithWorkerThread");
        LoadTest loadTest = new LoadTest((Test)mockTest, 1);
        loadTest.setEnforceTestAtomicity(true);
        TimedTest test = new TimedTest(loadTest, 1100L);
        LoadTestTest.assertEquals((int)1, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        LoadTestTest.assertEquals((int)1, (int)result.runCount());
        LoadTestTest.assertEquals((int)0, (int)result.errorCount());
        LoadTestTest.assertEquals((int)1, (int)result.failureCount());
    }

    public void testTestStateConsistencyFailure() {
        MockTestWithState mockTest = new MockTestWithState("testInvariant");
        LoadTest test = new LoadTest((Test)mockTest, 10, 2);
        test.setEnforceTestAtomicity(true);
        LoadTestTest.assertEquals((int)20, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        LoadTestTest.assertEquals((int)20, (int)result.runCount());
        LoadTestTest.assertEquals((int)0, (int)result.errorCount());
        LoadTestTest.assertTrue((result.failureCount() > 0 ? 1 : 0) != 0);
    }

    public void testTestStateConsistencyWithTestFactory() {
        TestFactory testFactory = new TestFactory(class$com$clarkware$junitperf$MockTestWithState == null ? (class$com$clarkware$junitperf$MockTestWithState = LoadTestTest.class$("com.clarkware.junitperf.MockTestWithState")) : class$com$clarkware$junitperf$MockTestWithState);
        LoadTest test = new LoadTest((Test)testFactory, 10, 2);
        test.setEnforceTestAtomicity(true);
        LoadTestTest.assertEquals((int)20, (int)test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        LoadTestTest.assertEquals((int)20, (int)result.runCount());
        LoadTestTest.assertEquals((int)0, (int)result.errorCount());
        LoadTestTest.assertEquals((int)0, (int)result.failureCount());
    }

    public static Test suite() {
        return new TestSuite(class$com$clarkware$junitperf$LoadTestTest == null ? (class$com$clarkware$junitperf$LoadTestTest = LoadTestTest.class$("com.clarkware.junitperf.LoadTestTest")) : class$com$clarkware$junitperf$LoadTestTest);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LoadTestTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

