; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple arm-eabi -mattr=+v6t2 | FileCheck %s
; RUN: llc < %s -mtriple arm-eabi -mattr=+v6t2 -mattr=+neon | FileCheck %s
; RUN: llc < %s -mtriple thumbv6m-none-eabi | FileCheck %s --check-prefix=CHECK-THUMB

; This test checks the @llvm.cttz.* intrinsics for integers.

declare i8 @llvm.cttz.i8(i8, i1)
declare i16 @llvm.cttz.i16(i16, i1)
declare i32 @llvm.cttz.i32(i32, i1)
declare i64 @llvm.cttz.i64(i64, i1)

;------------------------------------------------------------------------------

define i8 @test_i8(i8 %a) {
; CHECK-LABEL: test_i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    orr r0, r0, #256
; CHECK-NEXT:    rbit r0, r0
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_i8:
; CHECK-THUMB:       @ %bb.0:
; CHECK-THUMB-NEXT:    lsls r1, r0, #24
; CHECK-THUMB-NEXT:    beq .LBB0_2
; CHECK-THUMB-NEXT:  @ %bb.1: @ %cond.false
; CHECK-THUMB-NEXT:    subs r1, r0, #1
; CHECK-THUMB-NEXT:    bics r1, r0
; CHECK-THUMB-NEXT:    lsrs r0, r1, #1
; CHECK-THUMB-NEXT:    ldr r2, .LCPI0_0
; CHECK-THUMB-NEXT:    ands r2, r0
; CHECK-THUMB-NEXT:    subs r0, r1, r2
; CHECK-THUMB-NEXT:    ldr r1, .LCPI0_1
; CHECK-THUMB-NEXT:    lsrs r2, r0, #2
; CHECK-THUMB-NEXT:    ands r0, r1
; CHECK-THUMB-NEXT:    ands r2, r1
; CHECK-THUMB-NEXT:    adds r0, r0, r2
; CHECK-THUMB-NEXT:    lsrs r1, r0, #4
; CHECK-THUMB-NEXT:    adds r0, r0, r1
; CHECK-THUMB-NEXT:    ldr r1, .LCPI0_2
; CHECK-THUMB-NEXT:    ands r1, r0
; CHECK-THUMB-NEXT:    ldr r0, .LCPI0_3
; CHECK-THUMB-NEXT:    muls r0, r1, r0
; CHECK-THUMB-NEXT:    lsrs r0, r0, #24
; CHECK-THUMB-NEXT:    bx lr
; CHECK-THUMB-NEXT:  .LBB0_2:
; CHECK-THUMB-NEXT:    movs r0, #8
; CHECK-THUMB-NEXT:    bx lr
; CHECK-THUMB-NEXT:    .p2align 2
; CHECK-THUMB-NEXT:  @ %bb.3:
; CHECK-THUMB-NEXT:  .LCPI0_0:
; CHECK-THUMB-NEXT:    .long 1431655765 @ 0x55555555
; CHECK-THUMB-NEXT:  .LCPI0_1:
; CHECK-THUMB-NEXT:    .long 858993459 @ 0x33333333
; CHECK-THUMB-NEXT:  .LCPI0_2:
; CHECK-THUMB-NEXT:    .long 252645135 @ 0xf0f0f0f
; CHECK-THUMB-NEXT:  .LCPI0_3:
; CHECK-THUMB-NEXT:    .long 16843009 @ 0x1010101
  %tmp = call i8 @llvm.cttz.i8(i8 %a, i1 false)
  ret i8 %tmp
}

define i16 @test_i16(i16 %a) {
; CHECK-LABEL: test_i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    orr r0, r0, #65536
; CHECK-NEXT:    rbit r0, r0
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_i16:
; CHECK-THUMB:       @ %bb.0:
; CHECK-THUMB-NEXT:    lsls r1, r0, #16
; CHECK-THUMB-NEXT:    beq .LBB1_2
; CHECK-THUMB-NEXT:  @ %bb.1: @ %cond.false
; CHECK-THUMB-NEXT:    subs r1, r0, #1
; CHECK-THUMB-NEXT:    bics r1, r0
; CHECK-THUMB-NEXT:    lsrs r0, r1, #1
; CHECK-THUMB-NEXT:    ldr r2, .LCPI1_0
; CHECK-THUMB-NEXT:    ands r2, r0
; CHECK-THUMB-NEXT:    subs r0, r1, r2
; CHECK-THUMB-NEXT:    ldr r1, .LCPI1_1
; CHECK-THUMB-NEXT:    lsrs r2, r0, #2
; CHECK-THUMB-NEXT:    ands r0, r1
; CHECK-THUMB-NEXT:    ands r2, r1
; CHECK-THUMB-NEXT:    adds r0, r0, r2
; CHECK-THUMB-NEXT:    lsrs r1, r0, #4
; CHECK-THUMB-NEXT:    adds r0, r0, r1
; CHECK-THUMB-NEXT:    ldr r1, .LCPI1_2
; CHECK-THUMB-NEXT:    ands r1, r0
; CHECK-THUMB-NEXT:    ldr r0, .LCPI1_3
; CHECK-THUMB-NEXT:    muls r0, r1, r0
; CHECK-THUMB-NEXT:    lsrs r0, r0, #24
; CHECK-THUMB-NEXT:    bx lr
; CHECK-THUMB-NEXT:  .LBB1_2:
; CHECK-THUMB-NEXT:    movs r0, #16
; CHECK-THUMB-NEXT:    bx lr
; CHECK-THUMB-NEXT:    .p2align 2
; CHECK-THUMB-NEXT:  @ %bb.3:
; CHECK-THUMB-NEXT:  .LCPI1_0:
; CHECK-THUMB-NEXT:    .long 1431655765 @ 0x55555555
; CHECK-THUMB-NEXT:  .LCPI1_1:
; CHECK-THUMB-NEXT:    .long 858993459 @ 0x33333333
; CHECK-THUMB-NEXT:  .LCPI1_2:
; CHECK-THUMB-NEXT:    .long 252645135 @ 0xf0f0f0f
; CHECK-THUMB-NEXT:  .LCPI1_3:
; CHECK-THUMB-NEXT:    .long 16843009 @ 0x1010101
  %tmp = call i16 @llvm.cttz.i16(i16 %a, i1 false)
  ret i16 %tmp
}

define i32 @test_i32(i32 %a) {
; CHECK-LABEL: test_i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    rbit r0, r0
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_i32:
; CHECK-THUMB:       @ %bb.0:
; CHECK-THUMB-NEXT:    cmp r0, #0
; CHECK-THUMB-NEXT:    beq .LBB2_2
; CHECK-THUMB-NEXT:  @ %bb.1: @ %cond.false
; CHECK-THUMB-NEXT:    subs r1, r0, #1
; CHECK-THUMB-NEXT:    bics r1, r0
; CHECK-THUMB-NEXT:    lsrs r0, r1, #1
; CHECK-THUMB-NEXT:    ldr r2, .LCPI2_0
; CHECK-THUMB-NEXT:    ands r2, r0
; CHECK-THUMB-NEXT:    subs r0, r1, r2
; CHECK-THUMB-NEXT:    ldr r1, .LCPI2_1
; CHECK-THUMB-NEXT:    lsrs r2, r0, #2
; CHECK-THUMB-NEXT:    ands r0, r1
; CHECK-THUMB-NEXT:    ands r2, r1
; CHECK-THUMB-NEXT:    adds r0, r0, r2
; CHECK-THUMB-NEXT:    lsrs r1, r0, #4
; CHECK-THUMB-NEXT:    adds r0, r0, r1
; CHECK-THUMB-NEXT:    ldr r1, .LCPI2_2
; CHECK-THUMB-NEXT:    ands r1, r0
; CHECK-THUMB-NEXT:    ldr r0, .LCPI2_3
; CHECK-THUMB-NEXT:    muls r0, r1, r0
; CHECK-THUMB-NEXT:    lsrs r0, r0, #24
; CHECK-THUMB-NEXT:    bx lr
; CHECK-THUMB-NEXT:  .LBB2_2:
; CHECK-THUMB-NEXT:    movs r0, #32
; CHECK-THUMB-NEXT:    bx lr
; CHECK-THUMB-NEXT:    .p2align 2
; CHECK-THUMB-NEXT:  @ %bb.3:
; CHECK-THUMB-NEXT:  .LCPI2_0:
; CHECK-THUMB-NEXT:    .long 1431655765 @ 0x55555555
; CHECK-THUMB-NEXT:  .LCPI2_1:
; CHECK-THUMB-NEXT:    .long 858993459 @ 0x33333333
; CHECK-THUMB-NEXT:  .LCPI2_2:
; CHECK-THUMB-NEXT:    .long 252645135 @ 0xf0f0f0f
; CHECK-THUMB-NEXT:  .LCPI2_3:
; CHECK-THUMB-NEXT:    .long 16843009 @ 0x1010101
  %tmp = call i32 @llvm.cttz.i32(i32 %a, i1 false)
  ret i32 %tmp
}

define i64 @test_i64(i64 %a) {
; CHECK-LABEL: test_i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    rbit r1, r1
; CHECK-NEXT:    rbit r2, r0
; CHECK-NEXT:    clz r1, r1
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    add r1, r1, #32
; CHECK-NEXT:    clzne r1, r2
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    mov r1, #0
; CHECK-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_i64:
; CHECK-THUMB:       @ %bb.0:
; CHECK-THUMB-NEXT:    .save {r4, r5, r7, lr}
; CHECK-THUMB-NEXT:    push {r4, r5, r7, lr}
; CHECK-THUMB-NEXT:    ldr r5, .LCPI3_0
; CHECK-THUMB-NEXT:    ldr r4, .LCPI3_1
; CHECK-THUMB-NEXT:    ldr r3, .LCPI3_2
; CHECK-THUMB-NEXT:    ldr r2, .LCPI3_3
; CHECK-THUMB-NEXT:    cmp r0, #0
; CHECK-THUMB-NEXT:    bne .LBB3_2
; CHECK-THUMB-NEXT:  @ %bb.1:
; CHECK-THUMB-NEXT:    subs r0, r1, #1
; CHECK-THUMB-NEXT:    bics r0, r1
; CHECK-THUMB-NEXT:    lsrs r1, r0, #1
; CHECK-THUMB-NEXT:    ands r1, r5
; CHECK-THUMB-NEXT:    subs r0, r0, r1
; CHECK-THUMB-NEXT:    lsrs r1, r0, #2
; CHECK-THUMB-NEXT:    ands r0, r4
; CHECK-THUMB-NEXT:    ands r1, r4
; CHECK-THUMB-NEXT:    adds r0, r0, r1
; CHECK-THUMB-NEXT:    lsrs r1, r0, #4
; CHECK-THUMB-NEXT:    adds r0, r0, r1
; CHECK-THUMB-NEXT:    ands r0, r3
; CHECK-THUMB-NEXT:    muls r2, r0, r2
; CHECK-THUMB-NEXT:    lsrs r0, r2, #24
; CHECK-THUMB-NEXT:    adds r0, #32
; CHECK-THUMB-NEXT:    movs r1, #0
; CHECK-THUMB-NEXT:    pop {r4, r5, r7, pc}
; CHECK-THUMB-NEXT:  .LBB3_2:
; CHECK-THUMB-NEXT:    subs r1, r0, #1
; CHECK-THUMB-NEXT:    bics r1, r0
; CHECK-THUMB-NEXT:    lsrs r0, r1, #1
; CHECK-THUMB-NEXT:    ands r0, r5
; CHECK-THUMB-NEXT:    subs r0, r1, r0
; CHECK-THUMB-NEXT:    lsrs r1, r0, #2
; CHECK-THUMB-NEXT:    ands r0, r4
; CHECK-THUMB-NEXT:    ands r1, r4
; CHECK-THUMB-NEXT:    adds r0, r0, r1
; CHECK-THUMB-NEXT:    lsrs r1, r0, #4
; CHECK-THUMB-NEXT:    adds r0, r0, r1
; CHECK-THUMB-NEXT:    ands r0, r3
; CHECK-THUMB-NEXT:    muls r2, r0, r2
; CHECK-THUMB-NEXT:    lsrs r0, r2, #24
; CHECK-THUMB-NEXT:    movs r1, #0
; CHECK-THUMB-NEXT:    pop {r4, r5, r7, pc}
; CHECK-THUMB-NEXT:    .p2align 2
; CHECK-THUMB-NEXT:  @ %bb.3:
; CHECK-THUMB-NEXT:  .LCPI3_0:
; CHECK-THUMB-NEXT:    .long 1431655765 @ 0x55555555
; CHECK-THUMB-NEXT:  .LCPI3_1:
; CHECK-THUMB-NEXT:    .long 858993459 @ 0x33333333
; CHECK-THUMB-NEXT:  .LCPI3_2:
; CHECK-THUMB-NEXT:    .long 252645135 @ 0xf0f0f0f
; CHECK-THUMB-NEXT:  .LCPI3_3:
; CHECK-THUMB-NEXT:    .long 16843009 @ 0x1010101
  %tmp = call i64 @llvm.cttz.i64(i64 %a, i1 false)
  ret i64 %tmp
}

;------------------------------------------------------------------------------

define i8 @test_i8_zero_undef(i8 %a) {
; CHECK-LABEL: test_i8_zero_undef:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    rbit r0, r0
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_i8_zero_undef:
; CHECK-THUMB:       @ %bb.0:
; CHECK-THUMB-NEXT:    subs r1, r0, #1
; CHECK-THUMB-NEXT:    bics r1, r0
; CHECK-THUMB-NEXT:    lsrs r0, r1, #1
; CHECK-THUMB-NEXT:    ldr r2, .LCPI4_0
; CHECK-THUMB-NEXT:    ands r2, r0
; CHECK-THUMB-NEXT:    subs r0, r1, r2
; CHECK-THUMB-NEXT:    ldr r1, .LCPI4_1
; CHECK-THUMB-NEXT:    lsrs r2, r0, #2
; CHECK-THUMB-NEXT:    ands r0, r1
; CHECK-THUMB-NEXT:    ands r2, r1
; CHECK-THUMB-NEXT:    adds r0, r0, r2
; CHECK-THUMB-NEXT:    lsrs r1, r0, #4
; CHECK-THUMB-NEXT:    adds r0, r0, r1
; CHECK-THUMB-NEXT:    ldr r1, .LCPI4_2
; CHECK-THUMB-NEXT:    ands r1, r0
; CHECK-THUMB-NEXT:    ldr r0, .LCPI4_3
; CHECK-THUMB-NEXT:    muls r0, r1, r0
; CHECK-THUMB-NEXT:    lsrs r0, r0, #24
; CHECK-THUMB-NEXT:    bx lr
; CHECK-THUMB-NEXT:    .p2align 2
; CHECK-THUMB-NEXT:  @ %bb.1:
; CHECK-THUMB-NEXT:  .LCPI4_0:
; CHECK-THUMB-NEXT:    .long 1431655765 @ 0x55555555
; CHECK-THUMB-NEXT:  .LCPI4_1:
; CHECK-THUMB-NEXT:    .long 858993459 @ 0x33333333
; CHECK-THUMB-NEXT:  .LCPI4_2:
; CHECK-THUMB-NEXT:    .long 252645135 @ 0xf0f0f0f
; CHECK-THUMB-NEXT:  .LCPI4_3:
; CHECK-THUMB-NEXT:    .long 16843009 @ 0x1010101
  %tmp = call i8 @llvm.cttz.i8(i8 %a, i1 true)
  ret i8 %tmp
}

define i16 @test_i16_zero_undef(i16 %a) {
; CHECK-LABEL: test_i16_zero_undef:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    rbit r0, r0
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_i16_zero_undef:
; CHECK-THUMB:       @ %bb.0:
; CHECK-THUMB-NEXT:    subs r1, r0, #1
; CHECK-THUMB-NEXT:    bics r1, r0
; CHECK-THUMB-NEXT:    lsrs r0, r1, #1
; CHECK-THUMB-NEXT:    ldr r2, .LCPI5_0
; CHECK-THUMB-NEXT:    ands r2, r0
; CHECK-THUMB-NEXT:    subs r0, r1, r2
; CHECK-THUMB-NEXT:    ldr r1, .LCPI5_1
; CHECK-THUMB-NEXT:    lsrs r2, r0, #2
; CHECK-THUMB-NEXT:    ands r0, r1
; CHECK-THUMB-NEXT:    ands r2, r1
; CHECK-THUMB-NEXT:    adds r0, r0, r2
; CHECK-THUMB-NEXT:    lsrs r1, r0, #4
; CHECK-THUMB-NEXT:    adds r0, r0, r1
; CHECK-THUMB-NEXT:    ldr r1, .LCPI5_2
; CHECK-THUMB-NEXT:    ands r1, r0
; CHECK-THUMB-NEXT:    ldr r0, .LCPI5_3
; CHECK-THUMB-NEXT:    muls r0, r1, r0
; CHECK-THUMB-NEXT:    lsrs r0, r0, #24
; CHECK-THUMB-NEXT:    bx lr
; CHECK-THUMB-NEXT:    .p2align 2
; CHECK-THUMB-NEXT:  @ %bb.1:
; CHECK-THUMB-NEXT:  .LCPI5_0:
; CHECK-THUMB-NEXT:    .long 1431655765 @ 0x55555555
; CHECK-THUMB-NEXT:  .LCPI5_1:
; CHECK-THUMB-NEXT:    .long 858993459 @ 0x33333333
; CHECK-THUMB-NEXT:  .LCPI5_2:
; CHECK-THUMB-NEXT:    .long 252645135 @ 0xf0f0f0f
; CHECK-THUMB-NEXT:  .LCPI5_3:
; CHECK-THUMB-NEXT:    .long 16843009 @ 0x1010101
  %tmp = call i16 @llvm.cttz.i16(i16 %a, i1 true)
  ret i16 %tmp
}


define i32 @test_i32_zero_undef(i32 %a) {
; CHECK-LABEL: test_i32_zero_undef:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    rbit r0, r0
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_i32_zero_undef:
; CHECK-THUMB:       @ %bb.0:
; CHECK-THUMB-NEXT:    subs r1, r0, #1
; CHECK-THUMB-NEXT:    bics r1, r0
; CHECK-THUMB-NEXT:    lsrs r0, r1, #1
; CHECK-THUMB-NEXT:    ldr r2, .LCPI6_0
; CHECK-THUMB-NEXT:    ands r2, r0
; CHECK-THUMB-NEXT:    subs r0, r1, r2
; CHECK-THUMB-NEXT:    ldr r1, .LCPI6_1
; CHECK-THUMB-NEXT:    lsrs r2, r0, #2
; CHECK-THUMB-NEXT:    ands r0, r1
; CHECK-THUMB-NEXT:    ands r2, r1
; CHECK-THUMB-NEXT:    adds r0, r0, r2
; CHECK-THUMB-NEXT:    lsrs r1, r0, #4
; CHECK-THUMB-NEXT:    adds r0, r0, r1
; CHECK-THUMB-NEXT:    ldr r1, .LCPI6_2
; CHECK-THUMB-NEXT:    ands r1, r0
; CHECK-THUMB-NEXT:    ldr r0, .LCPI6_3
; CHECK-THUMB-NEXT:    muls r0, r1, r0
; CHECK-THUMB-NEXT:    lsrs r0, r0, #24
; CHECK-THUMB-NEXT:    bx lr
; CHECK-THUMB-NEXT:    .p2align 2
; CHECK-THUMB-NEXT:  @ %bb.1:
; CHECK-THUMB-NEXT:  .LCPI6_0:
; CHECK-THUMB-NEXT:    .long 1431655765 @ 0x55555555
; CHECK-THUMB-NEXT:  .LCPI6_1:
; CHECK-THUMB-NEXT:    .long 858993459 @ 0x33333333
; CHECK-THUMB-NEXT:  .LCPI6_2:
; CHECK-THUMB-NEXT:    .long 252645135 @ 0xf0f0f0f
; CHECK-THUMB-NEXT:  .LCPI6_3:
; CHECK-THUMB-NEXT:    .long 16843009 @ 0x1010101
  %tmp = call i32 @llvm.cttz.i32(i32 %a, i1 true)
  ret i32 %tmp
}

define i64 @test_i64_zero_undef(i64 %a) {
; CHECK-LABEL: test_i64_zero_undef:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    rbit r1, r1
; CHECK-NEXT:    rbit r2, r0
; CHECK-NEXT:    clz r1, r1
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    add r1, r1, #32
; CHECK-NEXT:    clzne r1, r2
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    mov r1, #0
; CHECK-NEXT:    bx lr
;
; CHECK-THUMB-LABEL: test_i64_zero_undef:
; CHECK-THUMB:       @ %bb.0:
; CHECK-THUMB-NEXT:    .save {r4, r5, r7, lr}
; CHECK-THUMB-NEXT:    push {r4, r5, r7, lr}
; CHECK-THUMB-NEXT:    ldr r5, .LCPI7_0
; CHECK-THUMB-NEXT:    ldr r4, .LCPI7_1
; CHECK-THUMB-NEXT:    ldr r3, .LCPI7_2
; CHECK-THUMB-NEXT:    ldr r2, .LCPI7_3
; CHECK-THUMB-NEXT:    cmp r0, #0
; CHECK-THUMB-NEXT:    bne .LBB7_2
; CHECK-THUMB-NEXT:  @ %bb.1:
; CHECK-THUMB-NEXT:    subs r0, r1, #1
; CHECK-THUMB-NEXT:    bics r0, r1
; CHECK-THUMB-NEXT:    lsrs r1, r0, #1
; CHECK-THUMB-NEXT:    ands r1, r5
; CHECK-THUMB-NEXT:    subs r0, r0, r1
; CHECK-THUMB-NEXT:    lsrs r1, r0, #2
; CHECK-THUMB-NEXT:    ands r0, r4
; CHECK-THUMB-NEXT:    ands r1, r4
; CHECK-THUMB-NEXT:    adds r0, r0, r1
; CHECK-THUMB-NEXT:    lsrs r1, r0, #4
; CHECK-THUMB-NEXT:    adds r0, r0, r1
; CHECK-THUMB-NEXT:    ands r0, r3
; CHECK-THUMB-NEXT:    muls r2, r0, r2
; CHECK-THUMB-NEXT:    lsrs r0, r2, #24
; CHECK-THUMB-NEXT:    adds r0, #32
; CHECK-THUMB-NEXT:    movs r1, #0
; CHECK-THUMB-NEXT:    pop {r4, r5, r7, pc}
; CHECK-THUMB-NEXT:  .LBB7_2:
; CHECK-THUMB-NEXT:    subs r1, r0, #1
; CHECK-THUMB-NEXT:    bics r1, r0
; CHECK-THUMB-NEXT:    lsrs r0, r1, #1
; CHECK-THUMB-NEXT:    ands r0, r5
; CHECK-THUMB-NEXT:    subs r0, r1, r0
; CHECK-THUMB-NEXT:    lsrs r1, r0, #2
; CHECK-THUMB-NEXT:    ands r0, r4
; CHECK-THUMB-NEXT:    ands r1, r4
; CHECK-THUMB-NEXT:    adds r0, r0, r1
; CHECK-THUMB-NEXT:    lsrs r1, r0, #4
; CHECK-THUMB-NEXT:    adds r0, r0, r1
; CHECK-THUMB-NEXT:    ands r0, r3
; CHECK-THUMB-NEXT:    muls r2, r0, r2
; CHECK-THUMB-NEXT:    lsrs r0, r2, #24
; CHECK-THUMB-NEXT:    movs r1, #0
; CHECK-THUMB-NEXT:    pop {r4, r5, r7, pc}
; CHECK-THUMB-NEXT:    .p2align 2
; CHECK-THUMB-NEXT:  @ %bb.3:
; CHECK-THUMB-NEXT:  .LCPI7_0:
; CHECK-THUMB-NEXT:    .long 1431655765 @ 0x55555555
; CHECK-THUMB-NEXT:  .LCPI7_1:
; CHECK-THUMB-NEXT:    .long 858993459 @ 0x33333333
; CHECK-THUMB-NEXT:  .LCPI7_2:
; CHECK-THUMB-NEXT:    .long 252645135 @ 0xf0f0f0f
; CHECK-THUMB-NEXT:  .LCPI7_3:
; CHECK-THUMB-NEXT:    .long 16843009 @ 0x1010101
  %tmp = call i64 @llvm.cttz.i64(i64 %a, i1 true)
  ret i64 %tmp
}
