; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=tahiti < %s | FileCheck -check-prefixes=GCN,GFX6 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=fiji < %s | FileCheck -check-prefixes=GCN,GFX8 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 < %s | FileCheck -check-prefixes=GCN,GFX9 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10PLUS,GFX10 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 < %s | FileCheck -check-prefixes=GFX10PLUS,GFX11 %s

define i8 @v_shl_i8(i8 %value, i8 %amount) {
; GFX6-LABEL: v_shl_i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_shl_i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b16_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_shl_i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b16_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_i8:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX10PLUS-NEXT:    v_lshlrev_b16 v0, v1, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl i8 %value, %amount
  ret i8 %result
}

define i8 @v_shl_i8_7(i8 %value) {
; GFX6-LABEL: v_shl_i8_7:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 7, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_shl_i8_7:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, 7, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_shl_i8_7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 7, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_i8_7:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_lshlrev_b16 v0, 7, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl i8 %value, 7
  ret i8 %result
}

define amdgpu_ps i8 @s_shl_i8(i8 inreg %value, i8 inreg %amount) {
; GFX6-LABEL: s_shl_i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, s1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_shl_i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_and_b32 s0, s0, 0xff
; GFX8-NEXT:    s_lshl_b32 s0, s0, s1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_shl_i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_and_b32 s0, s0, 0xff
; GFX9-NEXT:    s_lshl_b32 s0, s0, s1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_i8:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_and_b32 s0, s0, 0xff
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, s1
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i8 %value, %amount
  ret i8 %result
}

define amdgpu_ps i8 @s_shl_i8_7(i8 inreg %value) {
; GFX6-LABEL: s_shl_i8_7:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 7
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_shl_i8_7:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_bfe_u32 s1, 7, 0x100000
; GFX8-NEXT:    s_lshl_b32 s0, s0, s1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_shl_i8_7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_bfe_u32 s1, 7, 0x100000
; GFX9-NEXT:    s_lshl_b32 s0, s0, s1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_i8_7:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_bfe_u32 s1, 7, 0x100000
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, s1
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i8 %value, 7
  ret i8 %result
}


define i24 @v_shl_i24(i24 %value, i24 %amount) {
; GCN-LABEL: v_shl_i24:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 0xffffff, v1
; GCN-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_i24:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_and_b32_e32 v1, 0xffffff, v1
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl i24 %value, %amount
  ret i24 %result
}

define i24 @v_shl_i24_7(i24 %value) {
; GCN-LABEL: v_shl_i24_7:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 7, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_i24_7:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v0, 7, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl i24 %value, 7
  ret i24 %result
}

define amdgpu_ps i24 @s_shl_i24(i24 inreg %value, i24 inreg %amount) {
; GCN-LABEL: s_shl_i24:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_lshl_b32 s0, s0, s1
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_i24:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, s1
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i24 %value, %amount
  ret i24 %result
}

define amdgpu_ps i24 @s_shl_i24_7(i24 inreg %value) {
; GCN-LABEL: s_shl_i24_7:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_lshl_b32 s0, s0, 7
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_i24_7:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, 7
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i24 %value, 7
  ret i24 %result
}

define i32 @v_shl_i32(i32 %value, i32 %amount) {
; GCN-LABEL: v_shl_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl i32 %value, %amount
  ret i32 %result
}

define i32 @v_shl_i32_31(i32 %value) {
; GCN-LABEL: v_shl_i32_31:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 31, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_i32_31:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v0, 31, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl i32 %value, 31
  ret i32 %result
}

define amdgpu_ps i32 @s_shl_i32(i32 inreg %value, i32 inreg %amount) {
; GCN-LABEL: s_shl_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_lshl_b32 s0, s0, s1
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, s1
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i32 %value, %amount
  ret i32 %result
}

define amdgpu_ps i32 @s_shl_i32_31(i32 inreg %value) {
; GCN-LABEL: s_shl_i32_31:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_lshl_b32 s0, s0, 31
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_i32_31:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, 31
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i32 %value, 31
  ret i32 %result
}

define amdgpu_ps float @shl_i32_sv(i32 inreg %value, i32 %amount) {
; GFX6-LABEL: shl_i32_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_lshl_b32_e32 v0, s0, v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: shl_i32_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v0, s0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: shl_i32_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: shl_i32_sv:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_lshlrev_b32_e64 v0, v0, s0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i32 %value, %amount
  %cast = bitcast i32 %result to float
  ret float %cast
}

define amdgpu_ps float @shl_i32_vs(i32 %value, i32 inreg %amount) {
; GCN-LABEL: shl_i32_vs:
; GCN:       ; %bb.0:
; GCN-NEXT:    v_lshlrev_b32_e32 v0, s0, v0
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: shl_i32_vs:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v0, s0, v0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i32 %value, %amount
  %cast = bitcast i32 %result to float
  ret float %cast
}

define <2 x i32> @v_shl_v2i32(<2 x i32> %value, <2 x i32> %amount) {
; GCN-LABEL: v_shl_v2i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshlrev_b32_e32 v0, v2, v0
; GCN-NEXT:    v_lshlrev_b32_e32 v1, v3, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_v2i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v0, v2, v0
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v1, v3, v1
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl <2 x i32> %value, %amount
  ret <2 x i32> %result
}

define <2 x i32> @v_shl_v2i32_31(<2 x i32> %value) {
; GCN-LABEL: v_shl_v2i32_31:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 31, v0
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 31, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_v2i32_31:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v0, 31, v0
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v1, 31, v1
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl <2 x i32> %value, <i32 31, i32 31>
  ret <2 x i32> %result
}

define amdgpu_ps <2 x i32> @s_shl_v2i32(<2 x i32> inreg %value, <2 x i32> inreg %amount) {
; GCN-LABEL: s_shl_v2i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_lshl_b32 s0, s0, s2
; GCN-NEXT:    s_lshl_b32 s1, s1, s3
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_v2i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, s2
; GFX10PLUS-NEXT:    s_lshl_b32 s1, s1, s3
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl <2 x i32> %value, %amount
  ret <2 x i32> %result
}

define <3 x i32> @v_shl_v3i32(<3 x i32> %value, <3 x i32> %amount) {
; GCN-LABEL: v_shl_v3i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshlrev_b32_e32 v0, v3, v0
; GCN-NEXT:    v_lshlrev_b32_e32 v1, v4, v1
; GCN-NEXT:    v_lshlrev_b32_e32 v2, v5, v2
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_v3i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v0, v3, v0
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v1, v4, v1
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v2, v5, v2
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl <3 x i32> %value, %amount
  ret <3 x i32> %result
}

define amdgpu_ps <3 x i32> @s_shl_v3i32(<3 x i32> inreg %value, <3 x i32> inreg %amount) {
; GCN-LABEL: s_shl_v3i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_lshl_b32 s0, s0, s3
; GCN-NEXT:    s_lshl_b32 s1, s1, s4
; GCN-NEXT:    s_lshl_b32 s2, s2, s5
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_v3i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, s3
; GFX10PLUS-NEXT:    s_lshl_b32 s1, s1, s4
; GFX10PLUS-NEXT:    s_lshl_b32 s2, s2, s5
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl <3 x i32> %value, %amount
  ret <3 x i32> %result
}

define <4 x i32> @v_shl_v4i32(<4 x i32> %value, <4 x i32> %amount) {
; GCN-LABEL: v_shl_v4i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshlrev_b32_e32 v0, v4, v0
; GCN-NEXT:    v_lshlrev_b32_e32 v1, v5, v1
; GCN-NEXT:    v_lshlrev_b32_e32 v2, v6, v2
; GCN-NEXT:    v_lshlrev_b32_e32 v3, v7, v3
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_v4i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v0, v4, v0
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v1, v5, v1
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v2, v6, v2
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v3, v7, v3
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl <4 x i32> %value, %amount
  ret <4 x i32> %result
}

define amdgpu_ps <4 x i32> @s_shl_v4i32(<4 x i32> inreg %value, <4 x i32> inreg %amount) {
; GCN-LABEL: s_shl_v4i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_lshl_b32 s0, s0, s4
; GCN-NEXT:    s_lshl_b32 s1, s1, s5
; GCN-NEXT:    s_lshl_b32 s2, s2, s6
; GCN-NEXT:    s_lshl_b32 s3, s3, s7
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_v4i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, s4
; GFX10PLUS-NEXT:    s_lshl_b32 s1, s1, s5
; GFX10PLUS-NEXT:    s_lshl_b32 s2, s2, s6
; GFX10PLUS-NEXT:    s_lshl_b32 s3, s3, s7
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl <4 x i32> %value, %amount
  ret <4 x i32> %result
}

define <5 x i32> @v_shl_v5i32(<5 x i32> %value, <5 x i32> %amount) {
; GCN-LABEL: v_shl_v5i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshlrev_b32_e32 v0, v5, v0
; GCN-NEXT:    v_lshlrev_b32_e32 v1, v6, v1
; GCN-NEXT:    v_lshlrev_b32_e32 v2, v7, v2
; GCN-NEXT:    v_lshlrev_b32_e32 v3, v8, v3
; GCN-NEXT:    v_lshlrev_b32_e32 v4, v9, v4
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_v5i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v0, v5, v0
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v1, v6, v1
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v2, v7, v2
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v3, v8, v3
; GFX10PLUS-NEXT:    v_lshlrev_b32_e32 v4, v9, v4
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl <5 x i32> %value, %amount
  ret <5 x i32> %result
}

define amdgpu_ps <5 x i32> @s_shl_v5i32(<5 x i32> inreg %value, <5 x i32> inreg %amount) {
; GCN-LABEL: s_shl_v5i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_lshl_b32 s0, s0, s5
; GCN-NEXT:    s_lshl_b32 s1, s1, s6
; GCN-NEXT:    s_lshl_b32 s2, s2, s7
; GCN-NEXT:    s_lshl_b32 s3, s3, s8
; GCN-NEXT:    s_lshl_b32 s4, s4, s9
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_v5i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, s5
; GFX10PLUS-NEXT:    s_lshl_b32 s1, s1, s6
; GFX10PLUS-NEXT:    s_lshl_b32 s2, s2, s7
; GFX10PLUS-NEXT:    s_lshl_b32 s3, s3, s8
; GFX10PLUS-NEXT:    s_lshl_b32 s4, s4, s9
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl <5 x i32> %value, %amount
  ret <5 x i32> %result
}

define <16 x i32> @v_shl_v16i32(<16 x i32> %value, <16 x i32> %amount) {
; GCN-LABEL: v_shl_v16i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshlrev_b32_e32 v0, v16, v0
; GCN-NEXT:    buffer_load_dword v16, off, s[0:3], s32
; GCN-NEXT:    v_lshlrev_b32_e32 v1, v17, v1
; GCN-NEXT:    v_lshlrev_b32_e32 v2, v18, v2
; GCN-NEXT:    v_lshlrev_b32_e32 v3, v19, v3
; GCN-NEXT:    v_lshlrev_b32_e32 v4, v20, v4
; GCN-NEXT:    v_lshlrev_b32_e32 v5, v21, v5
; GCN-NEXT:    v_lshlrev_b32_e32 v6, v22, v6
; GCN-NEXT:    v_lshlrev_b32_e32 v7, v23, v7
; GCN-NEXT:    v_lshlrev_b32_e32 v8, v24, v8
; GCN-NEXT:    v_lshlrev_b32_e32 v9, v25, v9
; GCN-NEXT:    v_lshlrev_b32_e32 v10, v26, v10
; GCN-NEXT:    v_lshlrev_b32_e32 v11, v27, v11
; GCN-NEXT:    v_lshlrev_b32_e32 v12, v28, v12
; GCN-NEXT:    v_lshlrev_b32_e32 v13, v29, v13
; GCN-NEXT:    v_lshlrev_b32_e32 v14, v30, v14
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshlrev_b32_e32 v15, v16, v15
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_shl_v16i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, v16, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, v17, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, v18, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, v19, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, v20, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, v21, v5
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, v22, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, v23, v7
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, v24, v8
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, v25, v9
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, v26, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, v27, v11
; GFX10-NEXT:    v_lshlrev_b32_e32 v12, v28, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v13, v29, v13
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, v30, v14
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v15, v31, v15
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_shl_v16i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, v16, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, v17, v1
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, v18, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, v19, v3
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, v20, v4
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v21, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v6, v22, v6
; GFX11-NEXT:    v_lshlrev_b32_e32 v7, v23, v7
; GFX11-NEXT:    v_lshlrev_b32_e32 v8, v24, v8
; GFX11-NEXT:    v_lshlrev_b32_e32 v9, v25, v9
; GFX11-NEXT:    v_lshlrev_b32_e32 v10, v26, v10
; GFX11-NEXT:    v_lshlrev_b32_e32 v11, v27, v11
; GFX11-NEXT:    v_lshlrev_b32_e32 v12, v28, v12
; GFX11-NEXT:    v_lshlrev_b32_e32 v13, v29, v13
; GFX11-NEXT:    v_lshlrev_b32_e32 v14, v30, v14
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v15, v31, v15
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %result = shl <16 x i32> %value, %amount
  ret <16 x i32> %result
}

define amdgpu_ps <16 x i32> @s_shl_v16i32(<16 x i32> inreg %value, <16 x i32> inreg %amount) {
; GCN-LABEL: s_shl_v16i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_lshl_b32 s0, s0, s16
; GCN-NEXT:    s_lshl_b32 s1, s1, s17
; GCN-NEXT:    s_lshl_b32 s2, s2, s18
; GCN-NEXT:    s_lshl_b32 s3, s3, s19
; GCN-NEXT:    s_lshl_b32 s4, s4, s20
; GCN-NEXT:    s_lshl_b32 s5, s5, s21
; GCN-NEXT:    s_lshl_b32 s6, s6, s22
; GCN-NEXT:    s_lshl_b32 s7, s7, s23
; GCN-NEXT:    s_lshl_b32 s8, s8, s24
; GCN-NEXT:    s_lshl_b32 s9, s9, s25
; GCN-NEXT:    s_lshl_b32 s10, s10, s26
; GCN-NEXT:    s_lshl_b32 s11, s11, s27
; GCN-NEXT:    s_lshl_b32 s12, s12, s28
; GCN-NEXT:    s_lshl_b32 s13, s13, s29
; GCN-NEXT:    s_lshl_b32 s14, s14, s30
; GCN-NEXT:    s_lshl_b32 s15, s15, s31
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_v16i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, s16
; GFX10PLUS-NEXT:    s_lshl_b32 s1, s1, s17
; GFX10PLUS-NEXT:    s_lshl_b32 s2, s2, s18
; GFX10PLUS-NEXT:    s_lshl_b32 s3, s3, s19
; GFX10PLUS-NEXT:    s_lshl_b32 s4, s4, s20
; GFX10PLUS-NEXT:    s_lshl_b32 s5, s5, s21
; GFX10PLUS-NEXT:    s_lshl_b32 s6, s6, s22
; GFX10PLUS-NEXT:    s_lshl_b32 s7, s7, s23
; GFX10PLUS-NEXT:    s_lshl_b32 s8, s8, s24
; GFX10PLUS-NEXT:    s_lshl_b32 s9, s9, s25
; GFX10PLUS-NEXT:    s_lshl_b32 s10, s10, s26
; GFX10PLUS-NEXT:    s_lshl_b32 s11, s11, s27
; GFX10PLUS-NEXT:    s_lshl_b32 s12, s12, s28
; GFX10PLUS-NEXT:    s_lshl_b32 s13, s13, s29
; GFX10PLUS-NEXT:    s_lshl_b32 s14, s14, s30
; GFX10PLUS-NEXT:    s_lshl_b32 s15, s15, s31
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl <16 x i32> %value, %amount
  ret <16 x i32> %result
}

define i16 @v_shl_i16(i16 %value, i16 %amount) {
; GFX6-LABEL: v_shl_i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_shl_i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_shl_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_lshlrev_b16 v0, v1, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl i16 %value, %amount
  ret i16 %result
}

define i16 @v_shl_i16_31(i16 %value) {
; GCN-LABEL: v_shl_i16_31:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_i16_31:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl i16 %value, 31
  ret i16 %result
}

define amdgpu_ps i16 @s_shl_i16(i16 inreg %value, i16 inreg %amount) {
; GFX6-LABEL: s_shl_i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, s1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_shl_i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX8-NEXT:    s_lshl_b32 s0, s0, s1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_shl_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX9-NEXT:    s_lshl_b32 s0, s0, s1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, s1
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i16 %value, %amount
  ret i16 %result
}

define amdgpu_ps i16 @s_shl_i16_15(i16 inreg %value) {
; GFX6-LABEL: s_shl_i16_15:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 15
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_shl_i16_15:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_bfe_u32 s1, 15, 0x100000
; GFX8-NEXT:    s_lshl_b32 s0, s0, s1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_shl_i16_15:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_bfe_u32 s1, 15, 0x100000
; GFX9-NEXT:    s_lshl_b32 s0, s0, s1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_i16_15:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_bfe_u32 s1, 15, 0x100000
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, s1
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i16 %value, 15
  ret i16 %result
}

define amdgpu_ps half @shl_i16_sv(i16 inreg %value, i16 %amount) {
; GFX6-LABEL: shl_i16_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-NEXT:    v_lshl_b32_e32 v0, s0, v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: shl_i16_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_lshlrev_b16_e64 v0, v0, s0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: shl_i16_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b16_e64 v0, v0, s0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: shl_i16_sv:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_lshlrev_b16 v0, v0, s0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i16 %value, %amount
  %cast = bitcast i16 %result to half
  ret half %cast
}

define amdgpu_ps half @shl_i16_vs(i16 %value, i16 inreg %amount) {
; GFX6-LABEL: shl_i16_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, s0, v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: shl_i16_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: shl_i16_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: shl_i16_vs:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_lshlrev_b16 v0, s0, v0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i16 %value, %amount
  %cast = bitcast i16 %result to half
  ret half %cast
}

define <2 x i16> @v_shl_v2i16(<2 x i16> %value, <2 x i16> %amount) {
; GFX6-LABEL: v_shl_v2i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, v2, v0
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, v2, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_shl_v2i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, v1, v0
; GFX8-NEXT:    v_lshlrev_b16_sdwa v0, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_shl_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_lshlrev_b16 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_v2i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_pk_lshlrev_b16 v0, v1, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl <2 x i16> %value, %amount
  ret <2 x i16> %result
}

define <2 x i16> @v_shl_v2i16_15(<2 x i16> %value) {
; GFX6-LABEL: v_shl_v2i16_15:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 15, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 15, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_shl_v2i16_15:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, 15
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 15, v0
; GFX8-NEXT:    v_lshlrev_b16_sdwa v0, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_shl_v2i16_15:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_lshlrev_b16 v0, 15, v0 op_sel_hi:[0,1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_v2i16_15:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_pk_lshlrev_b16 v0, 15, v0 op_sel_hi:[0,1]
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl <2 x i16> %value, <i16 15, i16 15>
  ret <2 x i16> %result
}

define amdgpu_ps i32 @s_shl_v2i16(<2 x i16> inreg %value, <2 x i16> inreg %amount) {
; GFX6-LABEL: s_shl_v2i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s1, s1, s3
; GFX6-NEXT:    s_lshl_b32 s0, s0, s2
; GFX6-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX6-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_shl_v2i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_lshr_b32 s2, s0, 16
; GFX8-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX8-NEXT:    s_lshr_b32 s3, s1, 16
; GFX8-NEXT:    s_lshl_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s2, s3
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX8-NEXT:    s_or_b32 s0, s1, s0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_shl_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_lshr_b32 s2, s0, 16
; GFX9-NEXT:    s_lshr_b32 s3, s1, 16
; GFX9-NEXT:    s_lshl_b32 s0, s0, s1
; GFX9-NEXT:    s_lshl_b32 s1, s2, s3
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s0, s1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_v2i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshr_b32 s2, s0, 16
; GFX10PLUS-NEXT:    s_lshr_b32 s3, s1, 16
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, s1
; GFX10PLUS-NEXT:    s_lshl_b32 s1, s2, s3
; GFX10PLUS-NEXT:    s_pack_ll_b32_b16 s0, s0, s1
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl <2 x i16> %value, %amount
  %cast = bitcast <2 x i16> %result to i32
  ret i32 %cast
}

define amdgpu_ps float @shl_v2i16_sv(<2 x i16> inreg %value, <2 x i16> %amount) {
; GFX6-LABEL: shl_v2i16_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-NEXT:    v_lshl_b32_e32 v1, s1, v1
; GFX6-NEXT:    v_lshl_b32_e32 v0, s0, v0
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: shl_v2i16_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_lshr_b32 s1, s0, 16
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_lshlrev_b16_e64 v1, v0, s0
; GFX8-NEXT:    v_lshlrev_b16_sdwa v0, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: shl_v2i16_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_pk_lshlrev_b16 v0, v0, s0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: shl_v2i16_sv:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_pk_lshlrev_b16 v0, v0, s0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl <2 x i16> %value, %amount
  %cast = bitcast <2 x i16> %result to float
  ret float %cast
}

define amdgpu_ps float @shl_v2i16_vs(<2 x i16> %value, <2 x i16> inreg %amount) {
; GFX6-LABEL: shl_v2i16_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, s0, v0
; GFX6-NEXT:    s_and_b32 s0, s1, 0xffff
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, s0, v1
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: shl_v2i16_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_lshr_b32 s1, s0, 16
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, s0, v0
; GFX8-NEXT:    v_lshlrev_b16_sdwa v0, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: shl_v2i16_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_pk_lshlrev_b16 v0, s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: shl_v2i16_vs:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_pk_lshlrev_b16 v0, s0, v0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl <2 x i16> %value, %amount
  %cast = bitcast <2 x i16> %result to float
  ret float %cast
}

; FIXME
; define <3 x i16> @v_shl_v3i16(<3 x i16> %value, <3 x i16> %amount) {
;   %result = shl <3 x i16> %value, %amount
;   ret <3 x i16> %result
; }

; define amdgpu_ps <3 x i16> @s_shl_v3i16(<3 x i16> inreg %value, <3 x i16> inreg %amount) {
;   %result = shl <3 x i16> %value, %amount
;   ret <3 x i16> %result
; }

define <2 x float> @v_shl_v4i16(<4 x i16> %value, <4 x i16> %amount) {
; GFX6-LABEL: v_shl_v4i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, v4, v0
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, v4, v1
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff, v7
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, v4, v3
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_shl_v4i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b16_e32 v4, v2, v0
; GFX8-NEXT:    v_lshlrev_b16_sdwa v0, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, v3, v1
; GFX8-NEXT:    v_lshlrev_b16_sdwa v1, v3, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX8-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_shl_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_lshlrev_b16 v0, v2, v0
; GFX9-NEXT:    v_pk_lshlrev_b16 v1, v3, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_v4i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_pk_lshlrev_b16 v0, v2, v0
; GFX10PLUS-NEXT:    v_pk_lshlrev_b16 v1, v3, v1
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl <4 x i16> %value, %amount
  %cast = bitcast <4 x i16> %result to <2 x float>
  ret <2 x float> %cast
}

define amdgpu_ps <2 x i32> @s_shl_v4i16(<4 x i16> inreg %value, <4 x i16> inreg %amount) {
; GFX6-LABEL: s_shl_v4i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s1, s1, s5
; GFX6-NEXT:    s_lshl_b32 s0, s0, s4
; GFX6-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX6-NEXT:    s_lshl_b32 s2, s2, s6
; GFX6-NEXT:    s_lshl_b32 s3, s3, s7
; GFX6-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    s_and_b32 s1, s2, 0xffff
; GFX6-NEXT:    s_and_b32 s2, s3, 0xffff
; GFX6-NEXT:    s_lshl_b32 s2, s2, 16
; GFX6-NEXT:    s_or_b32 s1, s1, s2
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_shl_v4i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_lshr_b32 s4, s0, 16
; GFX8-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX8-NEXT:    s_lshr_b32 s6, s2, 16
; GFX8-NEXT:    s_lshr_b32 s5, s1, 16
; GFX8-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX8-NEXT:    s_lshr_b32 s7, s3, 16
; GFX8-NEXT:    s_lshl_b32 s0, s0, s2
; GFX8-NEXT:    s_lshl_b32 s2, s4, s6
; GFX8-NEXT:    s_lshl_b32 s1, s1, s3
; GFX8-NEXT:    s_lshl_b32 s3, s5, s7
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX8-NEXT:    s_or_b32 s0, s2, s0
; GFX8-NEXT:    s_lshl_b32 s2, s3, 16
; GFX8-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX8-NEXT:    s_or_b32 s1, s2, s1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_shl_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_lshr_b32 s4, s0, 16
; GFX9-NEXT:    s_lshr_b32 s5, s2, 16
; GFX9-NEXT:    s_lshl_b32 s0, s0, s2
; GFX9-NEXT:    s_lshl_b32 s2, s4, s5
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s0, s2
; GFX9-NEXT:    s_lshr_b32 s2, s1, 16
; GFX9-NEXT:    s_lshr_b32 s4, s3, 16
; GFX9-NEXT:    s_lshl_b32 s1, s1, s3
; GFX9-NEXT:    s_lshl_b32 s2, s2, s4
; GFX9-NEXT:    s_pack_ll_b32_b16 s1, s1, s2
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_v4i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshr_b32 s4, s0, 16
; GFX10PLUS-NEXT:    s_lshr_b32 s5, s2, 16
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, s2
; GFX10PLUS-NEXT:    s_lshl_b32 s2, s4, s5
; GFX10PLUS-NEXT:    s_lshr_b32 s4, s1, 16
; GFX10PLUS-NEXT:    s_lshr_b32 s5, s3, 16
; GFX10PLUS-NEXT:    s_lshl_b32 s1, s1, s3
; GFX10PLUS-NEXT:    s_lshl_b32 s3, s4, s5
; GFX10PLUS-NEXT:    s_pack_ll_b32_b16 s0, s0, s2
; GFX10PLUS-NEXT:    s_pack_ll_b32_b16 s1, s1, s3
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl <4 x i16> %value, %amount
  %cast = bitcast <4 x i16> %result to <2 x i32>
  ret <2 x i32> %cast
}

; FIXME
; define <5 x i16> @v_shl_v5i16(<5 x i16> %value, <5 x i16> %amount) {
;   %result = shl <5 x i16> %value, %amount
;   ret <5 x i16> %result
; }

; define amdgpu_ps <5 x i16> @s_shl_v5i16(<5 x i16> inreg %value, <5 x i16> inreg %amount) {
;   %result = shl <5 x i16> %value, %amount
;   ret <5 x i16> %result
; }

; define <3 x float> @v_shl_v6i16(<6 x i16> %value, <6 x i16> %amount) {
;   %result = shl <6 x i16> %value, %amount
;   %cast = bitcast <6 x i16> %result to <3 x float>
;   ret <3 x float> %cast
; }

; define amdgpu_ps <3 x i32> @s_shl_v6i16(<6 x i16> inreg %value, <6 x i16> inreg %amount) {
;   %result = shl <6 x i16> %value, %amount
;   %cast = bitcast <6 x i16> %result to <3 x i32>
;   ret <3 x i32> %cast
; }

define <4 x float> @v_shl_v8i16(<8 x i16> %value, <8 x i16> %amount) {
; GFX6-LABEL: v_shl_v8i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, v8, v0
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v9
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, v8, v1
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v10
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v8, v2
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v11
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, v8, v3
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v12
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, v8, v4
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v13
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, v8, v5
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v14
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, v8, v6
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v15
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v7, v8, v7
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff, v5
; GFX6-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff, v7
; GFX6-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_shl_v8i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b16_e32 v8, v4, v0
; GFX8-NEXT:    v_lshlrev_b16_sdwa v0, v4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_lshlrev_b16_e32 v4, v5, v1
; GFX8-NEXT:    v_lshlrev_b16_sdwa v1, v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v1, v4, v1
; GFX8-NEXT:    v_lshlrev_b16_e32 v4, v6, v2
; GFX8-NEXT:    v_lshlrev_b16_sdwa v2, v6, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX8-NEXT:    v_lshlrev_b16_e32 v4, v7, v3
; GFX8-NEXT:    v_lshlrev_b16_sdwa v3, v7, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX8-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_shl_v8i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_lshlrev_b16 v0, v4, v0
; GFX9-NEXT:    v_pk_lshlrev_b16 v1, v5, v1
; GFX9-NEXT:    v_pk_lshlrev_b16 v2, v6, v2
; GFX9-NEXT:    v_pk_lshlrev_b16 v3, v7, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_v8i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_pk_lshlrev_b16 v0, v4, v0
; GFX10PLUS-NEXT:    v_pk_lshlrev_b16 v1, v5, v1
; GFX10PLUS-NEXT:    v_pk_lshlrev_b16 v2, v6, v2
; GFX10PLUS-NEXT:    v_pk_lshlrev_b16 v3, v7, v3
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl <8 x i16> %value, %amount
  %cast = bitcast <8 x i16> %result to <4 x float>
  ret <4 x float> %cast
}

define amdgpu_ps <4 x i32> @s_shl_v8i16(<8 x i16> inreg %value, <8 x i16> inreg %amount) {
; GFX6-LABEL: s_shl_v8i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s1, s1, s9
; GFX6-NEXT:    s_lshl_b32 s0, s0, s8
; GFX6-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX6-NEXT:    s_lshl_b32 s2, s2, s10
; GFX6-NEXT:    s_lshl_b32 s3, s3, s11
; GFX6-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_lshl_b32 s5, s5, s13
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    s_and_b32 s1, s2, 0xffff
; GFX6-NEXT:    s_and_b32 s2, s3, 0xffff
; GFX6-NEXT:    s_lshl_b32 s4, s4, s12
; GFX6-NEXT:    s_lshl_b32 s7, s7, s15
; GFX6-NEXT:    s_lshl_b32 s2, s2, 16
; GFX6-NEXT:    s_and_b32 s3, s5, 0xffff
; GFX6-NEXT:    s_lshl_b32 s6, s6, s14
; GFX6-NEXT:    s_or_b32 s1, s1, s2
; GFX6-NEXT:    s_and_b32 s2, s4, 0xffff
; GFX6-NEXT:    s_lshl_b32 s3, s3, 16
; GFX6-NEXT:    s_and_b32 s4, s7, 0xffff
; GFX6-NEXT:    s_or_b32 s2, s2, s3
; GFX6-NEXT:    s_and_b32 s3, s6, 0xffff
; GFX6-NEXT:    s_lshl_b32 s4, s4, 16
; GFX6-NEXT:    s_or_b32 s3, s3, s4
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_shl_v8i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_lshr_b32 s8, s0, 16
; GFX8-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX8-NEXT:    s_lshr_b32 s12, s4, 16
; GFX8-NEXT:    s_lshr_b32 s9, s1, 16
; GFX8-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX8-NEXT:    s_lshr_b32 s13, s5, 16
; GFX8-NEXT:    s_lshl_b32 s0, s0, s4
; GFX8-NEXT:    s_lshl_b32 s4, s8, s12
; GFX8-NEXT:    s_lshr_b32 s10, s2, 16
; GFX8-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX8-NEXT:    s_lshr_b32 s14, s6, 16
; GFX8-NEXT:    s_lshl_b32 s1, s1, s5
; GFX8-NEXT:    s_lshl_b32 s5, s9, s13
; GFX8-NEXT:    s_lshl_b32 s4, s4, 16
; GFX8-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX8-NEXT:    s_lshr_b32 s11, s3, 16
; GFX8-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX8-NEXT:    s_lshr_b32 s15, s7, 16
; GFX8-NEXT:    s_lshl_b32 s2, s2, s6
; GFX8-NEXT:    s_lshl_b32 s6, s10, s14
; GFX8-NEXT:    s_or_b32 s0, s4, s0
; GFX8-NEXT:    s_lshl_b32 s4, s5, 16
; GFX8-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX8-NEXT:    s_lshl_b32 s3, s3, s7
; GFX8-NEXT:    s_lshl_b32 s7, s11, s15
; GFX8-NEXT:    s_or_b32 s1, s4, s1
; GFX8-NEXT:    s_lshl_b32 s4, s6, 16
; GFX8-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX8-NEXT:    s_or_b32 s2, s4, s2
; GFX8-NEXT:    s_lshl_b32 s4, s7, 16
; GFX8-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX8-NEXT:    s_or_b32 s3, s4, s3
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_shl_v8i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_lshr_b32 s8, s0, 16
; GFX9-NEXT:    s_lshr_b32 s9, s4, 16
; GFX9-NEXT:    s_lshl_b32 s0, s0, s4
; GFX9-NEXT:    s_lshl_b32 s4, s8, s9
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s0, s4
; GFX9-NEXT:    s_lshr_b32 s4, s1, 16
; GFX9-NEXT:    s_lshr_b32 s8, s5, 16
; GFX9-NEXT:    s_lshl_b32 s1, s1, s5
; GFX9-NEXT:    s_lshl_b32 s4, s4, s8
; GFX9-NEXT:    s_pack_ll_b32_b16 s1, s1, s4
; GFX9-NEXT:    s_lshr_b32 s4, s2, 16
; GFX9-NEXT:    s_lshr_b32 s5, s6, 16
; GFX9-NEXT:    s_lshl_b32 s2, s2, s6
; GFX9-NEXT:    s_lshl_b32 s4, s4, s5
; GFX9-NEXT:    s_pack_ll_b32_b16 s2, s2, s4
; GFX9-NEXT:    s_lshr_b32 s4, s3, 16
; GFX9-NEXT:    s_lshr_b32 s5, s7, 16
; GFX9-NEXT:    s_lshl_b32 s3, s3, s7
; GFX9-NEXT:    s_lshl_b32 s4, s4, s5
; GFX9-NEXT:    s_pack_ll_b32_b16 s3, s3, s4
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_v8i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshr_b32 s8, s0, 16
; GFX10PLUS-NEXT:    s_lshr_b32 s9, s4, 16
; GFX10PLUS-NEXT:    s_lshl_b32 s0, s0, s4
; GFX10PLUS-NEXT:    s_lshl_b32 s4, s8, s9
; GFX10PLUS-NEXT:    s_lshr_b32 s8, s1, 16
; GFX10PLUS-NEXT:    s_lshr_b32 s9, s5, 16
; GFX10PLUS-NEXT:    s_lshl_b32 s1, s1, s5
; GFX10PLUS-NEXT:    s_lshl_b32 s5, s8, s9
; GFX10PLUS-NEXT:    s_pack_ll_b32_b16 s0, s0, s4
; GFX10PLUS-NEXT:    s_pack_ll_b32_b16 s1, s1, s5
; GFX10PLUS-NEXT:    s_lshr_b32 s4, s2, 16
; GFX10PLUS-NEXT:    s_lshr_b32 s5, s6, 16
; GFX10PLUS-NEXT:    s_lshl_b32 s2, s2, s6
; GFX10PLUS-NEXT:    s_lshl_b32 s4, s4, s5
; GFX10PLUS-NEXT:    s_lshr_b32 s5, s3, 16
; GFX10PLUS-NEXT:    s_lshr_b32 s6, s7, 16
; GFX10PLUS-NEXT:    s_lshl_b32 s3, s3, s7
; GFX10PLUS-NEXT:    s_lshl_b32 s5, s5, s6
; GFX10PLUS-NEXT:    s_pack_ll_b32_b16 s2, s2, s4
; GFX10PLUS-NEXT:    s_pack_ll_b32_b16 s3, s3, s5
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl <8 x i16> %value, %amount
  %cast = bitcast <8 x i16> %result to <4 x i32>
  ret <4 x i32> %cast
}

define i64 @v_shl_i64(i64 %value, i64 %amount) {
; GFX6-LABEL: v_shl_i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshl_b64 v[0:1], v[0:1], v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_shl_i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b64 v[0:1], v2, v[0:1]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_shl_i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], v2, v[0:1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_i64:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_lshlrev_b64 v[0:1], v2, v[0:1]
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl i64 %value, %amount
  ret i64 %result
}

define i64 @v_shl_i64_63(i64 %value) {
; GCN-LABEL: v_shl_i64_63:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 31, v0
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_shl_i64_63:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 31, v0
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_shl_i64_63:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_lshlrev_b32 v1, 31, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %result = shl i64 %value, 63
  ret i64 %result
}

define i64 @v_shl_i64_33(i64 %value) {
; GCN-LABEL: v_shl_i64_33:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_shl_i64_33:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_shl_i64_33:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_lshlrev_b32 v1, 1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %result = shl i64 %value, 33
  ret i64 %result
}

define i64 @v_shl_i64_32(i64 %value) {
; GCN-LABEL: v_shl_i64_32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v1, v0
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_shl_i64_32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_shl_i64_32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_dual_mov_b32 v1, v0 :: v_dual_mov_b32 v0, 0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %result = shl i64 %value, 32
  ret i64 %result
}

define i64 @v_shl_i64_31(i64 %value) {
; GFX6-LABEL: v_shl_i64_31:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshl_b64 v[0:1], v[0:1], 31
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_shl_i64_31:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b64 v[0:1], 31, v[0:1]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_shl_i64_31:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], 31, v[0:1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_i64_31:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_lshlrev_b64 v[0:1], 31, v[0:1]
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl i64 %value, 31
  ret i64 %result
}

define amdgpu_ps i64 @s_shl_i64(i64 inreg %value, i64 inreg %amount) {
; GCN-LABEL: s_shl_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_i64:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshl_b64 s[0:1], s[0:1], s2
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i64 %value, %amount
  ret i64 %result
}

define amdgpu_ps i64 @s_shl_i64_63(i64 inreg %value) {
; GCN-LABEL: s_shl_i64_63:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_lshl_b32 s1, s0, 31
; GCN-NEXT:    s_mov_b32 s0, 0
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_i64_63:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshl_b32 s1, s0, 31
; GFX10PLUS-NEXT:    s_mov_b32 s0, 0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i64 %value, 63
  ret i64 %result
}

define amdgpu_ps i64 @s_shl_i64_33(i64 inreg %value) {
; GCN-LABEL: s_shl_i64_33:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_lshl_b32 s1, s0, 1
; GCN-NEXT:    s_mov_b32 s0, 0
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_i64_33:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshl_b32 s1, s0, 1
; GFX10PLUS-NEXT:    s_mov_b32 s0, 0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i64 %value, 33
  ret i64 %result
}

define amdgpu_ps i64 @s_shl_i64_32(i64 inreg %value) {
; GCN-LABEL: s_shl_i64_32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_mov_b32 s1, s0
; GCN-NEXT:    s_mov_b32 s0, 0
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_i64_32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_mov_b32 s1, s0
; GFX10PLUS-NEXT:    s_mov_b32 s0, 0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i64 %value, 32
  ret i64 %result
}

define amdgpu_ps i64 @s_shl_i64_31(i64 inreg %value) {
; GCN-LABEL: s_shl_i64_31:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_lshl_b64 s[0:1], s[0:1], 31
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_i64_31:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshl_b64 s[0:1], s[0:1], 31
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i64 %value, 31
  ret i64 %result
}

define amdgpu_ps <2 x float> @shl_i64_sv(i64 inreg %value, i64 %amount) {
; GFX6-LABEL: shl_i64_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_lshl_b64 v[0:1], s[0:1], v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: shl_i64_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_lshlrev_b64 v[0:1], v0, s[0:1]
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: shl_i64_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], v0, s[0:1]
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: shl_i64_sv:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_lshlrev_b64 v[0:1], v0, s[0:1]
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i64 %value, %amount
  %cast = bitcast i64 %result to <2 x float>
  ret <2 x float> %cast
}

define amdgpu_ps <2 x float> @shl_i64_vs(i64 %value, i64 inreg %amount) {
; GFX6-LABEL: shl_i64_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_lshl_b64 v[0:1], v[0:1], s0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: shl_i64_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_lshlrev_b64 v[0:1], s0, v[0:1]
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: shl_i64_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], s0, v[0:1]
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: shl_i64_vs:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_lshlrev_b64 v[0:1], s0, v[0:1]
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i64 %value, %amount
  %cast = bitcast i64 %result to <2 x float>
  ret <2 x float> %cast
}

define <2 x i64> @v_shl_v2i64(<2 x i64> %value, <2 x i64> %amount) {
; GFX6-LABEL: v_shl_v2i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshl_b64 v[0:1], v[0:1], v4
; GFX6-NEXT:    v_lshl_b64 v[2:3], v[2:3], v6
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_shl_v2i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b64 v[0:1], v4, v[0:1]
; GFX8-NEXT:    v_lshlrev_b64 v[2:3], v6, v[2:3]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_shl_v2i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], v4, v[0:1]
; GFX9-NEXT:    v_lshlrev_b64 v[2:3], v6, v[2:3]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_v2i64:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_lshlrev_b64 v[0:1], v4, v[0:1]
; GFX10PLUS-NEXT:    v_lshlrev_b64 v[2:3], v6, v[2:3]
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl <2 x i64> %value, %amount
  ret <2 x i64> %result
}

define <2 x i64> @v_shl_v2i64_31(<2 x i64> %value) {
; GFX6-LABEL: v_shl_v2i64_31:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshl_b64 v[0:1], v[0:1], 31
; GFX6-NEXT:    v_lshl_b64 v[2:3], v[2:3], 31
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_shl_v2i64_31:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b64 v[0:1], 31, v[0:1]
; GFX8-NEXT:    v_lshlrev_b64 v[2:3], 31, v[2:3]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_shl_v2i64_31:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], 31, v[0:1]
; GFX9-NEXT:    v_lshlrev_b64 v[2:3], 31, v[2:3]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_shl_v2i64_31:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_lshlrev_b64 v[0:1], 31, v[0:1]
; GFX10PLUS-NEXT:    v_lshlrev_b64 v[2:3], 31, v[2:3]
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = shl <2 x i64> %value, <i64 31, i64 31>
  ret <2 x i64> %result
}

define amdgpu_ps <2 x i64> @s_shl_v2i64(<2 x i64> inreg %value, <2 x i64> inreg %amount) {
; GCN-LABEL: s_shl_v2i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_lshl_b64 s[0:1], s[0:1], s4
; GCN-NEXT:    s_lshl_b64 s[2:3], s[2:3], s6
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_v2i64:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_lshl_b64 s[0:1], s[0:1], s4
; GFX10PLUS-NEXT:    s_lshl_b64 s[2:3], s[2:3], s6
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl <2 x i64> %value, %amount
  ret <2 x i64> %result
}

define i65 @v_shl_i65(i65 %value, i65 %amount) {
; GFX6-LABEL: v_shl_i65:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_sub_i32_e32 v4, vcc, 64, v3
; GFX6-NEXT:    v_lshr_b64 v[4:5], v[0:1], v4
; GFX6-NEXT:    v_lshl_b64 v[5:6], v[2:3], v3
; GFX6-NEXT:    v_subrev_i32_e32 v8, vcc, 64, v3
; GFX6-NEXT:    v_lshl_b64 v[6:7], v[0:1], v3
; GFX6-NEXT:    v_or_b32_e32 v9, v4, v5
; GFX6-NEXT:    v_lshl_b64 v[4:5], v[0:1], v8
; GFX6-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v3
; GFX6-NEXT:    v_cndmask_b32_e32 v0, 0, v6, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v7, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v4, v4, v9, vcc
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_shl_i65:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_sub_u32_e32 v4, vcc, 64, v3
; GFX8-NEXT:    v_lshrrev_b64 v[4:5], v4, v[0:1]
; GFX8-NEXT:    v_lshlrev_b64 v[5:6], v3, v[2:3]
; GFX8-NEXT:    v_subrev_u32_e32 v8, vcc, 64, v3
; GFX8-NEXT:    v_lshlrev_b64 v[6:7], v3, v[0:1]
; GFX8-NEXT:    v_or_b32_e32 v9, v4, v5
; GFX8-NEXT:    v_lshlrev_b64 v[4:5], v8, v[0:1]
; GFX8-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, 0, v6, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v7, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v9, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_shl_i65:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_sub_u32_e32 v4, 64, v3
; GFX9-NEXT:    v_lshrrev_b64 v[4:5], v4, v[0:1]
; GFX9-NEXT:    v_lshlrev_b64 v[5:6], v3, v[2:3]
; GFX9-NEXT:    v_subrev_u32_e32 v8, 64, v3
; GFX9-NEXT:    v_lshlrev_b64 v[6:7], v3, v[0:1]
; GFX9-NEXT:    v_or_b32_e32 v9, v4, v5
; GFX9-NEXT:    v_lshlrev_b64 v[4:5], v8, v[0:1]
; GFX9-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v0, 0, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v7, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v4, v9, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_shl_i65:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_sub_nc_u32_e32 v6, 64, v3
; GFX10-NEXT:    v_lshlrev_b64 v[4:5], v3, v[2:3]
; GFX10-NEXT:    v_subrev_nc_u32_e32 v8, 64, v3
; GFX10-NEXT:    v_cmp_gt_u32_e32 vcc_lo, 64, v3
; GFX10-NEXT:    v_lshrrev_b64 v[5:6], v6, v[0:1]
; GFX10-NEXT:    v_lshlrev_b64 v[6:7], v3, v[0:1]
; GFX10-NEXT:    v_lshlrev_b64 v[8:9], v8, v[0:1]
; GFX10-NEXT:    v_or_b32_e32 v1, v5, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0, v6, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v8, v1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v1, 0, v7, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_shl_i65:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_sub_nc_u32_e32 v6, 64, v3
; GFX11-NEXT:    v_lshlrev_b64 v[4:5], v3, v[2:3]
; GFX11-NEXT:    v_subrev_nc_u32_e32 v8, 64, v3
; GFX11-NEXT:    v_cmp_gt_u32_e32 vcc_lo, 64, v3
; GFX11-NEXT:    v_lshrrev_b64 v[5:6], v6, v[0:1]
; GFX11-NEXT:    v_lshlrev_b64 v[6:7], v3, v[0:1]
; GFX11-NEXT:    v_lshlrev_b64 v[8:9], v8, v[0:1]
; GFX11-NEXT:    v_or_b32_e32 v1, v5, v4
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0, v6, vcc_lo
; GFX11-NEXT:    v_dual_cndmask_b32 v4, v8, v1 :: v_dual_cndmask_b32 v1, 0, v7
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %result = shl i65 %value, %amount
  ret i65 %result
}

define i65 @v_shl_i65_33(i65 %value) {
; GFX6-LABEL: v_shl_i65_33:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 1, v0
; GFX6-NEXT:    v_lshr_b64 v[2:3], v[0:1], 31
; GFX6-NEXT:    v_mov_b32_e32 v0, 0
; GFX6-NEXT:    v_mov_b32_e32 v1, v4
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_shl_i65_33:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 1, v0
; GFX8-NEXT:    v_lshrrev_b64 v[2:3], 31, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_shl_i65_33:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 1, v0
; GFX9-NEXT:    v_lshrrev_b64 v[2:3], 31, v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, v4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_shl_i65_33:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 1, v0
; GFX10-NEXT:    v_lshrrev_b64 v[2:3], 31, v[0:1]
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, v4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_shl_i65_33:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 1, v0
; GFX11-NEXT:    v_lshrrev_b64 v[2:3], 31, v[0:1]
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %result = shl i65 %value, 33
  ret i65 %result
}

define amdgpu_ps i65 @s_shl_i65(i65 inreg %value, i65 inreg %amount) {
; GCN-LABEL: s_shl_i65:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_sub_i32 s10, s3, 64
; GCN-NEXT:    s_sub_i32 s6, 64, s3
; GCN-NEXT:    s_cmp_lt_u32 s3, 64
; GCN-NEXT:    s_cselect_b32 s11, 1, 0
; GCN-NEXT:    s_cmp_eq_u32 s3, 0
; GCN-NEXT:    s_cselect_b32 s12, 1, 0
; GCN-NEXT:    s_lshr_b64 s[6:7], s[0:1], s6
; GCN-NEXT:    s_lshl_b64 s[8:9], s[2:3], s3
; GCN-NEXT:    s_lshl_b64 s[4:5], s[0:1], s3
; GCN-NEXT:    s_or_b64 s[6:7], s[6:7], s[8:9]
; GCN-NEXT:    s_lshl_b64 s[8:9], s[0:1], s10
; GCN-NEXT:    s_cmp_lg_u32 s11, 0
; GCN-NEXT:    s_cselect_b64 s[0:1], s[4:5], 0
; GCN-NEXT:    s_cselect_b64 s[4:5], s[6:7], s[8:9]
; GCN-NEXT:    s_cmp_lg_u32 s12, 0
; GCN-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[4:5]
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_i65:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_sub_i32 s10, s3, 64
; GFX10PLUS-NEXT:    s_sub_i32 s4, 64, s3
; GFX10PLUS-NEXT:    s_cmp_lt_u32 s3, 64
; GFX10PLUS-NEXT:    s_cselect_b32 s11, 1, 0
; GFX10PLUS-NEXT:    s_cmp_eq_u32 s3, 0
; GFX10PLUS-NEXT:    s_cselect_b32 s12, 1, 0
; GFX10PLUS-NEXT:    s_lshr_b64 s[4:5], s[0:1], s4
; GFX10PLUS-NEXT:    s_lshl_b64 s[6:7], s[2:3], s3
; GFX10PLUS-NEXT:    s_lshl_b64 s[8:9], s[0:1], s3
; GFX10PLUS-NEXT:    s_or_b64 s[4:5], s[4:5], s[6:7]
; GFX10PLUS-NEXT:    s_lshl_b64 s[6:7], s[0:1], s10
; GFX10PLUS-NEXT:    s_cmp_lg_u32 s11, 0
; GFX10PLUS-NEXT:    s_cselect_b64 s[0:1], s[8:9], 0
; GFX10PLUS-NEXT:    s_cselect_b64 s[4:5], s[4:5], s[6:7]
; GFX10PLUS-NEXT:    s_cmp_lg_u32 s12, 0
; GFX10PLUS-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[4:5]
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i65 %value, %amount
  ret i65 %result
}

define amdgpu_ps i65 @s_shl_i65_33(i65 inreg %value) {
; GCN-LABEL: s_shl_i65_33:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_lshl_b32 s4, s0, 1
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    s_lshl_b32 s7, s2, 1
; GCN-NEXT:    s_lshr_b64 s[0:1], s[0:1], 31
; GCN-NEXT:    s_or_b64 s[2:3], s[6:7], s[0:1]
; GCN-NEXT:    s_mov_b32 s0, 0
; GCN-NEXT:    s_mov_b32 s1, s4
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_shl_i65_33:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_mov_b32 s4, 0
; GFX10PLUS-NEXT:    s_lshl_b32 s5, s2, 1
; GFX10PLUS-NEXT:    s_lshr_b64 s[2:3], s[0:1], 31
; GFX10PLUS-NEXT:    s_lshl_b32 s1, s0, 1
; GFX10PLUS-NEXT:    s_or_b64 s[2:3], s[4:5], s[2:3]
; GFX10PLUS-NEXT:    s_mov_b32 s0, 0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = shl i65 %value, 33
  ret i65 %result
}

; FIXME: Argument lowering asserts
; define <2 x i65> @v_shl_v2i65(<2 x i65> %value, <2 x i65> %amount) {
;   %result = shl <2 x i65> %value, %amount
;   ret <2 x i65> %result
; }

; define amdgpu_ps <2 x i65> @s_shl_v2i65(<2 x i65> inreg %value, <2 x i65> inreg %amount) {
;   %result = shl <2 x i65> %value, %amount
;   ret <2 x i65> %result
; }
