; Tests that `llvm-dis` could disassemble ThinLTO minimized bitcode
; (e.g., bitcode generated by `opt --thin-link-bitcode-file=<minimized-bitcode>`,
;  or `clang -Xclang -fthin-link-bitcode=<minimized-bitcode>`)

; %t.o is the thin-lto ready bitcode, and %t.thinlink.bc is the minimized bitcode. 
; RUN: opt -thinlto-bc %s -thin-link-bitcode-file=%t.thinlink.bc -o %t.o

; With default options, `llvm-dis` returns invalid record for ThinLTO minimized bitcode.
; RUN: not llvm-dis %t.thinlink.bc 2>&1 | FileCheck %s --check-prefix=INVALID-RECORD

; INVALID-RECORD: Invalid record

; Tests that `llvm-dis` could disassemble minimized bitcode with `--print-thinlto-index-only`, and verify its content.
; RUN: llvm-dis --print-thinlto-index-only %t.thinlink.bc -o - | FileCheck %s --check-prefix=DIS

; Tests that `llvm-dis` could disassemble ThinLTO-ready bitcode with `--print-thinlto-index-only`,
; and verify its content.
; RUN: llvm-dis --print-thinlto-index-only %t.o -o - | FileCheck %s --check-prefix=DIS

; DIS: ^0 = module: (path: "{{.*}}thinlto-index-disassembled-by-llvm-dis.ll.tmp
; DIS: ^1 = gv: (name: "aplusb", summaries: (function: (module: ^0, flags: (linkage: external, visibility: default, notEligibleToImport: 0, live: 0, dsoLocal: 0, canAutoHide: 0), insts: 2))) ; guid = 
; DIS: ^2 = blockcount: 1

source_filename = "add.cpp"
target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"
define i32 @aplusb(i32 %a, i32 %b) {
  %add = add i32 %b, %a
  ret i32 %add
}
