# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, List, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._app_service_plans_operations import (
    build_create_or_update_request,
    build_create_or_update_vnet_route_request,
    build_delete_hybrid_connection_request,
    build_delete_request,
    build_delete_vnet_route_request,
    build_get_hybrid_connection_plan_limit_request,
    build_get_hybrid_connection_request,
    build_get_request,
    build_get_route_for_vnet_request,
    build_get_server_farm_skus_request,
    build_get_vnet_from_server_farm_request,
    build_get_vnet_gateway_request,
    build_list_by_resource_group_request,
    build_list_capabilities_request,
    build_list_hybrid_connection_keys_request,
    build_list_hybrid_connections_request,
    build_list_request,
    build_list_routes_for_vnet_request,
    build_list_usages_request,
    build_list_vnets_request,
    build_list_web_apps_by_hybrid_connection_request,
    build_list_web_apps_request,
    build_reboot_worker_request,
    build_restart_web_apps_request,
    build_update_request,
    build_update_vnet_gateway_request,
    build_update_vnet_route_request,
)
from .._vendor import WebSiteManagementClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AppServicePlansOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.web.v2020_06_01.aio.WebSiteManagementClient`'s
        :attr:`app_service_plans` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(self, detailed: Optional[bool] = None, **kwargs: Any) -> AsyncIterable["_models.AppServicePlan"]:
        """Get all App Service plans for a subscription.

        Get all App Service plans for a subscription.

        :param detailed: Specify :code:`<code>true</code>` to return all App Service plan properties.
         The default is :code:`<code>false</code>`, which returns a subset of the properties.
          Retrieval of all properties may increase the API latency. Default value is None.
        :type detailed: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AppServicePlan or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_06_01.models.AppServicePlan]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.AppServicePlanCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    subscription_id=self._config.subscription_id,
                    detailed=detailed,
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("AppServicePlanCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Web/serverfarms"}

    @distributed_trace
    def list_by_resource_group(
        self, resource_group_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.AppServicePlan"]:
        """Get all App Service plans in a resource group.

        Get all App Service plans in a resource group.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AppServicePlan or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_06_01.models.AppServicePlan]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.AppServicePlanCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_by_resource_group.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("AppServicePlanCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_resource_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms"
    }

    @distributed_trace_async
    async def get(self, resource_group_name: str, name: str, **kwargs: Any) -> Optional[_models.AppServicePlan]:
        """Get an App Service plan.

        Get an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppServicePlan or None or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.AppServicePlan or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[Optional[_models.AppServicePlan]] = kwargs.pop("cls", None)

        request = build_get_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("AppServicePlan", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}"
    }

    async def _create_or_update_initial(
        self, resource_group_name: str, name: str, app_service_plan: Union[_models.AppServicePlan, IO], **kwargs: Any
    ) -> _models.AppServicePlan:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AppServicePlan] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(app_service_plan, (IOBase, bytes)):
            _content = app_service_plan
        else:
            _json = self._serialize.body(app_service_plan, "AppServicePlan")

        request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._create_or_update_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("AppServicePlan", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("AppServicePlan", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    _create_or_update_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}"
    }

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        name: str,
        app_service_plan: _models.AppServicePlan,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AppServicePlan]:
        """Creates or updates an App Service Plan.

        Creates or updates an App Service Plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param app_service_plan: Details of the App Service plan. Required.
        :type app_service_plan: ~azure.mgmt.web.v2020_06_01.models.AppServicePlan
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either AppServicePlan or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2020_06_01.models.AppServicePlan]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        name: str,
        app_service_plan: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AppServicePlan]:
        """Creates or updates an App Service Plan.

        Creates or updates an App Service Plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param app_service_plan: Details of the App Service plan. Required.
        :type app_service_plan: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either AppServicePlan or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2020_06_01.models.AppServicePlan]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self, resource_group_name: str, name: str, app_service_plan: Union[_models.AppServicePlan, IO], **kwargs: Any
    ) -> AsyncLROPoller[_models.AppServicePlan]:
        """Creates or updates an App Service Plan.

        Creates or updates an App Service Plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param app_service_plan: Details of the App Service plan. Is either a AppServicePlan type or a
         IO type. Required.
        :type app_service_plan: ~azure.mgmt.web.v2020_06_01.models.AppServicePlan or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either AppServicePlan or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2020_06_01.models.AppServicePlan]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AppServicePlan] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                name=name,
                app_service_plan=app_service_plan,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("AppServicePlan", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_create_or_update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}"
    }

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> None:
        """Delete an App Service plan.

        Delete an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}"
    }

    @overload
    async def update(
        self,
        resource_group_name: str,
        name: str,
        app_service_plan: _models.AppServicePlanPatchResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AppServicePlan:
        """Creates or updates an App Service Plan.

        Creates or updates an App Service Plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param app_service_plan: Details of the App Service plan. Required.
        :type app_service_plan: ~azure.mgmt.web.v2020_06_01.models.AppServicePlanPatchResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppServicePlan or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.AppServicePlan
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        name: str,
        app_service_plan: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AppServicePlan:
        """Creates or updates an App Service Plan.

        Creates or updates an App Service Plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param app_service_plan: Details of the App Service plan. Required.
        :type app_service_plan: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppServicePlan or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.AppServicePlan
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        name: str,
        app_service_plan: Union[_models.AppServicePlanPatchResource, IO],
        **kwargs: Any
    ) -> _models.AppServicePlan:
        """Creates or updates an App Service Plan.

        Creates or updates an App Service Plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param app_service_plan: Details of the App Service plan. Is either a
         AppServicePlanPatchResource type or a IO type. Required.
        :type app_service_plan: ~azure.mgmt.web.v2020_06_01.models.AppServicePlanPatchResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppServicePlan or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.AppServicePlan
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AppServicePlan] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(app_service_plan, (IOBase, bytes)):
            _content = app_service_plan
        else:
            _json = self._serialize.body(app_service_plan, "AppServicePlanPatchResource")

        request = build_update_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("AppServicePlan", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("AppServicePlan", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}"
    }

    @distributed_trace_async
    async def list_capabilities(self, resource_group_name: str, name: str, **kwargs: Any) -> List[_models.Capability]:
        """List all capabilities of an App Service plan.

        List all capabilities of an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Capability or the result of cls(response)
        :rtype: list[~azure.mgmt.web.v2020_06_01.models.Capability]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[List[_models.Capability]] = kwargs.pop("cls", None)

        request = build_list_capabilities_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_capabilities.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[Capability]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_capabilities.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/capabilities"
    }

    @distributed_trace_async
    async def get_hybrid_connection(
        self, resource_group_name: str, name: str, namespace_name: str, relay_name: str, **kwargs: Any
    ) -> _models.HybridConnection:
        """Retrieve a Hybrid Connection in use in an App Service plan.

        Retrieve a Hybrid Connection in use in an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param namespace_name: Name of the Service Bus namespace. Required.
        :type namespace_name: str
        :param relay_name: Name of the Service Bus relay. Required.
        :type relay_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.HybridConnection] = kwargs.pop("cls", None)

        request = build_get_hybrid_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            namespace_name=namespace_name,
            relay_name=relay_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_hybrid_connection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HybridConnection", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_hybrid_connection.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}"
    }

    @distributed_trace_async
    async def delete_hybrid_connection(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, namespace_name: str, relay_name: str, **kwargs: Any
    ) -> None:
        """Delete a Hybrid Connection in use in an App Service plan.

        Delete a Hybrid Connection in use in an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param namespace_name: Name of the Service Bus namespace. Required.
        :type namespace_name: str
        :param relay_name: Name of the Service Bus relay. Required.
        :type relay_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_hybrid_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            namespace_name=namespace_name,
            relay_name=relay_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_hybrid_connection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_hybrid_connection.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}"
    }

    @distributed_trace_async
    async def list_hybrid_connection_keys(
        self, resource_group_name: str, name: str, namespace_name: str, relay_name: str, **kwargs: Any
    ) -> _models.HybridConnectionKey:
        """Get the send key name and value of a Hybrid Connection.

        Get the send key name and value of a Hybrid Connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param namespace_name: The name of the Service Bus namespace. Required.
        :type namespace_name: str
        :param relay_name: The name of the Service Bus relay. Required.
        :type relay_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HybridConnectionKey or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.HybridConnectionKey
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.HybridConnectionKey] = kwargs.pop("cls", None)

        request = build_list_hybrid_connection_keys_request(
            resource_group_name=resource_group_name,
            name=name,
            namespace_name=namespace_name,
            relay_name=relay_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_hybrid_connection_keys.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HybridConnectionKey", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_hybrid_connection_keys.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys"
    }

    @distributed_trace
    def list_web_apps_by_hybrid_connection(
        self, resource_group_name: str, name: str, namespace_name: str, relay_name: str, **kwargs: Any
    ) -> AsyncIterable[str]:
        """Get all apps that use a Hybrid Connection in an App Service Plan.

        Get all apps that use a Hybrid Connection in an App Service Plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param namespace_name: Name of the Hybrid Connection namespace. Required.
        :type namespace_name: str
        :param relay_name: Name of the Hybrid Connection relay. Required.
        :type relay_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either str or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.ResourceCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_web_apps_by_hybrid_connection_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    namespace_name=namespace_name,
                    relay_name=relay_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_web_apps_by_hybrid_connection.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ResourceCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_web_apps_by_hybrid_connection.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/sites"
    }

    @distributed_trace_async
    async def get_hybrid_connection_plan_limit(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.HybridConnectionLimits:
        """Get the maximum number of Hybrid Connections allowed in an App Service plan.

        Get the maximum number of Hybrid Connections allowed in an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HybridConnectionLimits or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.HybridConnectionLimits
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.HybridConnectionLimits] = kwargs.pop("cls", None)

        request = build_get_hybrid_connection_plan_limit_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_hybrid_connection_plan_limit.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HybridConnectionLimits", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_hybrid_connection_plan_limit.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionPlanLimits/limit"
    }

    @distributed_trace
    def list_hybrid_connections(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.HybridConnection"]:
        """Retrieve all Hybrid Connections in use in an App Service plan.

        Retrieve all Hybrid Connections in use in an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either HybridConnection or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_06_01.models.HybridConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.HybridConnectionCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_hybrid_connections_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_hybrid_connections.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("HybridConnectionCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_hybrid_connections.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionRelays"
    }

    @distributed_trace_async
    async def restart_web_apps(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, soft_restart: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """Restart all apps in an App Service plan.

        Restart all apps in an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param soft_restart: Specify :code:`<code>true</code>` to perform a soft restart, applies the
         configuration settings and restarts the apps if necessary. The default is
         :code:`<code>false</code>`, which always restarts and reprovisions the apps. Default value is
         None.
        :type soft_restart: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_restart_web_apps_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            soft_restart=soft_restart,
            api_version=api_version,
            template_url=self.restart_web_apps.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    restart_web_apps.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/restartSites"
    }

    @distributed_trace
    def list_web_apps(
        self,
        resource_group_name: str,
        name: str,
        skip_token: Optional[str] = None,
        filter: Optional[str] = None,
        top: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.Site"]:
        """Get all apps associated with an App Service plan.

        Get all apps associated with an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param skip_token: Skip to a web app in the list of webapps associated with app service plan.
         If specified, the resulting list will contain web apps starting from (including) the skipToken.
         Otherwise, the resulting list contains web apps from the start of the list. Default value is
         None.
        :type skip_token: str
        :param filter: Supported filter: $filter=state eq running. Returns only web apps that are
         currently running. Default value is None.
        :type filter: str
        :param top: List page size. If specified, results are paged. Default value is None.
        :type top: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either Site or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_06_01.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.WebAppCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_web_apps_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    skip_token=skip_token,
                    filter=filter,
                    top=top,
                    api_version=api_version,
                    template_url=self.list_web_apps.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("WebAppCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_web_apps.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/sites"
    }

    @distributed_trace_async
    async def get_server_farm_skus(self, resource_group_name: str, name: str, **kwargs: Any) -> JSON:
        """Gets all selectable SKUs for a given App Service Plan.

        Gets all selectable SKUs for a given App Service Plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of App Service Plan. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JSON or the result of cls(response)
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_get_server_farm_skus_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_server_farm_skus.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("object", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_server_farm_skus.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/skus"
    }

    @distributed_trace
    def list_usages(
        self, resource_group_name: str, name: str, filter: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable["_models.CsmUsageQuota"]:
        """Gets server farm usage information.

        Gets server farm usage information.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of App Service Plan. Required.
        :type name: str
        :param filter: Return only usages/metrics specified in the filter. Filter conforms to odata
         syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2'). Default value is
         None.
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CsmUsageQuota or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_06_01.models.CsmUsageQuota]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.CsmUsageQuotaCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_usages_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    filter=filter,
                    api_version=api_version,
                    template_url=self.list_usages.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("CsmUsageQuotaCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_usages.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/usages"
    }

    @distributed_trace_async
    async def list_vnets(self, resource_group_name: str, name: str, **kwargs: Any) -> List[_models.VnetInfo]:
        """Get all Virtual Networks associated with an App Service plan.

        Get all Virtual Networks associated with an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of VnetInfo or the result of cls(response)
        :rtype: list[~azure.mgmt.web.v2020_06_01.models.VnetInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[List[_models.VnetInfo]] = kwargs.pop("cls", None)

        request = build_list_vnets_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_vnets.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[VnetInfo]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_vnets.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections"
    }

    @distributed_trace_async
    async def get_vnet_from_server_farm(
        self, resource_group_name: str, name: str, vnet_name: str, **kwargs: Any
    ) -> Optional[_models.VnetInfo]:
        """Get a Virtual Network associated with an App Service plan.

        Get a Virtual Network associated with an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param vnet_name: Name of the Virtual Network. Required.
        :type vnet_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: VnetInfo or None or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.VnetInfo or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[Optional[_models.VnetInfo]] = kwargs.pop("cls", None)

        request = build_get_vnet_from_server_farm_request(
            resource_group_name=resource_group_name,
            name=name,
            vnet_name=vnet_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_vnet_from_server_farm.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("VnetInfo", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_vnet_from_server_farm.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}"
    }

    @distributed_trace_async
    async def get_vnet_gateway(
        self, resource_group_name: str, name: str, vnet_name: str, gateway_name: str, **kwargs: Any
    ) -> _models.VnetGateway:
        """Get a Virtual Network gateway.

        Get a Virtual Network gateway.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param vnet_name: Name of the Virtual Network. Required.
        :type vnet_name: str
        :param gateway_name: Name of the gateway. Only the 'primary' gateway is supported. Required.
        :type gateway_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: VnetGateway or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.VnetGateway
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[_models.VnetGateway] = kwargs.pop("cls", None)

        request = build_get_vnet_gateway_request(
            resource_group_name=resource_group_name,
            name=name,
            vnet_name=vnet_name,
            gateway_name=gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_vnet_gateway.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("VnetGateway", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_vnet_gateway.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}"
    }

    @overload
    async def update_vnet_gateway(
        self,
        resource_group_name: str,
        name: str,
        vnet_name: str,
        gateway_name: str,
        connection_envelope: _models.VnetGateway,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.VnetGateway:
        """Update a Virtual Network gateway.

        Update a Virtual Network gateway.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param vnet_name: Name of the Virtual Network. Required.
        :type vnet_name: str
        :param gateway_name: Name of the gateway. Only the 'primary' gateway is supported. Required.
        :type gateway_name: str
        :param connection_envelope: Definition of the gateway. Required.
        :type connection_envelope: ~azure.mgmt.web.v2020_06_01.models.VnetGateway
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: VnetGateway or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.VnetGateway
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_vnet_gateway(
        self,
        resource_group_name: str,
        name: str,
        vnet_name: str,
        gateway_name: str,
        connection_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.VnetGateway:
        """Update a Virtual Network gateway.

        Update a Virtual Network gateway.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param vnet_name: Name of the Virtual Network. Required.
        :type vnet_name: str
        :param gateway_name: Name of the gateway. Only the 'primary' gateway is supported. Required.
        :type gateway_name: str
        :param connection_envelope: Definition of the gateway. Required.
        :type connection_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: VnetGateway or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.VnetGateway
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_vnet_gateway(
        self,
        resource_group_name: str,
        name: str,
        vnet_name: str,
        gateway_name: str,
        connection_envelope: Union[_models.VnetGateway, IO],
        **kwargs: Any
    ) -> _models.VnetGateway:
        """Update a Virtual Network gateway.

        Update a Virtual Network gateway.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param vnet_name: Name of the Virtual Network. Required.
        :type vnet_name: str
        :param gateway_name: Name of the gateway. Only the 'primary' gateway is supported. Required.
        :type gateway_name: str
        :param connection_envelope: Definition of the gateway. Is either a VnetGateway type or a IO
         type. Required.
        :type connection_envelope: ~azure.mgmt.web.v2020_06_01.models.VnetGateway or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: VnetGateway or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.VnetGateway
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VnetGateway] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_envelope, (IOBase, bytes)):
            _content = connection_envelope
        else:
            _json = self._serialize.body(connection_envelope, "VnetGateway")

        request = build_update_vnet_gateway_request(
            resource_group_name=resource_group_name,
            name=name,
            vnet_name=vnet_name,
            gateway_name=gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_vnet_gateway.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("VnetGateway", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_vnet_gateway.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}"
    }

    @distributed_trace_async
    async def list_routes_for_vnet(
        self, resource_group_name: str, name: str, vnet_name: str, **kwargs: Any
    ) -> List[_models.VnetRoute]:
        """Get all routes that are associated with a Virtual Network in an App Service plan.

        Get all routes that are associated with a Virtual Network in an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param vnet_name: Name of the Virtual Network. Required.
        :type vnet_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of VnetRoute or the result of cls(response)
        :rtype: list[~azure.mgmt.web.v2020_06_01.models.VnetRoute]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[List[_models.VnetRoute]] = kwargs.pop("cls", None)

        request = build_list_routes_for_vnet_request(
            resource_group_name=resource_group_name,
            name=name,
            vnet_name=vnet_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_routes_for_vnet.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[VnetRoute]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_routes_for_vnet.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes"
    }

    @distributed_trace_async
    async def get_route_for_vnet(
        self, resource_group_name: str, name: str, vnet_name: str, route_name: str, **kwargs: Any
    ) -> Optional[List[_models.VnetRoute]]:
        """Get a Virtual Network route in an App Service plan.

        Get a Virtual Network route in an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param vnet_name: Name of the Virtual Network. Required.
        :type vnet_name: str
        :param route_name: Name of the Virtual Network route. Required.
        :type route_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of VnetRoute or None or the result of cls(response)
        :rtype: list[~azure.mgmt.web.v2020_06_01.models.VnetRoute] or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[Optional[List[_models.VnetRoute]]] = kwargs.pop("cls", None)

        request = build_get_route_for_vnet_request(
            resource_group_name=resource_group_name,
            name=name,
            vnet_name=vnet_name,
            route_name=route_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_route_for_vnet.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("[VnetRoute]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_route_for_vnet.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}"
    }

    @overload
    async def create_or_update_vnet_route(
        self,
        resource_group_name: str,
        name: str,
        vnet_name: str,
        route_name: str,
        route: _models.VnetRoute,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Optional[_models.VnetRoute]:
        """Create or update a Virtual Network route in an App Service plan.

        Create or update a Virtual Network route in an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param vnet_name: Name of the Virtual Network. Required.
        :type vnet_name: str
        :param route_name: Name of the Virtual Network route. Required.
        :type route_name: str
        :param route: Definition of the Virtual Network route. Required.
        :type route: ~azure.mgmt.web.v2020_06_01.models.VnetRoute
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: VnetRoute or None or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.VnetRoute or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_vnet_route(
        self,
        resource_group_name: str,
        name: str,
        vnet_name: str,
        route_name: str,
        route: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Optional[_models.VnetRoute]:
        """Create or update a Virtual Network route in an App Service plan.

        Create or update a Virtual Network route in an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param vnet_name: Name of the Virtual Network. Required.
        :type vnet_name: str
        :param route_name: Name of the Virtual Network route. Required.
        :type route_name: str
        :param route: Definition of the Virtual Network route. Required.
        :type route: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: VnetRoute or None or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.VnetRoute or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_vnet_route(
        self,
        resource_group_name: str,
        name: str,
        vnet_name: str,
        route_name: str,
        route: Union[_models.VnetRoute, IO],
        **kwargs: Any
    ) -> Optional[_models.VnetRoute]:
        """Create or update a Virtual Network route in an App Service plan.

        Create or update a Virtual Network route in an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param vnet_name: Name of the Virtual Network. Required.
        :type vnet_name: str
        :param route_name: Name of the Virtual Network route. Required.
        :type route_name: str
        :param route: Definition of the Virtual Network route. Is either a VnetRoute type or a IO type.
         Required.
        :type route: ~azure.mgmt.web.v2020_06_01.models.VnetRoute or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: VnetRoute or None or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.VnetRoute or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.VnetRoute]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(route, (IOBase, bytes)):
            _content = route
        else:
            _json = self._serialize.body(route, "VnetRoute")

        request = build_create_or_update_vnet_route_request(
            resource_group_name=resource_group_name,
            name=name,
            vnet_name=vnet_name,
            route_name=route_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_vnet_route.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("VnetRoute", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_vnet_route.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}"
    }

    @distributed_trace_async
    async def delete_vnet_route(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, vnet_name: str, route_name: str, **kwargs: Any
    ) -> None:
        """Delete a Virtual Network route in an App Service plan.

        Delete a Virtual Network route in an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param vnet_name: Name of the Virtual Network. Required.
        :type vnet_name: str
        :param route_name: Name of the Virtual Network route. Required.
        :type route_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_vnet_route_request(
            resource_group_name=resource_group_name,
            name=name,
            vnet_name=vnet_name,
            route_name=route_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_vnet_route.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_vnet_route.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}"
    }

    @overload
    async def update_vnet_route(
        self,
        resource_group_name: str,
        name: str,
        vnet_name: str,
        route_name: str,
        route: _models.VnetRoute,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Optional[_models.VnetRoute]:
        """Create or update a Virtual Network route in an App Service plan.

        Create or update a Virtual Network route in an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param vnet_name: Name of the Virtual Network. Required.
        :type vnet_name: str
        :param route_name: Name of the Virtual Network route. Required.
        :type route_name: str
        :param route: Definition of the Virtual Network route. Required.
        :type route: ~azure.mgmt.web.v2020_06_01.models.VnetRoute
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: VnetRoute or None or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.VnetRoute or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_vnet_route(
        self,
        resource_group_name: str,
        name: str,
        vnet_name: str,
        route_name: str,
        route: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Optional[_models.VnetRoute]:
        """Create or update a Virtual Network route in an App Service plan.

        Create or update a Virtual Network route in an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param vnet_name: Name of the Virtual Network. Required.
        :type vnet_name: str
        :param route_name: Name of the Virtual Network route. Required.
        :type route_name: str
        :param route: Definition of the Virtual Network route. Required.
        :type route: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: VnetRoute or None or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.VnetRoute or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_vnet_route(
        self,
        resource_group_name: str,
        name: str,
        vnet_name: str,
        route_name: str,
        route: Union[_models.VnetRoute, IO],
        **kwargs: Any
    ) -> Optional[_models.VnetRoute]:
        """Create or update a Virtual Network route in an App Service plan.

        Create or update a Virtual Network route in an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param vnet_name: Name of the Virtual Network. Required.
        :type vnet_name: str
        :param route_name: Name of the Virtual Network route. Required.
        :type route_name: str
        :param route: Definition of the Virtual Network route. Is either a VnetRoute type or a IO type.
         Required.
        :type route: ~azure.mgmt.web.v2020_06_01.models.VnetRoute or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: VnetRoute or None or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_06_01.models.VnetRoute or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.VnetRoute]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(route, (IOBase, bytes)):
            _content = route
        else:
            _json = self._serialize.body(route, "VnetRoute")

        request = build_update_vnet_route_request(
            resource_group_name=resource_group_name,
            name=name,
            vnet_name=vnet_name,
            route_name=route_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_vnet_route.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("VnetRoute", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_vnet_route.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}"
    }

    @distributed_trace_async
    async def reboot_worker(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, worker_name: str, **kwargs: Any
    ) -> None:
        """Reboot a worker machine in an App Service plan.

        Reboot a worker machine in an App Service plan.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the App Service plan. Required.
        :type name: str
        :param worker_name: Name of worker machine, which typically starts with RD. Required.
        :type worker_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2020-06-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_reboot_worker_request(
            resource_group_name=resource_group_name,
            name=name,
            worker_name=worker_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.reboot_worker.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    reboot_worker.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/workers/{workerName}/reboot"
    }
