# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._monitor_management_client_enums import *


class Action(msrest.serialization.Model):
    """Action descriptor.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AlertingAction, LogToMetricAction.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Specifies the action. Supported values - AlertingAction,
     LogToMetricAction.Constant filled by server.
    :vartype odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.AlertingAction': 'AlertingAction', 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.LogToMetricAction': 'LogToMetricAction'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Action, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class AlertingAction(Action):
    """Specify action need to be taken when rule type is Alert.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Specifies the action. Supported values - AlertingAction,
     LogToMetricAction.Constant filled by server.
    :vartype odata_type: str
    :ivar severity: Required. Severity of the alert. Possible values include: "0", "1", "2", "3",
     "4".
    :vartype severity: str or ~$(python-base-namespace).v2018_04_16.models.AlertSeverity
    :ivar azns_action: Azure action group reference.
    :vartype azns_action: ~$(python-base-namespace).v2018_04_16.models.AzNsActionGroup
    :ivar throttling_in_min: time (in minutes) for which Alerts should be throttled or suppressed.
    :vartype throttling_in_min: int
    :ivar trigger: Required. The trigger condition that results in the alert rule being.
    :vartype trigger: ~$(python-base-namespace).v2018_04_16.models.TriggerCondition
    """

    _validation = {
        'odata_type': {'required': True},
        'severity': {'required': True},
        'trigger': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'azns_action': {'key': 'aznsAction', 'type': 'AzNsActionGroup'},
        'throttling_in_min': {'key': 'throttlingInMin', 'type': 'int'},
        'trigger': {'key': 'trigger', 'type': 'TriggerCondition'},
    }

    def __init__(
        self,
        *,
        severity: Union[str, "AlertSeverity"],
        trigger: "TriggerCondition",
        azns_action: Optional["AzNsActionGroup"] = None,
        throttling_in_min: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword severity: Required. Severity of the alert. Possible values include: "0", "1", "2",
         "3", "4".
        :paramtype severity: str or ~$(python-base-namespace).v2018_04_16.models.AlertSeverity
        :keyword azns_action: Azure action group reference.
        :paramtype azns_action: ~$(python-base-namespace).v2018_04_16.models.AzNsActionGroup
        :keyword throttling_in_min: time (in minutes) for which Alerts should be throttled or
         suppressed.
        :paramtype throttling_in_min: int
        :keyword trigger: Required. The trigger condition that results in the alert rule being.
        :paramtype trigger: ~$(python-base-namespace).v2018_04_16.models.TriggerCondition
        """
        super(AlertingAction, self).__init__(**kwargs)
        self.odata_type = 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.AlertingAction'  # type: str
        self.severity = severity
        self.azns_action = azns_action
        self.throttling_in_min = throttling_in_min
        self.trigger = trigger


class AzNsActionGroup(msrest.serialization.Model):
    """Azure action group.

    :ivar action_group: Azure Action Group reference.
    :vartype action_group: list[str]
    :ivar email_subject: Custom subject override for all email ids in Azure action group.
    :vartype email_subject: str
    :ivar custom_webhook_payload: Custom payload to be sent for all webhook URI in Azure action
     group.
    :vartype custom_webhook_payload: str
    """

    _attribute_map = {
        'action_group': {'key': 'actionGroup', 'type': '[str]'},
        'email_subject': {'key': 'emailSubject', 'type': 'str'},
        'custom_webhook_payload': {'key': 'customWebhookPayload', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        action_group: Optional[List[str]] = None,
        email_subject: Optional[str] = None,
        custom_webhook_payload: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword action_group: Azure Action Group reference.
        :paramtype action_group: list[str]
        :keyword email_subject: Custom subject override for all email ids in Azure action group.
        :paramtype email_subject: str
        :keyword custom_webhook_payload: Custom payload to be sent for all webhook URI in Azure action
         group.
        :paramtype custom_webhook_payload: str
        """
        super(AzNsActionGroup, self).__init__(**kwargs)
        self.action_group = action_group
        self.email_subject = email_subject
        self.custom_webhook_payload = custom_webhook_payload


class Criteria(msrest.serialization.Model):
    """Specifies the criteria for converting log to metric.

    All required parameters must be populated in order to send to Azure.

    :ivar metric_name: Required. Name of the metric.
    :vartype metric_name: str
    :ivar dimensions: List of Dimensions for creating metric.
    :vartype dimensions: list[~$(python-base-namespace).v2018_04_16.models.Dimension]
    """

    _validation = {
        'metric_name': {'required': True},
    }

    _attribute_map = {
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
    }

    def __init__(
        self,
        *,
        metric_name: str,
        dimensions: Optional[List["Dimension"]] = None,
        **kwargs
    ):
        """
        :keyword metric_name: Required. Name of the metric.
        :paramtype metric_name: str
        :keyword dimensions: List of Dimensions for creating metric.
        :paramtype dimensions: list[~$(python-base-namespace).v2018_04_16.models.Dimension]
        """
        super(Criteria, self).__init__(**kwargs)
        self.metric_name = metric_name
        self.dimensions = dimensions


class Dimension(msrest.serialization.Model):
    """Specifies the criteria for converting log to metric.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Name of the dimension.
    :vartype name: str
    :ivar operator: Required. Operator for dimension values. Possible values include: "Include".
    :vartype operator: str or ~$(python-base-namespace).v2018_04_16.models.Operator
    :ivar values: Required. List of dimension values.
    :vartype values: list[str]
    """

    _validation = {
        'name': {'required': True},
        'operator': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        operator: Union[str, "Operator"],
        values: List[str],
        **kwargs
    ):
        """
        :keyword name: Required. Name of the dimension.
        :paramtype name: str
        :keyword operator: Required. Operator for dimension values. Possible values include: "Include".
        :paramtype operator: str or ~$(python-base-namespace).v2018_04_16.models.Operator
        :keyword values: Required. List of dimension values.
        :paramtype values: list[str]
        """
        super(Dimension, self).__init__(**kwargs)
        self.name = name
        self.operator = operator
        self.values = values


class ErrorContract(msrest.serialization.Model):
    """Describes the format of Error response.

    :ivar error: The error details.
    :vartype error: ~$(python-base-namespace).v2018_04_16.models.ErrorResponse
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorResponse"] = None,
        **kwargs
    ):
        """
        :keyword error: The error details.
        :paramtype error: ~$(python-base-namespace).v2018_04_16.models.ErrorResponse
        """
        super(ErrorContract, self).__init__(**kwargs)
        self.error = error


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class LogMetricTrigger(msrest.serialization.Model):
    """A log metrics trigger descriptor.

    :ivar threshold_operator: Evaluation operation for Metric -'GreaterThan' or 'LessThan' or
     'Equal'. Possible values include: "GreaterThanOrEqual", "LessThanOrEqual", "GreaterThan",
     "LessThan", "Equal". Default value: "GreaterThanOrEqual".
    :vartype threshold_operator: str or
     ~$(python-base-namespace).v2018_04_16.models.ConditionalOperator
    :ivar threshold: The threshold of the metric trigger.
    :vartype threshold: float
    :ivar metric_trigger_type: Metric Trigger Type - 'Consecutive' or 'Total'. Possible values
     include: "Consecutive", "Total". Default value: "Consecutive".
    :vartype metric_trigger_type: str or
     ~$(python-base-namespace).v2018_04_16.models.MetricTriggerType
    :ivar metric_column: Evaluation of metric on a particular column.
    :vartype metric_column: str
    """

    _attribute_map = {
        'threshold_operator': {'key': 'thresholdOperator', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'float'},
        'metric_trigger_type': {'key': 'metricTriggerType', 'type': 'str'},
        'metric_column': {'key': 'metricColumn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        threshold_operator: Optional[Union[str, "ConditionalOperator"]] = "GreaterThanOrEqual",
        threshold: Optional[float] = None,
        metric_trigger_type: Optional[Union[str, "MetricTriggerType"]] = "Consecutive",
        metric_column: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword threshold_operator: Evaluation operation for Metric -'GreaterThan' or 'LessThan' or
         'Equal'. Possible values include: "GreaterThanOrEqual", "LessThanOrEqual", "GreaterThan",
         "LessThan", "Equal". Default value: "GreaterThanOrEqual".
        :paramtype threshold_operator: str or
         ~$(python-base-namespace).v2018_04_16.models.ConditionalOperator
        :keyword threshold: The threshold of the metric trigger.
        :paramtype threshold: float
        :keyword metric_trigger_type: Metric Trigger Type - 'Consecutive' or 'Total'. Possible values
         include: "Consecutive", "Total". Default value: "Consecutive".
        :paramtype metric_trigger_type: str or
         ~$(python-base-namespace).v2018_04_16.models.MetricTriggerType
        :keyword metric_column: Evaluation of metric on a particular column.
        :paramtype metric_column: str
        """
        super(LogMetricTrigger, self).__init__(**kwargs)
        self.threshold_operator = threshold_operator
        self.threshold = threshold
        self.metric_trigger_type = metric_trigger_type
        self.metric_column = metric_column


class Resource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :vartype kind: str
    :ivar etag: The etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal etag convention.  Entity tags are used for
     comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in
     the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
     (section 14.27) header fields.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.kind = None
        self.etag = None


class LogSearchRuleResource(Resource):
    """The Log Search Rule resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :vartype kind: str
    :ivar etag: The etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal etag convention.  Entity tags are used for
     comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in
     the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
     (section 14.27) header fields.
    :vartype etag: str
    :ivar created_with_api_version: The api-version used when creating this alert rule.
    :vartype created_with_api_version: str
    :ivar is_legacy_log_analytics_rule: True if alert rule is legacy Log Analytic rule.
    :vartype is_legacy_log_analytics_rule: bool
    :ivar description: The description of the Log Search rule.
    :vartype description: str
    :ivar display_name: The display name of the alert rule.
    :vartype display_name: str
    :ivar auto_mitigate: The flag that indicates whether the alert should be automatically resolved
     or not. The default is false.
    :vartype auto_mitigate: bool
    :ivar enabled: The flag which indicates whether the Log Search rule is enabled. Value should be
     true or false. Possible values include: "true", "false".
    :vartype enabled: str or ~$(python-base-namespace).v2018_04_16.models.Enabled
    :ivar last_updated_time: Last time the rule was updated in IS08601 format.
    :vartype last_updated_time: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the scheduled query rule. Possible values
     include: "Succeeded", "Deploying", "Canceled", "Failed".
    :vartype provisioning_state: str or
     ~$(python-base-namespace).v2018_04_16.models.ProvisioningState
    :ivar source: Required. Data Source against which rule will Query Data.
    :vartype source: ~$(python-base-namespace).v2018_04_16.models.Source
    :ivar schedule: Schedule (Frequency, Time Window) for rule. Required for action type -
     AlertingAction.
    :vartype schedule: ~$(python-base-namespace).v2018_04_16.models.Schedule
    :ivar action: Required. Action needs to be taken on rule execution.
    :vartype action: ~$(python-base-namespace).v2018_04_16.models.Action
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'readonly': True},
        'etag': {'readonly': True},
        'created_with_api_version': {'readonly': True},
        'is_legacy_log_analytics_rule': {'readonly': True},
        'last_updated_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'source': {'required': True},
        'action': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'created_with_api_version': {'key': 'properties.createdWithApiVersion', 'type': 'str'},
        'is_legacy_log_analytics_rule': {'key': 'properties.isLegacyLogAnalyticsRule', 'type': 'bool'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'auto_mitigate': {'key': 'properties.autoMitigate', 'type': 'bool'},
        'enabled': {'key': 'properties.enabled', 'type': 'str'},
        'last_updated_time': {'key': 'properties.lastUpdatedTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'Source'},
        'schedule': {'key': 'properties.schedule', 'type': 'Schedule'},
        'action': {'key': 'properties.action', 'type': 'Action'},
    }

    def __init__(
        self,
        *,
        location: str,
        source: "Source",
        action: "Action",
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        auto_mitigate: Optional[bool] = False,
        enabled: Optional[Union[str, "Enabled"]] = None,
        schedule: Optional["Schedule"] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of the Log Search rule.
        :paramtype description: str
        :keyword display_name: The display name of the alert rule.
        :paramtype display_name: str
        :keyword auto_mitigate: The flag that indicates whether the alert should be automatically
         resolved or not. The default is false.
        :paramtype auto_mitigate: bool
        :keyword enabled: The flag which indicates whether the Log Search rule is enabled. Value should
         be true or false. Possible values include: "true", "false".
        :paramtype enabled: str or ~$(python-base-namespace).v2018_04_16.models.Enabled
        :keyword source: Required. Data Source against which rule will Query Data.
        :paramtype source: ~$(python-base-namespace).v2018_04_16.models.Source
        :keyword schedule: Schedule (Frequency, Time Window) for rule. Required for action type -
         AlertingAction.
        :paramtype schedule: ~$(python-base-namespace).v2018_04_16.models.Schedule
        :keyword action: Required. Action needs to be taken on rule execution.
        :paramtype action: ~$(python-base-namespace).v2018_04_16.models.Action
        """
        super(LogSearchRuleResource, self).__init__(location=location, tags=tags, **kwargs)
        self.created_with_api_version = None
        self.is_legacy_log_analytics_rule = None
        self.description = description
        self.display_name = display_name
        self.auto_mitigate = auto_mitigate
        self.enabled = enabled
        self.last_updated_time = None
        self.provisioning_state = None
        self.source = source
        self.schedule = schedule
        self.action = action


class LogSearchRuleResourceCollection(msrest.serialization.Model):
    """Represents a collection of Log Search rule resources.

    :ivar value: The values for the Log Search Rule resources.
    :vartype value: list[~$(python-base-namespace).v2018_04_16.models.LogSearchRuleResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LogSearchRuleResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["LogSearchRuleResource"]] = None,
        **kwargs
    ):
        """
        :keyword value: The values for the Log Search Rule resources.
        :paramtype value: list[~$(python-base-namespace).v2018_04_16.models.LogSearchRuleResource]
        """
        super(LogSearchRuleResourceCollection, self).__init__(**kwargs)
        self.value = value


class LogSearchRuleResourcePatch(msrest.serialization.Model):
    """The log search rule resource for patch operations.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar enabled: The flag which indicates whether the Log Search rule is enabled. Value should be
     true or false. Possible values include: "true", "false".
    :vartype enabled: str or ~$(python-base-namespace).v2018_04_16.models.Enabled
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'enabled': {'key': 'properties.enabled', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        enabled: Optional[Union[str, "Enabled"]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword enabled: The flag which indicates whether the Log Search rule is enabled. Value should
         be true or false. Possible values include: "true", "false".
        :paramtype enabled: str or ~$(python-base-namespace).v2018_04_16.models.Enabled
        """
        super(LogSearchRuleResourcePatch, self).__init__(**kwargs)
        self.tags = tags
        self.enabled = enabled


class LogToMetricAction(Action):
    """Specify action need to be taken when rule type is converting log to metric.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Specifies the action. Supported values - AlertingAction,
     LogToMetricAction.Constant filled by server.
    :vartype odata_type: str
    :ivar criteria: Required. Criteria of Metric.
    :vartype criteria: list[~$(python-base-namespace).v2018_04_16.models.Criteria]
    """

    _validation = {
        'odata_type': {'required': True},
        'criteria': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'criteria': {'key': 'criteria', 'type': '[Criteria]'},
    }

    def __init__(
        self,
        *,
        criteria: List["Criteria"],
        **kwargs
    ):
        """
        :keyword criteria: Required. Criteria of Metric.
        :paramtype criteria: list[~$(python-base-namespace).v2018_04_16.models.Criteria]
        """
        super(LogToMetricAction, self).__init__(**kwargs)
        self.odata_type = 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.LogToMetricAction'  # type: str
        self.criteria = criteria


class Schedule(msrest.serialization.Model):
    """Defines how often to run the search and the time interval.

    All required parameters must be populated in order to send to Azure.

    :ivar frequency_in_minutes: Required. frequency (in minutes) at which rule condition should be
     evaluated.
    :vartype frequency_in_minutes: int
    :ivar time_window_in_minutes: Required. Time window for which data needs to be fetched for
     query (should be greater than or equal to frequencyInMinutes).
    :vartype time_window_in_minutes: int
    """

    _validation = {
        'frequency_in_minutes': {'required': True},
        'time_window_in_minutes': {'required': True},
    }

    _attribute_map = {
        'frequency_in_minutes': {'key': 'frequencyInMinutes', 'type': 'int'},
        'time_window_in_minutes': {'key': 'timeWindowInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        frequency_in_minutes: int,
        time_window_in_minutes: int,
        **kwargs
    ):
        """
        :keyword frequency_in_minutes: Required. frequency (in minutes) at which rule condition should
         be evaluated.
        :paramtype frequency_in_minutes: int
        :keyword time_window_in_minutes: Required. Time window for which data needs to be fetched for
         query (should be greater than or equal to frequencyInMinutes).
        :paramtype time_window_in_minutes: int
        """
        super(Schedule, self).__init__(**kwargs)
        self.frequency_in_minutes = frequency_in_minutes
        self.time_window_in_minutes = time_window_in_minutes


class Source(msrest.serialization.Model):
    """Specifies the log search query.

    All required parameters must be populated in order to send to Azure.

    :ivar query: Log search query. Required for action type - AlertingAction.
    :vartype query: str
    :ivar authorized_resources: List of  Resource referred into query.
    :vartype authorized_resources: list[str]
    :ivar data_source_id: Required. The resource uri over which log search query is to be run.
    :vartype data_source_id: str
    :ivar query_type: Set value to 'ResultCount' . Possible values include: "ResultCount".
    :vartype query_type: str or ~$(python-base-namespace).v2018_04_16.models.QueryType
    """

    _validation = {
        'data_source_id': {'required': True},
    }

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'authorized_resources': {'key': 'authorizedResources', 'type': '[str]'},
        'data_source_id': {'key': 'dataSourceId', 'type': 'str'},
        'query_type': {'key': 'queryType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_source_id: str,
        query: Optional[str] = None,
        authorized_resources: Optional[List[str]] = None,
        query_type: Optional[Union[str, "QueryType"]] = None,
        **kwargs
    ):
        """
        :keyword query: Log search query. Required for action type - AlertingAction.
        :paramtype query: str
        :keyword authorized_resources: List of  Resource referred into query.
        :paramtype authorized_resources: list[str]
        :keyword data_source_id: Required. The resource uri over which log search query is to be run.
        :paramtype data_source_id: str
        :keyword query_type: Set value to 'ResultCount' . Possible values include: "ResultCount".
        :paramtype query_type: str or ~$(python-base-namespace).v2018_04_16.models.QueryType
        """
        super(Source, self).__init__(**kwargs)
        self.query = query
        self.authorized_resources = authorized_resources
        self.data_source_id = data_source_id
        self.query_type = query_type


class TriggerCondition(msrest.serialization.Model):
    """The condition that results in the Log Search rule.

    All required parameters must be populated in order to send to Azure.

    :ivar threshold_operator: Required. Evaluation operation for rule - 'GreaterThan' or 'LessThan.
     Possible values include: "GreaterThanOrEqual", "LessThanOrEqual", "GreaterThan", "LessThan",
     "Equal". Default value: "GreaterThanOrEqual".
    :vartype threshold_operator: str or
     ~$(python-base-namespace).v2018_04_16.models.ConditionalOperator
    :ivar threshold: Required. Result or count threshold based on which rule should be triggered.
    :vartype threshold: float
    :ivar metric_trigger: Trigger condition for metric query rule.
    :vartype metric_trigger: ~$(python-base-namespace).v2018_04_16.models.LogMetricTrigger
    """

    _validation = {
        'threshold_operator': {'required': True},
        'threshold': {'required': True},
    }

    _attribute_map = {
        'threshold_operator': {'key': 'thresholdOperator', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'float'},
        'metric_trigger': {'key': 'metricTrigger', 'type': 'LogMetricTrigger'},
    }

    def __init__(
        self,
        *,
        threshold_operator: Union[str, "ConditionalOperator"] = "GreaterThanOrEqual",
        threshold: float,
        metric_trigger: Optional["LogMetricTrigger"] = None,
        **kwargs
    ):
        """
        :keyword threshold_operator: Required. Evaluation operation for rule - 'GreaterThan' or
         'LessThan. Possible values include: "GreaterThanOrEqual", "LessThanOrEqual", "GreaterThan",
         "LessThan", "Equal". Default value: "GreaterThanOrEqual".
        :paramtype threshold_operator: str or
         ~$(python-base-namespace).v2018_04_16.models.ConditionalOperator
        :keyword threshold: Required. Result or count threshold based on which rule should be
         triggered.
        :paramtype threshold: float
        :keyword metric_trigger: Trigger condition for metric query rule.
        :paramtype metric_trigger: ~$(python-base-namespace).v2018_04_16.models.LogMetricTrigger
        """
        super(TriggerCondition, self).__init__(**kwargs)
        self.threshold_operator = threshold_operator
        self.threshold = threshold
        self.metric_trigger = metric_trigger
