/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.matcher;

import fr.jayasoft.ivy.matcher.AnyMatcher;
import fr.jayasoft.ivy.matcher.Matcher;
import fr.jayasoft.ivy.matcher.PatternMatcher;
import java.util.regex.Pattern;

public final class RegexpPatternMatcher
implements PatternMatcher {
    private static final RegexpPatternMatcher INSTANCE = new RegexpPatternMatcher();

    public static PatternMatcher getInstance() {
        return INSTANCE;
    }

    private RegexpPatternMatcher() {
    }

    public boolean match(String str, String exp) {
        if (exp == null) {
            return str == null;
        }
        return Pattern.matches(exp, str);
    }

    public String getName() {
        return "regexp";
    }

    public Matcher getMatcher(String exp) {
        if ("*".equals(exp)) {
            return AnyMatcher.getInstance();
        }
        return new RegexpMatcher(exp);
    }

    public static class RegexpMatcher
    implements Matcher {
        private Pattern _p;

        public RegexpMatcher(String exp) {
            this._p = Pattern.compile(exp);
        }

        public boolean matches(String str) {
            return this._p.matcher(str).matches();
        }

        public boolean isExact() {
            return false;
        }
    }
}

