
// This file is generated by utils/generate-downcast.py.

// Background is provided at http://nickdarnell.com/swig-casting-revisited/
// and https://github.com/swig/swig/blob/master/Lib/typemaps/factory.swg.

// In most cases the downcast is not required since polymorphism is handled in
// C++. But if you e.g. extend the Device classes in Ruby it is required.

// Order of classes is crucial: The first one wins so the most derived class
// must be first, e.g. Luks before Encryption. Abstract classes should not be
// listed.

%include "factory.i"

%factory(storage::Device* storage::downcast,
	 storage::BcacheCset,
	 storage::BitlockerV2,
	 storage::Luks,
	 storage::PlainEncryption,
	 storage::Encryption,
	 storage::LvmLv,
	 storage::Partition,
	 storage::Bcache,
	 storage::Dasd,
	 storage::Disk,
	 storage::DmRaid,
	 storage::MdContainer,
	 storage::MdMember,
	 storage::Md,
	 storage::Multipath,
	 storage::Partitionable,
	 storage::StrayBlkDevice,
	 storage::BlkDevice,
	 storage::BtrfsQgroup,
	 storage::LvmPv,
	 storage::LvmVg,
	 storage::MountPoint,
	 storage::BtrfsSubvolume,
	 storage::Bitlocker,
	 storage::Btrfs,
	 storage::Exfat,
	 storage::Ext2,
	 storage::Ext3,
	 storage::Ext4,
	 storage::Ext,
	 storage::F2fs,
	 storage::Iso9660,
	 storage::Jfs,
	 storage::Nilfs2,
	 storage::Ntfs,
	 storage::Reiserfs,
	 storage::Swap,
	 storage::Udf,
	 storage::Vfat,
	 storage::Xfs,
	 storage::BlkFilesystem,
	 storage::Nfs,
	 storage::Tmpfs,
	 storage::Filesystem,
	 storage::Mountable,
	 storage::DasdPt,
	 storage::Gpt,
	 storage::ImplicitPt,
	 storage::Msdos,
	 storage::PartitionTable,
	 storage::Device)

%factory(const storage::Device* storage::downcast,
	 const storage::BcacheCset,
	 const storage::BitlockerV2,
	 const storage::Luks,
	 const storage::PlainEncryption,
	 const storage::Encryption,
	 const storage::LvmLv,
	 const storage::Partition,
	 const storage::Bcache,
	 const storage::Dasd,
	 const storage::Disk,
	 const storage::DmRaid,
	 const storage::MdContainer,
	 const storage::MdMember,
	 const storage::Md,
	 const storage::Multipath,
	 const storage::Partitionable,
	 const storage::StrayBlkDevice,
	 const storage::BlkDevice,
	 const storage::BtrfsQgroup,
	 const storage::LvmPv,
	 const storage::LvmVg,
	 const storage::MountPoint,
	 const storage::BtrfsSubvolume,
	 const storage::Bitlocker,
	 const storage::Btrfs,
	 const storage::Exfat,
	 const storage::Ext2,
	 const storage::Ext3,
	 const storage::Ext4,
	 const storage::Ext,
	 const storage::F2fs,
	 const storage::Iso9660,
	 const storage::Jfs,
	 const storage::Nilfs2,
	 const storage::Ntfs,
	 const storage::Reiserfs,
	 const storage::Swap,
	 const storage::Udf,
	 const storage::Vfat,
	 const storage::Xfs,
	 const storage::BlkFilesystem,
	 const storage::Nfs,
	 const storage::Tmpfs,
	 const storage::Filesystem,
	 const storage::Mountable,
	 const storage::DasdPt,
	 const storage::Gpt,
	 const storage::ImplicitPt,
	 const storage::Msdos,
	 const storage::PartitionTable,
	 const storage::Device)

%factory(storage::Holder* storage::downcast,
	 storage::BtrfsQgroupRelation,
	 storage::Snapshot,
	 storage::MdSubdevice,
	 storage::Subdevice,
	 storage::FilesystemUser,
	 storage::MdUser,
	 storage::User,
	 storage::Holder)

%factory(const storage::Holder* storage::downcast,
	 const storage::BtrfsQgroupRelation,
	 const storage::Snapshot,
	 const storage::MdSubdevice,
	 const storage::Subdevice,
	 const storage::FilesystemUser,
	 const storage::MdUser,
	 const storage::User,
	 const storage::Holder)

%inline %{

    namespace storage
    {

	storage::Device*
	downcast(storage::Device* device)
	{
	    return device;
	}

	const storage::Device*
	downcast(const storage::Device* device)
	{
	    return device;
	}

	storage::Holder*
	downcast(storage::Holder* holder)
	{
	    return holder;
	}

	const storage::Holder*
	downcast(const storage::Holder* holder)
	{
	    return holder;
	}

    }

%}

