/*
 *	udev related utilities
 *
 *	Copyright (C) 2011 SUSE LINUX Products GmbH, Nuernberg, Germany.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *	MA  02110-1301  USA
 *
 *	Authors: Marius Tomaschewski <mt@suse.de>
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	You can find the wicked project at http://gitorious.org/wicked/.
 *
 */
#ifndef __NETCONTROL_UDEV_UTILS_H
#define __NETCONTROL_UDEV_UTILS_H
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <sutils.h>

/**
 * Returns the MAC address that may be (default) used to match specified
 * interface name in the udev persistent interface name rule file.
 * @param ifname	interface name to search for
 * @param hwaddr	pointer to store the mac address int it
 * @return 0 when address were found, 1 when not, -1 on errors.
 */
int			nc_udev_net_rule_hwaddr_for_name(const char *ifname, char **hwaddr);

/**
 * @param bus_id_map	var array with interface name to bus-id mapping
 * @return 0 for no replacement, -1 on errors or > 0 as the number of replacements
 */
int			nc_udev_net_rule_hwaddr_to_bus_id(const nc_var_array_t *bus_id_map);

#endif /* __NETCONTROL_UDEV_UTILS_H */

