---
layout: "docs"
page_title: "State"
sidebar_current: "docs-state"
description: |-
  Terraform must store state about your managed infrastructure and configuration. This state is used by Terraform to map real world resources to your configuration, keep track of metadata, and to improve performance for large infrastructures.
---

# State

Terraform must store state about your managed infrastructure and
configuration. This state is used by Terraform to map real world
resources to your configuration, keep track of metadata, and to improve
performance for large infrastructures.

This state is stored by default in a local file named "terraform.tfstate",
but it can also be stored remotely, which works better in a team environment.

Terraform uses this local state to create plans and make changes to your
infrastructure. Prior to any operation, Terraform does a
[refresh](/docs/commands/refresh.html) to update the state with the
real infrastructure.

The primary purpose of Terraform state is to store bindings between objects in
a remote system and resource instances declared in your configuration.
When Terraform creates a remote object in response to a change of configuration,
it will record the identity of that remote object against a particular
resource instance, and then potentially update or delete that object in
response to future configuration changes.

For more information on why Terraform requires state and why Terraform cannot
function without state, please see the page [state purpose](/docs/state/purpose.html).

## Inspection and Modification

While the format of the state files are just JSON, direct file editing
of the state is discouraged. Terraform provides the
[terraform state](/docs/commands/state/index.html) command to perform
basic modifications of the state using the CLI.

The CLI usage and output of the state commands is structured to be
friendly for Unix tools such as grep, awk, etc. Additionally, the CLI
insulates users from any format changes within the state itself. The Terraform
project will keep the CLI working while the state format underneath it may
shift.

Terraform expects a one-to-one mapping between configured resource instances
and remote objects. Normally that is guaranteed by Terraform being the one
to create each object and record its identity in the state, or to destroy
an object and then remove the binding for it.

If you add or remove bindings in the state by other means, such as by importing
externally-created objects with `terraform import`, or by asking Terraform to
"forget" an existing object with `terraform state rm`, you'll then need to
ensure for yourself that this one-to-one rule is followed, such as by manually
deleting an object that you asked Terraform to "forget", or by re-importing it
to bind it to some other resource instance.

## Format

State snapshots are stored in JSON format and new Terraform versions are
generally backward compatible with state snapshots produced by earlier versions.
However, the state format is subject to change in new Terraform versions, so
if you build software that parses or modifies it directly you should expect
to perform ongoing maintenence of that software as the state format evolves
in new versions.

Alternatively, there are several integration points which produce JSON output
that is specifically intended for consumption by external software:

* [The `terraform output` command](/docs/commands/output.html)
has a `-json` option, for obtaining either the full set of root module output
values or a specific named output value from the latest state snapshot.
* [The `terraform show` command](/docs/commands/show.html) has a `-json`
option for inspecting the latest state snapshot in full, and also for
inspecting saved plan files which include a copy of the prior state at the
time the plan was made.

A typical way to use these in situations where Terraform is running in
automation is to run them immediately after a successful `terraform apply`
to obtain a representation of the latest state snapshot, and then store that
result as an artifact associated with the automated run so that other software
can potentially consume it without needing to run Terraform itself.
