// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    AUTO GENERATED CODE     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"strings"
	"testing"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/resource"
	"github.com/hashicorp/terraform-plugin-sdk/v2/terraform"
)

func TestAccMLEngineModel_mlModelBasicExample(t *testing.T) {
	t.Parallel()

	context := map[string]interface{}{
		"random_suffix": randString(t, 10),
	}

	vcrTest(t, resource.TestCase{
		PreCheck:  func() { testAccPreCheck(t) },
		Providers: testAccProviders,
		ExternalProviders: map[string]resource.ExternalProvider{
			"random": {},
		},
		CheckDestroy: testAccCheckMLEngineModelDestroyProducer(t),
		Steps: []resource.TestStep{
			{
				Config: testAccMLEngineModel_mlModelBasicExample(context),
			},
			{
				ResourceName:      "google_ml_engine_model.default",
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func testAccMLEngineModel_mlModelBasicExample(context map[string]interface{}) string {
	return Nprintf(`
resource "google_ml_engine_model" "default" {
  name        = "default%{random_suffix}"
  description = "My model"
  regions     = ["us-central1"]
}
`, context)
}

func TestAccMLEngineModel_mlModelFullExample(t *testing.T) {
	t.Parallel()

	context := map[string]interface{}{
		"random_suffix": randString(t, 10),
	}

	vcrTest(t, resource.TestCase{
		PreCheck:  func() { testAccPreCheck(t) },
		Providers: testAccProviders,
		ExternalProviders: map[string]resource.ExternalProvider{
			"random": {},
		},
		CheckDestroy: testAccCheckMLEngineModelDestroyProducer(t),
		Steps: []resource.TestStep{
			{
				Config: testAccMLEngineModel_mlModelFullExample(context),
			},
			{
				ResourceName:      "google_ml_engine_model.default",
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func testAccMLEngineModel_mlModelFullExample(context map[string]interface{}) string {
	return Nprintf(`
resource "google_ml_engine_model" "default" {
  name        = "default%{random_suffix}"
  description = "My model"
  regions     = ["us-central1"]
  labels = {
    my_model = "foo"
  }
  online_prediction_logging         = true
  online_prediction_console_logging = true
}
`, context)
}

func testAccCheckMLEngineModelDestroyProducer(t *testing.T) func(s *terraform.State) error {
	return func(s *terraform.State) error {
		for name, rs := range s.RootModule().Resources {
			if rs.Type != "google_ml_engine_model" {
				continue
			}
			if strings.HasPrefix(name, "data.") {
				continue
			}

			config := googleProviderConfig(t)

			url, err := replaceVarsForTest(config, rs, "{{MLEngineBasePath}}projects/{{project}}/models/{{name}}")
			if err != nil {
				return err
			}

			_, err = sendRequest(config, "GET", "", url, config.userAgent, nil)
			if err == nil {
				return fmt.Errorf("MLEngineModel still exists at %s", url)
			}
		}

		return nil
	}
}
