// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    AUTO GENERATED CODE     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"testing"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/resource"
)

func TestAccStorageBucketIamBindingGenerated(t *testing.T) {
	t.Parallel()

	context := map[string]interface{}{
		"random_suffix": randString(t, 10),
		"role":          "roles/storage.objectViewer",
		"admin_role":    "roles/storage.admin",
	}

	vcrTest(t, resource.TestCase{
		PreCheck:  func() { testAccPreCheck(t) },
		Providers: testAccProviders,
		Steps: []resource.TestStep{
			{
				Config: testAccStorageBucketIamBinding_basicGenerated(context),
			},
			{
				ResourceName:      "google_storage_bucket_iam_binding.foo",
				ImportStateId:     fmt.Sprintf("b/%s roles/storage.objectViewer", fmt.Sprintf("tf-test-my-bucket%s", context["random_suffix"])),
				ImportState:       true,
				ImportStateVerify: true,
			},
			{
				// Test Iam Binding update
				Config: testAccStorageBucketIamBinding_updateGenerated(context),
			},
			{
				ResourceName:      "google_storage_bucket_iam_binding.foo",
				ImportStateId:     fmt.Sprintf("b/%s roles/storage.objectViewer", fmt.Sprintf("tf-test-my-bucket%s", context["random_suffix"])),
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func TestAccStorageBucketIamMemberGenerated(t *testing.T) {
	t.Parallel()

	context := map[string]interface{}{
		"random_suffix": randString(t, 10),
		"role":          "roles/storage.objectViewer",
		"admin_role":    "roles/storage.admin",
	}

	vcrTest(t, resource.TestCase{
		PreCheck:  func() { testAccPreCheck(t) },
		Providers: testAccProviders,
		Steps: []resource.TestStep{
			{
				// Test Iam Member creation (no update for member, no need to test)
				Config: testAccStorageBucketIamMember_basicGenerated(context),
			},
			{
				ResourceName:      "google_storage_bucket_iam_member.foo",
				ImportStateId:     fmt.Sprintf("b/%s roles/storage.objectViewer user:admin@hashicorptest.com", fmt.Sprintf("tf-test-my-bucket%s", context["random_suffix"])),
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func TestAccStorageBucketIamPolicyGenerated(t *testing.T) {
	t.Parallel()

	// This may skip test, so do it first
	sa := getTestServiceAccountFromEnv(t)
	context := map[string]interface{}{
		"random_suffix": randString(t, 10),
		"role":          "roles/storage.objectViewer",
		"admin_role":    "roles/storage.admin",
	}
	context["service_account"] = sa

	vcrTest(t, resource.TestCase{
		PreCheck:  func() { testAccPreCheck(t) },
		Providers: testAccProviders,
		Steps: []resource.TestStep{
			{
				Config: testAccStorageBucketIamPolicy_basicGenerated(context),
			},
			{
				ResourceName:      "google_storage_bucket_iam_policy.foo",
				ImportStateId:     fmt.Sprintf("b/%s", fmt.Sprintf("tf-test-my-bucket%s", context["random_suffix"])),
				ImportState:       true,
				ImportStateVerify: true,
			},
			{
				Config: testAccStorageBucketIamPolicy_emptyBinding(context),
			},
			{
				ResourceName:      "google_storage_bucket_iam_policy.foo",
				ImportStateId:     fmt.Sprintf("b/%s", fmt.Sprintf("tf-test-my-bucket%s", context["random_suffix"])),
				ImportState:       true,
				ImportStateVerify: true,
			},
		},
	})
}

func testAccStorageBucketIamMember_basicGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_storage_bucket" "default" {
  name               = "tf-test-my-bucket%{random_suffix}"
  bucket_policy_only = true
}

resource "google_storage_bucket_iam_member" "foo" {
  bucket = google_storage_bucket.default.name
  role = "%{role}"
  member = "user:admin@hashicorptest.com"
}
`, context)
}

func testAccStorageBucketIamPolicy_basicGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_storage_bucket" "default" {
  name               = "tf-test-my-bucket%{random_suffix}"
  bucket_policy_only = true
}

data "google_iam_policy" "foo" {
  binding {
    role = "%{role}"
    members = ["user:admin@hashicorptest.com"]
  }
  binding {
    role = "%{admin_role}"
    members = ["serviceAccount:%{service_account}"]
  }
}

resource "google_storage_bucket_iam_policy" "foo" {
  bucket = google_storage_bucket.default.name
  policy_data = data.google_iam_policy.foo.policy_data
}
`, context)
}

func testAccStorageBucketIamPolicy_emptyBinding(context map[string]interface{}) string {
	return Nprintf(`
resource "google_storage_bucket" "default" {
  name               = "tf-test-my-bucket%{random_suffix}"
  bucket_policy_only = true
}

data "google_iam_policy" "foo" {
}

resource "google_storage_bucket_iam_policy" "foo" {
  bucket = google_storage_bucket.default.name
  policy_data = data.google_iam_policy.foo.policy_data
}
`, context)
}

func testAccStorageBucketIamBinding_basicGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_storage_bucket" "default" {
  name               = "tf-test-my-bucket%{random_suffix}"
  bucket_policy_only = true
}

resource "google_storage_bucket_iam_binding" "foo" {
  bucket = google_storage_bucket.default.name
  role = "%{role}"
  members = ["user:admin@hashicorptest.com"]
}
`, context)
}

func testAccStorageBucketIamBinding_updateGenerated(context map[string]interface{}) string {
	return Nprintf(`
resource "google_storage_bucket" "default" {
  name               = "tf-test-my-bucket%{random_suffix}"
  bucket_policy_only = true
}

resource "google_storage_bucket_iam_binding" "foo" {
  bucket = google_storage_bucket.default.name
  role = "%{role}"
  members = ["user:admin@hashicorptest.com", "user:paddy@hashicorp.com"]
}
`, context)
}
